/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.wizards.newresource.BasicNewFileResourceWizard;

public class CreateFileAction
extends SelectionListenerAction {
    public static final String ID = "org.eclipse.ui.CreateFileAction";
    protected IShellProvider shellProvider;

    public CreateFileAction(final Shell shell) {
        super(IDEWorkbenchMessages.CreateFileAction_text);
        Assert.isNotNull((Object)shell);
        this.shellProvider = new IShellProvider(){

            public Shell getShell() {
                return shell;
            }
        };
        this.initAction();
    }

    public CreateFileAction(IShellProvider provider) {
        super(IDEWorkbenchMessages.CreateFileAction_toolTip);
        Assert.isNotNull((Object)provider);
        this.shellProvider = provider;
        this.initAction();
    }

    private void initAction() {
        this.setToolTipText(IDEWorkbenchMessages.CreateFileAction_toolTip);
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FILE"));
        this.setId(ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.create_file_action_context");
    }

    public void run() {
        BasicNewFileResourceWizard wizard = new BasicNewFileResourceWizard();
        wizard.init(PlatformUI.getWorkbench(), this.getStructuredSelection());
        wizard.setNeedsProgressMonitor(true);
        WizardDialog dialog = new WizardDialog(this.shellProvider.getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setText(IDEWorkbenchMessages.CreateFileAction_title);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.ui.ide.new_file_wizard_context");
        dialog.open();
    }

    protected boolean updateSelection(IStructuredSelection s) {
        if (!super.updateSelection(s)) {
            return false;
        }
        for (IResource resource : this.getSelectedResources()) {
            if (this.resourceIsType(resource, 6) && resource.isAccessible()) continue;
            return false;
        }
        return true;
    }
}

