/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CPPASTDoStatement
extends ASTAttributeOwner
implements IASTDoStatement,
IASTAmbiguityParent {
    private IASTStatement body;
    private IASTExpression condition;

    public CPPASTDoStatement() {
    }

    public CPPASTDoStatement(IASTStatement body, IASTExpression condition) {
        this.setBody(body);
        this.setCondition(condition);
    }

    @Override
    public CPPASTDoStatement copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTDoStatement copy(IASTNode.CopyStyle style) {
        CPPASTDoStatement copy = new CPPASTDoStatement();
        copy.setBody(this.body == null ? null : this.body.copy(style));
        copy.setCondition(this.condition == null ? null : this.condition.copy(style));
        return this.copy(copy, style);
    }

    @Override
    public IASTStatement getBody() {
        return this.body;
    }

    @Override
    public void setBody(IASTStatement body) {
        this.assertNotFrozen();
        this.body = body;
        if (body != null) {
            body.setParent(this);
            body.setPropertyInParent(BODY);
        }
    }

    @Override
    public IASTExpression getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(IASTExpression condition) {
        this.assertNotFrozen();
        this.condition = condition;
        if (condition != null) {
            condition.setParent(this);
            condition.setPropertyInParent(CONDITION);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitStatements) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.body != null && !this.body.accept(action)) {
            return false;
        }
        if (this.condition != null && !this.condition.accept(action)) {
            return false;
        }
        if (action.shouldVisitStatements) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.body == child) {
            other.setPropertyInParent(this.body.getPropertyInParent());
            other.setParent(this.body.getParent());
            this.body = (IASTStatement)other;
        }
        if (child == this.condition) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.condition = (IASTExpression)other;
        }
    }
}

