/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.errorparsers;

import java.util.regex.Matcher;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.errorparsers.AbstractErrorParser;
import org.eclipse.cdt.core.errorparsers.ErrorPattern;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CWDLocator
extends AbstractErrorParser {
    private static boolean enabled = true;
    private static final ErrorPattern[] patterns = new ErrorPattern[]{new ErrorPattern("^\\w*make.*\\s((-j)|(--jobs=))(\\s*\\d*)", 0, 0){

        @Override
        protected boolean recordError(Matcher matcher, ErrorParserManager eoParser) {
            String jobs = matcher.group(4).trim();
            if (!jobs.equals("1")) {
                enabled = false;
                int parseLevel = eoParser.getDirectoryLevel();
                int level = 0;
                while (level < parseLevel) {
                    eoParser.popDirectoryURI();
                    ++level;
                }
            }
            return false;
        }
    }, new ErrorPattern("make\\[(.*)\\]: Entering directory `(.*)'", 0, 0){

        @Override
        protected boolean recordError(Matcher matcher, ErrorParserManager eoParser) {
            int level;
            try {
                level = Integer.valueOf(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                level = 0;
            }
            String dir = matcher.group(2);
            int parseLevel = eoParser.getDirectoryLevel();
            while (level < parseLevel) {
                eoParser.popDirectoryURI();
                ++level;
            }
            eoParser.pushDirectory((IPath)new Path(dir));
            return true;
        }
    }, new ErrorPattern("make: Entering directory `(.*)'", 0, 0){

        @Override
        protected boolean recordError(Matcher matcher, ErrorParserManager eoParser) {
            String dir = matcher.group(1);
            eoParser.pushDirectory((IPath)new Path(dir));
            return true;
        }
    }, new ErrorPattern("make(\\[.*\\])?: Leaving directory", 0, 0){

        @Override
        protected boolean recordError(Matcher matcher, ErrorParserManager eoParser) {
            eoParser.popDirectoryURI();
            return true;
        }
    }};

    @Override
    public boolean processLine(String line, ErrorParserManager manager) {
        int lineNumber = manager.getLineCounter();
        if (lineNumber == 1) {
            enabled = true;
        }
        if (enabled) {
            return super.processLine(line, manager);
        }
        return false;
    }

    public CWDLocator() {
        super(patterns);
        enabled = true;
    }
}

