/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "OpenDRIM_BIOSPasswordAccess.h"

const string instanceID = "OpenDRIM:BIOSPassword:BIOS";
vector<bios_information> bios;
vector< vector<string> > dmi_strings;

int BIOS_OpenDRIM_BIOSPassword_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	SMBIOS_getBIOSInformation(bios,dmi_strings,errorMessage);
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSPassword_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSPassword_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_BIOSPassword>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	for(unsigned int i=0;i<bios.size();i++)
	{
		OpenDRIM_BIOSPassword instance;
		char buffer[256];
		
		sprintf(buffer,"%u",i+1);
		
		instance.setInstanceID(instanceID+buffer);
	
		if (discriminant == "ei")
			CF_assert(BIOS_OpenDRIM_BIOSPassword_populate(instance, i, errorMessage));
	
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSPassword_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_BIOSPassword& instance, const char** properties, string& errorMessage) {
	_E_;
	unsigned int num=atoi(instance.InstanceID.substr(26).c_str());
	char buffer[256];
	
	sprintf(buffer,"%u",num);
	num--;
	
	if(num < 0 || num >= bios.size() || instance.InstanceID.substr(0,26) != instanceID)
	{
		errorMessage = "No instance";
		return NOT_FOUND;
	}
	
	CF_assert(BIOS_OpenDRIM_BIOSPassword_populate(instance,num,errorMessage));
	_L_;
	return OK;
}

int BIOS_OpenDRIM_BIOSPassword_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSPassword& newInstance, const OpenDRIM_BIOSPassword& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSPassword_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSPassword& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSPassword_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_BIOSPassword& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int BIOS_OpenDRIM_BIOSPassword_populate(OpenDRIM_BIOSPassword& instance, unsigned int num, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 + Mandatory inherited from BIOSAttribute:
	 * [X] InstanceID     [KEY]
	 * [X] AttributeName
	 * [X] IsReadOnly
	 * + Mandatory:
	 * [X] IsSet
	 * [X] MinLength
	 * [X] MaxLength
	 * [X] CurrentValue
	 * [X] PendingValue
	 */
	
	uint8_t cmos[CMOS_MAX_SIZE];
	
	memset(cmos, 0, sizeof(cmos));
	
	CF_assert(CF_loadCMOS(cmos,CMOS_SIZE,errorMessage));
	
	// FIXME: Need to be improved
	switch(CF_getBIOSManufacturer(dmi_strings[num][bios[num].vendor]))
	{
		case PHOENIX:
		case AWARD:
			if(atof(dmi_strings[num][bios[num].bios_version].c_str())==4.50f) instance.setIsSet(cmos[0x5E]&1);
			else if(atof(dmi_strings[num][bios[num].bios_version].c_str())==4.51f) instance.setIsSet(cmos[0x62]&1);
			else instance.setIsSet((cmos[0x11]&2)>>1);
			instance.setMinLength(1);
			instance.setMaxLength(8);
			break;
		case ACER:
		case COMPAQ:
		case DTK:
		case IBM:
		case PACKARD_BELL:
		case GATEWAY_PHOENIX:
		case SAMSUNG:
		case SONY:
		case TOSHIBA:
		case ZENITH_AMI:
		case AMI:
		default:
			instance.setIsSet((cmos[0x34]&64)>>6);
			instance.setMinLength(1);
			instance.setMaxLength(0x3D-0x38);
			break;
	}
	
	instance.setIsReadOnly(true);
	instance.setAttributeName("DMTF:BIOS Password");
	_L_;
	return OK;
}

