/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_SSHCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_SSHCONFORMSTOPROFILEACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_SSHConformsToProfile.h"
#include "assocOpenDRIM_SSHConformsToProfile.h"

int SSH_OpenDRIM_SSHConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_SSHConformsToProfile_unload(string& errorMessage);

int SSH_OpenDRIM_SSHConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHConformsToProfile& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHConformsToProfile& newInstance, const OpenDRIM_SSHConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_SSHConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHConformsToProfile& instance, string& errorMessage);

int SSH_OpenDRIM_SSHConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHConformsToProfile& instance, string& errorMessage);

int SSH_OpenDRIM_SSHConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_SSHConformsToProfile>& OpenDRIM_SSHConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_SSHConformsToProfile>& OpenDRIM_SSHConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_SSHConformsToProfile_populate(OpenDRIM_SSHConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_SSHCONFORMSTOPROFILEACCESS_H_*/
