/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.i18n;

import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.util.CookieGenerator;
import org.springframework.web.util.WebUtils;

public class CookieLocaleResolver
extends CookieGenerator
implements LocaleResolver {
    public static final String LOCALE_REQUEST_ATTRIBUTE_NAME = CookieLocaleResolver.class.getName() + ".LOCALE";
    public static final String DEFAULT_COOKIE_NAME = CookieLocaleResolver.class.getName() + ".LOCALE";
    private Locale defaultLocale;

    public CookieLocaleResolver() {
        this.setCookieName(DEFAULT_COOKIE_NAME);
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    protected Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public Locale resolveLocale(HttpServletRequest request) {
        Locale locale = (Locale)request.getAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME);
        if (locale != null) {
            return locale;
        }
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)this.getCookieName());
        if (cookie != null) {
            locale = StringUtils.parseLocaleString((String)cookie.getValue());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Parsed cookie value [" + cookie.getValue() + "] into locale '" + locale + "'"));
            }
            if (locale != null) {
                request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
                return locale;
            }
        }
        return this.determineDefaultLocale(request);
    }

    public void setLocale(HttpServletRequest request, HttpServletResponse response, Locale locale) {
        if (locale != null) {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)locale);
            this.addCookie(response, locale.toString());
        } else {
            request.setAttribute(LOCALE_REQUEST_ATTRIBUTE_NAME, (Object)this.determineDefaultLocale(request));
            this.removeCookie(response);
        }
    }

    protected Locale determineDefaultLocale(HttpServletRequest request) {
        Locale defaultLocale = this.getDefaultLocale();
        if (defaultLocale == null) {
            defaultLocale = request.getLocale();
        }
        return defaultLocale;
    }
}

