#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Marie's Room
# send your bug reports to contact@dotslashplay.it
###

script_version=20241107.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='maries-room'
GAME_NAME='Marie’s Room'

ARCHIVE_BASE_0_NAME='MariesRoom.zip'
ARCHIVE_BASE_0_MD5='4c7375a2fcf5bdd49405f4ddd9ce5770'
ARCHIVE_BASE_0_SIZE='1000000'
ARCHIVE_BASE_0_VERSION='1.0-itch.2018.05.17'
ARCHIVE_BASE_0_URL='https://kennyguillaume.itch.io/maries-room'

UNREALENGINE4_NAME='MariesRoom'

CONTENT_PATH_DEFAULT='MariesRoom/MariesRoom_Game_x64'

APP_MAIN_EXE="${UNREALENGINE4_NAME}/Binaries/Win64/${UNREALENGINE4_NAME}-Win64-Shipping.exe"
## The --name=101 wrestool option, default for UE4 games, should not be used here
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
