#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Warm
# send your bug reports to contact@dotslashplay.it
###

script_version=20240915.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='warm'
GAME_NAME='Warm'

ARCHIVE_BASE_0_NAME='Warm-Full-pc.zip'
ARCHIVE_BASE_0_MD5='55f19b7d105d1e929edfba0e5e853538'
ARCHIVE_BASE_0_SIZE='670000'
ARCHIVE_BASE_0_VERSION='1.02-itch'
ARCHIVE_BASE_0_URL='https://krispycat.itch.io/warm'

CONTENT_PATH_DEFAULT='Warm-Full-pc/game'
CONTENT_GAME_MAIN_FILES='
cache
gui
images
Music
script_version.txt
*.rpy
*.rpyc'

APP_MAIN_TYPE='renpy'

## Ensure easy upgrades from packages generated with pre-20240915.2 game scripts
PKG_MAIN_PROVIDES="${PKG_MAIN_PROVIDES:=}
warm-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	# Remove unexpected indentation in a Python script, to prevent a crash on launch
	sed --in-place 's/^ \{4\}//' 'script.rpy'
)

# Include game data

content_inclusion_default

# Write launchers

## Use the default Ren'Py icon, instead of a generic icon.
desktop_field_icon() {
	printf 'renpy'
}
launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
