#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
set -o errexit

###
# Touhou 12
# send your bug reports to contact@dotslashplay.it
###

script_version=20231130.2

GAME_ID='touhou-12-demo'
GAME_NAME='Touhou Seirensen ~ Undefined Fantastic Object (demo)'

SCRIPT_DEPS='iconv'

ARCHIVE_ZUN='th12tr002a_setup.exe'
ARCHIVE_ZUN_MD5='61a77c94c2ef64d7afda477dda0594eb'
ARCHIVE_ZUN_TYPE='innosetup'
ARCHIVE_ZUN_SIZE='151620'
ARCHIVE_ZUN_VERSION='0.02a-zun1'
ARCHIVE_ZUN_URL='http://www16.big.or.jp/~zun/html/th12dl.html'

ARCHIVE_DOC_DATA_PATH='app'
ARCHIVE_DOC_DATA_FILES='*.txt index.html html'

ARCHIVE_GAME_BIN_PATH='app'
ARCHIVE_GAME_BIN_FILES='*.exe'

ARCHIVE_GAME_DATA_PATH='app'
ARCHIVE_GAME_DATA_FILES='*.dat'

# Store saved games and settings outside of WINE prefix
CONFIG_FILES='./th12.cfg'
DATA_FILES='./log.txt ./score.dat'
DATA_DIRS='./replay'

APP_MAIN_TYPE='wine'
APP_MAIN_PRERUN='export LANG=ja_JP.UTF-8'
APP_MAIN_EXE='th12.exe'
APP_MAIN_ICON='th12.exe'

APP_CONFIG_ID="${GAME_ID}_config"
APP_CONFIG_TYPE='wine'
APP_CONFIG_PRERUN='export LANG=ja_JP.UTF-8'
APP_CONFIG_EXE='custom.exe'
APP_CONFIG_ICON='custom.exe'
APP_CONFIG_NAME="$GAME_NAME - configuration"
APP_CONFIG_CAT='Settings'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine glx"
PKG_BIN_DEPS_DEB='fonts-wqy-microhei'
PKG_BIN_DEPS_ARCH='wqy-microhei'
PKG_BIN_DEPS_GENTOO='media-fonts/wqy-microhei'

# Load common functions

target_version='2.12'

if [ -z "$PLAYIT_LIB2" ]; then
	: "${XDG_DATA_HOME:="$HOME/.local/share"}"
	for path in\
		"$PWD"\
		"$XDG_DATA_HOME/play.it"\
		'/usr/local/share/games/play.it'\
		'/usr/local/share/play.it'\
		'/usr/share/games/play.it'\
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
#shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"

# Convert the text files to UTF-8 encoding

find "$PLAYIT_WORKDIR" \( -name '*.txt' -o -name '*.html' \) -exec \
	sh -c 'contents=$(iconv --from-code CP932 --to-code UTF-8 "$1"); printf "%s" "$contents" > "$1"' -- '{}' \;

prepare_package_layout

# Extract game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN' 'APP_CONFIG'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN' 'APP_CONFIG'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
