#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2017 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Tri: Of Friendship and Madness
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250511.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='tri-of-friendship-and-madness'
GAME_NAME='TRI: Of Friendship and Madness'

ARCHIVE_BASE_2_NAME='tri_of_friendship_and_madness_1_2_1_stunnedfox_56365.sh'
ARCHIVE_BASE_2_MD5='7daf33ea8d0e13fc9d5988bc02e8d1d3'
ARCHIVE_BASE_2_SIZE='470002'
ARCHIVE_BASE_2_VERSION='1.2.1-gog56365'
ARCHIVE_BASE_2_URL='https://www.gog.com/game/tri'

ARCHIVE_BASE_1_NAME='tri_of_friendship_and_madness_1_2_30878.sh'
ARCHIVE_BASE_1_MD5='3240ccae6723c2fdba20910246a4c068'
ARCHIVE_BASE_1_SIZE='480000'
ARCHIVE_BASE_1_VERSION='1.2-gog30878'

ARCHIVE_BASE_0_NAME='gog_tri_2.6.0.9.sh'
ARCHIVE_BASE_0_MD5='c2bf151b58766740e52db9559d61e3d6'
ARCHIVE_BASE_0_SIZE='470000'
ARCHIVE_BASE_0_VERSION='1.2-gog2.6.0.9'

UNITY3D_NAME='tri'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_DOC_DATA_FILES='
versions.txt'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libGLU.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
## Easier upgrades from pre-20250511.2 packages
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
tri-of-friendship-of-madness"
PKG_BIN64_PROVIDES="$PKG_BIN_PROVIDES"
PKG_BIN32_PROVIDES="$PKG_BIN_PROVIDES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20250511.2 packages
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
tri-of-friendship-of-madness-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build package

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
