/**
 * X-macro list of all the object flags.
 *
 * Parameters:
 *
 * - e_name: name of the flag in the edit files.
 * - c_name: name of the flag on the character sheet
 *           (10 characters max). If nullptrptr the
 *           flag doesn't appear and the other c_*
 *           values are ignored.
 * - c_page: page on the character sheet (0-3).
 * - c_col:  column number on the character sheet (0-1).
 * - c_row:  row number on the character sheet (0-15).
 * - c_type: type of the character sheet; either
 *             NUMERIC, BINARY or TERNARY(n).
 * - c_prio: priority if the flag overlaps another flag
 *           on the character sheet. 0 is lowes priority.
 * - is_pval: true iff the flag _description_ depends on PVAL.
 * - is_esp: true iff the flag affects ESP.
 */

/* TR(<tier>, <index>, <name>, <e_name>, <c_name>, <c_page>, <c_col>, <c_row>, <c_type>, <c_prio>, <is_pval>, <is_esp>) */

TR(1,  0, TR_STR                , STR                , "Add Str"   ,  0,  0,  0, NUMERIC   , 0, true , false)
TR(1,  1, TR_INT                , INT                , "Add Int"   ,  0,  0,  1, NUMERIC   , 0, true , false)
TR(1,  2, TR_WIS                , WIS                , "Add Wis"   ,  0,  0,  2, NUMERIC   , 0, true , false)
TR(1,  3, TR_DEX                , DEX                , "Add Dex"   ,  0,  0,  3, NUMERIC   , 0, true , false)
TR(1,  4, TR_CON                , CON                , "Add Con"   ,  0,  0,  4, NUMERIC   , 0, true , false)
TR(1,  5, TR_CHR                , CHR                , "Add Chr"   ,  0,  0,  5, NUMERIC   , 0, true , false)
TR(1,  6, TR_MANA               , MANA               , "Mul Mana"  ,  0,  0,  6, BINARY    , 0, false, false)
TR(1,  7, TR_SPELL              , SPELL              , "Mul SPower",  0,  0,  7, BINARY    , 0, true , false)
TR(1,  8, TR_STEALTH            , STEALTH            , "Add Stea." ,  0,  0,  8, NUMERIC   , 0, true , false)
TR(1, 10, TR_INFRA              , INFRA              , "Add Infra" ,  0,  0,  9, NUMERIC   , 0, true , false)
TR(1, 11, TR_TUNNEL             , TUNNEL             , "Add Tun.." ,  0,  0, 10, NUMERIC   , 0, true , false)
TR(1, 12, TR_SPEED              , SPEED              , "Add Speed" ,  0,  0, 11, NUMERIC   , 0, true , false)
TR(1, 13, TR_BLOWS              , BLOWS              , "Add Blows" ,  0,  0, 12, NUMERIC   , 0, true , false)
TR(1, 14, TR_CHAOTIC            , CHAOTIC            , "Chaotic"   ,  0,  0, 13, BINARY    , 0, false, false)
TR(1, 15, TR_VAMPIRIC           , VAMPIRIC           , "Vampiric"  ,  0,  0, 14, BINARY    , 0, false, false)
TR(1, 16, TR_SLAY_ANIMAL        , SLAY_ANIMAL        , "Slay Anim.",  0,  1,  0, BINARY    , 0, false, false)
TR(1, 17, TR_SLAY_EVIL          , SLAY_EVIL          , "Slay Evil" ,  0,  1,  1, BINARY    , 0, false, false)
TR(1, 18, TR_SLAY_UNDEAD        , SLAY_UNDEAD        , "Slay Und." ,  0,  1,  2, BINARY    , 0, false, false)
TR(1, 19, TR_SLAY_DEMON         , SLAY_DEMON         , "Slay Demon",  0,  1,  3, BINARY    , 0, false, false)
TR(1, 20, TR_SLAY_ORC           , SLAY_ORC           , "Slay Orc"  ,  0,  1,  4, BINARY    , 0, false, false)
TR(1, 21, TR_SLAY_TROLL         , SLAY_TROLL         , "Slay Troll",  0,  1,  5, BINARY    , 0, false, false)
TR(1, 22, TR_SLAY_GIANT         , SLAY_GIANT         , "Slay Giant",  0,  1,  6, BINARY    , 0, false, false)
TR(1, 23, TR_SLAY_DRAGON        , SLAY_DRAGON        , "Slay Drag.",  0,  1,  7, BINARY    , 0, false, false)
TR(1, 24, TR_KILL_DRAGON        , KILL_DRAGON        , "Kill Drag.",  0,  1,  8, BINARY    , 0, false, false)
TR(1, 25, TR_VORPAL             , VORPAL             , "Sharpness" ,  0,  1,  9, BINARY    , 0, false, false)
TR(1, 26, TR_IMPACT             , IMPACT             , "Impact"    ,  0,  1, 10, BINARY    , 0, false, false)
TR(1, 27, TR_BRAND_POIS         , BRAND_POIS         , "Poison Brd",  0,  1, 11, BINARY    , 0, false, false)
TR(1, 28, TR_BRAND_ACID         , BRAND_ACID         , "Acid Brand",  0,  1, 12, BINARY    , 0, false, false)
TR(1, 29, TR_BRAND_ELEC         , BRAND_ELEC         , "Elec Brand",  0,  1, 13, BINARY    , 0, false, false)
TR(1, 30, TR_BRAND_FIRE         , BRAND_FIRE         , "Fire Brand",  0,  1, 14, BINARY    , 0, false, false)
TR(1, 31, TR_BRAND_COLD         , BRAND_COLD         , "Cold Brand",  0,  1, 15, BINARY    , 0, false, false)

TR(2,  0, TR_SUST_STR           , SUST_STR           , "Sust Str"  ,  1,  0,  0, BINARY    , 0, false, false)
TR(2,  1, TR_SUST_INT           , SUST_INT           , "Sust Int"  ,  1,  0,  1, BINARY    , 0, false, false)
TR(2,  2, TR_SUST_WIS           , SUST_WIS           , "Sust Wis"  ,  1,  0,  2, BINARY    , 0, false, false)
TR(2,  3, TR_SUST_DEX           , SUST_DEX           , "Sust Dex"  ,  1,  0,  3, BINARY    , 0, false, false)
TR(2,  4, TR_SUST_CON           , SUST_CON           , "Sust Con"  ,  1,  0,  4, BINARY    , 0, false, false)
TR(2,  5, TR_SUST_CHR           , SUST_CHR           , "Sust Chr"  ,  1,  0,  5, BINARY    , 0, false, false)
TR(2,  6, TR_INVIS              , INVIS              , "Invisible" ,  1,  0,  6, BINARY    , 0, false, false)
TR(2,  7, TR_LIFE               , LIFE               , "Mul life"  ,  1,  0,  7, BINARY    , 0, false, false)
TR(2,  8, TR_IM_ACID            , IM_ACID            , "Imm Acid"  ,  1,  1,  0, TERNARY(2), 1, false, false)
TR(2,  9, TR_IM_ELEC            , IM_ELEC            , "Imm Elec"  ,  1,  1,  1, TERNARY(2), 1, false, false)
TR(2, 10, TR_IM_FIRE            , IM_FIRE            , "Imm Fire"  ,  1,  1,  2, TERNARY(2), 1, false, false)
TR(2, 11, TR_IM_COLD            , IM_COLD            , "Imm Cold"  ,  1,  1,  3, TERNARY(2), 1, false, false)
TR(2, 12, TR_SENS_FIRE          , SENS_FIRE          , "Sens Fire" ,  1,  0, 12, BINARY    , 0, false, false)
TR(2, 13, TR_REFLECT            , REFLECT            , "Reflect"   ,  1,  0, 13, BINARY    , 0, false, false)
TR(2, 14, TR_FREE_ACT           , FREE_ACT           , "Free Act"  ,  1,  0, 14, BINARY    , 0, false, false)
TR(2, 15, TR_HOLD_LIFE          , HOLD_LIFE          , "Hold Life" ,  1,  0, 15, BINARY    , 0, false, false)
TR(2, 16, TR_RES_ACID           , RES_ACID           , "Res Acid"  ,  1,  1,  0, TERNARY(1), 0, false, false)
TR(2, 17, TR_RES_ELEC           , RES_ELEC           , "Res Elec"  ,  1,  1,  1, TERNARY(1), 0, false, false)
TR(2, 18, TR_RES_FIRE           , RES_FIRE           , "Res Fire"  ,  1,  1,  2, TERNARY(1), 0, false, false)
TR(2, 19, TR_RES_COLD           , RES_COLD           , "Res Cold"  ,  1,  1,  3, TERNARY(1), 0, false, false)
TR(2, 20, TR_RES_POIS           , RES_POIS           , "Res Pois"  ,  1,  1,  4, BINARY    , 0, false, false)
TR(2, 21, TR_RES_FEAR           , RES_FEAR           , "Res Fear"  ,  1,  1,  5, BINARY    , 0, false, false)
TR(2, 22, TR_RES_LITE           , RES_LITE           , "Res Light" ,  1,  1,  6, BINARY    , 0, false, false)
TR(2, 23, TR_RES_DARK           , RES_DARK           , "Res Dark"  ,  1,  1,  7, BINARY    , 0, false, false)
TR(2, 24, TR_RES_BLIND          , RES_BLIND          , "Res Blind" ,  1,  1,  8, BINARY    , 0, false, false)
TR(2, 25, TR_RES_CONF           , RES_CONF           , "Res Conf"  ,  1,  1,  9, BINARY    , 0, false, false)
TR(2, 26, TR_RES_SOUND          , RES_SOUND          , "Res Sound" ,  1,  1, 10, BINARY    , 0, false, false)
TR(2, 27, TR_RES_SHARDS         , RES_SHARDS         , "Res Shard" ,  1,  1, 11, BINARY    , 0, false, false)
TR(2, 28, TR_RES_NETHER         , RES_NETHER         , "Res Neth"  ,  1,  1, 12, TERNARY(1), 0, false, false)
TR(2, 29, TR_RES_NEXUS          , RES_NEXUS          , "Res Nexus" ,  1,  1, 13, BINARY    , 0, false, false)
TR(2, 30, TR_RES_CHAOS          , RES_CHAOS          , "Res Chaos" ,  1,  1, 14, BINARY    , 0, false, false)
TR(2, 31, TR_RES_DISEN          , RES_DISEN          , "Res Disen" ,  1,  1, 15, BINARY    , 0, false, false)

TR(3,  0, TR_SH_FIRE            , SH_FIRE            , "Aura Fire" ,  2,  0,  0, BINARY    , 0, false, false)
TR(3,  1, TR_SH_ELEC            , SH_ELEC            , "Aura Elec" ,  2,  0,  1, BINARY    , 0, false, false)
TR(3,  2, TR_AUTO_CURSE         , AUTO_CURSE         , "Auto Curse",  2,  0,  2, BINARY    , 0, false, false)
TR(3,  3, TR_DECAY              , DECAY              , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3,  4, TR_NO_TELE            , NO_TELE            , "NoTeleport",  2,  0,  4, BINARY    , 0, false, false)
TR(3,  5, TR_NO_MAGIC           , NO_MAGIC           , "AntiMagic" ,  2,  0,  5, BINARY    , 0, false, false)
TR(3,  6, TR_WRAITH             , WRAITH             , "WraithForm",  2,  0,  6, BINARY    , 0, false, false)
TR(3,  7, TR_TY_CURSE           , TY_CURSE           , "EvilCurse" ,  2,  0,  7, BINARY    , 0, false, false)
TR(3,  8, TR_EASY_KNOW          , EASY_KNOW          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3,  9, TR_HIDE_TYPE          , HIDE_TYPE          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 10, TR_SHOW_MODS          , SHOW_MODS          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 11, TR_INSTA_ART          , INSTA_ART          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 12, TR_FEATHER            , FEATHER            , "Levitate"  ,  2,  0, 12, BINARY    , 0, false, false)
TR(3, 13, TR_LITE1              , LITE1              , "Lite"      ,  2,  0, 13, FIXED(1)  , 0, false, false)
TR(3, 14, TR_SEE_INVIS          , SEE_INVIS          , "See Invis" ,  2,  0, 14, BINARY    , 0, false, false)
TR(3, 15, TR_NORM_ART           , NORM_ART           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 16, TR_SLOW_DIGEST        , SLOW_DIGEST        , "Digestion" ,  2,  1,  0, BINARY    , 0, false, false)
TR(3, 17, TR_REGEN              , REGEN              , "Regen"     ,  2,  1,  1, BINARY    , 0, false, false)
TR(3, 18, TR_XTRA_MIGHT         , XTRA_MIGHT         , "Xtra Might",  2,  1,  2, BINARY    , 0, false, false)
TR(3, 19, TR_XTRA_SHOTS         , XTRA_SHOTS         , "Xtra Shots",  2,  1,  3, BINARY    , 0, false, false)
TR(3, 20, TR_IGNORE_ACID        , IGNORE_ACID        , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 21, TR_IGNORE_ELEC        , IGNORE_ELEC        , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 22, TR_IGNORE_FIRE        , IGNORE_FIRE        , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 23, TR_IGNORE_COLD        , IGNORE_COLD        , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(3, 24, TR_ACTIVATE           , ACTIVATE           , "Activate"  ,  2,  1,  8, BINARY    , 0, false, false)
TR(3, 25, TR_DRAIN_EXP          , DRAIN_EXP          , "Drain Exp" ,  2,  1,  9, BINARY    , 0, false, false)
TR(3, 26, TR_TELEPORT           , TELEPORT           , "Teleport"  ,  2,  1, 10, BINARY    , 0, false, false)
TR(3, 27, TR_AGGRAVATE          , AGGRAVATE          , "Aggravate" ,  2,  1, 11, BINARY    , 0, false, false)
TR(3, 28, TR_BLESSED            , BLESSED            , "Blessed"   ,  2,  1, 12, BINARY    , 0, false, false)
TR(3, 29, TR_CURSED             , CURSED             , "Cursed"    ,  2,  1, 13, BINARY    , 0, false, false)
TR(3, 30, TR_HEAVY_CURSE        , HEAVY_CURSE        , "Hvy Curse" ,  2,  1, 14, BINARY    , 0, false, false)
TR(3, 31, TR_PERMA_CURSE        , PERMA_CURSE        , "Prm Curse" ,  2,  1, 15, BINARY    , 0, false, false)

TR(4,  0, TR_NEVER_BLOW         , NEVER_BLOW         , "No blows"  ,  3,  0,  0, BINARY    , 0, false, false)
TR(4,  1, TR_PRECOGNITION       , PRECOGNITION       , "Precogn."  ,  3,  0,  1, BINARY    , 0, false, false)
TR(4,  2, TR_BLACK_BREATH       , BLACK_BREATH       , "B.Breath"  ,  3,  0,  2, BINARY    , 0, false, false)
TR(4,  3, TR_RECHARGE           , RECHARGE           , "Recharge"  ,  3,  0,  3, BINARY    , 0, false, false)
TR(4,  4, TR_FLY                , FLY                , "Fly"       ,  3,  0,  4, BINARY    , 0, false, false)
TR(4,  5, TR_DG_CURSE           , DG_CURSE           , "Mrg.Curse" ,  3,  0,  5, BINARY    , 0, false, false)
TR(4,  6, TR_COULD2H            , COULD2H            , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4,  7, TR_MUST2H             , MUST2H             , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4,  8, TR_LEVELS             , LEVELS             , "Sentient"  ,  3,  0,  8, BINARY    , 0, false, false)
TR(4,  9, TR_CLONE              , CLONE              , "Clone"     ,  3,  0,  9, BINARY    , 0, false, false)
TR(4, 10, TR_SPECIAL_GENE       , SPECIAL_GENE       , nullptr     ,  3,  0, 10, BINARY    , 0, false, false)
TR(4, 11, TR_CLIMB              , CLIMB              , "Climb"     ,  3,  0, 11, BINARY    , 0, false, false)
TR(4, 12, TR_FAST_CAST          , FAST_CAST          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 13, TR_CAPACITY           , CAPACITY           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 14, TR_CHARGING           , CHARGING           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 15, TR_CHEAPNESS          , CHEAPNESS          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 16, TR_FOUNTAIN           , FOUNTAIN           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 17, TR_ANTIMAGIC_50       , ANTIMAGIC_50       , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 21, TR_EASY_USE           , EASY_USE           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 22, TR_IM_NETHER          , IM_NETHER          , "Imm Neth"  ,  1,  1, 12, TERNARY(2), 1, false, false)
TR(4, 23, TR_RECHARGED          , RECHARGED          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 24, TR_ULTIMATE           , ULTIMATE           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 26, TR_LITE2              , LITE2              , "Lite"      ,  2,  0, 13, FIXED(2)  , 0, false, false)
TR(4, 27, TR_LITE3              , LITE3              , "Lite"      ,  2,  0, 13, FIXED(3)  , 0, false, false)
TR(4, 28, TR_FUEL_LITE          , FUEL_LITE          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 30, TR_CURSE_NO_DROP      , CURSE_NO_DROP      , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(4, 31, TR_NO_RECHARGE        , NO_RECHARGE        , nullptr     , -1, -1, -1, BINARY    , 0, false, false)

TR(5,  0, TR_TEMPORARY          , TEMPORARY          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  1, TR_DRAIN_MANA         , DRAIN_MANA         , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  2, TR_DRAIN_HP           , DRAIN_HP           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  3, TR_KILL_DEMON         , KILL_DEMON         , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  4, TR_KILL_UNDEAD        , KILL_UNDEAD        , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  5, TR_CRIT               , CRIT               , nullptr     , -1, -1, -1, BINARY    , 0, true , false)
TR(5,  6, TR_ATTR_MULTI         , ATTR_MULTI         , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  7, TR_WOUNDING           , WOUNDING           , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  8, TR_FULL_NAME          , FULL_NAME          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5,  9, TR_LUCK               , LUCK               , nullptr     , -1, -1, -1, BINARY    , 0, true , false)
TR(5, 10, TR_IMMOVABLE          , IMMOVABLE          , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 11, TR_SPELL_CONTAIN      , SPELL_CONTAIN      , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 12, TR_RES_MORGUL         , RES_MORGUL         , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 13, TR_ACTIVATE_NO_WIELD  , ACTIVATE_NO_WIELD  , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 14, TR_MAGIC_BREATH       , MAGIC_BREATH       , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 15, TR_WATER_BREATH       , WATER_BREATH       , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 16, TR_WIELD_CAST         , WIELD_CAST         , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 17, TR_RANDOM_RESIST      , RANDOM_RESIST      , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 18, TR_RANDOM_POWER       , RANDOM_POWER       , nullptr     , -1, -1, -1, BINARY    , 0, false, false)
TR(5, 19, TR_RANDOM_RES_OR_POWER, RANDOM_RES_OR_POWER, nullptr     , -1, -1, -1, BINARY    , 0, false, false)

TR(6,  0, ESP_ORC               , ESP_ORC            , "Orc.ESP"   ,  3,  1,  0, BINARY    , 0, false, true )
TR(6,  1, ESP_TROLL             , ESP_TROLL          , "Troll.ESP" ,  3,  1,  1, BINARY    , 0, false, true )
TR(6,  2, ESP_DRAGON            , ESP_DRAGON         , "Dragon.ESP",  3,  1,  2, BINARY    , 0, false, true )
TR(6,  3, ESP_GIANT             , ESP_GIANT          , "Giant.ESP" ,  3,  1,  3, BINARY    , 0, false, true )
TR(6,  4, ESP_DEMON             , ESP_DEMON          , "Demon.ESP" ,  3,  1,  4, BINARY    , 0, false, true )
TR(6,  5, ESP_UNDEAD            , ESP_UNDEAD         , "Undead.ESP",  3,  1,  5, BINARY    , 0, false, true )
TR(6,  6, ESP_EVIL              , ESP_EVIL           , "Evil.ESP"  ,  3,  1,  6, BINARY    , 0, false, true )
TR(6,  7, ESP_ANIMAL            , ESP_ANIMAL         , "Animal.ESP",  3,  1,  7, BINARY    , 0, false, true )
TR(6,  8, ESP_THUNDERLORD       , ESP_THUNDERLORD    , "TLord.ESP" ,  3,  1,  8, BINARY    , 0, false, true )
TR(6,  9, ESP_GOOD              , ESP_GOOD           , "Good.ESP"  ,  3,  1,  9, BINARY    , 0, false, true )
TR(6, 10, ESP_NONLIVING         , ESP_NONLIVING      , "Nlive.ESP" ,  3,  1, 10, BINARY    , 0, false, true )
TR(6, 11, ESP_UNIQUE            , ESP_UNIQUE         , "Unique.ESP",  3,  1, 11, BINARY    , 0, false, true )
TR(6, 12, ESP_SPIDER            , ESP_SPIDER         , "Spider ESP",  3,  1, 12, BINARY    , 0, false, true )
TR(6, 31, ESP_ALL               , ESP_ALL            , "Full ESP"  ,  3,  1, 15, BINARY    , 0, false, true )
