/* $Id: tstIEMAImplDataFpuBinary1-Amd.cpp $ */
/** @file
 * IEM Assembly Instruction Helper Testcase Data Amd - r150740 on AMD Ryzen Threadripper 3990X 64-Core Processor.
 */

/*
 * Copyright (C) 2022-2023 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#include "tstIEMAImpl.h"

FPU_BINARY_R80_TEST_T const g_aTests_fpatan_r80_by_r80_amd[] =
{
    { 0x0000, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/0/0/u */
    { 0x007f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/0/0/c */
    { 0x0100, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/0/1/u */
    { 0x017f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/0/1/c */
    { 0x0200, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/0/2/u */
    { 0x027f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/0/2/c */
    { 0x0300, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/0/3/u */
    { 0x037f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/0/3/c */
    { 0x0400, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/1/0/u */
    { 0x047f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/1/0/c */
    { 0x0500, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/1/1/u */
    { 0x057f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/1/1/c */
    { 0x0600, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/1/2/u */
    { 0x067f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/1/2/c */
    { 0x0700, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/1/3/u */
    { 0x077f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/1/3/c */
    { 0x0800, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/2/0/u */
    { 0x087f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/2/0/c */
    { 0x0900, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/2/1/u */
    { 0x097f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/2/1/c */
    { 0x0a00, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/2/2/u */
    { 0x0a7f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/2/2/c */
    { 0x0b00, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/2/3/u */
    { 0x0b7f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/2/3/c */
    { 0x0c00, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/3/0/u */
    { 0x0c7f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/3/0/c */
    { 0x0d00, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/3/1/u */
    { 0x0d7f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/3/1/c */
    { 0x0e00, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/3/2/u */
    { 0x0e7f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/3/2/c */
    { 0x0f00, 0x9335, 0xb181, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365) }, /* #0/3/3/u */
    { 0x0f7f, 0x9335, 0x3901, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,25694), RTFLOAT80U_INIT_C(1,0x6ec310525cb9de91,12365), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #0/3/3/c */
    { 0x0000, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/0/u */
    { 0x007f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/0/c */
    { 0x0100, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/1/u */
    { 0x017f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/1/c */
    { 0x0200, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/2/u */
    { 0x027f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/2/c */
    { 0x0300, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/3/u */
    { 0x037f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/0/3/c */
    { 0x0400, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/0/u */
    { 0x047f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/0/c */
    { 0x0500, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/1/u */
    { 0x057f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/1/c */
    { 0x0600, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/2/u */
    { 0x067f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/2/c */
    { 0x0700, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/3/u */
    { 0x077f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/1/3/c */
    { 0x0800, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/0/u */
    { 0x087f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/0/c */
    { 0x0900, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/1/u */
    { 0x097f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/1/c */
    { 0x0a00, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/2/u */
    { 0x0a7f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/2/c */
    { 0x0b00, 0xd9c1, 0xfba0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/3/u */
    { 0x0b7f, 0xd9c1, 0x7b20, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #1/2/3/c */
    { 0x0c00, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/0/u */
    { 0x0c7f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/0/c */
    { 0x0d00, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/1/u */
    { 0x0d7f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/1/c */
    { 0x0e00, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/2/u */
    { 0x0e7f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/2/c */
    { 0x0f00, 0xd9c1, 0xf9a0, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/3/u */
    { 0x0f7f, 0xd9c1, 0x7920, RTFLOAT80U_INIT_C(0,0x96772e18526d8dc7,13613), RTFLOAT80U_INIT_C(1,0x96fc777ca21fd1a4,6785), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #1/3/3/c */
    { 0x0000, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/0/0/u */
    { 0x007f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/0/c */
    { 0x0100, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/0/1/u */
    { 0x017f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/1/c */
    { 0x0200, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/0/2/u */
    { 0x027f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/2/c */
    { 0x0300, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/0/3/u */
    { 0x037f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/0/3/c */
    { 0x0400, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/1/0/u */
    { 0x047f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/0/c */
    { 0x0500, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/1/1/u */
    { 0x057f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/1/c */
    { 0x0600, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/1/2/u */
    { 0x067f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/2/c */
    { 0x0700, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/1/3/u */
    { 0x077f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/1/3/c */
    { 0x0800, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/2/0/u */
    { 0x087f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/0/c */
    { 0x0900, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/2/1/u */
    { 0x097f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/1/c */
    { 0x0a00, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/2/2/u */
    { 0x0a7f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/2/c */
    { 0x0b00, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/2/3/u */
    { 0x0b7f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/2/3/c */
    { 0x0c00, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/3/0/u */
    { 0x0c7f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/0/c */
    { 0x0d00, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/3/1/u */
    { 0x0d7f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/1/c */
    { 0x0e00, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/3/2/u */
    { 0x0e7f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/2/c */
    { 0x0f00, 0x6da6, 0xf581, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725) }, /* #2/3/3/u */
    { 0x0f7f, 0x6da6, 0x7d01, RTFLOAT80U_INIT_C(0,0x8000000045e1a70d,0), RTFLOAT80U_INIT_C(1,0x1c8c0dc72bcded24,4725), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #2/3/3/c */
    { 0x0000, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/0/0/u */
    { 0x007f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/0/0/c */
    { 0x0100, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/0/1/u */
    { 0x017f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/0/1/c */
    { 0x0200, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/0/2/u */
    { 0x027f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/0/2/c */
    { 0x0300, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/0/3/u */
    { 0x037f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/0/3/c */
    { 0x0400, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/1/0/u */
    { 0x047f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/1/0/c */
    { 0x0500, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/1/1/u */
    { 0x057f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/1/1/c */
    { 0x0600, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/1/2/u */
    { 0x067f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/1/2/c */
    { 0x0700, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/1/3/u */
    { 0x077f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/1/3/c */
    { 0x0800, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/2/0/u */
    { 0x087f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/2/0/c */
    { 0x0900, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/2/1/u */
    { 0x097f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/2/1/c */
    { 0x0a00, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/2/2/u */
    { 0x0a7f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/2/2/c */
    { 0x0b00, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/2/3/u */
    { 0x0b7f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/2/3/c */
    { 0x0c00, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/3/0/u */
    { 0x0c7f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/3/0/c */
    { 0x0d00, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/3/1/u */
    { 0x0d7f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/3/1/c */
    { 0x0e00, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/3/2/u */
    { 0x0e7f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/3/2/c */
    { 0x0f00, 0x2179, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #3/3/3/u */
    { 0x0f7f, 0x2179, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #3/3/3/c */
    { 0x0000, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/0/0/u */
    { 0x007f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/0/c */
    { 0x0100, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/0/1/u */
    { 0x017f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/1/c */
    { 0x0200, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/0/2/u */
    { 0x027f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/2/c */
    { 0x0300, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/0/3/u */
    { 0x037f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/0/3/c */
    { 0x0400, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/1/0/u */
    { 0x047f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/0/c */
    { 0x0500, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/1/1/u */
    { 0x057f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/1/c */
    { 0x0600, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/1/2/u */
    { 0x067f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/2/c */
    { 0x0700, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/1/3/u */
    { 0x077f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/1/3/c */
    { 0x0800, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/2/0/u */
    { 0x087f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/0/c */
    { 0x0900, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/2/1/u */
    { 0x097f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/1/c */
    { 0x0a00, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/2/2/u */
    { 0x0a7f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/2/c */
    { 0x0b00, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/2/3/u */
    { 0x0b7f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/2/3/c */
    { 0x0c00, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/3/0/u */
    { 0x0c7f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/0/c */
    { 0x0d00, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/3/1/u */
    { 0x0d7f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/1/c */
    { 0x0e00, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/3/2/u */
    { 0x0e7f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/2/c */
    { 0x0f00, 0x6fb2, 0xf581, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488) }, /* #4/3/3/u */
    { 0x0f7f, 0x6fb2, 0x7d01, RTFLOAT80U_INIT_C(1,0xe227579bee47a709,13173), RTFLOAT80U_INIT_C(0,0x6e2b4c16ec2cc0e2,20488), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #4/3/3/c */
    { 0x0000, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/0/0/u */
    { 0x007f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/0/c */
    { 0x0100, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/0/1/u */
    { 0x017f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/1/c */
    { 0x0200, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/0/2/u */
    { 0x027f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/2/c */
    { 0x0300, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/0/3/u */
    { 0x037f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/0/3/c */
    { 0x0400, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/1/0/u */
    { 0x047f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/0/c */
    { 0x0500, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/1/1/u */
    { 0x057f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/1/c */
    { 0x0600, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/1/2/u */
    { 0x067f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/2/c */
    { 0x0700, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/1/3/u */
    { 0x077f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/1/3/c */
    { 0x0800, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/2/0/u */
    { 0x087f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/0/c */
    { 0x0900, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/2/1/u */
    { 0x097f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/1/c */
    { 0x0a00, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/2/2/u */
    { 0x0a7f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/2/c */
    { 0x0b00, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/2/3/u */
    { 0x0b7f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/2/3/c */
    { 0x0c00, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/3/0/u */
    { 0x0c7f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/0/c */
    { 0x0d00, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/3/1/u */
    { 0x0d7f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/1/c */
    { 0x0e00, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/3/2/u */
    { 0x0e7f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/2/c */
    { 0x0f00, 0x9ba4, 0xb181, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379) }, /* #5/3/3/u */
    { 0x0f7f, 0x9ba4, 0x3901, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x7375a461448bc21f,30379), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #5/3/3/c */
    { 0x0000, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/0/0/u */
    { 0x007f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/0/0/c */
    { 0x0100, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/0/1/u */
    { 0x017f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/0/1/c */
    { 0x0200, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/0/2/u */
    { 0x027f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/0/2/c */
    { 0x0300, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/0/3/u */
    { 0x037f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/0/3/c */
    { 0x0400, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/1/0/u */
    { 0x047f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/1/0/c */
    { 0x0500, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/1/1/u */
    { 0x057f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/1/1/c */
    { 0x0600, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/1/2/u */
    { 0x067f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/1/2/c */
    { 0x0700, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/1/3/u */
    { 0x077f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/1/3/c */
    { 0x0800, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/2/0/u */
    { 0x087f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/2/0/c */
    { 0x0900, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/2/1/u */
    { 0x097f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/2/1/c */
    { 0x0a00, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/2/2/u */
    { 0x0a7f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/2/2/c */
    { 0x0b00, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/2/3/u */
    { 0x0b7f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/2/3/c */
    { 0x0c00, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/3/0/u */
    { 0x0c7f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/3/0/c */
    { 0x0d00, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/3/1/u */
    { 0x0d7f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/3/1/c */
    { 0x0e00, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/3/2/u */
    { 0x0e7f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/3/2/c */
    { 0x0f00, 0x896d, 0xb181, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502) }, /* #6/3/3/u */
    { 0x0f7f, 0x896d, 0x3901, RTFLOAT80U_INIT_C(0,0x800000008db60cd4,32767), RTFLOAT80U_INIT_C(0,0xa6314474d1ffa32a,20502), RTFLOAT80U_INIT_C(0,0xc00000008db60cd4,32767) }, /* #6/3/3/c */
    { 0x0000, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/0/0/u */
    { 0x007f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/0/0/c */
    { 0x0100, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/0/1/u */
    { 0x017f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/0/1/c */
    { 0x0200, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/0/2/u */
    { 0x027f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/0/2/c */
    { 0x0300, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/0/3/u */
    { 0x037f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/0/3/c */
    { 0x0400, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/1/0/u */
    { 0x047f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/1/0/c */
    { 0x0500, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/1/1/u */
    { 0x057f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/1/1/c */
    { 0x0600, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/1/2/u */
    { 0x067f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/1/2/c */
    { 0x0700, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/1/3/u */
    { 0x077f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/1/3/c */
    { 0x0800, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/2/0/u */
    { 0x087f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/2/0/c */
    { 0x0900, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/2/1/u */
    { 0x097f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/2/1/c */
    { 0x0a00, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/2/2/u */
    { 0x0a7f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/2/2/c */
    { 0x0b00, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/2/3/u */
    { 0x0b7f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/2/3/c */
    { 0x0c00, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/3/0/u */
    { 0x0c7f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/3/0/c */
    { 0x0d00, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/3/1/u */
    { 0x0d7f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/3/1/c */
    { 0x0e00, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/3/2/u */
    { 0x0e7f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/3/2/c */
    { 0x0f00, 0x8ce2, 0xb481, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437) }, /* #7/3/3/u */
    { 0x0f7f, 0x8ce2, 0x3c01, RTFLOAT80U_INIT_C(1,0xa09cd90d3d998ca4,30005), RTFLOAT80U_INIT_C(1,0x2b0e6b60a7b82717,437), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #7/3/3/c */
    { 0x0000, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/0/0/u */
    { 0x007f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/0/c */
    { 0x0100, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/0/1/u */
    { 0x017f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/1/c */
    { 0x0200, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/0/2/u */
    { 0x027f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/2/c */
    { 0x0300, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/0/3/u */
    { 0x037f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/0/3/c */
    { 0x0400, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/1/0/u */
    { 0x047f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/0/c */
    { 0x0500, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/1/1/u */
    { 0x057f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/1/c */
    { 0x0600, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/1/2/u */
    { 0x067f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/2/c */
    { 0x0700, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/1/3/u */
    { 0x077f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/1/3/c */
    { 0x0800, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/2/0/u */
    { 0x087f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/0/c */
    { 0x0900, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/2/1/u */
    { 0x097f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/1/c */
    { 0x0a00, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/2/2/u */
    { 0x0a7f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/2/c */
    { 0x0b00, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/2/3/u */
    { 0x0b7f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/2/3/c */
    { 0x0c00, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/3/0/u */
    { 0x0c7f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/0/c */
    { 0x0d00, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/3/1/u */
    { 0x0d7f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/1/c */
    { 0x0e00, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/3/2/u */
    { 0x0e7f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/2/c */
    { 0x0f00, 0xdaec, 0xf081, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #8/3/3/u */
    { 0x0f7f, 0xdaec, 0x7801, RTFLOAT80U_INIT_C(0,0x1e18463054192,25765), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #8/3/3/c */
    { 0x0000, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/0/0/u */
    { 0x007f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/0/c */
    { 0x0100, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/0/1/u */
    { 0x017f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/1/c */
    { 0x0200, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/0/2/u */
    { 0x027f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/2/c */
    { 0x0300, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/0/3/u */
    { 0x037f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/0/3/c */
    { 0x0400, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/1/0/u */
    { 0x047f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/0/c */
    { 0x0500, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/1/1/u */
    { 0x057f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/1/c */
    { 0x0600, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/1/2/u */
    { 0x067f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/2/c */
    { 0x0700, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/1/3/u */
    { 0x077f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/1/3/c */
    { 0x0800, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/2/0/u */
    { 0x087f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/0/c */
    { 0x0900, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/2/1/u */
    { 0x097f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/1/c */
    { 0x0a00, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/2/2/u */
    { 0x0a7f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/2/c */
    { 0x0b00, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/2/3/u */
    { 0x0b7f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/2/3/c */
    { 0x0c00, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/3/0/u */
    { 0x0c7f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/0/c */
    { 0x0d00, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/3/1/u */
    { 0x0d7f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/1/c */
    { 0x0e00, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/3/2/u */
    { 0x0e7f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/2/c */
    { 0x0f00, 0x776e, 0xf581, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978) }, /* #9/3/3/u */
    { 0x0f7f, 0x776e, 0x7d01, RTFLOAT80U_INIT_C(0,0x8066d911f,32767), RTFLOAT80U_INIT_C(0,0xeaeaab3c0f7a5edf,9978), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #9/3/3/c */
    { 0x0000, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/0/0/u */
    { 0x007f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/0/c */
    { 0x0100, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/0/1/u */
    { 0x017f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/1/c */
    { 0x0200, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/0/2/u */
    { 0x027f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/2/c */
    { 0x0300, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/0/3/u */
    { 0x037f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/0/3/c */
    { 0x0400, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/1/0/u */
    { 0x047f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/0/c */
    { 0x0500, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/1/1/u */
    { 0x057f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/1/c */
    { 0x0600, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/1/2/u */
    { 0x067f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/2/c */
    { 0x0700, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/1/3/u */
    { 0x077f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/1/3/c */
    { 0x0800, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/2/0/u */
    { 0x087f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/0/c */
    { 0x0900, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/2/1/u */
    { 0x097f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/1/c */
    { 0x0a00, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/2/2/u */
    { 0x0a7f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/2/c */
    { 0x0b00, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/2/3/u */
    { 0x0b7f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/2/3/c */
    { 0x0c00, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/3/0/u */
    { 0x0c7f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/0/c */
    { 0x0d00, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/3/1/u */
    { 0x0d7f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/1/c */
    { 0x0e00, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/3/2/u */
    { 0x0e7f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/2/c */
    { 0x0f00, 0xb2d0, 0xb081, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530) }, /* #10/3/3/u */
    { 0x0f7f, 0xb2d0, 0x3801, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xda19c814b6fa0bc,12530), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #10/3/3/c */
    { 0x0000, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/0/u */
    { 0x007f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/0/c */
    { 0x0100, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/1/u */
    { 0x017f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/1/c */
    { 0x0200, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/2/u */
    { 0x027f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/2/c */
    { 0x0300, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/3/u */
    { 0x037f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/0/3/c */
    { 0x0400, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/0/u */
    { 0x047f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/0/c */
    { 0x0500, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/1/u */
    { 0x057f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/1/c */
    { 0x0600, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/2/u */
    { 0x067f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/2/c */
    { 0x0700, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/3/u */
    { 0x077f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/1/3/c */
    { 0x0800, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/0/u */
    { 0x087f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/0/c */
    { 0x0900, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/1/u */
    { 0x097f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/1/c */
    { 0x0a00, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/2/u */
    { 0x0a7f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/2/c */
    { 0x0b00, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/3/u */
    { 0x0b7f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/2/3/c */
    { 0x0c00, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/0/u */
    { 0x0c7f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/0/c */
    { 0x0d00, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/1/u */
    { 0x0d7f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/1/c */
    { 0x0e00, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/2/u */
    { 0x0e7f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/2/c */
    { 0x0f00, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/3/u */
    { 0x0f7f, 0xbbfe, 0x3900, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xcebd16d4e241cff9,24750), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #11/3/3/c */
    { 0x0000, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/0/0/u */
    { 0x007f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/0/c */
    { 0x0100, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/0/1/u */
    { 0x017f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/1/c */
    { 0x0200, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/0/2/u */
    { 0x027f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/2/c */
    { 0x0300, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/0/3/u */
    { 0x037f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/0/3/c */
    { 0x0400, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/1/0/u */
    { 0x047f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/0/c */
    { 0x0500, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/1/1/u */
    { 0x057f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/1/c */
    { 0x0600, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/1/2/u */
    { 0x067f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/2/c */
    { 0x0700, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/1/3/u */
    { 0x077f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/1/3/c */
    { 0x0800, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/2/0/u */
    { 0x087f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/0/c */
    { 0x0900, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/2/1/u */
    { 0x097f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/1/c */
    { 0x0a00, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/2/2/u */
    { 0x0a7f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/2/c */
    { 0x0b00, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/2/3/u */
    { 0x0b7f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/2/3/c */
    { 0x0c00, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/3/0/u */
    { 0x0c7f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/0/c */
    { 0x0d00, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/3/1/u */
    { 0x0d7f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/1/c */
    { 0x0e00, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/3/2/u */
    { 0x0e7f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/2/c */
    { 0x0f00, 0x62ac, 0xf081, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075) }, /* #12/3/3/u */
    { 0x0f7f, 0x62ac, 0x7801, RTFLOAT80U_INIT_C(0,0x135ff2103fde2d0d,9011), RTFLOAT80U_INIT_C(1,0x98a3dde82b6688de,14075), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #12/3/3/c */
    { 0x0000, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/0/0/u */
    { 0x007f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/0/c */
    { 0x0100, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/0/1/u */
    { 0x017f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/1/c */
    { 0x0200, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/0/2/u */
    { 0x027f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/2/c */
    { 0x0300, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/0/3/u */
    { 0x037f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/0/3/c */
    { 0x0400, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/1/0/u */
    { 0x047f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/0/c */
    { 0x0500, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/1/1/u */
    { 0x057f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/1/c */
    { 0x0600, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/1/2/u */
    { 0x067f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/2/c */
    { 0x0700, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/1/3/u */
    { 0x077f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/1/3/c */
    { 0x0800, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/2/0/u */
    { 0x087f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/0/c */
    { 0x0900, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/2/1/u */
    { 0x097f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/1/c */
    { 0x0a00, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/2/2/u */
    { 0x0a7f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/2/c */
    { 0x0b00, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/2/3/u */
    { 0x0b7f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/2/3/c */
    { 0x0c00, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/3/0/u */
    { 0x0c7f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/0/c */
    { 0x0d00, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/3/1/u */
    { 0x0d7f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/1/c */
    { 0x0e00, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/3/2/u */
    { 0x0e7f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/2/c */
    { 0x0f00, 0x7256, 0xf081, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692) }, /* #13/3/3/u */
    { 0x0f7f, 0x7256, 0x7801, RTFLOAT80U_INIT_C(1,0x63d217964d6027c1,11276), RTFLOAT80U_INIT_C(1,0x906949de6c959500,5692), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #13/3/3/c */
    { 0x0000, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/0/0/u */
    { 0x007f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/0/0/c */
    { 0x0100, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/0/1/u */
    { 0x017f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/0/1/c */
    { 0x0200, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/0/2/u */
    { 0x027f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/0/2/c */
    { 0x0300, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/0/3/u */
    { 0x037f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/0/3/c */
    { 0x0400, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/1/0/u */
    { 0x047f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/1/0/c */
    { 0x0500, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/1/1/u */
    { 0x057f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/1/1/c */
    { 0x0600, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/1/2/u */
    { 0x067f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/1/2/c */
    { 0x0700, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/1/3/u */
    { 0x077f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/1/3/c */
    { 0x0800, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/2/0/u */
    { 0x087f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/2/0/c */
    { 0x0900, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/2/1/u */
    { 0x097f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/2/1/c */
    { 0x0a00, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/2/2/u */
    { 0x0a7f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/2/2/c */
    { 0x0b00, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/2/3/u */
    { 0x0b7f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/2/3/c */
    { 0x0c00, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/3/0/u */
    { 0x0c7f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/3/0/c */
    { 0x0d00, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/3/1/u */
    { 0x0d7f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/3/1/c */
    { 0x0e00, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/3/2/u */
    { 0x0e7f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/3/2/c */
    { 0x0f00, 0x19cf, 0xb181, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056) }, /* #14/3/3/u */
    { 0x0f7f, 0x19cf, 0x3901, RTFLOAT80U_INIT_C(0,0x80000000083e9552,32767), RTFLOAT80U_INIT_C(1,0xdfbedfc01cfe02ac,18056), RTFLOAT80U_INIT_C(0,0xc0000000083e9552,32767) }, /* #14/3/3/c */
    { 0x0000, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/0/0/u */
    { 0x007f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/0/c */
    { 0x0100, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/0/1/u */
    { 0x017f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/1/c */
    { 0x0200, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/0/2/u */
    { 0x027f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/2/c */
    { 0x0300, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/0/3/u */
    { 0x037f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/0/3/c */
    { 0x0400, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/1/0/u */
    { 0x047f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/0/c */
    { 0x0500, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/1/1/u */
    { 0x057f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/1/c */
    { 0x0600, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/1/2/u */
    { 0x067f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/2/c */
    { 0x0700, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/1/3/u */
    { 0x077f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/1/3/c */
    { 0x0800, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/2/0/u */
    { 0x087f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/0/c */
    { 0x0900, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/2/1/u */
    { 0x097f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/1/c */
    { 0x0a00, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/2/2/u */
    { 0x0a7f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/2/c */
    { 0x0b00, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/2/3/u */
    { 0x0b7f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/2/3/c */
    { 0x0c00, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/3/0/u */
    { 0x0c7f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/0/c */
    { 0x0d00, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/3/1/u */
    { 0x0d7f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/1/c */
    { 0x0e00, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/3/2/u */
    { 0x0e7f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/2/c */
    { 0x0f00, 0xbe13, 0xb481, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614) }, /* #15/3/3/u */
    { 0x0f7f, 0xbe13, 0x3c01, RTFLOAT80U_INIT_C(1,0xc0002e8de1139ac4,32767), RTFLOAT80U_INIT_C(1,0x3c946e64d2d95daa,1614), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #15/3/3/c */
    { 0x0000, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/0/0/u */
    { 0x007f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/0/0/c */
    { 0x0100, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/0/1/u */
    { 0x017f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/0/1/c */
    { 0x0200, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/0/2/u */
    { 0x027f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/0/2/c */
    { 0x0300, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/0/3/u */
    { 0x037f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/0/3/c */
    { 0x0400, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/1/0/u */
    { 0x047f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/1/0/c */
    { 0x0500, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/1/1/u */
    { 0x057f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/1/1/c */
    { 0x0600, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/1/2/u */
    { 0x067f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/1/2/c */
    { 0x0700, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/1/3/u */
    { 0x077f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/1/3/c */
    { 0x0800, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/2/0/u */
    { 0x087f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/2/0/c */
    { 0x0900, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/2/1/u */
    { 0x097f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/2/1/c */
    { 0x0a00, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/2/2/u */
    { 0x0a7f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/2/2/c */
    { 0x0b00, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/2/3/u */
    { 0x0b7f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/2/3/c */
    { 0x0c00, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/3/0/u */
    { 0x0c7f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/3/0/c */
    { 0x0d00, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/3/1/u */
    { 0x0d7f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/3/1/c */
    { 0x0e00, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/3/2/u */
    { 0x0e7f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/3/2/c */
    { 0x0f00, 0x2909, 0xb181, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509) }, /* #16/3/3/u */
    { 0x0f7f, 0x2909, 0x3901, RTFLOAT80U_INIT_C(0,0x8000001b26398ddf,32767), RTFLOAT80U_INIT_C(0,0x370e62ebe530127f,28509), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #16/3/3/c */
    { 0x0000, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/0/0/u */
    { 0x007f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/0/c */
    { 0x0100, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/0/1/u */
    { 0x017f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/1/c */
    { 0x0200, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/0/2/u */
    { 0x027f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/2/c */
    { 0x0300, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/0/3/u */
    { 0x037f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/0/3/c */
    { 0x0400, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/1/0/u */
    { 0x047f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/0/c */
    { 0x0500, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/1/1/u */
    { 0x057f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/1/c */
    { 0x0600, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/1/2/u */
    { 0x067f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/2/c */
    { 0x0700, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/1/3/u */
    { 0x077f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/1/3/c */
    { 0x0800, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/2/0/u */
    { 0x087f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/0/c */
    { 0x0900, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/2/1/u */
    { 0x097f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/1/c */
    { 0x0a00, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/2/2/u */
    { 0x0a7f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/2/c */
    { 0x0b00, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/2/3/u */
    { 0x0b7f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/2/3/c */
    { 0x0c00, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/3/0/u */
    { 0x0c7f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/0/c */
    { 0x0d00, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/3/1/u */
    { 0x0d7f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/1/c */
    { 0x0e00, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/3/2/u */
    { 0x0e7f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/2/c */
    { 0x0f00, 0x1035, 0xb081, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893) }, /* #17/3/3/u */
    { 0x0f7f, 0x1035, 0x3801, RTFLOAT80U_INIT_C(1,0x630ceb66186d1b14,32767), RTFLOAT80U_INIT_C(1,0x93b35b1534dde43c,18893), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #17/3/3/c */
    { 0x0000, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/0/u */
    { 0x007f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/0/c */
    { 0x0100, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/1/u */
    { 0x017f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/1/c */
    { 0x0200, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/2/u */
    { 0x027f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/2/c */
    { 0x0300, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/3/u */
    { 0x037f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/0/3/c */
    { 0x0400, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/0/u */
    { 0x047f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/0/c */
    { 0x0500, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/1/u */
    { 0x057f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/1/c */
    { 0x0600, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/2/u */
    { 0x067f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/2/c */
    { 0x0700, 0xb3f3, 0xbba0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/3/u */
    { 0x077f, 0xb3f3, 0x3b20, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #18/1/3/c */
    { 0x0800, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/0/u */
    { 0x087f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/0/c */
    { 0x0900, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/1/u */
    { 0x097f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/1/c */
    { 0x0a00, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/2/u */
    { 0x0a7f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/2/c */
    { 0x0b00, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/3/u */
    { 0x0b7f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/2/3/c */
    { 0x0c00, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/0/u */
    { 0x0c7f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/0/c */
    { 0x0d00, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/1/u */
    { 0x0d7f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/1/c */
    { 0x0e00, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/2/u */
    { 0x0e7f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/2/c */
    { 0x0f00, 0xb3f3, 0xb9a0, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/3/u */
    { 0x0f7f, 0xb3f3, 0x3920, RTFLOAT80U_INIT_C(1,0xd27d546944b432f4,23922), RTFLOAT80U_INIT_C(1,0xd0eeafa6693cb674,17401), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #18/3/3/c */
    { 0x0000, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/0/0/u */
    { 0x007f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/0/c */
    { 0x0100, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/0/1/u */
    { 0x017f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/1/c */
    { 0x0200, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/0/2/u */
    { 0x027f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/2/c */
    { 0x0300, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/0/3/u */
    { 0x037f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/0/3/c */
    { 0x0400, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/1/0/u */
    { 0x047f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/0/c */
    { 0x0500, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/1/1/u */
    { 0x057f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/1/c */
    { 0x0600, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/1/2/u */
    { 0x067f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/2/c */
    { 0x0700, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/1/3/u */
    { 0x077f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/1/3/c */
    { 0x0800, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/2/0/u */
    { 0x087f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/0/c */
    { 0x0900, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/2/1/u */
    { 0x097f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/1/c */
    { 0x0a00, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/2/2/u */
    { 0x0a7f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/2/c */
    { 0x0b00, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/2/3/u */
    { 0x0b7f, 0xee83, 0x7e22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #19/2/3/c */
    { 0x0c00, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/3/0/u */
    { 0x0c7f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/0/c */
    { 0x0d00, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/3/1/u */
    { 0x0d7f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/1/c */
    { 0x0e00, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/3/2/u */
    { 0x0e7f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/2/c */
    { 0x0f00, 0xee83, 0xf482, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0) }, /* #19/3/3/u */
    { 0x0f7f, 0xee83, 0x7c22, RTFLOAT80U_INIT_C(0,0xc5a5b43df8903d41,13444), RTFLOAT80U_INIT_C(0,0x12b5069d4ac9fbd7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #19/3/3/c */
    { 0x0000, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/0/0/u */
    { 0x007f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/0/0/c */
    { 0x0100, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/0/1/u */
    { 0x017f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/0/1/c */
    { 0x0200, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/0/2/u */
    { 0x027f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/0/2/c */
    { 0x0300, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/0/3/u */
    { 0x037f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/0/3/c */
    { 0x0400, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/1/0/u */
    { 0x047f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/1/0/c */
    { 0x0500, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/1/1/u */
    { 0x057f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/1/1/c */
    { 0x0600, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/1/2/u */
    { 0x067f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/1/2/c */
    { 0x0700, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/1/3/u */
    { 0x077f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/1/3/c */
    { 0x0800, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/2/0/u */
    { 0x087f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/2/0/c */
    { 0x0900, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/2/1/u */
    { 0x097f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/2/1/c */
    { 0x0a00, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/2/2/u */
    { 0x0a7f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/2/2/c */
    { 0x0b00, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/2/3/u */
    { 0x0b7f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/2/3/c */
    { 0x0c00, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/3/0/u */
    { 0x0c7f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/3/0/c */
    { 0x0d00, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/3/1/u */
    { 0x0d7f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/3/1/c */
    { 0x0e00, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/3/2/u */
    { 0x0e7f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/3/2/c */
    { 0x0f00, 0xb6af, 0xb481, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170) }, /* #20/3/3/u */
    { 0x0f7f, 0xb6af, 0x3c01, RTFLOAT80U_INIT_C(1,0x80017355da42a6b0,32767), RTFLOAT80U_INIT_C(1,0xbd9db5f03353b91b,16170), RTFLOAT80U_INIT_C(1,0xc0017355da42a6b0,32767) }, /* #20/3/3/c */
    { 0x0000, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/0/u */
    { 0x007f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/0/c */
    { 0x0100, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/1/u */
    { 0x017f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/1/c */
    { 0x0200, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/2/u */
    { 0x027f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/2/c */
    { 0x0300, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/3/u */
    { 0x037f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/0/3/c */
    { 0x0400, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/0/u */
    { 0x047f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/0/c */
    { 0x0500, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/1/u */
    { 0x057f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/1/c */
    { 0x0600, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/2/u */
    { 0x067f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/2/c */
    { 0x0700, 0x4279, 0xfaa0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/3/u */
    { 0x077f, 0x4279, 0x7a20, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #21/1/3/c */
    { 0x0800, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/0/u */
    { 0x087f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/0/c */
    { 0x0900, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/1/u */
    { 0x097f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/1/c */
    { 0x0a00, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/2/u */
    { 0x0a7f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/2/c */
    { 0x0b00, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/3/u */
    { 0x0b7f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/2/3/c */
    { 0x0c00, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/0/u */
    { 0x0c7f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/0/c */
    { 0x0d00, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/1/u */
    { 0x0d7f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/1/c */
    { 0x0e00, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/2/u */
    { 0x0e7f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/2/c */
    { 0x0f00, 0x4279, 0xf8a0, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/3/u */
    { 0x0f7f, 0x4279, 0x7820, RTFLOAT80U_INIT_C(1,0x814250027ae8ab3d,13299), RTFLOAT80U_INIT_C(1,0x969f0c785158b435,18101), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #21/3/3/c */
    { 0x0000, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/0/u */
    { 0x007f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/0/c */
    { 0x0100, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/1/u */
    { 0x017f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/1/c */
    { 0x0200, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/2/u */
    { 0x027f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/2/c */
    { 0x0300, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/3/u */
    { 0x037f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/0/3/c */
    { 0x0400, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/0/u */
    { 0x047f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/0/c */
    { 0x0500, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/1/u */
    { 0x057f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/1/c */
    { 0x0600, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/2/u */
    { 0x067f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/2/c */
    { 0x0700, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/3/u */
    { 0x077f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/1/3/c */
    { 0x0800, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/0/u */
    { 0x087f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/0/c */
    { 0x0900, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/1/u */
    { 0x097f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/1/c */
    { 0x0a00, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/2/u */
    { 0x0a7f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/2/c */
    { 0x0b00, 0x9b95, 0xbba0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/3/u */
    { 0x0b7f, 0x9b95, 0x3b20, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #22/2/3/c */
    { 0x0c00, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/0/u */
    { 0x0c7f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/0/c */
    { 0x0d00, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/1/u */
    { 0x0d7f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/1/c */
    { 0x0e00, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/2/u */
    { 0x0e7f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/2/c */
    { 0x0f00, 0x9b95, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/3/u */
    { 0x0f7f, 0x9b95, 0x3920, RTFLOAT80U_INIT_C(0,0xa1884cb69fcc40a2,29376), RTFLOAT80U_INIT_C(0,0xc95ed4a0dfdf7c61,22830), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #22/3/3/c */
    { 0x0000, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/0/0/u */
    { 0x007f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/0/c */
    { 0x0100, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/0/1/u */
    { 0x017f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/1/c */
    { 0x0200, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/0/2/u */
    { 0x027f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/2/c */
    { 0x0300, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/0/3/u */
    { 0x037f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/0/3/c */
    { 0x0400, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/1/0/u */
    { 0x047f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/0/c */
    { 0x0500, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/1/1/u */
    { 0x057f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/1/c */
    { 0x0600, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/1/2/u */
    { 0x067f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/2/c */
    { 0x0700, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/1/3/u */
    { 0x077f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/1/3/c */
    { 0x0800, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/2/0/u */
    { 0x087f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/0/c */
    { 0x0900, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/2/1/u */
    { 0x097f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/1/c */
    { 0x0a00, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/2/2/u */
    { 0x0a7f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/2/c */
    { 0x0b00, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/2/3/u */
    { 0x0b7f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/2/3/c */
    { 0x0c00, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/3/0/u */
    { 0x0c7f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/0/c */
    { 0x0d00, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/3/1/u */
    { 0x0d7f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/1/c */
    { 0x0e00, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/3/2/u */
    { 0x0e7f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/2/c */
    { 0x0f00, 0x8401, 0xb481, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767) }, /* #23/3/3/u */
    { 0x0f7f, 0x8401, 0x3c01, RTFLOAT80U_INIT_C(0,0x50f39bf9c3c45df1,288), RTFLOAT80U_INIT_C(0,0xc0160d4fcefb8c45,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #23/3/3/c */
    { 0x0000, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/0/0/u */
    { 0x007f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/0/c */
    { 0x0100, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/0/1/u */
    { 0x017f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/1/c */
    { 0x0200, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/0/2/u */
    { 0x027f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/2/c */
    { 0x0300, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/0/3/u */
    { 0x037f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/0/3/c */
    { 0x0400, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/1/0/u */
    { 0x047f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/0/c */
    { 0x0500, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/1/1/u */
    { 0x057f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/1/c */
    { 0x0600, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/1/2/u */
    { 0x067f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/2/c */
    { 0x0700, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/1/3/u */
    { 0x077f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/1/3/c */
    { 0x0800, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/2/0/u */
    { 0x087f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/0/c */
    { 0x0900, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/2/1/u */
    { 0x097f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/1/c */
    { 0x0a00, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/2/2/u */
    { 0x0a7f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/2/c */
    { 0x0b00, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/2/3/u */
    { 0x0b7f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/2/3/c */
    { 0x0c00, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/3/0/u */
    { 0x0c7f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/0/c */
    { 0x0d00, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/3/1/u */
    { 0x0d7f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/1/c */
    { 0x0e00, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/3/2/u */
    { 0x0e7f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/2/c */
    { 0x0f00, 0x269d, 0xb481, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349) }, /* #24/3/3/u */
    { 0x0f7f, 0x269d, 0x3c01, RTFLOAT80U_INIT_C(1,0xe2120198a8436ab2,13217), RTFLOAT80U_INIT_C(0,0x4f1fbc5c37bbd,17349), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #24/3/3/c */
    { 0x0000, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/0/0/u */
    { 0x007f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/0/c */
    { 0x0100, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/0/1/u */
    { 0x017f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/1/c */
    { 0x0200, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/0/2/u */
    { 0x027f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/2/c */
    { 0x0300, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/0/3/u */
    { 0x037f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/0/3/c */
    { 0x0400, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/1/0/u */
    { 0x047f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/0/c */
    { 0x0500, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/1/1/u */
    { 0x057f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/1/c */
    { 0x0600, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/1/2/u */
    { 0x067f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/2/c */
    { 0x0700, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/1/3/u */
    { 0x077f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/1/3/c */
    { 0x0800, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/2/0/u */
    { 0x087f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/0/c */
    { 0x0900, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/2/1/u */
    { 0x097f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/1/c */
    { 0x0a00, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/2/2/u */
    { 0x0a7f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/2/c */
    { 0x0b00, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/2/3/u */
    { 0x0b7f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/2/3/c */
    { 0x0c00, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/3/0/u */
    { 0x0c7f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/0/c */
    { 0x0d00, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/3/1/u */
    { 0x0d7f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/1/c */
    { 0x0e00, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/3/2/u */
    { 0x0e7f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/2/c */
    { 0x0f00, 0xdd77, 0xf581, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780) }, /* #25/3/3/u */
    { 0x0f7f, 0xdd77, 0x7d01, RTFLOAT80U_INIT_C(1,0xf3c41a9254a9406a,459), RTFLOAT80U_INIT_C(1,0x64634837c88ff9f5,16780), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #25/3/3/c */
    { 0x0000, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/0/u */
    { 0x007f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/0/c */
    { 0x0100, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/1/u */
    { 0x017f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/1/c */
    { 0x0200, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/2/u */
    { 0x027f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/2/c */
    { 0x0300, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/3/u */
    { 0x037f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/0/3/c */
    { 0x0400, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/0/u */
    { 0x047f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/0/c */
    { 0x0500, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/1/u */
    { 0x057f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/1/c */
    { 0x0600, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/2/u */
    { 0x067f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/2/c */
    { 0x0700, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/3/u */
    { 0x077f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/1/3/c */
    { 0x0800, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/0/u */
    { 0x087f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/0/c */
    { 0x0900, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/1/u */
    { 0x097f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/1/c */
    { 0x0a00, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/2/u */
    { 0x0a7f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/2/c */
    { 0x0b00, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/3/u */
    { 0x0b7f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/2/3/c */
    { 0x0c00, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/0/u */
    { 0x0c7f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/0/c */
    { 0x0d00, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/1/u */
    { 0x0d7f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/1/c */
    { 0x0e00, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/2/u */
    { 0x0e7f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/2/c */
    { 0x0f00, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/3/u */
    { 0x0f7f, 0x0d12, 0x3d00, RTFLOAT80U_INIT_C(0,0xfa9cac467650eb9d,26253), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767), RTFLOAT80U_INIT_C(0,0xd781f6be353c821b,32767) }, /* #26/3/3/c */
    { 0x0000, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/0/0/u */
    { 0x007f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/0/0/c */
    { 0x0100, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/0/1/u */
    { 0x017f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/0/1/c */
    { 0x0200, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/0/2/u */
    { 0x027f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/0/2/c */
    { 0x0300, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/0/3/u */
    { 0x037f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/0/3/c */
    { 0x0400, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/1/0/u */
    { 0x047f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/1/0/c */
    { 0x0500, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/1/1/u */
    { 0x057f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/1/1/c */
    { 0x0600, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/1/2/u */
    { 0x067f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/1/2/c */
    { 0x0700, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/1/3/u */
    { 0x077f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/1/3/c */
    { 0x0800, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/2/0/u */
    { 0x087f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/2/0/c */
    { 0x0900, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/2/1/u */
    { 0x097f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/2/1/c */
    { 0x0a00, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/2/2/u */
    { 0x0a7f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/2/2/c */
    { 0x0b00, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/2/3/u */
    { 0x0b7f, 0xd96d, 0x7b22, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #27/2/3/c */
    { 0x0c00, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/3/0/u */
    { 0x0c7f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/3/0/c */
    { 0x0d00, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/3/1/u */
    { 0x0d7f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/3/1/c */
    { 0x0e00, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/3/2/u */
    { 0x0e7f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/3/2/c */
    { 0x0f00, 0xd96d, 0xf182, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005) }, /* #27/3/3/u */
    { 0x0f7f, 0xd96d, 0x7922, RTFLOAT80U_INIT_C(0,0x2d43ae13b85e26c6,0), RTFLOAT80U_INIT_C(1,0x8f752400491c088c,1005), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #27/3/3/c */
    { 0x0000, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/0/u */
    { 0x007f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/0/c */
    { 0x0100, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/1/u */
    { 0x017f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/1/c */
    { 0x0200, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/2/u */
    { 0x027f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/2/c */
    { 0x0300, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/3/u */
    { 0x037f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/0/3/c */
    { 0x0400, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/0/u */
    { 0x047f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/0/c */
    { 0x0500, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/1/u */
    { 0x057f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/1/c */
    { 0x0600, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/2/u */
    { 0x067f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/2/c */
    { 0x0700, 0x9684, 0xbea0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/3/u */
    { 0x077f, 0x9684, 0x3e20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #28/1/3/c */
    { 0x0800, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/0/u */
    { 0x087f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/0/c */
    { 0x0900, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/1/u */
    { 0x097f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/1/c */
    { 0x0a00, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/2/u */
    { 0x0a7f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/2/c */
    { 0x0b00, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/3/u */
    { 0x0b7f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/2/3/c */
    { 0x0c00, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/0/u */
    { 0x0c7f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/0/c */
    { 0x0d00, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/1/u */
    { 0x0d7f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/1/c */
    { 0x0e00, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/2/u */
    { 0x0e7f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/2/c */
    { 0x0f00, 0x9684, 0xbca0, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/3/u */
    { 0x0f7f, 0x9684, 0x3c20, RTFLOAT80U_INIT_C(1,0xef8e93c942748421,2435), RTFLOAT80U_INIT_C(1,0x993e8a1303c47e47,29271), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #28/3/3/c */
    { 0x0000, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/0/u */
    { 0x007f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/0/c */
    { 0x0100, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/1/u */
    { 0x017f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/1/c */
    { 0x0200, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/2/u */
    { 0x027f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/2/c */
    { 0x0300, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/3/u */
    { 0x037f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/0/3/c */
    { 0x0400, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/0/u */
    { 0x047f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/0/c */
    { 0x0500, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/1/u */
    { 0x057f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/1/c */
    { 0x0600, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/2/u */
    { 0x067f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/2/c */
    { 0x0700, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/3/u */
    { 0x077f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/1/3/c */
    { 0x0800, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/0/u */
    { 0x087f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/0/c */
    { 0x0900, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/1/u */
    { 0x097f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/1/c */
    { 0x0a00, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/2/u */
    { 0x0a7f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/2/c */
    { 0x0b00, 0xc6c0, 0xfea0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/3/u */
    { 0x0b7f, 0xc6c0, 0x7e20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #29/2/3/c */
    { 0x0c00, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/0/u */
    { 0x0c7f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/0/c */
    { 0x0d00, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/1/u */
    { 0x0d7f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/1/c */
    { 0x0e00, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/2/u */
    { 0x0e7f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/2/c */
    { 0x0f00, 0xc6c0, 0xfca0, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/3/u */
    { 0x0f7f, 0xc6c0, 0x7c20, RTFLOAT80U_INIT_C(0,0x906915204d8bba22,4382), RTFLOAT80U_INIT_C(0,0xe96da8fb59e69aca,3068), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #29/3/3/c */
    { 0x0000, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/0/0/u */
    { 0x007f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/0/c */
    { 0x0100, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/0/1/u */
    { 0x017f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/1/c */
    { 0x0200, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/0/2/u */
    { 0x027f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/2/c */
    { 0x0300, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/0/3/u */
    { 0x037f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/0/3/c */
    { 0x0400, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/1/0/u */
    { 0x047f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/0/c */
    { 0x0500, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/1/1/u */
    { 0x057f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/1/c */
    { 0x0600, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/1/2/u */
    { 0x067f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/2/c */
    { 0x0700, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/1/3/u */
    { 0x077f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/1/3/c */
    { 0x0800, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/2/0/u */
    { 0x087f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/0/c */
    { 0x0900, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/2/1/u */
    { 0x097f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/1/c */
    { 0x0a00, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/2/2/u */
    { 0x0a7f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/2/c */
    { 0x0b00, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/2/3/u */
    { 0x0b7f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/2/3/c */
    { 0x0c00, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/3/0/u */
    { 0x0c7f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/0/c */
    { 0x0d00, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/3/1/u */
    { 0x0d7f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/1/c */
    { 0x0e00, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/3/2/u */
    { 0x0e7f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/2/c */
    { 0x0f00, 0x8f8f, 0xb581, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228) }, /* #30/3/3/u */
    { 0x0f7f, 0x8f8f, 0x3d01, RTFLOAT80U_INIT_C(1,0x3285f7024798959b,15927), RTFLOAT80U_INIT_C(1,0x124c87d8e1eb1b4,10228), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #30/3/3/c */
    { 0x0000, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/0/u */
    { 0x007f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/0/c */
    { 0x0100, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/1/u */
    { 0x017f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/1/c */
    { 0x0200, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/2/u */
    { 0x027f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/2/c */
    { 0x0300, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/3/u */
    { 0x037f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/0/3/c */
    { 0x0400, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/0/u */
    { 0x047f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/0/c */
    { 0x0500, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/1/u */
    { 0x057f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/1/c */
    { 0x0600, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/2/u */
    { 0x067f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/2/c */
    { 0x0700, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/3/u */
    { 0x077f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/1/3/c */
    { 0x0800, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/0/u */
    { 0x087f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/0/c */
    { 0x0900, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/1/u */
    { 0x097f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/1/c */
    { 0x0a00, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/2/u */
    { 0x0a7f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/2/c */
    { 0x0b00, 0x7a8f, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/3/u */
    { 0x0b7f, 0x7a8f, 0x7a20, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #31/2/3/c */
    { 0x0c00, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/0/u */
    { 0x0c7f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/0/c */
    { 0x0d00, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/1/u */
    { 0x0d7f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/1/c */
    { 0x0e00, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/2/u */
    { 0x0e7f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/2/c */
    { 0x0f00, 0x7a8f, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/3/u */
    { 0x0f7f, 0x7a8f, 0x7820, RTFLOAT80U_INIT_C(0,0xa4a89c9596a10276,3328), RTFLOAT80U_INIT_C(1,0xb329ed4e0656e64d,22259), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #31/3/3/c */
    { 0x0000, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/0/0/u */
    { 0x007f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/0/c */
    { 0x0100, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/0/1/u */
    { 0x017f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/1/c */
    { 0x0200, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/0/2/u */
    { 0x027f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/2/c */
    { 0x0300, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/0/3/u */
    { 0x037f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/0/3/c */
    { 0x0400, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/1/0/u */
    { 0x047f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/0/c */
    { 0x0500, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/1/1/u */
    { 0x057f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/1/c */
    { 0x0600, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/1/2/u */
    { 0x067f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/2/c */
    { 0x0700, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/1/3/u */
    { 0x077f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/1/3/c */
    { 0x0800, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/2/0/u */
    { 0x087f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/0/c */
    { 0x0900, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/2/1/u */
    { 0x097f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/1/c */
    { 0x0a00, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/2/2/u */
    { 0x0a7f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/2/c */
    { 0x0b00, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/2/3/u */
    { 0x0b7f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/2/3/c */
    { 0x0c00, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/3/0/u */
    { 0x0c7f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/0/c */
    { 0x0d00, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/3/1/u */
    { 0x0d7f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/1/c */
    { 0x0e00, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/3/2/u */
    { 0x0e7f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/2/c */
    { 0x0f00, 0x797b, 0xf181, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767) }, /* #32/3/3/u */
    { 0x0f7f, 0x797b, 0x7901, RTFLOAT80U_INIT_C(0,0xdde127a7d53644d5,29975), RTFLOAT80U_INIT_C(1,0x3eee24ab59cf64f9,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #32/3/3/c */
    { 0x0000, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/0/0/u */
    { 0x007f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/0/0/c */
    { 0x0100, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/0/1/u */
    { 0x017f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/0/1/c */
    { 0x0200, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/0/2/u */
    { 0x027f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/0/2/c */
    { 0x0300, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/0/3/u */
    { 0x037f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/0/3/c */
    { 0x0400, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/1/0/u */
    { 0x047f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/1/0/c */
    { 0x0500, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/1/1/u */
    { 0x057f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/1/1/c */
    { 0x0600, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/1/2/u */
    { 0x067f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/1/2/c */
    { 0x0700, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/1/3/u */
    { 0x077f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/1/3/c */
    { 0x0800, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/2/0/u */
    { 0x087f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/2/0/c */
    { 0x0900, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/2/1/u */
    { 0x097f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/2/1/c */
    { 0x0a00, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/2/2/u */
    { 0x0a7f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/2/2/c */
    { 0x0b00, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/2/3/u */
    { 0x0b7f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/2/3/c */
    { 0x0c00, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/3/0/u */
    { 0x0c7f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/3/0/c */
    { 0x0d00, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/3/1/u */
    { 0x0d7f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/3/1/c */
    { 0x0e00, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/3/2/u */
    { 0x0e7f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/3/2/c */
    { 0x0f00, 0x0fd6, 0xb581, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927) }, /* #33/3/3/u */
    { 0x0f7f, 0x0fd6, 0x3d01, RTFLOAT80U_INIT_C(1,0xe11327bba57fac74,1347), RTFLOAT80U_INIT_C(0,0xac56fe8abb,15927), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #33/3/3/c */
    { 0x0000, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/0/u */
    { 0x007f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/0/c */
    { 0x0100, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/1/u */
    { 0x017f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/1/c */
    { 0x0200, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/2/u */
    { 0x027f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/2/c */
    { 0x0300, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/3/u */
    { 0x037f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/0/3/c */
    { 0x0400, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/0/u */
    { 0x047f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/0/c */
    { 0x0500, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/1/u */
    { 0x057f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/1/c */
    { 0x0600, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/2/u */
    { 0x067f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/2/c */
    { 0x0700, 0xd07a, 0xfaa0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/3/u */
    { 0x077f, 0xd07a, 0x7a20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #34/1/3/c */
    { 0x0800, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/0/u */
    { 0x087f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/0/c */
    { 0x0900, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/1/u */
    { 0x097f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/1/c */
    { 0x0a00, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/2/u */
    { 0x0a7f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/2/c */
    { 0x0b00, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/3/u */
    { 0x0b7f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/2/3/c */
    { 0x0c00, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/0/u */
    { 0x0c7f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/0/c */
    { 0x0d00, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/1/u */
    { 0x0d7f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/1/c */
    { 0x0e00, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/2/u */
    { 0x0e7f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/2/c */
    { 0x0f00, 0xd07a, 0xf8a0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/3/u */
    { 0x0f7f, 0xd07a, 0x7820, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #34/3/3/c */
    { 0x0000, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/0/u */
    { 0x007f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/0/c */
    { 0x0100, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/1/u */
    { 0x017f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/1/c */
    { 0x0200, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/2/u */
    { 0x027f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/2/c */
    { 0x0300, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/3/u */
    { 0x037f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/0/3/c */
    { 0x0400, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/0/u */
    { 0x047f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/0/c */
    { 0x0500, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/1/u */
    { 0x057f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/1/c */
    { 0x0600, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/2/u */
    { 0x067f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/2/c */
    { 0x0700, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/3/u */
    { 0x077f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/1/3/c */
    { 0x0800, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/0/u */
    { 0x087f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/0/c */
    { 0x0900, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/1/u */
    { 0x097f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/1/c */
    { 0x0a00, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/2/u */
    { 0x0a7f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/2/c */
    { 0x0b00, 0x9eaa, 0xbea0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/3/u */
    { 0x0b7f, 0x9eaa, 0x3e20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #35/2/3/c */
    { 0x0c00, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/0/u */
    { 0x0c7f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/0/c */
    { 0x0d00, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/1/u */
    { 0x0d7f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/1/c */
    { 0x0e00, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/2/u */
    { 0x0e7f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/2/c */
    { 0x0f00, 0x9eaa, 0xbca0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/3/u */
    { 0x0f7f, 0x9eaa, 0x3c20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x98f8847fbcdd1e6c,15015), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #35/3/3/c */
    { 0x0000, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/0/u */
    { 0x007f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/0/c */
    { 0x0100, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/1/u */
    { 0x017f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/1/c */
    { 0x0200, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/2/u */
    { 0x027f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/2/c */
    { 0x0300, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/3/u */
    { 0x037f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/0/3/c */
    { 0x0400, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/0/u */
    { 0x047f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/0/c */
    { 0x0500, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/1/u */
    { 0x057f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/1/c */
    { 0x0600, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/2/u */
    { 0x067f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/2/c */
    { 0x0700, 0x9dd7, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/3/u */
    { 0x077f, 0x9dd7, 0x3f20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #36/1/3/c */
    { 0x0800, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/0/u */
    { 0x087f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/0/c */
    { 0x0900, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/1/u */
    { 0x097f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/1/c */
    { 0x0a00, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/2/u */
    { 0x0a7f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/2/c */
    { 0x0b00, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/3/u */
    { 0x0b7f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/2/3/c */
    { 0x0c00, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/0/u */
    { 0x0c7f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/0/c */
    { 0x0d00, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/1/u */
    { 0x0d7f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/1/c */
    { 0x0e00, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/2/u */
    { 0x0e7f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/2/c */
    { 0x0f00, 0x9dd7, 0xbda0, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/3/u */
    { 0x0f7f, 0x9dd7, 0x3d20, RTFLOAT80U_INIT_C(1,0xe76d5c883a86cad0,30960), RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #36/3/3/c */
    { 0x0000, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/0/0/u */
    { 0x007f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/0/c */
    { 0x0100, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/0/1/u */
    { 0x017f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/1/c */
    { 0x0200, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/0/2/u */
    { 0x027f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/2/c */
    { 0x0300, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/0/3/u */
    { 0x037f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/0/3/c */
    { 0x0400, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/1/0/u */
    { 0x047f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/0/c */
    { 0x0500, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/1/1/u */
    { 0x057f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/1/c */
    { 0x0600, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/1/2/u */
    { 0x067f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/2/c */
    { 0x0700, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/1/3/u */
    { 0x077f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/1/3/c */
    { 0x0800, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/2/0/u */
    { 0x087f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/0/c */
    { 0x0900, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/2/1/u */
    { 0x097f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/1/c */
    { 0x0a00, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/2/2/u */
    { 0x0a7f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/2/c */
    { 0x0b00, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/2/3/u */
    { 0x0b7f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/2/3/c */
    { 0x0c00, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/3/0/u */
    { 0x0c7f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/0/c */
    { 0x0d00, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/3/1/u */
    { 0x0d7f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/1/c */
    { 0x0e00, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/3/2/u */
    { 0x0e7f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/2/c */
    { 0x0f00, 0x7ca7, 0xf481, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100) }, /* #37/3/3/u */
    { 0x0f7f, 0x7ca7, 0x7c01, RTFLOAT80U_INIT_C(0,0x22ae83f8057c91f0,16741), RTFLOAT80U_INIT_C(0,0xca6beea40770faf5,22100), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #37/3/3/c */
    { 0x0000, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/0/0/u */
    { 0x007f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/0/c */
    { 0x0100, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/0/1/u */
    { 0x017f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/1/c */
    { 0x0200, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/0/2/u */
    { 0x027f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/2/c */
    { 0x0300, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/0/3/u */
    { 0x037f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/0/3/c */
    { 0x0400, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/1/0/u */
    { 0x047f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/0/c */
    { 0x0500, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/1/1/u */
    { 0x057f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/1/c */
    { 0x0600, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/1/2/u */
    { 0x067f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/2/c */
    { 0x0700, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/1/3/u */
    { 0x077f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/1/3/c */
    { 0x0800, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/2/0/u */
    { 0x087f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/0/c */
    { 0x0900, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/2/1/u */
    { 0x097f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/1/c */
    { 0x0a00, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/2/2/u */
    { 0x0a7f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/2/c */
    { 0x0b00, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/2/3/u */
    { 0x0b7f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/2/3/c */
    { 0x0c00, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/3/0/u */
    { 0x0c7f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/0/c */
    { 0x0d00, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/3/1/u */
    { 0x0d7f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/1/c */
    { 0x0e00, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/3/2/u */
    { 0x0e7f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/2/c */
    { 0x0f00, 0x3535, 0xb581, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772) }, /* #38/3/3/u */
    { 0x0f7f, 0x3535, 0x3d01, RTFLOAT80U_INIT_C(1,0xd7aa43333557ce51,21864), RTFLOAT80U_INIT_C(0,0x78ff09d32fcfe202,14772), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #38/3/3/c */
    { 0x0000, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/0/u */
    { 0x007f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/0/c */
    { 0x0100, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/1/u */
    { 0x017f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/1/c */
    { 0x0200, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/2/u */
    { 0x027f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/2/c */
    { 0x0300, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/3/u */
    { 0x037f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/0/3/c */
    { 0x0400, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/0/u */
    { 0x047f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/0/c */
    { 0x0500, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/1/u */
    { 0x057f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/1/c */
    { 0x0600, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/2/u */
    { 0x067f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/2/c */
    { 0x0700, 0x9471, 0xbea0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/3/u */
    { 0x077f, 0x9471, 0x3e20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #39/1/3/c */
    { 0x0800, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/0/u */
    { 0x087f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/0/c */
    { 0x0900, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/1/u */
    { 0x097f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/1/c */
    { 0x0a00, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/2/u */
    { 0x0a7f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/2/c */
    { 0x0b00, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/3/u */
    { 0x0b7f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/2/3/c */
    { 0x0c00, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/0/u */
    { 0x0c7f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/0/c */
    { 0x0d00, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/1/u */
    { 0x0d7f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/1/c */
    { 0x0e00, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/2/u */
    { 0x0e7f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/2/c */
    { 0x0f00, 0x9471, 0xbca0, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/3/u */
    { 0x0f7f, 0x9471, 0x3c20, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xaecc1b1fb221666f,10297), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #39/3/3/c */
    { 0x0000, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/0/0/u */
    { 0x007f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/0/c */
    { 0x0100, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/0/1/u */
    { 0x017f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/1/c */
    { 0x0200, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/0/2/u */
    { 0x027f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/2/c */
    { 0x0300, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/0/3/u */
    { 0x037f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/0/3/c */
    { 0x0400, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/1/0/u */
    { 0x047f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/0/c */
    { 0x0500, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/1/1/u */
    { 0x057f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/1/c */
    { 0x0600, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/1/2/u */
    { 0x067f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/2/c */
    { 0x0700, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/1/3/u */
    { 0x077f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/1/3/c */
    { 0x0800, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/2/0/u */
    { 0x087f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/0/c */
    { 0x0900, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/2/1/u */
    { 0x097f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/1/c */
    { 0x0a00, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/2/2/u */
    { 0x0a7f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/2/c */
    { 0x0b00, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/2/3/u */
    { 0x0b7f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/2/3/c */
    { 0x0c00, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/3/0/u */
    { 0x0c7f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/0/c */
    { 0x0d00, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/3/1/u */
    { 0x0d7f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/1/c */
    { 0x0e00, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/3/2/u */
    { 0x0e7f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/2/c */
    { 0x0f00, 0x1c8b, 0xb481, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432) }, /* #40/3/3/u */
    { 0x0f7f, 0x1c8b, 0x3c01, RTFLOAT80U_INIT_C(1,0xef86bdb4b0e68a60,32767), RTFLOAT80U_INIT_C(1,0x786a5c9f809cd519,28432), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #40/3/3/c */
    { 0x0000, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/0/0/u */
    { 0x007f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/0/0/c */
    { 0x0100, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/0/1/u */
    { 0x017f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/0/1/c */
    { 0x0200, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/0/2/u */
    { 0x027f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/0/2/c */
    { 0x0300, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/0/3/u */
    { 0x037f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/0/3/c */
    { 0x0400, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/1/0/u */
    { 0x047f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/1/0/c */
    { 0x0500, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/1/1/u */
    { 0x057f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/1/1/c */
    { 0x0600, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/1/2/u */
    { 0x067f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/1/2/c */
    { 0x0700, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/1/3/u */
    { 0x077f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/1/3/c */
    { 0x0800, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/2/0/u */
    { 0x087f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/2/0/c */
    { 0x0900, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/2/1/u */
    { 0x097f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/2/1/c */
    { 0x0a00, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/2/2/u */
    { 0x0a7f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/2/2/c */
    { 0x0b00, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/2/3/u */
    { 0x0b7f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/2/3/c */
    { 0x0c00, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/3/0/u */
    { 0x0c7f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/3/0/c */
    { 0x0d00, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/3/1/u */
    { 0x0d7f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/3/1/c */
    { 0x0e00, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/3/2/u */
    { 0x0e7f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/3/2/c */
    { 0x0f00, 0x8beb, 0xb181, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726) }, /* #41/3/3/u */
    { 0x0f7f, 0x8beb, 0x3901, RTFLOAT80U_INIT_C(1,0x64e0c79c020c0be4,26030), RTFLOAT80U_INIT_C(1,0xe07213665507841b,7726), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #41/3/3/c */
    { 0x0000, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/0/0/u */
    { 0x007f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/0/c */
    { 0x0100, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/0/1/u */
    { 0x017f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/1/c */
    { 0x0200, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/0/2/u */
    { 0x027f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/2/c */
    { 0x0300, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/0/3/u */
    { 0x037f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/0/3/c */
    { 0x0400, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/1/0/u */
    { 0x047f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/0/c */
    { 0x0500, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/1/1/u */
    { 0x057f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/1/c */
    { 0x0600, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/1/2/u */
    { 0x067f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/2/c */
    { 0x0700, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/1/3/u */
    { 0x077f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/1/3/c */
    { 0x0800, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/2/0/u */
    { 0x087f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/0/c */
    { 0x0900, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/2/1/u */
    { 0x097f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/1/c */
    { 0x0a00, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/2/2/u */
    { 0x0a7f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/2/c */
    { 0x0b00, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/2/3/u */
    { 0x0b7f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/2/3/c */
    { 0x0c00, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/3/0/u */
    { 0x0c7f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/0/c */
    { 0x0d00, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/3/1/u */
    { 0x0d7f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/1/c */
    { 0x0e00, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/3/2/u */
    { 0x0e7f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/2/c */
    { 0x0f00, 0x8aa4, 0xb081, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302) }, /* #42/3/3/u */
    { 0x0f7f, 0x8aa4, 0x3801, RTFLOAT80U_INIT_C(1,0x2122b4bce59af849,13218), RTFLOAT80U_INIT_C(0,0x40490ef7f3471746,31302), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #42/3/3/c */
    { 0x0000, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/0/u */
    { 0x007f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/0/c */
    { 0x0100, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/1/u */
    { 0x017f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/1/c */
    { 0x0200, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/2/u */
    { 0x027f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/2/c */
    { 0x0300, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/3/u */
    { 0x037f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/0/3/c */
    { 0x0400, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/0/u */
    { 0x047f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/0/c */
    { 0x0500, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/1/u */
    { 0x057f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/1/c */
    { 0x0600, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/2/u */
    { 0x067f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/2/c */
    { 0x0700, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/3/u */
    { 0x077f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/1/3/c */
    { 0x0800, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/0/u */
    { 0x087f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/0/c */
    { 0x0900, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/1/u */
    { 0x097f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/1/c */
    { 0x0a00, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/2/u */
    { 0x0a7f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/2/c */
    { 0x0b00, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/3/u */
    { 0x0b7f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/2/3/c */
    { 0x0c00, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/0/u */
    { 0x0c7f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/0/c */
    { 0x0d00, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/1/u */
    { 0x0d7f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/1/c */
    { 0x0e00, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/2/u */
    { 0x0e7f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/2/c */
    { 0x0f00, 0x09a7, 0xb181, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/3/u */
    { 0x0f7f, 0x09a7, 0x3901, RTFLOAT80U_INIT_C(0,0xdac0627d83a16c1,4679), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #43/3/3/c */
    { 0x0000, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/0/0/u */
    { 0x007f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/0/c */
    { 0x0100, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/0/1/u */
    { 0x017f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/1/c */
    { 0x0200, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/0/2/u */
    { 0x027f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/2/c */
    { 0x0300, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/0/3/u */
    { 0x037f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/0/3/c */
    { 0x0400, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/1/0/u */
    { 0x047f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/0/c */
    { 0x0500, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/1/1/u */
    { 0x057f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/1/c */
    { 0x0600, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/1/2/u */
    { 0x067f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/2/c */
    { 0x0700, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/1/3/u */
    { 0x077f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/1/3/c */
    { 0x0800, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/2/0/u */
    { 0x087f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/0/c */
    { 0x0900, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/2/1/u */
    { 0x097f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/1/c */
    { 0x0a00, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/2/2/u */
    { 0x0a7f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/2/c */
    { 0x0b00, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/2/3/u */
    { 0x0b7f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/2/3/c */
    { 0x0c00, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/3/0/u */
    { 0x0c7f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/0/c */
    { 0x0d00, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/3/1/u */
    { 0x0d7f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/1/c */
    { 0x0e00, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/3/2/u */
    { 0x0e7f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/2/c */
    { 0x0f00, 0x34bc, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0) }, /* #44/3/3/u */
    { 0x0f7f, 0x34bc, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x800000001d48a192,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #44/3/3/c */
    { 0x0000, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/0/0/u */
    { 0x007f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/0/0/c */
    { 0x0100, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/0/1/u */
    { 0x017f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/0/1/c */
    { 0x0200, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/0/2/u */
    { 0x027f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/0/2/c */
    { 0x0300, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/0/3/u */
    { 0x037f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/0/3/c */
    { 0x0400, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/1/0/u */
    { 0x047f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/1/0/c */
    { 0x0500, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/1/1/u */
    { 0x057f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/1/1/c */
    { 0x0600, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/1/2/u */
    { 0x067f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/1/2/c */
    { 0x0700, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/1/3/u */
    { 0x077f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/1/3/c */
    { 0x0800, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/2/0/u */
    { 0x087f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/2/0/c */
    { 0x0900, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/2/1/u */
    { 0x097f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/2/1/c */
    { 0x0a00, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/2/2/u */
    { 0x0a7f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/2/2/c */
    { 0x0b00, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/2/3/u */
    { 0x0b7f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/2/3/c */
    { 0x0c00, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/3/0/u */
    { 0x0c7f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/3/0/c */
    { 0x0d00, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/3/1/u */
    { 0x0d7f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/3/1/c */
    { 0x0e00, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/3/2/u */
    { 0x0e7f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/3/2/c */
    { 0x0f00, 0x2377, 0xb181, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658) }, /* #45/3/3/u */
    { 0x0f7f, 0x2377, 0x3901, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6817ef5128a01e18,25658), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #45/3/3/c */
    { 0x0000, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/0/0/u */
    { 0x007f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/0/c */
    { 0x0100, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/0/1/u */
    { 0x017f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/1/c */
    { 0x0200, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/0/2/u */
    { 0x027f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/2/c */
    { 0x0300, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/0/3/u */
    { 0x037f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/0/3/c */
    { 0x0400, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/1/0/u */
    { 0x047f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/0/c */
    { 0x0500, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/1/1/u */
    { 0x057f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/1/c */
    { 0x0600, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/1/2/u */
    { 0x067f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/2/c */
    { 0x0700, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/1/3/u */
    { 0x077f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/1/3/c */
    { 0x0800, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/2/0/u */
    { 0x087f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/0/c */
    { 0x0900, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/2/1/u */
    { 0x097f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/1/c */
    { 0x0a00, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/2/2/u */
    { 0x0a7f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/2/c */
    { 0x0b00, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/2/3/u */
    { 0x0b7f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/2/3/c */
    { 0x0c00, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/3/0/u */
    { 0x0c7f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/0/c */
    { 0x0d00, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/3/1/u */
    { 0x0d7f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/1/c */
    { 0x0e00, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/3/2/u */
    { 0x0e7f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/2/c */
    { 0x0f00, 0xd6ff, 0xf481, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767) }, /* #46/3/3/u */
    { 0x0f7f, 0xd6ff, 0x7c01, RTFLOAT80U_INIT_C(0,0x432ec0acc23093ab,32425), RTFLOAT80U_INIT_C(1,0xc0071fe20509cc59,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #46/3/3/c */
    { 0x0000, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/0/u */
    { 0x007f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/0/c */
    { 0x0100, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/1/u */
    { 0x017f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/1/c */
    { 0x0200, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/2/u */
    { 0x027f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/2/c */
    { 0x0300, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/3/u */
    { 0x037f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/0/3/c */
    { 0x0400, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/0/u */
    { 0x047f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/0/c */
    { 0x0500, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/1/u */
    { 0x057f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/1/c */
    { 0x0600, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/2/u */
    { 0x067f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/2/c */
    { 0x0700, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/3/u */
    { 0x077f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/1/3/c */
    { 0x0800, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/0/u */
    { 0x087f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/0/c */
    { 0x0900, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/1/u */
    { 0x097f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/1/c */
    { 0x0a00, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/2/u */
    { 0x0a7f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/2/c */
    { 0x0b00, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/3/u */
    { 0x0b7f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/2/3/c */
    { 0x0c00, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/0/u */
    { 0x0c7f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/0/c */
    { 0x0d00, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/1/u */
    { 0x0d7f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/1/c */
    { 0x0e00, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/2/u */
    { 0x0e7f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/2/c */
    { 0x0f00, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/3/u */
    { 0x0f7f, 0xdd9d, 0x7d00, RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767), RTFLOAT80U_INIT_C(1,0xc8fbd4b8356d0752,8567), RTFLOAT80U_INIT_C(0,0xd10e310503830e08,32767) }, /* #47/3/3/c */
    { 0x0000, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/0/u */
    { 0x007f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/0/c */
    { 0x0100, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/1/u */
    { 0x017f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/1/c */
    { 0x0200, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/2/u */
    { 0x027f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/2/c */
    { 0x0300, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/3/u */
    { 0x037f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/0/3/c */
    { 0x0400, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/0/u */
    { 0x047f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/0/c */
    { 0x0500, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/1/u */
    { 0x057f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/1/c */
    { 0x0600, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/2/u */
    { 0x067f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/2/c */
    { 0x0700, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/3/u */
    { 0x077f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/1/3/c */
    { 0x0800, 0xfae7, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/0/u */
    { 0x087f, 0xfae7, 0x7a20, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/0/c */
    { 0x0900, 0xfae7, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/1/u */
    { 0x097f, 0xfae7, 0x7a20, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/1/c */
    { 0x0a00, 0xfae7, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/2/u */
    { 0x0a7f, 0xfae7, 0x7a20, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/2/c */
    { 0x0b00, 0xfae7, 0xfaa0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/3/u */
    { 0x0b7f, 0xfae7, 0x7a20, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866d,8340) }, /* #48/2/3/c */
    { 0x0c00, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/0/u */
    { 0x0c7f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/0/c */
    { 0x0d00, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/1/u */
    { 0x0d7f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/1/c */
    { 0x0e00, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/2/u */
    { 0x0e7f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/2/c */
    { 0x0f00, 0xfae7, 0xf8a0, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/3/u */
    { 0x0f7f, 0xfae7, 0x7820, RTFLOAT80U_INIT_C(0,0xa42dded5930baf7b,20921), RTFLOAT80U_INIT_C(0,0xb7a0d6f835298037,28963), RTFLOAT80U_INIT_C(0,0xe4e2b72ae292866c,8340) }, /* #48/3/3/c */
    { 0x0000, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/0/u */
    { 0x007f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/0/c */
    { 0x0100, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/1/u */
    { 0x017f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/1/c */
    { 0x0200, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/2/u */
    { 0x027f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/2/c */
    { 0x0300, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/3/u */
    { 0x037f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/0/3/c */
    { 0x0400, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/0/u */
    { 0x047f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/0/c */
    { 0x0500, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/1/u */
    { 0x057f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/1/c */
    { 0x0600, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/2/u */
    { 0x067f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/2/c */
    { 0x0700, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/3/u */
    { 0x077f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/1/3/c */
    { 0x0800, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/0/u */
    { 0x087f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/0/c */
    { 0x0900, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/1/u */
    { 0x097f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/1/c */
    { 0x0a00, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/2/u */
    { 0x0a7f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/2/c */
    { 0x0b00, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/3/u */
    { 0x0b7f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/2/3/c */
    { 0x0c00, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/0/u */
    { 0x0c7f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/0/c */
    { 0x0d00, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/1/u */
    { 0x0d7f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/1/c */
    { 0x0e00, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/2/u */
    { 0x0e7f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/2/c */
    { 0x0f00, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/3/u */
    { 0x0f7f, 0xb2dd, 0x3800, RTFLOAT80U_INIT_C(1,0xf0b8b8c93e8c5b37,11548), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #49/3/3/c */
    { 0x0000, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/0/u */
    { 0x007f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/0/c */
    { 0x0100, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/1/u */
    { 0x017f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/1/c */
    { 0x0200, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/2/u */
    { 0x027f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/2/c */
    { 0x0300, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/3/u */
    { 0x037f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/0/3/c */
    { 0x0400, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/0/u */
    { 0x047f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/0/c */
    { 0x0500, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/1/u */
    { 0x057f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/1/c */
    { 0x0600, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/2/u */
    { 0x067f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/2/c */
    { 0x0700, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/3/u */
    { 0x077f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/1/3/c */
    { 0x0800, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/0/u */
    { 0x087f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/0/c */
    { 0x0900, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/1/u */
    { 0x097f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/1/c */
    { 0x0a00, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/2/u */
    { 0x0a7f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/2/c */
    { 0x0b00, 0xa756, 0xbfa0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/3/u */
    { 0x0b7f, 0xa756, 0x3f20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #50/2/3/c */
    { 0x0c00, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/0/u */
    { 0x0c7f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/0/c */
    { 0x0d00, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/1/u */
    { 0x0d7f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/1/c */
    { 0x0e00, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/2/u */
    { 0x0e7f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/2/c */
    { 0x0f00, 0xa756, 0xbda0, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/3/u */
    { 0x0f7f, 0xa756, 0x3d20, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #50/3/3/c */
    { 0x0000, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/0/0/u */
    { 0x007f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/0/0/c */
    { 0x0100, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/0/1/u */
    { 0x017f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/0/1/c */
    { 0x0200, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/0/2/u */
    { 0x027f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/0/2/c */
    { 0x0300, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/0/3/u */
    { 0x037f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/0/3/c */
    { 0x0400, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/1/0/u */
    { 0x047f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/1/0/c */
    { 0x0500, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/1/1/u */
    { 0x057f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/1/1/c */
    { 0x0600, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/1/2/u */
    { 0x067f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/1/2/c */
    { 0x0700, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/1/3/u */
    { 0x077f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/1/3/c */
    { 0x0800, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/2/0/u */
    { 0x087f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/2/0/c */
    { 0x0900, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/2/1/u */
    { 0x097f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/2/1/c */
    { 0x0a00, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/2/2/u */
    { 0x0a7f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/2/2/c */
    { 0x0b00, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/2/3/u */
    { 0x0b7f, 0x13d5, 0x3b22, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #51/2/3/c */
    { 0x0c00, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/3/0/u */
    { 0x0c7f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/3/0/c */
    { 0x0d00, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/3/1/u */
    { 0x0d7f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/3/1/c */
    { 0x0e00, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/3/2/u */
    { 0x0e7f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/3/2/c */
    { 0x0f00, 0x13d5, 0xb182, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723) }, /* #51/3/3/u */
    { 0x0f7f, 0x13d5, 0x3922, RTFLOAT80U_INIT_C(0,0x34f5fa,0), RTFLOAT80U_INIT_C(1,0xf8972acbced7c82d,4723), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #51/3/3/c */
    { 0x0000, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/0/u */
    { 0x007f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/0/c */
    { 0x0100, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/1/u */
    { 0x017f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/1/c */
    { 0x0200, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/2/u */
    { 0x027f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/2/c */
    { 0x0300, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/3/u */
    { 0x037f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/0/3/c */
    { 0x0400, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/0/u */
    { 0x047f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/0/c */
    { 0x0500, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/1/u */
    { 0x057f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/1/c */
    { 0x0600, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/2/u */
    { 0x067f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/2/c */
    { 0x0700, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/3/u */
    { 0x077f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/1/3/c */
    { 0x0800, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/0/u */
    { 0x087f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/0/c */
    { 0x0900, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/1/u */
    { 0x097f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/1/c */
    { 0x0a00, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/2/u */
    { 0x0a7f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/2/c */
    { 0x0b00, 0x89e5, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/3/u */
    { 0x0b7f, 0x89e5, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #52/2/3/c */
    { 0x0c00, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/0/u */
    { 0x0c7f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/0/c */
    { 0x0d00, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/1/u */
    { 0x0d7f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/1/c */
    { 0x0e00, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/2/u */
    { 0x0e7f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/2/c */
    { 0x0f00, 0x89e5, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/3/u */
    { 0x0f7f, 0x89e5, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xb94fcc5b1e14186d,10389), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #52/3/3/c */
    { 0x0000, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/0/u */
    { 0x007f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/0/c */
    { 0x0100, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/1/u */
    { 0x017f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/1/c */
    { 0x0200, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/2/u */
    { 0x027f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/2/c */
    { 0x0300, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/3/u */
    { 0x037f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/0/3/c */
    { 0x0400, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/0/u */
    { 0x047f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/0/c */
    { 0x0500, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/1/u */
    { 0x057f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/1/c */
    { 0x0600, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/2/u */
    { 0x067f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/2/c */
    { 0x0700, 0xeb72, 0xfba0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/3/u */
    { 0x077f, 0xeb72, 0x7b20, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #53/1/3/c */
    { 0x0800, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/0/u */
    { 0x087f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/0/c */
    { 0x0900, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/1/u */
    { 0x097f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/1/c */
    { 0x0a00, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/2/u */
    { 0x0a7f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/2/c */
    { 0x0b00, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/3/u */
    { 0x0b7f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/2/3/c */
    { 0x0c00, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/0/u */
    { 0x0c7f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/0/c */
    { 0x0d00, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/1/u */
    { 0x0d7f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/1/c */
    { 0x0e00, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/2/u */
    { 0x0e7f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/2/c */
    { 0x0f00, 0xeb72, 0xf9a0, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/3/u */
    { 0x0f7f, 0xeb72, 0x7920, RTFLOAT80U_INIT_C(1,0x930f18e3efa7563e,26843), RTFLOAT80U_INIT_C(0,0xe4e185ad05304867,21657), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #53/3/3/c */
    { 0x0000, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/0/0/u */
    { 0x007f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/0/0/c */
    { 0x0100, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/0/1/u */
    { 0x017f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/0/1/c */
    { 0x0200, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/0/2/u */
    { 0x027f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/0/2/c */
    { 0x0300, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/0/3/u */
    { 0x037f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/0/3/c */
    { 0x0400, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/1/0/u */
    { 0x047f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/1/0/c */
    { 0x0500, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/1/1/u */
    { 0x057f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/1/1/c */
    { 0x0600, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/1/2/u */
    { 0x067f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/1/2/c */
    { 0x0700, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/1/3/u */
    { 0x077f, 0xd97c, 0x7b22, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #54/1/3/c */
    { 0x0800, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/2/0/u */
    { 0x087f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/2/0/c */
    { 0x0900, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/2/1/u */
    { 0x097f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/2/1/c */
    { 0x0a00, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/2/2/u */
    { 0x0a7f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/2/2/c */
    { 0x0b00, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/2/3/u */
    { 0x0b7f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/2/3/c */
    { 0x0c00, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/3/0/u */
    { 0x0c7f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/3/0/c */
    { 0x0d00, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/3/1/u */
    { 0x0d7f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/3/1/c */
    { 0x0e00, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/3/2/u */
    { 0x0e7f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/3/2/c */
    { 0x0f00, 0xd97c, 0xf182, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0) }, /* #54/3/3/u */
    { 0x0f7f, 0xd97c, 0x7922, RTFLOAT80U_INIT_C(1,0x802a7d6630f08ad4,13215), RTFLOAT80U_INIT_C(0,0x4a0ad7a7944eee7b,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #54/3/3/c */
    { 0x0000, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/0/0/u */
    { 0x007f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/0/0/c */
    { 0x0100, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/0/1/u */
    { 0x017f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/0/1/c */
    { 0x0200, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/0/2/u */
    { 0x027f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/0/2/c */
    { 0x0300, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/0/3/u */
    { 0x037f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/0/3/c */
    { 0x0400, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/1/0/u */
    { 0x047f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/1/0/c */
    { 0x0500, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/1/1/u */
    { 0x057f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/1/1/c */
    { 0x0600, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/1/2/u */
    { 0x067f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/1/2/c */
    { 0x0700, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/1/3/u */
    { 0x077f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/1/3/c */
    { 0x0800, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/2/0/u */
    { 0x087f, 0x7120, 0x7b22, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683051,16383) }, /* #55/2/0/c */
    { 0x0900, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/2/1/u */
    { 0x097f, 0x7120, 0x7b22, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683051,16383) }, /* #55/2/1/c */
    { 0x0a00, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/2/2/u */
    { 0x0a7f, 0x7120, 0x7b22, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683051,16383) }, /* #55/2/2/c */
    { 0x0b00, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/2/3/u */
    { 0x0b7f, 0x7120, 0x7b22, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683051,16383) }, /* #55/2/3/c */
    { 0x0c00, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/3/0/u */
    { 0x0c7f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/3/0/c */
    { 0x0d00, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/3/1/u */
    { 0x0d7f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/3/1/c */
    { 0x0e00, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/3/2/u */
    { 0x0e7f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/3/2/c */
    { 0x0f00, 0x7120, 0xf182, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0x3dd2,0) }, /* #55/3/3/u */
    { 0x0f7f, 0x7120, 0x7922, RTFLOAT80U_INIT_C(0,0x363d06b4e41368ac,0), RTFLOAT80U_INIT_C(0,0x3dd2,0), RTFLOAT80U_INIT_C(0,0xc90fdaa221683050,16383) }, /* #55/3/3/c */
    { 0x0000, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/0/u */
    { 0x007f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/0/c */
    { 0x0100, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/1/u */
    { 0x017f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/1/c */
    { 0x0200, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/2/u */
    { 0x027f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/2/c */
    { 0x0300, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/3/u */
    { 0x037f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/0/3/c */
    { 0x0400, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/0/u */
    { 0x047f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/0/c */
    { 0x0500, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/1/u */
    { 0x057f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/1/c */
    { 0x0600, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/2/u */
    { 0x067f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/2/c */
    { 0x0700, 0xb52d, 0xbfa0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/3/u */
    { 0x077f, 0xb52d, 0x3f20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #56/1/3/c */
    { 0x0800, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/0/u */
    { 0x087f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/0/c */
    { 0x0900, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/1/u */
    { 0x097f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/1/c */
    { 0x0a00, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/2/u */
    { 0x0a7f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/2/c */
    { 0x0b00, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/3/u */
    { 0x0b7f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/2/3/c */
    { 0x0c00, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/0/u */
    { 0x0c7f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/0/c */
    { 0x0d00, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/1/u */
    { 0x0d7f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/1/c */
    { 0x0e00, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/2/u */
    { 0x0e7f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/2/c */
    { 0x0f00, 0xb52d, 0xbda0, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/3/u */
    { 0x0f7f, 0xb52d, 0x3d20, RTFLOAT80U_INIT_C(1,0xe50716e32a4a1289,9234), RTFLOAT80U_INIT_C(0,0xd5b6fb28bea25db8,2619), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #56/3/3/c */
    { 0x0000, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/0/0/u */
    { 0x007f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/0/0/c */
    { 0x0100, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/0/1/u */
    { 0x017f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/0/1/c */
    { 0x0200, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/0/2/u */
    { 0x027f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/0/2/c */
    { 0x0300, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/0/3/u */
    { 0x037f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/0/3/c */
    { 0x0400, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/1/0/u */
    { 0x047f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/1/0/c */
    { 0x0500, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/1/1/u */
    { 0x057f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/1/1/c */
    { 0x0600, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/1/2/u */
    { 0x067f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/1/2/c */
    { 0x0700, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/1/3/u */
    { 0x077f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/1/3/c */
    { 0x0800, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/2/0/u */
    { 0x087f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/2/0/c */
    { 0x0900, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/2/1/u */
    { 0x097f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/2/1/c */
    { 0x0a00, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/2/2/u */
    { 0x0a7f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/2/2/c */
    { 0x0b00, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/2/3/u */
    { 0x0b7f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/2/3/c */
    { 0x0c00, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/3/0/u */
    { 0x0c7f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/3/0/c */
    { 0x0d00, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/3/1/u */
    { 0x0d7f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/3/1/c */
    { 0x0e00, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/3/2/u */
    { 0x0e7f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/3/2/c */
    { 0x0f00, 0x20da, 0xb081, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767) }, /* #57/3/3/u */
    { 0x0f7f, 0x20da, 0x3801, RTFLOAT80U_INIT_C(1,0x508577e252aec6eb,7911), RTFLOAT80U_INIT_C(1,0x35e21bb3ecb8459c,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #57/3/3/c */
    { 0x0000, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/0/u */
    { 0x007f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/0/c */
    { 0x0100, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/1/u */
    { 0x017f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/1/c */
    { 0x0200, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/2/u */
    { 0x027f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/2/c */
    { 0x0300, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/3/u */
    { 0x037f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/0/3/c */
    { 0x0400, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/0/u */
    { 0x047f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/0/c */
    { 0x0500, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/1/u */
    { 0x057f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/1/c */
    { 0x0600, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/2/u */
    { 0x067f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/2/c */
    { 0x0700, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/3/u */
    { 0x077f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/1/3/c */
    { 0x0800, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/0/u */
    { 0x087f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/0/c */
    { 0x0900, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/1/u */
    { 0x097f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/1/c */
    { 0x0a00, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/2/u */
    { 0x0a7f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/2/c */
    { 0x0b00, 0xe72b, 0xffa0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/3/u */
    { 0x0b7f, 0xe72b, 0x7f20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #58/2/3/c */
    { 0x0c00, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/0/u */
    { 0x0c7f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/0/c */
    { 0x0d00, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/1/u */
    { 0x0d7f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/1/c */
    { 0x0e00, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/2/u */
    { 0x0e7f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/2/c */
    { 0x0f00, 0xe72b, 0xfda0, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/3/u */
    { 0x0f7f, 0xe72b, 0x7d20, RTFLOAT80U_INIT_C(0,0xf83dd7fd56afee2d,24759), RTFLOAT80U_INIT_C(0,0x9f4c64415a3ffe3d,6216), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #58/3/3/c */
    { 0x0000, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/0/u */
    { 0x007f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/0/c */
    { 0x0100, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/1/u */
    { 0x017f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/1/c */
    { 0x0200, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/2/u */
    { 0x027f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/2/c */
    { 0x0300, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/3/u */
    { 0x037f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/0/3/c */
    { 0x0400, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/0/u */
    { 0x047f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/0/c */
    { 0x0500, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/1/u */
    { 0x057f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/1/c */
    { 0x0600, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/2/u */
    { 0x067f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/2/c */
    { 0x0700, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/3/u */
    { 0x077f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/1/3/c */
    { 0x0800, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/0/u */
    { 0x087f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/0/c */
    { 0x0900, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/1/u */
    { 0x097f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/1/c */
    { 0x0a00, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/2/u */
    { 0x0a7f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/2/c */
    { 0x0b00, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/3/u */
    { 0x0b7f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/2/3/c */
    { 0x0c00, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/0/u */
    { 0x0c7f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/0/c */
    { 0x0d00, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/1/u */
    { 0x0d7f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/1/c */
    { 0x0e00, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/2/u */
    { 0x0e7f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/2/c */
    { 0x0f00, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/3/u */
    { 0x0f7f, 0x32d2, 0x3800, RTFLOAT80U_INIT_C(0,0x8b717d2e67abf923,23776), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #59/3/3/c */
    { 0x0000, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/0/u */
    { 0x007f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/0/c */
    { 0x0100, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/1/u */
    { 0x017f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/1/c */
    { 0x0200, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/2/u */
    { 0x027f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/2/c */
    { 0x0300, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/3/u */
    { 0x037f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/0/3/c */
    { 0x0400, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/0/u */
    { 0x047f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/0/c */
    { 0x0500, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/1/u */
    { 0x057f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/1/c */
    { 0x0600, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/2/u */
    { 0x067f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/2/c */
    { 0x0700, 0x9390, 0xbba0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/3/u */
    { 0x077f, 0x9390, 0x3b20, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #60/1/3/c */
    { 0x0800, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/0/u */
    { 0x087f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/0/c */
    { 0x0900, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/1/u */
    { 0x097f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/1/c */
    { 0x0a00, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/2/u */
    { 0x0a7f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/2/c */
    { 0x0b00, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/3/u */
    { 0x0b7f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/2/3/c */
    { 0x0c00, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/0/u */
    { 0x0c7f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/0/c */
    { 0x0d00, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/1/u */
    { 0x0d7f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/1/c */
    { 0x0e00, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/2/u */
    { 0x0e7f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/2/c */
    { 0x0f00, 0x9390, 0xb9a0, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/3/u */
    { 0x0f7f, 0x9390, 0x3920, RTFLOAT80U_INIT_C(1,0x820d1a6195418b01,30759), RTFLOAT80U_INIT_C(0,0xb2433cacf81423ef,23035), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #60/3/3/c */
    { 0x0000, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/0/0/u */
    { 0x007f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/0/0/c */
    { 0x0100, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/0/1/u */
    { 0x017f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/0/1/c */
    { 0x0200, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/0/2/u */
    { 0x027f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/0/2/c */
    { 0x0300, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/0/3/u */
    { 0x037f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/0/3/c */
    { 0x0400, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/1/0/u */
    { 0x047f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/1/0/c */
    { 0x0500, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/1/1/u */
    { 0x057f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/1/1/c */
    { 0x0600, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/1/2/u */
    { 0x067f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/1/2/c */
    { 0x0700, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/1/3/u */
    { 0x077f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/1/3/c */
    { 0x0800, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/2/0/u */
    { 0x087f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/2/0/c */
    { 0x0900, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/2/1/u */
    { 0x097f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/2/1/c */
    { 0x0a00, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/2/2/u */
    { 0x0a7f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/2/2/c */
    { 0x0b00, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/2/3/u */
    { 0x0b7f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/2/3/c */
    { 0x0c00, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/3/0/u */
    { 0x0c7f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/3/0/c */
    { 0x0d00, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/3/1/u */
    { 0x0d7f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/3/1/c */
    { 0x0e00, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/3/2/u */
    { 0x0e7f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/3/2/c */
    { 0x0f00, 0x8cd0, 0xb481, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107) }, /* #61/3/3/u */
    { 0x0f7f, 0x8cd0, 0x3c01, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0x6c56d9fa01251ffc,17107), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #61/3/3/c */
    { 0x0000, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/0/u */
    { 0x007f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/0/c */
    { 0x0100, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/1/u */
    { 0x017f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/1/c */
    { 0x0200, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/2/u */
    { 0x027f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/2/c */
    { 0x0300, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/3/u */
    { 0x037f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/0/3/c */
    { 0x0400, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/0/u */
    { 0x047f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/0/c */
    { 0x0500, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/1/u */
    { 0x057f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/1/c */
    { 0x0600, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/2/u */
    { 0x067f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/2/c */
    { 0x0700, 0xb8f6, 0xbaa0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/3/u */
    { 0x077f, 0xb8f6, 0x3a20, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #62/1/3/c */
    { 0x0800, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/0/u */
    { 0x087f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/0/c */
    { 0x0900, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/1/u */
    { 0x097f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/1/c */
    { 0x0a00, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/2/u */
    { 0x0a7f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/2/c */
    { 0x0b00, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/3/u */
    { 0x0b7f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/2/3/c */
    { 0x0c00, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/0/u */
    { 0x0c7f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/0/c */
    { 0x0d00, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/1/u */
    { 0x0d7f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/1/c */
    { 0x0e00, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/2/u */
    { 0x0e7f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/2/c */
    { 0x0f00, 0xb8f6, 0xb8a0, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/3/u */
    { 0x0f7f, 0xb8f6, 0x3820, RTFLOAT80U_INIT_C(1,0x970a8eda1265c391,5639), RTFLOAT80U_INIT_C(1,0xb521079d8f2c8a23,28587), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #62/3/3/c */
    { 0x0000, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/0/0/u */
    { 0x007f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/0/c */
    { 0x0100, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/0/1/u */
    { 0x017f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/1/c */
    { 0x0200, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/0/2/u */
    { 0x027f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/2/c */
    { 0x0300, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/0/3/u */
    { 0x037f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/0/3/c */
    { 0x0400, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/1/0/u */
    { 0x047f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/0/c */
    { 0x0500, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/1/1/u */
    { 0x057f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/1/c */
    { 0x0600, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/1/2/u */
    { 0x067f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/2/c */
    { 0x0700, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/1/3/u */
    { 0x077f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/1/3/c */
    { 0x0800, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/2/0/u */
    { 0x087f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/0/c */
    { 0x0900, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/2/1/u */
    { 0x097f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/1/c */
    { 0x0a00, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/2/2/u */
    { 0x0a7f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/2/c */
    { 0x0b00, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/2/3/u */
    { 0x0b7f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/2/3/c */
    { 0x0c00, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/3/0/u */
    { 0x0c7f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/0/c */
    { 0x0d00, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/3/1/u */
    { 0x0d7f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/1/c */
    { 0x0e00, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/3/2/u */
    { 0x0e7f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/2/c */
    { 0x0f00, 0x78e6, 0xf081, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672) }, /* #63/3/3/u */
    { 0x0f7f, 0x78e6, 0x7801, RTFLOAT80U_INIT_C(0,0x800000008f336d5c,0), RTFLOAT80U_INIT_C(1,0x30ffc325cc4a8768,27672), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #63/3/3/c */
    { 0x0000, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/0/u */
    { 0x007f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/0/c */
    { 0x0100, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/1/u */
    { 0x017f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/1/c */
    { 0x0200, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/2/u */
    { 0x027f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/2/c */
    { 0x0300, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/3/u */
    { 0x037f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/0/3/c */
    { 0x0400, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/0/u */
    { 0x047f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/0/c */
    { 0x0500, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/1/u */
    { 0x057f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/1/c */
    { 0x0600, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/2/u */
    { 0x067f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/2/c */
    { 0x0700, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/3/u */
    { 0x077f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/1/3/c */
    { 0x0800, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/0/u */
    { 0x087f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/0/c */
    { 0x0900, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/1/u */
    { 0x097f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/1/c */
    { 0x0a00, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/2/u */
    { 0x0a7f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/2/c */
    { 0x0b00, 0x05ac, 0xbfa0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/3/u */
    { 0x0b7f, 0x05ac, 0x3f20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #64/2/3/c */
    { 0x0c00, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/0/u */
    { 0x0c7f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/0/c */
    { 0x0d00, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/1/u */
    { 0x0d7f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/1/c */
    { 0x0e00, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/2/u */
    { 0x0e7f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/2/c */
    { 0x0f00, 0x05ac, 0xbda0, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/3/u */
    { 0x0f7f, 0x05ac, 0x3d20, RTFLOAT80U_INIT_C(0,0x8b99f6b9e0a94f5f,4725), RTFLOAT80U_INIT_C(1,0xdc4cd90cbea56411,12631), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #64/3/3/c */
    { 0x0000, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/0/0/u */
    { 0x007f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/0/c */
    { 0x0100, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/0/1/u */
    { 0x017f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/1/c */
    { 0x0200, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/0/2/u */
    { 0x027f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/2/c */
    { 0x0300, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/0/3/u */
    { 0x037f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/0/3/c */
    { 0x0400, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/1/0/u */
    { 0x047f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/0/c */
    { 0x0500, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/1/1/u */
    { 0x057f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/1/c */
    { 0x0600, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/1/2/u */
    { 0x067f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/2/c */
    { 0x0700, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/1/3/u */
    { 0x077f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/1/3/c */
    { 0x0800, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/2/0/u */
    { 0x087f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/0/c */
    { 0x0900, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/2/1/u */
    { 0x097f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/1/c */
    { 0x0a00, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/2/2/u */
    { 0x0a7f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/2/c */
    { 0x0b00, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/2/3/u */
    { 0x0b7f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/2/3/c */
    { 0x0c00, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/3/0/u */
    { 0x0c7f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/0/c */
    { 0x0d00, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/3/1/u */
    { 0x0d7f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/1/c */
    { 0x0e00, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/3/2/u */
    { 0x0e7f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/2/c */
    { 0x0f00, 0x05ac, 0xb581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895) }, /* #65/3/3/u */
    { 0x0f7f, 0x05ac, 0x3d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,7906), RTFLOAT80U_INIT_C(1,0x6c62692830a52dce,30895), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #65/3/3/c */
    { 0x0000, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/0/0/u */
    { 0x007f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/0/c */
    { 0x0100, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/0/1/u */
    { 0x017f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/1/c */
    { 0x0200, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/0/2/u */
    { 0x027f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/2/c */
    { 0x0300, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/0/3/u */
    { 0x037f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/0/3/c */
    { 0x0400, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/1/0/u */
    { 0x047f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/0/c */
    { 0x0500, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/1/1/u */
    { 0x057f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/1/c */
    { 0x0600, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/1/2/u */
    { 0x067f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/2/c */
    { 0x0700, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/1/3/u */
    { 0x077f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/1/3/c */
    { 0x0800, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/2/0/u */
    { 0x087f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/0/c */
    { 0x0900, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/2/1/u */
    { 0x097f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/1/c */
    { 0x0a00, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/2/2/u */
    { 0x0a7f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/2/c */
    { 0x0b00, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/2/3/u */
    { 0x0b7f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/2/3/c */
    { 0x0c00, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/3/0/u */
    { 0x0c7f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/0/c */
    { 0x0d00, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/3/1/u */
    { 0x0d7f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/1/c */
    { 0x0e00, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/3/2/u */
    { 0x0e7f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/2/c */
    { 0x0f00, 0x054d, 0xb581, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0x1f8b28,32289) }, /* #66/3/3/u */
    { 0x0f7f, 0x054d, 0x3d01, RTFLOAT80U_INIT_C(0,0x69198c1e5d8b5f3c,15226), RTFLOAT80U_INIT_C(1,0x1f8b28,32289), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #66/3/3/c */
    { 0x0000, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/0/u */
    { 0x007f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/0/c */
    { 0x0100, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/1/u */
    { 0x017f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/1/c */
    { 0x0200, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/2/u */
    { 0x027f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/2/c */
    { 0x0300, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/3/u */
    { 0x037f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/0/3/c */
    { 0x0400, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/0/u */
    { 0x047f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/0/c */
    { 0x0500, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/1/u */
    { 0x057f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/1/c */
    { 0x0600, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/2/u */
    { 0x067f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/2/c */
    { 0x0700, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/3/u */
    { 0x077f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/1/3/c */
    { 0x0800, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/0/u */
    { 0x087f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/0/c */
    { 0x0900, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/1/u */
    { 0x097f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/1/c */
    { 0x0a00, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/2/u */
    { 0x0a7f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/2/c */
    { 0x0b00, 0xf526, 0xffa0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/3/u */
    { 0x0b7f, 0xf526, 0x7f20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #67/2/3/c */
    { 0x0c00, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/0/u */
    { 0x0c7f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/0/c */
    { 0x0d00, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/1/u */
    { 0x0d7f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/1/c */
    { 0x0e00, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/2/u */
    { 0x0e7f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/2/c */
    { 0x0f00, 0xf526, 0xfda0, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/3/u */
    { 0x0f7f, 0xf526, 0x7d20, RTFLOAT80U_INIT_C(0,0xf371bc7f9a54098e,20539), RTFLOAT80U_INIT_C(1,0xe8e22df70bb63b1a,26860), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #67/3/3/c */
    { 0x0000, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/0/u */
    { 0x007f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/0/c */
    { 0x0100, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/1/u */
    { 0x017f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/1/c */
    { 0x0200, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/2/u */
    { 0x027f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/2/c */
    { 0x0300, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/3/u */
    { 0x037f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/0/3/c */
    { 0x0400, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/0/u */
    { 0x047f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/0/c */
    { 0x0500, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/1/u */
    { 0x057f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/1/c */
    { 0x0600, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/2/u */
    { 0x067f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/2/c */
    { 0x0700, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/3/u */
    { 0x077f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/1/3/c */
    { 0x0800, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/0/u */
    { 0x087f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/0/c */
    { 0x0900, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/1/u */
    { 0x097f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/1/c */
    { 0x0a00, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/2/u */
    { 0x0a7f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/2/c */
    { 0x0b00, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/3/u */
    { 0x0b7f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/2/3/c */
    { 0x0c00, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/0/u */
    { 0x0c7f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/0/c */
    { 0x0d00, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/1/u */
    { 0x0d7f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/1/c */
    { 0x0e00, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/2/u */
    { 0x0e7f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/2/c */
    { 0x0f00, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/3/u */
    { 0x0f7f, 0x2580, 0x3d00, RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xfa9956e591decdcd,32767) }, /* #68/3/3/c */
    { 0x0000, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/0/u */
    { 0x007f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/0/c */
    { 0x0100, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/1/u */
    { 0x017f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/1/c */
    { 0x0200, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/2/u */
    { 0x027f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/2/c */
    { 0x0300, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/3/u */
    { 0x037f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/0/3/c */
    { 0x0400, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/0/u */
    { 0x047f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/0/c */
    { 0x0500, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/1/u */
    { 0x057f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/1/c */
    { 0x0600, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/2/u */
    { 0x067f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/2/c */
    { 0x0700, 0x65e1, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/3/u */
    { 0x077f, 0x65e1, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16382) }, /* #69/1/3/c */
    { 0x0800, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/0/u */
    { 0x087f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/0/c */
    { 0x0900, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/1/u */
    { 0x097f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/1/c */
    { 0x0a00, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/2/u */
    { 0x0a7f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/2/c */
    { 0x0b00, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/3/u */
    { 0x0b7f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/2/3/c */
    { 0x0c00, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/0/u */
    { 0x0c7f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/0/c */
    { 0x0d00, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/1/u */
    { 0x0d7f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/1/c */
    { 0x0e00, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/2/u */
    { 0x0e7f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/2/c */
    { 0x0f00, 0x65e1, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/3/u */
    { 0x0f7f, 0x65e1, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16382) }, /* #69/3/3/c */
    { 0x0000, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/0/0/u */
    { 0x007f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/0/c */
    { 0x0100, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/0/1/u */
    { 0x017f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/1/c */
    { 0x0200, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/0/2/u */
    { 0x027f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/2/c */
    { 0x0300, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/0/3/u */
    { 0x037f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/0/3/c */
    { 0x0400, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/1/0/u */
    { 0x047f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/0/c */
    { 0x0500, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/1/1/u */
    { 0x057f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/1/c */
    { 0x0600, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/1/2/u */
    { 0x067f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/2/c */
    { 0x0700, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/1/3/u */
    { 0x077f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/1/3/c */
    { 0x0800, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/2/0/u */
    { 0x087f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/0/c */
    { 0x0900, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/2/1/u */
    { 0x097f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/1/c */
    { 0x0a00, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/2/2/u */
    { 0x0a7f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/2/c */
    { 0x0b00, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/2/3/u */
    { 0x0b7f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/2/3/c */
    { 0x0c00, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/3/0/u */
    { 0x0c7f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/0/c */
    { 0x0d00, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/3/1/u */
    { 0x0d7f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/1/c */
    { 0x0e00, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/3/2/u */
    { 0x0e7f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/2/c */
    { 0x0f00, 0x9d94, 0xb581, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(0,0xd,2648) }, /* #70/3/3/u */
    { 0x0f7f, 0x9d94, 0x3d01, RTFLOAT80U_INIT_C(1,0x14c222502dacb,32767), RTFLOAT80U_INIT_C(0,0xd,2648), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #70/3/3/c */
    { 0x0000, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/0/u */
    { 0x007f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/0/c */
    { 0x0100, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/1/u */
    { 0x017f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/1/c */
    { 0x0200, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/2/u */
    { 0x027f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/2/c */
    { 0x0300, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/3/u */
    { 0x037f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/0/3/c */
    { 0x0400, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/0/u */
    { 0x047f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/0/c */
    { 0x0500, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/1/u */
    { 0x057f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/1/c */
    { 0x0600, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/2/u */
    { 0x067f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/2/c */
    { 0x0700, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/3/u */
    { 0x077f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/1/3/c */
    { 0x0800, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/0/u */
    { 0x087f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/0/c */
    { 0x0900, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/1/u */
    { 0x097f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/1/c */
    { 0x0a00, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/2/u */
    { 0x0a7f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/2/c */
    { 0x0b00, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/3/u */
    { 0x0b7f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/2/3/c */
    { 0x0c00, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/0/u */
    { 0x0c7f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/0/c */
    { 0x0d00, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/1/u */
    { 0x0d7f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/1/c */
    { 0x0e00, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/2/u */
    { 0x0e7f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/2/c */
    { 0x0f00, 0x1e9d, 0xb481, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/3/u */
    { 0x0f7f, 0x1e9d, 0x3c01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #71/3/3/c */
    { 0x0000, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/0/u */
    { 0x007f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/0/c */
    { 0x0100, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/1/u */
    { 0x017f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/1/c */
    { 0x0200, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/2/u */
    { 0x027f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/2/c */
    { 0x0300, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/3/u */
    { 0x037f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/0/3/c */
    { 0x0400, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/0/u */
    { 0x047f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/0/c */
    { 0x0500, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/1/u */
    { 0x057f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/1/c */
    { 0x0600, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/2/u */
    { 0x067f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/2/c */
    { 0x0700, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/3/u */
    { 0x077f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/1/3/c */
    { 0x0800, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/0/u */
    { 0x087f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/0/c */
    { 0x0900, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/1/u */
    { 0x097f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/1/c */
    { 0x0a00, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/2/u */
    { 0x0a7f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/2/c */
    { 0x0b00, 0xe2d9, 0xfaa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/3/u */
    { 0x0b7f, 0xe2d9, 0x7a20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #72/2/3/c */
    { 0x0c00, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/0/u */
    { 0x0c7f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/0/c */
    { 0x0d00, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/1/u */
    { 0x0d7f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/1/c */
    { 0x0e00, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/2/u */
    { 0x0e7f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/2/c */
    { 0x0f00, 0xe2d9, 0xf8a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/3/u */
    { 0x0f7f, 0xe2d9, 0x7820, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa81b887b56c041bb,30882), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #72/3/3/c */
    { 0x0000, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/0/0/u */
    { 0x007f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/0/0/c */
    { 0x0100, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/0/1/u */
    { 0x017f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/0/1/c */
    { 0x0200, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/0/2/u */
    { 0x027f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/0/2/c */
    { 0x0300, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/0/3/u */
    { 0x037f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/0/3/c */
    { 0x0400, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/1/0/u */
    { 0x047f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/1/0/c */
    { 0x0500, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/1/1/u */
    { 0x057f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/1/1/c */
    { 0x0600, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/1/2/u */
    { 0x067f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/1/2/c */
    { 0x0700, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/1/3/u */
    { 0x077f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/1/3/c */
    { 0x0800, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/2/0/u */
    { 0x087f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/2/0/c */
    { 0x0900, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/2/1/u */
    { 0x097f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/2/1/c */
    { 0x0a00, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/2/2/u */
    { 0x0a7f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/2/2/c */
    { 0x0b00, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/2/3/u */
    { 0x0b7f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/2/3/c */
    { 0x0c00, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/3/0/u */
    { 0x0c7f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/3/0/c */
    { 0x0d00, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/3/1/u */
    { 0x0d7f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/3/1/c */
    { 0x0e00, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/3/2/u */
    { 0x0e7f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/3/2/c */
    { 0x0f00, 0x1beb, 0xb181, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775) }, /* #73/3/3/u */
    { 0x0f7f, 0x1beb, 0x3901, RTFLOAT80U_INIT_C(0,0x4568f72fcf8d4bc3,12655), RTFLOAT80U_INIT_C(1,0xfb84f8a8f2bc9799,31775), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #73/3/3/c */
    { 0x0000, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/0/u */
    { 0x007f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/0/c */
    { 0x0100, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/1/u */
    { 0x017f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/1/c */
    { 0x0200, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/2/u */
    { 0x027f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/2/c */
    { 0x0300, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/3/u */
    { 0x037f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/0/3/c */
    { 0x0400, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/0/u */
    { 0x047f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/0/c */
    { 0x0500, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/1/u */
    { 0x057f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/1/c */
    { 0x0600, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/2/u */
    { 0x067f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/2/c */
    { 0x0700, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/3/u */
    { 0x077f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/1/3/c */
    { 0x0800, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/0/u */
    { 0x087f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/0/c */
    { 0x0900, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/1/u */
    { 0x097f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/1/c */
    { 0x0a00, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/2/u */
    { 0x0a7f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/2/c */
    { 0x0b00, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/3/u */
    { 0x0b7f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/2/3/c */
    { 0x0c00, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/0/u */
    { 0x0c7f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/0/c */
    { 0x0d00, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/1/u */
    { 0x0d7f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/1/c */
    { 0x0e00, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/2/u */
    { 0x0e7f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/2/c */
    { 0x0f00, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/3/u */
    { 0x0f7f, 0x9561, 0x3d00, RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767), RTFLOAT80U_INIT_C(0,0x8000033ed665fcea,0), RTFLOAT80U_INIT_C(1,0xc0001e4ccccdcf92,32767) }, /* #74/3/3/c */
    { 0x0000, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/0/0/u */
    { 0x007f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/0/0/c */
    { 0x0100, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/0/1/u */
    { 0x017f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/0/1/c */
    { 0x0200, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/0/2/u */
    { 0x027f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/0/2/c */
    { 0x0300, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/0/3/u */
    { 0x037f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/0/3/c */
    { 0x0400, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/1/0/u */
    { 0x047f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/1/0/c */
    { 0x0500, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/1/1/u */
    { 0x057f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/1/1/c */
    { 0x0600, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/1/2/u */
    { 0x067f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/1/2/c */
    { 0x0700, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/1/3/u */
    { 0x077f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/1/3/c */
    { 0x0800, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/2/0/u */
    { 0x087f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/2/0/c */
    { 0x0900, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/2/1/u */
    { 0x097f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/2/1/c */
    { 0x0a00, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/2/2/u */
    { 0x0a7f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/2/2/c */
    { 0x0b00, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/2/3/u */
    { 0x0b7f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/2/3/c */
    { 0x0c00, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/3/0/u */
    { 0x0c7f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/3/0/c */
    { 0x0d00, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/3/1/u */
    { 0x0d7f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/3/1/c */
    { 0x0e00, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/3/2/u */
    { 0x0e7f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/3/2/c */
    { 0x0f00, 0x4f08, 0xf582, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0) }, /* #75/3/3/u */
    { 0x0f7f, 0x4f08, 0x7d02, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0xbe3887d011d9fc23,0), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #75/3/3/c */
    { 0x0000, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/0/0/u */
    { 0x007f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/0/c */
    { 0x0100, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/0/1/u */
    { 0x017f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/1/c */
    { 0x0200, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/0/2/u */
    { 0x027f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/2/c */
    { 0x0300, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/0/3/u */
    { 0x037f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/0/3/c */
    { 0x0400, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/1/0/u */
    { 0x047f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/0/c */
    { 0x0500, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/1/1/u */
    { 0x057f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/1/c */
    { 0x0600, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/1/2/u */
    { 0x067f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/2/c */
    { 0x0700, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/1/3/u */
    { 0x077f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/1/3/c */
    { 0x0800, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/2/0/u */
    { 0x087f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/0/c */
    { 0x0900, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/2/1/u */
    { 0x097f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/1/c */
    { 0x0a00, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/2/2/u */
    { 0x0a7f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/2/c */
    { 0x0b00, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/2/3/u */
    { 0x0b7f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/2/3/c */
    { 0x0c00, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/3/0/u */
    { 0x0c7f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/0/c */
    { 0x0d00, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/3/1/u */
    { 0x0d7f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/1/c */
    { 0x0e00, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/3/2/u */
    { 0x0e7f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/2/c */
    { 0x0f00, 0x08e7, 0xb081, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732) }, /* #76/3/3/u */
    { 0x0f7f, 0x08e7, 0x3801, RTFLOAT80U_INIT_C(1,0xb8a1da6a4381b53d,8965), RTFLOAT80U_INIT_C(1,0x4910c4b2bcddd9f6,1732), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #76/3/3/c */
    { 0x0000, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/0/0/u */
    { 0x007f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/0/c */
    { 0x0100, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/0/1/u */
    { 0x017f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/1/c */
    { 0x0200, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/0/2/u */
    { 0x027f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/2/c */
    { 0x0300, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/0/3/u */
    { 0x037f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/0/3/c */
    { 0x0400, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/1/0/u */
    { 0x047f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/0/c */
    { 0x0500, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/1/1/u */
    { 0x057f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/1/c */
    { 0x0600, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/1/2/u */
    { 0x067f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/2/c */
    { 0x0700, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/1/3/u */
    { 0x077f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/1/3/c */
    { 0x0800, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/2/0/u */
    { 0x087f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/0/c */
    { 0x0900, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/2/1/u */
    { 0x097f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/1/c */
    { 0x0a00, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/2/2/u */
    { 0x0a7f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/2/c */
    { 0x0b00, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/2/3/u */
    { 0x0b7f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/2/3/c */
    { 0x0c00, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/3/0/u */
    { 0x0c7f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/0/c */
    { 0x0d00, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/3/1/u */
    { 0x0d7f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/1/c */
    { 0x0e00, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/3/2/u */
    { 0x0e7f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/2/c */
    { 0x0f00, 0x2702, 0xb581, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767) }, /* #77/3/3/u */
    { 0x0f7f, 0x2702, 0x3d01, RTFLOAT80U_INIT_C(1,0x72c1665e0a058e4d,24621), RTFLOAT80U_INIT_C(0,0xc59f26313a9ea5eb,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #77/3/3/c */
    { 0x0000, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/0/0/u */
    { 0x007f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/0/0/c */
    { 0x0100, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/0/1/u */
    { 0x017f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/0/1/c */
    { 0x0200, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/0/2/u */
    { 0x027f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/0/2/c */
    { 0x0300, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/0/3/u */
    { 0x037f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/0/3/c */
    { 0x0400, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/1/0/u */
    { 0x047f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/1/0/c */
    { 0x0500, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/1/1/u */
    { 0x057f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/1/1/c */
    { 0x0600, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/1/2/u */
    { 0x067f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/1/2/c */
    { 0x0700, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/1/3/u */
    { 0x077f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/1/3/c */
    { 0x0800, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/2/0/u */
    { 0x087f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/2/0/c */
    { 0x0900, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/2/1/u */
    { 0x097f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/2/1/c */
    { 0x0a00, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/2/2/u */
    { 0x0a7f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/2/2/c */
    { 0x0b00, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/2/3/u */
    { 0x0b7f, 0x2310, 0x3b22, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #78/2/3/c */
    { 0x0c00, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/3/0/u */
    { 0x0c7f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/3/0/c */
    { 0x0d00, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/3/1/u */
    { 0x0d7f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/3/1/c */
    { 0x0e00, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/3/2/u */
    { 0x0e7f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/3/2/c */
    { 0x0f00, 0x2310, 0xb182, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(1,0x16453,0) }, /* #78/3/3/u */
    { 0x0f7f, 0x2310, 0x3922, RTFLOAT80U_INIT_C(0,0xfb401b18979702e9,8048), RTFLOAT80U_INIT_C(1,0x16453,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #78/3/3/c */
    { 0x0000, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/0/0/u */
    { 0x007f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/0/0/c */
    { 0x0100, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/0/1/u */
    { 0x017f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/0/1/c */
    { 0x0200, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/0/2/u */
    { 0x027f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/0/2/c */
    { 0x0300, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/0/3/u */
    { 0x037f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/0/3/c */
    { 0x0400, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/1/0/u */
    { 0x047f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/1/0/c */
    { 0x0500, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/1/1/u */
    { 0x057f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/1/1/c */
    { 0x0600, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/1/2/u */
    { 0x067f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/1/2/c */
    { 0x0700, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/1/3/u */
    { 0x077f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/1/3/c */
    { 0x0800, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/2/0/u */
    { 0x087f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/2/0/c */
    { 0x0900, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/2/1/u */
    { 0x097f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/2/1/c */
    { 0x0a00, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/2/2/u */
    { 0x0a7f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/2/2/c */
    { 0x0b00, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/2/3/u */
    { 0x0b7f, 0x0ead, 0x3e22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #79/2/3/c */
    { 0x0c00, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/3/0/u */
    { 0x0c7f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/3/0/c */
    { 0x0d00, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/3/1/u */
    { 0x0d7f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/3/1/c */
    { 0x0e00, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/3/2/u */
    { 0x0e7f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/3/2/c */
    { 0x0f00, 0x0ead, 0xb482, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0) }, /* #79/3/3/u */
    { 0x0f7f, 0x0ead, 0x3c22, RTFLOAT80U_INIT_C(0,0x80ef56460d760b89,12024), RTFLOAT80U_INIT_C(0,0x1895bb2f75f1d7e7,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #79/3/3/c */
    { 0x0000, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/0/0/u */
    { 0x007f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/0/0/c */
    { 0x0100, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/0/1/u */
    { 0x017f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/0/1/c */
    { 0x0200, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/0/2/u */
    { 0x027f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/0/2/c */
    { 0x0300, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/0/3/u */
    { 0x037f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/0/3/c */
    { 0x0400, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/1/0/u */
    { 0x047f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/1/0/c */
    { 0x0500, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/1/1/u */
    { 0x057f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/1/1/c */
    { 0x0600, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/1/2/u */
    { 0x067f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/1/2/c */
    { 0x0700, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/1/3/u */
    { 0x077f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/1/3/c */
    { 0x0800, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/2/0/u */
    { 0x087f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/2/0/c */
    { 0x0900, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/2/1/u */
    { 0x097f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/2/1/c */
    { 0x0a00, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/2/2/u */
    { 0x0a7f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/2/2/c */
    { 0x0b00, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/2/3/u */
    { 0x0b7f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/2/3/c */
    { 0x0c00, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/3/0/u */
    { 0x0c7f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/3/0/c */
    { 0x0d00, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/3/1/u */
    { 0x0d7f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/3/1/c */
    { 0x0e00, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/3/2/u */
    { 0x0e7f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/3/2/c */
    { 0x0f00, 0x3157, 0xb181, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231) }, /* #80/3/3/u */
    { 0x0f7f, 0x3157, 0x3901, RTFLOAT80U_INIT_C(1,0xd0dfc218c4089aa1,24355), RTFLOAT80U_INIT_C(0,0x8ef5ffdb0,231), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #80/3/3/c */
    { 0x0000, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/0/0/u */
    { 0x007f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/0/c */
    { 0x0100, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/0/1/u */
    { 0x017f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/1/c */
    { 0x0200, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/0/2/u */
    { 0x027f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/2/c */
    { 0x0300, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/0/3/u */
    { 0x037f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/0/3/c */
    { 0x0400, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/1/0/u */
    { 0x047f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/0/c */
    { 0x0500, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/1/1/u */
    { 0x057f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/1/c */
    { 0x0600, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/1/2/u */
    { 0x067f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/2/c */
    { 0x0700, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/1/3/u */
    { 0x077f, 0x6a91, 0x7a22, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #81/1/3/c */
    { 0x0800, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/2/0/u */
    { 0x087f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/0/c */
    { 0x0900, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/2/1/u */
    { 0x097f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/1/c */
    { 0x0a00, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/2/2/u */
    { 0x0a7f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/2/c */
    { 0x0b00, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/2/3/u */
    { 0x0b7f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/2/3/c */
    { 0x0c00, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/3/0/u */
    { 0x0c7f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/0/c */
    { 0x0d00, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/3/1/u */
    { 0x0d7f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/1/c */
    { 0x0e00, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/3/2/u */
    { 0x0e7f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/2/c */
    { 0x0f00, 0x6a91, 0xf082, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758) }, /* #81/3/3/u */
    { 0x0f7f, 0x6a91, 0x7822, RTFLOAT80U_INIT_C(1,0x800008a5adad8ba9,0), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32758), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #81/3/3/c */
    { 0x0000, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/0/0/u */
    { 0x007f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/0/c */
    { 0x0100, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/0/1/u */
    { 0x017f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/1/c */
    { 0x0200, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/0/2/u */
    { 0x027f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/2/c */
    { 0x0300, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/0/3/u */
    { 0x037f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/0/3/c */
    { 0x0400, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/1/0/u */
    { 0x047f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/0/c */
    { 0x0500, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/1/1/u */
    { 0x057f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/1/c */
    { 0x0600, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/1/2/u */
    { 0x067f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/2/c */
    { 0x0700, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/1/3/u */
    { 0x077f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/1/3/c */
    { 0x0800, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/2/0/u */
    { 0x087f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/0/c */
    { 0x0900, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/2/1/u */
    { 0x097f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/1/c */
    { 0x0a00, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/2/2/u */
    { 0x0a7f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/2/c */
    { 0x0b00, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/2/3/u */
    { 0x0b7f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/2/3/c */
    { 0x0c00, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/3/0/u */
    { 0x0c7f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/0/c */
    { 0x0d00, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/3/1/u */
    { 0x0d7f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/1/c */
    { 0x0e00, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/3/2/u */
    { 0x0e7f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/2/c */
    { 0x0f00, 0xeed8, 0xf481, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221) }, /* #82/3/3/u */
    { 0x0f7f, 0xeed8, 0x7c01, RTFLOAT80U_INIT_C(0,0x59f93,23221), RTFLOAT80U_INIT_C(0,0x88bf8c8f7a3c3cdb,1221), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #82/3/3/c */
    { 0x0000, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/0/0/u */
    { 0x007f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/0/c */
    { 0x0100, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/0/1/u */
    { 0x017f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/1/c */
    { 0x0200, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/0/2/u */
    { 0x027f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/2/c */
    { 0x0300, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/0/3/u */
    { 0x037f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/0/3/c */
    { 0x0400, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/1/0/u */
    { 0x047f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/0/c */
    { 0x0500, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/1/1/u */
    { 0x057f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/1/c */
    { 0x0600, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/1/2/u */
    { 0x067f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/2/c */
    { 0x0700, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/1/3/u */
    { 0x077f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/1/3/c */
    { 0x0800, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/2/0/u */
    { 0x087f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/0/c */
    { 0x0900, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/2/1/u */
    { 0x097f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/1/c */
    { 0x0a00, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/2/2/u */
    { 0x0a7f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/2/c */
    { 0x0b00, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/2/3/u */
    { 0x0b7f, 0xd848, 0x7a22, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #83/2/3/c */
    { 0x0c00, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/3/0/u */
    { 0x0c7f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/0/c */
    { 0x0d00, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/3/1/u */
    { 0x0d7f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/1/c */
    { 0x0e00, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/3/2/u */
    { 0x0e7f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/2/c */
    { 0x0f00, 0xd848, 0xf082, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0) }, /* #83/3/3/u */
    { 0x0f7f, 0xd848, 0x7822, RTFLOAT80U_INIT_C(0,0xe49bf46506c7c228,18045), RTFLOAT80U_INIT_C(0,0x6c98cd67b09e5bbc,0), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #83/3/3/c */
    { 0x0000, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/0/0/u */
    { 0x007f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/0/c */
    { 0x0100, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/0/1/u */
    { 0x017f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/1/c */
    { 0x0200, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/0/2/u */
    { 0x027f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/2/c */
    { 0x0300, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/0/3/u */
    { 0x037f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/0/3/c */
    { 0x0400, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/1/0/u */
    { 0x047f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/0/c */
    { 0x0500, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/1/1/u */
    { 0x057f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/1/c */
    { 0x0600, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/1/2/u */
    { 0x067f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/2/c */
    { 0x0700, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/1/3/u */
    { 0x077f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/1/3/c */
    { 0x0800, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/2/0/u */
    { 0x087f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/0/c */
    { 0x0900, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/2/1/u */
    { 0x097f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/1/c */
    { 0x0a00, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/2/2/u */
    { 0x0a7f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/2/c */
    { 0x0b00, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/2/3/u */
    { 0x0b7f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/2/3/c */
    { 0x0c00, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/3/0/u */
    { 0x0c7f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/0/c */
    { 0x0d00, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/3/1/u */
    { 0x0d7f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/1/c */
    { 0x0e00, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/3/2/u */
    { 0x0e7f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/2/c */
    { 0x0f00, 0x476a, 0xf581, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767) }, /* #84/3/3/u */
    { 0x0f7f, 0x476a, 0x7d01, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,2629), RTFLOAT80U_INIT_C(0,0x4000023a37b372dd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #84/3/3/c */
    { 0x0000, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/0/0/u */
    { 0x007f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/0/c */
    { 0x0100, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/0/1/u */
    { 0x017f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/1/c */
    { 0x0200, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/0/2/u */
    { 0x027f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/2/c */
    { 0x0300, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/0/3/u */
    { 0x037f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/0/3/c */
    { 0x0400, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/1/0/u */
    { 0x047f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/0/c */
    { 0x0500, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/1/1/u */
    { 0x057f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/1/c */
    { 0x0600, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/1/2/u */
    { 0x067f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/2/c */
    { 0x0700, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/1/3/u */
    { 0x077f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/1/3/c */
    { 0x0800, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/2/0/u */
    { 0x087f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/0/c */
    { 0x0900, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/2/1/u */
    { 0x097f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/1/c */
    { 0x0a00, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/2/2/u */
    { 0x0a7f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/2/c */
    { 0x0b00, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/2/3/u */
    { 0x0b7f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/2/3/c */
    { 0x0c00, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/3/0/u */
    { 0x0c7f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/0/c */
    { 0x0d00, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/3/1/u */
    { 0x0d7f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/1/c */
    { 0x0e00, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/3/2/u */
    { 0x0e7f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/2/c */
    { 0x0f00, 0x750d, 0xf581, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279) }, /* #85/3/3/u */
    { 0x0f7f, 0x750d, 0x7d01, RTFLOAT80U_INIT_C(1,0x3dbcc47ffa9c9410,11862), RTFLOAT80U_INIT_C(1,0xe7a492c0ded2e4b2,12279), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #85/3/3/c */
    { 0x0000, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/0/0/u */
    { 0x007f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/0/0/c */
    { 0x0100, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/0/1/u */
    { 0x017f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/0/1/c */
    { 0x0200, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/0/2/u */
    { 0x027f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/0/2/c */
    { 0x0300, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/0/3/u */
    { 0x037f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/0/3/c */
    { 0x0400, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/1/0/u */
    { 0x047f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/1/0/c */
    { 0x0500, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/1/1/u */
    { 0x057f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/1/1/c */
    { 0x0600, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/1/2/u */
    { 0x067f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/1/2/c */
    { 0x0700, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/1/3/u */
    { 0x077f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/1/3/c */
    { 0x0800, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/2/0/u */
    { 0x087f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/2/0/c */
    { 0x0900, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/2/1/u */
    { 0x097f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/2/1/c */
    { 0x0a00, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/2/2/u */
    { 0x0a7f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/2/2/c */
    { 0x0b00, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/2/3/u */
    { 0x0b7f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/2/3/c */
    { 0x0c00, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/3/0/u */
    { 0x0c7f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/3/0/c */
    { 0x0d00, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/3/1/u */
    { 0x0d7f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/3/1/c */
    { 0x0e00, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/3/2/u */
    { 0x0e7f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/3/2/c */
    { 0x0f00, 0x15c9, 0xb581, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699) }, /* #86/3/3/u */
    { 0x0f7f, 0x15c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x5ee288f824bbb2f7,24991), RTFLOAT80U_INIT_C(0,0x5186e05e2aaf286,11699), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #86/3/3/c */
    { 0x0000, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/0/0/u */
    { 0x007f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/0/c */
    { 0x0100, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/0/1/u */
    { 0x017f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/1/c */
    { 0x0200, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/0/2/u */
    { 0x027f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/2/c */
    { 0x0300, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/0/3/u */
    { 0x037f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/0/3/c */
    { 0x0400, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/1/0/u */
    { 0x047f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/0/c */
    { 0x0500, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/1/1/u */
    { 0x057f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/1/c */
    { 0x0600, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/1/2/u */
    { 0x067f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/2/c */
    { 0x0700, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/1/3/u */
    { 0x077f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/1/3/c */
    { 0x0800, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/2/0/u */
    { 0x087f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/0/c */
    { 0x0900, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/2/1/u */
    { 0x097f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/1/c */
    { 0x0a00, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/2/2/u */
    { 0x0a7f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/2/c */
    { 0x0b00, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/2/3/u */
    { 0x0b7f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/2/3/c */
    { 0x0c00, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/3/0/u */
    { 0x0c7f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/0/c */
    { 0x0d00, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/3/1/u */
    { 0x0d7f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/1/c */
    { 0x0e00, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/3/2/u */
    { 0x0e7f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/2/c */
    { 0x0f00, 0xee28, 0xf481, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440) }, /* #87/3/3/u */
    { 0x0f7f, 0xee28, 0x7c01, RTFLOAT80U_INIT_C(1,0xb805413714d24266,16240), RTFLOAT80U_INIT_C(1,0x78da6b695d46661e,22440), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #87/3/3/c */
    { 0x0000, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/0/0/u */
    { 0x007f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/0/c */
    { 0x0100, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/0/1/u */
    { 0x017f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/1/c */
    { 0x0200, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/0/2/u */
    { 0x027f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/2/c */
    { 0x0300, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/0/3/u */
    { 0x037f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/0/3/c */
    { 0x0400, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/1/0/u */
    { 0x047f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/0/c */
    { 0x0500, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/1/1/u */
    { 0x057f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/1/c */
    { 0x0600, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/1/2/u */
    { 0x067f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/2/c */
    { 0x0700, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/1/3/u */
    { 0x077f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/1/3/c */
    { 0x0800, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/2/0/u */
    { 0x087f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/0/c */
    { 0x0900, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/2/1/u */
    { 0x097f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/1/c */
    { 0x0a00, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/2/2/u */
    { 0x0a7f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/2/c */
    { 0x0b00, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/2/3/u */
    { 0x0b7f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/2/3/c */
    { 0x0c00, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/3/0/u */
    { 0x0c7f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/0/c */
    { 0x0d00, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/3/1/u */
    { 0x0d7f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/1/c */
    { 0x0e00, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/3/2/u */
    { 0x0e7f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/2/c */
    { 0x0f00, 0xd3b5, 0xf181, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766) }, /* #88/3/3/u */
    { 0x0f7f, 0xd3b5, 0x7901, RTFLOAT80U_INIT_C(1,0x3b821378698ad,5019), RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #88/3/3/c */
    { 0x0000, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/0/u */
    { 0x007f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/0/c */
    { 0x0100, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/1/u */
    { 0x017f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/1/c */
    { 0x0200, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/2/u */
    { 0x027f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/2/c */
    { 0x0300, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/3/u */
    { 0x037f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/0/3/c */
    { 0x0400, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/0/u */
    { 0x047f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/0/c */
    { 0x0500, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/1/u */
    { 0x057f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/1/c */
    { 0x0600, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/2/u */
    { 0x067f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/2/c */
    { 0x0700, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/3/u */
    { 0x077f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/1/3/c */
    { 0x0800, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/0/u */
    { 0x087f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/0/c */
    { 0x0900, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/1/u */
    { 0x097f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/1/c */
    { 0x0a00, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/2/u */
    { 0x0a7f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/2/c */
    { 0x0b00, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/3/u */
    { 0x0b7f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/2/3/c */
    { 0x0c00, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/0/u */
    { 0x0c7f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/0/c */
    { 0x0d00, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/1/u */
    { 0x0d7f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/1/c */
    { 0x0e00, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/2/u */
    { 0x0e7f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/2/c */
    { 0x0f00, 0x4cc3, 0xf481, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/3/u */
    { 0x0f7f, 0x4cc3, 0x7c01, RTFLOAT80U_INIT_C(0,0x8000000000000037,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #89/3/3/c */
    { 0x0000, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/0/u */
    { 0x007f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/0/c */
    { 0x0100, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/1/u */
    { 0x017f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/1/c */
    { 0x0200, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/2/u */
    { 0x027f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/2/c */
    { 0x0300, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/3/u */
    { 0x037f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/0/3/c */
    { 0x0400, 0xd094, 0xfaa0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/0/u */
    { 0x047f, 0xd094, 0x7a20, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/0/c */
    { 0x0500, 0xd094, 0xfaa0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/1/u */
    { 0x057f, 0xd094, 0x7a20, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/1/c */
    { 0x0600, 0xd094, 0xfaa0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/2/u */
    { 0x067f, 0xd094, 0x7a20, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/2/c */
    { 0x0700, 0xd094, 0xfaa0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/3/u */
    { 0x077f, 0xd094, 0x7a20, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c5,4221) }, /* #90/1/3/c */
    { 0x0800, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/0/u */
    { 0x087f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/0/c */
    { 0x0900, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/1/u */
    { 0x097f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/1/c */
    { 0x0a00, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/2/u */
    { 0x0a7f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/2/c */
    { 0x0b00, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/3/u */
    { 0x0b7f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/2/3/c */
    { 0x0c00, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/0/u */
    { 0x0c7f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/0/c */
    { 0x0d00, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/1/u */
    { 0x0d7f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/1/c */
    { 0x0e00, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/2/u */
    { 0x0e7f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/2/c */
    { 0x0f00, 0xd094, 0xf8a0, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/3/u */
    { 0x0f7f, 0xd094, 0x7820, RTFLOAT80U_INIT_C(1,0xff747fd9c50d97f9,16622), RTFLOAT80U_INIT_C(0,0xa7fd366274136f7f,28784), RTFLOAT80U_INIT_C(1,0xc2a5224d197b93c4,4221) }, /* #90/3/3/c */
    { 0x0000, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/0/0/u */
    { 0x007f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/0/c */
    { 0x0100, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/0/1/u */
    { 0x017f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/1/c */
    { 0x0200, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/0/2/u */
    { 0x027f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/2/c */
    { 0x0300, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/0/3/u */
    { 0x037f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/0/3/c */
    { 0x0400, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/1/0/u */
    { 0x047f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/0/c */
    { 0x0500, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/1/1/u */
    { 0x057f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/1/c */
    { 0x0600, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/1/2/u */
    { 0x067f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/2/c */
    { 0x0700, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/1/3/u */
    { 0x077f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/1/3/c */
    { 0x0800, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/2/0/u */
    { 0x087f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/0/c */
    { 0x0900, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/2/1/u */
    { 0x097f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/1/c */
    { 0x0a00, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/2/2/u */
    { 0x0a7f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/2/c */
    { 0x0b00, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/2/3/u */
    { 0x0b7f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/2/3/c */
    { 0x0c00, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/3/0/u */
    { 0x0c7f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/0/c */
    { 0x0d00, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/3/1/u */
    { 0x0d7f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/1/c */
    { 0x0e00, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/3/2/u */
    { 0x0e7f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/2/c */
    { 0x0f00, 0xc48e, 0xf481, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771) }, /* #91/3/3/u */
    { 0x0f7f, 0xc48e, 0x7c01, RTFLOAT80U_INIT_C(1,0x652f78add685b8eb,32767), RTFLOAT80U_INIT_C(0,0xc62b89cf9a7153a9,30771), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #91/3/3/c */
    { 0x0000, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/0/0/u */
    { 0x007f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/0/c */
    { 0x0100, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/0/1/u */
    { 0x017f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/1/c */
    { 0x0200, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/0/2/u */
    { 0x027f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/2/c */
    { 0x0300, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/0/3/u */
    { 0x037f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/0/3/c */
    { 0x0400, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/1/0/u */
    { 0x047f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/0/c */
    { 0x0500, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/1/1/u */
    { 0x057f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/1/c */
    { 0x0600, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/1/2/u */
    { 0x067f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/2/c */
    { 0x0700, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/1/3/u */
    { 0x077f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/1/3/c */
    { 0x0800, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/2/0/u */
    { 0x087f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/0/c */
    { 0x0900, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/2/1/u */
    { 0x097f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/1/c */
    { 0x0a00, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/2/2/u */
    { 0x0a7f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/2/c */
    { 0x0b00, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/2/3/u */
    { 0x0b7f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/2/3/c */
    { 0x0c00, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/3/0/u */
    { 0x0c7f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/0/c */
    { 0x0d00, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/3/1/u */
    { 0x0d7f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/1/c */
    { 0x0e00, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/3/2/u */
    { 0x0e7f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/2/c */
    { 0x0f00, 0x5962, 0xf181, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871) }, /* #92/3/3/u */
    { 0x0f7f, 0x5962, 0x7901, RTFLOAT80U_INIT_C(0,0x4591ca73e1877ad7,26547), RTFLOAT80U_INIT_C(0,0x50a0115ff9600bb2,31871), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #92/3/3/c */
    { 0x0000, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/0/0/u */
    { 0x007f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/0/c */
    { 0x0100, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/0/1/u */
    { 0x017f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/1/c */
    { 0x0200, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/0/2/u */
    { 0x027f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/2/c */
    { 0x0300, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/0/3/u */
    { 0x037f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/0/3/c */
    { 0x0400, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/1/0/u */
    { 0x047f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/0/c */
    { 0x0500, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/1/1/u */
    { 0x057f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/1/c */
    { 0x0600, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/1/2/u */
    { 0x067f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/2/c */
    { 0x0700, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/1/3/u */
    { 0x077f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/1/3/c */
    { 0x0800, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/2/0/u */
    { 0x087f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/0/c */
    { 0x0900, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/2/1/u */
    { 0x097f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/1/c */
    { 0x0a00, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/2/2/u */
    { 0x0a7f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/2/c */
    { 0x0b00, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/2/3/u */
    { 0x0b7f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/2/3/c */
    { 0x0c00, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/3/0/u */
    { 0x0c7f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/0/c */
    { 0x0d00, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/3/1/u */
    { 0x0d7f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/1/c */
    { 0x0e00, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/3/2/u */
    { 0x0e7f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/2/c */
    { 0x0f00, 0xaafa, 0xb081, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0) }, /* #93/3/3/u */
    { 0x0f7f, 0xaafa, 0x3801, RTFLOAT80U_INIT_C(1,0x5bb65ff0,24217), RTFLOAT80U_INIT_C(1,0xb9deb466dce4ee63,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #93/3/3/c */
    { 0x0000, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/0/0/u */
    { 0x007f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/0/0/c */
    { 0x0100, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/0/1/u */
    { 0x017f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/0/1/c */
    { 0x0200, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/0/2/u */
    { 0x027f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/0/2/c */
    { 0x0300, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/0/3/u */
    { 0x037f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/0/3/c */
    { 0x0400, 0x1ef1, 0xbeb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3ba,13320) }, /* #94/1/0/u */
    { 0x047f, 0x1ef1, 0x3e30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #94/1/0/c */
    { 0x0500, 0x1ef1, 0xbeb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3ba,13320) }, /* #94/1/1/u */
    { 0x057f, 0x1ef1, 0x3e30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #94/1/1/c */
    { 0x0600, 0x1ef1, 0xbeb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3ba,13320) }, /* #94/1/2/u */
    { 0x067f, 0x1ef1, 0x3e30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #94/1/2/c */
    { 0x0700, 0x1ef1, 0xbeb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3ba,13320) }, /* #94/1/3/u */
    { 0x077f, 0x1ef1, 0x3e30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #94/1/3/c */
    { 0x0800, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/2/0/u */
    { 0x087f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/2/0/c */
    { 0x0900, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/2/1/u */
    { 0x097f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/2/1/c */
    { 0x0a00, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/2/2/u */
    { 0x0a7f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/2/2/c */
    { 0x0b00, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/2/3/u */
    { 0x0b7f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/2/3/c */
    { 0x0c00, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/3/0/u */
    { 0x0c7f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/3/0/c */
    { 0x0d00, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/3/1/u */
    { 0x0d7f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/3/1/c */
    { 0x0e00, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/3/2/u */
    { 0x0e7f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/3/2/c */
    { 0x0f00, 0x1ef1, 0xbcb0, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0xc08773bcc2aec3b9,13320) }, /* #94/3/3/u */
    { 0x0f7f, 0x1ef1, 0x3c30, RTFLOAT80U_INIT_C(1,0xd8af09e4b6802b9b,1336), RTFLOAT80U_INIT_C(0,0x900f0fd55c031bb1,28975), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #94/3/3/c */
    { 0x0000, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/0/0/u */
    { 0x007f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/0/c */
    { 0x0100, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/0/1/u */
    { 0x017f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/1/c */
    { 0x0200, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/0/2/u */
    { 0x027f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/2/c */
    { 0x0300, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/0/3/u */
    { 0x037f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/0/3/c */
    { 0x0400, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/1/0/u */
    { 0x047f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/0/c */
    { 0x0500, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/1/1/u */
    { 0x057f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/1/c */
    { 0x0600, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/1/2/u */
    { 0x067f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/2/c */
    { 0x0700, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/1/3/u */
    { 0x077f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/1/3/c */
    { 0x0800, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/2/0/u */
    { 0x087f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/0/c */
    { 0x0900, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/2/1/u */
    { 0x097f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/1/c */
    { 0x0a00, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/2/2/u */
    { 0x0a7f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/2/c */
    { 0x0b00, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/2/3/u */
    { 0x0b7f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/2/3/c */
    { 0x0c00, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/3/0/u */
    { 0x0c7f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/0/c */
    { 0x0d00, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/3/1/u */
    { 0x0d7f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/1/c */
    { 0x0e00, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/3/2/u */
    { 0x0e7f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/2/c */
    { 0x0f00, 0x51d4, 0xf181, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767) }, /* #95/3/3/u */
    { 0x0f7f, 0x51d4, 0x7901, RTFLOAT80U_INIT_C(1,0x4dc1e806104a8a5d,26872), RTFLOAT80U_INIT_C(0,0xc000000000e7b573,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #95/3/3/c */
    { 0x0000, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/0/0/u */
    { 0x007f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/0/0/c */
    { 0x0100, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/0/1/u */
    { 0x017f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/0/1/c */
    { 0x0200, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/0/2/u */
    { 0x027f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/0/2/c */
    { 0x0300, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/0/3/u */
    { 0x037f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/0/3/c */
    { 0x0400, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/1/0/u */
    { 0x047f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/1/0/c */
    { 0x0500, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/1/1/u */
    { 0x057f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/1/1/c */
    { 0x0600, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/1/2/u */
    { 0x067f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/1/2/c */
    { 0x0700, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/1/3/u */
    { 0x077f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/1/3/c */
    { 0x0800, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/2/0/u */
    { 0x087f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/2/0/c */
    { 0x0900, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/2/1/u */
    { 0x097f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/2/1/c */
    { 0x0a00, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/2/2/u */
    { 0x0a7f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/2/2/c */
    { 0x0b00, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/2/3/u */
    { 0x0b7f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/2/3/c */
    { 0x0c00, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/3/0/u */
    { 0x0c7f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/3/0/c */
    { 0x0d00, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/3/1/u */
    { 0x0d7f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/3/1/c */
    { 0x0e00, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/3/2/u */
    { 0x0e7f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/3/2/c */
    { 0x0f00, 0x0b25, 0xb181, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162) }, /* #96/3/3/u */
    { 0x0f7f, 0x0b25, 0x3901, RTFLOAT80U_INIT_C(1,0xa5a6c86bbe633ea8,31772), RTFLOAT80U_INIT_C(0,0x1adb9ca79f7e44d,32162), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #96/3/3/c */
    { 0x0000, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/0/u */
    { 0x007f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/0/c */
    { 0x0100, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/1/u */
    { 0x017f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/1/c */
    { 0x0200, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/2/u */
    { 0x027f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/2/c */
    { 0x0300, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/3/u */
    { 0x037f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/0/3/c */
    { 0x0400, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/0/u */
    { 0x047f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/0/c */
    { 0x0500, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/1/u */
    { 0x057f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/1/c */
    { 0x0600, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/2/u */
    { 0x067f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/2/c */
    { 0x0700, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/3/u */
    { 0x077f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/1/3/c */
    { 0x0800, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/0/u */
    { 0x087f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/0/c */
    { 0x0900, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/1/u */
    { 0x097f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/1/c */
    { 0x0a00, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/2/u */
    { 0x0a7f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/2/c */
    { 0x0b00, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/3/u */
    { 0x0b7f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/2/3/c */
    { 0x0c00, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/0/u */
    { 0x0c7f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/0/c */
    { 0x0d00, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/1/u */
    { 0x0d7f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/1/c */
    { 0x0e00, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/2/u */
    { 0x0e7f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/2/c */
    { 0x0f00, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/3/u */
    { 0x0f7f, 0x298b, 0x3900, RTFLOAT80U_INIT_C(0,0xe4a905ce8296b030,10799), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767), RTFLOAT80U_INIT_C(0,0xc7770ceba521b320,32767) }, /* #97/3/3/c */
    { 0x0000, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/0/0/u */
    { 0x007f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/0/0/c */
    { 0x0100, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/0/1/u */
    { 0x017f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/0/1/c */
    { 0x0200, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/0/2/u */
    { 0x027f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/0/2/c */
    { 0x0300, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/0/3/u */
    { 0x037f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/0/3/c */
    { 0x0400, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/1/0/u */
    { 0x047f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/1/0/c */
    { 0x0500, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/1/1/u */
    { 0x057f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/1/1/c */
    { 0x0600, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/1/2/u */
    { 0x067f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/1/2/c */
    { 0x0700, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/1/3/u */
    { 0x077f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/1/3/c */
    { 0x0800, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/2/0/u */
    { 0x087f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/2/0/c */
    { 0x0900, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/2/1/u */
    { 0x097f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/2/1/c */
    { 0x0a00, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/2/2/u */
    { 0x0a7f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/2/2/c */
    { 0x0b00, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/2/3/u */
    { 0x0b7f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/2/3/c */
    { 0x0c00, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/3/0/u */
    { 0x0c7f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/3/0/c */
    { 0x0d00, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/3/1/u */
    { 0x0d7f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/3/1/c */
    { 0x0e00, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/3/2/u */
    { 0x0e7f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/3/2/c */
    { 0x0f00, 0xf014, 0xf081, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634) }, /* #98/3/3/u */
    { 0x0f7f, 0xf014, 0x7801, RTFLOAT80U_INIT_C(1,0x72a1426,32767), RTFLOAT80U_INIT_C(0,0xa15acfa135244994,25634), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #98/3/3/c */
    { 0x0000, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/0/u */
    { 0x007f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/0/c */
    { 0x0100, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/1/u */
    { 0x017f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/1/c */
    { 0x0200, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/2/u */
    { 0x027f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/2/c */
    { 0x0300, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/3/u */
    { 0x037f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/0/3/c */
    { 0x0400, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/0/u */
    { 0x047f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/0/c */
    { 0x0500, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/1/u */
    { 0x057f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/1/c */
    { 0x0600, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/2/u */
    { 0x067f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/2/c */
    { 0x0700, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/3/u */
    { 0x077f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/1/3/c */
    { 0x0800, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/0/u */
    { 0x087f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/0/c */
    { 0x0900, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/1/u */
    { 0x097f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/1/c */
    { 0x0a00, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/2/u */
    { 0x0a7f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/2/c */
    { 0x0b00, 0x3b8a, 0xbba0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/3/u */
    { 0x0b7f, 0x3b8a, 0x3b20, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #99/2/3/c */
    { 0x0c00, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/0/u */
    { 0x0c7f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/0/c */
    { 0x0d00, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/1/u */
    { 0x0d7f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/1/c */
    { 0x0e00, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/2/u */
    { 0x0e7f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/2/c */
    { 0x0f00, 0x3b8a, 0xb9a0, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/3/u */
    { 0x0f7f, 0x3b8a, 0x3920, RTFLOAT80U_INIT_C(0,0xa4d4f677ae1fb9a4,12888), RTFLOAT80U_INIT_C(1,0xace021ed695e485a,1650), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #99/3/3/c */
    { 0x0000, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/0/0/u */
    { 0x007f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/0/0/c */
    { 0x0100, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/0/1/u */
    { 0x017f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/0/1/c */
    { 0x0200, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/0/2/u */
    { 0x027f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/0/2/c */
    { 0x0300, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/0/3/u */
    { 0x037f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/0/3/c */
    { 0x0400, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/1/0/u */
    { 0x047f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/1/0/c */
    { 0x0500, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/1/1/u */
    { 0x057f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/1/1/c */
    { 0x0600, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/1/2/u */
    { 0x067f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/1/2/c */
    { 0x0700, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/1/3/u */
    { 0x077f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/1/3/c */
    { 0x0800, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/2/0/u */
    { 0x087f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/2/0/c */
    { 0x0900, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/2/1/u */
    { 0x097f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/2/1/c */
    { 0x0a00, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/2/2/u */
    { 0x0a7f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/2/2/c */
    { 0x0b00, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/2/3/u */
    { 0x0b7f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/2/3/c */
    { 0x0c00, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/3/0/u */
    { 0x0c7f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/3/0/c */
    { 0x0d00, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/3/1/u */
    { 0x0d7f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/3/1/c */
    { 0x0e00, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/3/2/u */
    { 0x0e7f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/3/2/c */
    { 0x0f00, 0x2e9f, 0xb481, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0x1a9,32340) }, /* #100/3/3/u */
    { 0x0f7f, 0x2e9f, 0x3c01, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(1,0x1a9,32340), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #100/3/3/c */
    { 0x0000, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/0/u */
    { 0x007f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/0/c */
    { 0x0100, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/1/u */
    { 0x017f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/1/c */
    { 0x0200, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/2/u */
    { 0x027f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/2/c */
    { 0x0300, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/3/u */
    { 0x037f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/0/3/c */
    { 0x0400, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/0/u */
    { 0x047f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/0/c */
    { 0x0500, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/1/u */
    { 0x057f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/1/c */
    { 0x0600, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/2/u */
    { 0x067f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/2/c */
    { 0x0700, 0xdd02, 0xffa0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/3/u */
    { 0x077f, 0xdd02, 0x7f20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #101/1/3/c */
    { 0x0800, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/0/u */
    { 0x087f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/0/c */
    { 0x0900, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/1/u */
    { 0x097f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/1/c */
    { 0x0a00, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/2/u */
    { 0x0a7f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/2/c */
    { 0x0b00, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/3/u */
    { 0x0b7f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/2/3/c */
    { 0x0c00, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/0/u */
    { 0x0c7f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/0/c */
    { 0x0d00, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/1/u */
    { 0x0d7f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/1/c */
    { 0x0e00, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/2/u */
    { 0x0e7f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/2/c */
    { 0x0f00, 0xdd02, 0xfda0, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/3/u */
    { 0x0f7f, 0xdd02, 0x7d20, RTFLOAT80U_INIT_C(1,0xaa41485809a1fe58,16359), RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #101/3/3/c */
    { 0x0000, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/0/0/u */
    { 0x007f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/0/0/c */
    { 0x0100, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/0/1/u */
    { 0x017f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/0/1/c */
    { 0x0200, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/0/2/u */
    { 0x027f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/0/2/c */
    { 0x0300, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/0/3/u */
    { 0x037f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/0/3/c */
    { 0x0400, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/1/0/u */
    { 0x047f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/1/0/c */
    { 0x0500, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/1/1/u */
    { 0x057f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/1/1/c */
    { 0x0600, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/1/2/u */
    { 0x067f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/1/2/c */
    { 0x0700, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/1/3/u */
    { 0x077f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/1/3/c */
    { 0x0800, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/2/0/u */
    { 0x087f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/2/0/c */
    { 0x0900, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/2/1/u */
    { 0x097f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/2/1/c */
    { 0x0a00, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/2/2/u */
    { 0x0a7f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/2/2/c */
    { 0x0b00, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/2/3/u */
    { 0x0b7f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/2/3/c */
    { 0x0c00, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/3/0/u */
    { 0x0c7f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/3/0/c */
    { 0x0d00, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/3/1/u */
    { 0x0d7f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/3/1/c */
    { 0x0e00, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/3/2/u */
    { 0x0e7f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/3/2/c */
    { 0x0f00, 0x8c61, 0xb481, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068) }, /* #102/3/3/u */
    { 0x0f7f, 0x8c61, 0x3c01, RTFLOAT80U_INIT_C(1,0x5e74faf18f13d2ce,29654), RTFLOAT80U_INIT_C(1,0x8f518d8f030d12dd,12068), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #102/3/3/c */
    { 0x0000, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/0/u */
    { 0x007f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/0/c */
    { 0x0100, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/1/u */
    { 0x017f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/1/c */
    { 0x0200, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/2/u */
    { 0x027f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/2/c */
    { 0x0300, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/3/u */
    { 0x037f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/0/3/c */
    { 0x0400, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/0/u */
    { 0x047f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/0/c */
    { 0x0500, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/1/u */
    { 0x057f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/1/c */
    { 0x0600, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/2/u */
    { 0x067f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/2/c */
    { 0x0700, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/3/u */
    { 0x077f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/1/3/c */
    { 0x0800, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/0/u */
    { 0x087f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/0/c */
    { 0x0900, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/1/u */
    { 0x097f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/1/c */
    { 0x0a00, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/2/u */
    { 0x0a7f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/2/c */
    { 0x0b00, 0xe0ca, 0xfaa0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/3/u */
    { 0x0b7f, 0xe0ca, 0x7a20, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #103/2/3/c */
    { 0x0c00, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/0/u */
    { 0x0c7f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/0/c */
    { 0x0d00, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/1/u */
    { 0x0d7f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/1/c */
    { 0x0e00, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/2/u */
    { 0x0e7f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/2/c */
    { 0x0f00, 0xe0ca, 0xf8a0, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/3/u */
    { 0x0f7f, 0xe0ca, 0x7820, RTFLOAT80U_INIT_C(0,0xe2f706b030236200,16274), RTFLOAT80U_INIT_C(1,0xd8ab429f6e7a3303,24928), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #103/3/3/c */
    { 0x0000, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/0/0/u */
    { 0x007f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/0/0/c */
    { 0x0100, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/0/1/u */
    { 0x017f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/0/1/c */
    { 0x0200, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/0/2/u */
    { 0x027f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/0/2/c */
    { 0x0300, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/0/3/u */
    { 0x037f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/0/3/c */
    { 0x0400, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/1/0/u */
    { 0x047f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/1/0/c */
    { 0x0500, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/1/1/u */
    { 0x057f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/1/1/c */
    { 0x0600, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/1/2/u */
    { 0x067f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/1/2/c */
    { 0x0700, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/1/3/u */
    { 0x077f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/1/3/c */
    { 0x0800, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/2/0/u */
    { 0x087f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/2/0/c */
    { 0x0900, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/2/1/u */
    { 0x097f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/2/1/c */
    { 0x0a00, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/2/2/u */
    { 0x0a7f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/2/2/c */
    { 0x0b00, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/2/3/u */
    { 0x0b7f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/2/3/c */
    { 0x0c00, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/3/0/u */
    { 0x0c7f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/3/0/c */
    { 0x0d00, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/3/1/u */
    { 0x0d7f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/3/1/c */
    { 0x0e00, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/3/2/u */
    { 0x0e7f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/3/2/c */
    { 0x0f00, 0xe0f4, 0xf081, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #104/3/3/u */
    { 0x0f7f, 0xe0f4, 0x7801, RTFLOAT80U_INIT_C(1,0xd5a83afcfd2b0e0f,383), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #104/3/3/c */
    { 0x0000, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/0/u */
    { 0x007f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/0/c */
    { 0x0100, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/1/u */
    { 0x017f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/1/c */
    { 0x0200, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/2/u */
    { 0x027f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/2/c */
    { 0x0300, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/3/u */
    { 0x037f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/0/3/c */
    { 0x0400, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/0/u */
    { 0x047f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/0/c */
    { 0x0500, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/1/u */
    { 0x057f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/1/c */
    { 0x0600, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/2/u */
    { 0x067f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/2/c */
    { 0x0700, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/3/u */
    { 0x077f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/1/3/c */
    { 0x0800, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/0/u */
    { 0x087f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/0/c */
    { 0x0900, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/1/u */
    { 0x097f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/1/c */
    { 0x0a00, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/2/u */
    { 0x0a7f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/2/c */
    { 0x0b00, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/3/u */
    { 0x0b7f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/2/3/c */
    { 0x0c00, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/0/u */
    { 0x0c7f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/0/c */
    { 0x0d00, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/1/u */
    { 0x0d7f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/1/c */
    { 0x0e00, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/2/u */
    { 0x0e7f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/2/c */
    { 0x0f00, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/3/u */
    { 0x0f7f, 0xb845, 0x3800, RTFLOAT80U_INIT_C(0,0x800000000014dede,0), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #105/3/3/c */
    { 0x0000, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/0/u */
    { 0x007f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/0/c */
    { 0x0100, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/1/u */
    { 0x017f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/1/c */
    { 0x0200, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/2/u */
    { 0x027f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/2/c */
    { 0x0300, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/3/u */
    { 0x037f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/0/3/c */
    { 0x0400, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/0/u */
    { 0x047f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/0/c */
    { 0x0500, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/1/u */
    { 0x057f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/1/c */
    { 0x0600, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/2/u */
    { 0x067f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/2/c */
    { 0x0700, 0xdf52, 0xffa0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/3/u */
    { 0x077f, 0xdf52, 0x7f20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #106/1/3/c */
    { 0x0800, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/0/u */
    { 0x087f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/0/c */
    { 0x0900, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/1/u */
    { 0x097f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/1/c */
    { 0x0a00, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/2/u */
    { 0x0a7f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/2/c */
    { 0x0b00, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/3/u */
    { 0x0b7f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/2/3/c */
    { 0x0c00, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/0/u */
    { 0x0c7f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/0/c */
    { 0x0d00, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/1/u */
    { 0x0d7f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/1/c */
    { 0x0e00, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/2/u */
    { 0x0e7f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/2/c */
    { 0x0f00, 0xdf52, 0xfda0, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/3/u */
    { 0x0f7f, 0xdf52, 0x7d20, RTFLOAT80U_INIT_C(1,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xa370d6bd041688d3,17740), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #106/3/3/c */
    { 0x0000, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/0/0/u */
    { 0x007f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/0/0/c */
    { 0x0100, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/0/1/u */
    { 0x017f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/0/1/c */
    { 0x0200, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/0/2/u */
    { 0x027f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/0/2/c */
    { 0x0300, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/0/3/u */
    { 0x037f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/0/3/c */
    { 0x0400, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/1/0/u */
    { 0x047f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/1/0/c */
    { 0x0500, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/1/1/u */
    { 0x057f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/1/1/c */
    { 0x0600, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/1/2/u */
    { 0x067f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/1/2/c */
    { 0x0700, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/1/3/u */
    { 0x077f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/1/3/c */
    { 0x0800, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/2/0/u */
    { 0x087f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/2/0/c */
    { 0x0900, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/2/1/u */
    { 0x097f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/2/1/c */
    { 0x0a00, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/2/2/u */
    { 0x0a7f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/2/2/c */
    { 0x0b00, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/2/3/u */
    { 0x0b7f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/2/3/c */
    { 0x0c00, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/3/0/u */
    { 0x0c7f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/3/0/c */
    { 0x0d00, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/3/1/u */
    { 0x0d7f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/3/1/c */
    { 0x0e00, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/3/2/u */
    { 0x0e7f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/3/2/c */
    { 0x0f00, 0x5a97, 0xf081, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767) }, /* #107/3/3/u */
    { 0x0f7f, 0x5a97, 0x7801, RTFLOAT80U_INIT_C(1,0xd138b7e3ebf5b8d1,8426), RTFLOAT80U_INIT_C(0,0x4000000000000003,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #107/3/3/c */
    { 0x0000, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/0/u */
    { 0x007f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/0/c */
    { 0x0100, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/1/u */
    { 0x017f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/1/c */
    { 0x0200, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/2/u */
    { 0x027f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/2/c */
    { 0x0300, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/3/u */
    { 0x037f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/0/3/c */
    { 0x0400, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/0/u */
    { 0x047f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/0/c */
    { 0x0500, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/1/u */
    { 0x057f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/1/c */
    { 0x0600, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/2/u */
    { 0x067f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/2/c */
    { 0x0700, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/3/u */
    { 0x077f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/1/3/c */
    { 0x0800, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/0/u */
    { 0x087f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/0/c */
    { 0x0900, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/1/u */
    { 0x097f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/1/c */
    { 0x0a00, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/2/u */
    { 0x0a7f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/2/c */
    { 0x0b00, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/3/u */
    { 0x0b7f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/2/3/c */
    { 0x0c00, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/0/u */
    { 0x0c7f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/0/c */
    { 0x0d00, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/1/u */
    { 0x0d7f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/1/c */
    { 0x0e00, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/2/u */
    { 0x0e7f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/2/c */
    { 0x0f00, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/3/u */
    { 0x0f7f, 0x76e9, 0x7c00, RTFLOAT80U_INIT_C(0,0x0,0), RTFLOAT80U_INIT_C(0,0x8581423a99bdf295,4476), RTFLOAT80U_INIT_C(0,0x0,0) }, /* #108/3/3/c */
    { 0x0000, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/0/u */
    { 0x007f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/0/c */
    { 0x0100, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/1/u */
    { 0x017f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/1/c */
    { 0x0200, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/2/u */
    { 0x027f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/2/c */
    { 0x0300, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/3/u */
    { 0x037f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/0/3/c */
    { 0x0400, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/0/u */
    { 0x047f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/0/c */
    { 0x0500, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/1/u */
    { 0x057f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/1/c */
    { 0x0600, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/2/u */
    { 0x067f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/2/c */
    { 0x0700, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/3/u */
    { 0x077f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/1/3/c */
    { 0x0800, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/0/u */
    { 0x087f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/0/c */
    { 0x0900, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/1/u */
    { 0x097f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/1/c */
    { 0x0a00, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/2/u */
    { 0x0a7f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/2/c */
    { 0x0b00, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/3/u */
    { 0x0b7f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/2/3/c */
    { 0x0c00, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/0/u */
    { 0x0c7f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/0/c */
    { 0x0d00, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/1/u */
    { 0x0d7f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/1/c */
    { 0x0e00, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/2/u */
    { 0x0e7f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/2/c */
    { 0x0f00, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/3/u */
    { 0x0f7f, 0x3bbb, 0x3900, RTFLOAT80U_INIT_C(0,0x93f520a8ec1cc1c3,8360), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #109/3/3/c */
    { 0x0000, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/0/0/u */
    { 0x007f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/0/0/c */
    { 0x0100, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/0/1/u */
    { 0x017f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/0/1/c */
    { 0x0200, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/0/2/u */
    { 0x027f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/0/2/c */
    { 0x0300, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/0/3/u */
    { 0x037f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/0/3/c */
    { 0x0400, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/1/0/u */
    { 0x047f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/1/0/c */
    { 0x0500, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/1/1/u */
    { 0x057f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/1/1/c */
    { 0x0600, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/1/2/u */
    { 0x067f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/1/2/c */
    { 0x0700, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/1/3/u */
    { 0x077f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/1/3/c */
    { 0x0800, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/2/0/u */
    { 0x087f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/2/0/c */
    { 0x0900, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/2/1/u */
    { 0x097f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/2/1/c */
    { 0x0a00, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/2/2/u */
    { 0x0a7f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/2/2/c */
    { 0x0b00, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/2/3/u */
    { 0x0b7f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/2/3/c */
    { 0x0c00, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/3/0/u */
    { 0x0c7f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/3/0/c */
    { 0x0d00, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/3/1/u */
    { 0x0d7f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/3/1/c */
    { 0x0e00, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/3/2/u */
    { 0x0e7f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/3/2/c */
    { 0x0f00, 0x486d, 0xf081, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767) }, /* #110/3/3/u */
    { 0x0f7f, 0x486d, 0x7801, RTFLOAT80U_INIT_C(1,0x19d5b,32767), RTFLOAT80U_INIT_C(0,0x7b1d9c621925b72f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #110/3/3/c */
    { 0x0000, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/0/0/u */
    { 0x007f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/0/0/c */
    { 0x0100, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/0/1/u */
    { 0x017f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/0/1/c */
    { 0x0200, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/0/2/u */
    { 0x027f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/0/2/c */
    { 0x0300, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/0/3/u */
    { 0x037f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/0/3/c */
    { 0x0400, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/1/0/u */
    { 0x047f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/1/0/c */
    { 0x0500, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/1/1/u */
    { 0x057f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/1/1/c */
    { 0x0600, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/1/2/u */
    { 0x067f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/1/2/c */
    { 0x0700, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/1/3/u */
    { 0x077f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/1/3/c */
    { 0x0800, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/2/0/u */
    { 0x087f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/2/0/c */
    { 0x0900, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/2/1/u */
    { 0x097f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/2/1/c */
    { 0x0a00, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/2/2/u */
    { 0x0a7f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/2/2/c */
    { 0x0b00, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/2/3/u */
    { 0x0b7f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/2/3/c */
    { 0x0c00, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/3/0/u */
    { 0x0c7f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/3/0/c */
    { 0x0d00, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/3/1/u */
    { 0x0d7f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/3/1/c */
    { 0x0e00, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/3/2/u */
    { 0x0e7f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/3/2/c */
    { 0x0f00, 0x17f0, 0xb581, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381) }, /* #111/3/3/u */
    { 0x0f7f, 0x17f0, 0x3d01, RTFLOAT80U_INIT_C(0,0xab168a678c28,0), RTFLOAT80U_INIT_C(1,0x7262d8caada420c2,20381), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #111/3/3/c */
    { 0x0000, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/0/0/u */
    { 0x007f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/0/0/c */
    { 0x0100, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/0/1/u */
    { 0x017f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/0/1/c */
    { 0x0200, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/0/2/u */
    { 0x027f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/0/2/c */
    { 0x0300, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/0/3/u */
    { 0x037f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/0/3/c */
    { 0x0400, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/1/0/u */
    { 0x047f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/1/0/c */
    { 0x0500, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/1/1/u */
    { 0x057f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/1/1/c */
    { 0x0600, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/1/2/u */
    { 0x067f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/1/2/c */
    { 0x0700, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/1/3/u */
    { 0x077f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/1/3/c */
    { 0x0800, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/2/0/u */
    { 0x087f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/2/0/c */
    { 0x0900, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/2/1/u */
    { 0x097f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/2/1/c */
    { 0x0a00, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/2/2/u */
    { 0x0a7f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/2/2/c */
    { 0x0b00, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/2/3/u */
    { 0x0b7f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/2/3/c */
    { 0x0c00, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/3/0/u */
    { 0x0c7f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/3/0/c */
    { 0x0d00, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/3/1/u */
    { 0x0d7f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/3/1/c */
    { 0x0e00, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/3/2/u */
    { 0x0e7f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/3/2/c */
    { 0x0f00, 0x7529, 0xf581, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892) }, /* #112/3/3/u */
    { 0x0f7f, 0x7529, 0x7d01, RTFLOAT80U_INIT_C(1,0x51f7c8b0c0ac91d3,32767), RTFLOAT80U_INIT_C(0,0xfa1763fbe99ed2a5,12892), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #112/3/3/c */
    { 0x0000, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/0/0/u */
    { 0x007f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/0/0/c */
    { 0x0100, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/0/1/u */
    { 0x017f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/0/1/c */
    { 0x0200, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/0/2/u */
    { 0x027f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/0/2/c */
    { 0x0300, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/0/3/u */
    { 0x037f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/0/3/c */
    { 0x0400, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/1/0/u */
    { 0x047f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/1/0/c */
    { 0x0500, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/1/1/u */
    { 0x057f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/1/1/c */
    { 0x0600, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/1/2/u */
    { 0x067f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/1/2/c */
    { 0x0700, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/1/3/u */
    { 0x077f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/1/3/c */
    { 0x0800, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/2/0/u */
    { 0x087f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/2/0/c */
    { 0x0900, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/2/1/u */
    { 0x097f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/2/1/c */
    { 0x0a00, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/2/2/u */
    { 0x0a7f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/2/2/c */
    { 0x0b00, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/2/3/u */
    { 0x0b7f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/2/3/c */
    { 0x0c00, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/3/0/u */
    { 0x0c7f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/3/0/c */
    { 0x0d00, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/3/1/u */
    { 0x0d7f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/3/1/c */
    { 0x0e00, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/3/2/u */
    { 0x0e7f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/3/2/c */
    { 0x0f00, 0x8d2d, 0xb581, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336) }, /* #113/3/3/u */
    { 0x0f7f, 0x8d2d, 0x3d01, RTFLOAT80U_INIT_C(1,0x740781bec8700b91,31649), RTFLOAT80U_INIT_C(1,0x42832f858baaec5a,26336), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #113/3/3/c */
    { 0x0000, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/0/0/u */
    { 0x007f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/0/0/c */
    { 0x0100, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/0/1/u */
    { 0x017f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/0/1/c */
    { 0x0200, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/0/2/u */
    { 0x027f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/0/2/c */
    { 0x0300, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/0/3/u */
    { 0x037f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/0/3/c */
    { 0x0400, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/1/0/u */
    { 0x047f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/1/0/c */
    { 0x0500, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/1/1/u */
    { 0x057f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/1/1/c */
    { 0x0600, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/1/2/u */
    { 0x067f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/1/2/c */
    { 0x0700, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/1/3/u */
    { 0x077f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/1/3/c */
    { 0x0800, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/2/0/u */
    { 0x087f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/2/0/c */
    { 0x0900, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/2/1/u */
    { 0x097f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/2/1/c */
    { 0x0a00, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/2/2/u */
    { 0x0a7f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/2/2/c */
    { 0x0b00, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/2/3/u */
    { 0x0b7f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/2/3/c */
    { 0x0c00, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/3/0/u */
    { 0x0c7f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/3/0/c */
    { 0x0d00, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/3/1/u */
    { 0x0d7f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/3/1/c */
    { 0x0e00, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/3/2/u */
    { 0x0e7f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/3/2/c */
    { 0x0f00, 0x64d8, 0xf481, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472) }, /* #114/3/3/u */
    { 0x0f7f, 0x64d8, 0x7c01, RTFLOAT80U_INIT_C(1,0x8000000004945484,0), RTFLOAT80U_INIT_C(0,0x10928f80f47c5c57,9472), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #114/3/3/c */
    { 0x0000, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/0/0/u */
    { 0x007f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/0/0/c */
    { 0x0100, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/0/1/u */
    { 0x017f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/0/1/c */
    { 0x0200, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/0/2/u */
    { 0x027f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/0/2/c */
    { 0x0300, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/0/3/u */
    { 0x037f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/0/3/c */
    { 0x0400, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/1/0/u */
    { 0x047f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/1/0/c */
    { 0x0500, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/1/1/u */
    { 0x057f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/1/1/c */
    { 0x0600, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/1/2/u */
    { 0x067f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/1/2/c */
    { 0x0700, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/1/3/u */
    { 0x077f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/1/3/c */
    { 0x0800, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/2/0/u */
    { 0x087f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/2/0/c */
    { 0x0900, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/2/1/u */
    { 0x097f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/2/1/c */
    { 0x0a00, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/2/2/u */
    { 0x0a7f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/2/2/c */
    { 0x0b00, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/2/3/u */
    { 0x0b7f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/2/3/c */
    { 0x0c00, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/3/0/u */
    { 0x0c7f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/3/0/c */
    { 0x0d00, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/3/1/u */
    { 0x0d7f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/3/1/c */
    { 0x0e00, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/3/2/u */
    { 0x0e7f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/3/2/c */
    { 0x0f00, 0x26f0, 0xb481, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784) }, /* #115/3/3/u */
    { 0x0f7f, 0x26f0, 0x3c01, RTFLOAT80U_INIT_C(1,0xa1540e96ef55ab19,32767), RTFLOAT80U_INIT_C(0,0x83d0a73f00760345,19784), RTFLOAT80U_INIT_C(1,0xe1540e96ef55ab19,32767) }, /* #115/3/3/c */
    { 0x0000, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/0/0/u */
    { 0x007f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/0/0/c */
    { 0x0100, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/0/1/u */
    { 0x017f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/0/1/c */
    { 0x0200, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/0/2/u */
    { 0x027f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/0/2/c */
    { 0x0300, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/0/3/u */
    { 0x037f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/0/3/c */
    { 0x0400, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/1/0/u */
    { 0x047f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/1/0/c */
    { 0x0500, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/1/1/u */
    { 0x057f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/1/1/c */
    { 0x0600, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/1/2/u */
    { 0x067f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/1/2/c */
    { 0x0700, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/1/3/u */
    { 0x077f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/1/3/c */
    { 0x0800, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/2/0/u */
    { 0x087f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/2/0/c */
    { 0x0900, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/2/1/u */
    { 0x097f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/2/1/c */
    { 0x0a00, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/2/2/u */
    { 0x0a7f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/2/2/c */
    { 0x0b00, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/2/3/u */
    { 0x0b7f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/2/3/c */
    { 0x0c00, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/3/0/u */
    { 0x0c7f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/3/0/c */
    { 0x0d00, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/3/1/u */
    { 0x0d7f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/3/1/c */
    { 0x0e00, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/3/2/u */
    { 0x0e7f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/3/2/c */
    { 0x0f00, 0x3e0d, 0xb481, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #116/3/3/u */
    { 0x0f7f, 0x3e0d, 0x3c01, RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #116/3/3/c */
    { 0x0000, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/0/u */
    { 0x007f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/0/c */
    { 0x0100, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/1/u */
    { 0x017f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/1/c */
    { 0x0200, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/2/u */
    { 0x027f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/2/c */
    { 0x0300, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/3/u */
    { 0x037f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/0/3/c */
    { 0x0400, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/0/u */
    { 0x047f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/0/c */
    { 0x0500, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/1/u */
    { 0x057f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/1/c */
    { 0x0600, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/2/u */
    { 0x067f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/2/c */
    { 0x0700, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/3/u */
    { 0x077f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/1/3/c */
    { 0x0800, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/0/u */
    { 0x087f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/0/c */
    { 0x0900, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/1/u */
    { 0x097f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/1/c */
    { 0x0a00, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/2/u */
    { 0x0a7f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/2/c */
    { 0x0b00, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/3/u */
    { 0x0b7f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/2/3/c */
    { 0x0c00, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/0/u */
    { 0x0c7f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/0/c */
    { 0x0d00, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/1/u */
    { 0x0d7f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/1/c */
    { 0x0e00, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/2/u */
    { 0x0e7f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/2/c */
    { 0x0f00, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/3/u */
    { 0x0f7f, 0xce38, 0x7c00, RTFLOAT80U_INIT_C(1,0x800000000000000e,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #117/3/3/c */
    { 0x0000, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/0/u */
    { 0x007f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/0/c */
    { 0x0100, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/1/u */
    { 0x017f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/1/c */
    { 0x0200, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/2/u */
    { 0x027f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/2/c */
    { 0x0300, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/3/u */
    { 0x037f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/0/3/c */
    { 0x0400, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/0/u */
    { 0x047f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/0/c */
    { 0x0500, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/1/u */
    { 0x057f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/1/c */
    { 0x0600, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/2/u */
    { 0x067f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/2/c */
    { 0x0700, 0x74e4, 0xfea0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/3/u */
    { 0x077f, 0x74e4, 0x7e20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #118/1/3/c */
    { 0x0800, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/0/u */
    { 0x087f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/0/c */
    { 0x0900, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/1/u */
    { 0x097f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/1/c */
    { 0x0a00, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/2/u */
    { 0x0a7f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/2/c */
    { 0x0b00, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/3/u */
    { 0x0b7f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/2/3/c */
    { 0x0c00, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/0/u */
    { 0x0c7f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/0/c */
    { 0x0d00, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/1/u */
    { 0x0d7f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/1/c */
    { 0x0e00, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/2/u */
    { 0x0e7f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/2/c */
    { 0x0f00, 0x74e4, 0xfca0, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/3/u */
    { 0x0f7f, 0x74e4, 0x7c20, RTFLOAT80U_INIT_C(1,0xab343866a41cfd37,26502), RTFLOAT80U_INIT_C(1,0xf67f54521713562f,28529), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #118/3/3/c */
    { 0x0000, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/0/u */
    { 0x007f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/0/c */
    { 0x0100, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/1/u */
    { 0x017f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/1/c */
    { 0x0200, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/2/u */
    { 0x027f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/2/c */
    { 0x0300, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/3/u */
    { 0x037f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/0/3/c */
    { 0x0400, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/0/u */
    { 0x047f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/0/c */
    { 0x0500, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/1/u */
    { 0x057f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/1/c */
    { 0x0600, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/2/u */
    { 0x067f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/2/c */
    { 0x0700, 0xb9b8, 0xbba0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/3/u */
    { 0x077f, 0xb9b8, 0x3b20, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #119/1/3/c */
    { 0x0800, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/0/u */
    { 0x087f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/0/c */
    { 0x0900, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/1/u */
    { 0x097f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/1/c */
    { 0x0a00, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/2/u */
    { 0x0a7f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/2/c */
    { 0x0b00, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/3/u */
    { 0x0b7f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/2/3/c */
    { 0x0c00, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/0/u */
    { 0x0c7f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/0/c */
    { 0x0d00, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/1/u */
    { 0x0d7f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/1/c */
    { 0x0e00, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/2/u */
    { 0x0e7f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/2/c */
    { 0x0f00, 0xb9b8, 0xb9a0, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/3/u */
    { 0x0f7f, 0xb9b8, 0x3920, RTFLOAT80U_INIT_C(1,0xbf22799ffaaa3f4f,30446), RTFLOAT80U_INIT_C(1,0xfb9d1dd19ea935f6,17342), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #119/3/3/c */
    { 0x0000, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/0/0/u */
    { 0x007f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/0/0/c */
    { 0x0100, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/0/1/u */
    { 0x017f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/0/1/c */
    { 0x0200, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/0/2/u */
    { 0x027f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/0/2/c */
    { 0x0300, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/0/3/u */
    { 0x037f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/0/3/c */
    { 0x0400, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/1/0/u */
    { 0x047f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/1/0/c */
    { 0x0500, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/1/1/u */
    { 0x057f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/1/1/c */
    { 0x0600, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/1/2/u */
    { 0x067f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/1/2/c */
    { 0x0700, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/1/3/u */
    { 0x077f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/1/3/c */
    { 0x0800, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/2/0/u */
    { 0x087f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/2/0/c */
    { 0x0900, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/2/1/u */
    { 0x097f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/2/1/c */
    { 0x0a00, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/2/2/u */
    { 0x0a7f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/2/2/c */
    { 0x0b00, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/2/3/u */
    { 0x0b7f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/2/3/c */
    { 0x0c00, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/3/0/u */
    { 0x0c7f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/3/0/c */
    { 0x0d00, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/3/1/u */
    { 0x0d7f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/3/1/c */
    { 0x0e00, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/3/2/u */
    { 0x0e7f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/3/2/c */
    { 0x0f00, 0x275a, 0xb581, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376) }, /* #120/3/3/u */
    { 0x0f7f, 0x275a, 0x3d01, RTFLOAT80U_INIT_C(1,0x81a427410f60657,0), RTFLOAT80U_INIT_C(1,0x5727b30b09f396a7,17376), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #120/3/3/c */
    { 0x0000, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/0/0/u */
    { 0x007f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/0/0/c */
    { 0x0100, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/0/1/u */
    { 0x017f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/0/1/c */
    { 0x0200, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/0/2/u */
    { 0x027f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/0/2/c */
    { 0x0300, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/0/3/u */
    { 0x037f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/0/3/c */
    { 0x0400, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/1/0/u */
    { 0x047f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/1/0/c */
    { 0x0500, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/1/1/u */
    { 0x057f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/1/1/c */
    { 0x0600, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/1/2/u */
    { 0x067f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/1/2/c */
    { 0x0700, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/1/3/u */
    { 0x077f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/1/3/c */
    { 0x0800, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/2/0/u */
    { 0x087f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/2/0/c */
    { 0x0900, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/2/1/u */
    { 0x097f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/2/1/c */
    { 0x0a00, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/2/2/u */
    { 0x0a7f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/2/2/c */
    { 0x0b00, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/2/3/u */
    { 0x0b7f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/2/3/c */
    { 0x0c00, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/3/0/u */
    { 0x0c7f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/3/0/c */
    { 0x0d00, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/3/1/u */
    { 0x0d7f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/3/1/c */
    { 0x0e00, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/3/2/u */
    { 0x0e7f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/3/2/c */
    { 0x0f00, 0xd585, 0xf581, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767) }, /* #121/3/3/u */
    { 0x0f7f, 0xd585, 0x7d01, RTFLOAT80U_INIT_C(1,0x400001ed29896c2a,32767), RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #121/3/3/c */
    { 0x0000, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/0/u */
    { 0x007f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/0/c */
    { 0x0100, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/1/u */
    { 0x017f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/1/c */
    { 0x0200, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/2/u */
    { 0x027f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/2/c */
    { 0x0300, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/3/u */
    { 0x037f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/0/3/c */
    { 0x0400, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/0/u */
    { 0x047f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/0/c */
    { 0x0500, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/1/u */
    { 0x057f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/1/c */
    { 0x0600, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/2/u */
    { 0x067f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/2/c */
    { 0x0700, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/3/u */
    { 0x077f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/1/3/c */
    { 0x0800, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/0/u */
    { 0x087f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/0/c */
    { 0x0900, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/1/u */
    { 0x097f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/1/c */
    { 0x0a00, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/2/u */
    { 0x0a7f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/2/c */
    { 0x0b00, 0x16c5, 0xbea0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/3/u */
    { 0x0b7f, 0x16c5, 0x3e20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #122/2/3/c */
    { 0x0c00, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/0/u */
    { 0x0c7f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/0/c */
    { 0x0d00, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/1/u */
    { 0x0d7f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/1/c */
    { 0x0e00, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/2/u */
    { 0x0e7f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/2/c */
    { 0x0f00, 0x16c5, 0xbca0, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/3/u */
    { 0x0f7f, 0x16c5, 0x3c20, RTFLOAT80U_INIT_C(0,0xa27387fdb5ed1e97,1206), RTFLOAT80U_INIT_C(1,0xd9023fc5832f5725,11094), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #122/3/3/c */
    { 0x0000, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/0/0/u */
    { 0x007f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/0/0/c */
    { 0x0100, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/0/1/u */
    { 0x017f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/0/1/c */
    { 0x0200, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/0/2/u */
    { 0x027f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/0/2/c */
    { 0x0300, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/0/3/u */
    { 0x037f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/0/3/c */
    { 0x0400, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/1/0/u */
    { 0x047f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/1/0/c */
    { 0x0500, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/1/1/u */
    { 0x057f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/1/1/c */
    { 0x0600, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/1/2/u */
    { 0x067f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/1/2/c */
    { 0x0700, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/1/3/u */
    { 0x077f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/1/3/c */
    { 0x0800, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/2/0/u */
    { 0x087f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/2/0/c */
    { 0x0900, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/2/1/u */
    { 0x097f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/2/1/c */
    { 0x0a00, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/2/2/u */
    { 0x0a7f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/2/2/c */
    { 0x0b00, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/2/3/u */
    { 0x0b7f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/2/3/c */
    { 0x0c00, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/3/0/u */
    { 0x0c7f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/3/0/c */
    { 0x0d00, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/3/1/u */
    { 0x0d7f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/3/1/c */
    { 0x0e00, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/3/2/u */
    { 0x0e7f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/3/2/c */
    { 0x0f00, 0x486b, 0xf081, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242) }, /* #123/3/3/u */
    { 0x0f7f, 0x486b, 0x7801, RTFLOAT80U_INIT_C(0,0x42768b5a4c21da1,32767), RTFLOAT80U_INIT_C(1,0x145c0dca49a032,18242), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #123/3/3/c */
    { 0x0000, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/0/0/u */
    { 0x007f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/0/0/c */
    { 0x0100, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/0/1/u */
    { 0x017f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/0/1/c */
    { 0x0200, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/0/2/u */
    { 0x027f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/0/2/c */
    { 0x0300, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/0/3/u */
    { 0x037f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/0/3/c */
    { 0x0400, 0x0d08, 0xbfb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf54,23257) }, /* #124/1/0/u */
    { 0x047f, 0x0d08, 0x3f30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #124/1/0/c */
    { 0x0500, 0x0d08, 0xbfb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf54,23257) }, /* #124/1/1/u */
    { 0x057f, 0x0d08, 0x3f30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #124/1/1/c */
    { 0x0600, 0x0d08, 0xbfb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf54,23257) }, /* #124/1/2/u */
    { 0x067f, 0x0d08, 0x3f30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #124/1/2/c */
    { 0x0700, 0x0d08, 0xbfb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf54,23257) }, /* #124/1/3/u */
    { 0x077f, 0x0d08, 0x3f30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #124/1/3/c */
    { 0x0800, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/2/0/u */
    { 0x087f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/2/0/c */
    { 0x0900, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/2/1/u */
    { 0x097f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/2/1/c */
    { 0x0a00, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/2/2/u */
    { 0x0a7f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/2/2/c */
    { 0x0b00, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/2/3/u */
    { 0x0b7f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/2/3/c */
    { 0x0c00, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/3/0/u */
    { 0x0c7f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/3/0/c */
    { 0x0d00, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/3/1/u */
    { 0x0d7f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/3/1/c */
    { 0x0e00, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/3/2/u */
    { 0x0e7f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/3/2/c */
    { 0x0f00, 0x0d08, 0xbdb0, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0xd9381fb9c19dcf53,23257) }, /* #124/3/3/u */
    { 0x0f7f, 0x0d08, 0x3d30, RTFLOAT80U_INIT_C(1,0x81748a3943b77547,9454), RTFLOAT80U_INIT_C(0,0x989136eab87ff490,27155), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #124/3/3/c */
    { 0x0000, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/0/0/u */
    { 0x007f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/0/0/c */
    { 0x0100, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/0/1/u */
    { 0x017f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/0/1/c */
    { 0x0200, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/0/2/u */
    { 0x027f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/0/2/c */
    { 0x0300, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/0/3/u */
    { 0x037f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/0/3/c */
    { 0x0400, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/1/0/u */
    { 0x047f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/1/0/c */
    { 0x0500, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/1/1/u */
    { 0x057f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/1/1/c */
    { 0x0600, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/1/2/u */
    { 0x067f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/1/2/c */
    { 0x0700, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/1/3/u */
    { 0x077f, 0x84f6, 0x3e22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #125/1/3/c */
    { 0x0800, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/2/0/u */
    { 0x087f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/2/0/c */
    { 0x0900, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/2/1/u */
    { 0x097f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/2/1/c */
    { 0x0a00, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/2/2/u */
    { 0x0a7f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/2/2/c */
    { 0x0b00, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/2/3/u */
    { 0x0b7f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/2/3/c */
    { 0x0c00, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/3/0/u */
    { 0x0c7f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/3/0/c */
    { 0x0d00, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/3/1/u */
    { 0x0d7f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/3/1/c */
    { 0x0e00, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/3/2/u */
    { 0x0e7f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/3/2/c */
    { 0x0f00, 0x84f6, 0xb482, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536) }, /* #125/3/3/u */
    { 0x0f7f, 0x84f6, 0x3c22, RTFLOAT80U_INIT_C(1,0x80000001e2d5a074,0), RTFLOAT80U_INIT_C(1,0xef39aa784f5e2a85,17536), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #125/3/3/c */
    { 0x0000, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/0/u */
    { 0x007f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/0/c */
    { 0x0100, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/1/u */
    { 0x017f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/1/c */
    { 0x0200, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/2/u */
    { 0x027f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/2/c */
    { 0x0300, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/3/u */
    { 0x037f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/0/3/c */
    { 0x0400, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/0/u */
    { 0x047f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/0/c */
    { 0x0500, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/1/u */
    { 0x057f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/1/c */
    { 0x0600, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/2/u */
    { 0x067f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/2/c */
    { 0x0700, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/3/u */
    { 0x077f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/1/3/c */
    { 0x0800, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/0/u */
    { 0x087f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/0/c */
    { 0x0900, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/1/u */
    { 0x097f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/1/c */
    { 0x0a00, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/2/u */
    { 0x0a7f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/2/c */
    { 0x0b00, 0x1d0b, 0xbfa0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/3/u */
    { 0x0b7f, 0x1d0b, 0x3f20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16384) }, /* #126/2/3/c */
    { 0x0c00, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/0/u */
    { 0x0c7f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/0/c */
    { 0x0d00, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/1/u */
    { 0x0d7f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/1/c */
    { 0x0e00, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/2/u */
    { 0x0e7f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/2/c */
    { 0x0f00, 0x1d0b, 0xbda0, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/3/u */
    { 0x0f7f, 0x1d0b, 0x3d20, RTFLOAT80U_INIT_C(0,0xa95e82768e455347,9777), RTFLOAT80U_INIT_C(1,0x8406460cf2601cda,24759), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16384) }, /* #126/3/3/c */
    { 0x0000, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/0/0/u */
    { 0x007f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/0/0/c */
    { 0x0100, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/0/1/u */
    { 0x017f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/0/1/c */
    { 0x0200, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/0/2/u */
    { 0x027f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/0/2/c */
    { 0x0300, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/0/3/u */
    { 0x037f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/0/3/c */
    { 0x0400, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/1/0/u */
    { 0x047f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/1/0/c */
    { 0x0500, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/1/1/u */
    { 0x057f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/1/1/c */
    { 0x0600, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/1/2/u */
    { 0x067f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/1/2/c */
    { 0x0700, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/1/3/u */
    { 0x077f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/1/3/c */
    { 0x0800, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/2/0/u */
    { 0x087f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/2/0/c */
    { 0x0900, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/2/1/u */
    { 0x097f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/2/1/c */
    { 0x0a00, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/2/2/u */
    { 0x0a7f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/2/2/c */
    { 0x0b00, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/2/3/u */
    { 0x0b7f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/2/3/c */
    { 0x0c00, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/3/0/u */
    { 0x0c7f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/3/0/c */
    { 0x0d00, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/3/1/u */
    { 0x0d7f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/3/1/c */
    { 0x0e00, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/3/2/u */
    { 0x0e7f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/3/2/c */
    { 0x0f00, 0xe93f, 0xf181, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566) }, /* #127/3/3/u */
    { 0x0f7f, 0xe93f, 0x7901, RTFLOAT80U_INIT_C(1,0x4995019143cbe73b,23425), RTFLOAT80U_INIT_C(0,0x886f201d0240410e,21566), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #127/3/3/c */
    { 0x0000, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/0/u */
    { 0x007f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/0/c */
    { 0x0100, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/1/u */
    { 0x017f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/1/c */
    { 0x0200, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/2/u */
    { 0x027f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/2/c */
    { 0x0300, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/3/u */
    { 0x037f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/0/3/c */
    { 0x0400, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/0/u */
    { 0x047f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/0/c */
    { 0x0500, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/1/u */
    { 0x057f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/1/c */
    { 0x0600, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/2/u */
    { 0x067f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/2/c */
    { 0x0700, 0xcddb, 0xffa0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/3/u */
    { 0x077f, 0xcddb, 0x7f20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b3,12558) }, /* #128/1/3/c */
    { 0x0800, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/0/u */
    { 0x087f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/0/c */
    { 0x0900, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/1/u */
    { 0x097f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/1/c */
    { 0x0a00, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/2/u */
    { 0x0a7f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/2/c */
    { 0x0b00, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/3/u */
    { 0x0b7f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/2/3/c */
    { 0x0c00, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/0/u */
    { 0x0c7f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/0/c */
    { 0x0d00, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/1/u */
    { 0x0d7f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/1/c */
    { 0x0e00, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/2/u */
    { 0x0e7f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/2/c */
    { 0x0f00, 0xcddb, 0xfda0, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/3/u */
    { 0x0f7f, 0xcddb, 0x7d20, RTFLOAT80U_INIT_C(1,0xa6b08b4e966e596b,16826), RTFLOAT80U_INIT_C(0,0xdb633b3d9b3c6a3e,20650), RTFLOAT80U_INIT_C(1,0xc281ed5b3b1447b2,12558) }, /* #128/3/3/c */
    { 0x0000, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/0/0/u */
    { 0x007f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/0/0/c */
    { 0x0100, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/0/1/u */
    { 0x017f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/0/1/c */
    { 0x0200, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/0/2/u */
    { 0x027f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/0/2/c */
    { 0x0300, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/0/3/u */
    { 0x037f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/0/3/c */
    { 0x0400, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/1/0/u */
    { 0x047f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/1/0/c */
    { 0x0500, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/1/1/u */
    { 0x057f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/1/1/c */
    { 0x0600, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/1/2/u */
    { 0x067f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/1/2/c */
    { 0x0700, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/1/3/u */
    { 0x077f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/1/3/c */
    { 0x0800, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/2/0/u */
    { 0x087f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/2/0/c */
    { 0x0900, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/2/1/u */
    { 0x097f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/2/1/c */
    { 0x0a00, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/2/2/u */
    { 0x0a7f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/2/2/c */
    { 0x0b00, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/2/3/u */
    { 0x0b7f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/2/3/c */
    { 0x0c00, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/3/0/u */
    { 0x0c7f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/3/0/c */
    { 0x0d00, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/3/1/u */
    { 0x0d7f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/3/1/c */
    { 0x0e00, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/3/2/u */
    { 0x0e7f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/3/2/c */
    { 0x0f00, 0x4d6b, 0xf581, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0x0,32767) }, /* #129/3/3/u */
    { 0x0f7f, 0x4d6b, 0x7d01, RTFLOAT80U_INIT_C(0,0x968d378d319e674,28699), RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #129/3/3/c */
    { 0x0000, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/0/0/u */
    { 0x007f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/0/0/c */
    { 0x0100, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/0/1/u */
    { 0x017f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/0/1/c */
    { 0x0200, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/0/2/u */
    { 0x027f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/0/2/c */
    { 0x0300, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/0/3/u */
    { 0x037f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/0/3/c */
    { 0x0400, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/1/0/u */
    { 0x047f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/1/0/c */
    { 0x0500, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/1/1/u */
    { 0x057f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/1/1/c */
    { 0x0600, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/1/2/u */
    { 0x067f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/1/2/c */
    { 0x0700, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/1/3/u */
    { 0x077f, 0x8c24, 0x3e22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #130/1/3/c */
    { 0x0800, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/2/0/u */
    { 0x087f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/2/0/c */
    { 0x0900, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/2/1/u */
    { 0x097f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/2/1/c */
    { 0x0a00, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/2/2/u */
    { 0x0a7f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/2/2/c */
    { 0x0b00, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/2/3/u */
    { 0x0b7f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/2/3/c */
    { 0x0c00, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/3/0/u */
    { 0x0c7f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/3/0/c */
    { 0x0d00, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/3/1/u */
    { 0x0d7f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/3/1/c */
    { 0x0e00, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/3/2/u */
    { 0x0e7f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/3/2/c */
    { 0x0f00, 0x8c24, 0xb482, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0) }, /* #130/3/3/u */
    { 0x0f7f, 0x8c24, 0x3c22, RTFLOAT80U_INIT_C(1,0xc180fe51c68eaef7,6511), RTFLOAT80U_INIT_C(0,0x8000000a4cb3e519,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #130/3/3/c */
    { 0x0000, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/0/0/u */
    { 0x007f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/0/0/c */
    { 0x0100, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/0/1/u */
    { 0x017f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/0/1/c */
    { 0x0200, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/0/2/u */
    { 0x027f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/0/2/c */
    { 0x0300, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/0/3/u */
    { 0x037f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/0/3/c */
    { 0x0400, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/1/0/u */
    { 0x047f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/1/0/c */
    { 0x0500, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/1/1/u */
    { 0x057f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/1/1/c */
    { 0x0600, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/1/2/u */
    { 0x067f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/1/2/c */
    { 0x0700, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/1/3/u */
    { 0x077f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/1/3/c */
    { 0x0800, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/2/0/u */
    { 0x087f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/2/0/c */
    { 0x0900, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/2/1/u */
    { 0x097f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/2/1/c */
    { 0x0a00, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/2/2/u */
    { 0x0a7f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/2/2/c */
    { 0x0b00, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/2/3/u */
    { 0x0b7f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/2/3/c */
    { 0x0c00, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/3/0/u */
    { 0x0c7f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/3/0/c */
    { 0x0d00, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/3/1/u */
    { 0x0d7f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/3/1/c */
    { 0x0e00, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/3/2/u */
    { 0x0e7f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/3/2/c */
    { 0x0f00, 0x6c19, 0xf481, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(0,0x2faa330,31094) }, /* #131/3/3/u */
    { 0x0f7f, 0x6c19, 0x7c01, RTFLOAT80U_INIT_C(1,0x30ac09b5c7e39e46,989), RTFLOAT80U_INIT_C(0,0x2faa330,31094), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #131/3/3/c */
    { 0x0000, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/0/0/u */
    { 0x007f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/0/0/c */
    { 0x0100, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/0/1/u */
    { 0x017f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/0/1/c */
    { 0x0200, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/0/2/u */
    { 0x027f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/0/2/c */
    { 0x0300, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/0/3/u */
    { 0x037f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/0/3/c */
    { 0x0400, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/1/0/u */
    { 0x047f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/1/0/c */
    { 0x0500, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/1/1/u */
    { 0x057f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/1/1/c */
    { 0x0600, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/1/2/u */
    { 0x067f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/1/2/c */
    { 0x0700, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/1/3/u */
    { 0x077f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/1/3/c */
    { 0x0800, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/2/0/u */
    { 0x087f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/2/0/c */
    { 0x0900, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/2/1/u */
    { 0x097f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/2/1/c */
    { 0x0a00, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/2/2/u */
    { 0x0a7f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/2/2/c */
    { 0x0b00, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/2/3/u */
    { 0x0b7f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/2/3/c */
    { 0x0c00, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/3/0/u */
    { 0x0c7f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/3/0/c */
    { 0x0d00, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/3/1/u */
    { 0x0d7f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/3/1/c */
    { 0x0e00, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/3/2/u */
    { 0x0e7f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/3/2/c */
    { 0x0f00, 0xe3e4, 0xf181, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767) }, /* #132/3/3/u */
    { 0x0f7f, 0xe3e4, 0x7901, RTFLOAT80U_INIT_C(1,0x31acfb13982a10ad,13791), RTFLOAT80U_INIT_C(0,0x2b5dba36146f9bcd,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #132/3/3/c */
    { 0x0000, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/0/u */
    { 0x007f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/0/c */
    { 0x0100, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/1/u */
    { 0x017f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/1/c */
    { 0x0200, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/2/u */
    { 0x027f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/2/c */
    { 0x0300, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/3/u */
    { 0x037f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/0/3/c */
    { 0x0400, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/0/u */
    { 0x047f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/0/c */
    { 0x0500, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/1/u */
    { 0x057f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/1/c */
    { 0x0600, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/2/u */
    { 0x067f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/2/c */
    { 0x0700, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/3/u */
    { 0x077f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/1/3/c */
    { 0x0800, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/0/u */
    { 0x087f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/0/c */
    { 0x0900, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/1/u */
    { 0x097f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/1/c */
    { 0x0a00, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/2/u */
    { 0x0a7f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/2/c */
    { 0x0b00, 0x6511, 0xffa0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/3/u */
    { 0x0b7f, 0x6511, 0x7f20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #133/2/3/c */
    { 0x0c00, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/0/u */
    { 0x0c7f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/0/c */
    { 0x0d00, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/1/u */
    { 0x0d7f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/1/c */
    { 0x0e00, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/2/u */
    { 0x0e7f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/2/c */
    { 0x0f00, 0x6511, 0xfda0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/3/u */
    { 0x0f7f, 0x6511, 0x7d20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(0,0xcf3a8ee8516f0331,10535), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #133/3/3/c */
    { 0x0000, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/0/0/u */
    { 0x007f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/0/0/c */
    { 0x0100, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/0/1/u */
    { 0x017f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/0/1/c */
    { 0x0200, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/0/2/u */
    { 0x027f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/0/2/c */
    { 0x0300, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/0/3/u */
    { 0x037f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/0/3/c */
    { 0x0400, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/1/0/u */
    { 0x047f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/1/0/c */
    { 0x0500, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/1/1/u */
    { 0x057f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/1/1/c */
    { 0x0600, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/1/2/u */
    { 0x067f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/1/2/c */
    { 0x0700, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/1/3/u */
    { 0x077f, 0x7895, 0x7a22, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16384) }, /* #134/1/3/c */
    { 0x0800, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/2/0/u */
    { 0x087f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/2/0/c */
    { 0x0900, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/2/1/u */
    { 0x097f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/2/1/c */
    { 0x0a00, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/2/2/u */
    { 0x0a7f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/2/2/c */
    { 0x0b00, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/2/3/u */
    { 0x0b7f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/2/3/c */
    { 0x0c00, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/3/0/u */
    { 0x0c7f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/3/0/c */
    { 0x0d00, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/3/1/u */
    { 0x0d7f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/3/1/c */
    { 0x0e00, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/3/2/u */
    { 0x0e7f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/3/2/c */
    { 0x0f00, 0x7895, 0xf082, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615) }, /* #134/3/3/u */
    { 0x0f7f, 0x7895, 0x7822, RTFLOAT80U_INIT_C(1,0x800000000806daa9,0), RTFLOAT80U_INIT_C(1,0x8565b4addd204586,19615), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16384) }, /* #134/3/3/c */
    { 0x0000, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/0/0/u */
    { 0x007f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/0/0/c */
    { 0x0100, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/0/1/u */
    { 0x017f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/0/1/c */
    { 0x0200, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/0/2/u */
    { 0x027f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/0/2/c */
    { 0x0300, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/0/3/u */
    { 0x037f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/0/3/c */
    { 0x0400, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/1/0/u */
    { 0x047f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/1/0/c */
    { 0x0500, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/1/1/u */
    { 0x057f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/1/1/c */
    { 0x0600, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/1/2/u */
    { 0x067f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/1/2/c */
    { 0x0700, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/1/3/u */
    { 0x077f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/1/3/c */
    { 0x0800, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/2/0/u */
    { 0x087f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/2/0/c */
    { 0x0900, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/2/1/u */
    { 0x097f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/2/1/c */
    { 0x0a00, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/2/2/u */
    { 0x0a7f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/2/2/c */
    { 0x0b00, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/2/3/u */
    { 0x0b7f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/2/3/c */
    { 0x0c00, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/3/0/u */
    { 0x0c7f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/3/0/c */
    { 0x0d00, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/3/1/u */
    { 0x0d7f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/3/1/c */
    { 0x0e00, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/3/2/u */
    { 0x0e7f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/3/2/c */
    { 0x0f00, 0x4475, 0xf481, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036) }, /* #135/3/3/u */
    { 0x0f7f, 0x4475, 0x7c01, RTFLOAT80U_INIT_C(0,0x8003e468155bee54,32767), RTFLOAT80U_INIT_C(1,0x2549847f37aba2be,25036), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #135/3/3/c */
    { 0x0000, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/0/u */
    { 0x007f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/0/c */
    { 0x0100, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/1/u */
    { 0x017f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/1/c */
    { 0x0200, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/2/u */
    { 0x027f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/2/c */
    { 0x0300, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/3/u */
    { 0x037f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/0/3/c */
    { 0x0400, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/0/u */
    { 0x047f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/0/c */
    { 0x0500, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/1/u */
    { 0x057f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/1/c */
    { 0x0600, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/2/u */
    { 0x067f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/2/c */
    { 0x0700, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/3/u */
    { 0x077f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/1/3/c */
    { 0x0800, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/0/u */
    { 0x087f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/0/c */
    { 0x0900, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/1/u */
    { 0x097f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/1/c */
    { 0x0a00, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/2/u */
    { 0x0a7f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/2/c */
    { 0x0b00, 0x0d48, 0xbfa0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/3/u */
    { 0x0b7f, 0x0d48, 0x3f20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827de,15296) }, /* #136/2/3/c */
    { 0x0c00, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/0/u */
    { 0x0c7f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/0/c */
    { 0x0d00, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/1/u */
    { 0x0d7f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/1/c */
    { 0x0e00, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/2/u */
    { 0x0e7f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/2/c */
    { 0x0f00, 0x0d48, 0xbda0, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/3/u */
    { 0x0f7f, 0x0d48, 0x3d20, RTFLOAT80U_INIT_C(0,0x916b2ac58b51773c,5445), RTFLOAT80U_INIT_C(0,0xa636f8fa74ebd23a,6531), RTFLOAT80U_INIT_C(0,0xdff866a098e827dd,15296) }, /* #136/3/3/c */
    { 0x0000, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/0/0/u */
    { 0x007f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/0/0/c */
    { 0x0100, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/0/1/u */
    { 0x017f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/0/1/c */
    { 0x0200, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/0/2/u */
    { 0x027f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/0/2/c */
    { 0x0300, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/0/3/u */
    { 0x037f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/0/3/c */
    { 0x0400, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/1/0/u */
    { 0x047f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/1/0/c */
    { 0x0500, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/1/1/u */
    { 0x057f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/1/1/c */
    { 0x0600, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/1/2/u */
    { 0x067f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/1/2/c */
    { 0x0700, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/1/3/u */
    { 0x077f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/1/3/c */
    { 0x0800, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/2/0/u */
    { 0x087f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/2/0/c */
    { 0x0900, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/2/1/u */
    { 0x097f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/2/1/c */
    { 0x0a00, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/2/2/u */
    { 0x0a7f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/2/2/c */
    { 0x0b00, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/2/3/u */
    { 0x0b7f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/2/3/c */
    { 0x0c00, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/3/0/u */
    { 0x0c7f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/3/0/c */
    { 0x0d00, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/3/1/u */
    { 0x0d7f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/3/1/c */
    { 0x0e00, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/3/2/u */
    { 0x0e7f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/3/2/c */
    { 0x0f00, 0x5074, 0xf081, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309) }, /* #137/3/3/u */
    { 0x0f7f, 0x5074, 0x7801, RTFLOAT80U_INIT_C(1,0x2f34e70fba340cce,32767), RTFLOAT80U_INIT_C(0,0xb01ee089eed630d0,23309), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #137/3/3/c */
    { 0x0000, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/0/0/u */
    { 0x007f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/0/0/c */
    { 0x0100, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/0/1/u */
    { 0x017f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/0/1/c */
    { 0x0200, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/0/2/u */
    { 0x027f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/0/2/c */
    { 0x0300, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/0/3/u */
    { 0x037f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/0/3/c */
    { 0x0400, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/1/0/u */
    { 0x047f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/1/0/c */
    { 0x0500, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/1/1/u */
    { 0x057f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/1/1/c */
    { 0x0600, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/1/2/u */
    { 0x067f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/1/2/c */
    { 0x0700, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/1/3/u */
    { 0x077f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/1/3/c */
    { 0x0800, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/2/0/u */
    { 0x087f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/2/0/c */
    { 0x0900, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/2/1/u */
    { 0x097f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/2/1/c */
    { 0x0a00, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/2/2/u */
    { 0x0a7f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/2/2/c */
    { 0x0b00, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/2/3/u */
    { 0x0b7f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/2/3/c */
    { 0x0c00, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/3/0/u */
    { 0x0c7f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/3/0/c */
    { 0x0d00, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/3/1/u */
    { 0x0d7f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/3/1/c */
    { 0x0e00, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/3/2/u */
    { 0x0e7f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/3/2/c */
    { 0x0f00, 0x0a25, 0xb081, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(0,0x7,0) }, /* #138/3/3/u */
    { 0x0f7f, 0x0a25, 0x3801, RTFLOAT80U_INIT_C(0,0x6d1369d8ba0c0ca9,29385), RTFLOAT80U_INIT_C(0,0x7,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #138/3/3/c */
    { 0x0000, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/0/u */
    { 0x007f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/0/c */
    { 0x0100, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/1/u */
    { 0x017f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/1/c */
    { 0x0200, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/2/u */
    { 0x027f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/2/c */
    { 0x0300, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/3/u */
    { 0x037f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/0/3/c */
    { 0x0400, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/0/u */
    { 0x047f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/0/c */
    { 0x0500, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/1/u */
    { 0x057f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/1/c */
    { 0x0600, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/2/u */
    { 0x067f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/2/c */
    { 0x0700, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/3/u */
    { 0x077f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/1/3/c */
    { 0x0800, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/0/u */
    { 0x087f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/0/c */
    { 0x0900, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/1/u */
    { 0x097f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/1/c */
    { 0x0a00, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/2/u */
    { 0x0a7f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/2/c */
    { 0x0b00, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/3/u */
    { 0x0b7f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/2/3/c */
    { 0x0c00, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/0/u */
    { 0x0c7f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/0/c */
    { 0x0d00, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/1/u */
    { 0x0d7f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/1/c */
    { 0x0e00, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/2/u */
    { 0x0e7f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/2/c */
    { 0x0f00, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/3/u */
    { 0x0f7f, 0xc487, 0x7c00, RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767), RTFLOAT80U_INIT_C(0,0xcf0acc816f5e29ce,12510), RTFLOAT80U_INIT_C(1,0xcc387bd73d0004c2,32767) }, /* #139/3/3/c */
    { 0x0000, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/0/u */
    { 0x007f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/0/c */
    { 0x0100, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/1/u */
    { 0x017f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/1/c */
    { 0x0200, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/2/u */
    { 0x027f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/2/c */
    { 0x0300, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/3/u */
    { 0x037f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/0/3/c */
    { 0x0400, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/0/u */
    { 0x047f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/0/c */
    { 0x0500, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/1/u */
    { 0x057f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/1/c */
    { 0x0600, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/2/u */
    { 0x067f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/2/c */
    { 0x0700, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/3/u */
    { 0x077f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/1/3/c */
    { 0x0800, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/0/u */
    { 0x087f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/0/c */
    { 0x0900, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/1/u */
    { 0x097f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/1/c */
    { 0x0a00, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/2/u */
    { 0x0a7f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/2/c */
    { 0x0b00, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/3/u */
    { 0x0b7f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/2/3/c */
    { 0x0c00, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/0/u */
    { 0x0c7f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/0/c */
    { 0x0d00, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/1/u */
    { 0x0d7f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/1/c */
    { 0x0e00, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/2/u */
    { 0x0e7f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/2/c */
    { 0x0f00, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/3/u */
    { 0x0f7f, 0x0639, 0x3c00, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0xf924d7442a0a0a37,20139), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #140/3/3/c */
    { 0x0000, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/0/0/u */
    { 0x007f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/0/0/c */
    { 0x0100, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/0/1/u */
    { 0x017f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/0/1/c */
    { 0x0200, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/0/2/u */
    { 0x027f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/0/2/c */
    { 0x0300, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/0/3/u */
    { 0x037f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/0/3/c */
    { 0x0400, 0xf601, 0xfeb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60fa,19823) }, /* #141/1/0/u */
    { 0x047f, 0xf601, 0x7e30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #141/1/0/c */
    { 0x0500, 0xf601, 0xfeb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60fa,19823) }, /* #141/1/1/u */
    { 0x057f, 0xf601, 0x7e30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #141/1/1/c */
    { 0x0600, 0xf601, 0xfeb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60fa,19823) }, /* #141/1/2/u */
    { 0x067f, 0xf601, 0x7e30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #141/1/2/c */
    { 0x0700, 0xf601, 0xfeb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60fa,19823) }, /* #141/1/3/u */
    { 0x077f, 0xf601, 0x7e30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x1,0) }, /* #141/1/3/c */
    { 0x0800, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/2/0/u */
    { 0x087f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/2/0/c */
    { 0x0900, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/2/1/u */
    { 0x097f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/2/1/c */
    { 0x0a00, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/2/2/u */
    { 0x0a7f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/2/2/c */
    { 0x0b00, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/2/3/u */
    { 0x0b7f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/2/3/c */
    { 0x0c00, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/3/0/u */
    { 0x0c7f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/3/0/c */
    { 0x0d00, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/3/1/u */
    { 0x0d7f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/3/1/c */
    { 0x0e00, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/3/2/u */
    { 0x0e7f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/3/2/c */
    { 0x0f00, 0xf601, 0xfcb0, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x8ab876e3b11d60f9,19823) }, /* #141/3/3/u */
    { 0x0f7f, 0xf601, 0x7c30, RTFLOAT80U_INIT_C(1,0xcc33339d3d0cb0eb,3756), RTFLOAT80U_INIT_C(0,0xbc6b48b48c872478,24892), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #141/3/3/c */
    { 0x0000, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/0/0/u */
    { 0x007f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/0/0/c */
    { 0x0100, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/0/1/u */
    { 0x017f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/0/1/c */
    { 0x0200, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/0/2/u */
    { 0x027f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/0/2/c */
    { 0x0300, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/0/3/u */
    { 0x037f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/0/3/c */
    { 0x0400, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/1/0/u */
    { 0x047f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/1/0/c */
    { 0x0500, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/1/1/u */
    { 0x057f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/1/1/c */
    { 0x0600, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/1/2/u */
    { 0x067f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/1/2/c */
    { 0x0700, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/1/3/u */
    { 0x077f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/1/3/c */
    { 0x0800, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/2/0/u */
    { 0x087f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/2/0/c */
    { 0x0900, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/2/1/u */
    { 0x097f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/2/1/c */
    { 0x0a00, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/2/2/u */
    { 0x0a7f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/2/2/c */
    { 0x0b00, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/2/3/u */
    { 0x0b7f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/2/3/c */
    { 0x0c00, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/3/0/u */
    { 0x0c7f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/3/0/c */
    { 0x0d00, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/3/1/u */
    { 0x0d7f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/3/1/c */
    { 0x0e00, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/3/2/u */
    { 0x0e7f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/3/2/c */
    { 0x0f00, 0xb838, 0xb081, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580) }, /* #142/3/3/u */
    { 0x0f7f, 0xb838, 0x3801, RTFLOAT80U_INIT_C(0,0xa6379e521c30e979,11544), RTFLOAT80U_INIT_C(0,0x760d1378cd02d95f,26580), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #142/3/3/c */
    { 0x0000, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/0/0/u */
    { 0x007f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/0/0/c */
    { 0x0100, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/0/1/u */
    { 0x017f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/0/1/c */
    { 0x0200, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/0/2/u */
    { 0x027f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/0/2/c */
    { 0x0300, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/0/3/u */
    { 0x037f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/0/3/c */
    { 0x0400, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/1/0/u */
    { 0x047f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/1/0/c */
    { 0x0500, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/1/1/u */
    { 0x057f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/1/1/c */
    { 0x0600, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/1/2/u */
    { 0x067f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/1/2/c */
    { 0x0700, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/1/3/u */
    { 0x077f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/1/3/c */
    { 0x0800, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/2/0/u */
    { 0x087f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/2/0/c */
    { 0x0900, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/2/1/u */
    { 0x097f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/2/1/c */
    { 0x0a00, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/2/2/u */
    { 0x0a7f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/2/2/c */
    { 0x0b00, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/2/3/u */
    { 0x0b7f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/2/3/c */
    { 0x0c00, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/3/0/u */
    { 0x0c7f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/3/0/c */
    { 0x0d00, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/3/1/u */
    { 0x0d7f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/3/1/c */
    { 0x0e00, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/3/2/u */
    { 0x0e7f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/3/2/c */
    { 0x0f00, 0xa65f, 0xb481, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159) }, /* #143/3/3/u */
    { 0x0f7f, 0xa65f, 0x3c01, RTFLOAT80U_INIT_C(1,0x0,32767), RTFLOAT80U_INIT_C(1,0xe57427eaa71831e6,10159), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #143/3/3/c */
    { 0x0000, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/0/0/u */
    { 0x007f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/0/0/c */
    { 0x0100, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/0/1/u */
    { 0x017f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/0/1/c */
    { 0x0200, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/0/2/u */
    { 0x027f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/0/2/c */
    { 0x0300, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/0/3/u */
    { 0x037f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/0/3/c */
    { 0x0400, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/1/0/u */
    { 0x047f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/1/0/c */
    { 0x0500, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/1/1/u */
    { 0x057f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/1/1/c */
    { 0x0600, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/1/2/u */
    { 0x067f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/1/2/c */
    { 0x0700, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/1/3/u */
    { 0x077f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/1/3/c */
    { 0x0800, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/2/0/u */
    { 0x087f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/2/0/c */
    { 0x0900, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/2/1/u */
    { 0x097f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/2/1/c */
    { 0x0a00, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/2/2/u */
    { 0x0a7f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/2/2/c */
    { 0x0b00, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/2/3/u */
    { 0x0b7f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/2/3/c */
    { 0x0c00, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/3/0/u */
    { 0x0c7f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/3/0/c */
    { 0x0d00, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/3/1/u */
    { 0x0d7f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/3/1/c */
    { 0x0e00, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/3/2/u */
    { 0x0e7f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/3/2/c */
    { 0x0f00, 0x541c, 0xf481, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801) }, /* #144/3/3/u */
    { 0x0f7f, 0x541c, 0x7c01, RTFLOAT80U_INIT_C(0,0xa6f4a650f5ba7f3,21264), RTFLOAT80U_INIT_C(0,0x4b4ba6baa4c33309,801), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #144/3/3/c */
    { 0x0000, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/0/u */
    { 0x007f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/0/c */
    { 0x0100, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/1/u */
    { 0x017f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/1/c */
    { 0x0200, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/2/u */
    { 0x027f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/2/c */
    { 0x0300, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/3/u */
    { 0x037f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/0/3/c */
    { 0x0400, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/0/u */
    { 0x047f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/0/c */
    { 0x0500, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/1/u */
    { 0x057f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/1/c */
    { 0x0600, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/2/u */
    { 0x067f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/2/c */
    { 0x0700, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/3/u */
    { 0x077f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/1/3/c */
    { 0x0800, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/0/u */
    { 0x087f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/0/c */
    { 0x0900, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/1/u */
    { 0x097f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/1/c */
    { 0x0a00, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/2/u */
    { 0x0a7f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/2/c */
    { 0x0b00, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/3/u */
    { 0x0b7f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/2/3/c */
    { 0x0c00, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/0/u */
    { 0x0c7f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/0/c */
    { 0x0d00, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/1/u */
    { 0x0d7f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/1/c */
    { 0x0e00, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/2/u */
    { 0x0e7f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/2/c */
    { 0x0f00, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/3/u */
    { 0x0f7f, 0x33b5, 0x3900, RTFLOAT80U_INIT_C(1,0xc000000000000010,32767), RTFLOAT80U_INIT_C(1,0x2412dc415ea3127d,0), RTFLOAT80U_INIT_C(1,0xc000000000000010,32767) }, /* #145/3/3/c */
    { 0x0000, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/0/0/u */
    { 0x007f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/0/0/c */
    { 0x0100, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/0/1/u */
    { 0x017f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/0/1/c */
    { 0x0200, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/0/2/u */
    { 0x027f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/0/2/c */
    { 0x0300, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/0/3/u */
    { 0x037f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/0/3/c */
    { 0x0400, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/1/0/u */
    { 0x047f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/1/0/c */
    { 0x0500, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/1/1/u */
    { 0x057f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/1/1/c */
    { 0x0600, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/1/2/u */
    { 0x067f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/1/2/c */
    { 0x0700, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/1/3/u */
    { 0x077f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/1/3/c */
    { 0x0800, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/2/0/u */
    { 0x087f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/2/0/c */
    { 0x0900, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/2/1/u */
    { 0x097f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/2/1/c */
    { 0x0a00, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/2/2/u */
    { 0x0a7f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/2/2/c */
    { 0x0b00, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/2/3/u */
    { 0x0b7f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/2/3/c */
    { 0x0c00, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/3/0/u */
    { 0x0c7f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/3/0/c */
    { 0x0d00, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/3/1/u */
    { 0x0d7f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/3/1/c */
    { 0x0e00, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/3/2/u */
    { 0x0e7f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/3/2/c */
    { 0x0f00, 0x75bf, 0xf582, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0) }, /* #146/3/3/u */
    { 0x0f7f, 0x75bf, 0x7d02, RTFLOAT80U_INIT_C(1,0x0,0), RTFLOAT80U_INIT_C(0,0xe2f04174534b07d9,0), RTFLOAT80U_INIT_C(1,0x0,0) }, /* #146/3/3/c */
    { 0x0000, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/0/0/u */
    { 0x007f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/0/0/c */
    { 0x0100, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/0/1/u */
    { 0x017f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/0/1/c */
    { 0x0200, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/0/2/u */
    { 0x027f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/0/2/c */
    { 0x0300, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/0/3/u */
    { 0x037f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/0/3/c */
    { 0x0400, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/1/0/u */
    { 0x047f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/1/0/c */
    { 0x0500, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/1/1/u */
    { 0x057f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/1/1/c */
    { 0x0600, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/1/2/u */
    { 0x067f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/1/2/c */
    { 0x0700, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/1/3/u */
    { 0x077f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/1/3/c */
    { 0x0800, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/2/0/u */
    { 0x087f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/2/0/c */
    { 0x0900, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/2/1/u */
    { 0x097f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/2/1/c */
    { 0x0a00, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/2/2/u */
    { 0x0a7f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/2/2/c */
    { 0x0b00, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/2/3/u */
    { 0x0b7f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/2/3/c */
    { 0x0c00, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/3/0/u */
    { 0x0c7f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/3/0/c */
    { 0x0d00, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/3/1/u */
    { 0x0d7f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/3/1/c */
    { 0x0e00, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/3/2/u */
    { 0x0e7f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/3/2/c */
    { 0x0f00, 0x3d2f, 0xb581, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800) }, /* #147/3/3/u */
    { 0x0f7f, 0x3d2f, 0x3d01, RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0x3e41a1bef1bd3a58,24800), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #147/3/3/c */
    { 0x0000, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/0/0/u */
    { 0x007f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/0/0/c */
    { 0x0100, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/0/1/u */
    { 0x017f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/0/1/c */
    { 0x0200, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/0/2/u */
    { 0x027f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/0/2/c */
    { 0x0300, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/0/3/u */
    { 0x037f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/0/3/c */
    { 0x0400, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/1/0/u */
    { 0x047f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/1/0/c */
    { 0x0500, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/1/1/u */
    { 0x057f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/1/1/c */
    { 0x0600, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/1/2/u */
    { 0x067f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/1/2/c */
    { 0x0700, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/1/3/u */
    { 0x077f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/1/3/c */
    { 0x0800, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/2/0/u */
    { 0x087f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/2/0/c */
    { 0x0900, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/2/1/u */
    { 0x097f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/2/1/c */
    { 0x0a00, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/2/2/u */
    { 0x0a7f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/2/2/c */
    { 0x0b00, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/2/3/u */
    { 0x0b7f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/2/3/c */
    { 0x0c00, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/3/0/u */
    { 0x0c7f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/3/0/c */
    { 0x0d00, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/3/1/u */
    { 0x0d7f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/3/1/c */
    { 0x0e00, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/3/2/u */
    { 0x0e7f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/3/2/c */
    { 0x0f00, 0x531c, 0xf181, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767) }, /* #148/3/3/u */
    { 0x0f7f, 0x531c, 0x7901, RTFLOAT80U_INIT_C(1,0xe717d94e567c00ca,9199), RTFLOAT80U_INIT_C(1,0xa8b5a2cd760e5,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #148/3/3/c */
    { 0x0000, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/0/u */
    { 0x007f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/0/c */
    { 0x0100, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/1/u */
    { 0x017f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/1/c */
    { 0x0200, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/2/u */
    { 0x027f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/2/c */
    { 0x0300, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/3/u */
    { 0x037f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/0/3/c */
    { 0x0400, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/0/u */
    { 0x047f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/0/c */
    { 0x0500, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/1/u */
    { 0x057f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/1/c */
    { 0x0600, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/2/u */
    { 0x067f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/2/c */
    { 0x0700, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/3/u */
    { 0x077f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/1/3/c */
    { 0x0800, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/0/u */
    { 0x087f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/0/c */
    { 0x0900, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/1/u */
    { 0x097f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/1/c */
    { 0x0a00, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/2/u */
    { 0x0a7f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/2/c */
    { 0x0b00, 0x9ac6, 0xbaa0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/3/u */
    { 0x0b7f, 0x9ac6, 0x3a20, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #149/2/3/c */
    { 0x0c00, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/0/u */
    { 0x0c7f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/0/c */
    { 0x0d00, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/1/u */
    { 0x0d7f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/1/c */
    { 0x0e00, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/2/u */
    { 0x0e7f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/2/c */
    { 0x0f00, 0x9ac6, 0xb8a0, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/3/u */
    { 0x0f7f, 0x9ac6, 0x3820, RTFLOAT80U_INIT_C(0,0xbe13d85b6fbb7d20,24116), RTFLOAT80U_INIT_C(0,0xac3a92beec247f9a,12148), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #149/3/3/c */
    { 0x0000, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/0/0/u */
    { 0x007f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/0/0/c */
    { 0x0100, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/0/1/u */
    { 0x017f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/0/1/c */
    { 0x0200, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/0/2/u */
    { 0x027f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/0/2/c */
    { 0x0300, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/0/3/u */
    { 0x037f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/0/3/c */
    { 0x0400, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/1/0/u */
    { 0x047f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/1/0/c */
    { 0x0500, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/1/1/u */
    { 0x057f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/1/1/c */
    { 0x0600, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/1/2/u */
    { 0x067f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/1/2/c */
    { 0x0700, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/1/3/u */
    { 0x077f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/1/3/c */
    { 0x0800, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/2/0/u */
    { 0x087f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/2/0/c */
    { 0x0900, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/2/1/u */
    { 0x097f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/2/1/c */
    { 0x0a00, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/2/2/u */
    { 0x0a7f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/2/2/c */
    { 0x0b00, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/2/3/u */
    { 0x0b7f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/2/3/c */
    { 0x0c00, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/3/0/u */
    { 0x0c7f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/3/0/c */
    { 0x0d00, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/3/1/u */
    { 0x0d7f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/3/1/c */
    { 0x0e00, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/3/2/u */
    { 0x0e7f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/3/2/c */
    { 0x0f00, 0xf5a9, 0xf581, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(0,0x0,32767) }, /* #150/3/3/u */
    { 0x0f7f, 0xf5a9, 0x7d01, RTFLOAT80U_INIT_C(1,0xfedf0c455cab7e07,9794), RTFLOAT80U_INIT_C(0,0x0,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #150/3/3/c */
    { 0x0000, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/0/u */
    { 0x007f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/0/c */
    { 0x0100, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/1/u */
    { 0x017f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/1/c */
    { 0x0200, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/2/u */
    { 0x027f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/2/c */
    { 0x0300, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/3/u */
    { 0x037f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/0/3/c */
    { 0x0400, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/0/u */
    { 0x047f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/0/c */
    { 0x0500, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/1/u */
    { 0x057f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/1/c */
    { 0x0600, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/2/u */
    { 0x067f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/2/c */
    { 0x0700, 0x3caa, 0xbea0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/3/u */
    { 0x077f, 0x3caa, 0x3e20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #151/1/3/c */
    { 0x0800, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/0/u */
    { 0x087f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/0/c */
    { 0x0900, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/1/u */
    { 0x097f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/1/c */
    { 0x0a00, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/2/u */
    { 0x0a7f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/2/c */
    { 0x0b00, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/3/u */
    { 0x0b7f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/2/3/c */
    { 0x0c00, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/0/u */
    { 0x0c7f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/0/c */
    { 0x0d00, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/1/u */
    { 0x0d7f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/1/c */
    { 0x0e00, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/2/u */
    { 0x0e7f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/2/c */
    { 0x0f00, 0x3caa, 0xbca0, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/3/u */
    { 0x0f7f, 0x3caa, 0x3c20, RTFLOAT80U_INIT_C(1,0x8f3fb20e65d52ff5,15604), RTFLOAT80U_INIT_C(0,0x93b04c7fcc26fd10,12274), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #151/3/3/c */
    { 0x0000, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/0/0/u */
    { 0x007f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/0/0/c */
    { 0x0100, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/0/1/u */
    { 0x017f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/0/1/c */
    { 0x0200, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/0/2/u */
    { 0x027f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/0/2/c */
    { 0x0300, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/0/3/u */
    { 0x037f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/0/3/c */
    { 0x0400, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/1/0/u */
    { 0x047f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/1/0/c */
    { 0x0500, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/1/1/u */
    { 0x057f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/1/1/c */
    { 0x0600, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/1/2/u */
    { 0x067f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/1/2/c */
    { 0x0700, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/1/3/u */
    { 0x077f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/1/3/c */
    { 0x0800, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/2/0/u */
    { 0x087f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/2/0/c */
    { 0x0900, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/2/1/u */
    { 0x097f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/2/1/c */
    { 0x0a00, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/2/2/u */
    { 0x0a7f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/2/2/c */
    { 0x0b00, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/2/3/u */
    { 0x0b7f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/2/3/c */
    { 0x0c00, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/3/0/u */
    { 0x0c7f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/3/0/c */
    { 0x0d00, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/3/1/u */
    { 0x0d7f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/3/1/c */
    { 0x0e00, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/3/2/u */
    { 0x0e7f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/3/2/c */
    { 0x0f00, 0x1f3a, 0xb581, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062) }, /* #152/3/3/u */
    { 0x0f7f, 0x1f3a, 0x3d01, RTFLOAT80U_INIT_C(0,0x762987deb101efd8,7065), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,19062), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #152/3/3/c */
    { 0x0000, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/0/0/u */
    { 0x007f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/0/0/c */
    { 0x0100, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/0/1/u */
    { 0x017f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/0/1/c */
    { 0x0200, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/0/2/u */
    { 0x027f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/0/2/c */
    { 0x0300, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/0/3/u */
    { 0x037f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/0/3/c */
    { 0x0400, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/1/0/u */
    { 0x047f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/1/0/c */
    { 0x0500, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/1/1/u */
    { 0x057f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/1/1/c */
    { 0x0600, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/1/2/u */
    { 0x067f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/1/2/c */
    { 0x0700, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/1/3/u */
    { 0x077f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/1/3/c */
    { 0x0800, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/2/0/u */
    { 0x087f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/2/0/c */
    { 0x0900, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/2/1/u */
    { 0x097f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/2/1/c */
    { 0x0a00, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/2/2/u */
    { 0x0a7f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/2/2/c */
    { 0x0b00, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/2/3/u */
    { 0x0b7f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/2/3/c */
    { 0x0c00, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/3/0/u */
    { 0x0c7f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/3/0/c */
    { 0x0d00, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/3/1/u */
    { 0x0d7f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/3/1/c */
    { 0x0e00, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/3/2/u */
    { 0x0e7f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/3/2/c */
    { 0x0f00, 0xb06f, 0xb081, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767) }, /* #153/3/3/u */
    { 0x0f7f, 0xb06f, 0x3801, RTFLOAT80U_INIT_C(1,0xd12df1889f75591e,12273), RTFLOAT80U_INIT_C(0,0xd4afce5f5794,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #153/3/3/c */
    { 0x0000, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/0/0/u */
    { 0x007f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/0/0/c */
    { 0x0100, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/0/1/u */
    { 0x017f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/0/1/c */
    { 0x0200, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/0/2/u */
    { 0x027f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/0/2/c */
    { 0x0300, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/0/3/u */
    { 0x037f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/0/3/c */
    { 0x0400, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/1/0/u */
    { 0x047f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/1/0/c */
    { 0x0500, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/1/1/u */
    { 0x057f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/1/1/c */
    { 0x0600, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/1/2/u */
    { 0x067f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/1/2/c */
    { 0x0700, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/1/3/u */
    { 0x077f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/1/3/c */
    { 0x0800, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/2/0/u */
    { 0x087f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/2/0/c */
    { 0x0900, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/2/1/u */
    { 0x097f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/2/1/c */
    { 0x0a00, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/2/2/u */
    { 0x0a7f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/2/2/c */
    { 0x0b00, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/2/3/u */
    { 0x0b7f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/2/3/c */
    { 0x0c00, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/3/0/u */
    { 0x0c7f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/3/0/c */
    { 0x0d00, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/3/1/u */
    { 0x0d7f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/3/1/c */
    { 0x0e00, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/3/2/u */
    { 0x0e7f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/3/2/c */
    { 0x0f00, 0x3e48, 0xb481, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767) }, /* #154/3/3/u */
    { 0x0f7f, 0x3e48, 0x3c01, RTFLOAT80U_INIT_C(0,0xc000000000000000,32767), RTFLOAT80U_INIT_C(1,0x8000000ca3d0911f,32767), RTFLOAT80U_INIT_C(0,0xc000000000000000,32767) }, /* #154/3/3/c */
    { 0x0000, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/0/0/u */
    { 0x007f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/0/0/c */
    { 0x0100, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/0/1/u */
    { 0x017f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/0/1/c */
    { 0x0200, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/0/2/u */
    { 0x027f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/0/2/c */
    { 0x0300, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/0/3/u */
    { 0x037f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/0/3/c */
    { 0x0400, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/1/0/u */
    { 0x047f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/1/0/c */
    { 0x0500, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/1/1/u */
    { 0x057f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/1/1/c */
    { 0x0600, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/1/2/u */
    { 0x067f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/1/2/c */
    { 0x0700, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/1/3/u */
    { 0x077f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/1/3/c */
    { 0x0800, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/2/0/u */
    { 0x087f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/2/0/c */
    { 0x0900, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/2/1/u */
    { 0x097f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/2/1/c */
    { 0x0a00, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/2/2/u */
    { 0x0a7f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/2/2/c */
    { 0x0b00, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/2/3/u */
    { 0x0b7f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/2/3/c */
    { 0x0c00, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/3/0/u */
    { 0x0c7f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/3/0/c */
    { 0x0d00, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/3/1/u */
    { 0x0d7f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/3/1/c */
    { 0x0e00, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/3/2/u */
    { 0x0e7f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/3/2/c */
    { 0x0f00, 0xcea6, 0xf481, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #155/3/3/u */
    { 0x0f7f, 0xcea6, 0x7c01, RTFLOAT80U_INIT_C(0,0x381dc6077890087,17728), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #155/3/3/c */
    { 0x0000, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/0/u */
    { 0x007f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/0/c */
    { 0x0100, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/1/u */
    { 0x017f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/1/c */
    { 0x0200, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/2/u */
    { 0x027f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/2/c */
    { 0x0300, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/3/u */
    { 0x037f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/0/3/c */
    { 0x0400, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/0/u */
    { 0x047f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/0/c */
    { 0x0500, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/1/u */
    { 0x057f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/1/c */
    { 0x0600, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/2/u */
    { 0x067f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/2/c */
    { 0x0700, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/3/u */
    { 0x077f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/1/3/c */
    { 0x0800, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/0/u */
    { 0x087f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/0/c */
    { 0x0900, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/1/u */
    { 0x097f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/1/c */
    { 0x0a00, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/2/u */
    { 0x0a7f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/2/c */
    { 0x0b00, 0x1bcb, 0xbba0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/3/u */
    { 0x0b7f, 0x1bcb, 0x3b20, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c235,16383) }, /* #156/2/3/c */
    { 0x0c00, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/0/u */
    { 0x0c7f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/0/c */
    { 0x0d00, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/1/u */
    { 0x0d7f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/1/c */
    { 0x0e00, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/2/u */
    { 0x0e7f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/2/c */
    { 0x0f00, 0x1bcb, 0xb9a0, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/3/u */
    { 0x0f7f, 0x1bcb, 0x3920, RTFLOAT80U_INIT_C(0,0x8000000000000000,32767), RTFLOAT80U_INIT_C(1,0xd68881c2eb00252c,29468), RTFLOAT80U_INIT_C(0,0xc90fdaa22168c234,16383) }, /* #156/3/3/c */
    { 0x0000, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/0/0/u */
    { 0x007f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/0/0/c */
    { 0x0100, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/0/1/u */
    { 0x017f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/0/1/c */
    { 0x0200, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/0/2/u */
    { 0x027f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/0/2/c */
    { 0x0300, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/0/3/u */
    { 0x037f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/0/3/c */
    { 0x0400, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/1/0/u */
    { 0x047f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/1/0/c */
    { 0x0500, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/1/1/u */
    { 0x057f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/1/1/c */
    { 0x0600, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/1/2/u */
    { 0x067f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/1/2/c */
    { 0x0700, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/1/3/u */
    { 0x077f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/1/3/c */
    { 0x0800, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/2/0/u */
    { 0x087f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/2/0/c */
    { 0x0900, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/2/1/u */
    { 0x097f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/2/1/c */
    { 0x0a00, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/2/2/u */
    { 0x0a7f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/2/2/c */
    { 0x0b00, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/2/3/u */
    { 0x0b7f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/2/3/c */
    { 0x0c00, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/3/0/u */
    { 0x0c7f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/3/0/c */
    { 0x0d00, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/3/1/u */
    { 0x0d7f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/3/1/c */
    { 0x0e00, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/3/2/u */
    { 0x0e7f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/3/2/c */
    { 0x0f00, 0xc776, 0xf581, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270) }, /* #157/3/3/u */
    { 0x0f7f, 0xc776, 0x7d01, RTFLOAT80U_INIT_C(1,0x1100783f3036d802,6564), RTFLOAT80U_INIT_C(1,0xbf68772fcc6dd7a4,20270), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #157/3/3/c */
    { 0x0000, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/0/0/u */
    { 0x007f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/0/0/c */
    { 0x0100, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/0/1/u */
    { 0x017f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/0/1/c */
    { 0x0200, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/0/2/u */
    { 0x027f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/0/2/c */
    { 0x0300, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/0/3/u */
    { 0x037f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/0/3/c */
    { 0x0400, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/1/0/u */
    { 0x047f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/1/0/c */
    { 0x0500, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/1/1/u */
    { 0x057f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/1/1/c */
    { 0x0600, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/1/2/u */
    { 0x067f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/1/2/c */
    { 0x0700, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/1/3/u */
    { 0x077f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/1/3/c */
    { 0x0800, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/2/0/u */
    { 0x087f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/2/0/c */
    { 0x0900, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/2/1/u */
    { 0x097f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/2/1/c */
    { 0x0a00, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/2/2/u */
    { 0x0a7f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/2/2/c */
    { 0x0b00, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/2/3/u */
    { 0x0b7f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/2/3/c */
    { 0x0c00, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/3/0/u */
    { 0x0c7f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/3/0/c */
    { 0x0d00, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/3/1/u */
    { 0x0d7f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/3/1/c */
    { 0x0e00, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/3/2/u */
    { 0x0e7f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/3/2/c */
    { 0x0f00, 0x1249, 0xb081, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550) }, /* #158/3/3/u */
    { 0x0f7f, 0x1249, 0x3801, RTFLOAT80U_INIT_C(0,0xffffffffffffffff,32766), RTFLOAT80U_INIT_C(1,0x4225db1422a8f3eb,32550), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #158/3/3/c */
    { 0x0000, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/0/0/u */
    { 0x007f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/0/0/c */
    { 0x0100, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/0/1/u */
    { 0x017f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/0/1/c */
    { 0x0200, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/0/2/u */
    { 0x027f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/0/2/c */
    { 0x0300, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/0/3/u */
    { 0x037f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/0/3/c */
    { 0x0400, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/1/0/u */
    { 0x047f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/1/0/c */
    { 0x0500, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/1/1/u */
    { 0x057f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/1/1/c */
    { 0x0600, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/1/2/u */
    { 0x067f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/1/2/c */
    { 0x0700, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/1/3/u */
    { 0x077f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/1/3/c */
    { 0x0800, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/2/0/u */
    { 0x087f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/2/0/c */
    { 0x0900, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/2/1/u */
    { 0x097f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/2/1/c */
    { 0x0a00, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/2/2/u */
    { 0x0a7f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/2/2/c */
    { 0x0b00, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/2/3/u */
    { 0x0b7f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/2/3/c */
    { 0x0c00, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/3/0/u */
    { 0x0c7f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/3/0/c */
    { 0x0d00, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/3/1/u */
    { 0x0d7f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/3/1/c */
    { 0x0e00, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/3/2/u */
    { 0x0e7f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/3/2/c */
    { 0x0f00, 0x50c6, 0xf081, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(0,0xa4634b3,2121) }, /* #159/3/3/u */
    { 0x0f7f, 0x50c6, 0x7801, RTFLOAT80U_INIT_C(1,0xffffffffffffffff,32762), RTFLOAT80U_INIT_C(0,0xa4634b3,2121), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #159/3/3/c */
    { 0x0000, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/0/0/u */
    { 0x007f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/0/0/c */
    { 0x0100, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/0/1/u */
    { 0x017f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/0/1/c */
    { 0x0200, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/0/2/u */
    { 0x027f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/0/2/c */
    { 0x0300, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/0/3/u */
    { 0x037f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/0/3/c */
    { 0x0400, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/1/0/u */
    { 0x047f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/1/0/c */
    { 0x0500, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/1/1/u */
    { 0x057f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/1/1/c */
    { 0x0600, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/1/2/u */
    { 0x067f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/1/2/c */
    { 0x0700, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/1/3/u */
    { 0x077f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/1/3/c */
    { 0x0800, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/2/0/u */
    { 0x087f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/2/0/c */
    { 0x0900, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/2/1/u */
    { 0x097f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/2/1/c */
    { 0x0a00, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/2/2/u */
    { 0x0a7f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/2/2/c */
    { 0x0b00, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/2/3/u */
    { 0x0b7f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/2/3/c */
    { 0x0c00, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/3/0/u */
    { 0x0c7f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/3/0/c */
    { 0x0d00, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/3/1/u */
    { 0x0d7f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/3/1/c */
    { 0x0e00, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/3/2/u */
    { 0x0e7f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/3/2/c */
    { 0x0f00, 0xf65d, 0xf481, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1) }, /* #160/3/3/u */
    { 0x0f7f, 0xf65d, 0x7c01, RTFLOAT80U_INIT_C(0,0x28d7dbf24ebf2bd9,8868), RTFLOAT80U_INIT_C(1,0xffffffffffffffff,1), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #160/3/3/c */
    { 0x0000, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/0/0/u */
    { 0x007f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/0/0/c */
    { 0x0100, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/0/1/u */
    { 0x017f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/0/1/c */
    { 0x0200, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/0/2/u */
    { 0x027f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/0/2/c */
    { 0x0300, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/0/3/u */
    { 0x037f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/0/3/c */
    { 0x0400, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/1/0/u */
    { 0x047f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/1/0/c */
    { 0x0500, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/1/1/u */
    { 0x057f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/1/1/c */
    { 0x0600, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/1/2/u */
    { 0x067f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/1/2/c */
    { 0x0700, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/1/3/u */
    { 0x077f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/1/3/c */
    { 0x0800, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/2/0/u */
    { 0x087f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/2/0/c */
    { 0x0900, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/2/1/u */
    { 0x097f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/2/1/c */
    { 0x0a00, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/2/2/u */
    { 0x0a7f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/2/2/c */
    { 0x0b00, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/2/3/u */
    { 0x0b7f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/2/3/c */
    { 0x0c00, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/3/0/u */
    { 0x0c7f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/3/0/c */
    { 0x0d00, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/3/1/u */
    { 0x0d7f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/3/1/c */
    { 0x0e00, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/3/2/u */
    { 0x0e7f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/3/2/c */
    { 0x0f00, 0x36af, 0xb481, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006) }, /* #161/3/3/u */
    { 0x0f7f, 0x36af, 0x3c01, RTFLOAT80U_INIT_C(0,0x4ae5cf4bcbc36bf9,19075), RTFLOAT80U_INIT_C(0,0xe272123c7aec1950,13006), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #161/3/3/c */
    { 0x0000, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/0/0/u */
    { 0x007f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/0/0/c */
    { 0x0100, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/0/1/u */
    { 0x017f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/0/1/c */
    { 0x0200, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/0/2/u */
    { 0x027f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/0/2/c */
    { 0x0300, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/0/3/u */
    { 0x037f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/0/3/c */
    { 0x0400, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/1/0/u */
    { 0x047f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/1/0/c */
    { 0x0500, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/1/1/u */
    { 0x057f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/1/1/c */
    { 0x0600, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/1/2/u */
    { 0x067f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/1/2/c */
    { 0x0700, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/1/3/u */
    { 0x077f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/1/3/c */
    { 0x0800, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/2/0/u */
    { 0x087f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/2/0/c */
    { 0x0900, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/2/1/u */
    { 0x097f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/2/1/c */
    { 0x0a00, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/2/2/u */
    { 0x0a7f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/2/2/c */
    { 0x0b00, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/2/3/u */
    { 0x0b7f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/2/3/c */
    { 0x0c00, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/3/0/u */
    { 0x0c7f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/3/0/c */
    { 0x0d00, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/3/1/u */
    { 0x0d7f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/3/1/c */
    { 0x0e00, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/3/2/u */
    { 0x0e7f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/3/2/c */
    { 0x0f00, 0xdda6, 0xf581, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767) }, /* #162/3/3/u */
    { 0x0f7f, 0xdda6, 0x7d01, RTFLOAT80U_INIT_C(1,0x2,608), RTFLOAT80U_INIT_C(0,0x48ec3346173a9c4f,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #162/3/3/c */
    { 0x0000, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/0/0/u */
    { 0x007f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/0/0/c */
    { 0x0100, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/0/1/u */
    { 0x017f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/0/1/c */
    { 0x0200, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/0/2/u */
    { 0x027f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/0/2/c */
    { 0x0300, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/0/3/u */
    { 0x037f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/0/3/c */
    { 0x0400, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/1/0/u */
    { 0x047f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/1/0/c */
    { 0x0500, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/1/1/u */
    { 0x057f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/1/1/c */
    { 0x0600, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/1/2/u */
    { 0x067f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/1/2/c */
    { 0x0700, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/1/3/u */
    { 0x077f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/1/3/c */
    { 0x0800, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/2/0/u */
    { 0x087f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/2/0/c */
    { 0x0900, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/2/1/u */
    { 0x097f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/2/1/c */
    { 0x0a00, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/2/2/u */
    { 0x0a7f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/2/2/c */
    { 0x0b00, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/2/3/u */
    { 0x0b7f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/2/3/c */
    { 0x0c00, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/3/0/u */
    { 0x0c7f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/3/0/c */
    { 0x0d00, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/3/1/u */
    { 0x0d7f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/3/1/c */
    { 0x0e00, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/3/2/u */
    { 0x0e7f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/3/2/c */
    { 0x0f00, 0x8bf6, 0xb181, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640) }, /* #163/3/3/u */
    { 0x0f7f, 0x8bf6, 0x3901, RTFLOAT80U_INIT_C(0,0x7cd3d9eafd8e1c0,21522), RTFLOAT80U_INIT_C(0,0x86d98cce1436831b,19640), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #163/3/3/c */
    { 0x0000, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/0/0/u */
    { 0x007f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/0/0/c */
    { 0x0100, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/0/1/u */
    { 0x017f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/0/1/c */
    { 0x0200, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/0/2/u */
    { 0x027f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/0/2/c */
    { 0x0300, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/0/3/u */
    { 0x037f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/0/3/c */
    { 0x0400, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/1/0/u */
    { 0x047f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/1/0/c */
    { 0x0500, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/1/1/u */
    { 0x057f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/1/1/c */
    { 0x0600, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/1/2/u */
    { 0x067f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/1/2/c */
    { 0x0700, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/1/3/u */
    { 0x077f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/1/3/c */
    { 0x0800, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/2/0/u */
    { 0x087f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/2/0/c */
    { 0x0900, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/2/1/u */
    { 0x097f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/2/1/c */
    { 0x0a00, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/2/2/u */
    { 0x0a7f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/2/2/c */
    { 0x0b00, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/2/3/u */
    { 0x0b7f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/2/3/c */
    { 0x0c00, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/3/0/u */
    { 0x0c7f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/3/0/c */
    { 0x0d00, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/3/1/u */
    { 0x0d7f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/3/1/c */
    { 0x0e00, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/3/2/u */
    { 0x0e7f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/3/2/c */
    { 0x0f00, 0xb5c9, 0xb581, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013) }, /* #164/3/3/u */
    { 0x0f7f, 0xb5c9, 0x3d01, RTFLOAT80U_INIT_C(0,0x34cf098f4dda44,22522), RTFLOAT80U_INIT_C(1,0xdfa5b411c77471af,31013), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #164/3/3/c */
    { 0x0000, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/0/0/u */
    { 0x007f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/0/0/c */
    { 0x0100, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/0/1/u */
    { 0x017f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/0/1/c */
    { 0x0200, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/0/2/u */
    { 0x027f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/0/2/c */
    { 0x0300, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/0/3/u */
    { 0x037f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/0/3/c */
    { 0x0400, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/1/0/u */
    { 0x047f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/1/0/c */
    { 0x0500, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/1/1/u */
    { 0x057f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/1/1/c */
    { 0x0600, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/1/2/u */
    { 0x067f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/1/2/c */
    { 0x0700, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/1/3/u */
    { 0x077f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/1/3/c */
    { 0x0800, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/2/0/u */
    { 0x087f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/2/0/c */
    { 0x0900, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/2/1/u */
    { 0x097f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/2/1/c */
    { 0x0a00, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/2/2/u */
    { 0x0a7f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/2/2/c */
    { 0x0b00, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/2/3/u */
    { 0x0b7f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/2/3/c */
    { 0x0c00, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/3/0/u */
    { 0x0c7f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/3/0/c */
    { 0x0d00, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/3/1/u */
    { 0x0d7f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/3/1/c */
    { 0x0e00, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/3/2/u */
    { 0x0e7f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/3/2/c */
    { 0x0f00, 0x07c0, 0xb581, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384) }, /* #165/3/3/u */
    { 0x0f7f, 0x07c0, 0x3d01, RTFLOAT80U_INIT_C(0,0x3f1142f5fa09,0), RTFLOAT80U_INIT_C(0,0x76f20a0ad7894c53,21384), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #165/3/3/c */
    { 0x0000, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/0/0/u */
    { 0x007f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/0/0/c */
    { 0x0100, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/0/1/u */
    { 0x017f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/0/1/c */
    { 0x0200, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/0/2/u */
    { 0x027f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/0/2/c */
    { 0x0300, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/0/3/u */
    { 0x037f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/0/3/c */
    { 0x0400, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/1/0/u */
    { 0x047f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/1/0/c */
    { 0x0500, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/1/1/u */
    { 0x057f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/1/1/c */
    { 0x0600, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/1/2/u */
    { 0x067f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/1/2/c */
    { 0x0700, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/1/3/u */
    { 0x077f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/1/3/c */
    { 0x0800, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/2/0/u */
    { 0x087f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/2/0/c */
    { 0x0900, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/2/1/u */
    { 0x097f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/2/1/c */
    { 0x0a00, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/2/2/u */
    { 0x0a7f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/2/2/c */
    { 0x0b00, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/2/3/u */
    { 0x0b7f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/2/3/c */
    { 0x0c00, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/3/0/u */
    { 0x0c7f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/3/0/c */
    { 0x0d00, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/3/1/u */
    { 0x0d7f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/3/1/c */
    { 0x0e00, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/3/2/u */
    { 0x0e7f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/3/2/c */
    { 0x0f00, 0x23b0, 0xb181, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767) }, /* #166/3/3/u */
    { 0x0f7f, 0x23b0, 0x3901, RTFLOAT80U_INIT_C(1,0x37ebaca8ff5f0798,1818), RTFLOAT80U_INIT_C(1,0x14a2a71d31,32767), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #166/3/3/c */
    { 0x0000, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/0/0/u */
    { 0x007f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/0/0/c */
    { 0x0100, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/0/1/u */
    { 0x017f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/0/1/c */
    { 0x0200, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/0/2/u */
    { 0x027f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/0/2/c */
    { 0x0300, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/0/3/u */
    { 0x037f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/0/3/c */
    { 0x0400, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/1/0/u */
    { 0x047f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/1/0/c */
    { 0x0500, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/1/1/u */
    { 0x057f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/1/1/c */
    { 0x0600, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/1/2/u */
    { 0x067f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/1/2/c */
    { 0x0700, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/1/3/u */
    { 0x077f, 0x7419, 0x7e22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814ff,9548) }, /* #167/1/3/c */
    { 0x0800, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/2/0/u */
    { 0x087f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/2/0/c */
    { 0x0900, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/2/1/u */
    { 0x097f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/2/1/c */
    { 0x0a00, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/2/2/u */
    { 0x0a7f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/2/2/c */
    { 0x0b00, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/2/3/u */
    { 0x0b7f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/2/3/c */
    { 0x0c00, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/3/0/u */
    { 0x0c7f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/3/0/c */
    { 0x0d00, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/3/1/u */
    { 0x0d7f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/3/1/c */
    { 0x0e00, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/3/2/u */
    { 0x0e7f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/3/2/c */
    { 0x0f00, 0x7419, 0xf482, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833) }, /* #167/3/3/u */
    { 0x0f7f, 0x7419, 0x7c22, RTFLOAT80U_INIT_C(1,0x244c53098c4f35aa,0), RTFLOAT80U_INIT_C(0,0xb5c77e8fd3b49977,6833), RTFLOAT80U_INIT_C(1,0xcc799277af8814fe,9548) }, /* #167/3/3/c */
    { 0x0000, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/0/0/u */
    { 0x007f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/0/0/c */
    { 0x0100, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/0/1/u */
    { 0x017f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/0/1/c */
    { 0x0200, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/0/2/u */
    { 0x027f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/0/2/c */
    { 0x0300, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/0/3/u */
    { 0x037f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/0/3/c */
    { 0x0400, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/1/0/u */
    { 0x047f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/1/0/c */
    { 0x0500, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/1/1/u */
    { 0x057f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/1/1/c */
    { 0x0600, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/1/2/u */
    { 0x067f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/1/2/c */
    { 0x0700, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/1/3/u */
    { 0x077f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/1/3/c */
    { 0x0800, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/2/0/u */
    { 0x087f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/2/0/c */
    { 0x0900, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/2/1/u */
    { 0x097f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/2/1/c */
    { 0x0a00, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/2/2/u */
    { 0x0a7f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/2/2/c */
    { 0x0b00, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/2/3/u */
    { 0x0b7f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/2/3/c */
    { 0x0c00, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/3/0/u */
    { 0x0c7f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/3/0/c */
    { 0x0d00, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/3/1/u */
    { 0x0d7f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/3/1/c */
    { 0x0e00, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/3/2/u */
    { 0x0e7f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/3/2/c */
    { 0x0f00, 0xdcb9, 0xf481, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0) }, /* #168/3/3/u */
    { 0x0f7f, 0xdcb9, 0x7c01, RTFLOAT80U_INIT_C(0,0x5ac498115ee53813,25092), RTFLOAT80U_INIT_C(1,0x8e0d360d05adb03c,0), RTFLOAT80U_INIT_C(1,0xc000000000000000,32767) }, /* #168/3/3/c */
    { 0x0000, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/0/0/u */
    { 0x007f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/0/0/c */
    { 0x0100, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/0/1/u */
    { 0x017f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/0/1/c */
    { 0x0200, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/0/2/u */
    { 0x027f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/0/2/c */
    { 0x0300, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/0/3/u */
    { 0x037f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/0/3/c */
    { 0x0400, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/1/0/u */
    { 0x047f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/1/0/c */
    { 0x0500, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/1/1/u */
    { 0x057f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/1/1/c */
    { 0x0600, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/1/2/u */
    { 0x067f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/1/2/c */
    { 0x0700, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/1/3/u */
    { 0x077f, 0xa164, 0x3b22, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c235,16383) }, /* #169/1/3/c */
    { 0x0800, 0xa164, 0xb182, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0) }, /* #169/2/0/u */
    { 0x087f, 0xa164, 0x3922, RTFLOAT80U_INIT_C(1,0xfbbe5e018a6b1346,21279), RTFLOAT80U_INIT_C(1,0xa319c1b63bbdb29e,0), RTFLOAT80U_INIT_C(1,0xc90fdaa22168c234,16383) }, /* #169/2/0/c */
    { 0x0900, 0xa164, 0xb182