//
// XmlSerializableServices.cs
//
// Author:
//	Atsushi Enomoto <atsushi@ximian.com>
//
// Copyright (C) 2005 Novell, Inc.  http://www.novell.com
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
#if NET_2_0
using System;
using System.Collections.Generic;
using System.IO;
using System.Xml;
using System.Xml.Schema;

using QName = System.Xml.XmlQualifiedName;

namespace System.Runtime.Serialization
{
	public static class XmlSerializableServices
	{
		static Dictionary<QName, XmlSchemaSet> defaultSchemas
			= new Dictionary<QName, XmlSchemaSet> ();

		[MonoTODO]
		public static void AddDefaultSchema (
			XmlSchemaSet schemas,
			QName typeQName)
		{
			throw new NotImplementedException ();
		}

		public static XmlNode [] ReadNodes (XmlReader xmlReader)
		{
			if (xmlReader.NodeType != XmlNodeType.Element || xmlReader.IsEmptyElement)
				return new XmlNode [0];

			int depth = xmlReader.Depth;
			xmlReader.Read ();
			if (xmlReader.NodeType == XmlNodeType.EndElement)
				return new XmlNode [0];

			List<XmlNode> al = new List<XmlNode> ();
			XmlDocument doc = new XmlDocument ();
			while (xmlReader.Depth > depth & !xmlReader.EOF)
				al.Add (doc.ReadNode (xmlReader));
			return al.ToArray ();
		}

		public static void WriteNodes (XmlWriter xmlWriter,
			XmlNode [] nodes)
		{
			foreach (XmlNode n in nodes)
				n.WriteTo (xmlWriter);
		}
	}
}
#endif
