# -*- Autoconf -*-
#
# Copyright (c) 2006-2007 The ABINIT Group (Yann Pouillon)
# All rights reserved.
#
# This file is part of the ABINIT software package. For license information,
# please see the COPYING file in the top-level directory of the ABINIT source
# distribution.
#

#
# File I/O
#



# ABI_LOAD_OPTIONS()
# ------------------
#
# Looks for options to the configure script in predefined locations:
#
#  * system-wide : /etc/abinit/build/hostname.ac
#  * per-user    : ~/.abinit/build/hostname.ac
#  * local       : <current_directory>/hostname.ac
#
# and eventually in a command-line-specified file. "hostname" is the
# name of the machine without the domain name. The last valid file is
# the one to be read.
#
# NOTE
#
#    The name choosen for the per-user the config file allows the peaceful
#    coexistence of several option sets on machines sharing the same home
#    directory.
#
AC_DEFUN([ABI_LOAD_OPTIONS],
[dnl Setup file names
 abi_hostname=`hostname | sed -e 's/\..*//'`
 abi_sys_options="/etc/abinit/build/${abi_hostname}.ac"
 abi_per_options="${HOME}/.abinit/build/${abi_hostname}.ac"
 abi_src_options="${abinit_srcdir}/${abi_hostname}.ac"
 abi_loc_options="./${abi_hostname}.ac"
 abi_cmd_options="${with_config_file}"
 abi_cfg_options=""

 dnl Select and read config file
 if test "${enable_config_file}" = "yes"; then
  for abi_options in "${abi_sys_options}" "${abi_per_options}" \
                     "${abi_src_options}" "${abi_loc_options}" \
                     "${abi_cmd_options}"; do
   if test -s "${abi_options}"; then
    abi_cfg_options="${abi_options}"
   fi
  done
  if test "${abi_cfg_options}" != ""; then
   AC_MSG_NOTICE([reading options from ${abi_cfg_options}])
   . ${abi_cfg_options}
  fi
 fi
]) # ABI_LOAD_OPTIONS



# ABI_LOAD_OPTFLAGS(COMPILER, VERSION, ARCHITECTURE)
# --------------------------------------------------
#
# Looks for default optimization flags for a specified compiler and
# a specified version, running on a specified architecture. Load them
# if found.
#
AC_DEFUN([ABI_LOAD_OPTFLAGS],
[dnl Do some sanity checking of the arguments
 m4_if([$1], , [AC_FATAL([$0: missing argument 1])])dnl
 m4_if([$2], , [AC_FATAL([$0: missing argument 2])])dnl
 m4_if([$2], , [AC_FATAL([$0: missing argument 3])])dnl

 dnl Look for a completely independent file
 abi_optflags_file="${ac_top_srcdir}/config/optflags/$1/all/all"
 #AC_MSG_NOTICE([checking ${abi_optflags_file}])
 if test -s "${abi_optflags_file}"; then
  AC_MSG_NOTICE([applying optimizations for $1/all/all])
  . "${abi_optflags_file}"
 fi
 
 dnl Look for an architecture-specific file (might override previous defaults)
 abi_optflags_file="${ac_top_srcdir}/config/optflags/$1/all/$3"
 #AC_MSG_NOTICE([checking ${abi_optflags_file}])
 if test -s "${abi_optflags_file}"; then
  AC_MSG_NOTICE([applying optimizations for $1/all/$3])
  . "${abi_optflags_file}"
 fi
 
 dnl Look for a version-specific file (might override previous defaults)
 abi_optflags_file="${ac_top_srcdir}/config/optflags/$1/$2/all"
 #AC_MSG_NOTICE([checking ${abi_optflags_file}])
 if test -s "${abi_optflags_file}"; then
  AC_MSG_NOTICE([applying optimizations for $1/$2/all])
  . "${abi_optflags_file}"
 fi

 dnl Look for a fully specific file (might override previous defaults)
 abi_optflags_file="${ac_top_srcdir}/config/optflags/$1/$2/$3"
 #AC_MSG_NOTICE([checking ${abi_optflags_file}])
 if test -s "${abi_optflags_file}"; then
  AC_MSG_NOTICE([applying optimizations for $1/$2/$3])
  . "${abi_optflags_file}"
 fi
]) # ABI_LOAD_OPTFLAGS
