!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_newvtr
!! NAME
!! wvl_newvtr
!!
!! FUNCTION
!! Compute new trial potential by summing all components.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2014 ABINIT group (DCA, XG, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  mpi_enreg=informations about MPI parallelization
!!
!! OUTPUT
!!  vtrial(nfft,nspden)=new potential
!!
!! NOTES
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine wvl_newvtr( nfft,nspden,vtrial, wvl,wvl_den)

 use defs_basis
 use defs_wvltypes
 use m_profiling
 use m_errors
#if defined HAVE_DFT_BIGDFT
  use BigDFT_API, only : KS_POTENTIAL,HARTREE_POTENTIAL
#endif

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'wvl_newvtr'
 use interfaces_67_common, except_this_one => wvl_newvtr
!End of the abilint section

 implicit none

!Arguments-------------------------------
!scalars
 integer,intent(in):: nfft,nspden
 type(wvl_internal_type), intent(in) :: wvl
 type(wvl_denspot_type), intent(inout) :: wvl_den
!arrays
 real(dp),intent(out) :: vtrial(nfft*nspden)

!Local variables-------------------------------
!scalars
 character(len=500) :: message

! *************************************************************************

 DBG_ENTER("COLL")

#if defined HAVE_DFT_BIGDFT

 if(wvl_den%denspot%rhov_is .ne. HARTREE_POTENTIAL) then
   message= "wvl_newvtr: rhov should contain the Hartree potential"
   MSG_ERROR(message)
 end if

 if (nspden == 2) then
   call dcopy(wvl%Glr%d%n1i*wvl%Glr%d%n2i*wvl_den%denspot%dpbox%n3p,wvl_den%denspot%rhov(1),1,&
   wvl_den%denspot%rhov(1+wvl%Glr%d%n1i*wvl%Glr%d%n2i*wvl_den%denspot%dpbox%n3p),1)
 end if

!Here rhov is: H_potential + V_ion

!spin up and down together with the XC part
 call axpy(wvl%Glr%d%n1i*wvl%Glr%d%n2i*wvl_den%denspot%dpbox%n3p*nspden,&
& 1.0d0,wvl_den%denspot%V_XC,&
& wvl_den%denspot%rhov)

!write(message, '(a,a,a,a)' ) ch10, ' wvl_newvtr : but why are you copying me :..o('
!call wrtout(std_out,message,'COLL')
!wvl_den%denspot%rhov= reshape(vtrial, shape(wvl_den%denspot%rhov))
!vtrial= reshape(wvl_den%denspot%rhov, shape(vtrial))

 wvl_den%denspot%rhov_is=KS_POTENTIAL
 call wvl_vtrial_abi2big(nfft,nspden,2,vtrial,wvl_den)


#else
 write(message, '(a,a,a,a)' ) ch10,&
& ' wvl_newvtr: BUG -',ch10,&
& '  BigDFT is not compiled. Use --enable-bigdft during configure.'
 MSG_BUG(message)
#endif


 DBG_EXIT("COLL")

 contains
!!***

!!****f* wvl_newvtr/axpy
!! NAME
!!  axpy
!!
!! FUNCTION
!!
!! COPYRIGHT
!!  Copyright (C) 2011-2014 ABINIT group (T. Rangel)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!
!! PARENTS
!!      wvl_newvtr
!!
!! CHILDREN
!!
!! SOURCE

subroutine axpy(nx,a,x,y)


!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'axpy'
!End of the abilint section

 implicit none

!Arguments -------------------------------
!scalars
 integer,intent(in)::nx
 real(dp),intent(in)::a
!arrays
 real(dp),intent(in)::x(nx)
 real(dp),intent(inout)::y(nx)

!Local variables -------------------------

! *********************************************************************

   y(:)=a*x(:)+y(:)

 end subroutine axpy

end subroutine wvl_newvtr
!!***
