#!/bin/sh
# This script creates '*_ext_alias.h' from '*_ext_api.h' in
# include/allegro5/opengl/GLext/ dir

prefix="glx wgl gl"

for name in $prefix; do
	src="include/allegro5/opengl/GLext/"$name"_ext_api.h"
	out="include/allegro5/opengl/GLext/"$name"_ext_alias.h"
	prfx=`echo $name | sed 's/glx/glX/'`
	cat $src | sed -e '/^[ 	]*#/!s/[ 	]//g' | awk -F"," "BEGIN{print\"/*Automatically generated by gl_mkalias.sh DO NOT EDIT!*/\"}
	{if (\$0 ~ /^AGL_API/) printf \"#define $prfx%s _al_$prfx%s\n\",\$2,\$2;
	else print \$0}" > $out
done
