
#line 3 "<stdout>"

#define  MGN_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define MGN_FLEX_MAJOR_VERSION 2
#define MGN_FLEX_MINOR_VERSION 5
#define MGN_FLEX_SUBMINOR_VERSION 35
#if MGN_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define MGN_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define MGN_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef MGN_USE_CONST
#define mgnconst const
#else
#define mgnconst
#endif

/* Returned upon end-of-file. */
#define MGN_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define MGN_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (mgn_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The MGNSTATE alias is for lex
 * compatibility.
 */
#define MGN_START (((mgn_start) - 1) / 2)
#define MGNSTATE MGN_START

/* Action number for EOF rule of a given start state. */
#define MGN_STATE_EOF(state) (MGN_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define MGN_NEW_FILE mgnrestart(mgnin  )

#define MGN_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef MGN_BUF_SIZE
#define MGN_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define MGN_STATE_BUF_SIZE   ((MGN_BUF_SIZE + 2) * sizeof(mgn_state_type))

#ifndef MGN_TYPEDEF_MGN_BUFFER_STATE
#define MGN_TYPEDEF_MGN_BUFFER_STATE
typedef struct mgn_buffer_state *MGN_BUFFER_STATE;
#endif

extern int mgnleng;

extern FILE *mgnin, *mgnout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define MGN_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define mgnless(n) \
	do \
		{ \
		/* Undo effects of setting up mgntext. */ \
        int mgnless_macro_arg = (n); \
        MGN_LESS_LINENO(mgnless_macro_arg);\
		*mgn_cp = (mgn_hold_char); \
		MGN_RESTORE_MGN_MORE_OFFSET \
		(mgn_c_buf_p) = mgn_cp = mgn_bp + mgnless_macro_arg - MGN_MORE_ADJ; \
		MGN_DO_BEFORE_ACTION; /* set up mgntext again */ \
		} \
	while ( 0 )

#define unput(c) mgnunput( c, (mgntext_ptr)  )

#ifndef MGN_TYPEDEF_MGN_SIZE_T
#define MGN_TYPEDEF_MGN_SIZE_T
typedef size_t mgn_size_t;
#endif

#ifndef MGN_STRUCT_MGN_BUFFER_STATE
#define MGN_STRUCT_MGN_BUFFER_STATE
struct mgn_buffer_state
	{
	FILE *mgn_input_file;

	char *mgn_ch_buf;		/* input buffer */
	char *mgn_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	mgn_size_t mgn_buf_size;

	/* Number of characters read into mgn_ch_buf, not including EOB
	 * characters.
	 */
	int mgn_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int mgn_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int mgn_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int mgn_at_bol;

    int mgn_bs_lineno; /**< The line count. */
    int mgn_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int mgn_fill_buffer;

	int mgn_buffer_status;

#define MGN_BUFFER_NEW 0
#define MGN_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as MGN_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via mgnrestart()), so that the user can continue scanning by
	 * just pointing mgnin at a new input file.
	 */
#define MGN_BUFFER_EOF_PENDING 2

	};
#endif /* !MGN_STRUCT_MGN_BUFFER_STATE */

/* Stack of input buffers. */
static size_t mgn_buffer_stack_top = 0; /**< index of top of stack. */
static size_t mgn_buffer_stack_max = 0; /**< capacity of stack. */
static MGN_BUFFER_STATE * mgn_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define MGN_CURRENT_BUFFER ( (mgn_buffer_stack) \
                          ? (mgn_buffer_stack)[(mgn_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define MGN_CURRENT_BUFFER_LVALUE (mgn_buffer_stack)[(mgn_buffer_stack_top)]

/* mgn_hold_char holds the character lost when mgntext is formed. */
static char mgn_hold_char;
static int mgn_n_chars;		/* number of characters read into mgn_ch_buf */
int mgnleng;

/* Points to current character in buffer. */
static char *mgn_c_buf_p = (char *) 0;
static int mgn_init = 0;		/* whether we need to initialize */
static int mgn_start = 0;	/* start state number */

/* Flag which is used to allow mgnwrap()'s to do buffer switches
 * instead of setting up a fresh mgnin.  A bit of a hack ...
 */
static int mgn_did_buffer_switch_on_eof;

void mgnrestart (FILE *input_file  );
void mgn_switch_to_buffer (MGN_BUFFER_STATE new_buffer  );
MGN_BUFFER_STATE mgn_create_buffer (FILE *file,int size  );
void mgn_delete_buffer (MGN_BUFFER_STATE b  );
void mgn_flush_buffer (MGN_BUFFER_STATE b  );
void mgnpush_buffer_state (MGN_BUFFER_STATE new_buffer  );
void mgnpop_buffer_state (void );

static void mgnensure_buffer_stack (void );
static void mgn_load_buffer_state (void );
static void mgn_init_buffer (MGN_BUFFER_STATE b,FILE *file  );

#define MGN_FLUSH_BUFFER mgn_flush_buffer(MGN_CURRENT_BUFFER )

MGN_BUFFER_STATE mgn_scan_buffer (char *base,mgn_size_t size  );
MGN_BUFFER_STATE mgn_scan_string (mgnconst char *mgn_str  );
MGN_BUFFER_STATE mgn_scan_bytes (mgnconst char *bytes,int len  );

void *mgnalloc (mgn_size_t  );
void *mgnrealloc (void *,mgn_size_t  );
void mgnfree (void *  );

#define mgn_new_buffer mgn_create_buffer

#define mgn_set_interactive(is_interactive) \
	{ \
	if ( ! MGN_CURRENT_BUFFER ){ \
        mgnensure_buffer_stack (); \
		MGN_CURRENT_BUFFER_LVALUE =    \
            mgn_create_buffer(mgnin,MGN_BUF_SIZE ); \
	} \
	MGN_CURRENT_BUFFER_LVALUE->mgn_is_interactive = is_interactive; \
	}

#define mgn_set_bol(at_bol) \
	{ \
	if ( ! MGN_CURRENT_BUFFER ){\
        mgnensure_buffer_stack (); \
		MGN_CURRENT_BUFFER_LVALUE =    \
            mgn_create_buffer(mgnin,MGN_BUF_SIZE ); \
	} \
	MGN_CURRENT_BUFFER_LVALUE->mgn_at_bol = at_bol; \
	}

#define MGN_AT_BOL() (MGN_CURRENT_BUFFER_LVALUE->mgn_at_bol)

/* Begin user sect3 */

typedef unsigned char MGN_CHAR;

FILE *mgnin = (FILE *) 0, *mgnout = (FILE *) 0;

typedef int mgn_state_type;

extern int mgnlineno;

int mgnlineno = 1;

extern char *mgntext;
#define mgntext_ptr mgntext

static mgn_state_type mgn_get_previous_state (void );
static mgn_state_type mgn_try_NUL_trans (mgn_state_type current_state  );
static int mgn_get_next_buffer (void );
static void mgn_fatal_error (mgnconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up mgntext.
 */
#define MGN_DO_BEFORE_ACTION \
	(mgntext_ptr) = mgn_bp; \
	mgnleng = (size_t) (mgn_cp - mgn_bp); \
	(mgn_hold_char) = *mgn_cp; \
	*mgn_cp = '\0'; \
	(mgn_c_buf_p) = mgn_cp;

#define MGN_NUM_RULES 45
#define MGN_END_OF_BUFFER 46
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct mgn_trans_info
	{
	flex_int32_t mgn_verify;
	flex_int32_t mgn_nxt;
	};
static mgnconst flex_int16_t mgn_accept[125] =
    {   0,
        1,    1,   46,   45,    1,    2,    4,   39,   40,   45,
       41,   45,   43,   44,   42,   36,   43,   43,   43,   43,
       43,   43,   43,   43,   43,   25,   43,   43,   43,   43,
       37,   38,    1,    0,   44,   44,   43,    3,    0,   22,
       43,   43,   43,   43,   43,   43,   23,   24,   43,   43,
       43,   43,   43,   43,   12,   43,   43,   43,   43,   43,
       43,    0,   43,   43,   29,   28,   34,   35,   16,   43,
       43,   26,   43,   43,   27,   43,   43,   43,   43,   43,
       20,   17,   43,   43,   43,    9,   43,   32,   30,   31,
       18,    6,   43,   43,   33,   43,   43,   43,    7,   43,

       14,   43,   43,   10,   43,   19,   43,   43,   15,   21,
       43,   43,   43,   43,   43,   43,   13,   43,   43,    5,
       11,   43,    8,    0
    } ;

static mgnconst flex_int32_t mgn_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    1,    1,    4,    5,    1,    1,    1,    6,
        7,    8,    9,   10,    9,   11,   12,   13,   13,   13,
       13,   13,   13,   13,   13,   13,   13,    1,   14,    1,
       15,    1,    1,    1,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       16,   16,   16,   16,   16,   16,   16,   16,   16,   16,
       17,    1,   18,    1,   16,    1,   19,   20,   21,   22,

       23,   24,   25,   26,   27,   16,   16,   28,   29,   30,
       31,   32,   16,   33,   34,   35,   16,   36,   37,   38,
       39,   16,   40,    1,   41,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static mgnconst flex_int32_t mgn_meta[42] =
    {   0,
        1,    1,    1,    1,    2,    1,    1,    2,    1,    1,
        2,    2,    2,    1,    1,    2,    2,    1,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    1,
        1
    } ;

static mgnconst flex_int16_t mgn_base[126] =
    {   0,
        0,    0,  121,  381,  118,  381,  381,  381,  381,   31,
      381,   84,   35,   34,  381,  381,   38,   40,   41,   42,
       43,   45,   46,   59,   53,   74,   61,   75,   87,   91,
      381,  381,   85,   66,   53,   64,   92,  381,   58,   94,
       95,   97,   99,  105,  107,  109,  111,  115,  119,  126,
      130,  131,  134,  136,  137,  144,  138,  148,  156,  149,
      162,  159,  166,  168,  170,  172,  182,  183,  185,  186,
      197,  200,  202,  205,  207,  208,  218,  222,  221,  223,
      224,  225,  226,  239,  238,  240,  243,  246,  251,  256,
      257,  258,  259,  262,  263,  264,  269,  275,  276,  279,

      280,  281,  283,  286,  298,  300,  301,  303,  304,  306,
      311,  317,  318,  319,  324,  329,  331,  332,  337,  339,
      342,  345,  347,  381,   54
    } ;

static mgnconst flex_int16_t mgn_def[126] =
    {   0,
      124,    1,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  125,  124,  124,  124,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      124,  124,  124,  124,  124,  124,  125,  124,  124,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  124,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,

      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,  125,  125,  125,  125,  125,  125,  125,
      125,  125,  125,    0,  124
    } ;

static mgnconst flex_int16_t mgn_nxt[423] =
    {   0,
        4,    5,    6,    7,    4,    8,    9,    4,   10,   11,
       12,   13,   14,   15,   16,   17,    4,    4,   18,   19,
       20,   17,   17,   17,   17,   21,   17,   22,   23,   24,
       17,   25,   26,   27,   28,   29,   30,   17,   17,   31,
       32,   34,   38,   35,   34,  124,   35,  124,  124,  124,
      124,   39,  124,  124,   39,   37,   39,   39,   39,   39,
      124,   39,   39,   34,   42,   35,  124,   46,  124,   39,
       62,   41,   43,   45,   40,   39,   36,   39,   36,   44,
       51,  124,  124,   47,   48,   52,   33,   53,   54,   49,
       39,   39,   55,   50,  124,   57,   36,   58,  124,  124,

       56,  124,  124,   39,  124,   59,  124,   39,   39,   60,
       39,   39,  124,   39,  124,   39,  124,   61,  124,   33,
      124,   39,  124,   39,   64,   39,  124,   39,   65,   63,
       66,   39,   70,  124,   67,   39,   68,  124,  124,   69,
       71,  124,   39,  124,  124,  124,   39,   39,   73,  124,
       39,  124,   39,   39,   39,  124,  124,  124,   72,  124,
       39,   74,   76,  124,   39,   39,   75,  124,   77,  124,
       78,   62,   39,  124,  124,  124,   37,  124,   39,  124,
       79,   82,   39,   83,   39,   80,   39,   81,   39,  124,
      124,  124,  124,  124,   84,   86,  124,  124,   39,   39,

       85,   39,   39,   87,  124,   89,   88,  124,   90,  124,
      124,  124,  124,   39,  124,  124,   39,  124,   39,   92,
       91,   39,   93,   39,   39,  124,   95,  124,  124,  124,
      124,  124,  124,  124,   39,  124,   94,   39,   39,   39,
       39,   39,   39,   96,   97,  124,  124,  124,  124,   98,
      124,  124,  124,  124,   39,   39,   39,   99,  124,   39,
      100,  101,   39,  124,  124,  124,  124,   39,  102,  124,
      124,  124,   39,   39,   39,   39,  124,  103,   39,   39,
       39,  104,  124,  124,  105,   39,  124,  124,  124,  124,
      124,   39,   39,  124,  124,   39,   39,   39,  106,   39,

      124,  108,   39,  107,  109,  124,  124,  124,  124,  110,
      124,  124,  124,  124,   39,  111,   39,   39,  124,   39,
       39,  113,   39,  124,  124,  124,  124,   39,  124,  115,
      112,  124,  114,   39,   39,   39,  124,  118,  124,  124,
       39,  124,  124,  117,  124,   39,  124,   39,   39,  124,
      119,  116,  124,   39,  124,   39,  124,  124,   39,  121,
      124,   39,  124,   39,  124,  124,  122,  120,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  123,
        3,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124
    } ;

static mgnconst flex_int16_t mgn_chk[423] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,   10,   13,   10,   14,   17,   14,   18,   19,   20,
       21,   13,   22,   23,   17,  125,   18,   19,   20,   21,
       25,   22,   23,   35,   20,   35,   24,   22,   27,   25,
       39,   19,   20,   21,   18,   24,   36,   27,   34,   20,
       25,   26,   28,   23,   23,   25,   33,   25,   25,   24,
       26,   28,   26,   24,   29,   27,   12,   28,   30,   37,

       26,   40,   41,   29,   42,   28,   43,   30,   37,   29,
       40,   41,   44,   42,   45,   43,   46,   30,   47,    5,
        3,   44,   48,   45,   42,   46,   49,   47,   43,   41,
       43,   48,   46,   50,   44,   49,   44,   51,   52,   45,
       49,   53,   50,   54,   55,   57,   51,   52,   51,    0,
       53,   56,   54,   55,   57,   58,   60,    0,   50,    0,
       56,   52,   54,   59,   58,   60,   53,    0,   56,   61,
       57,   62,   59,   63,    0,   64,   62,   65,   61,   66,
       58,   60,   63,   61,   64,   58,   65,   59,   66,   67,
       68,    0,   69,   70,   61,   64,    0,    0,   67,   68,

       63,   69,   70,   65,   71,   66,   65,   72,   66,   73,
        0,    0,   74,   71,   75,   76,   72,    0,   73,   71,
       70,   74,   73,   75,   76,   77,   76,    0,   79,   78,
       80,   81,   82,   83,   77,    0,   74,   79,   78,   80,
       81,   82,   83,   77,   78,   85,   84,   86,    0,   79,
       87,    0,    0,   88,   85,   84,   86,   80,   89,   87,
       83,   84,   88,   90,   91,   92,   93,   89,   85,   94,
       95,   96,   90,   91,   92,   93,   97,   87,   94,   95,
       96,   93,   98,   99,   94,   97,  100,  101,  102,    0,
      103,   98,   99,  104,    0,  100,  101,  102,   96,  103,

        0,   98,  104,   97,  100,  105,    0,  106,  107,  102,
      108,  109,    0,  110,  105,  103,  106,  107,  111,  108,
      109,  107,  110,    0,  112,  113,  114,  111,    0,  111,
      105,  115,  108,  112,  113,  114,  116,  114,  117,  118,
      115,    0,    0,  113,  119,  116,  120,  117,  118,  121,
      115,  112,  122,  119,  123,  120,    0,    0,  121,  118,
        0,  122,    0,  123,    0,    0,  119,  116,    0,    0,
        0,    0,    0,    0,    0,    0,    0,    0,    0,  122,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,

      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124,  124,  124,  124,  124,  124,  124,  124,  124,
      124,  124
    } ;

static mgn_state_type mgn_last_accepting_state;
static char *mgn_last_accepting_cpos;

extern int mgn_flex_debug;
int mgn_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define mgnmore() mgnmore_used_but_not_detected
#define MGN_MORE_ADJ 0
#define MGN_RESTORE_MGN_MORE_OFFSET
char *mgntext;
#line 1 "./mg2mbk_l.l"
#line 2 "./mg2mbk_l.l"
/* 
 * This file is part of the Alliance CAD System
 * Copyright (C) Laboratoire LIP6 - Dpartement ASIM
 * Universite Pierre et Marie Curie
 * 
 * Home page          : http://www-asim.lip6.fr/alliance/
 * E-mail             : mailto:alliance-users@asim.lip6.fr
 * 
 * This library is free software; you  can redistribute it and/or modify it
 * under the terms  of the GNU Library General Public  License as published
 * by the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * Alliance VLSI  CAD System  is distributed  in the hope  that it  will be
 * useful, but WITHOUT  ANY WARRANTY; without even the  implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy  of the GNU General Public License along
 * with the GNU C Library; see the  file COPYING. If not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */
 /*
  * Parsing Philips modgen format, done during the IDPS project.
  * Author: Frdric Ptrot
  */

#include <string.h>
#include <ctype.h>
#include <mut.h>
#include "mg2mbk_y.h"
static void zweep();
extern char *filenameforlex();
/* change lex input routine to a non case sensitive one */
#ifdef FLEX_SCANNER
#ifdef MGN_INPUT
#undef MGN_INPUT
#endif
#define MGN_INPUT(buf,result,max_size) \
	do { \
	int c = getc(mgnin); \
		result = (c == EOF) ? MGN_NULL \
									: (buf[0] = isupper(c) ? tolower(c) : c, 1); \
	} while(0)

int mgnlineno;
#else /* using lex, for sure */
#ifdef input
#undef input
#endif
#define input()	(((mgntchar = mgnsptr > mgnsbuf ? U(*--mgnsptr)    \
							: getc(mgnin)) == 10 ?(mgnlineno++,mgntchar)   \
								: mgntchar) == EOF ? 0                    \
									: isupper(mgntchar) ? tolower(mgntchar) \
										: mgntchar)
#endif
#line 641 "<stdout>"

#define INITIAL 0

#ifndef MGN_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef MGN_EXTRA_TYPE
#define MGN_EXTRA_TYPE void *
#endif

static int mgn_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int mgnlex_destroy (void );

int mgnget_debug (void );

void mgnset_debug (int debug_flag  );

MGN_EXTRA_TYPE mgnget_extra (void );

void mgnset_extra (MGN_EXTRA_TYPE user_defined  );

FILE *mgnget_in (void );

void mgnset_in  (FILE * in_str  );

FILE *mgnget_out (void );

void mgnset_out  (FILE * out_str  );

int mgnget_leng (void );

char *mgnget_text (void );

int mgnget_lineno (void );

void mgnset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef MGN_SKIP_MGNWRAP
#ifdef __cplusplus
extern "C" int mgnwrap (void );
#else
extern int mgnwrap (void );
#endif
#endif

    static void mgnunput (int c,char *buf_ptr  );
    
#ifndef mgntext_ptr
static void mgn_flex_strncpy (char *,mgnconst char *,int );
#endif

#ifdef MGN_NEED_STRLEN
static int mgn_flex_strlen (mgnconst char * );
#endif

#ifndef MGN_NO_INPUT

#ifdef __cplusplus
static int mgninput (void );
#else
static int input (void );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef MGN_READ_BUF_SIZE
#define MGN_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( mgntext, mgnleng, 1, mgnout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or MGN_NULL,
 * is returned in "result".
 */
#ifndef MGN_INPUT
#define MGN_INPUT(buf,result,max_size) \
	if ( MGN_CURRENT_BUFFER_LVALUE->mgn_is_interactive ) \
		{ \
		int c = '*'; \
		unsigned n; \
		for ( n = 0; n < max_size && \
			     (c = getc( mgnin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( mgnin ) ) \
			MGN_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, mgnin))==0 && ferror(mgnin)) \
			{ \
			if( errno != EINTR) \
				{ \
				MGN_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(mgnin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "mgnterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef mgnterminate
#define mgnterminate() return MGN_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef MGN_START_STACK_INCR
#define MGN_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef MGN_FATAL_ERROR
#define MGN_FATAL_ERROR(msg) mgn_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef MGN_DECL
#define MGN_DECL_IS_OURS 1

extern int mgnlex (void);

#define MGN_DECL int mgnlex (void)
#endif /* !MGN_DECL */

/* Code executed at the beginning of each rule, after mgntext and mgnleng
 * have been set up.
 */
#ifndef MGN_USER_ACTION
#define MGN_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef MGN_BREAK
#define MGN_BREAK break;
#endif

#define MGN_RULE_SETUP \
	MGN_USER_ACTION

/** The main scanner function which does all the work.
 */
MGN_DECL
{
	register mgn_state_type mgn_current_state;
	register char *mgn_cp, *mgn_bp;
	register int mgn_act;
    
#line 67 "./mg2mbk_l.l"

#line 825 "<stdout>"

	if ( !(mgn_init) )
		{
		(mgn_init) = 1;

#ifdef MGN_USER_INIT
		MGN_USER_INIT;
#endif

		if ( ! (mgn_start) )
			(mgn_start) = 1;	/* first start state */

		if ( ! mgnin )
			mgnin = stdin;

		if ( ! mgnout )
			mgnout = stdout;

		if ( ! MGN_CURRENT_BUFFER ) {
			mgnensure_buffer_stack ();
			MGN_CURRENT_BUFFER_LVALUE =
				mgn_create_buffer(mgnin,MGN_BUF_SIZE );
		}

		mgn_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		mgn_cp = (mgn_c_buf_p);

		/* Support of mgntext. */
		*mgn_cp = (mgn_hold_char);

		/* mgn_bp points to the position in mgn_ch_buf of the start of
		 * the current run.
		 */
		mgn_bp = mgn_cp;

		mgn_current_state = (mgn_start);
mgn_match:
		do
			{
			register MGN_CHAR mgn_c = mgn_ec[MGN_SC_TO_UI(*mgn_cp)];
			if ( mgn_accept[mgn_current_state] )
				{
				(mgn_last_accepting_state) = mgn_current_state;
				(mgn_last_accepting_cpos) = mgn_cp;
				}
			while ( mgn_chk[mgn_base[mgn_current_state] + mgn_c] != mgn_current_state )
				{
				mgn_current_state = (int) mgn_def[mgn_current_state];
				if ( mgn_current_state >= 125 )
					mgn_c = mgn_meta[(unsigned int) mgn_c];
				}
			mgn_current_state = mgn_nxt[mgn_base[mgn_current_state] + (unsigned int) mgn_c];
			++mgn_cp;
			}
		while ( mgn_base[mgn_current_state] != 381 );

mgn_find_action:
		mgn_act = mgn_accept[mgn_current_state];
		if ( mgn_act == 0 )
			{ /* have to back up */
			mgn_cp = (mgn_last_accepting_cpos);
			mgn_current_state = (mgn_last_accepting_state);
			mgn_act = mgn_accept[mgn_current_state];
			}

		MGN_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( mgn_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of MGN_DO_BEFORE_ACTION */
			*mgn_cp = (mgn_hold_char);
			mgn_cp = (mgn_last_accepting_cpos);
			mgn_current_state = (mgn_last_accepting_state);
			goto mgn_find_action;

case 1:
MGN_RULE_SETUP
#line 68 "./mg2mbk_l.l"
{}
	MGN_BREAK
case 2:
/* rule 2 can match eol */
MGN_RULE_SETUP
#line 69 "./mg2mbk_l.l"
{
#ifdef FLEX_SCANNER
								mgnlineno++;
#endif
							}
	MGN_BREAK
case 3:
MGN_RULE_SETUP
#line 74 "./mg2mbk_l.l"
{zweep('/');}
	MGN_BREAK
case 4:
MGN_RULE_SETUP
#line 75 "./mg2mbk_l.l"
{zweep('\n');}
	MGN_BREAK
case 5:
MGN_RULE_SETUP
#line 76 "./mg2mbk_l.l"
{zweep('}');}
	MGN_BREAK
case 6:
MGN_RULE_SETUP
#line 77 "./mg2mbk_l.l"
{zweep('}');}
	MGN_BREAK
case 7:
MGN_RULE_SETUP
#line 78 "./mg2mbk_l.l"
{zweep(';');}
	MGN_BREAK
case 8:
MGN_RULE_SETUP
#line 79 "./mg2mbk_l.l"
{zweep(';');}
	MGN_BREAK
case 9:
MGN_RULE_SETUP
#line 80 "./mg2mbk_l.l"
{return CELL;}
	MGN_BREAK
case 10:
MGN_RULE_SETUP
#line 81 "./mg2mbk_l.l"
{return PLACE;}
	MGN_BREAK
case 11:
MGN_RULE_SETUP
#line 82 "./mg2mbk_l.l"
{return TERMINAL;}
	MGN_BREAK
case 12:
MGN_RULE_SETUP
#line 83 "./mg2mbk_l.l"
{return RA;}
	MGN_BREAK
case 13:
MGN_RULE_SETUP
#line 84 "./mg2mbk_l.l"
{return STRETCH;}
	MGN_BREAK
case 14:
MGN_RULE_SETUP
#line 85 "./mg2mbk_l.l"
{return WIRE;}
	MGN_BREAK
case 15:
MGN_RULE_SETUP
#line 86 "./mg2mbk_l.l"
{return MWIDTH;}
	MGN_BREAK
case 16:
MGN_RULE_SETUP
#line 87 "./mg2mbk_l.l"
{return HORIZ;}
	MGN_BREAK
case 17:
MGN_RULE_SETUP
#line 88 "./mg2mbk_l.l"
{return VERTI;}
	MGN_BREAK
case 18:
MGN_RULE_SETUP
#line 89 "./mg2mbk_l.l"
{return MLEFT;}
	MGN_BREAK
case 19:
MGN_RULE_SETUP
#line 90 "./mg2mbk_l.l"
{return MRIGHT;}
	MGN_BREAK
case 20:
MGN_RULE_SETUP
#line 91 "./mg2mbk_l.l"
{return MTOP;}
	MGN_BREAK
case 21:
MGN_RULE_SETUP
#line 92 "./mg2mbk_l.l"
{return MBOTTOM;}
	MGN_BREAK
case 22:
MGN_RULE_SETUP
#line 93 "./mg2mbk_l.l"
{return AT;}
	MGN_BREAK
case 23:
MGN_RULE_SETUP
#line 94 "./mg2mbk_l.l"
{return MX;}
	MGN_BREAK
case 24:
MGN_RULE_SETUP
#line 95 "./mg2mbk_l.l"
{return MY;}
	MGN_BREAK
case 25:
MGN_RULE_SETUP
#line 96 "./mg2mbk_l.l"
{return R;}
	MGN_BREAK
case 26:
MGN_RULE_SETUP
#line 97 "./mg2mbk_l.l"
{return NTR;}
	MGN_BREAK
case 27:
MGN_RULE_SETUP
#line 98 "./mg2mbk_l.l"
{return PTR;}
	MGN_BREAK
case 28:
MGN_RULE_SETUP
#line 99 "./mg2mbk_l.l"
{return COP;}
	MGN_BREAK
case 29:
MGN_RULE_SETUP
#line 100 "./mg2mbk_l.l"
{return CON;}
	MGN_BREAK
case 30:
MGN_RULE_SETUP
#line 101 "./mg2mbk_l.l"
{return COPS;}
	MGN_BREAK
case 31:
MGN_RULE_SETUP
#line 102 "./mg2mbk_l.l"
{return COPW;}
	MGN_BREAK
case 32:
MGN_RULE_SETUP
#line 103 "./mg2mbk_l.l"
{return CONW;}
	MGN_BREAK
case 33:
MGN_RULE_SETUP
#line 104 "./mg2mbk_l.l"
{return PVIA;}
	MGN_BREAK
case 34:
MGN_RULE_SETUP
#line 105 "./mg2mbk_l.l"
{return CXN;}
	MGN_BREAK
case 35:
MGN_RULE_SETUP
#line 106 "./mg2mbk_l.l"
{return CXP;}
	MGN_BREAK
case 36:
MGN_RULE_SETUP
#line 107 "./mg2mbk_l.l"
{return '=';}
	MGN_BREAK
case 37:
MGN_RULE_SETUP
#line 108 "./mg2mbk_l.l"
{return '{';}
	MGN_BREAK
case 38:
MGN_RULE_SETUP
#line 109 "./mg2mbk_l.l"
{return '}';}
	MGN_BREAK
case 39:
MGN_RULE_SETUP
#line 110 "./mg2mbk_l.l"
{return '(';}
	MGN_BREAK
case 40:
MGN_RULE_SETUP
#line 111 "./mg2mbk_l.l"
{return ')';}
	MGN_BREAK
case 41:
MGN_RULE_SETUP
#line 112 "./mg2mbk_l.l"
{return ',';}
	MGN_BREAK
case 42:
MGN_RULE_SETUP
#line 113 "./mg2mbk_l.l"
{return ';';}
	MGN_BREAK
case 43:
MGN_RULE_SETUP
#line 114 "./mg2mbk_l.l"
{	mgnlval.s = mbkstrdup(mgntext);
								return STRING;}
	MGN_BREAK
case 44:
MGN_RULE_SETUP
#line 116 "./mg2mbk_l.l"
{float f;
								sscanf(mgntext, "%f", &f);
								mgnlval.n = (long)(f * SCALE_X);
#ifdef GRIDDED
								mgnlval.n *= 2;
#endif
								return NUM;}
	MGN_BREAK
case 45:
MGN_RULE_SETUP
#line 123 "./mg2mbk_l.l"
ECHO;
	MGN_BREAK
#line 1145 "<stdout>"
case MGN_STATE_EOF(INITIAL):
	mgnterminate();

	case MGN_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int mgn_amount_of_matched_text = (int) (mgn_cp - (mgntext_ptr)) - 1;

		/* Undo the effects of MGN_DO_BEFORE_ACTION. */
		*mgn_cp = (mgn_hold_char);
		MGN_RESTORE_MGN_MORE_OFFSET

		if ( MGN_CURRENT_BUFFER_LVALUE->mgn_buffer_status == MGN_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed mgnin at a new source and called
			 * mgnlex().  If so, then we have to assure
			 * consistency between MGN_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(mgn_n_chars) = MGN_CURRENT_BUFFER_LVALUE->mgn_n_chars;
			MGN_CURRENT_BUFFER_LVALUE->mgn_input_file = mgnin;
			MGN_CURRENT_BUFFER_LVALUE->mgn_buffer_status = MGN_BUFFER_NORMAL;
			}

		/* Note that here we test for mgn_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since mgn_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (mgn_c_buf_p) <= &MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[(mgn_n_chars)] )
			{ /* This was really a NUL. */
			mgn_state_type mgn_next_state;

			(mgn_c_buf_p) = (mgntext_ptr) + mgn_amount_of_matched_text;

			mgn_current_state = mgn_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * mgn_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			mgn_next_state = mgn_try_NUL_trans( mgn_current_state );

			mgn_bp = (mgntext_ptr) + MGN_MORE_ADJ;

			if ( mgn_next_state )
				{
				/* Consume the NUL. */
				mgn_cp = ++(mgn_c_buf_p);
				mgn_current_state = mgn_next_state;
				goto mgn_match;
				}

			else
				{
				mgn_cp = (mgn_c_buf_p);
				goto mgn_find_action;
				}
			}

		else switch ( mgn_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(mgn_did_buffer_switch_on_eof) = 0;

				if ( mgnwrap( ) )
					{
					/* Note: because we've taken care in
					 * mgn_get_next_buffer() to have set up
					 * mgntext, we can now set up
					 * mgn_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * MGN_NULL, it'll still work - another
					 * MGN_NULL will get returned.
					 */
					(mgn_c_buf_p) = (mgntext_ptr) + MGN_MORE_ADJ;

					mgn_act = MGN_STATE_EOF(MGN_START);
					goto do_action;
					}

				else
					{
					if ( ! (mgn_did_buffer_switch_on_eof) )
						MGN_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(mgn_c_buf_p) =
					(mgntext_ptr) + mgn_amount_of_matched_text;

				mgn_current_state = mgn_get_previous_state(  );

				mgn_cp = (mgn_c_buf_p);
				mgn_bp = (mgntext_ptr) + MGN_MORE_ADJ;
				goto mgn_match;

			case EOB_ACT_LAST_MATCH:
				(mgn_c_buf_p) =
				&MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[(mgn_n_chars)];

				mgn_current_state = mgn_get_previous_state(  );

				mgn_cp = (mgn_c_buf_p);
				mgn_bp = (mgntext_ptr) + MGN_MORE_ADJ;
				goto mgn_find_action;
			}
		break;
		}

	default:
		MGN_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of mgnlex */

/* mgn_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int mgn_get_next_buffer (void)
{
    	register char *dest = MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf;
	register char *source = (mgntext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (mgn_c_buf_p) > &MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[(mgn_n_chars) + 1] )
		MGN_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( MGN_CURRENT_BUFFER_LVALUE->mgn_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (mgn_c_buf_p) - (mgntext_ptr) - MGN_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((mgn_c_buf_p) - (mgntext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( MGN_CURRENT_BUFFER_LVALUE->mgn_buffer_status == MGN_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		MGN_CURRENT_BUFFER_LVALUE->mgn_n_chars = (mgn_n_chars) = 0;

	else
		{
			int num_to_read =
			MGN_CURRENT_BUFFER_LVALUE->mgn_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			MGN_BUFFER_STATE b = MGN_CURRENT_BUFFER;

			int mgn_c_buf_p_offset =
				(int) ((mgn_c_buf_p) - b->mgn_ch_buf);

			if ( b->mgn_is_our_buffer )
				{
				int new_size = b->mgn_buf_size * 2;

				if ( new_size <= 0 )
					b->mgn_buf_size += b->mgn_buf_size / 8;
				else
					b->mgn_buf_size *= 2;

				b->mgn_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					mgnrealloc((void *) b->mgn_ch_buf,b->mgn_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->mgn_ch_buf = 0;

			if ( ! b->mgn_ch_buf )
				MGN_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(mgn_c_buf_p) = &b->mgn_ch_buf[mgn_c_buf_p_offset];

			num_to_read = MGN_CURRENT_BUFFER_LVALUE->mgn_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > MGN_READ_BUF_SIZE )
			num_to_read = MGN_READ_BUF_SIZE;

		/* Read in more data. */
		MGN_INPUT( (&MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[number_to_move]),
			(mgn_n_chars), (size_t) num_to_read );

		MGN_CURRENT_BUFFER_LVALUE->mgn_n_chars = (mgn_n_chars);
		}

	if ( (mgn_n_chars) == 0 )
		{
		if ( number_to_move == MGN_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			mgnrestart(mgnin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			MGN_CURRENT_BUFFER_LVALUE->mgn_buffer_status =
				MGN_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((mgn_size_t) ((mgn_n_chars) + number_to_move) > MGN_CURRENT_BUFFER_LVALUE->mgn_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		mgn_size_t new_size = (mgn_n_chars) + number_to_move + ((mgn_n_chars) >> 1);
		MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf = (char *) mgnrealloc((void *) MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf,new_size  );
		if ( ! MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf )
			MGN_FATAL_ERROR( "out of dynamic memory in mgn_get_next_buffer()" );
	}

	(mgn_n_chars) += number_to_move;
	MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[(mgn_n_chars)] = MGN_END_OF_BUFFER_CHAR;
	MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[(mgn_n_chars) + 1] = MGN_END_OF_BUFFER_CHAR;

	(mgntext_ptr) = &MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[0];

	return ret_val;
}

/* mgn_get_previous_state - get the state just before the EOB char was reached */

    static mgn_state_type mgn_get_previous_state (void)
{
	register mgn_state_type mgn_current_state;
	register char *mgn_cp;
    
	mgn_current_state = (mgn_start);

	for ( mgn_cp = (mgntext_ptr) + MGN_MORE_ADJ; mgn_cp < (mgn_c_buf_p); ++mgn_cp )
		{
		register MGN_CHAR mgn_c = (*mgn_cp ? mgn_ec[MGN_SC_TO_UI(*mgn_cp)] : 1);
		if ( mgn_accept[mgn_current_state] )
			{
			(mgn_last_accepting_state) = mgn_current_state;
			(mgn_last_accepting_cpos) = mgn_cp;
			}
		while ( mgn_chk[mgn_base[mgn_current_state] + mgn_c] != mgn_current_state )
			{
			mgn_current_state = (int) mgn_def[mgn_current_state];
			if ( mgn_current_state >= 125 )
				mgn_c = mgn_meta[(unsigned int) mgn_c];
			}
		mgn_current_state = mgn_nxt[mgn_base[mgn_current_state] + (unsigned int) mgn_c];
		}

	return mgn_current_state;
}

/* mgn_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = mgn_try_NUL_trans( current_state );
 */
    static mgn_state_type mgn_try_NUL_trans  (mgn_state_type mgn_current_state )
{
	register int mgn_is_jam;
    	register char *mgn_cp = (mgn_c_buf_p);

	register MGN_CHAR mgn_c = 1;
	if ( mgn_accept[mgn_current_state] )
		{
		(mgn_last_accepting_state) = mgn_current_state;
		(mgn_last_accepting_cpos) = mgn_cp;
		}
	while ( mgn_chk[mgn_base[mgn_current_state] + mgn_c] != mgn_current_state )
		{
		mgn_current_state = (int) mgn_def[mgn_current_state];
		if ( mgn_current_state >= 125 )
			mgn_c = mgn_meta[(unsigned int) mgn_c];
		}
	mgn_current_state = mgn_nxt[mgn_base[mgn_current_state] + (unsigned int) mgn_c];
	mgn_is_jam = (mgn_current_state == 124);

	return mgn_is_jam ? 0 : mgn_current_state;
}

    static void mgnunput (int c, register char * mgn_bp )
{
	register char *mgn_cp;
    
    mgn_cp = (mgn_c_buf_p);

	/* undo effects of setting up mgntext */
	*mgn_cp = (mgn_hold_char);

	if ( mgn_cp < MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf + 2 )
		{ /* need to shift things up to make room */
		/* +2 for EOB chars. */
		register int number_to_move = (mgn_n_chars) + 2;
		register char *dest = &MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[
					MGN_CURRENT_BUFFER_LVALUE->mgn_buf_size + 2];
		register char *source =
				&MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[number_to_move];

		while ( source > MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf )
			*--dest = *--source;

		mgn_cp += (int) (dest - source);
		mgn_bp += (int) (dest - source);
		MGN_CURRENT_BUFFER_LVALUE->mgn_n_chars =
			(mgn_n_chars) = MGN_CURRENT_BUFFER_LVALUE->mgn_buf_size;

		if ( mgn_cp < MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf + 2 )
			MGN_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--mgn_cp = (char) c;

	(mgntext_ptr) = mgn_bp;
	(mgn_hold_char) = *mgn_cp;
	(mgn_c_buf_p) = mgn_cp;
}

#ifndef MGN_NO_INPUT
#ifdef __cplusplus
    static int mgninput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(mgn_c_buf_p) = (mgn_hold_char);

	if ( *(mgn_c_buf_p) == MGN_END_OF_BUFFER_CHAR )
		{
		/* mgn_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( (mgn_c_buf_p) < &MGN_CURRENT_BUFFER_LVALUE->mgn_ch_buf[(mgn_n_chars)] )
			/* This was really a NUL. */
			*(mgn_c_buf_p) = '\0';

		else
			{ /* need more input */
			int offset = (mgn_c_buf_p) - (mgntext_ptr);
			++(mgn_c_buf_p);

			switch ( mgn_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because mgn_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					mgnrestart(mgnin );

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( mgnwrap( ) )
						return EOF;

					if ( ! (mgn_did_buffer_switch_on_eof) )
						MGN_NEW_FILE;
#ifdef __cplusplus
					return mgninput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(mgn_c_buf_p) = (mgntext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (mgn_c_buf_p);	/* cast for 8-bit char's */
	*(mgn_c_buf_p) = '\0';	/* preserve mgntext */
	(mgn_hold_char) = *++(mgn_c_buf_p);

	return c;
}
#endif	/* ifndef MGN_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void mgnrestart  (FILE * input_file )
{
    
	if ( ! MGN_CURRENT_BUFFER ){
        mgnensure_buffer_stack ();
		MGN_CURRENT_BUFFER_LVALUE =
            mgn_create_buffer(mgnin,MGN_BUF_SIZE );
	}

	mgn_init_buffer(MGN_CURRENT_BUFFER,input_file );
	mgn_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void mgn_switch_to_buffer  (MGN_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		mgnpop_buffer_state();
	 *		mgnpush_buffer_state(new_buffer);
     */
	mgnensure_buffer_stack ();
	if ( MGN_CURRENT_BUFFER == new_buffer )
		return;

	if ( MGN_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mgn_c_buf_p) = (mgn_hold_char);
		MGN_CURRENT_BUFFER_LVALUE->mgn_buf_pos = (mgn_c_buf_p);
		MGN_CURRENT_BUFFER_LVALUE->mgn_n_chars = (mgn_n_chars);
		}

	MGN_CURRENT_BUFFER_LVALUE = new_buffer;
	mgn_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (mgnwrap()) processing, but the only time this flag
	 * is looked at is after mgnwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(mgn_did_buffer_switch_on_eof) = 1;
}

static void mgn_load_buffer_state  (void)
{
    	(mgn_n_chars) = MGN_CURRENT_BUFFER_LVALUE->mgn_n_chars;
	(mgntext_ptr) = (mgn_c_buf_p) = MGN_CURRENT_BUFFER_LVALUE->mgn_buf_pos;
	mgnin = MGN_CURRENT_BUFFER_LVALUE->mgn_input_file;
	(mgn_hold_char) = *(mgn_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c MGN_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    MGN_BUFFER_STATE mgn_create_buffer  (FILE * file, int  size )
{
	MGN_BUFFER_STATE b;
    
	b = (MGN_BUFFER_STATE) mgnalloc(sizeof( struct mgn_buffer_state )  );
	if ( ! b )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_create_buffer()" );

	b->mgn_buf_size = size;

	/* mgn_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->mgn_ch_buf = (char *) mgnalloc(b->mgn_buf_size + 2  );
	if ( ! b->mgn_ch_buf )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_create_buffer()" );

	b->mgn_is_our_buffer = 1;

	mgn_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with mgn_create_buffer()
 * 
 */
    void mgn_delete_buffer (MGN_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == MGN_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		MGN_CURRENT_BUFFER_LVALUE = (MGN_BUFFER_STATE) 0;

	if ( b->mgn_is_our_buffer )
		mgnfree((void *) b->mgn_ch_buf  );

	mgnfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a mgnrestart() or at EOF.
 */
    static void mgn_init_buffer  (MGN_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	mgn_flush_buffer(b );

	b->mgn_input_file = file;
	b->mgn_fill_buffer = 1;

    /* If b is the current buffer, then mgn_init_buffer was _probably_
     * called from mgnrestart() or through mgn_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != MGN_CURRENT_BUFFER){
        b->mgn_bs_lineno = 1;
        b->mgn_bs_column = 0;
    }

        b->mgn_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, MGN_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c MGN_CURRENT_BUFFER.
 * 
 */
    void mgn_flush_buffer (MGN_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->mgn_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->mgn_ch_buf[0] = MGN_END_OF_BUFFER_CHAR;
	b->mgn_ch_buf[1] = MGN_END_OF_BUFFER_CHAR;

	b->mgn_buf_pos = &b->mgn_ch_buf[0];

	b->mgn_at_bol = 1;
	b->mgn_buffer_status = MGN_BUFFER_NEW;

	if ( b == MGN_CURRENT_BUFFER )
		mgn_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void mgnpush_buffer_state (MGN_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	mgnensure_buffer_stack();

	/* This block is copied from mgn_switch_to_buffer. */
	if ( MGN_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(mgn_c_buf_p) = (mgn_hold_char);
		MGN_CURRENT_BUFFER_LVALUE->mgn_buf_pos = (mgn_c_buf_p);
		MGN_CURRENT_BUFFER_LVALUE->mgn_n_chars = (mgn_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (MGN_CURRENT_BUFFER)
		(mgn_buffer_stack_top)++;
	MGN_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from mgn_switch_to_buffer. */
	mgn_load_buffer_state( );
	(mgn_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void mgnpop_buffer_state (void)
{
    	if (!MGN_CURRENT_BUFFER)
		return;

	mgn_delete_buffer(MGN_CURRENT_BUFFER );
	MGN_CURRENT_BUFFER_LVALUE = NULL;
	if ((mgn_buffer_stack_top) > 0)
		--(mgn_buffer_stack_top);

	if (MGN_CURRENT_BUFFER) {
		mgn_load_buffer_state( );
		(mgn_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void mgnensure_buffer_stack (void)
{
	int num_to_alloc;
    
	if (!(mgn_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(mgn_buffer_stack) = (struct mgn_buffer_state**)mgnalloc
								(num_to_alloc * sizeof(struct mgn_buffer_state*)
								);
		if ( ! (mgn_buffer_stack) )
			MGN_FATAL_ERROR( "out of dynamic memory in mgnensure_buffer_stack()" );
								  
		memset((mgn_buffer_stack), 0, num_to_alloc * sizeof(struct mgn_buffer_state*));
				
		(mgn_buffer_stack_max) = num_to_alloc;
		(mgn_buffer_stack_top) = 0;
		return;
	}

	if ((mgn_buffer_stack_top) >= ((mgn_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (mgn_buffer_stack_max) + grow_size;
		(mgn_buffer_stack) = (struct mgn_buffer_state**)mgnrealloc
								((mgn_buffer_stack),
								num_to_alloc * sizeof(struct mgn_buffer_state*)
								);
		if ( ! (mgn_buffer_stack) )
			MGN_FATAL_ERROR( "out of dynamic memory in mgnensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((mgn_buffer_stack) + (mgn_buffer_stack_max), 0, grow_size * sizeof(struct mgn_buffer_state*));
		(mgn_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
MGN_BUFFER_STATE mgn_scan_buffer  (char * base, mgn_size_t  size )
{
	MGN_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != MGN_END_OF_BUFFER_CHAR ||
	     base[size-1] != MGN_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (MGN_BUFFER_STATE) mgnalloc(sizeof( struct mgn_buffer_state )  );
	if ( ! b )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_scan_buffer()" );

	b->mgn_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->mgn_buf_pos = b->mgn_ch_buf = base;
	b->mgn_is_our_buffer = 0;
	b->mgn_input_file = 0;
	b->mgn_n_chars = b->mgn_buf_size;
	b->mgn_is_interactive = 0;
	b->mgn_at_bol = 1;
	b->mgn_fill_buffer = 0;
	b->mgn_buffer_status = MGN_BUFFER_NEW;

	mgn_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to mgnlex() will
 * scan from a @e copy of @a str.
 * @param mgnstr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       mgn_scan_bytes() instead.
 */
MGN_BUFFER_STATE mgn_scan_string (mgnconst char * mgnstr )
{
    
	return mgn_scan_bytes(mgnstr,strlen(mgnstr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to mgnlex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
MGN_BUFFER_STATE mgn_scan_bytes  (mgnconst char * mgnbytes, int  _mgnbytes_len )
{
	MGN_BUFFER_STATE b;
	char *buf;
	mgn_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _mgnbytes_len + 2;
	buf = (char *) mgnalloc(n  );
	if ( ! buf )
		MGN_FATAL_ERROR( "out of dynamic memory in mgn_scan_bytes()" );

	for ( i = 0; i < _mgnbytes_len; ++i )
		buf[i] = mgnbytes[i];

	buf[_mgnbytes_len] = buf[_mgnbytes_len+1] = MGN_END_OF_BUFFER_CHAR;

	b = mgn_scan_buffer(buf,n );
	if ( ! b )
		MGN_FATAL_ERROR( "bad buffer in mgn_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->mgn_is_our_buffer = 1;

	return b;
}

#ifndef MGN_EXIT_FAILURE
#define MGN_EXIT_FAILURE 2
#endif

static void mgn_fatal_error (mgnconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( MGN_EXIT_FAILURE );
}

/* Redefine mgnless() so it works in section 3 code. */

#undef mgnless
#define mgnless(n) \
	do \
		{ \
		/* Undo effects of setting up mgntext. */ \
        int mgnless_macro_arg = (n); \
        MGN_LESS_LINENO(mgnless_macro_arg);\
		mgntext[mgnleng] = (mgn_hold_char); \
		(mgn_c_buf_p) = mgntext + mgnless_macro_arg; \
		(mgn_hold_char) = *(mgn_c_buf_p); \
		*(mgn_c_buf_p) = '\0'; \
		mgnleng = mgnless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int mgnget_lineno  (void)
{
        
    return mgnlineno;
}

/** Get the input stream.
 * 
 */
FILE *mgnget_in  (void)
{
        return mgnin;
}

/** Get the output stream.
 * 
 */
FILE *mgnget_out  (void)
{
        return mgnout;
}

/** Get the length of the current token.
 * 
 */
int mgnget_leng  (void)
{
        return mgnleng;
}

/** Get the current token.
 * 
 */

char *mgnget_text  (void)
{
        return mgntext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void mgnset_lineno (int  line_number )
{
    
    mgnlineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see mgn_switch_to_buffer
 */
void mgnset_in (FILE *  in_str )
{
        mgnin = in_str ;
}

void mgnset_out (FILE *  out_str )
{
        mgnout = out_str ;
}

int mgnget_debug  (void)
{
        return mgn_flex_debug;
}

void mgnset_debug (int  bdebug )
{
        mgn_flex_debug = bdebug ;
}

static int mgn_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from mgnlex_destroy(), so don't allocate here.
     */

    (mgn_buffer_stack) = 0;
    (mgn_buffer_stack_top) = 0;
    (mgn_buffer_stack_max) = 0;
    (mgn_c_buf_p) = (char *) 0;
    (mgn_init) = 0;
    (mgn_start) = 0;

/* Defined in main.c */
#ifdef MGN_STDINIT
    mgnin = stdin;
    mgnout = stdout;
#else
    mgnin = (FILE *) 0;
    mgnout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * mgnlex_init()
     */
    return 0;
}

/* mgnlex_destroy is for both reentrant and non-reentrant scanners. */
int mgnlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(MGN_CURRENT_BUFFER){
		mgn_delete_buffer(MGN_CURRENT_BUFFER  );
		MGN_CURRENT_BUFFER_LVALUE = NULL;
		mgnpop_buffer_state();
	}

	/* Destroy the stack itself. */
	mgnfree((mgn_buffer_stack) );
	(mgn_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * mgnlex() is called, initialization will occur. */
    mgn_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef mgntext_ptr
static void mgn_flex_strncpy (char* s1, mgnconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef MGN_NEED_STRLEN
static int mgn_flex_strlen (mgnconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *mgnalloc (mgn_size_t  size )
{
	return (void *) malloc( size );
}

void *mgnrealloc  (void * ptr, mgn_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void mgnfree (void * ptr )
{
	free( (char *) ptr );	/* see mgnrealloc() for (char *) cast */
}

#define MGNTABLES_NAME "mgntables"

#line 123 "./mg2mbk_l.l"



int mgnwrap()
{
	return 1;
}

static void zweep(find_it)
char find_it;
{
char c;

	while (1) {
		if ((c = input()) == 0) {
			(void)fprintf(stderr, "reached EOF before expected end line %d\n",
								mgnlineno);
			exit(12);
		}
		/* special case for comments */
		if (c == '*')
			if (find_it == '/')
				if ((c = input()) == 0) {
					(void)fprintf(stderr,
										"reached EOF before expected end of comment\n");
					exit(12);
				}
		if (c == find_it)
			return;
	}
}

int mgnerror(s)
char *s;
{
	fflush(stdout);
	fprintf(stderr, "modgen parser : syntax error line %d on %s file %s\n",
				mgnlineno, mgntext, filenameforlex());
	exit(13);
}

