/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:05:35 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Entry;
import uk.ac.sanger.artemis.EntryVector;
import uk.ac.sanger.artemis.FeatureKeyQualifierPredicate;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.sequence.Bases;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class EntryVector_ESTest extends EntryVector_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      Key key0 = new Key("dze3_6i*H");
      FeatureKeyQualifierPredicate featureKeyQualifierPredicate0 = new FeatureKeyQualifierPredicate(key0, "", true);
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureKeyQualifierPredicate0, "dze3_6i*H");
      filteredEntryGroup0.createEntry();
      int int0 = simpleEntryGroup0.size();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      boolean boolean0 = entryVector0.removeElement((Entry) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      entryVector0.add((Entry) null);
      int int0 = entryVector0.indexOf((Entry) null);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("<h158ziaG:&sJV(?");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = Entry.newEntry(bases0);
      simpleEntryGroup0.add(entry0);
      Entry entry1 = simpleEntryGroup0.elementAt(0);
      assertSame(entry1, entry0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("<h158ziaG:&sJV(?");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      // Undeclared exception!
      try { 
        simpleEntryGroup0.addElement((Entry) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleEntryGroup", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      entryVector0.add((Entry) null);
      boolean boolean0 = entryVector0.contains((Entry) null);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      entryVector0.add((Entry) null);
      entryVector0.add((Entry) null);
      assertEquals(1, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      // Undeclared exception!
      try { 
        entryVector0.elementAt((-2));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      int int0 = entryVector0.size();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      int int0 = entryVector0.indexOf((Entry) null);
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("<h158ziaG:&sJV(?");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      EntryVector entryVector0 = (EntryVector)simpleEntryGroup0.clone();
      assertEquals(0, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      boolean boolean0 = simpleEntryGroup0.contains((Entry) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      entryVector0.add((Entry) null);
      entryVector0.addElement((Entry) null);
      assertEquals(1, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EntryVector entryVector0 = new EntryVector();
      entryVector0.removeAllElements();
      assertEquals(0, entryVector0.size());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("<h158ziaG:&sJV(?");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(genbankStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      EntryVector entryVector0 = simpleEntryGroup0.getActiveEntries();
      entryVector0.add((Entry) null);
      Entry entry0 = entryVector0.elementAt(0);
      assertNull(entry0);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("m2g_b*<");
      Bases bases0 = new Bases(emblStreamSequence0);
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup(bases0);
      Entry entry0 = simpleEntryGroup0.createEntry("m2g_b*<");
      simpleEntryGroup0.removeElement(entry0);
      // Undeclared exception!
      try { 
        simpleEntryGroup0.removeElement(entry0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }
}
