/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 14:31:28 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.HeadlessException;
import java.io.FileNotFoundException;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.Entry;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.PartialSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.io.StreamSequence;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.TextDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class BlastDocumentEntry_ESTest extends BlastDocumentEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("p!ct'Y|YKK$Hq");
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence(rawStreamSequence0);
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence(genbankStreamSequence0);
      StreamSequence streamSequence0 = blastDocumentEntry0.makeNativeSequence(emblStreamSequence0);
      assertEquals(1, streamSequence0.getTCount());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(mSPcrunchEntryInformation0);
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("");
      StreamSequence streamSequence0 = blastDocumentEntry0.makeNativeSequence(genbankStreamSequence0);
      assertEquals(0, streamSequence0.getCCount());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry((EntryInformation) null);
      // Undeclared exception!
      try { 
        blastDocumentEntry0.makeNativeSequence((Sequence) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.RawStreamSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      LogReadListener logReadListener0 = new LogReadListener("x~i$4Oa");
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry((Document) null, logReadListener0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      TextDocument textDocument0 = new TextDocument();
      LogReadListener logReadListener0 = new LogReadListener("");
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry(textDocument0, logReadListener0);
        fail("Expecting exception: HeadlessException");
      
      } catch(HeadlessException e) {
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry((Entry) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      // Undeclared exception!
      try { 
        blastDocumentEntry0.makeNativeFeature((Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      // Undeclared exception!
      try { 
        blastDocumentEntry0.makeNativeFeature((Feature) null, true);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.BlastStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(mSPcrunchEntryInformation0);
      char[] charArray0 = new char[1];
      Short short0 = new Short((short)0);
      PartialSequence partialSequence0 = new PartialSequence(charArray0, (-538), 40000, short0, (Integer) null);
      // Undeclared exception!
      try { 
        blastDocumentEntry0.makeNativeSequence(partialSequence0);
        fail("Expecting exception: NegativeArraySizeException");
      
      } catch(NegativeArraySizeException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.PartialSequence", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      MockFile mockFile0 = new MockFile("zcGM6CH");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      LogReadListener logReadListener0 = new LogReadListener("public");
      BlastDocumentEntry blastDocumentEntry0 = null;
      try {
        blastDocumentEntry0 = new BlastDocumentEntry(fileDocument0, logReadListener0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(Throwable e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileInputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(simpleEntryInformation0);
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(genbankDocumentEntry0, true);
      boolean boolean0 = blastDocumentEntry0.isReadOnly();
      assertTrue(boolean0);
  }
}
