/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 15:24:34 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.Range;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class Range_ESTest extends Range_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Range range0 = new Range(0);
      boolean boolean0 = range0.fuzzyOverlaps(range0, 0);
      assertEquals(0, range0.getEnd());
      assertEquals(0, range0.getStart());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Range range0 = new Range((-1), (-1));
      Range range1 = range0.change((-1), 0);
      boolean boolean0 = range1.equals(range0);
      assertEquals(2, range1.getCount());
      assertEquals(0, range1.getEnd());
      assertFalse(boolean0);
      assertEquals((-1), range1.getStart());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Range range0 = new Range(1939, 1939);
      Range range1 = new Range(1);
      boolean boolean0 = range0.equals(range1);
      assertEquals(1, range1.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1, range1.getEnd());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = new Range((-1));
      Range range2 = range1.truncate(range0);
      assertEquals((-1), range1.getEnd());
      assertEquals(0, range0.getEnd());
      assertEquals(1, range2.getCount());
      assertNotNull(range2);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Range range0 = new Range(0);
      int int0 = range0.getStart();
      assertEquals(1, range0.getCount());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Range range0 = new Range(0, 2940);
      Range range1 = range0.change(1224, 2940);
      int int0 = range1.getStart();
      assertEquals(1224, int0);
      assertEquals(1717, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      int int0 = range0.getEnd();
      assertEquals(2, range0.getCount());
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Range range0 = new Range(1);
      int int0 = range0.getEnd();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Range range0 = new Range((-4110));
      Range range1 = range0.truncate(range0);
      Range range2 = range1.copy();
      assertEquals((-4110), range0.getStart());
      assertEquals((-4110), range0.getEnd());
      assertEquals(1, range2.getCount());
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Range range0 = new Range((-1), (-1));
      Range range1 = range0.change((-1), 0);
      Range range2 = range1.copy();
      assertEquals(2, range2.getCount());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Range range0 = new Range((-2159));
      Range range1 = range0.copy();
      assertEquals((-2159), range1.getStart());
      assertEquals(1, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      Range range0 = new Range((-2159));
      Range range1 = range0.change((-2159), (-2159));
      assertEquals((-2159), range0.getEnd());
      assertEquals(1, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Range range0 = new Range((-963));
      // Undeclared exception!
      try { 
        range0.truncate((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Range range0 = new Range((-2159));
      // Undeclared exception!
      try { 
        range0.overlaps((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Range range0 = new Range((-1713));
      // Undeclared exception!
      try { 
        range0.fuzzyOverlaps((Range) null, (-2836));
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Range range0 = new Range(0, 0);
      // Undeclared exception!
      try { 
        range0.contains((Range) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Range range0 = new Range((-1), (-1));
      Range range1 = range0.truncate(range0);
      boolean boolean0 = range1.overlaps(range0);
      assertFalse(boolean0);
      assertEquals(1, range1.getCount());
      assertEquals((-1), range0.getEnd());
      assertEquals((-1), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Range range0 = new Range((-1207), (-1207));
      Range range1 = new Range((-1207), 1);
      Range range2 = range1.truncate(range0);
      boolean boolean0 = range1.overlaps(range2);
      assertEquals((-1207), range1.getStart());
      assertEquals(1, range2.getCount());
      assertEquals(1, range2.getEnd());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Range range0 = new Range((-1), (-1));
      boolean boolean0 = range0.overlaps(range0);
      assertEquals((-1), range0.getStart());
      assertTrue(boolean0);
      assertEquals((-1), range0.getEnd());
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Range range0 = null;
      try {
        range0 = new Range(1518, 0);
        fail("Expecting exception: Exception");
      
      } catch(Throwable e) {
         //
         // start: 1518 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Range range0 = new Range((-1), (-1));
      int int0 = range0.getStart();
      assertEquals(1, range0.getCount());
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      Range range0 = new Range((-1), (-1));
      int int0 = range0.getEnd();
      assertEquals((-1), int0);
      assertEquals(1, range0.getCount());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      Range range0 = new Range(1939, 1939);
      int int0 = range0.getCount();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      Range range1 = new Range((-1));
      boolean boolean0 = range0.fuzzyOverlaps(range1, (-1));
      assertFalse(boolean0);
      assertEquals(0, range0.getEnd());
      assertEquals((-1), range1.getEnd());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Range range0 = new Range(1);
      boolean boolean0 = range0.fuzzyOverlaps(range0, (-1));
      assertEquals(1, range0.getEnd());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      Range range0 = new Range((-1), 2108);
      boolean boolean0 = range0.fuzzyOverlaps(range0, (-1));
      assertTrue(boolean0);
      assertEquals((-1), range0.getStart());
      assertEquals(2110, range0.getCount());
      assertEquals(2108, range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Range range0 = new Range((-1), 2108);
      boolean boolean0 = range0.fuzzyOverlaps(range0, 2108);
      assertTrue(boolean0);
      assertEquals(2108, range0.getEnd());
      assertEquals(2110, range0.getCount());
      assertEquals((-1), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      Range range0 = new Range((-1), (-1));
      Range range1 = range0.truncate(range0);
      boolean boolean0 = range0.overlaps(range1);
      assertEquals((-1), range0.getStart());
      assertEquals(1, range1.getCount());
      assertEquals((-1), range0.getEnd());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Range range0 = new Range(633);
      Range range1 = range0.change(175, 2557);
      boolean boolean0 = range1.contains(range0);
      assertEquals(633, range0.getEnd());
      assertTrue(boolean0);
      assertEquals(633, range0.getStart());
      assertEquals(2383, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      Range range0 = new Range(0, 2940);
      Range range1 = range0.change(0, 0);
      Range range2 = range0.copy();
      boolean boolean0 = range1.equals(range2);
      assertEquals(1, range1.getCount());
      assertFalse(boolean0);
      assertEquals(2941, range2.getCount());
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Range range0 = new Range(633);
      boolean boolean0 = range0.equals(range0);
      assertTrue(boolean0);
      assertEquals(633, range0.getEnd());
      assertEquals(633, range0.getStart());
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Range range0 = new Range((-963));
      boolean boolean0 = range0.equals((Range) null);
      assertEquals((-963), range0.getEnd());
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      Range range0 = new Range((-1207), (-1207));
      Range range1 = new Range((-1207), 1);
      Range range2 = range1.truncate(range0);
      Range range3 = range1.truncate(range2);
      assertEquals(1, range2.getEnd());
      assertEquals(1, range3.getCount());
      assertNotNull(range3);
      assertEquals(1, range2.getStart());
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      Range range0 = new Range(0);
      Range range1 = range0.truncate(range0);
      Range range2 = range0.truncate(range1);
      assertNull(range2);
      assertEquals(1, range1.getCount());
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Range range0 = new Range((-1207), (-1207));
      Range range1 = range0.truncate(range0);
      assertNotNull(range1);
      
      range1.truncate(range0);
      assertEquals(1, range1.getCount());
      assertEquals((-1207), range0.getStart());
      assertEquals((-1207), range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      Range range0 = new Range((-4110));
      Range range1 = new Range((-4110), 0);
      boolean boolean0 = range0.contains(range1);
      assertFalse(boolean0);
      assertEquals(4111, range1.getCount());
      assertEquals((-4110), range1.getStart());
      assertEquals((-4110), range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      Range range0 = new Range(633);
      boolean boolean0 = range0.contains(range0);
      assertEquals(633, range0.getEnd());
      assertEquals(633, range0.getStart());
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      Range range0 = new Range((-1), 2108);
      Range range1 = new Range((-1));
      Range range2 = range0.truncate(range1);
      assertNotNull(range2);
      
      boolean boolean0 = range2.contains(range1);
      assertEquals(2110, range0.getCount());
      assertFalse(boolean0);
      assertEquals((-1), range1.getStart());
      assertEquals(1, range2.getCount());
      assertEquals((-1), range1.getEnd());
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      String string0 = range0.toString();
      assertEquals("-1..0", string0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      Range range0 = new Range(633);
      String string0 = range0.toString();
      assertEquals("633", string0);
      assertEquals(633, range0.getEnd());
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      Range range0 = new Range((-1), 0);
      try { 
        range0.change(442, 0);
        fail("Expecting exception: Exception");
      
      } catch(Exception e) {
         //
         // start: 442 > end: 0
         //
         verifyException("uk.ac.sanger.artemis.io.Range", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Range range0 = new Range((-1), 2108);
      Range range1 = range0.truncate(range0);
      assertNotNull(range1);
      
      boolean boolean0 = range1.contains(range0);
      assertEquals(2110, range0.getCount());
      assertFalse(boolean0);
      assertEquals(2108, range0.getEnd());
      assertEquals(2110, range1.getCount());
      assertEquals((-1), range0.getStart());
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      Range range0 = new Range(633);
      Range range1 = range0.change(175, 2557);
      boolean boolean0 = range1.equals(range0);
      assertFalse(boolean0);
      assertEquals(633, range0.getStart());
      assertEquals(2383, range1.getCount());
      assertEquals(1, range0.getCount());
  }
}
