/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 11:39:13 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PipedWriter;
import java.util.Date;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.FilteredEntryGroup;
import uk.ac.sanger.artemis.SimpleEntryGroup;
import uk.ac.sanger.artemis.components.LogReadListener;
import uk.ac.sanger.artemis.io.BlastDocumentEntry;
import uk.ac.sanger.artemis.io.BlastEntryInformation;
import uk.ac.sanger.artemis.io.BlastStreamFeature;
import uk.ac.sanger.artemis.io.EmblDocumentEntry;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.FeatureEnumeration;
import uk.ac.sanger.artemis.io.FeatureVector;
import uk.ac.sanger.artemis.io.GenbankDocumentEntry;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchDocumentEntry;
import uk.ac.sanger.artemis.io.MSPcrunchEntryInformation;
import uk.ac.sanger.artemis.io.PublicDBDocumentEntry;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ReadListener;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.io.SimpleEntryInformation;
import uk.ac.sanger.artemis.util.Document;
import uk.ac.sanger.artemis.util.FileDocument;
import uk.ac.sanger.artemis.util.ZipFileDocument;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class SimpleDocumentEntry_ESTest extends SimpleDocumentEntry_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(simpleEntryInformation0);
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(publicDBDocumentEntry0);
      boolean boolean0 = emblDocumentEntry0.setName("f,gP'0,-x");
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(entryInformation0);
      boolean boolean0 = mSPcrunchDocumentEntry0.setHeaderText((String) null);
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(simpleEntryInformation0);
      boolean boolean0 = blastDocumentEntry0.isReadOnly();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      int int0 = blastDocumentEntry0.indexOf(emblStreamFeature0);
      assertEquals((-1), int0);
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(mSPcrunchDocumentEntry0);
      String string0 = emblDocumentEntry0.getName();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0);
      FeatureVector featureVector0 = emblDocumentEntry0.getAllFeatures();
      assertTrue(featureVector0.isEmpty());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(mSPcrunchDocumentEntry0, true);
      MockFile mockFile0 = new MockFile("");
      FileDocument fileDocument0 = new FileDocument(mockFile0);
      try { 
        blastDocumentEntry0.save((Document) fileDocument0);
        fail("Expecting exception: FileNotFoundException");
      
      } catch(FileNotFoundException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("org.evosuite.runtime.mock.java.io.MockFileOutputStream", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      blastDocumentEntry0.dispose();
      // Undeclared exception!
      try { 
        blastDocumentEntry0.getHeaderText();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(mSPcrunchEntryInformation0);
      mSPcrunchDocumentEntry0.dispose();
      // Undeclared exception!
      try { 
        mSPcrunchDocumentEntry0.getFeatureAtIndex(0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      blastDocumentEntry0.line_groups = null;
      // Undeclared exception!
      try { 
        blastDocumentEntry0.features();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0);
      genbankDocumentEntry0.setDirtyFlag();
      assertFalse(genbankDocumentEntry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0);
      Sequence sequence0 = publicDBDocumentEntry0.getSequence();
      assertNull(sequence0);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      FeatureEnumeration featureEnumeration0 = blastDocumentEntry0.features();
      assertNotNull(featureEnumeration0);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      // Undeclared exception!
      try { 
        genbankDocumentEntry0.add((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      File file0 = MockFile.createTempFile(":organism", "");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, ":organism");
      LogReadListener logReadListener0 = new LogReadListener(":organism");
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0, zipFileDocument0, logReadListener0);
      genbankDocumentEntry0.save((Document) zipFileDocument0);
      assertFalse(genbankDocumentEntry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(simpleEntryInformation0);
      Document document0 = publicDBDocumentEntry0.getDocument();
      assertNull(document0);
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(mSPcrunchDocumentEntry0);
      EntryInformation entryInformation0 = emblDocumentEntry0.getEntryInformation();
      assertFalse(entryInformation0.useEMBLFormat());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(simpleEntryInformation0);
      mSPcrunchDocumentEntry0.setDocument((Document) null);
      assertTrue(mSPcrunchDocumentEntry0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      boolean boolean0 = genbankDocumentEntry0.isReadOnly();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      genbankDocumentEntry0.setHeaderText((String) null);
      boolean boolean0 = genbankDocumentEntry0.hasUnsavedChanges();
      assertTrue(boolean0);
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      boolean boolean0 = genbankDocumentEntry0.hasUnsavedChanges();
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(blastEntryInformation0);
      boolean boolean0 = mSPcrunchDocumentEntry0.setName("");
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      boolean boolean0 = mSPcrunchDocumentEntry0.setName((String) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(entryInformation0);
      PublicDBDocumentEntry publicDBDocumentEntry0 = new PublicDBDocumentEntry(entryInformation0, blastDocumentEntry0, false);
      PipedWriter pipedWriter0 = new PipedWriter();
      publicDBDocumentEntry0.writeToStream(pipedWriter0);
      FeatureEnumeration featureEnumeration0 = publicDBDocumentEntry0.features();
      assertNotNull(featureEnumeration0);
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(blastEntryInformation0);
      FeatureVector featureVector0 = mSPcrunchDocumentEntry0.getFeaturesInRange((Range) null);
      assertEquals(0, featureVector0.size());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      Key key0 = new Key("Failed to use the following keys\n");
      QualifierVector qualifierVector0 = new QualifierVector();
      try { 
        blastDocumentEntry0.createFeature(key0, (Location) null, qualifierVector0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      Feature feature0 = genbankDocumentEntry0.getFeatureAtIndex(2);
      assertNull(feature0);
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(blastEntryInformation0);
      try { 
        mSPcrunchDocumentEntry0.remove((Feature) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      SimpleEntryInformation simpleEntryInformation0 = new SimpleEntryInformation();
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry(simpleEntryInformation0);
      boolean boolean0 = mSPcrunchDocumentEntry0.removeInternal((Feature) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      BlastStreamFeature blastStreamFeature0 = (BlastStreamFeature)blastDocumentEntry0.makeNativeFeature(emblStreamFeature0, true);
      try { 
        blastDocumentEntry0.forcedAdd(blastStreamFeature0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      try { 
        blastDocumentEntry0.add(emblStreamFeature0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      SimpleEntryGroup simpleEntryGroup0 = new SimpleEntryGroup();
      uk.ac.sanger.artemis.FeatureVector featureVector0 = new uk.ac.sanger.artemis.FeatureVector();
      FilteredEntryGroup filteredEntryGroup0 = new FilteredEntryGroup(simpleEntryGroup0, featureVector0, "Skh)45jO;*@Vy67U");
      Key key0 = Key.CDS;
      uk.ac.sanger.artemis.Entry entry0 = filteredEntryGroup0.createEntry();
      Range range0 = new Range(1591, 1591);
      RangeVector rangeVector0 = new RangeVector(range0);
      Location location0 = new Location(rangeVector0, true);
      // Undeclared exception!
      try { 
        entry0.createFeature(key0, location0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.Feature", e);
      }
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(blastEntryInformation0);
      int int0 = emblDocumentEntry0.getFeatureCount();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((EntryInformation) null);
      try { 
        mSPcrunchDocumentEntry0.setHeaderText("S}\"%Rlx");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // the header must contain only header lines
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      EmblDocumentEntry emblDocumentEntry0 = new EmblDocumentEntry(entryInformation0);
      CharArrayWriter charArrayWriter0 = new CharArrayWriter();
      emblDocumentEntry0.writeToStream(charArrayWriter0);
      String string0 = emblDocumentEntry0.getHeaderText();
      assertNull(string0);
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      File file0 = MockFile.createTempFile(":organism", "");
      ZipFileDocument zipFileDocument0 = new ZipFileDocument(file0, ":organism");
      LogReadListener logReadListener0 = new LogReadListener(":organism");
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(blastEntryInformation0, zipFileDocument0, logReadListener0);
      boolean boolean0 = genbankDocumentEntry0.contains((Feature) null);
      assertFalse(boolean0);
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      MSPcrunchDocumentEntry mSPcrunchDocumentEntry0 = null;
      try {
        mSPcrunchDocumentEntry0 = new MSPcrunchDocumentEntry((Document) null, (ReadListener) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.SimpleDocumentEntry", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      EntryInformation entryInformation0 = SimpleEntryInformation.getDefaultEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(entryInformation0);
      genbankDocumentEntry0.save();
      assertTrue(PublicDBDocumentEntry.IGNORE_OBSOLETE_FEATURES);
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      BlastEntryInformation blastEntryInformation0 = new BlastEntryInformation();
      BlastDocumentEntry blastDocumentEntry0 = new BlastDocumentEntry(blastEntryInformation0);
      Date date0 = blastDocumentEntry0.getLastChangeTime();
      assertNull(date0);
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      genbankDocumentEntry0.forcedAdd(genbankStreamFeature0);
      // Undeclared exception!
      try { 
        genbankDocumentEntry0.removeInternal((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.FeatureComparator", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      MSPcrunchEntryInformation mSPcrunchEntryInformation0 = new MSPcrunchEntryInformation();
      GenbankDocumentEntry genbankDocumentEntry0 = new GenbankDocumentEntry(mSPcrunchEntryInformation0);
      GenbankDocumentEntry genbankDocumentEntry1 = new GenbankDocumentEntry(mSPcrunchEntryInformation0, genbankDocumentEntry0, true);
      assertFalse(genbankDocumentEntry1.equals((Object)genbankDocumentEntry0));
  }
}
