/* This file is part of Atomes.

Atomes is free software: you can redistribute it and/or modify it under the terms
of the GNU Affero General Public License as published by the Free Software Foundation,
either version 3 of the License, or (at your option) any later version.

Atomes is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU Affero General Public License along with Atomes.
If not, see <https://www.gnu.org/licenses/> */

/*
* This file: 'oplsaap.c'
*
*  Contains:
*

  OPLSAAM force field

  This file contains several tables:

    Atoms      : OPLSAAM_atoms[78][4]
    Bonds      : OPLSAAM_bonds[159][4]
    Angles     : OPLSAAM_angles[437][5]
    Dihedrals  : OPLSAAM_dihedrals[1446][7]
    Impropers  : OPLSAAM_impropers[105][[7]
    Non bonded : OPLSAAM_vdw[78][7]

*/

#include "global.h"

/*
 Atoms
  0= Element, 1= Mass, 2= Key, 3= Description, 4= OPLSAAM info
*/
int OPLSAAM_objects[14] = {78, 0, 0, 159, 0, 0, 437, 0, 1446, 0 , 0, 105, 78, 0};
int OPLSAAM_dim[14] = {4, 0, 0, 4, 0, 0, 5, 0, 7, 0, 0, 7, 7, 0};
/*
  Atoms
*/
char * OPLSAAM_atoms[78][4]= {{"C", "12.01100", "C135", "CH3 all-atom C: alkanes ALL-ATOM "},
                              {"C", "12.01100", "C136", "CH2 all-atom C: alkanes PARAMETERS"},
                              {"C", "12.01100", "C137", "CH all-atom C: alkanes FROM HERE ON"},
                              {"C", "12.01100", "C145", "Benzene C - 12 site JACS,112,4768-90"},
                              {"C", "12.01100", "C149", "all-atom C: CH2, ethyl benzene"},
                              {"C", "12.01100", "C157", "all-atom C: CH3 and CH2, alcohols"},
                              {"C", "12.01100", "C158", "all-atom C: CH, alcohols"},
                              {"C", "12.01100", "C166", "C(OH) phenol Use with all"},
                              {"C", "12.01100", "C206", "all-atom C: CH2, thiols"},
                              {"C", "12.01100", "C209", "all-atom C: CH3, sulfides"},
                              {"C", "12.01100", "C210", "all-atom C: CH2, sulfides"},
                              {"C", "12.01100", "C214", "all-atom C: CH2, disulfides"},
                              {"C", "12.01100", "C223", "C in RCH2NH2 and Gly CA (See 900 for amines)"},
                              {"C", "12.01100", "C224", "C in R2CHNH2 and Ala CA"},
                              {"C", "12.01100", "C235", "C: C=O in amide. Acyl R in amides"},
                              {"C", "12.01100", "C242", "C on N: secondary N-Me amide"},
                              {"C", "12.01100", "C245", "C on N: tertiary N-CH2R amide (Pro Cdelta)"},
                              {"C", "12.01100", "C246", "C on N: tertiary N-CHR2 amide (Pro Calpha)"},
                              {"C", "12.01100", "C267", "Co in CCOOH carboxylic acid"},
                              {"C", "12.01100", "C271", "C in COO- carboxylate"},
                              {"C", "12.01100", "C274", "C: CH2, carboxylate ion"},
                              {"C", "12.01100", "C283", "AA C-alpha on C-terminal ALA"},
                              {"C", "12.01100", "C284", "AA C-alpha on C-terminal GLY"},
                              {"C", "12.01100", "C285", "AA C-alpha on C-terminal PRO"},
                              {"C", "12.01100", "C292", "C in RCH2NH3+ and CA in N-term Gly"},
                              {"C", "12.01100", "C293", "C in R2CHNH3+ and CA in N-term Ala, etc."},
                              {"C", "12.01100", "C295", "AA:C-alpha in N-term PRO"},
                              {"C", "12.01100", "C296", "AA:C-delta in N-term PRO"},
                              {"C", "12.01100", "C302", "C: guanidinium C+"},
                              {"C", "12.01100", "C307", "C: CH2(D), ARG, ethylguanidinium"},
                              {"C", "12.01100", "C308", "C: CH2(G), ARG"},
                              {"C", "12.01100", "C500", "CG in TRP"},
                              {"C", "12.01100", "C501", "CD C in TRP"},
                              {"C", "12.01100", "C502", "CE C in TRP"},
                              {"C", "12.01100", "C505", "CB in HIS"},
                              {"C", "12.01100", "C506", "CE1 in HID, HIE"},
                              {"C", "12.01100", "C507", "CD2 in HID, CG in HIE"},
                              {"C", "12.01100", "C508", "CG in HID, CD2 in HIE"},
                              {"C", "12.01100", "C509", "CE1 in HIP"},
                              {"C", "12.01100", "C510", "CG, CD2 in HIP"},
                              {"C", "12.01100", "C514", "CD1 in TRP"},
                              {"H", "1.00800", "H140", "H all-atom H: alkanes"},
                              {"H", "1.00800", "H146", "Benzene H - 12 site"},
                              {"H", "1.00800", "H155", "all-atom H(O): mono alcohols"},
                              {"H", "1.00800", "H168", "H phenol 145 and 146"},
                              {"H", "1.00800", "H204", "all-atom H(S): thiols (mod 11/99)"},
                              {"H", "1.00800", "H240", "H on N: primary amide"},
                              {"H", "1.00800", "H241", "H on N: secondary amide"},
                              {"H", "1.00800", "H270", "H in CCOOH"},
                              {"H", "1.00800", "H290", "H (RNH3+)"},
                              {"H", "1.00800", "H301", "H: guanidinium NH2"},
                              {"H", "1.00800", "H304", "H: guanidinium NHR"},
                              {"H", "1.00800", "H310", "H (R2NH2+)"},
                              {"H", "1.00800", "H504", "H on NE in TRP"},
                              {"H", "1.00800", "H513", "H on N in HIP"},
                              {"N", "14.00700", "N237", "N: primary amide. alkane parameters."},
                              {"N", "14.00700", "N238", "N: secondary amide 279 for formyl H."},
                              {"N", "14.00700", "N239", "N: tertiary amide"},
                              {"N", "14.00700", "N287", "N (RNH3+)"},
                              {"N", "14.00700", "N300", "N: guanidinium NH2"},
                              {"N", "14.00700", "N303", "N: guanidinium NHR"},
                              {"N", "14.00700", "N309", "N (R2NH2+)"},
                              {"N", "14.00700", "N503", "NE in TRP"},
                              {"N", "14.00700", "N511", "NE in HID, ND in HIE"},
                              {"N", "14.00700", "N512", "N in HIP"},
                              {"O", "15.99940", "O154", "all-atom O: mono alcohols"},
                              {"O", "15.99940", "O167", "O phenol atom C, H"},
                              {"O", "15.99940", "O236", "O: C=O in amide. is neutral - use"},
                              {"O", "15.99940", "O268", "Oh in CCOOH R in RCOOH is"},
                              {"O", "15.99940", "O269", "Oc in CCOOH neutral; use 135-140"},
                              {"O", "15.99940", "O272", "O: O in COO- carboxylate"},
                              {"S", "32.06000", "S200", "all-atom S: thiols (mod 11/99)"},
                              {"S", "32.06000", "S202", "all-atom S: sulfides"},
                              {"S", "32.06000", "S203", "all-atom S: disulfides"},
                              {"O", "15.99940", "OT", " "},
                              {"H", "1.00800", "HT", " "},
                              {"Na", "22.98977", "SOD", "Sodium Ion, adm jr."},
                              {"Cl", "35.45000", "CLA", "Chloride Ion, adm jr."}};

/*
 Bonds
*/
char * OPLSAAM_bonds[159][4]= {{"OT", "HT", "450.0", "0.9572"},
                                   {"HT", "HT", "0.0", "1.5139"},
                                   {"S203", "S203", "166.0", "2.038"},
                                   {"C135", "C136", "268.00", "1.529"},
                                   {"C135", "C137", "268.00", "1.529"},
                                   {"C135", "C158", "268.00", "1.529"},
                                   {"C135", "C224", "268.00", "1.529"},
                                   {"C135", "C235", "317.00", "1.522"},
                                   {"C135", "C283", "268.00", "1.529"},
                                   {"C135", "C293", "268.00", "1.529"},
                                   {"C135", "H140", "340.00", "1.090"},
                                   {"C136", "C136", "268.00", "1.529"},
                                   {"C136", "C137", "268.00", "1.529"},
                                   {"C136", "C210", "268.00", "1.529"},
                                   {"C136", "C224", "268.00", "1.529"},
                                   {"C136", "C235", "317.00", "1.522"},
                                   {"C136", "C245", "268.00", "1.529"},
                                   {"C136", "C246", "268.00", "1.529"},
                                   {"C136", "C267", "317.00", "1.522"},
                                   {"C136", "C274", "268.00", "1.529"},
                                   {"C136", "C283", "268.00", "1.529"},
                                   {"C136", "C285", "268.00", "1.529"},
                                   {"C136", "C292", "268.00", "1.529"},
                                   {"C136", "C293", "268.00", "1.529"},
                                   {"C136", "C295", "268.00", "1.529"},
                                   {"C136", "C296", "268.00", "1.529"},
                                   {"C136", "C308", "268.00", "1.529"},
                                   {"C136", "C500", "317.00", "1.495"},
                                   {"C136", "H140", "340.00", "1.090"},
                                   {"C137", "C224", "268.00", "1.529"},
                                   {"C137", "C283", "268.00", "1.529"},
                                   {"C137", "C293", "268.00", "1.529"},
                                   {"C137", "H140", "340.00", "1.090"},
                                   {"C145", "C145", "469.00", "1.400"},
                                   {"C145", "C149", "317.00", "1.510"},
                                   {"C145", "C166", "469.00", "1.400"},
                                   {"C145", "C501", "469.00", "1.404"},
                                   {"C145", "C502", "469.00", "1.400"},
                                   {"C145", "H146", "367.00", "1.080"},
                                   {"C149", "C224", "268.00", "1.529"},
                                   {"C149", "C283", "268.00", "1.529"},
                                   {"C149", "C293", "268.00", "1.529"},
                                   {"C149", "H140", "340.00", "1.090"},
                                   {"C157", "C224", "268.00", "1.529"},
                                   {"C157", "C283", "268.00", "1.529"},
                                   {"C157", "C293", "268.00", "1.529"},
                                   {"C157", "H140", "340.00", "1.090"},
                                   {"C157", "O154", "320.00", "1.410"},
                                   {"C158", "C224", "268.00", "1.529"},
                                   {"C158", "C283", "268.00", "1.529"},
                                   {"C158", "C293", "268.00", "1.529"},
                                   {"C158", "H140", "340.00", "1.090"},
                                   {"C158", "O154", "320.00", "1.410"},
                                   {"C166", "O167", "450.00", "1.364"},
                                   {"C206", "C224", "268.00", "1.529"},
                                   {"C206", "C283", "268.00", "1.529"},
                                   {"C206", "C293", "268.00", "1.529"},
                                   {"C206", "H140", "340.00", "1.090"},
                                   {"C206", "S200", "222.00", "1.810"},
                                   {"C209", "H140", "340.00", "1.090"},
                                   {"C209", "S202", "222.00", "1.810"},
                                   {"C210", "H140", "340.00", "1.090"},
                                   {"C210", "S202", "222.00", "1.810"},
                                   {"C214", "C224", "268.00", "1.529"},
                                   {"C214", "C283", "268.00", "1.529"},
                                   {"C214", "C293", "268.00", "1.529"},
                                   {"C214", "H140", "340.00", "1.090"},
                                   {"C214", "S203", "222.00", "1.810"},
                                   {"C223", "C235", "317.00", "1.522"},
                                   {"C223", "H140", "340.00", "1.090"},
                                   {"C223", "N238", "337.00", "1.449"},
                                   {"C223", "C267", "317.00", "1.522"},
                                   {"C224", "C235", "317.00", "1.522"},
                                   {"C224", "C267", "317.00", "1.522"},
                                   {"C224", "C274", "268.00", "1.529"},
                                   {"C224", "C505", "268.00", "1.529"},
                                   {"C224", "H140", "340.00", "1.090"},
                                   {"C224", "N238", "337.00", "1.449"},
                                   {"C235", "C246", "317.00", "1.522"},
                                   {"C235", "C292", "317.00", "1.522"},
                                   {"C235", "C293", "317.00", "1.522"},
                                   {"C235", "C295", "317.00", "1.522"},
                                   {"C235", "N237", "490.00", "1.335"},
                                   {"C235", "N238", "490.00", "1.335"},
                                   {"C235", "N239", "490.00", "1.335"},
                                   {"C235", "O236", "570.00", "1.229"},
                                   {"C242", "H140", "340.00", "1.090"},
                                   {"C242", "N238", "337.00", "1.449"},
                                   {"C245", "H140", "340.00", "1.090"},
                                   {"C245", "N239", "337.00", "1.449"},
                                   {"C246", "H140", "340.00", "1.090"},
                                   {"C246", "N239", "337.00", "1.449"},
                                   {"C267", "O268", "450.00", "1.364"},
                                   {"C267", "O269", "570.00", "1.229"},
                                   {"C271", "C274", "317.00", "1.522"},
                                   {"C271", "C283", "317.00", "1.522"},
                                   {"C271", "C284", "317.00", "1.522"},
                                   {"C271", "C285", "317.00", "1.522"},
                                   {"C271", "O272", "656.00", "1.250"},
                                   {"C274", "C283", "268.00", "1.529"},
                                   {"C274", "C293", "268.00", "1.529"},
                                   {"C274", "H140", "340.00", "1.090"},
                                   {"C283", "C505", "268.00", "1.529"},
                                   {"C283", "H140", "340.00", "1.090"},
                                   {"C283", "N238", "337.00", "1.449"},
                                   {"C284", "H140", "340.00", "1.090"},
                                   {"C284", "N238", "337.00", "1.449"},
                                   {"C285", "H140", "340.00", "1.090"},
                                   {"C285", "N239", "337.00", "1.449"},
                                   {"C292", "H140", "340.00", "1.090"},
                                   {"C292", "N287", "367.00", "1.471"},
                                   {"C293", "C505", "268.00", "1.529"},
                                   {"C293", "H140", "340.00", "1.090"},
                                   {"C293", "N287", "367.00", "1.471"},
                                   {"C295", "H140", "340.00", "1.090"},
                                   {"C295", "N309", "367.00", "1.471"},
                                   {"C296", "H140", "340.00", "1.090"},
                                   {"C296", "N309", "367.00", "1.471"},
                                   {"C302", "N300", "481.00", "1.340"},
                                   {"C302", "N303", "481.00", "1.340"},
                                   {"C307", "C308", "268.00", "1.529"},
                                   {"C307", "H140", "340.00", "1.090"},
                                   {"C307", "N303", "337.00", "1.463"},
                                   {"C308", "H140", "340.00", "1.090"},
                                   {"C500", "C501", "388.00", "1.459"},
                                   {"C500", "C514", "546.00", "1.352"},
                                   {"C501", "C502", "447.00", "1.419"},
                                   {"C502", "N503", "428.00", "1.380"},
                                   {"C505", "C507", "317.00", "1.504"},
                                   {"C505", "C508", "317.00", "1.504"},
                                   {"C505", "C510", "317.00", "1.504"},
                                   {"C505", "H140", "340.00", "1.090"},
                                   {"C506", "H146", "367.00", "1.080"},
                                   {"C506", "N503", "477.00", "1.343"},
                                   {"C506", "N511", "488.00", "1.335"},
                                   {"C507", "C508", "520.00", "1.370"},
                                   {"C507", "H146", "367.00", "1.080"},
                                   {"C507", "N511", "410.00", "1.394"},
                                   {"C508", "H146", "367.00", "1.080"},
                                   {"C508", "N503", "427.00", "1.381"},
                                   {"C509", "H146", "367.00", "1.080"},
                                   {"C509", "N512", "477.00", "1.343"},
                                   {"C510", "C510", "520.00", "1.370"},
                                   {"C510", "H146", "367.00", "1.080"},
                                   {"C510", "N512", "427.00", "1.381"},
                                   {"C514", "H146", "367.00", "1.080"},
                                   {"C514", "N503", "427.00", "1.381"},
                                   {"H155", "O154", "553.00", "0.945"},
                                   {"H168", "O167", "553.00", "0.945"},
                                   {"H204", "S200", "274.00", "1.336"},
                                   {"H240", "N237", "434.00", "1.010"},
                                   {"H241", "N238", "434.00", "1.010"},
                                   {"H270", "O268", "553.00", "0.945"},
                                   {"H290", "N287", "434.00", "1.010"},
                                   {"H301", "N300", "434.00", "1.010"},
                                   {"H304", "N303", "434.00", "1.010"},
                                   {"H310", "N309", "434.00", "1.010"},
                                   {"H504", "N503", "434.00", "1.010"},
                                   {"H513", "N512", "434.00", "1.010"}};

/*
 Angles
*/
char * OPLSAAM_angles[437][5]= {{"HT", "OT", "HT", "55.0", "104.52"},
                                   {"H140", "C135", "H140", "33.0", "107.8"},
                                   {"H140", "C136", "H140", "33.0", "107.8"},
                                   {"H140", "C149", "H140", "33.0", "107.8"},
                                   {"H140", "C157", "H140", "33.0", "107.8"},
                                   {"H140", "C206", "H140", "33.0", "107.8"},
                                   {"H140", "C209", "H140", "33.0", "107.8"},
                                   {"H140", "C210", "H140", "33.0", "107.8"},
                                   {"H140", "C214", "H140", "33.0", "107.8"},
                                   {"H140", "C223", "H140", "33.0", "107.8"},
                                   {"H140", "C224", "H140", "33.0", "107.8"},
                                   {"H140", "C242", "H140", "33.0", "107.8"},
                                   {"H140", "C245", "H140", "33.0", "107.8"},
                                   {"H140", "C274", "H140", "33.0", "107.8"},
                                   {"H140", "C284", "H140", "33.0", "107.8"},
                                   {"H140", "C292", "H140", "33.0", "107.8"},
                                   {"H140", "C296", "H140", "33.0", "107.8"},
                                   {"H140", "C307", "H140", "33.0", "107.8"},
                                   {"H140", "C308", "H140", "33.0", "107.8"},
                                   {"H140", "C505", "H140", "33.0", "107.8"},
                                   {"H290", "N287", "H290", "35.0", "109.5"},
                                   {"H310", "N309", "H310", "35.0", "109.5"},
                                   {"C135", "C136", "C137", "58.35", "112.70"},
                                   {"C135", "C136", "H140", "37.50", "110.70"},
                                   {"C135", "C137", "C135", "58.35", "112.70"},
                                   {"C135", "C137", "C136", "58.35", "112.70"},
                                   {"C135", "C137", "C224", "58.35", "112.70"},
                                   {"C135", "C137", "C283", "58.35", "112.70"},
                                   {"C135", "C137", "C293", "58.35", "112.70"},
                                   {"C135", "C137", "H140", "37.50", "110.70"},
                                   {"C135", "C158", "C224", "58.35", "112.70"},
                                   {"C135", "C158", "C283", "58.35", "112.70"},
                                   {"C135", "C158", "C293", "58.35", "112.70"},
                                   {"C135", "C158", "H140", "37.50", "110.70"},
                                   {"C135", "C158", "O154", "50.00", "109.50"},
                                   {"C135", "C224", "C235", "63.00", "111.10"},
                                   {"C135", "C224", "C267", "63.00", "111.10"},
                                   {"C135", "C224", "H140", "37.50", "110.70"},
                                   {"C135", "C224", "N238", "80.00", "109.70"},
                                   {"C135", "C235", "N238", "70.00", "116.60"},
                                   {"C135", "C235", "N239", "70.00", "116.60"},
                                   {"C135", "C235", "O236", "80.00", "120.40"},
                                   {"C135", "C283", "C271", "63.00", "111.10"},
                                   {"C135", "C283", "H140", "37.50", "110.70"},
                                   {"C135", "C283", "N238", "80.00", "109.70"},
                                   {"C135", "C293", "C235", "63.00", "111.10"},
                                   {"C135", "C293", "H140", "37.50", "110.70"},
                                   {"C135", "C293", "N287", "80.00", "111.20"},
                                   {"C136", "C135", "H140", "37.50", "110.70"},
                                   {"C136", "C136", "C136", "58.35", "112.70"},
                                   {"C136", "C136", "C224", "58.35", "112.70"},
                                   {"C136", "C136", "C235", "63.00", "111.10"},
                                   {"C136", "C136", "C245", "58.35", "112.70"},
                                   {"C136", "C136", "C246", "58.35", "112.70"},
                                   {"C136", "C136", "C267", "63.00", "111.10"},
                                   {"C136", "C136", "C283", "58.35", "112.70"},
                                   {"C136", "C136", "C285", "58.35", "112.70"},
                                   {"C136", "C136", "C292", "58.35", "112.70"},
                                   {"C136", "C136", "C293", "58.35", "112.70"},
                                   {"C136", "C136", "C295", "58.35", "112.70"},
                                   {"C136", "C136", "C296", "58.35", "112.70"},
                                   {"C136", "C136", "H140", "37.50", "110.70"},
                                   {"C136", "C137", "C224", "58.35", "112.70"},
                                   {"C136", "C137", "C283", "58.35", "112.70"},
                                   {"C136", "C137", "C293", "58.35", "112.70"},
                                   {"C136", "C137", "H140", "37.50", "110.70"},
                                   {"C136", "C210", "H140", "37.50", "110.70"},
                                   {"C136", "C210", "S202", "50.00", "114.70"},
                                   {"C136", "C224", "C235", "63.00", "111.10"},
                                   {"C136", "C224", "H140", "37.50", "110.70"},
                                   {"C136", "C224", "N238", "80.00", "109.70"},
                                   {"C136", "C235", "N237", "70.00", "116.60"},
                                   {"C136", "C235", "O236", "80.00", "120.40"},
                                   {"C136", "C245", "H140", "37.50", "110.70"},
                                   {"C136", "C245", "N239", "80.00", "109.70"},
                                   {"C136", "C246", "C235", "63.00", "111.10"},
                                   {"C136", "C246", "H140", "37.50", "110.70"},
                                   {"C136", "C246", "N239", "80.00", "109.70"},
                                   {"C136", "C267", "O268", "70.00", "108.00"},
                                   {"C136", "C267", "O269", "80.00", "120.40"},
                                   {"C136", "C274", "C271", "63.00", "111.10"},
                                   {"C136", "C274", "H140", "37.50", "110.70"},
                                   {"C136", "C283", "C271", "63.00", "111.10"},
                                   {"C136", "C283", "H140", "37.50", "110.70"},
                                   {"C136", "C283", "N238", "80.00", "109.70"},
                                   {"C136", "C285", "C271", "63.00", "111.10"},
                                   {"C136", "C285", "H140", "37.50", "110.70"},
                                   {"C136", "C285", "N239", "80.00", "109.70"},
                                   {"C136", "C292", "H140", "37.50", "110.70"},
                                   {"C136", "C292", "N287", "80.00", "111.20"},
                                   {"C136", "C293", "C235", "63.00", "111.10"},
                                   {"C136", "C293", "H140", "37.50", "110.70"},
                                   {"C136", "C293", "N287", "80.00", "111.20"},
                                   {"C136", "C295", "C235", "63.00", "111.10"},
                                   {"C136", "C295", "H140", "37.50", "110.70"},
                                   {"C136", "C295", "N309", "80.00", "111.20"},
                                   {"C136", "C296", "H140", "37.50", "110.70"},
                                   {"C136", "C296", "N309", "80.00", "111.20"},
                                   {"C136", "C308", "C307", "58.35", "112.70"},
                                   {"C136", "C308", "H140", "37.50", "110.70"},
                                   {"C136", "C500", "C501", "70.00", "128.60"},
                                   {"C136", "C500", "C514", "70.00", "125.00"},
                                   {"C137", "C135", "H140", "37.50", "110.70"},
                                   {"C137", "C136", "C224", "58.35", "112.70"},
                                   {"C137", "C136", "C283", "58.35", "112.70"},
                                   {"C137", "C136", "C293", "58.35", "112.70"},
                                   {"C137", "C136", "H140", "37.50", "110.70"},
                                   {"C137", "C224", "C235", "63.00", "111.10"},
                                   {"C137", "C224", "H140", "37.50", "110.70"},
                                   {"C137", "C224", "N238", "80.00", "109.70"},
                                   {"C137", "C283", "C271", "63.00", "111.10"},
                                   {"C137", "C283", "H140", "37.50", "110.70"},
                                   {"C137", "C283", "N238", "80.00", "109.70"},
                                   {"C137", "C293", "C235", "63.00", "111.10"},
                                   {"C137", "C293", "H140", "37.50", "110.70"},
                                   {"C137", "C293", "N287", "80.00", "111.20"},
                                   {"C145", "C145", "C145", "63.00", "120.00"},
                                   {"C145", "C145", "C149", "70.00", "120.00"},
                                   {"C145", "C145", "C166", "63.00", "120.00"},
                                   {"C145", "C145", "C501", "63.00", "120.00"},
                                   {"C145", "C145", "C502", "85.00", "120.00"},
                                   {"C145", "C145", "H146", "35.00", "120.00"},
                                   {"C145", "C149", "C224", "63.00", "114.00"},
                                   {"C145", "C149", "C283", "63.00", "114.00"},
                                   {"C145", "C149", "C293", "63.00", "114.00"},
                                   {"C145", "C149", "H140", "35.00", "109.50"},
                                   {"C145", "C166", "C145", "63.00", "120.00"},
                                   {"C145", "C166", "O167", "70.00", "120.00"},
                                   {"C145", "C501", "C500", "85.00", "134.90"},
                                   {"C145", "C501", "C502", "85.00", "116.20"},
                                   {"C145", "C502", "C501", "85.00", "122.70"},
                                   {"C145", "C502", "N503", "70.00", "132.80"},
                                   {"C149", "C224", "C235", "63.00", "111.10"},
                                   {"C149", "C224", "H140", "37.50", "110.70"},
                                   {"C149", "C224", "N238", "80.00", "109.70"},
                                   {"C149", "C283", "C271", "63.00", "111.10"},
                                   {"C149", "C283", "H140", "37.50", "110.70"},
                                   {"C149", "C283", "N238", "80.00", "109.70"},
                                   {"C149", "C293", "C235", "63.00", "111.10"},
                                   {"C149", "C293", "H140", "37.50", "110.70"},
                                   {"C149", "C293", "N287", "80.00", "111.20"},
                                   {"C157", "C224", "C235", "63.00", "111.10"},
                                   {"C157", "C224", "H140", "37.50", "110.70"},
                                   {"C157", "C224", "N238", "80.00", "109.70"},
                                   {"C157", "C283", "C271", "63.00", "111.10"},
                                   {"C157", "C283", "H140", "37.50", "110.70"},
                                   {"C157", "C283", "N238", "80.00", "109.70"},
                                   {"C157", "C293", "C235", "63.00", "111.10"},
                                   {"C157", "C293", "H140", "37.50", "110.70"},
                                   {"C157", "C293", "N287", "80.00", "111.20"},
                                   {"C157", "O154", "H155", "55.00", "108.50"},
                                   {"C158", "C135", "H140", "37.50", "110.70"},
                                   {"C158", "C224", "C235", "63.00", "111.10"},
                                   {"C158", "C224", "H140", "37.50", "110.70"},
                                   {"C158", "C224", "N238", "80.00", "109.70"},
                                   {"C158", "C283", "C271", "63.00", "111.10"},
                                   {"C158", "C283", "H140", "37.50", "110.70"},
                                   {"C158", "C283", "N238", "80.00", "109.70"},
                                   {"C158", "C293", "C235", "63.00", "111.10"},
                                   {"C158", "C293", "H140", "37.50", "110.70"},
                                   {"C158", "C293", "N287", "80.00", "111.20"},
                                   {"C158", "O154", "H155", "55.00", "108.50"},
                                   {"C166", "C145", "H146", "35.00", "120.00"},
                                   {"C166", "O167", "H168", "35.00", "113.00"},
                                   {"C206", "C224", "C235", "63.00", "111.10"},
                                   {"C206", "C224", "H140", "37.50", "110.70"},
                                   {"C206", "C224", "N238", "80.00", "109.70"},
                                   {"C206", "C283", "C271", "63.00", "111.10"},
                                   {"C206", "C283", "H140", "37.50", "110.70"},
                                   {"C206", "C283", "N238", "80.00", "109.70"},
                                   {"C206", "C293", "C235", "63.00", "111.10"},
                                   {"C206", "C293", "H140", "37.50", "110.70"},
                                   {"C206", "C293", "N287", "80.00", "111.20"},
                                   {"C206", "S200", "H204", "44.00", "96.00"},
                                   {"C209", "S202", "C210", "62.00", "98.90"},
                                   {"C210", "C136", "C224", "58.35", "112.70"},
                                   {"C210", "C136", "C283", "58.35", "112.70"},
                                   {"C210", "C136", "C293", "58.35", "112.70"},
                                   {"C210", "C136", "H140", "37.50", "110.70"},
                                   {"C214", "C224", "C235", "63.00", "111.10"},
                                   {"C214", "C224", "H140", "37.50", "110.70"},
                                   {"C214", "C224", "N238", "80.00", "109.70"},
                                   {"C214", "C283", "C271", "63.00", "111.10"},
                                   {"C214", "C283", "H140", "37.50", "110.70"},
                                   {"C214", "C283", "N238", "80.00", "109.70"},
                                   {"C214", "C293", "C235", "63.00", "111.10"},
                                   {"C214", "C293", "H140", "37.50", "110.70"},
                                   {"C214", "C293", "N287", "80.00", "111.20"},
                                   {"C214", "S203", "S203", "68.00", "103.70"},
                                   {"C223", "C235", "N238", "70.00", "116.60"},
                                   {"C223", "C235", "N239", "70.00", "116.60"},
                                   {"C223", "C235", "O236", "80.00", "120.40"},
                                   {"C223", "N238", "C235", "50.00", "121.90"},
                                   {"C223", "N238", "H241", "38.00", "118.40"},
                                   {"C224", "C135", "H140", "37.50", "110.70"},
                                   {"C224", "C136", "C235", "63.00", "111.10"},
                                   {"C224", "C136", "C267", "63.00", "111.10"},
                                   {"C224", "C136", "C274", "58.35", "112.70"},
                                   {"C224", "C136", "C308", "58.35", "112.70"},
                                   {"C224", "C136", "C500", "63.00", "115.60"},
                                   {"C224", "C136", "H140", "37.50", "110.70"},
                                   {"C224", "C137", "H140", "37.50", "110.70"},
                                   {"C224", "C149", "H140", "37.50", "110.70"},
                                   {"C224", "C157", "H140", "37.50", "110.70"},
                                   {"C224", "C157", "O154", "50.00", "109.50"},
                                   {"C224", "C158", "H140", "37.50", "110.70"},
                                   {"C224", "C158", "O154", "50.00", "109.50"},
                                   {"C224", "C206", "H140", "37.50", "110.70"},
                                   {"C224", "C206", "S200", "50.00", "108.60"},
                                   {"C224", "C214", "H140", "37.50", "110.70"},
                                   {"C224", "C214", "S203", "50.00", "114.70"},
                                   {"C224", "C235", "N238", "70.00", "116.60"},
                                   {"C224", "C235", "N239", "70.00", "116.60"},
                                   {"C224", "C235", "O236", "80.00", "120.40"},
                                   {"C223", "C267", "O268", "70.00", "108.00"},
                                   {"C224", "C267", "O268", "70.00", "108.00"},
                                   {"C223", "C267", "O269", "80.00", "120.40"},
                                   {"C224", "C267", "O269", "80.00", "120.40"},
                                   {"C224", "C274", "C271", "63.00", "111.10"},
                                   {"C224", "C274", "H140", "37.50", "110.70"},
                                   {"C224", "C505", "C507", "63.00", "114.00"},
                                   {"C224", "C505", "C508", "63.00", "114.00"},
                                   {"C224", "C505", "C510", "63.00", "114.00"},
                                   {"C224", "C505", "H140", "37.50", "110.70"},
                                   {"C224", "N238", "C235", "50.00", "121.90"},
                                   {"C224", "N238", "H241", "38.00", "118.40"},
                                   {"C235", "C135", "H140", "35.00", "109.50"},
                                   {"C235", "C136", "C283", "63.00", "111.10"},
                                   {"C235", "C136", "C293", "63.00", "111.10"},
                                   {"C235", "C136", "H140", "35.00", "109.50"},
                                   {"C235", "C223", "H140", "35.00", "109.50"},
                                   {"C235", "C223", "N238", "63.00", "110.10"},
                                   {"C235", "C224", "C274", "63.00", "111.10"},
                                   {"C235", "C224", "C505", "63.00", "111.10"},
                                   {"C235", "C224", "H140", "35.00", "109.50"},
                                   {"C235", "C224", "N238", "63.00", "110.10"},
                                   {"C235", "C246", "H140", "35.00", "109.50"},
                                   {"C235", "C246", "N239", "63.00", "110.10"},
                                   {"C235", "C292", "H140", "35.00", "109.50"},
                                   {"C235", "C292", "N287", "80.00", "111.20"},
                                   {"C235", "C293", "C274", "63.00", "111.10"},
                                   {"C235", "C293", "C505", "63.00", "111.10"},
                                   {"C235", "C293", "H140", "35.00", "109.50"},
                                   {"C235", "C293", "N287", "80.00", "111.20"},
                                   {"C235", "C295", "H140", "35.00", "109.50"},
                                   {"C235", "C295", "N309", "80.00", "111.20"},
                                   {"C235", "N237", "H240", "35.00", "119.80"},
                                   {"C235", "N238", "C242", "50.00", "121.90"},
                                   {"C235", "N238", "C283", "50.00", "121.90"},
                                   {"C235", "N238", "C284", "50.00", "121.90"},
                                   {"C235", "N238", "H241", "35.00", "119.80"},
                                   {"C235", "N239", "C245", "50.00", "121.90"},
                                   {"C235", "N239", "C246", "50.00", "121.90"},
                                   {"C235", "N239", "C285", "50.00", "121.90"},
                                   {"C242", "N238", "H241", "38.00", "118.40"},
                                   {"C245", "C136", "H140", "37.50", "110.70"},
                                   {"C245", "N238", "C285", "50.00", "118.00"},
                                   {"C245", "N239", "C246", "50.00", "118.00"},
                                   {"C245", "N239", "C285", "50.00", "118.00"},
                                   {"C246", "C136", "H140", "37.50", "110.70"},
                                   {"C246", "C235", "N238", "70.00", "116.60"},
                                   {"C246", "C235", "N239", "70.00", "116.60"},
                                   {"C246", "C235", "O236", "80.00", "120.40"},
                                   {"C267", "C136", "C283", "63.00", "111.10"},
                                   {"C267", "C136", "C293", "63.00", "111.10"},
                                   {"C267", "C136", "H140", "35.00", "109.50"},
                                   {"C267", "C223", "H140", "35.00", "109.50"},
                                   {"C267", "C224", "H140", "35.00", "109.50"},
                                   {"C267", "C223", "N238", "63.00", "110.10"},
                                   {"C267", "C224", "N238", "63.00", "110.10"},
                                   {"C267", "O268", "H270", "35.00", "113.00"},
                                   {"C271", "C274", "C283", "63.00", "111.10"},
                                   {"C271", "C274", "C293", "63.00", "111.10"},
                                   {"C271", "C274", "H140", "35.00", "109.50"},
                                   {"C271", "C283", "C274", "63.00", "111.10"},
                                   {"C271", "C283", "C505", "63.00", "111.10"},
                                   {"C271", "C283", "H140", "35.00", "109.50"},
                                   {"C271", "C283", "N238", "63.00", "110.10"},
                                   {"C271", "C284", "H140", "35.00", "109.50"},
                                   {"C271", "C284", "N238", "63.00", "110.10"},
                                   {"C271", "C285", "H140", "35.00", "109.50"},
                                   {"C271", "C285", "N239", "63.00", "110.10"},
                                   {"C274", "C136", "C283", "58.35", "112.70"},
                                   {"C274", "C136", "C293", "58.35", "112.70"},
                                   {"C274", "C136", "H140", "37.50", "110.70"},
                                   {"C274", "C224", "H140", "37.50", "110.70"},
                                   {"C274", "C224", "N238", "80.00", "109.70"},
                                   {"C274", "C271", "O272", "70.00", "117.00"},
                                   {"C274", "C283", "H140", "37.50", "110.70"},
                                   {"C274", "C283", "N238", "80.00", "109.70"},
                                   {"C274", "C293", "H140", "37.50", "110.70"},
                                   {"C274", "C293", "N287", "80.00", "111.20"},
                                   {"C283", "C135", "H140", "37.50", "110.70"},
                                   {"C283", "C136", "C308", "58.35", "112.70"},
                                   {"C283", "C136", "C500", "63.00", "115.60"},
                                   {"C283", "C136", "H140", "37.50", "110.70"},
                                   {"C283", "C137", "H140", "37.50", "110.70"},
                                   {"C283", "C149", "H140", "37.50", "110.70"},
                                   {"C283", "C157", "H140", "37.50", "110.70"},
                                   {"C283", "C157", "O154", "50.00", "109.50"},
                                   {"C283", "C158", "H140", "37.50", "110.70"},
                                   {"C283", "C158", "O154", "50.00", "109.50"},
                                   {"C283", "C206", "H140", "37.50", "110.70"},
                                   {"C283", "C206", "S200", "50.00", "108.60"},
                                   {"C283", "C214", "H140", "37.50", "110.70"},
                                   {"C283", "C214", "S203", "50.00", "114.70"},
                                   {"C283", "C271", "O272", "70.00", "117.00"},
                                   {"C283", "C274", "H140", "37.50", "110.70"},
                                   {"C283", "C505", "C507", "63.00", "114.00"},
                                   {"C283", "C505", "C508", "63.00", "114.00"},
                                   {"C283", "C505", "C510", "63.00", "114.00"},
                                   {"C283", "C505", "H140", "37.50", "110.70"},
                                   {"C283", "N238", "H241", "38.00", "118.40"},
                                   {"C284", "C271", "O272", "70.00", "117.00"},
                                   {"C284", "N238", "H241", "38.00", "118.40"},
                                   {"C285", "C136", "H140", "37.50", "110.70"},
                                   {"C285", "C271", "O272", "70.00", "117.00"},
                                   {"C292", "C136", "H140", "37.50", "110.70"},
                                   {"C292", "C235", "N238", "70.00", "116.60"},
                                   {"C292", "C235", "N239", "70.00", "116.60"},
                                   {"C292", "C235", "O236", "80.00", "120.40"},
                                   {"C292", "N287", "H290", "35.00", "109.50"},
                                   {"C293", "C135", "H140", "37.50", "110.70"},
                                   {"C293", "C136", "C308", "58.35", "112.70"},
                                   {"C293", "C136", "C500", "63.00", "115.60"},
                                   {"C293", "C136", "H140", "37.50", "110.70"},
                                   {"C293", "C137", "H140", "37.50", "110.70"},
                                   {"C293", "C149", "H140", "37.50", "110.70"},
                                   {"C293", "C157", "H140", "37.50", "110.70"},
                                   {"C293", "C157", "O154", "50.00", "109.50"},
                                   {"C293", "C158", "H140", "37.50", "110.70"},
                                   {"C293", "C158", "O154", "50.00", "109.50"},
                                   {"C293", "C206", "H140", "37.50", "110.70"},
                                   {"C293", "C206", "S200", "50.00", "108.60"},
                                   {"C293", "C214", "H140", "37.50", "110.70"},
                                   {"C293", "C214", "S203", "50.00", "114.70"},
                                   {"C293", "C235", "N238", "70.00", "116.60"},
                                   {"C293", "C235", "N239", "70.00", "116.60"},
                                   {"C293", "C235", "O236", "80.00", "120.40"},
                                   {"C293", "C274", "H140", "37.50", "110.70"},
                                   {"C293", "C505", "C507", "63.00", "114.00"},
                                   {"C293", "C505", "C508", "63.00", "114.00"},
                                   {"C293", "C505", "C510", "63.00", "114.00"},
                                   {"C293", "C505", "H140", "37.50", "110.70"},
                                   {"C293", "N287", "H290", "35.00", "109.50"},
                                   {"C295", "C136", "H140", "37.50", "110.70"},
                                   {"C295", "C235", "N238", "70.00", "116.60"},
                                   {"C295", "C235", "N239", "70.00", "116.60"},
                                   {"C295", "C235", "O236", "80.00", "120.40"},
                                   {"C295", "N309", "C296", "50.00", "113.00"},
                                   {"C295", "N309", "H310", "35.00", "109.50"},
                                   {"C296", "C136", "H140", "37.50", "110.70"},
                                   {"C296", "N309", "H310", "35.00", "109.50"},
                                   {"C302", "N300", "H301", "35.00", "120.00"},
                                   {"C302", "N303", "C307", "50.00", "123.20"},
                                   {"C302", "N303", "H304", "35.00", "120.00"},
                                   {"C307", "C308", "H140", "37.50", "110.70"},
                                   {"C307", "N303", "H304", "35.00", "118.40"},
                                   {"C308", "C136", "H140", "37.50", "110.70"},
                                   {"C308", "C307", "H140", "37.50", "110.70"},
                                   {"C308", "C307", "N303", "80.00", "111.20"},
                                   {"C500", "C136", "H140", "35.00", "109.50"},
                                   {"C500", "C501", "C502", "85.00", "108.80"},
                                   {"C500", "C514", "H146", "35.00", "120.00"},
                                   {"C500", "C514", "N503", "70.00", "108.70"},
                                   {"C501", "C145", "H146", "35.00", "120.00"},
                                   {"C501", "C500", "C514", "85.00", "106.40"},
                                   {"C501", "C502", "N503", "70.00", "104.40"},
                                   {"C502", "C145", "H146", "35.00", "120.00"},
                                   {"C502", "N503", "C514", "70.00", "111.60"},
                                   {"C502", "N503", "H504", "35.00", "123.10"},
                                   {"C505", "C224", "H140", "37.50", "110.70"},
                                   {"C505", "C224", "N238", "80.00", "109.70"},
                                   {"C505", "C283", "H140", "37.50", "110.70"},
                                   {"C505", "C283", "N238", "80.00", "109.70"},
                                   {"C505", "C293", "H140", "37.50", "110.70"},
                                   {"C505", "C293", "N287", "80.00", "111.20"},
                                   {"C505", "C507", "C508", "70.00", "130.70"},
                                   {"C505", "C507", "N511", "70.00", "124.50"},
                                   {"C505", "C508", "C507", "70.00", "130.70"},
                                   {"C505", "C508", "N503", "70.00", "121.60"},
                                   {"C505", "C510", "C510", "70.00", "130.70"},
                                   {"C505", "C510", "N512", "70.00", "121.60"},
                                   {"C506", "N503", "C508", "70.00", "109.80"},
                                   {"C506", "N503", "H504", "35.00", "124.00"},
                                   {"C506", "N511", "C507", "70.00", "110.00"},
                                   {"C507", "C505", "H140", "35.00", "109.50"},
                                   {"C507", "C508", "H146", "35.00", "130.70"},
                                   {"C507", "C508", "N503", "70.00", "106.30"},
                                   {"C508", "C505", "H140", "35.00", "109.50"},
                                   {"C508", "C507", "H146", "35.00", "128.20"},
                                   {"C508", "C507", "N511", "70.00", "111.00"},
                                   {"C508", "N503", "H504", "35.00", "124.00"},
                                   {"C509", "N512", "C510", "70.00", "109.80"},
                                   {"C509", "N512", "H513", "35.00", "124.00"},
                                   {"C510", "C505", "H140", "35.00", "109.50"},
                                   {"C510", "C510", "H146", "35.00", "130.70"},
                                   {"C510", "C510", "N512", "70.00", "106.30"},
                                   {"C510", "N512", "H513", "35.00", "124.00"},
                                   {"C514", "N503", "H504", "35.00", "124.00"},
                                   {"H140", "C157", "O154", "35.00", "109.50"},
                                   {"H140", "C158", "O154", "35.00", "109.50"},
                                   {"H140", "C206", "S200", "35.00", "109.50"},
                                   {"H140", "C209", "S202", "35.00", "109.50"},
                                   {"H140", "C210", "S202", "35.00", "109.50"},
                                   {"H140", "C214", "S203", "35.00", "109.50"},
                                   {"H140", "C223", "N238", "35.00", "109.50"},
                                   {"H140", "C224", "N238", "35.00", "109.50"},
                                   {"H140", "C242", "N238", "35.00", "109.50"},
                                   {"H140", "C245", "N239", "35.00", "109.50"},
                                   {"H140", "C246", "N239", "35.00", "109.50"},
                                   {"H140", "C283", "N238", "35.00", "109.50"},
                                   {"H140", "C284", "N238", "35.00", "109.50"},
                                   {"H140", "C285", "N239", "35.00", "109.50"},
                                   {"H140", "C292", "N287", "35.00", "109.50"},
                                   {"H140", "C293", "N287", "35.00", "109.50"},
                                   {"H140", "C295", "N309", "35.00", "109.50"},
                                   {"H140", "C296", "N309", "35.00", "109.50"},
                                   {"H140", "C307", "N303", "35.00", "109.50"},
                                   {"H146", "C506", "N503", "35.00", "120.00"},
                                   {"H146", "C506", "N511", "35.00", "120.00"},
                                   {"H146", "C507", "N511", "35.00", "120.00"},
                                   {"H146", "C508", "N503", "35.00", "121.60"},
                                   {"H146", "C509", "N512", "35.00", "120.00"},
                                   {"H146", "C510", "N512", "35.00", "120.00"},
                                   {"H146", "C514", "N503", "35.00", "121.60"},
                                   {"H240", "N237", "H240", "35.00", "120.00"},
                                   {"H301", "N300", "H301", "35.00", "120.00"},
                                   {"N237", "C235", "O236", "80.00", "122.90"},
                                   {"N238", "C235", "O236", "80.00", "122.90"},
                                   {"N239", "C235", "O236", "80.00", "122.90"},
                                   {"N300", "C302", "N300", "70.00", "120.00"},
                                   {"N300", "C302", "N303", "70.00", "120.00"},
                                   {"N503", "C506", "N511", "70.00", "120.00"},
                                   {"N512", "C509", "N512", "70.00", "120.00"},
                                   {"O268", "C267", "O269", "80.00", "121.00"},
                                   {"O272", "C271", "O272", "80.00", "126.00"}};

/*
 Dihedrals
*/
char * OPLSAAM_dihedrals[1446][7]= {{"X", "C145", "C145", "X", "3.6250", "2", "180.0"},
                                   {"X", "C145", "C166", "X", "3.6250", "2", "180.0"},
                                   {"X", "C145", "C501", "X", "3.5000", "2", "180.0"},
                                   {"X", "C145", "C502", "X", "3.6250", "2", "180.0"},
                                   {"X", "C302", "N300", "X", "1.9500", "2", "180.0"},
                                   {"X", "C500", "C501", "X", "1.6750", "2", "180.0"},
                                   {"X", "C500", "C514", "X", "6.5250", "2", "180.0"},
                                   {"X", "C501", "C502", "X", "3.0000", "2", "180.0"},
                                   {"X", "C502", "N503", "X", "1.5250", "2", "180.0"},
                                   {"X", "C506", "N503", "X", "2.3250", "2", "180.0"},
                                   {"X", "C506", "N511", "X", "5.0000", "2", "180.0"},
                                   {"X", "C507", "C508", "X", "5.3750", "2", "180.0"},
                                   {"X", "C507", "N511", "X", "2.4000", "2", "180.0"},
                                   {"X", "C509", "N512", "X", "2.3250", "2", "180.0"},
                                   {"X", "C510", "C510", "X", "5.3750", "2", "180.0"},
                                   {"X", "C514", "N503", "X", "1.5000", "2", "180.0"},
                                   {"C135", "C136", "C137", "C135", "0.6500", "1", "0.0"},
                                   {"C135", "C136", "C137", "C135", "-0.1000", "2", "180.0"},
                                   {"C135", "C136", "C137", "C135", "0.1000", "3", "0.0"},
                                   {"C135", "C136", "C137", "C224", "0.6500", "1", "0.0"},
                                   {"C135", "C136", "C137", "C224", "-0.1000", "2", "180.0"},
                                   {"C135", "C136", "C137", "C224", "0.1000", "3", "0.0"},
                                   {"C135", "C136", "C137", "C283", "0.6500", "1", "0.0"},
                                   {"C135", "C136", "C137", "C283", "-0.1000", "2", "180.0"},
                                   {"C135", "C136", "C137", "C283", "0.1000", "3", "0.0"},
                                   {"C135", "C136", "C137", "C293", "0.6500", "1", "0.0"},
                                   {"C135", "C136", "C137", "C293", "-0.1000", "2", "180.0"},
                                   {"C135", "C136", "C137", "C293", "0.1000", "3", "0.0"},
                                   {"C135", "C136", "C137", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C136", "C224", "0.6500", "1", "0.0"},
                                   {"C135", "C137", "C136", "C224", "-0.1000", "2", "180.0"},
                                   {"C135", "C137", "C136", "C224", "0.1000", "3", "0.0"},
                                   {"C135", "C137", "C136", "C283", "0.6500", "1", "0.0"},
                                   {"C135", "C137", "C136", "C283", "-0.1000", "2", "180.0"},
                                   {"C135", "C137", "C136", "C283", "0.1000", "3", "0.0"},
                                   {"C135", "C137", "C136", "C293", "0.6500", "1", "0.0"},
                                   {"C135", "C137", "C136", "C293", "-0.1000", "2", "180.0"},
                                   {"C135", "C137", "C136", "C293", "0.1000", "3", "0.0"},
                                   {"C135", "C137", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C224", "C235", "-0.7110", "1", "0.0"},
                                   {"C135", "C137", "C224", "C235", "0.5340", "2", "180.0"},
                                   {"C135", "C137", "C224", "C235", "0.0000", "3", "0.0"},
                                   {"C135", "C137", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C224", "N238", "1.4970", "1", "0.0"},
                                   {"C135", "C137", "C224", "N238", "0.1260", "2", "180.0"},
                                   {"C135", "C137", "C224", "N238", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C283", "C271", "-0.7110", "1", "0.0"},
                                   {"C135", "C137", "C283", "C271", "0.5340", "2", "180.0"},
                                   {"C135", "C137", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C135", "C137", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C283", "N238", "1.4970", "1", "0.0"},
                                   {"C135", "C137", "C283", "N238", "0.1260", "2", "180.0"},
                                   {"C135", "C137", "C283", "N238", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C293", "C235", "-0.7110", "1", "0.0"},
                                   {"C135", "C137", "C293", "C235", "0.5340", "2", "180.0"},
                                   {"C135", "C137", "C293", "C235", "0.0000", "3", "0.0"},
                                   {"C135", "C137", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C137", "C293", "N287", "1.4970", "1", "0.0"},
                                   {"C135", "C137", "C293", "N287", "0.1260", "2", "180.0"},
                                   {"C135", "C137", "C293", "N287", "0.1500", "3", "0.0"},
                                   {"C135", "C158", "C224", "C235", "-0.7110", "1", "0.0"},
                                   {"C135", "C158", "C224", "C235", "0.5340", "2", "180.0"},
                                   {"C135", "C158", "C224", "C235", "0.0000", "3", "0.0"},
                                   {"C135", "C158", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C158", "C224", "N238", "1.4970", "1", "0.0"},
                                   {"C135", "C158", "C224", "N238", "0.1260", "2", "180.0"},
                                   {"C135", "C158", "C224", "N238", "0.1500", "3", "0.0"},
                                   {"C135", "C158", "C283", "C271", "-0.7110", "1", "0.0"},
                                   {"C135", "C158", "C283", "C271", "0.5340", "2", "180.0"},
                                   {"C135", "C158", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C135", "C158", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C158", "C283", "N238", "1.4970", "1", "0.0"},
                                   {"C135", "C158", "C283", "N238", "0.1260", "2", "180.0"},
                                   {"C135", "C158", "C283", "N238", "0.1500", "3", "0.0"},
                                   {"C135", "C158", "C293", "C235", "-0.7110", "1", "0.0"},
                                   {"C135", "C158", "C293", "C235", "0.5340", "2", "180.0"},
                                   {"C135", "C158", "C293", "C235", "0.0000", "3", "0.0"},
                                   {"C135", "C158", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C135", "C158", "C293", "N287", "1.4970", "1", "0.0"},
                                   {"C135", "C158", "C293", "N287", "0.1260", "2", "180.0"},
                                   {"C135", "C158", "C293", "N287", "0.1500", "3", "0.0"},
                                   {"C135", "C158", "O154", "H155", "-0.1780", "1", "0.0"},
                                   {"C135", "C158", "O154", "H155", "-0.0870", "2", "180.0"},
                                   {"C135", "C158", "O154", "H155", "0.2460", "3", "0.0"},
                                   {"C135", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C135", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C135", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C135", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C135", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C135", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C135", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C135", "C224", "C267", "O268", "0.5000", "1", "0.0"},
                                   {"C135", "C224", "C267", "O268", "0.2730", "2", "180.0"},
                                   {"C135", "C224", "C267", "O268", "0.2250", "3", "0.0"},
                                   {"C135", "C224", "C267", "O269", "0.2730", "2", "180.0"},
                                   {"C135", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C135", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C135", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C135", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C135", "C235", "N238", "C223", "1.1500", "1", "0.0"},
                                   {"C135", "C235", "N238", "C223", "3.0445", "2", "180.0"},
                                   {"C135", "C235", "N238", "C224", "1.1500", "1", "0.0"},
                                   {"C135", "C235", "N238", "C224", "3.0445", "2", "180.0"},
                                   {"C135", "C235", "N238", "H241", "2.4500", "2", "180.0"},
                                   {"C135", "C235", "N239", "C245", "1.1500", "1", "0.0"},
                                   {"C135", "C235", "N239", "C245", "3.0445", "2", "180.0"},
                                   {"C135", "C235", "N239", "C246", "1.1500", "1", "0.0"},
                                   {"C135", "C235", "N239", "C246", "3.0445", "2", "180.0"},
                                   {"C135", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C135", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C135", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C135", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C135", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C135", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C135", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C135", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C135", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C135", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C135", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C135", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C135", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C136", "C136", "C136", "C224", "0.6500", "1", "0.0"},
                                   {"C136", "C136", "C136", "C224", "-0.1000", "2", "180.0"},
                                   {"C136", "C136", "C136", "C224", "0.1000", "3", "0.0"},
                                   {"C267", "C136", "C136", "C224", "0.6500", "1", "0.0"},
                                   {"C267", "C136", "C136", "C224", "-0.1000", "2", "180.0"},
                                   {"C267", "C136", "C136", "C224", "0.1000", "3", "0.0"},
                                   {"C136", "C136", "C136", "C283", "0.6500", "1", "0.0"},
                                   {"C136", "C136", "C136", "C283", "-0.1000", "2", "180.0"},
                                   {"C136", "C136", "C136", "C283", "0.1000", "3", "0.0"},
                                   {"C136", "C136", "C136", "C292", "0.6500", "1", "0.0"},
                                   {"C136", "C136", "C136", "C292", "-0.1000", "2", "180.0"},
                                   {"C136", "C136", "C136", "C292", "0.1000", "3", "0.0"},
                                   {"C136", "C136", "C136", "C293", "0.6500", "1", "0.0"},
                                   {"C136", "C136", "C136", "C293", "-0.1000", "2", "180.0"},
                                   {"C136", "C136", "C136", "C293", "0.1000", "3", "0.0"},
                                   {"C136", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C267", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C224", "C235", "-1.1790", "1", "0.0"},
                                   {"C136", "C136", "C224", "C235", "0.4555", "2", "180.0"},
                                   {"C136", "C136", "C224", "C235", "0.0000", "3", "0.0"},
                                   {"C136", "C136", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C224", "N238", "0.4420", "1", "0.0"},
                                   {"C136", "C136", "C224", "N238", "0.4485", "2", "180.0"},
                                   {"C136", "C136", "C224", "N238", "0.4400", "3", "0.0"},
                                   {"C136", "C136", "C235", "N237", "1.4220", "1", "0.0"},
                                   {"C136", "C136", "C235", "N237", "-0.1805", "2", "180.0"},
                                   {"C136", "C136", "C235", "N237", "-0.1625", "3", "0.0"},
                                   {"C136", "C136", "C235", "O236", "0.2030", "1", "0.0"},
                                   {"C136", "C136", "C235", "O236", "0.6520", "2", "180.0"},
                                   {"C136", "C136", "C235", "O236", "0.0695", "3", "0.0"},
                                   {"C136", "C136", "C245", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C245", "N239", "0.4225", "1", "0.0"},
                                   {"C136", "C136", "C245", "N239", "-0.4810", "2", "180.0"},
                                   {"C136", "C136", "C245", "N239", "0.3565", "3", "0.0"},
                                   {"C136", "C136", "C246", "C235", "-0.8755", "1", "0.0"},
                                   {"C136", "C136", "C246", "C235", "0.8030", "2", "180.0"},
                                   {"C136", "C136", "C246", "C235", "0.0000", "3", "0.0"},
                                   {"C136", "C136", "C246", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C246", "N239", "0.7860", "1", "0.0"},
                                   {"C136", "C136", "C246", "N239", "0.0795", "2", "180.0"},
                                   {"C136", "C136", "C246", "N239", "0.1000", "3", "0.0"},
                                   {"C136", "C136", "C267", "O268", "0.5000", "1", "0.0"},
                                   {"C136", "C136", "C267", "O268", "0.2730", "2", "180.0"},
                                   {"C136", "C136", "C267", "O268", "0.2250", "3", "0.0"},
                                   {"C136", "C136", "C267", "O269", "0.2730", "2", "180.0"},
                                   {"C136", "C136", "C283", "C271", "-1.1790", "1", "0.0"},
                                   {"C136", "C136", "C283", "C271", "0.4555", "2", "180.0"},
                                   {"C136", "C136", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C136", "C136", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C283", "N238", "0.4420", "1", "0.0"},
                                   {"C136", "C136", "C283", "N238", "0.4485", "2", "180.0"},
                                   {"C136", "C136", "C283", "N238", "0.4400", "3", "0.0"},
                                   {"C136", "C136", "C285", "C271", "-0.8755", "1", "0.0"},
                                   {"C136", "C136", "C285", "C271", "0.8030", "2", "180.0"},
                                   {"C136", "C136", "C285", "C271", "0.0000", "3", "0.0"},
                                   {"C136", "C136", "C285", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C285", "N239", "0.7860", "1", "0.0"},
                                   {"C136", "C136", "C285", "N239", "0.0795", "2", "180.0"},
                                   {"C136", "C136", "C285", "N239", "0.1000", "3", "0.0"},
                                   {"C136", "C136", "C292", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C292", "N287", "1.3660", "1", "0.0"},
                                   {"C136", "C136", "C292", "N287", "-0.1145", "2", "180.0"},
                                   {"C136", "C136", "C292", "N287", "0.2425", "3", "0.0"},
                                   {"C136", "C136", "C293", "C235", "-1.1790", "1", "0.0"},
                                   {"C136", "C136", "C293", "C235", "0.4555", "2", "180.0"},
                                   {"C136", "C136", "C293", "C235", "0.0000", "3", "0.0"},
                                   {"C136", "C136", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C293", "N287", "0.4420", "1", "0.0"},
                                   {"C136", "C136", "C293", "N287", "0.4485", "2", "180.0"},
                                   {"C136", "C136", "C293", "N287", "0.4400", "3", "0.0"},
                                   {"C136", "C136", "C295", "C235", "-0.8755", "1", "0.0"},
                                   {"C136", "C136", "C295", "C235", "0.8030", "2", "180.0"},
                                   {"C136", "C136", "C295", "C235", "0.0000", "3", "0.0"},
                                   {"C136", "C136", "C295", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C295", "N309", "1.3660", "1", "0.0"},
                                   {"C136", "C136", "C295", "N309", "-0.1145", "2", "180.0"},
                                   {"C136", "C136", "C295", "N309", "0.2425", "3", "0.0"},
                                   {"C136", "C136", "C296", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C136", "C296", "N309", "1.3660", "1", "0.0"},
                                   {"C136", "C136", "C296", "N309", "-0.1145", "2", "180.0"},
                                   {"C136", "C136", "C296", "N309", "0.2425", "3", "0.0"},
                                   {"C136", "C137", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C137", "C224", "C235", "-0.7110", "1", "0.0"},
                                   {"C136", "C137", "C224", "C235", "0.5340", "2", "180.0"},
                                   {"C136", "C137", "C224", "C235", "0.0000", "3", "0.0"},
                                   {"C136", "C137", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C137", "C224", "N238", "1.4970", "1", "0.0"},
                                   {"C136", "C137", "C224", "N238", "0.1260", "2", "180.0"},
                                   {"C136", "C137", "C224", "N238", "0.1500", "3", "0.0"},
                                   {"C136", "C137", "C283", "C271", "-0.7110", "1", "0.0"},
                                   {"C136", "C137", "C283", "C271", "0.5340", "2", "180.0"},
                                   {"C136", "C137", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C136", "C137", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C137", "C283", "N238", "1.4970", "1", "0.0"},
                                   {"C136", "C137", "C283", "N238", "0.1260", "2", "180.0"},
                                   {"C136", "C137", "C283", "N238", "0.1500", "3", "0.0"},
                                   {"C136", "C137", "C293", "C235", "-0.7110", "1", "0.0"},
                                   {"C136", "C137", "C293", "C235", "0.5340", "2", "180.0"},
                                   {"C136", "C137", "C293", "C235", "0.0000", "3", "0.0"},
                                   {"C136", "C137", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C137", "C293", "N287", "1.4970", "1", "0.0"},
                                   {"C136", "C137", "C293", "N287", "0.1260", "2", "180.0"},
                                   {"C136", "C137", "C293", "N287", "0.1500", "3", "0.0"},
                                   {"C136", "C210", "S202", "C209", "0.4625", "1", "0.0"},
                                   {"C136", "C210", "S202", "C209", "-0.2880", "2", "180.0"},
                                   {"C136", "C210", "S202", "C209", "0.3385", "3", "0.0"},
                                   {"C136", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C136", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C136", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C136", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C136", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C136", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C136", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C136", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C136", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C136", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C136", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C136", "C235", "N237", "H240", "2.4500", "2", "180.0"},
                                   {"C136", "C245", "N239", "C235", "-0.3410", "1", "0.0"},
                                   {"C136", "C245", "N239", "C235", "0.0650", "2", "180.0"},
                                   {"C136", "C245", "N239", "C235", "0.1690", "3", "0.0"},
                                   {"C136", "C245", "N239", "C246", "1.4295", "1", "0.0"},
                                   {"C136", "C245", "N239", "C246", "1.0290", "2", "180.0"},
                                   {"C136", "C245", "N239", "C246", "-5.6330", "3", "0.0"},
                                   {"C136", "C245", "N239", "C285", "1.4295", "1", "0.0"},
                                   {"C136", "C245", "N239", "C285", "1.0290", "2", "180.0"},
                                   {"C136", "C245", "N239", "C285", "-5.6330", "3", "0.0"},
                                   {"C136", "C246", "C235", "N238", "2.5145", "1", "0.0"},
                                   {"C136", "C246", "C235", "N238", "0.3595", "2", "180.0"},
                                   {"C136", "C246", "C235", "N238", "1.1200", "3", "0.0"},
                                   {"C136", "C246", "C235", "N239", "2.5145", "1", "0.0"},
                                   {"C136", "C246", "C235", "N239", "0.3595", "2", "180.0"},
                                   {"C136", "C246", "C235", "N239", "1.1200", "3", "0.0"},
                                   {"C136", "C246", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C136", "C246", "N239", "C235", "-0.3410", "1", "0.0"},
                                   {"C136", "C246", "N239", "C235", "0.0650", "2", "180.0"},
                                   {"C136", "C246", "N239", "C235", "0.1690", "3", "0.0"},
                                   {"C136", "C246", "N239", "C245", "2.3765", "1", "0.0"},
                                   {"C136", "C246", "N239", "C245", "-0.3670", "2", "180.0"},
                                   {"C136", "C267", "O268", "H270", "0.7500", "1", "0.0"},
                                   {"C136", "C267", "O268", "H270", "2.7500", "2", "180.0"},
                                   {"C136", "C274", "C271", "O272", "0.2730", "2", "180.0"},
                                   {"C136", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C136", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C136", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C136", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C136", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C136", "C285", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C136", "C285", "N239", "C235", "-0.3410", "1", "0.0"},
                                   {"C136", "C285", "N239", "C235", "0.0650", "2", "180.0"},
                                   {"C136", "C285", "N239", "C235", "0.1690", "3", "0.0"},
                                   {"C136", "C285", "N239", "C245", "2.3765", "1", "0.0"},
                                   {"C136", "C285", "N239", "C245", "-0.3670", "2", "180.0"},
                                   {"C136", "C292", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C136", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C136", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C136", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C136", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C136", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C136", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C136", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C136", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C136", "C295", "C235", "N238", "2.5145", "1", "0.0"},
                                   {"C136", "C295", "C235", "N238", "0.3595", "2", "180.0"},
                                   {"C136", "C295", "C235", "N238", "1.1200", "3", "0.0"},
                                   {"C136", "C295", "C235", "N239", "2.5145", "1", "0.0"},
                                   {"C136", "C295", "C235", "N239", "0.3595", "2", "180.0"},
                                   {"C136", "C295", "C235", "N239", "1.1200", "3", "0.0"},
                                   {"C136", "C295", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C136", "C295", "N309", "C296", "0.71895", "1", "0.0"},
                                   {"C136", "C295", "N309", "C296", "-0.0619", "2", "180.0"},
                                   {"C136", "C295", "N309", "C296", "0.13195", "3", "0.0"},
                                   {"C136", "C295", "N309", "H310", "0.1735", "3", "0.0"},
                                   {"C136", "C296", "N309", "C295", "0.71895", "1", "0.0"},
                                   {"C136", "C296", "N309", "C295", "-0.0619", "2", "180.0"},
                                   {"C136", "C296", "N309", "C295", "0.13195", "3", "0.0"},
                                   {"C136", "C296", "N309", "H310", "0.1735", "3", "0.0"},
                                   {"C136", "C308", "C307", "H140", "0.1500", "3", "0.0"},
                                   {"C136", "C308", "C307", "N303", "1.3660", "1", "0.0"},
                                   {"C136", "C308", "C307", "N303", "-0.1145", "2", "180.0"},
                                   {"C136", "C308", "C307", "N303", "0.2425", "3", "0.0"},
                                   {"C137", "C136", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C137", "C136", "C224", "C235", "-0.8755", "1", "0.0"},
                                   {"C137", "C136", "C224", "C235", "0.8030", "2", "180.0"},
                                   {"C137", "C136", "C224", "C235", "0.0000", "3", "0.0"},
                                   {"C137", "C136", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C137", "C136", "C224", "N238", "0.7860", "1", "0.0"},
                                   {"C137", "C136", "C224", "N238", "0.0795", "2", "180.0"},
                                   {"C137", "C136", "C224", "N238", "0.1000", "3", "0.0"},
                                   {"C137", "C136", "C283", "C271", "-0.8755", "1", "0.0"},
                                   {"C137", "C136", "C283", "C271", "0.8030", "2", "180.0"},
                                   {"C137", "C136", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C137", "C136", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C137", "C136", "C283", "N238", "0.7860", "1", "0.0"},
                                   {"C137", "C136", "C283", "N238", "0.0795", "2", "180.0"},
                                   {"C137", "C136", "C283", "N238", "0.1000", "3", "0.0"},
                                   {"C137", "C136", "C293", "C235", "-0.8755", "1", "0.0"},
                                   {"C137", "C136", "C293", "C235", "0.8030", "2", "180.0"},
                                   {"C137", "C136", "C293", "C235", "0.0000", "3", "0.0"},
                                   {"C137", "C136", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C137", "C136", "C293", "N287", "0.7860", "1", "0.0"},
                                   {"C137", "C136", "C293", "N287", "0.0795", "2", "180.0"},
                                   {"C137", "C136", "C293", "N287", "0.1000", "3", "0.0"},
                                   {"C137", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C137", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C137", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C137", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C137", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C137", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C137", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C137", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C137", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C137", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C137", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C137", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C137", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C137", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C137", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C137", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C137", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C137", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C137", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C137", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C137", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C137", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C137", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C137", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C145", "C145", "C149", "C224", "0.0000", "1", "0.0"},
                                   {"C145", "C145", "C149", "C283", "0.0000", "1", "0.0"},
                                   {"C145", "C145", "C149", "C293", "0.0000", "1", "0.0"},
                                   {"C145", "C145", "C149", "H140", "0.0000", "1", "0.0"},
                                   {"C145", "C149", "C224", "C235", "-0.7030", "1", "0.0"},
                                   {"C145", "C149", "C224", "C235", "0.8885", "2", "180.0"},
                                   {"C145", "C149", "C224", "C235", "0.0000", "3", "0.0"},
                                   {"C145", "C149", "C224", "H140", "0.2310", "3", "0.0"},
                                   {"C145", "C149", "C224", "N238", "0.8560", "1", "0.0"},
                                   {"C145", "C149", "C224", "N238", "0.3625", "2", "180.0"},
                                   {"C145", "C149", "C224", "N238", "0.1830", "3", "0.0"},
                                   {"C145", "C149", "C283", "C271", "-0.7030", "1", "0.0"},
                                   {"C145", "C149", "C283", "C271", "0.8885", "2", "180.0"},
                                   {"C145", "C149", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C145", "C149", "C283", "H140", "0.2310", "3", "0.0"},
                                   {"C145", "C149", "C283", "N238", "0.8560", "1", "0.0"},
                                   {"C145", "C149", "C283", "N238", "0.3625", "2", "180.0"},
                                   {"C145", "C149", "C283", "N238", "0.1830", "3", "0.0"},
                                   {"C145", "C149", "C293", "C235", "-0.7030", "1", "0.0"},
                                   {"C145", "C149", "C293", "C235", "0.8885", "2", "180.0"},
                                   {"C145", "C149", "C293", "C235", "0.0000", "3", "0.0"},
                                   {"C145", "C149", "C293", "H140", "0.2310", "3", "0.0"},
                                   {"C145", "C149", "C293", "N287", "0.8560", "1", "0.0"},
                                   {"C145", "C149", "C293", "N287", "0.3625", "2", "180.0"},
                                   {"C145", "C149", "C293", "N287", "0.1830", "3", "0.0"},
                                   {"C145", "C166", "C145", "H146", "3.6250", "2", "180.0"},
                                   {"C145", "C166", "O167", "H168", "0.8410", "2", "180.0"},
                                   {"C145", "C501", "C500", "C514", "1.6750", "2", "180.0"},
                                   {"C145", "C502", "C501", "C500", "3.0000", "2", "180.0"},
                                   {"C149", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C149", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C149", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C149", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C149", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C149", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C149", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C149", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C149", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C149", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C149", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C149", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C149", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C149", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C149", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C149", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C149", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C149", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C149", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C149", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C149", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C149", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C149", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C149", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C157", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C157", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C157", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C157", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C157", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C157", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C157", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C157", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C157", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C157", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C157", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C157", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C157", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C157", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C157", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C157", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C157", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C157", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C157", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C157", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C157", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C158", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C158", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C158", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C158", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C158", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C158", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C158", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C158", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C158", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C158", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C158", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C158", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C158", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C158", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C158", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C158", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C158", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C158", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C158", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C158", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C158", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C158", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C158", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C158", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C206", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C206", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C206", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C206", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C206", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C206", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C206", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C206", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C206", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C206", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C206", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C206", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C206", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C206", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C206", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C206", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C206", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C206", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C206", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C206", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C206", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C206", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C206", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C206", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C209", "S202", "C210", "H140", "0.3235", "3", "0.0"},
                                   {"C210", "C136", "C224", "C235", "-0.4555", "1", "0.0"},
                                   {"C210", "C136", "C224", "C235", "0.3495", "2", "180.0"},
                                   {"C210", "C136", "C224", "C235", "0.0000", "3", "0.0"},
                                   {"C210", "C136", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C210", "C136", "C224", "N238", "0.1070", "1", "0.0"},
                                   {"C210", "C136", "C224", "N238", "0.2705", "2", "180.0"},
                                   {"C210", "C136", "C224", "N238", "0.1960", "3", "0.0"},
                                   {"C210", "C136", "C283", "C271", "-0.4555", "1", "0.0"},
                                   {"C210", "C136", "C283", "C271", "0.3495", "2", "180.0"},
                                   {"C210", "C136", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C210", "C136", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C210", "C136", "C283", "N238", "0.1070", "1", "0.0"},
                                   {"C210", "C136", "C283", "N238", "0.2705", "2", "180.0"},
                                   {"C210", "C136", "C283", "N238", "0.1960", "3", "0.0"},
                                   {"C210", "C136", "C293", "C235", "-0.4555", "1", "0.0"},
                                   {"C210", "C136", "C293", "C235", "0.3495", "2", "180.0"},
                                   {"C210", "C136", "C293", "C235", "0.0000", "3", "0.0"},
                                   {"C210", "C136", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C210", "C136", "C293", "N287", "0.1070", "1", "0.0"},
                                   {"C210", "C136", "C293", "N287", "0.2705", "2", "180.0"},
                                   {"C210", "C136", "C293", "N287", "0.1960", "3", "0.0"},
                                   {"C210", "S202", "C209", "H140", "0.3235", "3", "0.0"},
                                   {"C214", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C214", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C214", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C214", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C214", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C214", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C214", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C214", "C224", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C214", "C224", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C214", "C224", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C214", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C214", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C214", "C283", "N238", "C235", "-0.3410", "1", "0.0"},
                                   {"C214", "C283", "N238", "C235", "0.0650", "2", "180.0"},
                                   {"C214", "C283", "N238", "C235", "0.1690", "3", "0.0"},
                                   {"C214", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C214", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C214", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C214", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C214", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C214", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C214", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C214", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C214", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C214", "S203", "S203", "C214", "-3.7070", "2", "180.0"},
                                   {"C214", "S203", "S203", "C214", "0.8525", "3", "0.0"},
                                   {"C223", "C235", "N238", "C223", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N238", "C223", "3.0445", "2", "180.0"},
                                   {"C223", "C235", "N238", "C224", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N238", "C224", "3.0445", "2", "180.0"},
                                   {"C223", "C235", "N238", "C242", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N238", "C242", "3.0445", "2", "180.0"},
                                   {"C223", "C235", "N238", "C283", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N238", "C283", "3.0445", "2", "180.0"},
                                   {"C295", "C235", "N238", "C283", "1.1500", "1", "0.0"},
                                   {"C295", "C235", "N238", "C283", "3.0445", "2", "180.0"},
                                   {"C223", "C235", "N238", "C284", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N238", "C284", "3.0445", "2", "180.0"},
                                   {"C223", "C235", "N238", "H241", "2.4500", "2", "180.0"},
                                   {"C223", "C235", "N239", "C245", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N239", "C245", "3.0445", "2", "180.0"},
                                   {"C223", "C235", "N239", "C246", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N239", "C246", "3.0445", "2", "180.0"},
                                   {"C223", "C235", "N239", "C285", "1.1500", "1", "0.0"},
                                   {"C223", "C235", "N239", "C285", "3.0445", "2", "180.0"},
                                   {"C223", "N238", "C235", "C224", "1.1500", "1", "0.0"},
                                   {"C223", "N238", "C235", "C224", "3.0445", "2", "180.0"},
                                   {"C223", "N238", "C235", "C246", "1.1500", "1", "0.0"},
                                   {"C223", "N238", "C235", "C246", "3.0445", "2", "180.0"},
                                   {"C223", "N238", "C235", "C292", "1.1500", "1", "0.0"},
                                   {"C223", "N238", "C235", "C292", "3.0445", "2", "180.0"},
                                   {"C223", "N238", "C235", "C293", "1.1500", "1", "0.0"},
                                   {"C223", "N238", "C235", "C293", "3.0445", "2", "180.0"},
                                   {"C223", "N238", "C235", "C295", "1.1500", "1", "0.0"},
                                   {"C223", "N238", "C235", "C295", "3.0445", "2", "180.0"},
                                   {"C223", "N238", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C224", "C136", "C136", "C235", "-0.6335", "1", "0.0"},
                                   {"C224", "C136", "C136", "C235", "0.2395", "2", "180.0"},
                                   {"C224", "C136", "C136", "C235", "-0.2430", "3", "0.0"},
                                   {"C224", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C136", "C137", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C136", "C210", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C136", "C210", "S202", "-0.7825", "1", "0.0"},
                                   {"C224", "C136", "C210", "S202", "-0.0045", "2", "180.0"},
                                   {"C224", "C136", "C210", "S202", "-0.2250", "3", "0.0"},
                                   {"C224", "C136", "C235", "N237", "0.7470", "1", "0.0"},
                                   {"C224", "C136", "C235", "N237", "-0.2555", "2", "180.0"},
                                   {"C224", "C136", "C235", "N237", "0.0625", "3", "0.0"},
                                   {"C224", "C136", "C235", "O236", "0.8280", "1", "0.0"},
                                   {"C224", "C136", "C235", "O236", "0.6520", "2", "180.0"},
                                   {"C224", "C136", "C235", "O236", "0.2195", "3", "0.0"},
                                   {"C224", "C136", "C267", "O268", "0.5000", "1", "0.0"},
                                   {"C224", "C136", "C267", "O268", "0.2730", "2", "180.0"},
                                   {"C224", "C136", "C267", "O268", "0.2250", "3", "0.0"},
                                   {"C224", "C136", "C267", "O269", "0.2730", "2", "180.0"},
                                   {"C224", "C136", "C274", "C271", "-0.4425", "1", "0.0"},
                                   {"C224", "C136", "C274", "C271", "0.5125", "2", "180.0"},
                                   {"C224", "C136", "C274", "C271", "-0.6465", "3", "0.0"},
                                   {"C224", "C136", "C274", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C136", "C308", "C307", "0.6500", "1", "0.0"},
                                   {"C224", "C136", "C308", "C307", "-0.1000", "2", "180.0"},
                                   {"C224", "C136", "C308", "C307", "0.1000", "3", "0.0"},
                                   {"C224", "C136", "C308", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C136", "C500", "C501", "0.0000", "1", "0.0"},
                                   {"C224", "C136", "C500", "C514", "-0.3570", "1", "0.0"},
                                   {"C224", "C137", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C137", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C157", "O154", "H155", "-0.1780", "1", "0.0"},
                                   {"C224", "C157", "O154", "H155", "-0.0870", "2", "180.0"},
                                   {"C224", "C157", "O154", "H155", "0.2460", "3", "0.0"},
                                   {"C224", "C158", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C224", "C158", "O154", "H155", "-0.1780", "1", "0.0"},
                                   {"C224", "C158", "O154", "H155", "-0.0870", "2", "180.0"},
                                   {"C224", "C158", "O154", "H155", "0.2460", "3", "0.0"},
                                   {"C224", "C206", "S200", "H204", "-0.3795", "1", "0.0"},
                                   {"C224", "C206", "S200", "H204", "-0.1410", "2", "180.0"},
                                   {"C224", "C206", "S200", "H204", "0.3400", "3", "0.0"},
                                   {"C224", "C214", "S203", "S203", "0.9705", "1", "0.0"},
                                   {"C224", "C214", "S203", "S203", "-0.4180", "2", "180.0"},
                                   {"C224", "C214", "S203", "S203", "0.4675", "3", "0.0"},
                                   {"C224", "C235", "N238", "C224", "1.1500", "1", "0.0"},
                                   {"C224", "C235", "N238", "C224", "3.0445", "2", "180.0"},
                                   {"C224", "C235", "N238", "C242", "1.1500", "1", "0.0"},
                                   {"C224", "C235", "N238", "C242", "3.0445", "2", "180.0"},
                                   {"C224", "C235", "N238", "C283", "1.1500", "1", "0.0"},
                                   {"C224", "C235", "N238", "C283", "3.0445", "2", "180.0"},
                                   {"C224", "C235", "N238", "C284", "1.1500", "1", "0.0"},
                                   {"C224", "C235", "N238", "C284", "3.0445", "2", "180.0"},
                                   {"C224", "C235", "N238", "H241", "2.4500", "2", "180.0"},
                                   {"C224", "C235", "N239", "C245", "1.1500", "1", "0.0"},
                                   {"C224", "C235", "N239", "C245", "3.0445", "2", "180.0"},
                                   {"C224", "C235", "N239", "C246", "1.1500", "1", "0.0"},
                                   {"C224", "C235", "N239", "C246", "3.0445", "2", "180.0"},
                                   {"C224", "C235", "N239", "C285", "1.1500", "1", "0.0"},
                                   {"C224", "C235", "N239", "C285", "3.0445", "2", "180.0"},
                                   {"C223", "C267", "O268", "H270", "0.7500", "1", "0.0"},
                                   {"C223", "C267", "O268", "H270", "2.7500", "2", "180.0"},
                                   {"C224", "C267", "O268", "H270", "0.7500", "1", "0.0"},
                                   {"C224", "C267", "O268", "H270", "2.7500", "2", "180.0"},
                                   {"C224", "C274", "C271", "O272", "1.2500", "1", "0.0"},
                                   {"C224", "C274", "C271", "O272", "0.5000", "2", "180.0"},
                                   {"C224", "C274", "C271", "O272", "0.6750", "3", "0.0"},
                                   {"C224", "C505", "C507", "C508", "0.0000", "1", "0.0"},
                                   {"C224", "C505", "C507", "N511", "-0.2800", "1", "0.0"},
                                   {"C224", "C505", "C507", "N511", "-0.3700", "2", "180.0"},
                                   {"C224", "C505", "C507", "N511", "0.1745", "3", "0.0"},
                                   {"C224", "C505", "C508", "C507", "0.0000", "1", "0.0"},
                                   {"C224", "C505", "C508", "N503", "-0.2800", "1", "0.0"},
                                   {"C224", "C505", "C508", "N503", "-0.3700", "2", "180.0"},
                                   {"C224", "C505", "C508", "N503", "0.1745", "3", "0.0"},
                                   {"C224", "C505", "C510", "C510", "0.0000", "1", "0.0"},
                                   {"C224", "C505", "C510", "N512", "-1.9950", "1", "0.0"},
                                   {"C224", "C505", "C510", "N512", "0.8400", "2", "180.0"},
                                   {"C224", "C505", "C510", "N512", "0.1450", "3", "0.0"},
                                   {"C224", "N238", "C235", "C246", "1.1500", "1", "0.0"},
                                   {"C224", "N238", "C235", "C246", "3.0445", "2", "180.0"},
                                   {"C224", "N238", "C235", "C292", "1.1500", "1", "0.0"},
                                   {"C224", "N238", "C235", "C292", "3.0445", "2", "180.0"},
                                   {"C224", "N238", "C235", "C293", "1.1500", "1", "0.0"},
                                   {"C224", "N238", "C235", "C293", "3.0445", "2", "180.0"},
                                   {"C224", "N238", "C235", "C295", "1.1500", "1", "0.0"},
                                   {"C224", "N238", "C235", "C295", "3.0445", "2", "180.0"},
                                   {"C224", "N238", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C235", "C136", "C136", "C283", "-0.6335", "1", "0.0"},
                                   {"C235", "C136", "C136", "C283", "0.2395", "2", "180.0"},
                                   {"C235", "C136", "C136", "C283", "-0.2430", "3", "0.0"},
                                   {"C235", "C136", "C136", "C293", "-0.6335", "1", "0.0"},
                                   {"C235", "C136", "C136", "C293", "0.2395", "2", "180.0"},
                                   {"C235", "C136", "C136", "C293", "-0.2430", "3", "0.0"},
                                   {"C235", "C136", "C136", "H140", "-0.0500", "3", "0.0"},
                                   {"C235", "C136", "C224", "C235", "0.2990", "1", "0.0"},
                                   {"C235", "C136", "C224", "C235", "0.7790", "2", "180.0"},
                                   {"C235", "C136", "C224", "C235", "0.1275", "3", "0.0"},
                                   {"C235", "C136", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C235", "C136", "C224", "N238", "-2.7505", "1", "0.0"},
                                   {"C235", "C136", "C224", "N238", "0.7635", "2", "180.0"},
                                   {"C235", "C136", "C224", "N238", "0.0000", "3", "0.0"},
                                   {"C235", "C136", "C283", "C271", "0.2990", "1", "0.0"},
                                   {"C235", "C136", "C283", "C271", "0.7790", "2", "180.0"},
                                   {"C235", "C136", "C283", "C271", "0.1275", "3", "0.0"},
                                   {"C235", "C136", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C235", "C136", "C283", "N238", "-2.7505", "1", "0.0"},
                                   {"C235", "C136", "C283", "N238", "0.7635", "2", "180.0"},
                                   {"C235", "C136", "C283", "N238", "0.0000", "3", "0.0"},
                                   {"C235", "C136", "C293", "C235", "0.2990", "1", "0.0"},
                                   {"C235", "C136", "C293", "C235", "0.7790", "2", "180.0"},
                                   {"C235", "C136", "C293", "C235", "0.1275", "3", "0.0"},
                                   {"C235", "C136", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C235", "C136", "C293", "N287", "-2.7505", "1", "0.0"},
                                   {"C235", "C136", "C293", "N287", "0.7635", "2", "180.0"},
                                   {"C235", "C136", "C293", "N287", "0.0000", "3", "0.0"},
                                   {"C235", "C223", "N238", "C235", "-1.2555", "1", "0.0"},
                                   {"C235", "C223", "N238", "C235", "0.1050", "2", "180.0"},
                                   {"C235", "C223", "N238", "C235", "-0.1000", "3", "0.0"},
                                   {"C235", "C223", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C235", "C224", "C135", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C136", "C267", "0.2990", "1", "0.0"},
                                   {"C235", "C224", "C136", "C267", "0.7790", "2", "180.0"},
                                   {"C235", "C224", "C136", "C267", "0.1275", "3", "0.0"},
                                   {"C235", "C224", "C136", "C274", "-0.8820", "1", "0.0"},
                                   {"C235", "C224", "C136", "C274", "0.3500", "2", "180.0"},
                                   {"C235", "C224", "C136", "C274", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C136", "C308", "-0.9855", "1", "0.0"},
                                   {"C235", "C224", "C136", "C308", "0.3850", "2", "180.0"},
                                   {"C235", "C224", "C136", "C308", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C136", "C500", "-0.2530", "1", "0.0"},
                                   {"C235", "C224", "C136", "C500", "0.4875", "2", "180.0"},
                                   {"C235", "C224", "C136", "C500", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C136", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C137", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C149", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C157", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C157", "O154", "-2.8965", "1", "0.0"},
                                   {"C235", "C224", "C157", "O154", "0.2025", "2", "180.0"},
                                   {"C235", "C224", "C157", "O154", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C158", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C158", "O154", "-2.8965", "1", "0.0"},
                                   {"C235", "C224", "C158", "O154", "0.2025", "2", "180.0"},
                                   {"C235", "C224", "C158", "O154", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C206", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C206", "S200", "-1.6615", "1", "0.0"},
                                   {"C235", "C224", "C206", "S200", "0.2645", "2", "180.0"},
                                   {"C235", "C224", "C206", "S200", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C214", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C214", "S203", "-1.6615", "1", "0.0"},
                                   {"C235", "C224", "C214", "S203", "0.2645", "2", "180.0"},
                                   {"C235", "C224", "C214", "S203", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C274", "C271", "0.7715", "1", "0.0"},
                                   {"C235", "C224", "C274", "C271", "0.3480", "2", "180.0"},
                                   {"C235", "C224", "C274", "C271", "0.0000", "3", "0.0"},
                                   {"C235", "C224", "C274", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "C505", "C507", "-0.6410", "1", "0.0"},
                                   {"C235", "C224", "C505", "C507", "0.8225", "2", "180.0"},
                                   {"C235", "C224", "C505", "C507", "-0.0085", "3", "0.0"},
                                   {"C235", "C224", "C505", "C508", "-0.6410", "1", "0.0"},
                                   {"C235", "C224", "C505", "C508", "0.8225", "2", "180.0"},
                                   {"C235", "C224", "C505", "C508", "-0.0085", "3", "0.0"},
                                   {"C235", "C224", "C505", "C510", "-0.8540", "1", "0.0"},
                                   {"C235", "C224", "C505", "C510", "0.7580", "2", "180.0"},
                                   {"C235", "C224", "C505", "C510", "-0.2510", "3", "0.0"},
                                   {"C235", "C224", "C505", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C224", "N238", "C235", "-1.2555", "1", "0.0"},
                                   {"C235", "C224", "N238", "C235", "0.1050", "2", "180.0"},
                                   {"C235", "C224", "N238", "C235", "-0.1000", "3", "0.0"},
                                   {"C235", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C235", "N238", "C223", "C267", "-1.2555", "1", "0.0"},
                                   {"C235", "N238", "C223", "C267", "0.1050", "2", "180.0"},
                                   {"C235", "N238", "C223", "C267", "-0.1000", "3", "0.0"},
                                   {"C235", "N238", "C224", "C267", "-1.2555", "1", "0.0"},
                                   {"C235", "N238", "C224", "C267", "0.1050", "2", "180.0"},
                                   {"C235", "N238", "C224", "C267", "-0.1000", "3", "0.0"},
                                   {"C235", "C246", "C136", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C246", "N239", "C235", "-1.2555", "1", "0.0"},
                                   {"C235", "C246", "N239", "C235", "0.1050", "2", "180.0"},
                                   {"C235", "C246", "N239", "C235", "-0.1000", "3", "0.0"},
                                   {"C235", "C246", "N239", "C245", "-0.8685", "1", "0.0"},
                                   {"C235", "C246", "N239", "C245", "0.6255", "2", "180.0"},
                                   {"C235", "C246", "N239", "C245", "-1.7505", "3", "0.0"},
                                   {"C235", "C292", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C235", "C293", "C135", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C136", "C274", "-0.8820", "1", "0.0"},
                                   {"C235", "C293", "C136", "C274", "0.3500", "2", "180.0"},
                                   {"C235", "C293", "C136", "C274", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C136", "C308", "-0.9855", "1", "0.0"},
                                   {"C235", "C293", "C136", "C308", "0.3850", "2", "180.0"},
                                   {"C235", "C293", "C136", "C308", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C136", "C500", "-0.2530", "1", "0.0"},
                                   {"C235", "C293", "C136", "C500", "0.4875", "2", "180.0"},
                                   {"C235", "C293", "C136", "C500", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C136", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C137", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C149", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C157", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C157", "O154", "-2.8965", "1", "0.0"},
                                   {"C235", "C293", "C157", "O154", "0.2025", "2", "180.0"},
                                   {"C235", "C293", "C157", "O154", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C158", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C158", "O154", "-2.8965", "1", "0.0"},
                                   {"C235", "C293", "C158", "O154", "0.2025", "2", "180.0"},
                                   {"C235", "C293", "C158", "O154", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C206", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C206", "S200", "-1.6615", "1", "0.0"},
                                   {"C235", "C293", "C206", "S200", "0.2645", "2", "180.0"},
                                   {"C235", "C293", "C206", "S200", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C214", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C214", "S203", "-1.6615", "1", "0.0"},
                                   {"C235", "C293", "C214", "S203", "0.2645", "2", "180.0"},
                                   {"C235", "C293", "C214", "S203", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C274", "C271", "0.7715", "1", "0.0"},
                                   {"C235", "C293", "C274", "C271", "0.3480", "2", "180.0"},
                                   {"C235", "C293", "C274", "C271", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C274", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "C505", "C507", "-0.6410", "1", "0.0"},
                                   {"C235", "C293", "C505", "C507", "0.8225", "2", "180.0"},
                                   {"C235", "C293", "C505", "C507", "-0.0085", "3", "0.0"},
                                   {"C235", "C293", "C505", "C508", "-0.6410", "1", "0.0"},
                                   {"C235", "C293", "C505", "C508", "0.8225", "2", "180.0"},
                                   {"C235", "C293", "C505", "C508", "-0.0085", "3", "0.0"},
                                   {"C235", "C293", "C505", "C510", "-0.8540", "1", "0.0"},
                                   {"C235", "C293", "C505", "C510", "0.7580", "2", "180.0"},
                                   {"C235", "C293", "C505", "C510", "-0.2510", "3", "0.0"},
                                   {"C235", "C293", "C505", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C235", "C295", "C136", "H140", "-0.0380", "3", "0.0"},
                                   {"C235", "C295", "N309", "C296", "0.71895", "1", "0.0"},
                                   {"C235", "C295", "N309", "C296", "-0.0619", "2", "180.0"},
                                   {"C235", "C295", "N309", "C296", "0.13195", "3", "0.0"},
                                   {"C235", "C295", "N309", "H310", "0.1735", "3", "0.0"},
                                   {"C235", "N238", "C223", "H140", "0.0000", "1", "0.0"},
                                   {"C235", "N238", "C224", "C274", "-0.3410", "1", "0.0"},
                                   {"C235", "N238", "C224", "C274", "0.0650", "2", "180.0"},
                                   {"C235", "N238", "C224", "C274", "0.1690", "3", "0.0"},
                                   {"C235", "N238", "C224", "C505", "-0.3410", "1", "0.0"},
                                   {"C235", "N238", "C224", "C505", "0.0650", "2", "180.0"},
                                   {"C235", "N238", "C224", "C505", "0.1690", "3", "0.0"},
                                   {"C235", "N238", "C224", "H140", "0.0000", "1", "0.0"},
                                   {"C235", "N238", "C242", "H140", "0.0000", "1", "0.0"},
                                   {"C235", "N238", "C283", "C271", "-1.2555", "1", "0.0"},
                                   {"C235", "N238", "C283", "C271", "0.1050", "2", "180.0"},
                                   {"C235", "N238", "C283", "C271", "-0.1000", "3", "0.0"},
                                   {"C235", "N238", "C283", "C274", "-0.3410", "1", "0.0"},
                                   {"C235", "N238", "C283", "C274", "0.0650", "2", "180.0"},
                                   {"C235", "N238", "C283", "C274", "0.1690", "3", "0.0"},
                                   {"C235", "N238", "C283", "C505", "-0.3410", "1", "0.0"},
                                   {"C235", "N238", "C283", "C505", "0.0650", "2", "180.0"},
                                   {"C235", "N238", "C283", "C505", "0.1690", "3", "0.0"},
                                   {"C235", "N238", "C283", "H140", "0.0000", "1", "0.0"},
                                   {"C235", "N238", "C284", "C271", "-1.2555", "1", "0.0"},
                                   {"C235", "N238", "C284", "C271", "0.1050", "2", "180.0"},
                                   {"C235", "N238", "C284", "C271", "-0.1000", "3", "0.0"},
                                   {"C235", "N238", "C284", "H140", "0.0000", "1", "0.0"},
                                   {"C235", "N239", "C245", "H140", "0.0000", "1", "0.0"},
                                   {"C235", "N239", "C246", "H140", "0.0000", "1", "0.0"},
                                   {"C235", "N239", "C285", "C271", "-1.2555", "1", "0.0"},
                                   {"C235", "N239", "C285", "C271", "0.1050", "2", "180.0"},
                                   {"C235", "N239", "C285", "C271", "-0.1000", "3", "0.0"},
                                   {"C235", "N239", "C285", "H140", "0.0000", "1", "0.0"},
                                   {"C242", "N238", "C235", "C246", "1.1500", "1", "0.0"},
                                   {"C242", "N238", "C235", "C246", "3.0445", "2", "180.0"},
                                   {"C242", "N238", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C245", "C136", "C136", "C246", "0.6500", "1", "0.0"},
                                   {"C245", "C136", "C136", "C246", "-0.1000", "2", "180.0"},
                                   {"C245", "C136", "C136", "C246", "0.1000", "3", "0.0"},
                                   {"C245", "C136", "C136", "C285", "0.6500", "1", "0.0"},
                                   {"C245", "C136", "C136", "C285", "-0.1000", "2", "180.0"},
                                   {"C245", "C136", "C136", "C285", "0.1000", "3", "0.0"},
                                   {"C245", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C245", "N239", "C235", "C246", "1.1500", "1", "0.0"},
                                   {"C245", "N239", "C235", "C246", "3.0445", "2", "180.0"},
                                   {"C245", "N239", "C235", "C292", "1.1500", "1", "0.0"},
                                   {"C245", "N239", "C235", "C292", "3.0445", "2", "180.0"},
                                   {"C245", "N239", "C235", "C293", "1.1500", "1", "0.0"},
                                   {"C245", "N239", "C235", "C293", "3.0445", "2", "180.0"},
                                   {"C245", "N239", "C235", "C295", "1.1500", "1", "0.0"},
                                   {"C245", "N239", "C235", "C295", "3.0445", "2", "180.0"},
                                   {"C245", "N239", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C245", "N239", "C246", "H140", "0.0000", "1", "0.0"},
                                   {"C245", "N239", "C285", "C271", "-0.8685", "1", "0.0"},
                                   {"C245", "N239", "C285", "C271", "0.6255", "2", "180.0"},
                                   {"C245", "N239", "C285", "C271", "-1.7505", "3", "0.0"},
                                   {"C245", "N239", "C285", "H140", "0.0000", "1", "0.0"},
                                   {"C246", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C246", "C235", "N238", "C283", "1.1500", "1", "0.0"},
                                   {"C246", "C235", "N238", "C283", "3.0445", "2", "180.0"},
                                   {"C246", "C235", "N238", "C284", "1.1500", "1", "0.0"},
                                   {"C246", "C235", "N238", "C284", "3.0445", "2", "180.0"},
                                   {"C246", "C235", "N238", "H241", "2.4500", "2", "180.0"},
                                   {"C246", "C235", "N239", "C246", "1.1500", "1", "0.0"},
                                   {"C246", "C235", "N239", "C246", "3.0445", "2", "180.0"},
                                   {"C246", "C235", "N239", "C285", "1.1500", "1", "0.0"},
                                   {"C246", "C235", "N239", "C285", "3.0445", "2", "180.0"},
                                   {"C246", "N239", "C235", "C292", "1.1500", "1", "0.0"},
                                   {"C246", "N239", "C235", "C292", "3.0445", "2", "180.0"},
                                   {"C246", "N239", "C235", "C293", "1.1500", "1", "0.0"},
                                   {"C246", "N239", "C235", "C293", "3.0445", "2", "180.0"},
                                   {"C246", "N239", "C235", "C295", "1.1500", "1", "0.0"},
                                   {"C246", "N239", "C235", "C295", "3.0445", "2", "180.0"},
                                   {"C246", "N239", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C246", "N239", "C245", "H140", "0.0000", "1", "0.0"},
                                   {"C267", "C136", "C224", "H140", "-0.0380", "3", "0.0"},
                                   {"C267", "C136", "C224", "N238", "-2.7505", "1", "0.0"},
                                   {"C267", "C136", "C224", "N238", "0.7635", "2", "180.0"},
                                   {"C267", "C136", "C224", "N238", "0.0000", "3", "0.0"},
                                   {"C267", "C224", "C135", "H140", "0.0370", "3", "0.0"},
                                   {"C267", "C223", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C267", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C271", "C274", "C136", "C283", "-0.4425", "1", "0.0"},
                                   {"C271", "C274", "C136", "C283", "0.5125", "2", "180.0"},
                                   {"C271", "C274", "C136", "C283", "-0.6465", "3", "0.0"},
                                   {"C271", "C274", "C136", "C293", "-0.4425", "1", "0.0"},
                                   {"C271", "C274", "C136", "C293", "0.5125", "2", "180.0"},
                                   {"C271", "C274", "C136", "C293", "-0.6465", "3", "0.0"},
                                   {"C271", "C274", "C136", "H140", "-0.1125", "3", "0.0"},
                                   {"C271", "C274", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C271", "C274", "C224", "N238", "-3.9450", "1", "0.0"},
                                   {"C271", "C274", "C224", "N238", "0.3310", "2", "180.0"},
                                   {"C271", "C274", "C224", "N238", "0.4985", "3", "0.0"},
                                   {"C271", "C274", "C283", "C271", "0.7715", "1", "0.0"},
                                   {"C271", "C274", "C283", "C271", "0.3480", "2", "180.0"},
                                   {"C271", "C274", "C283", "C271", "0.0000", "3", "0.0"},
                                   {"C271", "C274", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C271", "C274", "C283", "N238", "-3.9450", "1", "0.0"},
                                   {"C271", "C274", "C283", "N238", "0.3310", "2", "180.0"},
                                   {"C271", "C274", "C283", "N238", "0.4985", "3", "0.0"},
                                   {"C271", "C274", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C271", "C274", "C293", "N287", "-3.9450", "1", "0.0"},
                                   {"C271", "C274", "C293", "N287", "0.3310", "2", "180.0"},
                                   {"C271", "C274", "C293", "N287", "0.4985", "3", "0.0"},
                                   {"C271", "C283", "C135", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C136", "C274", "-0.8820", "1", "0.0"},
                                   {"C271", "C283", "C136", "C274", "0.3500", "2", "180.0"},
                                   {"C271", "C283", "C136", "C274", "0.0000", "3", "0.0"},
                                   {"C271", "C283", "C136", "C308", "-0.9855", "1", "0.0"},
                                   {"C271", "C283", "C136", "C308", "0.3850", "2", "180.0"},
                                   {"C271", "C283", "C136", "C308", "0.0000", "3", "0.0"},
                                   {"C271", "C283", "C136", "C500", "-0.2530", "1", "0.0"},
                                   {"C271", "C283", "C136", "C500", "0.4875", "2", "180.0"},
                                   {"C271", "C283", "C136", "C500", "0.0000", "3", "0.0"},
                                   {"C271", "C283", "C136", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C137", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C149", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C157", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C157", "O154", "-2.8965", "1", "0.0"},
                                   {"C271", "C283", "C157", "O154", "0.2025", "2", "180.0"},
                                   {"C271", "C283", "C157", "O154", "0.0000", "3", "0.0"},
                                   {"C271", "C283", "C158", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C158", "O154", "-2.8965", "1", "0.0"},
                                   {"C271", "C283", "C158", "O154", "0.2025", "2", "180.0"},
                                   {"C271", "C283", "C158", "O154", "0.0000", "3", "0.0"},
                                   {"C271", "C283", "C206", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C206", "S200", "-1.6615", "1", "0.0"},
                                   {"C271", "C283", "C206", "S200", "0.2645", "2", "180.0"},
                                   {"C271", "C283", "C206", "S200", "0.0000", "3", "0.0"},
                                   {"C271", "C283", "C214", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C214", "S203", "-1.6615", "1", "0.0"},
                                   {"C271", "C283", "C214", "S203", "0.2645", "2", "180.0"},
                                   {"C271", "C283", "C214", "S203", "0.0000", "3", "0.0"},
                                   {"C271", "C283", "C274", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "C505", "C507", "-0.6410", "1", "0.0"},
                                   {"C271", "C283", "C505", "C507", "0.8225", "2", "180.0"},
                                   {"C271", "C283", "C505", "C507", "-0.0085", "3", "0.0"},
                                   {"C271", "C283", "C505", "C508", "-0.6410", "1", "0.0"},
                                   {"C271", "C283", "C505", "C508", "0.8225", "2", "180.0"},
                                   {"C271", "C283", "C505", "C508", "-0.0085", "3", "0.0"},
                                   {"C271", "C283", "C505", "C510", "-0.8540", "1", "0.0"},
                                   {"C271", "C283", "C505", "C510", "0.7580", "2", "180.0"},
                                   {"C271", "C283", "C505", "C510", "-0.2510", "3", "0.0"},
                                   {"C271", "C283", "C505", "H140", "-0.0380", "3", "0.0"},
                                   {"C271", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C271", "C284", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C271", "C285", "C136", "H140", "-0.0380", "3", "0.0"},
                                   {"C274", "C136", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C274", "C136", "C224", "N238", "0.9935", "1", "0.0"},
                                   {"C274", "C136", "C224", "N238", "0.2285", "2", "180.0"},
                                   {"C274", "C136", "C224", "N238", "0.4100", "3", "0.0"},
                                   {"C274", "C136", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C274", "C136", "C283", "N238", "0.9935", "1", "0.0"},
                                   {"C274", "C136", "C283", "N238", "0.2285", "2", "180.0"},
                                   {"C274", "C136", "C283", "N238", "0.4100", "3", "0.0"},
                                   {"C274", "C136", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C274", "C136", "C293", "N287", "0.9935", "1", "0.0"},
                                   {"C274", "C136", "C293", "N287", "0.2285", "2", "180.0"},
                                   {"C274", "C136", "C293", "N287", "0.4100", "3", "0.0"},
                                   {"C274", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C274", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C274", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C274", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C274", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C274", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C274", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C274", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C274", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C274", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C274", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C274", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C274", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C274", "C293", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C274", "C293", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C274", "C293", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C274", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C274", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C283", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C136", "C137", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C136", "C210", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C136", "C210", "S202", "-0.7825", "1", "0.0"},
                                   {"C283", "C136", "C210", "S202", "-0.0045", "2", "180.0"},
                                   {"C283", "C136", "C210", "S202", "-0.2250", "3", "0.0"},
                                   {"C283", "C136", "C235", "N237", "0.7470", "1", "0.0"},
                                   {"C283", "C136", "C235", "N237", "-0.2555", "2", "180.0"},
                                   {"C283", "C136", "C235", "N237", "0.0625", "3", "0.0"},
                                   {"C283", "C136", "C235", "O236", "0.8280", "1", "0.0"},
                                   {"C283", "C136", "C235", "O236", "0.6520", "2", "180.0"},
                                   {"C283", "C136", "C235", "O236", "0.2195", "3", "0.0"},
                                   {"C283", "C136", "C267", "O268", "0.5000", "1", "0.0"},
                                   {"C283", "C136", "C267", "O268", "0.2730", "2", "180.0"},
                                   {"C283", "C136", "C267", "O268", "0.2250", "3", "0.0"},
                                   {"C283", "C136", "C267", "O269", "0.2730", "2", "180.0"},
                                   {"C283", "C136", "C274", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C136", "C308", "C307", "0.6500", "1", "0.0"},
                                   {"C283", "C136", "C308", "C307", "-0.1000", "2", "180.0"},
                                   {"C283", "C136", "C308", "C307", "0.1000", "3", "0.0"},
                                   {"C283", "C136", "C308", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C136", "C500", "C501", "0.0000", "1", "0.0"},
                                   {"C283", "C136", "C500", "C514", "-0.3570", "1", "0.0"},
                                   {"C283", "C137", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C137", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C157", "O154", "H155", "-0.1780", "1", "0.0"},
                                   {"C283", "C157", "O154", "H155", "-0.0870", "2", "180.0"},
                                   {"C283", "C157", "O154", "H155", "0.2460", "3", "0.0"},
                                   {"C283", "C158", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C283", "C158", "O154", "H155", "-0.1780", "1", "0.0"},
                                   {"C283", "C158", "O154", "H155", "-0.0870", "2", "180.0"},
                                   {"C283", "C158", "O154", "H155", "0.2460", "3", "0.0"},
                                   {"C283", "C206", "S200", "H204", "-0.3795", "1", "0.0"},
                                   {"C283", "C206", "S200", "H204", "-0.1410", "2", "180.0"},
                                   {"C283", "C206", "S200", "H204", "0.3400", "3", "0.0"},
                                   {"C283", "C214", "S203", "S203", "0.9705", "1", "0.0"},
                                   {"C283", "C214", "S203", "S203", "-0.4180", "2", "180.0"},
                                   {"C283", "C214", "S203", "S203", "0.4675", "3", "0.0"},
                                   {"C283", "C274", "C271", "O272", "1.2500", "1", "0.0"},
                                   {"C283", "C274", "C271", "O272", "0.5000", "2", "180.0"},
                                   {"C283", "C274", "C271", "O272", "0.6750", "3", "0.0"},
                                   {"C283", "C505", "C507", "C508", "0.0000", "1", "0.0"},
                                   {"C283", "C505", "C507", "N511", "-0.2800", "1", "0.0"},
                                   {"C283", "C505", "C507", "N511", "-0.3700", "2", "180.0"},
                                   {"C283", "C505", "C507", "N511", "0.1745", "3", "0.0"},
                                   {"C283", "C505", "C508", "C507", "0.0000", "1", "0.0"},
                                   {"C283", "C505", "C508", "N503", "-0.2800", "1", "0.0"},
                                   {"C283", "C505", "C508", "N503", "-0.3700", "2", "180.0"},
                                   {"C283", "C505", "C508", "N503", "0.1745", "3", "0.0"},
                                   {"C283", "C505", "C510", "C510", "0.0000", "1", "0.0"},
                                   {"C283", "C505", "C510", "N512", "-1.9950", "1", "0.0"},
                                   {"C283", "C505", "C510", "N512", "0.8400", "2", "180.0"},
                                   {"C283", "C505", "C510", "N512", "0.1450", "3", "0.0"},
                                   {"C283", "N238", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C284", "N238", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C285", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C285", "N239", "C235", "O236", "3.0445", "2", "180.0"},
                                   {"C285", "N239", "C245", "H140", "0.0000", "1", "0.0"},
                                   {"C292", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C292", "C235", "N238", "H241", "2.4500", "2", "180.0"},
                                   {"C293", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C136", "C137", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C136", "C210", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C136", "C210", "S202", "-0.7825", "1", "0.0"},
                                   {"C293", "C136", "C210", "S202", "-0.0045", "2", "180.0"},
                                   {"C293", "C136", "C210", "S202", "-0.2250", "3", "0.0"},
                                   {"C293", "C136", "C235", "N237", "0.7470", "1", "0.0"},
                                   {"C293", "C136", "C235", "N237", "-0.2555", "2", "180.0"},
                                   {"C293", "C136", "C235", "N237", "0.0625", "3", "0.0"},
                                   {"C293", "C136", "C235", "O236", "0.8280", "1", "0.0"},
                                   {"C293", "C136", "C235", "O236", "0.6520", "2", "180.0"},
                                   {"C293", "C136", "C235", "O236", "0.2195", "3", "0.0"},
                                   {"C293", "C136", "C267", "O268", "0.5000", "1", "0.0"},
                                   {"C293", "C136", "C267", "O268", "0.2730", "2", "180.0"},
                                   {"C293", "C136", "C267", "O268", "0.2250", "3", "0.0"},
                                   {"C293", "C136", "C267", "O269", "0.2730", "2", "180.0"},
                                   {"C293", "C136", "C274", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C136", "C308", "C307", "0.6500", "1", "0.0"},
                                   {"C293", "C136", "C308", "C307", "-0.1000", "2", "180.0"},
                                   {"C293", "C136", "C308", "C307", "0.1000", "3", "0.0"},
                                   {"C293", "C136", "C308", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C136", "C500", "C501", "0.0000", "1", "0.0"},
                                   {"C293", "C136", "C500", "C514", "-0.3570", "1", "0.0"},
                                   {"C293", "C137", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C137", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C157", "O154", "H155", "-0.1780", "1", "0.0"},
                                   {"C293", "C157", "O154", "H155", "-0.0870", "2", "180.0"},
                                   {"C293", "C157", "O154", "H155", "0.2460", "3", "0.0"},
                                   {"C293", "C158", "C135", "H140", "0.1500", "3", "0.0"},
                                   {"C293", "C158", "O154", "H155", "-0.1780", "1", "0.0"},
                                   {"C293", "C158", "O154", "H155", "-0.0870", "2", "180.0"},
                                   {"C293", "C158", "O154", "H155", "0.2460", "3", "0.0"},
                                   {"C293", "C206", "S200", "H204", "-0.3795", "1", "0.0"},
                                   {"C293", "C206", "S200", "H204", "-0.1410", "2", "180.0"},
                                   {"C293", "C206", "S200", "H204", "0.3400", "3", "0.0"},
                                   {"C293", "C214", "S203", "S203", "0.9705", "1", "0.0"},
                                   {"C293", "C214", "S203", "S203", "-0.4180", "2", "180.0"},
                                   {"C293", "C214", "S203", "S203", "0.4675", "3", "0.0"},
                                   {"C293", "C235", "N238", "H241", "2.4500", "2", "180.0"},
                                   {"C293", "C274", "C271", "O272", "1.2500", "1", "0.0"},
                                   {"C293", "C274", "C271", "O272", "0.5000", "2", "180.0"},
                                   {"C293", "C274", "C271", "O272", "0.6750", "3", "0.0"},
                                   {"C293", "C505", "C507", "C508", "0.0000", "1", "0.0"},
                                   {"C293", "C505", "C507", "N511", "-0.2800", "1", "0.0"},
                                   {"C293", "C505", "C507", "N511", "-0.3700", "2", "180.0"},
                                   {"C293", "C505", "C507", "N511", "0.1745", "3", "0.0"},
                                   {"C293", "C505", "C508", "C507", "0.0000", "1", "0.0"},
                                   {"C293", "C505", "C508", "N503", "-0.2800", "1", "0.0"},
                                   {"C293", "C505", "C508", "N503", "-0.3700", "2", "180.0"},
                                   {"C293", "C505", "C508", "N503", "0.1745", "3", "0.0"},
                                   {"C293", "C505", "C510", "C510", "0.0000", "1", "0.0"},
                                   {"C293", "C505", "C510", "N512", "-1.9950", "1", "0.0"},
                                   {"C293", "C505", "C510", "N512", "0.8400", "2", "180.0"},
                                   {"C293", "C505", "C510", "N512", "0.1450", "3", "0.0"},
                                   {"C295", "C136", "C136", "C296", "0.6500", "1", "0.0"},
                                   {"C295", "C136", "C136", "C296", "-0.1000", "2", "180.0"},
                                   {"C295", "C136", "C136", "C296", "0.1000", "3", "0.0"},
                                   {"C295", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C295", "C235", "N238", "H241", "2.4500", "2", "180.0"},
                                   {"C295", "N309", "C296", "H140", "0.15085", "3", "0.0"},
                                   {"C296", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C296", "N309", "C295", "H140", "0.15085", "3", "0.0"},
                                   {"C302", "N303", "C307", "C308", "0.9145", "1", "0.0"},
                                   {"C302", "N303", "C307", "C308", "0.1215", "2", "180.0"},
                                   {"C302", "N303", "C307", "C308", "-0.2490", "3", "0.0"},
                                   {"C302", "N303", "C307", "H140", "0.0885", "3", "0.0"},
                                   {"C307", "C308", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"C307", "N303", "C302", "N300", "3.9680", "2", "180.0"},
                                   {"C308", "C136", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"C308", "C136", "C224", "N238", "0.0515", "1", "0.0"},
                                   {"C308", "C136", "C224", "N238", "0.3265", "2", "180.0"},
                                   {"C308", "C136", "C224", "N238", "0.2815", "3", "0.0"},
                                   {"C308", "C136", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"C308", "C136", "C283", "N238", "0.0515", "1", "0.0"},
                                   {"C308", "C136", "C283", "N238", "0.3265", "2", "180.0"},
                                   {"C308", "C136", "C283", "N238", "0.2815", "3", "0.0"},
                                   {"C308", "C136", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"C308", "C136", "C293", "N287", "0.0515", "1", "0.0"},
                                   {"C308", "C136", "C293", "N287", "0.3265", "2", "180.0"},
                                   {"C308", "C136", "C293", "N287", "0.2815", "3", "0.0"},
                                   {"C308", "C307", "N303", "H304", "-0.0950", "1", "0.0"},
                                   {"C308", "C307", "N303", "H304", "-0.2085", "2", "180.0"},
                                   {"C308", "C307", "N303", "H304", "0.2090", "3", "0.0"},
                                   {"C500", "C136", "C224", "H140", "0.2310", "3", "0.0"},
                                   {"C500", "C136", "C224", "N238", "-0.2940", "1", "0.0"},
                                   {"C500", "C136", "C224", "N238", "0.5100", "2", "180.0"},
                                   {"C500", "C136", "C224", "N238", "0.3325", "3", "0.0"},
                                   {"C500", "C136", "C283", "H140", "0.2310", "3", "0.0"},
                                   {"C500", "C136", "C283", "N238", "-0.2940", "1", "0.0"},
                                   {"C500", "C136", "C283", "N238", "0.5100", "2", "180.0"},
                                   {"C500", "C136", "C283", "N238", "0.3325", "3", "0.0"},
                                   {"C500", "C136", "C293", "H140", "0.2310", "3", "0.0"},
                                   {"C500", "C136", "C293", "N287", "-0.2940", "1", "0.0"},
                                   {"C500", "C136", "C293", "N287", "0.5100", "2", "180.0"},
                                   {"C500", "C136", "C293", "N287", "0.3325", "3", "0.0"},
                                   {"C500", "C501", "C145", "H146", "3.5000", "2", "180.0"},
                                   {"C501", "C500", "C136", "H140", "0.0000", "1", "0.0"},
                                   {"C501", "C502", "C145", "H146", "3.6250", "2", "180.0"},
                                   {"C502", "C501", "C145", "H146", "3.5000", "2", "180.0"},
                                   {"C502", "C501", "C500", "C514", "1.6750", "2", "180.0"},
                                   {"C502", "N503", "C514", "H146", "1.5000", "2", "180.0"},
                                   {"C505", "C224", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C505", "C224", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C505", "C224", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C505", "C224", "C235", "N239", "0.8895", "1", "0.0"},
                                   {"C505", "C224", "C235", "N239", "0.2095", "2", "180.0"},
                                   {"C505", "C224", "C235", "N239", "-0.0550", "3", "0.0"},
                                   {"C505", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C505", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C505", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"C505", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"C505", "C293", "C235", "N238", "0.8895", "1", "0.0"},
                                   {"C505", "C293", "C235", "N238", "0.2095", "2", "180.0"},
                                   {"C505", "C293", "C235", "N238", "-0.0550", "3", "0.0"},
                                   {"C505", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"C505", "C293", "N287", "H290", "0.1735", "3", "0.0"},
                                   {"C505", "C508", "C507", "H146", "5.3750", "2", "180.0"},
                                   {"C505", "C508", "C507", "N511", "5.3750", "2", "180.0"},
                                   {"C505", "C508", "N503", "C506", "1.4000", "2", "180.0"},
                                   {"C505", "C508", "N503", "H504", "1.4000", "2", "180.0"},
                                   {"C505", "C510", "N512", "C509", "1.4000", "2", "180.0"},
                                   {"C505", "C510", "N512", "H513", "1.4000", "2", "180.0"},
                                   {"C506", "N503", "C508", "C507", "1.4000", "2", "180.0"},
                                   {"C506", "N503", "C508", "H146", "2.5000", "2", "180.0"},
                                   {"C506", "N511", "C507", "C508", "2.4000", "2", "180.0"},
                                   {"C506", "N511", "C507", "H146", "2.4000", "2", "180.0"},
                                   {"C507", "C505", "C224", "H140", "0.2310", "3", "0.0"},
                                   {"C507", "C505", "C224", "N238", "-0.2710", "1", "0.0"},
                                   {"C507", "C505", "C224", "N238", "0.2175", "2", "180.0"},
                                   {"C507", "C505", "C224", "N238", "0.0000", "3", "0.0"},
                                   {"C507", "C505", "C283", "H140", "0.2310", "3", "0.0"},
                                   {"C507", "C505", "C283", "N238", "-0.2710", "1", "0.0"},
                                   {"C507", "C505", "C283", "N238", "0.2175", "2", "180.0"},
                                   {"C507", "C505", "C283", "N238", "0.0000", "3", "0.0"},
                                   {"C507", "C505", "C293", "H140", "0.2310", "3", "0.0"},
                                   {"C507", "C505", "C293", "N287", "-0.2710", "1", "0.0"},
                                   {"C507", "C505", "C293", "N287", "0.2175", "2", "180.0"},
                                   {"C507", "C505", "C293", "N287", "0.0000", "3", "0.0"},
                                   {"C507", "C508", "C505", "H140", "0.0000", "1", "0.0"},
                                   {"C507", "C508", "N503", "H504", "1.4000", "2", "180.0"},
                                   {"C507", "N511", "C506", "H146", "5.0000", "2", "180.0"},
                                   {"C507", "N511", "C506", "N503", "5.0000", "2", "180.0"},
                                   {"C508", "C505", "C224", "H140", "0.2310", "3", "0.0"},
                                   {"C508", "C505", "C224", "N238", "-0.2710", "1", "0.0"},
                                   {"C508", "C505", "C224", "N238", "0.2175", "2", "180.0"},
                                   {"C508", "C505", "C224", "N238", "0.0000", "3", "0.0"},
                                   {"C508", "C505", "C283", "H140", "0.2310", "3", "0.0"},
                                   {"C508", "C505", "C283", "N238", "-0.2710", "1", "0.0"},
                                   {"C508", "C505", "C283", "N238", "0.2175", "2", "180.0"},
                                   {"C508", "C505", "C283", "N238", "0.0000", "3", "0.0"},
                                   {"C508", "C505", "C293", "H140", "0.2310", "3", "0.0"},
                                   {"C508", "C505", "C293", "N287", "-0.2710", "1", "0.0"},
                                   {"C508", "C505", "C293", "N287", "0.2175", "2", "180.0"},
                                   {"C508", "C505", "C293", "N287", "0.0000", "3", "0.0"},
                                   {"C508", "C507", "C505", "H140", "0.0000", "1", "0.0"},
                                   {"C508", "N503", "C506", "H146", "2.3250", "2", "180.0"},
                                   {"C508", "N503", "C506", "N511", "2.3250", "2", "180.0"},
                                   {"C509", "N512", "C510", "C510", "1.4000", "2", "180.0"},
                                   {"C509", "N512", "C510", "H146", "2.5000", "2", "180.0"},
                                   {"C510", "C505", "C224", "H140", "0.2310", "3", "0.0"},
                                   {"C510", "C505", "C224", "N238", "-1.5190", "1", "0.0"},
                                   {"C510", "C505", "C224", "N238", "0.2095", "2", "180.0"},
                                   {"C510", "C505", "C224", "N238", "0.0000", "3", "0.0"},
                                   {"C510", "C505", "C283", "H140", "0.2310", "3", "0.0"},
                                   {"C510", "C505", "C283", "N238", "-1.5190", "1", "0.0"},
                                   {"C510", "C505", "C283", "N238", "0.2095", "2", "180.0"},
                                   {"C510", "C505", "C283", "N238", "0.0000", "3", "0.0"},
                                   {"C510", "C505", "C293", "H140", "0.2310", "3", "0.0"},
                                   {"C510", "C505", "C293", "N287", "-1.5190", "1", "0.0"},
                                   {"C510", "C505", "C293", "N287", "0.2095", "2", "180.0"},
                                   {"C510", "C505", "C293", "N287", "0.0000", "3", "0.0"},
                                   {"C510", "C510", "C505", "H140", "0.0000", "1", "0.0"},
                                   {"C510", "C510", "N512", "H513", "1.4000", "2", "180.0"},
                                   {"C510", "N512", "C509", "H146", "2.3250", "2", "180.0"},
                                   {"C510", "N512", "C509", "N512", "2.3250", "2", "180.0"},
                                   {"C514", "C500", "C136", "H140", "-0.2400", "3", "0.0"},
                                   {"H140", "C135", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C135", "C137", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C135", "C158", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C135", "C158", "O154", "0.2340", "3", "0.0"},
                                   {"H140", "C135", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C135", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C135", "C235", "N238", "0.0000", "1", "0.0"},
                                   {"H140", "C135", "C235", "N239", "0.0000", "1", "0.0"},
                                   {"H140", "C135", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C135", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C135", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C135", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C135", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C136", "C136", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C137", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C210", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C210", "S202", "0.2260", "3", "0.0"},
                                   {"H140", "C136", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C136", "C235", "N237", "0.0000", "1", "0.0"},
                                   {"H140", "C136", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C136", "C245", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C245", "N239", "0.2320", "3", "0.0"},
                                   {"H140", "C136", "C246", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C246", "N239", "0.2320", "3", "0.0"},
                                   {"H140", "C136", "C267", "O268", "0.0000", "1", "0.0"},
                                   {"H140", "C136", "C267", "O269", "0.0000", "1", "0.0"},
                                   {"H140", "C136", "C274", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C136", "C285", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C285", "N239", "0.2320", "3", "0.0"},
                                   {"H140", "C136", "C292", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C292", "N287", "0.1920", "3", "0.0"},
                                   {"H140", "C136", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C136", "C295", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C295", "N309", "0.1920", "3", "0.0"},
                                   {"H140", "C136", "C296", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C136", "C296", "N309", "0.1920", "3", "0.0"},
                                   {"H140", "C136", "C308", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C137", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C137", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C137", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C137", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C137", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C137", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C149", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C149", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C149", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C149", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C149", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C149", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C157", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C157", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C157", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C157", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C157", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C157", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C157", "O154", "H155", "0.1762", "3", "0.0"},
                                   {"H140", "C158", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C158", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C158", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C158", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C158", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C158", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C158", "O154", "H155", "0.1762", "3", "0.0"},
                                   {"H140", "C206", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C206", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C206", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C206", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C206", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C206", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C206", "S200", "H204", "0.2400", "3", "0.0"},
                                   {"H140", "C214", "C224", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C214", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C214", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C214", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C214", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C214", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C214", "S203", "S203", "0.2790", "3", "0.0"},
                                   {"H140", "C223", "C235", "N238", "0.0000", "1", "0.0"},
                                   {"H140", "C223", "C235", "N239", "0.0000", "1", "0.0"},
                                   {"H140", "C223", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C223", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"H140", "C224", "C157", "O154", "0.2340", "3", "0.0"},
                                   {"H140", "C224", "C158", "O154", "0.2340", "3", "0.0"},
                                   {"H140", "C224", "C206", "S200", "0.2260", "3", "0.0"},
                                   {"H140", "C224", "C214", "S203", "0.2260", "3", "0.0"},
                                   {"H140", "C224", "C235", "N238", "0.0000", "1", "0.0"},
                                   {"H140", "C224", "C235", "N239", "0.0000", "1", "0.0"},
                                   {"H140", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C223", "C267", "O268", "0.0000", "1", "0.0"},
                                   {"H140", "C223", "C267", "O269", "0.0000", "1", "0.0"},
                                   {"H140", "C224", "C267", "O268", "0.0000", "1", "0.0"},
                                   {"H140", "C224", "C267", "O269", "0.0000", "1", "0.0"},
                                   {"H140", "C224", "C274", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C224", "C505", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C224", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"H140", "C242", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"H140", "C246", "C235", "N238", "0.0000", "1", "0.0"},
                                   {"H140", "C246", "C235", "N239", "0.0000", "1", "0.0"},
                                   {"H140", "C246", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C274", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C274", "C271", "O272", "0.0000", "1", "0.0"},
                                   {"H140", "C274", "C283", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C274", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C274", "C293", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C274", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C283", "C157", "O154", "0.2340", "3", "0.0"},
                                   {"H140", "C283", "C158", "O154", "0.2340", "3", "0.0"},
                                   {"H140", "C283", "C206", "S200", "0.2260", "3", "0.0"},
                                   {"H140", "C283", "C214", "S203", "0.2260", "3", "0.0"},
                                   {"H140", "C283", "C271", "O272", "0.0000", "1", "0.0"},
                                   {"H140", "C283", "C505", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C283", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"H140", "C284", "C271", "O272", "0.0000", "1", "0.0"},
                                   {"H140", "C284", "N238", "H241", "0.0000", "1", "0.0"},
                                   {"H140", "C285", "C271", "O272", "0.0000", "1", "0.0"},
                                   {"H140", "C292", "C235", "N238", "0.0000", "1", "0.0"},
                                   {"H140", "C292", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C292", "N287", "H290", "0.1305", "3", "0.0"},
                                   {"H140", "C293", "C157", "O154", "0.2340", "3", "0.0"},
                                   {"H140", "C293", "C158", "O154", "0.2340", "3", "0.0"},
                                   {"H140", "C293", "C206", "S200", "0.2260", "3", "0.0"},
                                   {"H140", "C293", "C214", "S203", "0.2260", "3", "0.0"},
                                   {"H140", "C293", "C235", "N238", "0.0000", "1", "0.0"},
                                   {"H140", "C293", "C235", "N239", "0.0000", "1", "0.0"},
                                   {"H140", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C293", "C505", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C293", "N287", "H290", "0.1305", "3", "0.0"},
                                   {"H140", "C295", "C235", "N238", "0.0000", "1", "0.0"},
                                   {"H140", "C295", "C235", "N239", "0.0000", "1", "0.0"},
                                   {"H140", "C295", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"H140", "C295", "N309", "H310", "0.1305", "3", "0.0"},
                                   {"H140", "C296", "N309", "H310", "0.1920", "3", "0.0"},
                                   {"H140", "C307", "C308", "H140", "0.1500", "3", "0.0"},
                                   {"H140", "C307", "N303", "H304", "0.0000", "1", "0.0"},
                                   {"H140", "C308", "C307", "N303", "-0.2910", "3", "0.0"},
                                   {"H140", "C505", "C224", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C505", "C283", "N238", "0.2320", "3", "0.0"},
                                   {"H140", "C505", "C293", "N287", "0.2320", "3", "0.0"},
                                   {"H140", "C505", "C507", "N511", "0.2095", "3", "0.0"},
                                   {"H140", "C505", "C508", "N503", "0.2095", "3", "0.0"},
                                   {"H140", "C505", "C510", "N512", "0.2095", "3", "0.0"},
                                   {"H146", "C508", "C507", "N511", "5.3750", "2", "180.0"},
                                   {"H146", "C508", "N503", "H504", "2.5000", "2", "180.0"},
                                   {"H146", "C510", "N512", "H513", "2.5000", "2", "180.0"},
                                   {"H240", "N237", "C235", "O236", "2.4500", "2", "180.0"},
                                   {"H241", "N238", "C235", "O236", "2.4500", "2", "180.0"},
                                   {"H270", "O268", "C267", "O269", "2.7500", "2", "180.0"},
                                   {"H301", "N300", "C302", "N300", "1.9500", "2", "180.0"},
                                   {"H301", "N300", "C302", "N303", "1.9500", "2", "180.0"},
                                   {"H304", "N303", "C302", "N300", "1.9500", "2", "180.0"},
                                   {"H504", "N503", "C506", "N511", "2.3250", "2", "180.0"},
                                   {"H513", "N512", "C509", "N512", "2.3250", "2", "180.0"},
                                   {"N238", "C223", "C235", "N238", "0.9050", "1", "0.0"},
                                   {"N238", "C223", "C235", "N238", "1.0775", "2", "180.0"},
                                   {"N238", "C223", "C235", "N238", "-0.2350", "3", "0.0"},
                                   {"N238", "C223", "C235", "N239", "0.9050", "1", "0.0"},
                                   {"N238", "C223", "C235", "N239", "1.0775", "2", "180.0"},
                                   {"N238", "C223", "C235", "N239", "-0.2350", "3", "0.0"},
                                   {"N238", "C223", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"N238", "C224", "C157", "O154", "3.1290", "1", "0.0"},
                                   {"N238", "C224", "C157", "O154", "-0.5185", "2", "180.0"},
                                   {"N238", "C224", "C157", "O154", "0.6835", "3", "0.0"},
                                   {"N238", "C224", "C158", "O154", "3.1290", "1", "0.0"},
                                   {"N238", "C224", "C158", "O154", "-0.5185", "2", "180.0"},
                                   {"N238", "C224", "C158", "O154", "0.6835", "3", "0.0"},
                                   {"N238", "C224", "C206", "S200", "1.0275", "1", "0.0"},
                                   {"N238", "C224", "C206", "S200", "0.2645", "2", "180.0"},
                                   {"N238", "C224", "C206", "S200", "0.2720", "3", "0.0"},
                                   {"N238", "C224", "C214", "S203", "1.0275", "1", "0.0"},
                                   {"N238", "C224", "C214", "S203", "0.2645", "2", "180.0"},
                                   {"N238", "C224", "C214", "S203", "0.2720", "3", "0.0"},
                                   {"N238", "C224", "C235", "N238", "0.9050", "1", "0.0"},
                                   {"N238", "C224", "C235", "N238", "1.0775", "2", "180.0"},
                                   {"N238", "C224", "C235", "N238", "-0.2350", "3", "0.0"},
                                   {"N238", "C224", "C235", "N239", "0.9050", "1", "0.0"},
                                   {"N238", "C224", "C235", "N239", "1.0775", "2", "180.0"},
                                   {"N238", "C224", "C235", "N239", "-0.2350", "3", "0.0"},
                                   {"N238", "C224", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"N238", "C223", "C267", "O268", "2.6300", "1", "0.0"},
                                   {"N238", "C223", "C267", "O268", "0.4100", "2", "180.0"},
                                   {"N238", "C223", "C267", "O268", "0.0000", "3", "0.0"},
                                   {"N238", "C224", "C267", "O268", "2.6300", "1", "0.0"},
                                   {"N238", "C224", "C267", "O268", "0.4100", "2", "180.0"},
                                   {"N238", "C224", "C267", "O268", "0.0000", "3", "0.0"},
                                   {"N238", "C223", "C267", "O269", "0.0000", "1", "0.0"},
                                   {"N238", "C224", "C267", "O269", "0.0000", "1", "0.0"},
                                   {"N238", "C235", "C246", "N239", "-0.4700", "1", "0.0"},
                                   {"N238", "C235", "C246", "N239", "1.3775", "2", "180.0"},
                                   {"N238", "C235", "C246", "N239", "-1.3350", "3", "0.0"},
                                   {"N238", "C235", "C292", "N287", "0.9050", "1", "0.0"},
                                   {"N238", "C235", "C292", "N287", "1.0775", "2", "180.0"},
                                   {"N238", "C235", "C292", "N287", "-0.2350", "3", "0.0"},
                                   {"N238", "C235", "C293", "N287", "0.9050", "1", "0.0"},
                                   {"N238", "C235", "C293", "N287", "1.0775", "2", "180.0"},
                                   {"N238", "C235", "C293", "N287", "-0.2350", "3", "0.0"},
                                   {"N238", "C235", "C295", "N309", "-0.4700", "1", "0.0"},
                                   {"N238", "C235", "C295", "N309", "1.3775", "2", "180.0"},
                                   {"N238", "C235", "C295", "N309", "-1.3350", "3", "0.0"},
                                   {"N238", "C283", "C157", "O154", "3.1290", "1", "0.0"},
                                   {"N238", "C283", "C157", "O154", "-0.5185", "2", "180.0"},
                                   {"N238", "C283", "C157", "O154", "0.6835", "3", "0.0"},
                                   {"N238", "C283", "C158", "O154", "3.1290", "1", "0.0"},
                                   {"N238", "C283", "C158", "O154", "-0.5185", "2", "180.0"},
                                   {"N238", "C283", "C158", "O154", "0.6835", "3", "0.0"},
                                   {"N238", "C283", "C206", "S200", "1.0275", "1", "0.0"},
                                   {"N238", "C283", "C206", "S200", "0.2645", "2", "180.0"},
                                   {"N238", "C283", "C206", "S200", "0.2720", "3", "0.0"},
                                   {"N238", "C283", "C214", "S203", "1.0275", "1", "0.0"},
                                   {"N238", "C283", "C214", "S203", "0.2645", "2", "180.0"},
                                   {"N238", "C283", "C214", "S203", "0.2720", "3", "0.0"},
                                   {"N238", "C283", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"N238", "C284", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"N239", "C235", "C246", "N239", "-0.4700", "1", "0.0"},
                                   {"N239", "C235", "C246", "N239", "1.3775", "2", "180.0"},
                                   {"N239", "C235", "C246", "N239", "-1.3350", "3", "0.0"},
                                   {"N239", "C235", "C293", "N287", "0.9050", "1", "0.0"},
                                   {"N239", "C235", "C293", "N287", "1.0775", "2", "180.0"},
                                   {"N239", "C235", "C293", "N287", "-0.2350", "3", "0.0"},
                                   {"N239", "C235", "C295", "N309", "-0.4700", "1", "0.0"},
                                   {"N239", "C235", "C295", "N309", "1.3775", "2", "180.0"},
                                   {"N239", "C235", "C295", "N309", "-1.3350", "3", "0.0"},
                                   {"N239", "C246", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"N239", "C285", "C271", "O272", "0.4100", "2", "180.0"},
                                   {"N287", "C292", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"N287", "C293", "C157", "O154", "3.1290", "1", "0.0"},
                                   {"N287", "C293", "C157", "O154", "-0.5185", "2", "180.0"},
                                   {"N287", "C293", "C157", "O154", "0.6835", "3", "0.0"},
                                   {"N287", "C293", "C158", "O154", "3.1290", "1", "0.0"},
                                   {"N287", "C293", "C158", "O154", "-0.5185", "2", "180.0"},
                                   {"N287", "C293", "C158", "O154", "0.6835", "3", "0.0"},
                                   {"N287", "C293", "C206", "S200", "1.0275", "1", "0.0"},
                                   {"N287", "C293", "C206", "S200", "0.2645", "2", "180.0"},
                                   {"N287", "C293", "C206", "S200", "0.2720", "3", "0.0"},
                                   {"N287", "C293", "C214", "S203", "1.0275", "1", "0.0"},
                                   {"N287", "C293", "C214", "S203", "0.2645", "2", "180.0"},
                                   {"N287", "C293", "C214", "S203", "0.2720", "3", "0.0"},
                                   {"N287", "C293", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"N309", "C295", "C235", "O236", "0.0000", "1", "0.0"},
                                   {"N503", "C508", "C507", "N511", "5.3750", "2", "180.0"},
                                   {"C267", "C136", "C293", "N287", "-2.7505", "1", "0.0"},
                                   {"C267", "C136", "C293", "N287", "0.7635", "2", "180.0"},
                                   {"C267", "C136", "C293", "N287", "0.0000", "3", "0.0"},
                                   {"C235", "C293", "C136", "C267", "0.2990", "1", "0.0"},
                                   {"C235", "C293", "C136", "C267", "0.7790", "2", "180.0"},
                                   {"C235", "C293", "C136", "C267", "0.1275", "3", "0.0"},
                                   {"C267", "C136", "C283", "N238", "-2.7505", "1", "0.0"},
                                   {"C267", "C136", "C283", "N238", "0.7635", "2", "180.0"},
                                   {"C267", "C136", "C283", "N238", "0.0000", "3", "0.0"},
                                   {"C267", "C136", "C283", "C271", "0.2990", "1", "0.0"},
                                   {"C267", "C136", "C283", "C271", "0.7790", "2", "180.0"},
                                   {"C267", "C136", "C283", "C271", "0.1275", "3", "0.0"}};

/*
 Impropers
*/
char * OPLSAAM_impropers[105][7]= {{"C136", "C500", "C501", "C514", "1.1000", "2", "180.0"},
                                   {"C136", "C500", "C514", "C501", "1.1000", "2", "180.0"},
                                   {"C145", "C502", "C501", "N503", "1.1000", "2", "180.0"},
                                   {"C145", "C502", "N503", "C501", "1.1000", "2", "180.0"},
                                   {"C149", "C145", "C145", "C145", "1.1000", "2", "180.0"},
                                   {"C245", "N238", "C235", "C285", "2.5000", "2", "180.0"},
                                   {"C245", "N238", "C285", "C235", "2.5000", "2", "180.0"},
                                   {"C245", "N239", "C235", "C246", "2.5000", "2", "180.0"},
                                   {"C245", "N239", "C235", "C285", "2.5000", "2", "180.0"},
                                   {"C245", "N239", "C246", "C235", "2.5000", "2", "180.0"},
                                   {"C245", "N239", "C285", "C235", "2.5000", "2", "180.0"},
                                   {"C502", "C501", "C145", "C500", "1.1000", "2", "180.0"},
                                   {"C502", "C501", "C500", "C145", "1.1000", "2", "180.0"},
                                   {"C505", "C507", "C508", "N511", "1.1000", "2", "180.0"},
                                   {"C505", "C507", "N511", "C508", "1.1000", "2", "180.0"},
                                   {"C505", "C508", "C507", "N503", "1.1000", "2", "180.0"},
                                   {"C505", "C508", "N503", "C507", "1.1000", "2", "180.0"},
                                   {"C505", "C510", "C510", "N512", "1.1000", "2", "180.0"},
                                   {"C505", "C510", "N512", "C510", "1.1000", "2", "180.0"},
                                   {"H146", "C145", "C145", "C145", "1.1000", "2", "180.0"},
                                   {"H146", "C145", "C166", "C145", "1.1000", "2", "180.0"},
                                   {"H146", "C145", "C145", "C166", "1.1000", "2", "180.0"},
                                   {"H146", "C145", "C145", "C501", "1.1000", "2", "180.0"},
                                   {"H146", "C145", "C501", "C145", "1.1000", "2", "180.0"},
                                   {"H146", "C145", "C145", "C502", "1.1000", "2", "180.0"},
                                   {"H146", "C145", "C502", "C145", "1.1000", "2", "180.0"},
                                   {"H146", "C506", "N503", "N511", "1.1000", "2", "180.0"},
                                   {"H146", "C506", "N511", "N503", "1.1000", "2", "180.0"},
                                   {"H146", "C507", "C508", "N511", "1.1000", "2", "180.0"},
                                   {"H146", "C507", "N511", "C508", "1.1000", "2", "180.0"},
                                   {"H146", "C508", "C507", "N503", "1.1000", "2", "180.0"},
                                   {"H146", "C508", "N503", "C507", "1.1000", "2", "180.0"},
                                   {"H146", "C509", "N512", "N512", "1.1000", "2", "180.0"},
                                   {"H146", "C510", "C510", "N512", "1.1000", "2", "180.0"},
                                   {"H146", "C510", "N512", "C510", "1.1000", "2", "180.0"},
                                   {"H146", "C514", "C500", "N503", "1.1000", "2", "180.0"},
                                   {"H146", "C514", "N503", "C500", "1.1000", "2", "180.0"},
                                   {"H240", "N237", "C235", "H240", "2.5000", "2", "180.0"},
                                   {"H240", "N237", "H240", "C235", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C223", "C235", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C224", "C235", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C235", "C223", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C235", "C224", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C235", "C242", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C235", "C283", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C235", "C284", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C242", "C235", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C283", "C235", "2.5000", "2", "180.0"},
                                   {"H241", "N238", "C284", "C235", "2.5000", "2", "180.0"},
                                   {"H301", "N300", "C302", "H301", "2.5000", "2", "180.0"},
                                   {"H301", "N300", "H301", "C302", "2.5000", "2", "180.0"},
                                   {"H304", "N303", "C302", "C307", "2.5000", "2", "180.0"},
                                   {"H304", "N303", "C307", "C302", "2.5000", "2", "180.0"},
                                   {"H504", "N503", "C502", "C514", "2.5000", "2", "180.0"},
                                   {"H504", "N503", "C506", "C508", "2.5000", "2", "180.0"},
                                   {"H504", "N503", "C508", "C506", "2.5000", "2", "180.0"},
                                   {"H504", "N503", "C514", "C502", "2.5000", "2", "180.0"},
                                   {"H513", "N512", "C509", "C510", "2.5000", "2", "180.0"},
                                   {"H513", "N512", "C510", "C509", "2.5000", "2", "180.0"},
                                   {"N300", "C302", "N300", "N303", "10.5000", "2", "180.0"},
                                   {"N300", "C302", "N303", "N300", "10.5000", "2", "180.0"},
                                   {"O167", "C166", "C145", "C145", "1.1000", "2", "180.0"},
                                   {"O236", "C235", "C135", "N239", "10.5", "2", "180.0"},
                                   {"O236", "C235", "C135", "N238", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C136", "N237", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C223", "N238", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C223", "N239", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C224", "N238", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C224", "N239", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C246", "N238", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C246", "N239", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C292", "N238", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C293", "N238", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C293", "N239", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C295", "N238", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "C295", "N239", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N237", "C136", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N238", "C135", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N238", "C223", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N238", "C224", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N238", "C246", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N238", "C292", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N238", "C293", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N238", "C295", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N239", "C135", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N239", "C223", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N239", "C224", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N239", "C246", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N239", "C293", "10.5000", "2", "180.0"},
                                   {"O236", "C235", "N239", "C295", "10.5000", "2", "180.0"},
                                   {"O269", "C267", "C136", "O268", "10.5000", "2", "180.0"},
                                   {"O269", "C267", "O268", "C136", "10.5000", "2", "180.0"},
                                   {"O269", "C267", "C224", "O268", "10.5000", "2", "180.0"},
                                   {"O269", "C267", "O268", "C224", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "C274", "O272", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "C283", "O272", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "C284", "O272", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "C285", "O272", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "O272", "C274", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "O272", "C283", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "O272", "C284", "10.5000", "2", "180.0"},
                                   {"O272", "C271", "O272", "C285", "10.5000", "2", "180.0"},
                                   {"O268", "C267", "C136", "O269", "10.5", "2", "180.0"},
                                   {"O268", "C267", "C223", "O269", "10.5", "2", "180.0"},
                                   {"O268", "C267", "C224", "O269", "10.5", "2", "180.0"}};

/*
 Non-bonded
*/
char * OPLSAAM_vdw[78][7]= {{"C135", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C136", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C137", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C145", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C149", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C157", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C158", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C166", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C206", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C209", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C210", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C214", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C223", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C224", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C235", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"C242", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C245", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C246", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C267", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"C271", "0.00", "-0.105000", "2.1046163", "0.00", "-0.052500", "2.1046163"},
                                   {"C274", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C283", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C284", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C285", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C292", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C293", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C295", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C296", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C302", "0.00", "-0.050000", "1.2627698", "0.00", "-0.025000", "1.2627698"},
                                   {"C307", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C308", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C500", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C501", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C502", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C505", "0.00", "-0.066000", "1.9643086", "0.00", "-0.033000", "1.9643086"},
                                   {"C506", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C507", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C508", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C509", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C510", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"C514", "0.00", "-0.070000", "1.9923701", "0.00", "-0.035000", "1.9923701"},
                                   {"H140", "0.00", "-0.030000", "1.4030776", "0.00", "-0.015000", "1.4030776"},
                                   {"H146", "0.00", "-0.030000", "1.3581791", "0.00", "-0.015000", "1.3581791"},
                                   {"H155", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H168", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H204", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H240", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H241", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H270", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H290", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H301", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H304", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H310", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H504", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"H513", "0.00", "0.000000", "0.0000000", "0.00", "0.000000", "0.0000000"},
                                   {"N237", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N238", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N239", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N287", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N300", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N303", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N309", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N503", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N511", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"N512", "0.00", "-0.170000", "1.8240008", "0.00", "-0.085000", "1.8240008"},
                                   {"O154", "0.00", "-0.170000", "1.7510408", "0.00", "-0.085000", "1.7510408"},
                                   {"O167", "0.00", "-0.170000", "1.7229792", "0.00", "-0.085000", "1.7229792"},
                                   {"O236", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"O268", "0.00", "-0.170000", "1.6836931", "0.00", "-0.085000", "1.6836931"},
                                   {"O269", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"O272", "0.00", "-0.210000", "1.6612438", "0.00", "-0.105000", "1.6612438"},
                                   {"S200", "0.00", "-0.425000", "2.0204317", "0.00", "-0.212500", "2.0204317"},
                                   {"S202", "0.00", "-0.355000", "2.0204317", "0.00", "-0.177500", "2.0204317"},
                                   {"S203", "0.00", "-0.355000", "2.0204317", "0.00", "-0.177500", "2.0204317"},
                                   {"OT", "0.00", "-0.152100", "1.768200", "0.00", "-0.152100", "1.768200"},
                                   {"HT", "0.00", "-0.046000", "0.224500", "0.00", "-0.046000", "0.22450"},
                                   {"SOD", "0.00", "-0.000500", "2.9969737", "0.00", "-0.000500", "2.9969737"},
                                   {"CLA", "0.00", "-0.710000", "2.2561487", "0.00", "-0.710000", "2.2561487"}};
