CMAKE_MINIMUM_REQUIRED(VERSION 3.1.0)

###########################################
#### Usage: cmake -DCMD= -P cmake/cmd.cmake
###########################################

FUNCTION(MESSAGE type)
	IF(ARGV0 STREQUAL "STDOUT")
		EXECUTE_PROCESS(COMMAND ${CMAKE_COMMAND} -E echo "${ARGN}")
	ELSE()
		_MESSAGE(${type} "${ARGN}")
	ENDIF()
ENDFUNCTION()


FUNCTION(CREATE_HASH)
	IF(NOT FILES)
		MESSAGE(FATAL_ERROR "You need to specify 'FILES'")
	ENDIF()

	IF(NOT ALGORITHM)
		SET(ALGORITHM SHA256)
	ENDIF()
	STRING(TOLOWER "${ALGORITHM}" HASHFILE_ENDING)

	FILE(GLOB GLOBBED_FILES RELATIVE "${CMAKE_CURRENT_BINARY_DIR}" "${FILES}")

	FOREACH(f ${GLOBBED_FILES})
		FILE(${ALGORITHM} ${f} fHash)
		SET(OUTPUT "${fHash}  ${f}")
		MESSAGE(STDOUT ${OUTPUT})
		IF(CREATE_FILE)
			FILE(WRITE ${f}.${HASHFILE_ENDING} "${OUTPUT}\n")
		ENDIF()
	ENDFOREACH()
ENDFUNCTION()

FUNCTION(CHECK_WIX_WARNING)
	FILE(STRINGS "${FILE}" WIX_WARNINGS REGEX "warning")
	LIST(LENGTH WIX_WARNINGS WARNING_COUNT)
	IF(WARNING_COUNT GREATER 0)
		FOREACH(m ${WIX_WARNINGS})
			MESSAGE(STATUS "${m}\n")
		ENDFOREACH()
		MESSAGE(FATAL_ERROR "Found ${WARNING_COUNT} new WIX warnings")
	ELSE()
		MESSAGE(STATUS "No WIX warnings found")
	ENDIF()
ENDFUNCTION()







IF(NOT CMD)
	MESSAGE(FATAL_ERROR "You need to specify 'CMD'")
ENDIF()

IF(CMD STREQUAL "HASH")
	CREATE_HASH()
ELSEIF(CMD STREQUAL "CHECK_WIX_WARNING")
	CHECK_WIX_WARNING()
ELSE()
	MESSAGE(FATAL_ERROR "Unknown CMD: ${CMD}")
ENDIF()
