
#ifndef CTL_CODE
#define CTL_CODE(DeviceType,Function,Method,Access) (((DeviceType)<<16)|((Access)<<14)|((Function)<<2)|(Method))
#endif

#ifndef METHOD_BUFFERED
#define METHOD_BUFFERED                 0
#define METHOD_IN_DIRECT                1
#define METHOD_OUT_DIRECT               2
#define METHOD_NEITHER                  3
#endif

#ifndef FILE_ANY_ACCESS
#define FILE_ANY_ACCESS                 0
#define FILE_READ_ACCESS          (0x0001) 
#define FILE_WRITE_ACCESS         (0x0002)
#endif


#define FILE_DEVICE_EPPFLEX 0x80aa

struct eppflex_rwdata {
  unsigned char data;
  unsigned char mask;
};

#define IOCTL_EPPFLEX_READ_DATA         CTL_CODE(FILE_DEVICE_EPPFLEX,  0, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_DATA        CTL_CODE(FILE_DEVICE_EPPFLEX,  1, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_READ_STATUS       CTL_CODE(FILE_DEVICE_EPPFLEX,  2, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_STATUS      CTL_CODE(FILE_DEVICE_EPPFLEX,  3, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_READ_CONTROL      CTL_CODE(FILE_DEVICE_EPPFLEX,  4, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_CONTROL     CTL_CODE(FILE_DEVICE_EPPFLEX,  5, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_FROB_CONTROL      CTL_CODE(FILE_DEVICE_EPPFLEX,  6, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_READ_ECONTROL     CTL_CODE(FILE_DEVICE_EPPFLEX,  7, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_ECONTROL    CTL_CODE(FILE_DEVICE_EPPFLEX,  8, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_FROB_ECONTROL     CTL_CODE(FILE_DEVICE_EPPFLEX,  9, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_READ_CONFIGA      CTL_CODE(FILE_DEVICE_EPPFLEX, 10, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_CONFIGA     CTL_CODE(FILE_DEVICE_EPPFLEX, 11, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_READ_CONFIGB      CTL_CODE(FILE_DEVICE_EPPFLEX, 12, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_CONFIGB     CTL_CODE(FILE_DEVICE_EPPFLEX, 13, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_READ_EPPADDR      CTL_CODE(FILE_DEVICE_EPPFLEX, 14, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_EPPADDR     CTL_CODE(FILE_DEVICE_EPPFLEX, 15, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_READ_EPPDATA      CTL_CODE(FILE_DEVICE_EPPFLEX, 16, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_WRITE_EPPDATA     CTL_CODE(FILE_DEVICE_EPPFLEX, 17, METHOD_BUFFERED, FILE_ANY_ACCESS)

/* only W9x */
#define IOCTL_EPPFLEX_ACQUIREPORT       CTL_CODE(FILE_DEVICE_EPPFLEX, 64, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EPPFLEX_RELEASEPORT       CTL_CODE(FILE_DEVICE_EPPFLEX, 65, METHOD_BUFFERED, FILE_ANY_ACCESS)

