/**CFile****************************************************************

  FileName    [dau.c]

  SystemName  [ABC: Logic synthesis and verification system.]

  PackageName [DAG-aware unmapping.]

  Synopsis    [Counting ones in the truth table.]

  Author      [Alan Mishchenko]
  
  Affiliation [UC Berkeley]

  Date        [Ver. 1.0. Started - June 20, 2005.]

  Revision    [$Id: dau.c,v 1.00 2005/06/20 00:00:00 alanmi Exp $]

***********************************************************************/

#include "dauInt.h"

ABC_NAMESPACE_IMPL_START

////////////////////////////////////////////////////////////////////////
///                        DECLARATIONS                              ///
////////////////////////////////////////////////////////////////////////

static word Table[256][32] = //{{0}};
{
    { ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000), ABC_CONST(0x0000000000000000) },
    { ABC_CONST(0x0101010101010101), ABC_CONST(0x0101010100010101), ABC_CONST(0x0101010001010101), ABC_CONST(0x0101010000010101), ABC_CONST(0x0101000101010101), ABC_CONST(0x0101000100010101), ABC_CONST(0x0101000001010101), ABC_CONST(0x0101000000010101), ABC_CONST(0x0100010101010101), ABC_CONST(0x0100010100010101), ABC_CONST(0x0100010001010101), ABC_CONST(0x0100010000010101), ABC_CONST(0x0100000101010101), ABC_CONST(0x0100000100010101), ABC_CONST(0x0100000001010101), ABC_CONST(0x0100000000010101), ABC_CONST(0x0101010101010101), ABC_CONST(0x0101010100010101), ABC_CONST(0x0101010001010101), ABC_CONST(0x0101010000010101), ABC_CONST(0x0101000101010101), ABC_CONST(0x0101000100010101), ABC_CONST(0x0101000001010101), ABC_CONST(0x0101000000010101), ABC_CONST(0x0100010101010101), ABC_CONST(0x0100010100010101), ABC_CONST(0x0100010001010101), ABC_CONST(0x0100010000010101), ABC_CONST(0x0100000101010101), ABC_CONST(0x0100000100010101), ABC_CONST(0x0100000001010101), ABC_CONST(0x0100000000010101) },
    { ABC_CONST(0x0101010101010100), ABC_CONST(0x0101010100010100), ABC_CONST(0x0101010001010100), ABC_CONST(0x0101010000010100), ABC_CONST(0x0101000101010100), ABC_CONST(0x0101000100010100), ABC_CONST(0x0101000001010100), ABC_CONST(0x0101000000010100), ABC_CONST(0x0100010101010100), ABC_CONST(0x0100010100010100), ABC_CONST(0x0100010001010100), ABC_CONST(0x0100010000010100), ABC_CONST(0x0100000101010100), ABC_CONST(0x0100000100010100), ABC_CONST(0x0100000001010100), ABC_CONST(0x0100000000010100), ABC_CONST(0x0101010101010100), ABC_CONST(0x0101010100010100), ABC_CONST(0x0101010001010100), ABC_CONST(0x0101010000010100), ABC_CONST(0x0101000101010100), ABC_CONST(0x0101000100010100), ABC_CONST(0x0101000001010100), ABC_CONST(0x0101000000010100), ABC_CONST(0x0100010101010100), ABC_CONST(0x0100010100010100), ABC_CONST(0x0100010001010100), ABC_CONST(0x0100010000010100), ABC_CONST(0x0100000101010100), ABC_CONST(0x0100000100010100), ABC_CONST(0x0100000001010100), ABC_CONST(0x0100000000010100) },
    { ABC_CONST(0x0202020202020201), ABC_CONST(0x0202020200020201), ABC_CONST(0x0202020002020201), ABC_CONST(0x0202020000020201), ABC_CONST(0x0202000202020201), ABC_CONST(0x0202000200020201), ABC_CONST(0x0202000002020201), ABC_CONST(0x0202000000020201), ABC_CONST(0x0200020202020201), ABC_CONST(0x0200020200020201), ABC_CONST(0x0200020002020201), ABC_CONST(0x0200020000020201), ABC_CONST(0x0200000202020201), ABC_CONST(0x0200000200020201), ABC_CONST(0x0200000002020201), ABC_CONST(0x0200000000020201), ABC_CONST(0x0202020202020201), ABC_CONST(0x0202020200020201), ABC_CONST(0x0202020002020201), ABC_CONST(0x0202020000020201), ABC_CONST(0x0202000202020201), ABC_CONST(0x0202000200020201), ABC_CONST(0x0202000002020201), ABC_CONST(0x0202000000020201), ABC_CONST(0x0200020202020201), ABC_CONST(0x0200020200020201), ABC_CONST(0x0200020002020201), ABC_CONST(0x0200020000020201), ABC_CONST(0x0200000202020201), ABC_CONST(0x0200000200020201), ABC_CONST(0x0200000002020201), ABC_CONST(0x0200000000020201) },
    { ABC_CONST(0x0101010101010001), ABC_CONST(0x0101010100010001), ABC_CONST(0x0101010001010001), ABC_CONST(0x0101010000010001), ABC_CONST(0x0101000101010001), ABC_CONST(0x0101000100010001), ABC_CONST(0x0101000001010001), ABC_CONST(0x0101000000010001), ABC_CONST(0x0100010101010001), ABC_CONST(0x0100010100010001), ABC_CONST(0x0100010001010001), ABC_CONST(0x0100010000010001), ABC_CONST(0x0100000101010001), ABC_CONST(0x0100000100010001), ABC_CONST(0x0100000001010001), ABC_CONST(0x0100000000010001), ABC_CONST(0x0101010101010001), ABC_CONST(0x0101010100010001), ABC_CONST(0x0101010001010001), ABC_CONST(0x0101010000010001), ABC_CONST(0x0101000101010001), ABC_CONST(0x0101000100010001), ABC_CONST(0x0101000001010001), ABC_CONST(0x0101000000010001), ABC_CONST(0x0100010101010001), ABC_CONST(0x0100010100010001), ABC_CONST(0x0100010001010001), ABC_CONST(0x0100010000010001), ABC_CONST(0x0100000101010001), ABC_CONST(0x0100000100010001), ABC_CONST(0x0100000001010001), ABC_CONST(0x0100000000010001) },
    { ABC_CONST(0x0202020202020102), ABC_CONST(0x0202020200020102), ABC_CONST(0x0202020002020102), ABC_CONST(0x0202020000020102), ABC_CONST(0x0202000202020102), ABC_CONST(0x0202000200020102), ABC_CONST(0x0202000002020102), ABC_CONST(0x0202000000020102), ABC_CONST(0x0200020202020102), ABC_CONST(0x0200020200020102), ABC_CONST(0x0200020002020102), ABC_CONST(0x0200020000020102), ABC_CONST(0x0200000202020102), ABC_CONST(0x0200000200020102), ABC_CONST(0x0200000002020102), ABC_CONST(0x0200000000020102), ABC_CONST(0x0202020202020102), ABC_CONST(0x0202020200020102), ABC_CONST(0x0202020002020102), ABC_CONST(0x0202020000020102), ABC_CONST(0x0202000202020102), ABC_CONST(0x0202000200020102), ABC_CONST(0x0202000002020102), ABC_CONST(0x0202000000020102), ABC_CONST(0x0200020202020102), ABC_CONST(0x0200020200020102), ABC_CONST(0x0200020002020102), ABC_CONST(0x0200020000020102), ABC_CONST(0x0200000202020102), ABC_CONST(0x0200000200020102), ABC_CONST(0x0200000002020102), ABC_CONST(0x0200000000020102) },
    { ABC_CONST(0x0202020202020101), ABC_CONST(0x0202020200020101), ABC_CONST(0x0202020002020101), ABC_CONST(0x0202020000020101), ABC_CONST(0x0202000202020101), ABC_CONST(0x0202000200020101), ABC_CONST(0x0202000002020101), ABC_CONST(0x0202000000020101), ABC_CONST(0x0200020202020101), ABC_CONST(0x0200020200020101), ABC_CONST(0x0200020002020101), ABC_CONST(0x0200020000020101), ABC_CONST(0x0200000202020101), ABC_CONST(0x0200000200020101), ABC_CONST(0x0200000002020101), ABC_CONST(0x0200000000020101), ABC_CONST(0x0202020202020101), ABC_CONST(0x0202020200020101), ABC_CONST(0x0202020002020101), ABC_CONST(0x0202020000020101), ABC_CONST(0x0202000202020101), ABC_CONST(0x0202000200020101), ABC_CONST(0x0202000002020101), ABC_CONST(0x0202000000020101), ABC_CONST(0x0200020202020101), ABC_CONST(0x0200020200020101), ABC_CONST(0x0200020002020101), ABC_CONST(0x0200020000020101), ABC_CONST(0x0200000202020101), ABC_CONST(0x0200000200020101), ABC_CONST(0x0200000002020101), ABC_CONST(0x0200000000020101) },
    { ABC_CONST(0x0303030303030202), ABC_CONST(0x0303030300030202), ABC_CONST(0x0303030003030202), ABC_CONST(0x0303030000030202), ABC_CONST(0x0303000303030202), ABC_CONST(0x0303000300030202), ABC_CONST(0x0303000003030202), ABC_CONST(0x0303000000030202), ABC_CONST(0x0300030303030202), ABC_CONST(0x0300030300030202), ABC_CONST(0x0300030003030202), ABC_CONST(0x0300030000030202), ABC_CONST(0x0300000303030202), ABC_CONST(0x0300000300030202), ABC_CONST(0x0300000003030202), ABC_CONST(0x0300000000030202), ABC_CONST(0x0303030303030202), ABC_CONST(0x0303030300030202), ABC_CONST(0x0303030003030202), ABC_CONST(0x0303030000030202), ABC_CONST(0x0303000303030202), ABC_CONST(0x0303000300030202), ABC_CONST(0x0303000003030202), ABC_CONST(0x0303000000030202), ABC_CONST(0x0300030303030202), ABC_CONST(0x0300030300030202), ABC_CONST(0x0300030003030202), ABC_CONST(0x0300030000030202), ABC_CONST(0x0300000303030202), ABC_CONST(0x0300000300030202), ABC_CONST(0x0300000003030202), ABC_CONST(0x0300000000030202) },
    { ABC_CONST(0x0101010101010000), ABC_CONST(0x0101010100010000), ABC_CONST(0x0101010001010000), ABC_CONST(0x0101010000010000), ABC_CONST(0x0101000101010000), ABC_CONST(0x0101000100010000), ABC_CONST(0x0101000001010000), ABC_CONST(0x0101000000010000), ABC_CONST(0x0100010101010000), ABC_CONST(0x0100010100010000), ABC_CONST(0x0100010001010000), ABC_CONST(0x0100010000010000), ABC_CONST(0x0100000101010000), ABC_CONST(0x0100000100010000), ABC_CONST(0x0100000001010000), ABC_CONST(0x0100000000010000), ABC_CONST(0x0101010101010000), ABC_CONST(0x0101010100010000), ABC_CONST(0x0101010001010000), ABC_CONST(0x0101010000010000), ABC_CONST(0x0101000101010000), ABC_CONST(0x0101000100010000), ABC_CONST(0x0101000001010000), ABC_CONST(0x0101000000010000), ABC_CONST(0x0100010101010000), ABC_CONST(0x0100010100010000), ABC_CONST(0x0100010001010000), ABC_CONST(0x0100010000010000), ABC_CONST(0x0100000101010000), ABC_CONST(0x0100000100010000), ABC_CONST(0x0100000001010000), ABC_CONST(0x0100000000010000) },
    { ABC_CONST(0x0202020202020101), ABC_CONST(0x0202020200020101), ABC_CONST(0x0202020002020101), ABC_CONST(0x0202020000020101), ABC_CONST(0x0202000202020101), ABC_CONST(0x0202000200020101), ABC_CONST(0x0202000002020101), ABC_CONST(0x0202000000020101), ABC_CONST(0x0200020202020101), ABC_CONST(0x0200020200020101), ABC_CONST(0x0200020002020101), ABC_CONST(0x0200020000020101), ABC_CONST(0x0200000202020101), ABC_CONST(0x0200000200020101), ABC_CONST(0x0200000002020101), ABC_CONST(0x0200000000020101), ABC_CONST(0x0202020202020101), ABC_CONST(0x0202020200020101), ABC_CONST(0x0202020002020101), ABC_CONST(0x0202020000020101), ABC_CONST(0x0202000202020101), ABC_CONST(0x0202000200020101), ABC_CONST(0x0202000002020101), ABC_CONST(0x0202000000020101), ABC_CONST(0x0200020202020101), ABC_CONST(0x0200020200020101), ABC_CONST(0x0200020002020101), ABC_CONST(0x0200020000020101), ABC_CONST(0x0200000202020101), ABC_CONST(0x0200000200020101), ABC_CONST(0x0200000002020101), ABC_CONST(0x0200000000020101) },
    { ABC_CONST(0x0202020202020100), ABC_CONST(0x0202020200020100), ABC_CONST(0x0202020002020100), ABC_CONST(0x0202020000020100), ABC_CONST(0x0202000202020100), ABC_CONST(0x0202000200020100), ABC_CONST(0x0202000002020100), ABC_CONST(0x0202000000020100), ABC_CONST(0x0200020202020100), ABC_CONST(0x0200020200020100), ABC_CONST(0x0200020002020100), ABC_CONST(0x0200020000020100), ABC_CONST(0x0200000202020100), ABC_CONST(0x0200000200020100), ABC_CONST(0x0200000002020100), ABC_CONST(0x0200000000020100), ABC_CONST(0x0202020202020100), ABC_CONST(0x0202020200020100), ABC_CONST(0x0202020002020100), ABC_CONST(0x0202020000020100), ABC_CONST(0x0202000202020100), ABC_CONST(0x0202000200020100), ABC_CONST(0x0202000002020100), ABC_CONST(0x0202000000020100), ABC_CONST(0x0200020202020100), ABC_CONST(0x0200020200020100), ABC_CONST(0x0200020002020100), ABC_CONST(0x0200020000020100), ABC_CONST(0x0200000202020100), ABC_CONST(0x0200000200020100), ABC_CONST(0x0200000002020100), ABC_CONST(0x0200000000020100) },
    { ABC_CONST(0x0303030303030201), ABC_CONST(0x0303030300030201), ABC_CONST(0x0303030003030201), ABC_CONST(0x0303030000030201), ABC_CONST(0x0303000303030201), ABC_CONST(0x0303000300030201), ABC_CONST(0x0303000003030201), ABC_CONST(0x0303000000030201), ABC_CONST(0x0300030303030201), ABC_CONST(0x0300030300030201), ABC_CONST(0x0300030003030201), ABC_CONST(0x0300030000030201), ABC_CONST(0x0300000303030201), ABC_CONST(0x0300000300030201), ABC_CONST(0x0300000003030201), ABC_CONST(0x0300000000030201), ABC_CONST(0x0303030303030201), ABC_CONST(0x0303030300030201), ABC_CONST(0x0303030003030201), ABC_CONST(0x0303030000030201), ABC_CONST(0x0303000303030201), ABC_CONST(0x0303000300030201), ABC_CONST(0x0303000003030201), ABC_CONST(0x0303000000030201), ABC_CONST(0x0300030303030201), ABC_CONST(0x0300030300030201), ABC_CONST(0x0300030003030201), ABC_CONST(0x0300030000030201), ABC_CONST(0x0300000303030201), ABC_CONST(0x0300000300030201), ABC_CONST(0x0300000003030201), ABC_CONST(0x0300000000030201) },
    { ABC_CONST(0x0202020202020001), ABC_CONST(0x0202020200020001), ABC_CONST(0x0202020002020001), ABC_CONST(0x0202020000020001), ABC_CONST(0x0202000202020001), ABC_CONST(0x0202000200020001), ABC_CONST(0x0202000002020001), ABC_CONST(0x0202000000020001), ABC_CONST(0x0200020202020001), ABC_CONST(0x0200020200020001), ABC_CONST(0x0200020002020001), ABC_CONST(0x0200020000020001), ABC_CONST(0x0200000202020001), ABC_CONST(0x0200000200020001), ABC_CONST(0x0200000002020001), ABC_CONST(0x0200000000020001), ABC_CONST(0x0202020202020001), ABC_CONST(0x0202020200020001), ABC_CONST(0x0202020002020001), ABC_CONST(0x0202020000020001), ABC_CONST(0x0202000202020001), ABC_CONST(0x0202000200020001), ABC_CONST(0x0202000002020001), ABC_CONST(0x0202000000020001), ABC_CONST(0x0200020202020001), ABC_CONST(0x0200020200020001), ABC_CONST(0x0200020002020001), ABC_CONST(0x0200020000020001), ABC_CONST(0x0200000202020001), ABC_CONST(0x0200000200020001), ABC_CONST(0x0200000002020001), ABC_CONST(0x0200000000020001) },
    { ABC_CONST(0x0303030303030102), ABC_CONST(0x0303030300030102), ABC_CONST(0x0303030003030102), ABC_CONST(0x0303030000030102), ABC_CONST(0x0303000303030102), ABC_CONST(0x0303000300030102), ABC_CONST(0x0303000003030102), ABC_CONST(0x0303000000030102), ABC_CONST(0x0300030303030102), ABC_CONST(0x0300030300030102), ABC_CONST(0x0300030003030102), ABC_CONST(0x0300030000030102), ABC_CONST(0x0300000303030102), ABC_CONST(0x0300000300030102), ABC_CONST(0x0300000003030102), ABC_CONST(0x0300000000030102), ABC_CONST(0x0303030303030102), ABC_CONST(0x0303030300030102), ABC_CONST(0x0303030003030102), ABC_CONST(0x0303030000030102), ABC_CONST(0x0303000303030102), ABC_CONST(0x0303000300030102), ABC_CONST(0x0303000003030102), ABC_CONST(0x0303000000030102), ABC_CONST(0x0300030303030102), ABC_CONST(0x0300030300030102), ABC_CONST(0x0300030003030102), ABC_CONST(0x0300030000030102), ABC_CONST(0x0300000303030102), ABC_CONST(0x0300000300030102), ABC_CONST(0x0300000003030102), ABC_CONST(0x0300000000030102) },
    { ABC_CONST(0x0303030303030101), ABC_CONST(0x0303030300030101), ABC_CONST(0x0303030003030101), ABC_CONST(0x0303030000030101), ABC_CONST(0x0303000303030101), ABC_CONST(0x0303000300030101), ABC_CONST(0x0303000003030101), ABC_CONST(0x0303000000030101), ABC_CONST(0x0300030303030101), ABC_CONST(0x0300030300030101), ABC_CONST(0x0300030003030101), ABC_CONST(0x0300030000030101), ABC_CONST(0x0300000303030101), ABC_CONST(0x0300000300030101), ABC_CONST(0x0300000003030101), ABC_CONST(0x0300000000030101), ABC_CONST(0x0303030303030101), ABC_CONST(0x0303030300030101), ABC_CONST(0x0303030003030101), ABC_CONST(0x0303030000030101), ABC_CONST(0x0303000303030101), ABC_CONST(0x0303000300030101), ABC_CONST(0x0303000003030101), ABC_CONST(0x0303000000030101), ABC_CONST(0x0300030303030101), ABC_CONST(0x0300030300030101), ABC_CONST(0x0300030003030101), ABC_CONST(0x0300030000030101), ABC_CONST(0x0300000303030101), ABC_CONST(0x0300000300030101), ABC_CONST(0x0300000003030101), ABC_CONST(0x0300000000030101) },
    { ABC_CONST(0x0404040404040202), ABC_CONST(0x0404040400040202), ABC_CONST(0x0404040004040202), ABC_CONST(0x0404040000040202), ABC_CONST(0x0404000404040202), ABC_CONST(0x0404000400040202), ABC_CONST(0x0404000004040202), ABC_CONST(0x0404000000040202), ABC_CONST(0x0400040404040202), ABC_CONST(0x0400040400040202), ABC_CONST(0x0400040004040202), ABC_CONST(0x0400040000040202), ABC_CONST(0x0400000404040202), ABC_CONST(0x0400000400040202), ABC_CONST(0x0400000004040202), ABC_CONST(0x0400000000040202), ABC_CONST(0x0404040404040202), ABC_CONST(0x0404040400040202), ABC_CONST(0x0404040004040202), ABC_CONST(0x0404040000040202), ABC_CONST(0x0404000404040202), ABC_CONST(0x0404000400040202), ABC_CONST(0x0404000004040202), ABC_CONST(0x0404000000040202), ABC_CONST(0x0400040404040202), ABC_CONST(0x0400040400040202), ABC_CONST(0x0400040004040202), ABC_CONST(0x0400040000040202), ABC_CONST(0x0400000404040202), ABC_CONST(0x0400000400040202), ABC_CONST(0x0400000004040202), ABC_CONST(0x0400000000040202) },
    { ABC_CONST(0x0101010101000101), ABC_CONST(0x0101010100000101), ABC_CONST(0x0101010001000101), ABC_CONST(0x0101010000000101), ABC_CONST(0x0101000101000101), ABC_CONST(0x0101000100000101), ABC_CONST(0x0101000001000101), ABC_CONST(0x0101000000000101), ABC_CONST(0x0100010101000101), ABC_CONST(0x0100010100000101), ABC_CONST(0x0100010001000101), ABC_CONST(0x0100010000000101), ABC_CONST(0x0100000101000101), ABC_CONST(0x0100000100000101), ABC_CONST(0x0100000001000101), ABC_CONST(0x0100000000000101), ABC_CONST(0x0101010101000101), ABC_CONST(0x0101010100000101), ABC_CONST(0x0101010001000101), ABC_CONST(0x0101010000000101), ABC_CONST(0x0101000101000101), ABC_CONST(0x0101000100000101), ABC_CONST(0x0101000001000101), ABC_CONST(0x0101000000000101), ABC_CONST(0x0100010101000101), ABC_CONST(0x0100010100000101), ABC_CONST(0x0100010001000101), ABC_CONST(0x0100010000000101), ABC_CONST(0x0100000101000101), ABC_CONST(0x0100000100000101), ABC_CONST(0x0100000001000101), ABC_CONST(0x0100000000000101) },
    { ABC_CONST(0x0202020202010202), ABC_CONST(0x0202020200010202), ABC_CONST(0x0202020002010202), ABC_CONST(0x0202020000010202), ABC_CONST(0x0202000202010202), ABC_CONST(0x0202000200010202), ABC_CONST(0x0202000002010202), ABC_CONST(0x0202000000010202), ABC_CONST(0x0200020202010202), ABC_CONST(0x0200020200010202), ABC_CONST(0x0200020002010202), ABC_CONST(0x0200020000010202), ABC_CONST(0x0200000202010202), ABC_CONST(0x0200000200010202), ABC_CONST(0x0200000002010202), ABC_CONST(0x0200000000010202), ABC_CONST(0x0202020202010202), ABC_CONST(0x0202020200010202), ABC_CONST(0x0202020002010202), ABC_CONST(0x0202020000010202), ABC_CONST(0x0202000202010202), ABC_CONST(0x0202000200010202), ABC_CONST(0x0202000002010202), ABC_CONST(0x0202000000010202), ABC_CONST(0x0200020202010202), ABC_CONST(0x0200020200010202), ABC_CONST(0x0200020002010202), ABC_CONST(0x0200020000010202), ABC_CONST(0x0200000202010202), ABC_CONST(0x0200000200010202), ABC_CONST(0x0200000002010202), ABC_CONST(0x0200000000010202) },
    { ABC_CONST(0x0202020202010201), ABC_CONST(0x0202020200010201), ABC_CONST(0x0202020002010201), ABC_CONST(0x0202020000010201), ABC_CONST(0x0202000202010201), ABC_CONST(0x0202000200010201), ABC_CONST(0x0202000002010201), ABC_CONST(0x0202000000010201), ABC_CONST(0x0200020202010201), ABC_CONST(0x0200020200010201), ABC_CONST(0x0200020002010201), ABC_CONST(0x0200020000010201), ABC_CONST(0x0200000202010201), ABC_CONST(0x0200000200010201), ABC_CONST(0x0200000002010201), ABC_CONST(0x0200000000010201), ABC_CONST(0x0202020202010201), ABC_CONST(0x0202020200010201), ABC_CONST(0x0202020002010201), ABC_CONST(0x0202020000010201), ABC_CONST(0x0202000202010201), ABC_CONST(0x0202000200010201), ABC_CONST(0x0202000002010201), ABC_CONST(0x0202000000010201), ABC_CONST(0x0200020202010201), ABC_CONST(0x0200020200010201), ABC_CONST(0x0200020002010201), ABC_CONST(0x0200020000010201), ABC_CONST(0x0200000202010201), ABC_CONST(0x0200000200010201), ABC_CONST(0x0200000002010201), ABC_CONST(0x0200000000010201) },
    { ABC_CONST(0x0303030303020302), ABC_CONST(0x0303030300020302), ABC_CONST(0x0303030003020302), ABC_CONST(0x0303030000020302), ABC_CONST(0x0303000303020302), ABC_CONST(0x0303000300020302), ABC_CONST(0x0303000003020302), ABC_CONST(0x0303000000020302), ABC_CONST(0x0300030303020302), ABC_CONST(0x0300030300020302), ABC_CONST(0x0300030003020302), ABC_CONST(0x0300030000020302), ABC_CONST(0x0300000303020302), ABC_CONST(0x0300000300020302), ABC_CONST(0x0300000003020302), ABC_CONST(0x0300000000020302), ABC_CONST(0x0303030303020302), ABC_CONST(0x0303030300020302), ABC_CONST(0x0303030003020302), ABC_CONST(0x0303030000020302), ABC_CONST(0x0303000303020302), ABC_CONST(0x0303000300020302), ABC_CONST(0x0303000003020302), ABC_CONST(0x0303000000020302), ABC_CONST(0x0300030303020302), ABC_CONST(0x0300030300020302), ABC_CONST(0x0300030003020302), ABC_CONST(0x0300030000020302), ABC_CONST(0x0300000303020302), ABC_CONST(0x0300000300020302), ABC_CONST(0x0300000003020302), ABC_CONST(0x0300000000020302) },
    { ABC_CONST(0x0202020202010102), ABC_CONST(0x0202020200010102), ABC_CONST(0x0202020002010102), ABC_CONST(0x0202020000010102), ABC_CONST(0x0202000202010102), ABC_CONST(0x0202000200010102), ABC_CONST(0x0202000002010102), ABC_CONST(0x0202000000010102), ABC_CONST(0x0200020202010102), ABC_CONST(0x0200020200010102), ABC_CONST(0x0200020002010102), ABC_CONST(0x0200020000010102), ABC_CONST(0x0200000202010102), ABC_CONST(0x0200000200010102), ABC_CONST(0x0200000002010102), ABC_CONST(0x0200000000010102), ABC_CONST(0x0202020202010102), ABC_CONST(0x0202020200010102), ABC_CONST(0x0202020002010102), ABC_CONST(0x0202020000010102), ABC_CONST(0x0202000202010102), ABC_CONST(0x0202000200010102), ABC_CONST(0x0202000002010102), ABC_CONST(0x0202000000010102), ABC_CONST(0x0200020202010102), ABC_CONST(0x0200020200010102), ABC_CONST(0x0200020002010102), ABC_CONST(0x0200020000010102), ABC_CONST(0x0200000202010102), ABC_CONST(0x0200000200010102), ABC_CONST(0x0200000002010102), ABC_CONST(0x0200000000010102) },
    { ABC_CONST(0x0303030303020203), ABC_CONST(0x0303030300020203), ABC_CONST(0x0303030003020203), ABC_CONST(0x0303030000020203), ABC_CONST(0x0303000303020203), ABC_CONST(0x0303000300020203), ABC_CONST(0x0303000003020203), ABC_CONST(0x0303000000020203), ABC_CONST(0x0300030303020203), ABC_CONST(0x0300030300020203), ABC_CONST(0x0300030003020203), ABC_CONST(0x0300030000020203), ABC_CONST(0x0300000303020203), ABC_CONST(0x0300000300020203), ABC_CONST(0x0300000003020203), ABC_CONST(0x0300000000020203), ABC_CONST(0x0303030303020203), ABC_CONST(0x0303030300020203), ABC_CONST(0x0303030003020203), ABC_CONST(0x0303030000020203), ABC_CONST(0x0303000303020203), ABC_CONST(0x0303000300020203), ABC_CONST(0x0303000003020203), ABC_CONST(0x0303000000020203), ABC_CONST(0x0300030303020203), ABC_CONST(0x0300030300020203), ABC_CONST(0x0300030003020203), ABC_CONST(0x0300030000020203), ABC_CONST(0x0300000303020203), ABC_CONST(0x0300000300020203), ABC_CONST(0x0300000003020203), ABC_CONST(0x0300000000020203) },
    { ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202), ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202) },
    { ABC_CONST(0x0404040404030303), ABC_CONST(0x0404040400030303), ABC_CONST(0x0404040004030303), ABC_CONST(0x0404040000030303), ABC_CONST(0x0404000404030303), ABC_CONST(0x0404000400030303), ABC_CONST(0x0404000004030303), ABC_CONST(0x0404000000030303), ABC_CONST(0x0400040404030303), ABC_CONST(0x0400040400030303), ABC_CONST(0x0400040004030303), ABC_CONST(0x0400040000030303), ABC_CONST(0x0400000404030303), ABC_CONST(0x0400000400030303), ABC_CONST(0x0400000004030303), ABC_CONST(0x0400000000030303), ABC_CONST(0x0404040404030303), ABC_CONST(0x0404040400030303), ABC_CONST(0x0404040004030303), ABC_CONST(0x0404040000030303), ABC_CONST(0x0404000404030303), ABC_CONST(0x0404000400030303), ABC_CONST(0x0404000004030303), ABC_CONST(0x0404000000030303), ABC_CONST(0x0400040404030303), ABC_CONST(0x0400040400030303), ABC_CONST(0x0400040004030303), ABC_CONST(0x0400040000030303), ABC_CONST(0x0400000404030303), ABC_CONST(0x0400000400030303), ABC_CONST(0x0400000004030303), ABC_CONST(0x0400000000030303) },
    { ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101), ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101) },
    { ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202), ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202) },
    { ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201), ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201) },
    { ABC_CONST(0x0404040404030302), ABC_CONST(0x0404040400030302), ABC_CONST(0x0404040004030302), ABC_CONST(0x0404040000030302), ABC_CONST(0x0404000404030302), ABC_CONST(0x0404000400030302), ABC_CONST(0x0404000004030302), ABC_CONST(0x0404000000030302), ABC_CONST(0x0400040404030302), ABC_CONST(0x0400040400030302), ABC_CONST(0x0400040004030302), ABC_CONST(0x0400040000030302), ABC_CONST(0x0400000404030302), ABC_CONST(0x0400000400030302), ABC_CONST(0x0400000004030302), ABC_CONST(0x0400000000030302), ABC_CONST(0x0404040404030302), ABC_CONST(0x0404040400030302), ABC_CONST(0x0404040004030302), ABC_CONST(0x0404040000030302), ABC_CONST(0x0404000404030302), ABC_CONST(0x0404000400030302), ABC_CONST(0x0404000004030302), ABC_CONST(0x0404000000030302), ABC_CONST(0x0400040404030302), ABC_CONST(0x0400040400030302), ABC_CONST(0x0400040004030302), ABC_CONST(0x0400040000030302), ABC_CONST(0x0400000404030302), ABC_CONST(0x0400000400030302), ABC_CONST(0x0400000004030302), ABC_CONST(0x0400000000030302) },
    { ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102), ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102) },
    { ABC_CONST(0x0404040404030203), ABC_CONST(0x0404040400030203), ABC_CONST(0x0404040004030203), ABC_CONST(0x0404040000030203), ABC_CONST(0x0404000404030203), ABC_CONST(0x0404000400030203), ABC_CONST(0x0404000004030203), ABC_CONST(0x0404000000030203), ABC_CONST(0x0400040404030203), ABC_CONST(0x0400040400030203), ABC_CONST(0x0400040004030203), ABC_CONST(0x0400040000030203), ABC_CONST(0x0400000404030203), ABC_CONST(0x0400000400030203), ABC_CONST(0x0400000004030203), ABC_CONST(0x0400000000030203), ABC_CONST(0x0404040404030203), ABC_CONST(0x0404040400030203), ABC_CONST(0x0404040004030203), ABC_CONST(0x0404040000030203), ABC_CONST(0x0404000404030203), ABC_CONST(0x0404000400030203), ABC_CONST(0x0404000004030203), ABC_CONST(0x0404000000030203), ABC_CONST(0x0400040404030203), ABC_CONST(0x0400040400030203), ABC_CONST(0x0400040004030203), ABC_CONST(0x0400040000030203), ABC_CONST(0x0400000404030203), ABC_CONST(0x0400000400030203), ABC_CONST(0x0400000004030203), ABC_CONST(0x0400000000030203) },
    { ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202), ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202) },
    { ABC_CONST(0x0505050505040303), ABC_CONST(0x0505050500040303), ABC_CONST(0x0505050005040303), ABC_CONST(0x0505050000040303), ABC_CONST(0x0505000505040303), ABC_CONST(0x0505000500040303), ABC_CONST(0x0505000005040303), ABC_CONST(0x0505000000040303), ABC_CONST(0x0500050505040303), ABC_CONST(0x0500050500040303), ABC_CONST(0x0500050005040303), ABC_CONST(0x0500050000040303), ABC_CONST(0x0500000505040303), ABC_CONST(0x0500000500040303), ABC_CONST(0x0500000005040303), ABC_CONST(0x0500000000040303), ABC_CONST(0x0505050505040303), ABC_CONST(0x0505050500040303), ABC_CONST(0x0505050005040303), ABC_CONST(0x0505050000040303), ABC_CONST(0x0505000505040303), ABC_CONST(0x0505000500040303), ABC_CONST(0x0505000005040303), ABC_CONST(0x0505000000040303), ABC_CONST(0x0500050505040303), ABC_CONST(0x0500050500040303), ABC_CONST(0x0500050005040303), ABC_CONST(0x0500050000040303), ABC_CONST(0x0500000505040303), ABC_CONST(0x0500000500040303), ABC_CONST(0x0500000005040303), ABC_CONST(0x0500000000040303) },
    { ABC_CONST(0x0101010101000100), ABC_CONST(0x0101010100000100), ABC_CONST(0x0101010001000100), ABC_CONST(0x0101010000000100), ABC_CONST(0x0101000101000100), ABC_CONST(0x0101000100000100), ABC_CONST(0x0101000001000100), ABC_CONST(0x0101000000000100), ABC_CONST(0x0100010101000100), ABC_CONST(0x0100010100000100), ABC_CONST(0x0100010001000100), ABC_CONST(0x0100010000000100), ABC_CONST(0x0100000101000100), ABC_CONST(0x0100000100000100), ABC_CONST(0x0100000001000100), ABC_CONST(0x0100000000000100), ABC_CONST(0x0101010101000100), ABC_CONST(0x0101010100000100), ABC_CONST(0x0101010001000100), ABC_CONST(0x0101010000000100), ABC_CONST(0x0101000101000100), ABC_CONST(0x0101000100000100), ABC_CONST(0x0101000001000100), ABC_CONST(0x0101000000000100), ABC_CONST(0x0100010101000100), ABC_CONST(0x0100010100000100), ABC_CONST(0x0100010001000100), ABC_CONST(0x0100010000000100), ABC_CONST(0x0100000101000100), ABC_CONST(0x0100000100000100), ABC_CONST(0x0100000001000100), ABC_CONST(0x0100000000000100) },
    { ABC_CONST(0x0202020202010201), ABC_CONST(0x0202020200010201), ABC_CONST(0x0202020002010201), ABC_CONST(0x0202020000010201), ABC_CONST(0x0202000202010201), ABC_CONST(0x0202000200010201), ABC_CONST(0x0202000002010201), ABC_CONST(0x0202000000010201), ABC_CONST(0x0200020202010201), ABC_CONST(0x0200020200010201), ABC_CONST(0x0200020002010201), ABC_CONST(0x0200020000010201), ABC_CONST(0x0200000202010201), ABC_CONST(0x0200000200010201), ABC_CONST(0x0200000002010201), ABC_CONST(0x0200000000010201), ABC_CONST(0x0202020202010201), ABC_CONST(0x0202020200010201), ABC_CONST(0x0202020002010201), ABC_CONST(0x0202020000010201), ABC_CONST(0x0202000202010201), ABC_CONST(0x0202000200010201), ABC_CONST(0x0202000002010201), ABC_CONST(0x0202000000010201), ABC_CONST(0x0200020202010201), ABC_CONST(0x0200020200010201), ABC_CONST(0x0200020002010201), ABC_CONST(0x0200020000010201), ABC_CONST(0x0200000202010201), ABC_CONST(0x0200000200010201), ABC_CONST(0x0200000002010201), ABC_CONST(0x0200000000010201) },
    { ABC_CONST(0x0202020202010200), ABC_CONST(0x0202020200010200), ABC_CONST(0x0202020002010200), ABC_CONST(0x0202020000010200), ABC_CONST(0x0202000202010200), ABC_CONST(0x0202000200010200), ABC_CONST(0x0202000002010200), ABC_CONST(0x0202000000010200), ABC_CONST(0x0200020202010200), ABC_CONST(0x0200020200010200), ABC_CONST(0x0200020002010200), ABC_CONST(0x0200020000010200), ABC_CONST(0x0200000202010200), ABC_CONST(0x0200000200010200), ABC_CONST(0x0200000002010200), ABC_CONST(0x0200000000010200), ABC_CONST(0x0202020202010200), ABC_CONST(0x0202020200010200), ABC_CONST(0x0202020002010200), ABC_CONST(0x0202020000010200), ABC_CONST(0x0202000202010200), ABC_CONST(0x0202000200010200), ABC_CONST(0x0202000002010200), ABC_CONST(0x0202000000010200), ABC_CONST(0x0200020202010200), ABC_CONST(0x0200020200010200), ABC_CONST(0x0200020002010200), ABC_CONST(0x0200020000010200), ABC_CONST(0x0200000202010200), ABC_CONST(0x0200000200010200), ABC_CONST(0x0200000002010200), ABC_CONST(0x0200000000010200) },
    { ABC_CONST(0x0303030303020301), ABC_CONST(0x0303030300020301), ABC_CONST(0x0303030003020301), ABC_CONST(0x0303030000020301), ABC_CONST(0x0303000303020301), ABC_CONST(0x0303000300020301), ABC_CONST(0x0303000003020301), ABC_CONST(0x0303000000020301), ABC_CONST(0x0300030303020301), ABC_CONST(0x0300030300020301), ABC_CONST(0x0300030003020301), ABC_CONST(0x0300030000020301), ABC_CONST(0x0300000303020301), ABC_CONST(0x0300000300020301), ABC_CONST(0x0300000003020301), ABC_CONST(0x0300000000020301), ABC_CONST(0x0303030303020301), ABC_CONST(0x0303030300020301), ABC_CONST(0x0303030003020301), ABC_CONST(0x0303030000020301), ABC_CONST(0x0303000303020301), ABC_CONST(0x0303000300020301), ABC_CONST(0x0303000003020301), ABC_CONST(0x0303000000020301), ABC_CONST(0x0300030303020301), ABC_CONST(0x0300030300020301), ABC_CONST(0x0300030003020301), ABC_CONST(0x0300030000020301), ABC_CONST(0x0300000303020301), ABC_CONST(0x0300000300020301), ABC_CONST(0x0300000003020301), ABC_CONST(0x0300000000020301) },
    { ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101), ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101) },
    { ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202), ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202) },
    { ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201), ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201) },
    { ABC_CONST(0x0404040404030302), ABC_CONST(0x0404040400030302), ABC_CONST(0x0404040004030302), ABC_CONST(0x0404040000030302), ABC_CONST(0x0404000404030302), ABC_CONST(0x0404000400030302), ABC_CONST(0x0404000004030302), ABC_CONST(0x0404000000030302), ABC_CONST(0x0400040404030302), ABC_CONST(0x0400040400030302), ABC_CONST(0x0400040004030302), ABC_CONST(0x0400040000030302), ABC_CONST(0x0400000404030302), ABC_CONST(0x0400000400030302), ABC_CONST(0x0400000004030302), ABC_CONST(0x0400000000030302), ABC_CONST(0x0404040404030302), ABC_CONST(0x0404040400030302), ABC_CONST(0x0404040004030302), ABC_CONST(0x0404040000030302), ABC_CONST(0x0404000404030302), ABC_CONST(0x0404000400030302), ABC_CONST(0x0404000004030302), ABC_CONST(0x0404000000030302), ABC_CONST(0x0400040404030302), ABC_CONST(0x0400040400030302), ABC_CONST(0x0400040004030302), ABC_CONST(0x0400040000030302), ABC_CONST(0x0400000404030302), ABC_CONST(0x0400000400030302), ABC_CONST(0x0400000004030302), ABC_CONST(0x0400000000030302) },
    { ABC_CONST(0x0202020202010100), ABC_CONST(0x0202020200010100), ABC_CONST(0x0202020002010100), ABC_CONST(0x0202020000010100), ABC_CONST(0x0202000202010100), ABC_CONST(0x0202000200010100), ABC_CONST(0x0202000002010100), ABC_CONST(0x0202000000010100), ABC_CONST(0x0200020202010100), ABC_CONST(0x0200020200010100), ABC_CONST(0x0200020002010100), ABC_CONST(0x0200020000010100), ABC_CONST(0x0200000202010100), ABC_CONST(0x0200000200010100), ABC_CONST(0x0200000002010100), ABC_CONST(0x0200000000010100), ABC_CONST(0x0202020202010100), ABC_CONST(0x0202020200010100), ABC_CONST(0x0202020002010100), ABC_CONST(0x0202020000010100), ABC_CONST(0x0202000202010100), ABC_CONST(0x0202000200010100), ABC_CONST(0x0202000002010100), ABC_CONST(0x0202000000010100), ABC_CONST(0x0200020202010100), ABC_CONST(0x0200020200010100), ABC_CONST(0x0200020002010100), ABC_CONST(0x0200020000010100), ABC_CONST(0x0200000202010100), ABC_CONST(0x0200000200010100), ABC_CONST(0x0200000002010100), ABC_CONST(0x0200000000010100) },
    { ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201), ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201) },
    { ABC_CONST(0x0303030303020200), ABC_CONST(0x0303030300020200), ABC_CONST(0x0303030003020200), ABC_CONST(0x0303030000020200), ABC_CONST(0x0303000303020200), ABC_CONST(0x0303000300020200), ABC_CONST(0x0303000003020200), ABC_CONST(0x0303000000020200), ABC_CONST(0x0300030303020200), ABC_CONST(0x0300030300020200), ABC_CONST(0x0300030003020200), ABC_CONST(0x0300030000020200), ABC_CONST(0x0300000303020200), ABC_CONST(0x0300000300020200), ABC_CONST(0x0300000003020200), ABC_CONST(0x0300000000020200), ABC_CONST(0x0303030303020200), ABC_CONST(0x0303030300020200), ABC_CONST(0x0303030003020200), ABC_CONST(0x0303030000020200), ABC_CONST(0x0303000303020200), ABC_CONST(0x0303000300020200), ABC_CONST(0x0303000003020200), ABC_CONST(0x0303000000020200), ABC_CONST(0x0300030303020200), ABC_CONST(0x0300030300020200), ABC_CONST(0x0300030003020200), ABC_CONST(0x0300030000020200), ABC_CONST(0x0300000303020200), ABC_CONST(0x0300000300020200), ABC_CONST(0x0300000003020200), ABC_CONST(0x0300000000020200) },
    { ABC_CONST(0x0404040404030301), ABC_CONST(0x0404040400030301), ABC_CONST(0x0404040004030301), ABC_CONST(0x0404040000030301), ABC_CONST(0x0404000404030301), ABC_CONST(0x0404000400030301), ABC_CONST(0x0404000004030301), ABC_CONST(0x0404000000030301), ABC_CONST(0x0400040404030301), ABC_CONST(0x0400040400030301), ABC_CONST(0x0400040004030301), ABC_CONST(0x0400040000030301), ABC_CONST(0x0400000404030301), ABC_CONST(0x0400000400030301), ABC_CONST(0x0400000004030301), ABC_CONST(0x0400000000030301), ABC_CONST(0x0404040404030301), ABC_CONST(0x0404040400030301), ABC_CONST(0x0404040004030301), ABC_CONST(0x0404040000030301), ABC_CONST(0x0404000404030301), ABC_CONST(0x0404000400030301), ABC_CONST(0x0404000004030301), ABC_CONST(0x0404000000030301), ABC_CONST(0x0400040404030301), ABC_CONST(0x0400040400030301), ABC_CONST(0x0400040004030301), ABC_CONST(0x0400040000030301), ABC_CONST(0x0400000404030301), ABC_CONST(0x0400000400030301), ABC_CONST(0x0400000004030301), ABC_CONST(0x0400000000030301) },
    { ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101), ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101) },
    { ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202), ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202) },
    { ABC_CONST(0x0404040404030201), ABC_CONST(0x0404040400030201), ABC_CONST(0x0404040004030201), ABC_CONST(0x0404040000030201), ABC_CONST(0x0404000404030201), ABC_CONST(0x0404000400030201), ABC_CONST(0x0404000004030201), ABC_CONST(0x0404000000030201), ABC_CONST(0x0400040404030201), ABC_CONST(0x0400040400030201), ABC_CONST(0x0400040004030201), ABC_CONST(0x0400040000030201), ABC_CONST(0x0400000404030201), ABC_CONST(0x0400000400030201), ABC_CONST(0x0400000004030201), ABC_CONST(0x0400000000030201), ABC_CONST(0x0404040404030201), ABC_CONST(0x0404040400030201), ABC_CONST(0x0404040004030201), ABC_CONST(0x0404040000030201), ABC_CONST(0x0404000404030201), ABC_CONST(0x0404000400030201), ABC_CONST(0x0404000004030201), ABC_CONST(0x0404000000030201), ABC_CONST(0x0400040404030201), ABC_CONST(0x0400040400030201), ABC_CONST(0x0400040004030201), ABC_CONST(0x0400040000030201), ABC_CONST(0x0400000404030201), ABC_CONST(0x0400000400030201), ABC_CONST(0x0400000004030201), ABC_CONST(0x0400000000030201) },
    { ABC_CONST(0x0505050505040302), ABC_CONST(0x0505050500040302), ABC_CONST(0x0505050005040302), ABC_CONST(0x0505050000040302), ABC_CONST(0x0505000505040302), ABC_CONST(0x0505000500040302), ABC_CONST(0x0505000005040302), ABC_CONST(0x0505000000040302), ABC_CONST(0x0500050505040302), ABC_CONST(0x0500050500040302), ABC_CONST(0x0500050005040302), ABC_CONST(0x0500050000040302), ABC_CONST(0x0500000505040302), ABC_CONST(0x0500000500040302), ABC_CONST(0x0500000005040302), ABC_CONST(0x0500000000040302), ABC_CONST(0x0505050505040302), ABC_CONST(0x0505050500040302), ABC_CONST(0x0505050005040302), ABC_CONST(0x0505050000040302), ABC_CONST(0x0505000505040302), ABC_CONST(0x0505000500040302), ABC_CONST(0x0505000005040302), ABC_CONST(0x0505000000040302), ABC_CONST(0x0500050505040302), ABC_CONST(0x0500050500040302), ABC_CONST(0x0500050005040302), ABC_CONST(0x0500050000040302), ABC_CONST(0x0500000505040302), ABC_CONST(0x0500000500040302), ABC_CONST(0x0500000005040302), ABC_CONST(0x0500000000040302) },
    { ABC_CONST(0x0202020202000201), ABC_CONST(0x0202020200000201), ABC_CONST(0x0202020002000201), ABC_CONST(0x0202020000000201), ABC_CONST(0x0202000202000201), ABC_CONST(0x0202000200000201), ABC_CONST(0x0202000002000201), ABC_CONST(0x0202000000000201), ABC_CONST(0x0200020202000201), ABC_CONST(0x0200020200000201), ABC_CONST(0x0200020002000201), ABC_CONST(0x0200020000000201), ABC_CONST(0x0200000202000201), ABC_CONST(0x0200000200000201), ABC_CONST(0x0200000002000201), ABC_CONST(0x0200000000000201), ABC_CONST(0x0202020202000201), ABC_CONST(0x0202020200000201), ABC_CONST(0x0202020002000201), ABC_CONST(0x0202020000000201), ABC_CONST(0x0202000202000201), ABC_CONST(0x0202000200000201), ABC_CONST(0x0202000002000201), ABC_CONST(0x0202000000000201), ABC_CONST(0x0200020202000201), ABC_CONST(0x0200020200000201), ABC_CONST(0x0200020002000201), ABC_CONST(0x0200020000000201), ABC_CONST(0x0200000202000201), ABC_CONST(0x0200000200000201), ABC_CONST(0x0200000002000201), ABC_CONST(0x0200000000000201) },
    { ABC_CONST(0x0303030303010302), ABC_CONST(0x0303030300010302), ABC_CONST(0x0303030003010302), ABC_CONST(0x0303030000010302), ABC_CONST(0x0303000303010302), ABC_CONST(0x0303000300010302), ABC_CONST(0x0303000003010302), ABC_CONST(0x0303000000010302), ABC_CONST(0x0300030303010302), ABC_CONST(0x0300030300010302), ABC_CONST(0x0300030003010302), ABC_CONST(0x0300030000010302), ABC_CONST(0x0300000303010302), ABC_CONST(0x0300000300010302), ABC_CONST(0x0300000003010302), ABC_CONST(0x0300000000010302), ABC_CONST(0x0303030303010302), ABC_CONST(0x0303030300010302), ABC_CONST(0x0303030003010302), ABC_CONST(0x0303030000010302), ABC_CONST(0x0303000303010302), ABC_CONST(0x0303000300010302), ABC_CONST(0x0303000003010302), ABC_CONST(0x0303000000010302), ABC_CONST(0x0300030303010302), ABC_CONST(0x0300030300010302), ABC_CONST(0x0300030003010302), ABC_CONST(0x0300030000010302), ABC_CONST(0x0300000303010302), ABC_CONST(0x0300000300010302), ABC_CONST(0x0300000003010302), ABC_CONST(0x0300000000010302) },
    { ABC_CONST(0x0303030303010301), ABC_CONST(0x0303030300010301), ABC_CONST(0x0303030003010301), ABC_CONST(0x0303030000010301), ABC_CONST(0x0303000303010301), ABC_CONST(0x0303000300010301), ABC_CONST(0x0303000003010301), ABC_CONST(0x0303000000010301), ABC_CONST(0x0300030303010301), ABC_CONST(0x0300030300010301), ABC_CONST(0x0300030003010301), ABC_CONST(0x0300030000010301), ABC_CONST(0x0300000303010301), ABC_CONST(0x0300000300010301), ABC_CONST(0x0300000003010301), ABC_CONST(0x0300000000010301), ABC_CONST(0x0303030303010301), ABC_CONST(0x0303030300010301), ABC_CONST(0x0303030003010301), ABC_CONST(0x0303030000010301), ABC_CONST(0x0303000303010301), ABC_CONST(0x0303000300010301), ABC_CONST(0x0303000003010301), ABC_CONST(0x0303000000010301), ABC_CONST(0x0300030303010301), ABC_CONST(0x0300030300010301), ABC_CONST(0x0300030003010301), ABC_CONST(0x0300030000010301), ABC_CONST(0x0300000303010301), ABC_CONST(0x0300000300010301), ABC_CONST(0x0300000003010301), ABC_CONST(0x0300000000010301) },
    { ABC_CONST(0x0404040404020402), ABC_CONST(0x0404040400020402), ABC_CONST(0x0404040004020402), ABC_CONST(0x0404040000020402), ABC_CONST(0x0404000404020402), ABC_CONST(0x0404000400020402), ABC_CONST(0x0404000004020402), ABC_CONST(0x0404000000020402), ABC_CONST(0x0400040404020402), ABC_CONST(0x0400040400020402), ABC_CONST(0x0400040004020402), ABC_CONST(0x0400040000020402), ABC_CONST(0x0400000404020402), ABC_CONST(0x0400000400020402), ABC_CONST(0x0400000004020402), ABC_CONST(0x0400000000020402), ABC_CONST(0x0404040404020402), ABC_CONST(0x0404040400020402), ABC_CONST(0x0404040004020402), ABC_CONST(0x0404040000020402), ABC_CONST(0x0404000404020402), ABC_CONST(0x0404000400020402), ABC_CONST(0x0404000004020402), ABC_CONST(0x0404000000020402), ABC_CONST(0x0400040404020402), ABC_CONST(0x0400040400020402), ABC_CONST(0x0400040004020402), ABC_CONST(0x0400040000020402), ABC_CONST(0x0400000404020402), ABC_CONST(0x0400000400020402), ABC_CONST(0x0400000004020402), ABC_CONST(0x0400000000020402) },
    { ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202), ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202) },
    { ABC_CONST(0x0404040404020303), ABC_CONST(0x0404040400020303), ABC_CONST(0x0404040004020303), ABC_CONST(0x0404040000020303), ABC_CONST(0x0404000404020303), ABC_CONST(0x0404000400020303), ABC_CONST(0x0404000004020303), ABC_CONST(0x0404000000020303), ABC_CONST(0x0400040404020303), ABC_CONST(0x0400040400020303), ABC_CONST(0x0400040004020303), ABC_CONST(0x0400040000020303), ABC_CONST(0x0400000404020303), ABC_CONST(0x0400000400020303), ABC_CONST(0x0400000004020303), ABC_CONST(0x0400000000020303), ABC_CONST(0x0404040404020303), ABC_CONST(0x0404040400020303), ABC_CONST(0x0404040004020303), ABC_CONST(0x0404040000020303), ABC_CONST(0x0404000404020303), ABC_CONST(0x0404000400020303), ABC_CONST(0x0404000004020303), ABC_CONST(0x0404000000020303), ABC_CONST(0x0400040404020303), ABC_CONST(0x0400040400020303), ABC_CONST(0x0400040004020303), ABC_CONST(0x0400040000020303), ABC_CONST(0x0400000404020303), ABC_CONST(0x0400000400020303), ABC_CONST(0x0400000004020303), ABC_CONST(0x0400000000020303) },
    { ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302), ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302) },
    { ABC_CONST(0x0505050505030403), ABC_CONST(0x0505050500030403), ABC_CONST(0x0505050005030403), ABC_CONST(0x0505050000030403), ABC_CONST(0x0505000505030403), ABC_CONST(0x0505000500030403), ABC_CONST(0x0505000005030403), ABC_CONST(0x0505000000030403), ABC_CONST(0x0500050505030403), ABC_CONST(0x0500050500030403), ABC_CONST(0x0500050005030403), ABC_CONST(0x0500050000030403), ABC_CONST(0x0500000505030403), ABC_CONST(0x0500000500030403), ABC_CONST(0x0500000005030403), ABC_CONST(0x0500000000030403), ABC_CONST(0x0505050505030403), ABC_CONST(0x0505050500030403), ABC_CONST(0x0505050005030403), ABC_CONST(0x0505050000030403), ABC_CONST(0x0505000505030403), ABC_CONST(0x0505000500030403), ABC_CONST(0x0505000005030403), ABC_CONST(0x0505000000030403), ABC_CONST(0x0500050505030403), ABC_CONST(0x0500050500030403), ABC_CONST(0x0500050005030403), ABC_CONST(0x0500050000030403), ABC_CONST(0x0500000505030403), ABC_CONST(0x0500000500030403), ABC_CONST(0x0500000005030403), ABC_CONST(0x0500000000030403) },
    { ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201), ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201) },
    { ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302), ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302) },
    { ABC_CONST(0x0404040404020301), ABC_CONST(0x0404040400020301), ABC_CONST(0x0404040004020301), ABC_CONST(0x0404040000020301), ABC_CONST(0x0404000404020301), ABC_CONST(0x0404000400020301), ABC_CONST(0x0404000004020301), ABC_CONST(0x0404000000020301), ABC_CONST(0x0400040404020301), ABC_CONST(0x0400040400020301), ABC_CONST(0x0400040004020301), ABC_CONST(0x0400040000020301), ABC_CONST(0x0400000404020301), ABC_CONST(0x0400000400020301), ABC_CONST(0x0400000004020301), ABC_CONST(0x0400000000020301), ABC_CONST(0x0404040404020301), ABC_CONST(0x0404040400020301), ABC_CONST(0x0404040004020301), ABC_CONST(0x0404040000020301), ABC_CONST(0x0404000404020301), ABC_CONST(0x0404000400020301), ABC_CONST(0x0404000004020301), ABC_CONST(0x0404000000020301), ABC_CONST(0x0400040404020301), ABC_CONST(0x0400040400020301), ABC_CONST(0x0400040004020301), ABC_CONST(0x0400040000020301), ABC_CONST(0x0400000404020301), ABC_CONST(0x0400000400020301), ABC_CONST(0x0400000004020301), ABC_CONST(0x0400000000020301) },
    { ABC_CONST(0x0505050505030402), ABC_CONST(0x0505050500030402), ABC_CONST(0x0505050005030402), ABC_CONST(0x0505050000030402), ABC_CONST(0x0505000505030402), ABC_CONST(0x0505000500030402), ABC_CONST(0x0505000005030402), ABC_CONST(0x0505000000030402), ABC_CONST(0x0500050505030402), ABC_CONST(0x0500050500030402), ABC_CONST(0x0500050005030402), ABC_CONST(0x0500050000030402), ABC_CONST(0x0500000505030402), ABC_CONST(0x0500000500030402), ABC_CONST(0x0500000005030402), ABC_CONST(0x0500000000030402), ABC_CONST(0x0505050505030402), ABC_CONST(0x0505050500030402), ABC_CONST(0x0505050005030402), ABC_CONST(0x0505050000030402), ABC_CONST(0x0505000505030402), ABC_CONST(0x0505000500030402), ABC_CONST(0x0505000005030402), ABC_CONST(0x0505000000030402), ABC_CONST(0x0500050505030402), ABC_CONST(0x0500050500030402), ABC_CONST(0x0500050005030402), ABC_CONST(0x0500050000030402), ABC_CONST(0x0500000505030402), ABC_CONST(0x0500000500030402), ABC_CONST(0x0500000005030402), ABC_CONST(0x0500000000030402) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303), ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303) },
    { ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302), ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302) },
    { ABC_CONST(0x0606060606040403), ABC_CONST(0x0606060600040403), ABC_CONST(0x0606060006040403), ABC_CONST(0x0606060000040403), ABC_CONST(0x0606000606040403), ABC_CONST(0x0606000600040403), ABC_CONST(0x0606000006040403), ABC_CONST(0x0606000000040403), ABC_CONST(0x0600060606040403), ABC_CONST(0x0600060600040403), ABC_CONST(0x0600060006040403), ABC_CONST(0x0600060000040403), ABC_CONST(0x0600000606040403), ABC_CONST(0x0600000600040403), ABC_CONST(0x0600000006040403), ABC_CONST(0x0600000000040403), ABC_CONST(0x0606060606040403), ABC_CONST(0x0606060600040403), ABC_CONST(0x0606060006040403), ABC_CONST(0x0606060000040403), ABC_CONST(0x0606000606040403), ABC_CONST(0x0606000600040403), ABC_CONST(0x0606000006040403), ABC_CONST(0x0606000000040403), ABC_CONST(0x0600060606040403), ABC_CONST(0x0600060600040403), ABC_CONST(0x0600060006040403), ABC_CONST(0x0600060000040403), ABC_CONST(0x0600000606040403), ABC_CONST(0x0600000600040403), ABC_CONST(0x0600000006040403), ABC_CONST(0x0600000000040403) },
    { ABC_CONST(0x0101010101000001), ABC_CONST(0x0101010100000001), ABC_CONST(0x0101010001000001), ABC_CONST(0x0101010000000001), ABC_CONST(0x0101000101000001), ABC_CONST(0x0101000100000001), ABC_CONST(0x0101000001000001), ABC_CONST(0x0101000000000001), ABC_CONST(0x0100010101000001), ABC_CONST(0x0100010100000001), ABC_CONST(0x0100010001000001), ABC_CONST(0x0100010000000001), ABC_CONST(0x0100000101000001), ABC_CONST(0x0100000100000001), ABC_CONST(0x0100000001000001), ABC_CONST(0x0100000000000001), ABC_CONST(0x0101010101000001), ABC_CONST(0x0101010100000001), ABC_CONST(0x0101010001000001), ABC_CONST(0x0101010000000001), ABC_CONST(0x0101000101000001), ABC_CONST(0x0101000100000001), ABC_CONST(0x0101000001000001), ABC_CONST(0x0101000000000001), ABC_CONST(0x0100010101000001), ABC_CONST(0x0100010100000001), ABC_CONST(0x0100010001000001), ABC_CONST(0x0100010000000001), ABC_CONST(0x0100000101000001), ABC_CONST(0x0100000100000001), ABC_CONST(0x0100000001000001), ABC_CONST(0x0100000000000001) },
    { ABC_CONST(0x0202020202010102), ABC_CONST(0x0202020200010102), ABC_CONST(0x0202020002010102), ABC_CONST(0x0202020000010102), ABC_CONST(0x0202000202010102), ABC_CONST(0x0202000200010102), ABC_CONST(0x0202000002010102), ABC_CONST(0x0202000000010102), ABC_CONST(0x0200020202010102), ABC_CONST(0x0200020200010102), ABC_CONST(0x0200020002010102), ABC_CONST(0x0200020000010102), ABC_CONST(0x0200000202010102), ABC_CONST(0x0200000200010102), ABC_CONST(0x0200000002010102), ABC_CONST(0x0200000000010102), ABC_CONST(0x0202020202010102), ABC_CONST(0x0202020200010102), ABC_CONST(0x0202020002010102), ABC_CONST(0x0202020000010102), ABC_CONST(0x0202000202010102), ABC_CONST(0x0202000200010102), ABC_CONST(0x0202000002010102), ABC_CONST(0x0202000000010102), ABC_CONST(0x0200020202010102), ABC_CONST(0x0200020200010102), ABC_CONST(0x0200020002010102), ABC_CONST(0x0200020000010102), ABC_CONST(0x0200000202010102), ABC_CONST(0x0200000200010102), ABC_CONST(0x0200000002010102), ABC_CONST(0x0200000000010102) },
    { ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101), ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101) },
    { ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202), ABC_CONST(0x0303030303020202), ABC_CONST(0x0303030300020202), ABC_CONST(0x0303030003020202), ABC_CONST(0x0303030000020202), ABC_CONST(0x0303000303020202), ABC_CONST(0x0303000300020202), ABC_CONST(0x0303000003020202), ABC_CONST(0x0303000000020202), ABC_CONST(0x0300030303020202), ABC_CONST(0x0300030300020202), ABC_CONST(0x0300030003020202), ABC_CONST(0x0300030000020202), ABC_CONST(0x0300000303020202), ABC_CONST(0x0300000300020202), ABC_CONST(0x0300000003020202), ABC_CONST(0x0300000000020202) },
    { ABC_CONST(0x0202020202010002), ABC_CONST(0x0202020200010002), ABC_CONST(0x0202020002010002), ABC_CONST(0x0202020000010002), ABC_CONST(0x0202000202010002), ABC_CONST(0x0202000200010002), ABC_CONST(0x0202000002010002), ABC_CONST(0x0202000000010002), ABC_CONST(0x0200020202010002), ABC_CONST(0x0200020200010002), ABC_CONST(0x0200020002010002), ABC_CONST(0x0200020000010002), ABC_CONST(0x0200000202010002), ABC_CONST(0x0200000200010002), ABC_CONST(0x0200000002010002), ABC_CONST(0x0200000000010002), ABC_CONST(0x0202020202010002), ABC_CONST(0x0202020200010002), ABC_CONST(0x0202020002010002), ABC_CONST(0x0202020000010002), ABC_CONST(0x0202000202010002), ABC_CONST(0x0202000200010002), ABC_CONST(0x0202000002010002), ABC_CONST(0x0202000000010002), ABC_CONST(0x0200020202010002), ABC_CONST(0x0200020200010002), ABC_CONST(0x0200020002010002), ABC_CONST(0x0200020000010002), ABC_CONST(0x0200000202010002), ABC_CONST(0x0200000200010002), ABC_CONST(0x0200000002010002), ABC_CONST(0x0200000000010002) },
    { ABC_CONST(0x0303030303020103), ABC_CONST(0x0303030300020103), ABC_CONST(0x0303030003020103), ABC_CONST(0x0303030000020103), ABC_CONST(0x0303000303020103), ABC_CONST(0x0303000300020103), ABC_CONST(0x0303000003020103), ABC_CONST(0x0303000000020103), ABC_CONST(0x0300030303020103), ABC_CONST(0x0300030300020103), ABC_CONST(0x0300030003020103), ABC_CONST(0x0300030000020103), ABC_CONST(0x0300000303020103), ABC_CONST(0x0300000300020103), ABC_CONST(0x0300000003020103), ABC_CONST(0x0300000000020103), ABC_CONST(0x0303030303020103), ABC_CONST(0x0303030300020103), ABC_CONST(0x0303030003020103), ABC_CONST(0x0303030000020103), ABC_CONST(0x0303000303020103), ABC_CONST(0x0303000300020103), ABC_CONST(0x0303000003020103), ABC_CONST(0x0303000000020103), ABC_CONST(0x0300030303020103), ABC_CONST(0x0300030300020103), ABC_CONST(0x0300030003020103), ABC_CONST(0x0300030000020103), ABC_CONST(0x0300000303020103), ABC_CONST(0x0300000300020103), ABC_CONST(0x0300000003020103), ABC_CONST(0x0300000000020103) },
    { ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102), ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102) },
    { ABC_CONST(0x0404040404030203), ABC_CONST(0x0404040400030203), ABC_CONST(0x0404040004030203), ABC_CONST(0x0404040000030203), ABC_CONST(0x0404000404030203), ABC_CONST(0x0404000400030203), ABC_CONST(0x0404000004030203), ABC_CONST(0x0404000000030203), ABC_CONST(0x0400040404030203), ABC_CONST(0x0400040400030203), ABC_CONST(0x0400040004030203), ABC_CONST(0x0400040000030203), ABC_CONST(0x0400000404030203), ABC_CONST(0x0400000400030203), ABC_CONST(0x0400000004030203), ABC_CONST(0x0400000000030203), ABC_CONST(0x0404040404030203), ABC_CONST(0x0404040400030203), ABC_CONST(0x0404040004030203), ABC_CONST(0x0404040000030203), ABC_CONST(0x0404000404030203), ABC_CONST(0x0404000400030203), ABC_CONST(0x0404000004030203), ABC_CONST(0x0404000000030203), ABC_CONST(0x0400040404030203), ABC_CONST(0x0400040400030203), ABC_CONST(0x0400040004030203), ABC_CONST(0x0400040000030203), ABC_CONST(0x0400000404030203), ABC_CONST(0x0400000400030203), ABC_CONST(0x0400000004030203), ABC_CONST(0x0400000000030203) },
    { ABC_CONST(0x0202020202010001), ABC_CONST(0x0202020200010001), ABC_CONST(0x0202020002010001), ABC_CONST(0x0202020000010001), ABC_CONST(0x0202000202010001), ABC_CONST(0x0202000200010001), ABC_CONST(0x0202000002010001), ABC_CONST(0x0202000000010001), ABC_CONST(0x0200020202010001), ABC_CONST(0x0200020200010001), ABC_CONST(0x0200020002010001), ABC_CONST(0x0200020000010001), ABC_CONST(0x0200000202010001), ABC_CONST(0x0200000200010001), ABC_CONST(0x0200000002010001), ABC_CONST(0x0200000000010001), ABC_CONST(0x0202020202010001), ABC_CONST(0x0202020200010001), ABC_CONST(0x0202020002010001), ABC_CONST(0x0202020000010001), ABC_CONST(0x0202000202010001), ABC_CONST(0x0202000200010001), ABC_CONST(0x0202000002010001), ABC_CONST(0x0202000000010001), ABC_CONST(0x0200020202010001), ABC_CONST(0x0200020200010001), ABC_CONST(0x0200020002010001), ABC_CONST(0x0200020000010001), ABC_CONST(0x0200000202010001), ABC_CONST(0x0200000200010001), ABC_CONST(0x0200000002010001), ABC_CONST(0x0200000000010001) },
    { ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102), ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102) },
    { ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101), ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101) },
    { ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202), ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202) },
    { ABC_CONST(0x0303030303020002), ABC_CONST(0x0303030300020002), ABC_CONST(0x0303030003020002), ABC_CONST(0x0303030000020002), ABC_CONST(0x0303000303020002), ABC_CONST(0x0303000300020002), ABC_CONST(0x0303000003020002), ABC_CONST(0x0303000000020002), ABC_CONST(0x0300030303020002), ABC_CONST(0x0300030300020002), ABC_CONST(0x0300030003020002), ABC_CONST(0x0300030000020002), ABC_CONST(0x0300000303020002), ABC_CONST(0x0300000300020002), ABC_CONST(0x0300000003020002), ABC_CONST(0x0300000000020002), ABC_CONST(0x0303030303020002), ABC_CONST(0x0303030300020002), ABC_CONST(0x0303030003020002), ABC_CONST(0x0303030000020002), ABC_CONST(0x0303000303020002), ABC_CONST(0x0303000300020002), ABC_CONST(0x0303000003020002), ABC_CONST(0x0303000000020002), ABC_CONST(0x0300030303020002), ABC_CONST(0x0300030300020002), ABC_CONST(0x0300030003020002), ABC_CONST(0x0300030000020002), ABC_CONST(0x0300000303020002), ABC_CONST(0x0300000300020002), ABC_CONST(0x0300000003020002), ABC_CONST(0x0300000000020002) },
    { ABC_CONST(0x0404040404030103), ABC_CONST(0x0404040400030103), ABC_CONST(0x0404040004030103), ABC_CONST(0x0404040000030103), ABC_CONST(0x0404000404030103), ABC_CONST(0x0404000400030103), ABC_CONST(0x0404000004030103), ABC_CONST(0x0404000000030103), ABC_CONST(0x0400040404030103), ABC_CONST(0x0400040400030103), ABC_CONST(0x0400040004030103), ABC_CONST(0x0400040000030103), ABC_CONST(0x0400000404030103), ABC_CONST(0x0400000400030103), ABC_CONST(0x0400000004030103), ABC_CONST(0x0400000000030103), ABC_CONST(0x0404040404030103), ABC_CONST(0x0404040400030103), ABC_CONST(0x0404040004030103), ABC_CONST(0x0404040000030103), ABC_CONST(0x0404000404030103), ABC_CONST(0x0404000400030103), ABC_CONST(0x0404000004030103), ABC_CONST(0x0404000000030103), ABC_CONST(0x0400040404030103), ABC_CONST(0x0400040400030103), ABC_CONST(0x0400040004030103), ABC_CONST(0x0400040000030103), ABC_CONST(0x0400000404030103), ABC_CONST(0x0400000400030103), ABC_CONST(0x0400000004030103), ABC_CONST(0x0400000000030103) },
    { ABC_CONST(0x0404040404030102), ABC_CONST(0x0404040400030102), ABC_CONST(0x0404040004030102), ABC_CONST(0x0404040000030102), ABC_CONST(0x0404000404030102), ABC_CONST(0x0404000400030102), ABC_CONST(0x0404000004030102), ABC_CONST(0x0404000000030102), ABC_CONST(0x0400040404030102), ABC_CONST(0x0400040400030102), ABC_CONST(0x0400040004030102), ABC_CONST(0x0400040000030102), ABC_CONST(0x0400000404030102), ABC_CONST(0x0400000400030102), ABC_CONST(0x0400000004030102), ABC_CONST(0x0400000000030102), ABC_CONST(0x0404040404030102), ABC_CONST(0x0404040400030102), ABC_CONST(0x0404040004030102), ABC_CONST(0x0404040000030102), ABC_CONST(0x0404000404030102), ABC_CONST(0x0404000400030102), ABC_CONST(0x0404000004030102), ABC_CONST(0x0404000000030102), ABC_CONST(0x0400040404030102), ABC_CONST(0x0400040400030102), ABC_CONST(0x0400040004030102), ABC_CONST(0x0400040000030102), ABC_CONST(0x0400000404030102), ABC_CONST(0x0400000400030102), ABC_CONST(0x0400000004030102), ABC_CONST(0x0400000000030102) },
    { ABC_CONST(0x0505050505040203), ABC_CONST(0x0505050500040203), ABC_CONST(0x0505050005040203), ABC_CONST(0x0505050000040203), ABC_CONST(0x0505000505040203), ABC_CONST(0x0505000500040203), ABC_CONST(0x0505000005040203), ABC_CONST(0x0505000000040203), ABC_CONST(0x0500050505040203), ABC_CONST(0x0500050500040203), ABC_CONST(0x0500050005040203), ABC_CONST(0x0500050000040203), ABC_CONST(0x0500000505040203), ABC_CONST(0x0500000500040203), ABC_CONST(0x0500000005040203), ABC_CONST(0x0500000000040203), ABC_CONST(0x0505050505040203), ABC_CONST(0x0505050500040203), ABC_CONST(0x0505050005040203), ABC_CONST(0x0505050000040203), ABC_CONST(0x0505000505040203), ABC_CONST(0x0505000500040203), ABC_CONST(0x0505000005040203), ABC_CONST(0x0505000000040203), ABC_CONST(0x0500050505040203), ABC_CONST(0x0500050500040203), ABC_CONST(0x0500050005040203), ABC_CONST(0x0500050000040203), ABC_CONST(0x0500000505040203), ABC_CONST(0x0500000500040203), ABC_CONST(0x0500000005040203), ABC_CONST(0x0500000000040203) },
    { ABC_CONST(0x0202020202000102), ABC_CONST(0x0202020200000102), ABC_CONST(0x0202020002000102), ABC_CONST(0x0202020000000102), ABC_CONST(0x0202000202000102), ABC_CONST(0x0202000200000102), ABC_CONST(0x0202000002000102), ABC_CONST(0x0202000000000102), ABC_CONST(0x0200020202000102), ABC_CONST(0x0200020200000102), ABC_CONST(0x0200020002000102), ABC_CONST(0x0200020000000102), ABC_CONST(0x0200000202000102), ABC_CONST(0x0200000200000102), ABC_CONST(0x0200000002000102), ABC_CONST(0x0200000000000102), ABC_CONST(0x0202020202000102), ABC_CONST(0x0202020200000102), ABC_CONST(0x0202020002000102), ABC_CONST(0x0202020000000102), ABC_CONST(0x0202000202000102), ABC_CONST(0x0202000200000102), ABC_CONST(0x0202000002000102), ABC_CONST(0x0202000000000102), ABC_CONST(0x0200020202000102), ABC_CONST(0x0200020200000102), ABC_CONST(0x0200020002000102), ABC_CONST(0x0200020000000102), ABC_CONST(0x0200000202000102), ABC_CONST(0x0200000200000102), ABC_CONST(0x0200000002000102), ABC_CONST(0x0200000000000102) },
    { ABC_CONST(0x0303030303010203), ABC_CONST(0x0303030300010203), ABC_CONST(0x0303030003010203), ABC_CONST(0x0303030000010203), ABC_CONST(0x0303000303010203), ABC_CONST(0x0303000300010203), ABC_CONST(0x0303000003010203), ABC_CONST(0x0303000000010203), ABC_CONST(0x0300030303010203), ABC_CONST(0x0300030300010203), ABC_CONST(0x0300030003010203), ABC_CONST(0x0300030000010203), ABC_CONST(0x0300000303010203), ABC_CONST(0x0300000300010203), ABC_CONST(0x0300000003010203), ABC_CONST(0x0300000000010203), ABC_CONST(0x0303030303010203), ABC_CONST(0x0303030300010203), ABC_CONST(0x0303030003010203), ABC_CONST(0x0303030000010203), ABC_CONST(0x0303000303010203), ABC_CONST(0x0303000300010203), ABC_CONST(0x0303000003010203), ABC_CONST(0x0303000000010203), ABC_CONST(0x0300030303010203), ABC_CONST(0x0300030300010203), ABC_CONST(0x0300030003010203), ABC_CONST(0x0300030000010203), ABC_CONST(0x0300000303010203), ABC_CONST(0x0300000300010203), ABC_CONST(0x0300000003010203), ABC_CONST(0x0300000000010203) },
    { ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202), ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202) },
    { ABC_CONST(0x0404040404020303), ABC_CONST(0x0404040400020303), ABC_CONST(0x0404040004020303), ABC_CONST(0x0404040000020303), ABC_CONST(0x0404000404020303), ABC_CONST(0x0404000400020303), ABC_CONST(0x0404000004020303), ABC_CONST(0x0404000000020303), ABC_CONST(0x0400040404020303), ABC_CONST(0x0400040400020303), ABC_CONST(0x0400040004020303), ABC_CONST(0x0400040000020303), ABC_CONST(0x0400000404020303), ABC_CONST(0x0400000400020303), ABC_CONST(0x0400000004020303), ABC_CONST(0x0400000000020303), ABC_CONST(0x0404040404020303), ABC_CONST(0x0404040400020303), ABC_CONST(0x0404040004020303), ABC_CONST(0x0404040000020303), ABC_CONST(0x0404000404020303), ABC_CONST(0x0404000400020303), ABC_CONST(0x0404000004020303), ABC_CONST(0x0404000000020303), ABC_CONST(0x0400040404020303), ABC_CONST(0x0400040400020303), ABC_CONST(0x0400040004020303), ABC_CONST(0x0400040000020303), ABC_CONST(0x0400000404020303), ABC_CONST(0x0400000400020303), ABC_CONST(0x0400000004020303), ABC_CONST(0x0400000000020303) },
    { ABC_CONST(0x0303030303010103), ABC_CONST(0x0303030300010103), ABC_CONST(0x0303030003010103), ABC_CONST(0x0303030000010103), ABC_CONST(0x0303000303010103), ABC_CONST(0x0303000300010103), ABC_CONST(0x0303000003010103), ABC_CONST(0x0303000000010103), ABC_CONST(0x0300030303010103), ABC_CONST(0x0300030300010103), ABC_CONST(0x0300030003010103), ABC_CONST(0x0300030000010103), ABC_CONST(0x0300000303010103), ABC_CONST(0x0300000300010103), ABC_CONST(0x0300000003010103), ABC_CONST(0x0300000000010103), ABC_CONST(0x0303030303010103), ABC_CONST(0x0303030300010103), ABC_CONST(0x0303030003010103), ABC_CONST(0x0303030000010103), ABC_CONST(0x0303000303010103), ABC_CONST(0x0303000300010103), ABC_CONST(0x0303000003010103), ABC_CONST(0x0303000000010103), ABC_CONST(0x0300030303010103), ABC_CONST(0x0300030300010103), ABC_CONST(0x0300030003010103), ABC_CONST(0x0300030000010103), ABC_CONST(0x0300000303010103), ABC_CONST(0x0300000300010103), ABC_CONST(0x0300000003010103), ABC_CONST(0x0300000000010103) },
    { ABC_CONST(0x0404040404020204), ABC_CONST(0x0404040400020204), ABC_CONST(0x0404040004020204), ABC_CONST(0x0404040000020204), ABC_CONST(0x0404000404020204), ABC_CONST(0x0404000400020204), ABC_CONST(0x0404000004020204), ABC_CONST(0x0404000000020204), ABC_CONST(0x0400040404020204), ABC_CONST(0x0400040400020204), ABC_CONST(0x0400040004020204), ABC_CONST(0x0400040000020204), ABC_CONST(0x0400000404020204), ABC_CONST(0x0400000400020204), ABC_CONST(0x0400000004020204), ABC_CONST(0x0400000000020204), ABC_CONST(0x0404040404020204), ABC_CONST(0x0404040400020204), ABC_CONST(0x0404040004020204), ABC_CONST(0x0404040000020204), ABC_CONST(0x0404000404020204), ABC_CONST(0x0404000400020204), ABC_CONST(0x0404000004020204), ABC_CONST(0x0404000000020204), ABC_CONST(0x0400040404020204), ABC_CONST(0x0400040400020204), ABC_CONST(0x0400040004020204), ABC_CONST(0x0400040000020204), ABC_CONST(0x0400000404020204), ABC_CONST(0x0400000400020204), ABC_CONST(0x0400000004020204), ABC_CONST(0x0400000000020204) },
    { ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203), ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203) },
    { ABC_CONST(0x0505050505030304), ABC_CONST(0x0505050500030304), ABC_CONST(0x0505050005030304), ABC_CONST(0x0505050000030304), ABC_CONST(0x0505000505030304), ABC_CONST(0x0505000500030304), ABC_CONST(0x0505000005030304), ABC_CONST(0x0505000000030304), ABC_CONST(0x0500050505030304), ABC_CONST(0x0500050500030304), ABC_CONST(0x0500050005030304), ABC_CONST(0x0500050000030304), ABC_CONST(0x0500000505030304), ABC_CONST(0x0500000500030304), ABC_CONST(0x0500000005030304), ABC_CONST(0x0500000000030304), ABC_CONST(0x0505050505030304), ABC_CONST(0x0505050500030304), ABC_CONST(0x0505050005030304), ABC_CONST(0x0505050000030304), ABC_CONST(0x0505000505030304), ABC_CONST(0x0505000500030304), ABC_CONST(0x0505000005030304), ABC_CONST(0x0505000000030304), ABC_CONST(0x0500050505030304), ABC_CONST(0x0500050500030304), ABC_CONST(0x0500050005030304), ABC_CONST(0x0500050000030304), ABC_CONST(0x0500000505030304), ABC_CONST(0x0500000500030304), ABC_CONST(0x0500000005030304), ABC_CONST(0x0500000000030304) },
    { ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102), ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102) },
    { ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203), ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303), ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303) },
    { ABC_CONST(0x0404040404020103), ABC_CONST(0x0404040400020103), ABC_CONST(0x0404040004020103), ABC_CONST(0x0404040000020103), ABC_CONST(0x0404000404020103), ABC_CONST(0x0404000400020103), ABC_CONST(0x0404000004020103), ABC_CONST(0x0404000000020103), ABC_CONST(0x0400040404020103), ABC_CONST(0x0400040400020103), ABC_CONST(0x0400040004020103), ABC_CONST(0x0400040000020103), ABC_CONST(0x0400000404020103), ABC_CONST(0x0400000400020103), ABC_CONST(0x0400000004020103), ABC_CONST(0x0400000000020103), ABC_CONST(0x0404040404020103), ABC_CONST(0x0404040400020103), ABC_CONST(0x0404040004020103), ABC_CONST(0x0404040000020103), ABC_CONST(0x0404000404020103), ABC_CONST(0x0404000400020103), ABC_CONST(0x0404000004020103), ABC_CONST(0x0404000000020103), ABC_CONST(0x0400040404020103), ABC_CONST(0x0400040400020103), ABC_CONST(0x0400040004020103), ABC_CONST(0x0400040000020103), ABC_CONST(0x0400000404020103), ABC_CONST(0x0400000400020103), ABC_CONST(0x0400000004020103), ABC_CONST(0x0400000000020103) },
    { ABC_CONST(0x0505050505030204), ABC_CONST(0x0505050500030204), ABC_CONST(0x0505050005030204), ABC_CONST(0x0505050000030204), ABC_CONST(0x0505000505030204), ABC_CONST(0x0505000500030204), ABC_CONST(0x0505000005030204), ABC_CONST(0x0505000000030204), ABC_CONST(0x0500050505030204), ABC_CONST(0x0500050500030204), ABC_CONST(0x0500050005030204), ABC_CONST(0x0500050000030204), ABC_CONST(0x0500000505030204), ABC_CONST(0x0500000500030204), ABC_CONST(0x0500000005030204), ABC_CONST(0x0500000000030204), ABC_CONST(0x0505050505030204), ABC_CONST(0x0505050500030204), ABC_CONST(0x0505050005030204), ABC_CONST(0x0505050000030204), ABC_CONST(0x0505000505030204), ABC_CONST(0x0505000500030204), ABC_CONST(0x0505000005030204), ABC_CONST(0x0505000000030204), ABC_CONST(0x0500050505030204), ABC_CONST(0x0500050500030204), ABC_CONST(0x0500050005030204), ABC_CONST(0x0500050000030204), ABC_CONST(0x0500000505030204), ABC_CONST(0x0500000500030204), ABC_CONST(0x0500000005030204), ABC_CONST(0x0500000000030204) },
    { ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203), ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203) },
    { ABC_CONST(0x0606060606040304), ABC_CONST(0x0606060600040304), ABC_CONST(0x0606060006040304), ABC_CONST(0x0606060000040304), ABC_CONST(0x0606000606040304), ABC_CONST(0x0606000600040304), ABC_CONST(0x0606000006040304), ABC_CONST(0x0606000000040304), ABC_CONST(0x0600060606040304), ABC_CONST(0x0600060600040304), ABC_CONST(0x0600060006040304), ABC_CONST(0x0600060000040304), ABC_CONST(0x0600000606040304), ABC_CONST(0x0600000600040304), ABC_CONST(0x0600000006040304), ABC_CONST(0x0600000000040304), ABC_CONST(0x0606060606040304), ABC_CONST(0x0606060600040304), ABC_CONST(0x0606060006040304), ABC_CONST(0x0606060000040304), ABC_CONST(0x0606000606040304), ABC_CONST(0x0606000600040304), ABC_CONST(0x0606000006040304), ABC_CONST(0x0606000000040304), ABC_CONST(0x0600060606040304), ABC_CONST(0x0600060600040304), ABC_CONST(0x0600060006040304), ABC_CONST(0x0600060000040304), ABC_CONST(0x0600000606040304), ABC_CONST(0x0600000600040304), ABC_CONST(0x0600000006040304), ABC_CONST(0x0600000000040304) },
    { ABC_CONST(0x0202020202000101), ABC_CONST(0x0202020200000101), ABC_CONST(0x0202020002000101), ABC_CONST(0x0202020000000101), ABC_CONST(0x0202000202000101), ABC_CONST(0x0202000200000101), ABC_CONST(0x0202000002000101), ABC_CONST(0x0202000000000101), ABC_CONST(0x0200020202000101), ABC_CONST(0x0200020200000101), ABC_CONST(0x0200020002000101), ABC_CONST(0x0200020000000101), ABC_CONST(0x0200000202000101), ABC_CONST(0x0200000200000101), ABC_CONST(0x0200000002000101), ABC_CONST(0x0200000000000101), ABC_CONST(0x0202020202000101), ABC_CONST(0x0202020200000101), ABC_CONST(0x0202020002000101), ABC_CONST(0x0202020000000101), ABC_CONST(0x0202000202000101), ABC_CONST(0x0202000200000101), ABC_CONST(0x0202000002000101), ABC_CONST(0x0202000000000101), ABC_CONST(0x0200020202000101), ABC_CONST(0x0200020200000101), ABC_CONST(0x0200020002000101), ABC_CONST(0x0200020000000101), ABC_CONST(0x0200000202000101), ABC_CONST(0x0200000200000101), ABC_CONST(0x0200000002000101), ABC_CONST(0x0200000000000101) },
    { ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202), ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202) },
    { ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201), ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201) },
    { ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302), ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302) },
    { ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102), ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102) },
    { ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203), ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303), ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303) },
    { ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101), ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201), ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201) },
    { ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302), ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302) },
    { ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102), ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102) },
    { ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203), ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203) },
    { ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202), ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202) },
    { ABC_CONST(0x0606060606040303), ABC_CONST(0x0606060600040303), ABC_CONST(0x0606060006040303), ABC_CONST(0x0606060000040303), ABC_CONST(0x0606000606040303), ABC_CONST(0x0606000600040303), ABC_CONST(0x0606000006040303), ABC_CONST(0x0606000000040303), ABC_CONST(0x0600060606040303), ABC_CONST(0x0600060600040303), ABC_CONST(0x0600060006040303), ABC_CONST(0x0600060000040303), ABC_CONST(0x0600000606040303), ABC_CONST(0x0600000600040303), ABC_CONST(0x0600000006040303), ABC_CONST(0x0600000000040303), ABC_CONST(0x0606060606040303), ABC_CONST(0x0606060600040303), ABC_CONST(0x0606060006040303), ABC_CONST(0x0606060000040303), ABC_CONST(0x0606000606040303), ABC_CONST(0x0606000600040303), ABC_CONST(0x0606000006040303), ABC_CONST(0x0606000000040303), ABC_CONST(0x0600060606040303), ABC_CONST(0x0600060600040303), ABC_CONST(0x0600060006040303), ABC_CONST(0x0600060000040303), ABC_CONST(0x0600000606040303), ABC_CONST(0x0600000600040303), ABC_CONST(0x0600000006040303), ABC_CONST(0x0600000000040303) },
    { ABC_CONST(0x0303030303000202), ABC_CONST(0x0303030300000202), ABC_CONST(0x0303030003000202), ABC_CONST(0x0303030000000202), ABC_CONST(0x0303000303000202), ABC_CONST(0x0303000300000202), ABC_CONST(0x0303000003000202), ABC_CONST(0x0303000000000202), ABC_CONST(0x0300030303000202), ABC_CONST(0x0300030300000202), ABC_CONST(0x0300030003000202), ABC_CONST(0x0300030000000202), ABC_CONST(0x0300000303000202), ABC_CONST(0x0300000300000202), ABC_CONST(0x0300000003000202), ABC_CONST(0x0300000000000202), ABC_CONST(0x0303030303000202), ABC_CONST(0x0303030300000202), ABC_CONST(0x0303030003000202), ABC_CONST(0x0303030000000202), ABC_CONST(0x0303000303000202), ABC_CONST(0x0303000300000202), ABC_CONST(0x0303000003000202), ABC_CONST(0x0303000000000202), ABC_CONST(0x0300030303000202), ABC_CONST(0x0300030300000202), ABC_CONST(0x0300030003000202), ABC_CONST(0x0300030000000202), ABC_CONST(0x0300000303000202), ABC_CONST(0x0300000300000202), ABC_CONST(0x0300000003000202), ABC_CONST(0x0300000000000202) },
    { ABC_CONST(0x0404040404010303), ABC_CONST(0x0404040400010303), ABC_CONST(0x0404040004010303), ABC_CONST(0x0404040000010303), ABC_CONST(0x0404000404010303), ABC_CONST(0x0404000400010303), ABC_CONST(0x0404000004010303), ABC_CONST(0x0404000000010303), ABC_CONST(0x0400040404010303), ABC_CONST(0x0400040400010303), ABC_CONST(0x0400040004010303), ABC_CONST(0x0400040000010303), ABC_CONST(0x0400000404010303), ABC_CONST(0x0400000400010303), ABC_CONST(0x0400000004010303), ABC_CONST(0x0400000000010303), ABC_CONST(0x0404040404010303), ABC_CONST(0x0404040400010303), ABC_CONST(0x0404040004010303), ABC_CONST(0x0404040000010303), ABC_CONST(0x0404000404010303), ABC_CONST(0x0404000400010303), ABC_CONST(0x0404000004010303), ABC_CONST(0x0404000000010303), ABC_CONST(0x0400040404010303), ABC_CONST(0x0400040400010303), ABC_CONST(0x0400040004010303), ABC_CONST(0x0400040000010303), ABC_CONST(0x0400000404010303), ABC_CONST(0x0400000400010303), ABC_CONST(0x0400000004010303), ABC_CONST(0x0400000000010303) },
    { ABC_CONST(0x0404040404010302), ABC_CONST(0x0404040400010302), ABC_CONST(0x0404040004010302), ABC_CONST(0x0404040000010302), ABC_CONST(0x0404000404010302), ABC_CONST(0x0404000400010302), ABC_CONST(0x0404000004010302), ABC_CONST(0x0404000000010302), ABC_CONST(0x0400040404010302), ABC_CONST(0x0400040400010302), ABC_CONST(0x0400040004010302), ABC_CONST(0x0400040000010302), ABC_CONST(0x0400000404010302), ABC_CONST(0x0400000400010302), ABC_CONST(0x0400000004010302), ABC_CONST(0x0400000000010302), ABC_CONST(0x0404040404010302), ABC_CONST(0x0404040400010302), ABC_CONST(0x0404040004010302), ABC_CONST(0x0404040000010302), ABC_CONST(0x0404000404010302), ABC_CONST(0x0404000400010302), ABC_CONST(0x0404000004010302), ABC_CONST(0x0404000000010302), ABC_CONST(0x0400040404010302), ABC_CONST(0x0400040400010302), ABC_CONST(0x0400040004010302), ABC_CONST(0x0400040000010302), ABC_CONST(0x0400000404010302), ABC_CONST(0x0400000400010302), ABC_CONST(0x0400000004010302), ABC_CONST(0x0400000000010302) },
    { ABC_CONST(0x0505050505020403), ABC_CONST(0x0505050500020403), ABC_CONST(0x0505050005020403), ABC_CONST(0x0505050000020403), ABC_CONST(0x0505000505020403), ABC_CONST(0x0505000500020403), ABC_CONST(0x0505000005020403), ABC_CONST(0x0505000000020403), ABC_CONST(0x0500050505020403), ABC_CONST(0x0500050500020403), ABC_CONST(0x0500050005020403), ABC_CONST(0x0500050000020403), ABC_CONST(0x0500000505020403), ABC_CONST(0x0500000500020403), ABC_CONST(0x0500000005020403), ABC_CONST(0x0500000000020403), ABC_CONST(0x0505050505020403), ABC_CONST(0x0505050500020403), ABC_CONST(0x0505050005020403), ABC_CONST(0x0505050000020403), ABC_CONST(0x0505000505020403), ABC_CONST(0x0505000500020403), ABC_CONST(0x0505000005020403), ABC_CONST(0x0505000000020403), ABC_CONST(0x0500050505020403), ABC_CONST(0x0500050500020403), ABC_CONST(0x0500050005020403), ABC_CONST(0x0500050000020403), ABC_CONST(0x0500000505020403), ABC_CONST(0x0500000500020403), ABC_CONST(0x0500000005020403), ABC_CONST(0x0500000000020403) },
    { ABC_CONST(0x0404040404010203), ABC_CONST(0x0404040400010203), ABC_CONST(0x0404040004010203), ABC_CONST(0x0404040000010203), ABC_CONST(0x0404000404010203), ABC_CONST(0x0404000400010203), ABC_CONST(0x0404000004010203), ABC_CONST(0x0404000000010203), ABC_CONST(0x0400040404010203), ABC_CONST(0x0400040400010203), ABC_CONST(0x0400040004010203), ABC_CONST(0x0400040000010203), ABC_CONST(0x0400000404010203), ABC_CONST(0x0400000400010203), ABC_CONST(0x0400000004010203), ABC_CONST(0x0400000000010203), ABC_CONST(0x0404040404010203), ABC_CONST(0x0404040400010203), ABC_CONST(0x0404040004010203), ABC_CONST(0x0404040000010203), ABC_CONST(0x0404000404010203), ABC_CONST(0x0404000400010203), ABC_CONST(0x0404000004010203), ABC_CONST(0x0404000000010203), ABC_CONST(0x0400040404010203), ABC_CONST(0x0400040400010203), ABC_CONST(0x0400040004010203), ABC_CONST(0x0400040000010203), ABC_CONST(0x0400000404010203), ABC_CONST(0x0400000400010203), ABC_CONST(0x0400000004010203), ABC_CONST(0x0400000000010203) },
    { ABC_CONST(0x0505050505020304), ABC_CONST(0x0505050500020304), ABC_CONST(0x0505050005020304), ABC_CONST(0x0505050000020304), ABC_CONST(0x0505000505020304), ABC_CONST(0x0505000500020304), ABC_CONST(0x0505000005020304), ABC_CONST(0x0505000000020304), ABC_CONST(0x0500050505020304), ABC_CONST(0x0500050500020304), ABC_CONST(0x0500050005020304), ABC_CONST(0x0500050000020304), ABC_CONST(0x0500000505020304), ABC_CONST(0x0500000500020304), ABC_CONST(0x0500000005020304), ABC_CONST(0x0500000000020304), ABC_CONST(0x0505050505020304), ABC_CONST(0x0505050500020304), ABC_CONST(0x0505050005020304), ABC_CONST(0x0505050000020304), ABC_CONST(0x0505000505020304), ABC_CONST(0x0505000500020304), ABC_CONST(0x0505000005020304), ABC_CONST(0x0505000000020304), ABC_CONST(0x0500050505020304), ABC_CONST(0x0500050500020304), ABC_CONST(0x0500050005020304), ABC_CONST(0x0500050000020304), ABC_CONST(0x0500000505020304), ABC_CONST(0x0500000500020304), ABC_CONST(0x0500000005020304), ABC_CONST(0x0500000000020304) },
    { ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303), ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303) },
    { ABC_CONST(0x0606060606030404), ABC_CONST(0x0606060600030404), ABC_CONST(0x0606060006030404), ABC_CONST(0x0606060000030404), ABC_CONST(0x0606000606030404), ABC_CONST(0x0606000600030404), ABC_CONST(0x0606000006030404), ABC_CONST(0x0606000000030404), ABC_CONST(0x0600060606030404), ABC_CONST(0x0600060600030404), ABC_CONST(0x0600060006030404), ABC_CONST(0x0600060000030404), ABC_CONST(0x0600000606030404), ABC_CONST(0x0600000600030404), ABC_CONST(0x0600000006030404), ABC_CONST(0x0600000000030404), ABC_CONST(0x0606060606030404), ABC_CONST(0x0606060600030404), ABC_CONST(0x0606060006030404), ABC_CONST(0x0606060000030404), ABC_CONST(0x0606000606030404), ABC_CONST(0x0606000600030404), ABC_CONST(0x0606000006030404), ABC_CONST(0x0606000000030404), ABC_CONST(0x0600060606030404), ABC_CONST(0x0600060600030404), ABC_CONST(0x0600060006030404), ABC_CONST(0x0600060000030404), ABC_CONST(0x0600000606030404), ABC_CONST(0x0600000600030404), ABC_CONST(0x0600000006030404), ABC_CONST(0x0600000000030404) },
    { ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202), ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202) },
    { ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303), ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303) },
    { ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302), ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302) },
    { ABC_CONST(0x0606060606030403), ABC_CONST(0x0606060600030403), ABC_CONST(0x0606060006030403), ABC_CONST(0x0606060000030403), ABC_CONST(0x0606000606030403), ABC_CONST(0x0606000600030403), ABC_CONST(0x0606000006030403), ABC_CONST(0x0606000000030403), ABC_CONST(0x0600060606030403), ABC_CONST(0x0600060600030403), ABC_CONST(0x0600060006030403), ABC_CONST(0x0600060000030403), ABC_CONST(0x0600000606030403), ABC_CONST(0x0600000600030403), ABC_CONST(0x0600000006030403), ABC_CONST(0x0600000000030403), ABC_CONST(0x0606060606030403), ABC_CONST(0x0606060600030403), ABC_CONST(0x0606060006030403), ABC_CONST(0x0606060000030403), ABC_CONST(0x0606000606030403), ABC_CONST(0x0606000600030403), ABC_CONST(0x0606000006030403), ABC_CONST(0x0606000000030403), ABC_CONST(0x0600060606030403), ABC_CONST(0x0600060600030403), ABC_CONST(0x0600060006030403), ABC_CONST(0x0600060000030403), ABC_CONST(0x0600000606030403), ABC_CONST(0x0600000600030403), ABC_CONST(0x0600000006030403), ABC_CONST(0x0600000000030403) },
    { ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203), ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203) },
    { ABC_CONST(0x0606060606030304), ABC_CONST(0x0606060600030304), ABC_CONST(0x0606060006030304), ABC_CONST(0x0606060000030304), ABC_CONST(0x0606000606030304), ABC_CONST(0x0606000600030304), ABC_CONST(0x0606000006030304), ABC_CONST(0x0606000000030304), ABC_CONST(0x0600060606030304), ABC_CONST(0x0600060600030304), ABC_CONST(0x0600060006030304), ABC_CONST(0x0600060000030304), ABC_CONST(0x0600000606030304), ABC_CONST(0x0600000600030304), ABC_CONST(0x0600000006030304), ABC_CONST(0x0600000000030304), ABC_CONST(0x0606060606030304), ABC_CONST(0x0606060600030304), ABC_CONST(0x0606060006030304), ABC_CONST(0x0606060000030304), ABC_CONST(0x0606000606030304), ABC_CONST(0x0606000600030304), ABC_CONST(0x0606000006030304), ABC_CONST(0x0606000000030304), ABC_CONST(0x0600060606030304), ABC_CONST(0x0600060600030304), ABC_CONST(0x0600060006030304), ABC_CONST(0x0600060000030304), ABC_CONST(0x0600000606030304), ABC_CONST(0x0600000600030304), ABC_CONST(0x0600000006030304), ABC_CONST(0x0600000000030304) },
    { ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303), ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303) },
    { ABC_CONST(0x0707070707040404), ABC_CONST(0x0707070700040404), ABC_CONST(0x0707070007040404), ABC_CONST(0x0707070000040404), ABC_CONST(0x0707000707040404), ABC_CONST(0x0707000700040404), ABC_CONST(0x0707000007040404), ABC_CONST(0x0707000000040404), ABC_CONST(0x0700070707040404), ABC_CONST(0x0700070700040404), ABC_CONST(0x0700070007040404), ABC_CONST(0x0700070000040404), ABC_CONST(0x0700000707040404), ABC_CONST(0x0700000700040404), ABC_CONST(0x0700000007040404), ABC_CONST(0x0700000000040404), ABC_CONST(0x0707070707040404), ABC_CONST(0x0707070700040404), ABC_CONST(0x0707070007040404), ABC_CONST(0x0707070000040404), ABC_CONST(0x0707000707040404), ABC_CONST(0x0707000700040404), ABC_CONST(0x0707000007040404), ABC_CONST(0x0707000000040404), ABC_CONST(0x0700070707040404), ABC_CONST(0x0700070700040404), ABC_CONST(0x0700070007040404), ABC_CONST(0x0700070000040404), ABC_CONST(0x0700000707040404), ABC_CONST(0x0700000700040404), ABC_CONST(0x0700000007040404), ABC_CONST(0x0700000000040404) },
    { ABC_CONST(0x0101010101000000), ABC_CONST(0x0101010100000000), ABC_CONST(0x0101010001000000), ABC_CONST(0x0101010000000000), ABC_CONST(0x0101000101000000), ABC_CONST(0x0101000100000000), ABC_CONST(0x0101000001000000), ABC_CONST(0x0101000000000000), ABC_CONST(0x0100010101000000), ABC_CONST(0x0100010100000000), ABC_CONST(0x0100010001000000), ABC_CONST(0x0100010000000000), ABC_CONST(0x0100000101000000), ABC_CONST(0x0100000100000000), ABC_CONST(0x0100000001000000), ABC_CONST(0x0100000000000000), ABC_CONST(0x0101010101000000), ABC_CONST(0x0101010100000000), ABC_CONST(0x0101010001000000), ABC_CONST(0x0101010000000000), ABC_CONST(0x0101000101000000), ABC_CONST(0x0101000100000000), ABC_CONST(0x0101000001000000), ABC_CONST(0x0101000000000000), ABC_CONST(0x0100010101000000), ABC_CONST(0x0100010100000000), ABC_CONST(0x0100010001000000), ABC_CONST(0x0100010000000000), ABC_CONST(0x0100000101000000), ABC_CONST(0x0100000100000000), ABC_CONST(0x0100000001000000), ABC_CONST(0x0100000000000000) },
    { ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101), ABC_CONST(0x0202020202010101), ABC_CONST(0x0202020200010101), ABC_CONST(0x0202020002010101), ABC_CONST(0x0202020000010101), ABC_CONST(0x0202000202010101), ABC_CONST(0x0202000200010101), ABC_CONST(0x0202000002010101), ABC_CONST(0x0202000000010101), ABC_CONST(0x0200020202010101), ABC_CONST(0x0200020200010101), ABC_CONST(0x0200020002010101), ABC_CONST(0x0200020000010101), ABC_CONST(0x0200000202010101), ABC_CONST(0x0200000200010101), ABC_CONST(0x0200000002010101), ABC_CONST(0x0200000000010101) },
    { ABC_CONST(0x0202020202010100), ABC_CONST(0x0202020200010100), ABC_CONST(0x0202020002010100), ABC_CONST(0x0202020000010100), ABC_CONST(0x0202000202010100), ABC_CONST(0x0202000200010100), ABC_CONST(0x0202000002010100), ABC_CONST(0x0202000000010100), ABC_CONST(0x0200020202010100), ABC_CONST(0x0200020200010100), ABC_CONST(0x0200020002010100), ABC_CONST(0x0200020000010100), ABC_CONST(0x0200000202010100), ABC_CONST(0x0200000200010100), ABC_CONST(0x0200000002010100), ABC_CONST(0x0200000000010100), ABC_CONST(0x0202020202010100), ABC_CONST(0x0202020200010100), ABC_CONST(0x0202020002010100), ABC_CONST(0x0202020000010100), ABC_CONST(0x0202000202010100), ABC_CONST(0x0202000200010100), ABC_CONST(0x0202000002010100), ABC_CONST(0x0202000000010100), ABC_CONST(0x0200020202010100), ABC_CONST(0x0200020200010100), ABC_CONST(0x0200020002010100), ABC_CONST(0x0200020000010100), ABC_CONST(0x0200000202010100), ABC_CONST(0x0200000200010100), ABC_CONST(0x0200000002010100), ABC_CONST(0x0200000000010100) },
    { ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201), ABC_CONST(0x0303030303020201), ABC_CONST(0x0303030300020201), ABC_CONST(0x0303030003020201), ABC_CONST(0x0303030000020201), ABC_CONST(0x0303000303020201), ABC_CONST(0x0303000300020201), ABC_CONST(0x0303000003020201), ABC_CONST(0x0303000000020201), ABC_CONST(0x0300030303020201), ABC_CONST(0x0300030300020201), ABC_CONST(0x0300030003020201), ABC_CONST(0x0300030000020201), ABC_CONST(0x0300000303020201), ABC_CONST(0x0300000300020201), ABC_CONST(0x0300000003020201), ABC_CONST(0x0300000000020201) },
    { ABC_CONST(0x0202020202010001), ABC_CONST(0x0202020200010001), ABC_CONST(0x0202020002010001), ABC_CONST(0x0202020000010001), ABC_CONST(0x0202000202010001), ABC_CONST(0x0202000200010001), ABC_CONST(0x0202000002010001), ABC_CONST(0x0202000000010001), ABC_CONST(0x0200020202010001), ABC_CONST(0x0200020200010001), ABC_CONST(0x0200020002010001), ABC_CONST(0x0200020000010001), ABC_CONST(0x0200000202010001), ABC_CONST(0x0200000200010001), ABC_CONST(0x0200000002010001), ABC_CONST(0x0200000000010001), ABC_CONST(0x0202020202010001), ABC_CONST(0x0202020200010001), ABC_CONST(0x0202020002010001), ABC_CONST(0x0202020000010001), ABC_CONST(0x0202000202010001), ABC_CONST(0x0202000200010001), ABC_CONST(0x0202000002010001), ABC_CONST(0x0202000000010001), ABC_CONST(0x0200020202010001), ABC_CONST(0x0200020200010001), ABC_CONST(0x0200020002010001), ABC_CONST(0x0200020000010001), ABC_CONST(0x0200000202010001), ABC_CONST(0x0200000200010001), ABC_CONST(0x0200000002010001), ABC_CONST(0x0200000000010001) },
    { ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102), ABC_CONST(0x0303030303020102), ABC_CONST(0x0303030300020102), ABC_CONST(0x0303030003020102), ABC_CONST(0x0303030000020102), ABC_CONST(0x0303000303020102), ABC_CONST(0x0303000300020102), ABC_CONST(0x0303000003020102), ABC_CONST(0x0303000000020102), ABC_CONST(0x0300030303020102), ABC_CONST(0x0300030300020102), ABC_CONST(0x0300030003020102), ABC_CONST(0x0300030000020102), ABC_CONST(0x0300000303020102), ABC_CONST(0x0300000300020102), ABC_CONST(0x0300000003020102), ABC_CONST(0x0300000000020102) },
    { ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101), ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101) },
    { ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202), ABC_CONST(0x0404040404030202), ABC_CONST(0x0404040400030202), ABC_CONST(0x0404040004030202), ABC_CONST(0x0404040000030202), ABC_CONST(0x0404000404030202), ABC_CONST(0x0404000400030202), ABC_CONST(0x0404000004030202), ABC_CONST(0x0404000000030202), ABC_CONST(0x0400040404030202), ABC_CONST(0x0400040400030202), ABC_CONST(0x0400040004030202), ABC_CONST(0x0400040000030202), ABC_CONST(0x0400000404030202), ABC_CONST(0x0400000400030202), ABC_CONST(0x0400000004030202), ABC_CONST(0x0400000000030202) },
    { ABC_CONST(0x0202020202010000), ABC_CONST(0x0202020200010000), ABC_CONST(0x0202020002010000), ABC_CONST(0x0202020000010000), ABC_CONST(0x0202000202010000), ABC_CONST(0x0202000200010000), ABC_CONST(0x0202000002010000), ABC_CONST(0x0202000000010000), ABC_CONST(0x0200020202010000), ABC_CONST(0x0200020200010000), ABC_CONST(0x0200020002010000), ABC_CONST(0x0200020000010000), ABC_CONST(0x0200000202010000), ABC_CONST(0x0200000200010000), ABC_CONST(0x0200000002010000), ABC_CONST(0x0200000000010000), ABC_CONST(0x0202020202010000), ABC_CONST(0x0202020200010000), ABC_CONST(0x0202020002010000), ABC_CONST(0x0202020000010000), ABC_CONST(0x0202000202010000), ABC_CONST(0x0202000200010000), ABC_CONST(0x0202000002010000), ABC_CONST(0x0202000000010000), ABC_CONST(0x0200020202010000), ABC_CONST(0x0200020200010000), ABC_CONST(0x0200020002010000), ABC_CONST(0x0200020000010000), ABC_CONST(0x0200000202010000), ABC_CONST(0x0200000200010000), ABC_CONST(0x0200000002010000), ABC_CONST(0x0200000000010000) },
    { ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101), ABC_CONST(0x0303030303020101), ABC_CONST(0x0303030300020101), ABC_CONST(0x0303030003020101), ABC_CONST(0x0303030000020101), ABC_CONST(0x0303000303020101), ABC_CONST(0x0303000300020101), ABC_CONST(0x0303000003020101), ABC_CONST(0x0303000000020101), ABC_CONST(0x0300030303020101), ABC_CONST(0x0300030300020101), ABC_CONST(0x0300030003020101), ABC_CONST(0x0300030000020101), ABC_CONST(0x0300000303020101), ABC_CONST(0x0300000300020101), ABC_CONST(0x0300000003020101), ABC_CONST(0x0300000000020101) },
    { ABC_CONST(0x0303030303020100), ABC_CONST(0x0303030300020100), ABC_CONST(0x0303030003020100), ABC_CONST(0x0303030000020100), ABC_CONST(0x0303000303020100), ABC_CONST(0x0303000300020100), ABC_CONST(0x0303000003020100), ABC_CONST(0x0303000000020100), ABC_CONST(0x0300030303020100), ABC_CONST(0x0300030300020100), ABC_CONST(0x0300030003020100), ABC_CONST(0x0300030000020100), ABC_CONST(0x0300000303020100), ABC_CONST(0x0300000300020100), ABC_CONST(0x0300000003020100), ABC_CONST(0x0300000000020100), ABC_CONST(0x0303030303020100), ABC_CONST(0x0303030300020100), ABC_CONST(0x0303030003020100), ABC_CONST(0x0303030000020100), ABC_CONST(0x0303000303020100), ABC_CONST(0x0303000300020100), ABC_CONST(0x0303000003020100), ABC_CONST(0x0303000000020100), ABC_CONST(0x0300030303020100), ABC_CONST(0x0300030300020100), ABC_CONST(0x0300030003020100), ABC_CONST(0x0300030000020100), ABC_CONST(0x0300000303020100), ABC_CONST(0x0300000300020100), ABC_CONST(0x0300000003020100), ABC_CONST(0x0300000000020100) },
    { ABC_CONST(0x0404040404030201), ABC_CONST(0x0404040400030201), ABC_CONST(0x0404040004030201), ABC_CONST(0x0404040000030201), ABC_CONST(0x0404000404030201), ABC_CONST(0x0404000400030201), ABC_CONST(0x0404000004030201), ABC_CONST(0x0404000000030201), ABC_CONST(0x0400040404030201), ABC_CONST(0x0400040400030201), ABC_CONST(0x0400040004030201), ABC_CONST(0x0400040000030201), ABC_CONST(0x0400000404030201), ABC_CONST(0x0400000400030201), ABC_CONST(0x0400000004030201), ABC_CONST(0x0400000000030201), ABC_CONST(0x0404040404030201), ABC_CONST(0x0404040400030201), ABC_CONST(0x0404040004030201), ABC_CONST(0x0404040000030201), ABC_CONST(0x0404000404030201), ABC_CONST(0x0404000400030201), ABC_CONST(0x0404000004030201), ABC_CONST(0x0404000000030201), ABC_CONST(0x0400040404030201), ABC_CONST(0x0400040400030201), ABC_CONST(0x0400040004030201), ABC_CONST(0x0400040000030201), ABC_CONST(0x0400000404030201), ABC_CONST(0x0400000400030201), ABC_CONST(0x0400000004030201), ABC_CONST(0x0400000000030201) },
    { ABC_CONST(0x0303030303020001), ABC_CONST(0x0303030300020001), ABC_CONST(0x0303030003020001), ABC_CONST(0x0303030000020001), ABC_CONST(0x0303000303020001), ABC_CONST(0x0303000300020001), ABC_CONST(0x0303000003020001), ABC_CONST(0x0303000000020001), ABC_CONST(0x0300030303020001), ABC_CONST(0x0300030300020001), ABC_CONST(0x0300030003020001), ABC_CONST(0x0300030000020001), ABC_CONST(0x0300000303020001), ABC_CONST(0x0300000300020001), ABC_CONST(0x0300000003020001), ABC_CONST(0x0300000000020001), ABC_CONST(0x0303030303020001), ABC_CONST(0x0303030300020001), ABC_CONST(0x0303030003020001), ABC_CONST(0x0303030000020001), ABC_CONST(0x0303000303020001), ABC_CONST(0x0303000300020001), ABC_CONST(0x0303000003020001), ABC_CONST(0x0303000000020001), ABC_CONST(0x0300030303020001), ABC_CONST(0x0300030300020001), ABC_CONST(0x0300030003020001), ABC_CONST(0x0300030000020001), ABC_CONST(0x0300000303020001), ABC_CONST(0x0300000300020001), ABC_CONST(0x0300000003020001), ABC_CONST(0x0300000000020001) },
    { ABC_CONST(0x0404040404030102), ABC_CONST(0x0404040400030102), ABC_CONST(0x0404040004030102), ABC_CONST(0x0404040000030102), ABC_CONST(0x0404000404030102), ABC_CONST(0x0404000400030102), ABC_CONST(0x0404000004030102), ABC_CONST(0x0404000000030102), ABC_CONST(0x0400040404030102), ABC_CONST(0x0400040400030102), ABC_CONST(0x0400040004030102), ABC_CONST(0x0400040000030102), ABC_CONST(0x0400000404030102), ABC_CONST(0x0400000400030102), ABC_CONST(0x0400000004030102), ABC_CONST(0x0400000000030102), ABC_CONST(0x0404040404030102), ABC_CONST(0x0404040400030102), ABC_CONST(0x0404040004030102), ABC_CONST(0x0404040000030102), ABC_CONST(0x0404000404030102), ABC_CONST(0x0404000400030102), ABC_CONST(0x0404000004030102), ABC_CONST(0x0404000000030102), ABC_CONST(0x0400040404030102), ABC_CONST(0x0400040400030102), ABC_CONST(0x0400040004030102), ABC_CONST(0x0400040000030102), ABC_CONST(0x0400000404030102), ABC_CONST(0x0400000400030102), ABC_CONST(0x0400000004030102), ABC_CONST(0x0400000000030102) },
    { ABC_CONST(0x0404040404030101), ABC_CONST(0x0404040400030101), ABC_CONST(0x0404040004030101), ABC_CONST(0x0404040000030101), ABC_CONST(0x0404000404030101), ABC_CONST(0x0404000400030101), ABC_CONST(0x0404000004030101), ABC_CONST(0x0404000000030101), ABC_CONST(0x0400040404030101), ABC_CONST(0x0400040400030101), ABC_CONST(0x0400040004030101), ABC_CONST(0x0400040000030101), ABC_CONST(0x0400000404030101), ABC_CONST(0x0400000400030101), ABC_CONST(0x0400000004030101), ABC_CONST(0x0400000000030101), ABC_CONST(0x0404040404030101), ABC_CONST(0x0404040400030101), ABC_CONST(0x0404040004030101), ABC_CONST(0x0404040000030101), ABC_CONST(0x0404000404030101), ABC_CONST(0x0404000400030101), ABC_CONST(0x0404000004030101), ABC_CONST(0x0404000000030101), ABC_CONST(0x0400040404030101), ABC_CONST(0x0400040400030101), ABC_CONST(0x0400040004030101), ABC_CONST(0x0400040000030101), ABC_CONST(0x0400000404030101), ABC_CONST(0x0400000400030101), ABC_CONST(0x0400000004030101), ABC_CONST(0x0400000000030101) },
    { ABC_CONST(0x0505050505040202), ABC_CONST(0x0505050500040202), ABC_CONST(0x0505050005040202), ABC_CONST(0x0505050000040202), ABC_CONST(0x0505000505040202), ABC_CONST(0x0505000500040202), ABC_CONST(0x0505000005040202), ABC_CONST(0x0505000000040202), ABC_CONST(0x0500050505040202), ABC_CONST(0x0500050500040202), ABC_CONST(0x0500050005040202), ABC_CONST(0x0500050000040202), ABC_CONST(0x0500000505040202), ABC_CONST(0x0500000500040202), ABC_CONST(0x0500000005040202), ABC_CONST(0x0500000000040202), ABC_CONST(0x0505050505040202), ABC_CONST(0x0505050500040202), ABC_CONST(0x0505050005040202), ABC_CONST(0x0505050000040202), ABC_CONST(0x0505000505040202), ABC_CONST(0x0505000500040202), ABC_CONST(0x0505000005040202), ABC_CONST(0x0505000000040202), ABC_CONST(0x0500050505040202), ABC_CONST(0x0500050500040202), ABC_CONST(0x0500050005040202), ABC_CONST(0x0500050000040202), ABC_CONST(0x0500000505040202), ABC_CONST(0x0500000500040202), ABC_CONST(0x0500000005040202), ABC_CONST(0x0500000000040202) },
    { ABC_CONST(0x0202020202000101), ABC_CONST(0x0202020200000101), ABC_CONST(0x0202020002000101), ABC_CONST(0x0202020000000101), ABC_CONST(0x0202000202000101), ABC_CONST(0x0202000200000101), ABC_CONST(0x0202000002000101), ABC_CONST(0x0202000000000101), ABC_CONST(0x0200020202000101), ABC_CONST(0x0200020200000101), ABC_CONST(0x0200020002000101), ABC_CONST(0x0200020000000101), ABC_CONST(0x0200000202000101), ABC_CONST(0x0200000200000101), ABC_CONST(0x0200000002000101), ABC_CONST(0x0200000000000101), ABC_CONST(0x0202020202000101), ABC_CONST(0x0202020200000101), ABC_CONST(0x0202020002000101), ABC_CONST(0x0202020000000101), ABC_CONST(0x0202000202000101), ABC_CONST(0x0202000200000101), ABC_CONST(0x0202000002000101), ABC_CONST(0x0202000000000101), ABC_CONST(0x0200020202000101), ABC_CONST(0x0200020200000101), ABC_CONST(0x0200020002000101), ABC_CONST(0x0200020000000101), ABC_CONST(0x0200000202000101), ABC_CONST(0x0200000200000101), ABC_CONST(0x0200000002000101), ABC_CONST(0x0200000000000101) },
    { ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202), ABC_CONST(0x0303030303010202), ABC_CONST(0x0303030300010202), ABC_CONST(0x0303030003010202), ABC_CONST(0x0303030000010202), ABC_CONST(0x0303000303010202), ABC_CONST(0x0303000300010202), ABC_CONST(0x0303000003010202), ABC_CONST(0x0303000000010202), ABC_CONST(0x0300030303010202), ABC_CONST(0x0300030300010202), ABC_CONST(0x0300030003010202), ABC_CONST(0x0300030000010202), ABC_CONST(0x0300000303010202), ABC_CONST(0x0300000300010202), ABC_CONST(0x0300000003010202), ABC_CONST(0x0300000000010202) },
    { ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201), ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201) },
    { ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302), ABC_CONST(0x0404040404020302), ABC_CONST(0x0404040400020302), ABC_CONST(0x0404040004020302), ABC_CONST(0x0404040000020302), ABC_CONST(0x0404000404020302), ABC_CONST(0x0404000400020302), ABC_CONST(0x0404000004020302), ABC_CONST(0x0404000000020302), ABC_CONST(0x0400040404020302), ABC_CONST(0x0400040400020302), ABC_CONST(0x0400040004020302), ABC_CONST(0x0400040000020302), ABC_CONST(0x0400000404020302), ABC_CONST(0x0400000400020302), ABC_CONST(0x0400000004020302), ABC_CONST(0x0400000000020302) },
    { ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102), ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102) },
    { ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203), ABC_CONST(0x0404040404020203), ABC_CONST(0x0404040400020203), ABC_CONST(0x0404040004020203), ABC_CONST(0x0404040000020203), ABC_CONST(0x0404000404020203), ABC_CONST(0x0404000400020203), ABC_CONST(0x0404000004020203), ABC_CONST(0x0404000000020203), ABC_CONST(0x0400040404020203), ABC_CONST(0x0400040400020203), ABC_CONST(0x0400040004020203), ABC_CONST(0x0400040000020203), ABC_CONST(0x0400000404020203), ABC_CONST(0x0400000400020203), ABC_CONST(0x0400000004020203), ABC_CONST(0x0400000000020203) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303), ABC_CONST(0x0505050505030303), ABC_CONST(0x0505050500030303), ABC_CONST(0x0505050005030303), ABC_CONST(0x0505050000030303), ABC_CONST(0x0505000505030303), ABC_CONST(0x0505000500030303), ABC_CONST(0x0505000005030303), ABC_CONST(0x0505000000030303), ABC_CONST(0x0500050505030303), ABC_CONST(0x0500050500030303), ABC_CONST(0x0500050005030303), ABC_CONST(0x0500050000030303), ABC_CONST(0x0500000505030303), ABC_CONST(0x0500000500030303), ABC_CONST(0x0500000005030303), ABC_CONST(0x0500000000030303) },
    { ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101), ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201), ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201) },
    { ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302), ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302) },
    { ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102), ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102) },
    { ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203), ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203) },
    { ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202), ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202) },
    { ABC_CONST(0x0606060606040303), ABC_CONST(0x0606060600040303), ABC_CONST(0x0606060006040303), ABC_CONST(0x0606060000040303), ABC_CONST(0x0606000606040303), ABC_CONST(0x0606000600040303), ABC_CONST(0x0606000006040303), ABC_CONST(0x0606000000040303), ABC_CONST(0x0600060606040303), ABC_CONST(0x0600060600040303), ABC_CONST(0x0600060006040303), ABC_CONST(0x0600060000040303), ABC_CONST(0x0600000606040303), ABC_CONST(0x0600000600040303), ABC_CONST(0x0600000006040303), ABC_CONST(0x0600000000040303), ABC_CONST(0x0606060606040303), ABC_CONST(0x0606060600040303), ABC_CONST(0x0606060006040303), ABC_CONST(0x0606060000040303), ABC_CONST(0x0606000606040303), ABC_CONST(0x0606000600040303), ABC_CONST(0x0606000006040303), ABC_CONST(0x0606000000040303), ABC_CONST(0x0600060606040303), ABC_CONST(0x0600060600040303), ABC_CONST(0x0600060006040303), ABC_CONST(0x0600060000040303), ABC_CONST(0x0600000606040303), ABC_CONST(0x0600000600040303), ABC_CONST(0x0600000006040303), ABC_CONST(0x0600000000040303) },
    { ABC_CONST(0x0202020202000100), ABC_CONST(0x0202020200000100), ABC_CONST(0x0202020002000100), ABC_CONST(0x0202020000000100), ABC_CONST(0x0202000202000100), ABC_CONST(0x0202000200000100), ABC_CONST(0x0202000002000100), ABC_CONST(0x0202000000000100), ABC_CONST(0x0200020202000100), ABC_CONST(0x0200020200000100), ABC_CONST(0x0200020002000100), ABC_CONST(0x0200020000000100), ABC_CONST(0x0200000202000100), ABC_CONST(0x0200000200000100), ABC_CONST(0x0200000002000100), ABC_CONST(0x0200000000000100), ABC_CONST(0x0202020202000100), ABC_CONST(0x0202020200000100), ABC_CONST(0x0202020002000100), ABC_CONST(0x0202020000000100), ABC_CONST(0x0202000202000100), ABC_CONST(0x0202000200000100), ABC_CONST(0x0202000002000100), ABC_CONST(0x0202000000000100), ABC_CONST(0x0200020202000100), ABC_CONST(0x0200020200000100), ABC_CONST(0x0200020002000100), ABC_CONST(0x0200020000000100), ABC_CONST(0x0200000202000100), ABC_CONST(0x0200000200000100), ABC_CONST(0x0200000002000100), ABC_CONST(0x0200000000000100) },
    { ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201), ABC_CONST(0x0303030303010201), ABC_CONST(0x0303030300010201), ABC_CONST(0x0303030003010201), ABC_CONST(0x0303030000010201), ABC_CONST(0x0303000303010201), ABC_CONST(0x0303000300010201), ABC_CONST(0x0303000003010201), ABC_CONST(0x0303000000010201), ABC_CONST(0x0300030303010201), ABC_CONST(0x0300030300010201), ABC_CONST(0x0300030003010201), ABC_CONST(0x0300030000010201), ABC_CONST(0x0300000303010201), ABC_CONST(0x0300000300010201), ABC_CONST(0x0300000003010201), ABC_CONST(0x0300000000010201) },
    { ABC_CONST(0x0303030303010200), ABC_CONST(0x0303030300010200), ABC_CONST(0x0303030003010200), ABC_CONST(0x0303030000010200), ABC_CONST(0x0303000303010200), ABC_CONST(0x0303000300010200), ABC_CONST(0x0303000003010200), ABC_CONST(0x0303000000010200), ABC_CONST(0x0300030303010200), ABC_CONST(0x0300030300010200), ABC_CONST(0x0300030003010200), ABC_CONST(0x0300030000010200), ABC_CONST(0x0300000303010200), ABC_CONST(0x0300000300010200), ABC_CONST(0x0300000003010200), ABC_CONST(0x0300000000010200), ABC_CONST(0x0303030303010200), ABC_CONST(0x0303030300010200), ABC_CONST(0x0303030003010200), ABC_CONST(0x0303030000010200), ABC_CONST(0x0303000303010200), ABC_CONST(0x0303000300010200), ABC_CONST(0x0303000003010200), ABC_CONST(0x0303000000010200), ABC_CONST(0x0300030303010200), ABC_CONST(0x0300030300010200), ABC_CONST(0x0300030003010200), ABC_CONST(0x0300030000010200), ABC_CONST(0x0300000303010200), ABC_CONST(0x0300000300010200), ABC_CONST(0x0300000003010200), ABC_CONST(0x0300000000010200) },
    { ABC_CONST(0x0404040404020301), ABC_CONST(0x0404040400020301), ABC_CONST(0x0404040004020301), ABC_CONST(0x0404040000020301), ABC_CONST(0x0404000404020301), ABC_CONST(0x0404000400020301), ABC_CONST(0x0404000004020301), ABC_CONST(0x0404000000020301), ABC_CONST(0x0400040404020301), ABC_CONST(0x0400040400020301), ABC_CONST(0x0400040004020301), ABC_CONST(0x0400040000020301), ABC_CONST(0x0400000404020301), ABC_CONST(0x0400000400020301), ABC_CONST(0x0400000004020301), ABC_CONST(0x0400000000020301), ABC_CONST(0x0404040404020301), ABC_CONST(0x0404040400020301), ABC_CONST(0x0404040004020301), ABC_CONST(0x0404040000020301), ABC_CONST(0x0404000404020301), ABC_CONST(0x0404000400020301), ABC_CONST(0x0404000004020301), ABC_CONST(0x0404000000020301), ABC_CONST(0x0400040404020301), ABC_CONST(0x0400040400020301), ABC_CONST(0x0400040004020301), ABC_CONST(0x0400040000020301), ABC_CONST(0x0400000404020301), ABC_CONST(0x0400000400020301), ABC_CONST(0x0400000004020301), ABC_CONST(0x0400000000020301) },
    { ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101), ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201), ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201) },
    { ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302), ABC_CONST(0x0505050505030302), ABC_CONST(0x0505050500030302), ABC_CONST(0x0505050005030302), ABC_CONST(0x0505050000030302), ABC_CONST(0x0505000505030302), ABC_CONST(0x0505000500030302), ABC_CONST(0x0505000005030302), ABC_CONST(0x0505000000030302), ABC_CONST(0x0500050505030302), ABC_CONST(0x0500050500030302), ABC_CONST(0x0500050005030302), ABC_CONST(0x0500050000030302), ABC_CONST(0x0500000505030302), ABC_CONST(0x0500000500030302), ABC_CONST(0x0500000005030302), ABC_CONST(0x0500000000030302) },
    { ABC_CONST(0x0303030303010100), ABC_CONST(0x0303030300010100), ABC_CONST(0x0303030003010100), ABC_CONST(0x0303030000010100), ABC_CONST(0x0303000303010100), ABC_CONST(0x0303000300010100), ABC_CONST(0x0303000003010100), ABC_CONST(0x0303000000010100), ABC_CONST(0x0300030303010100), ABC_CONST(0x0300030300010100), ABC_CONST(0x0300030003010100), ABC_CONST(0x0300030000010100), ABC_CONST(0x0300000303010100), ABC_CONST(0x0300000300010100), ABC_CONST(0x0300000003010100), ABC_CONST(0x0300000000010100), ABC_CONST(0x0303030303010100), ABC_CONST(0x0303030300010100), ABC_CONST(0x0303030003010100), ABC_CONST(0x0303030000010100), ABC_CONST(0x0303000303010100), ABC_CONST(0x0303000300010100), ABC_CONST(0x0303000003010100), ABC_CONST(0x0303000000010100), ABC_CONST(0x0300030303010100), ABC_CONST(0x0300030300010100), ABC_CONST(0x0300030003010100), ABC_CONST(0x0300030000010100), ABC_CONST(0x0300000303010100), ABC_CONST(0x0300000300010100), ABC_CONST(0x0300000003010100), ABC_CONST(0x0300000000010100) },
    { ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201), ABC_CONST(0x0404040404020201), ABC_CONST(0x0404040400020201), ABC_CONST(0x0404040004020201), ABC_CONST(0x0404040000020201), ABC_CONST(0x0404000404020201), ABC_CONST(0x0404000400020201), ABC_CONST(0x0404000004020201), ABC_CONST(0x0404000000020201), ABC_CONST(0x0400040404020201), ABC_CONST(0x0400040400020201), ABC_CONST(0x0400040004020201), ABC_CONST(0x0400040000020201), ABC_CONST(0x0400000404020201), ABC_CONST(0x0400000400020201), ABC_CONST(0x0400000004020201), ABC_CONST(0x0400000000020201) },
    { ABC_CONST(0x0404040404020200), ABC_CONST(0x0404040400020200), ABC_CONST(0x0404040004020200), ABC_CONST(0x0404040000020200), ABC_CONST(0x0404000404020200), ABC_CONST(0x0404000400020200), ABC_CONST(0x0404000004020200), ABC_CONST(0x0404000000020200), ABC_CONST(0x0400040404020200), ABC_CONST(0x0400040400020200), ABC_CONST(0x0400040004020200), ABC_CONST(0x0400040000020200), ABC_CONST(0x0400000404020200), ABC_CONST(0x0400000400020200), ABC_CONST(0x0400000004020200), ABC_CONST(0x0400000000020200), ABC_CONST(0x0404040404020200), ABC_CONST(0x0404040400020200), ABC_CONST(0x0404040004020200), ABC_CONST(0x0404040000020200), ABC_CONST(0x0404000404020200), ABC_CONST(0x0404000400020200), ABC_CONST(0x0404000004020200), ABC_CONST(0x0404000000020200), ABC_CONST(0x0400040404020200), ABC_CONST(0x0400040400020200), ABC_CONST(0x0400040004020200), ABC_CONST(0x0400040000020200), ABC_CONST(0x0400000404020200), ABC_CONST(0x0400000400020200), ABC_CONST(0x0400000004020200), ABC_CONST(0x0400000000020200) },
    { ABC_CONST(0x0505050505030301), ABC_CONST(0x0505050500030301), ABC_CONST(0x0505050005030301), ABC_CONST(0x0505050000030301), ABC_CONST(0x0505000505030301), ABC_CONST(0x0505000500030301), ABC_CONST(0x0505000005030301), ABC_CONST(0x0505000000030301), ABC_CONST(0x0500050505030301), ABC_CONST(0x0500050500030301), ABC_CONST(0x0500050005030301), ABC_CONST(0x0500050000030301), ABC_CONST(0x0500000505030301), ABC_CONST(0x0500000500030301), ABC_CONST(0x0500000005030301), ABC_CONST(0x0500000000030301), ABC_CONST(0x0505050505030301), ABC_CONST(0x0505050500030301), ABC_CONST(0x0505050005030301), ABC_CONST(0x0505050000030301), ABC_CONST(0x0505000505030301), ABC_CONST(0x0505000500030301), ABC_CONST(0x0505000005030301), ABC_CONST(0x0505000000030301), ABC_CONST(0x0500050505030301), ABC_CONST(0x0500050500030301), ABC_CONST(0x0500050005030301), ABC_CONST(0x0500050000030301), ABC_CONST(0x0500000505030301), ABC_CONST(0x0500000500030301), ABC_CONST(0x0500000005030301), ABC_CONST(0x0500000000030301) },
    { ABC_CONST(0x0404040404020101), ABC_CONST(0x0404040400020101), ABC_CONST(0x0404040004020101), ABC_CONST(0x0404040000020101), ABC_CONST(0x0404000404020101), ABC_CONST(0x0404000400020101), ABC_CONST(0x0404000004020101), ABC_CONST(0x0404000000020101), ABC_CONST(0x0400040404020101), ABC_CONST(0x0400040400020101), ABC_CONST(0x0400040004020101), ABC_CONST(0x0400040000020101), ABC_CONST(0x0400000404020101), ABC_CONST(0x0400000400020101), ABC_CONST(0x0400000004020101), ABC_CONST(0x0400000000020101), ABC_CONST(0x0404040404020101), ABC_CONST(0x0404040400020101), ABC_CONST(0x0404040004020101), ABC_CONST(0x0404040000020101), ABC_CONST(0x0404000404020101), ABC_CONST(0x0404000400020101), ABC_CONST(0x0404000004020101), ABC_CONST(0x0404000000020101), ABC_CONST(0x0400040404020101), ABC_CONST(0x0400040400020101), ABC_CONST(0x0400040004020101), ABC_CONST(0x0400040000020101), ABC_CONST(0x0400000404020101), ABC_CONST(0x0400000400020101), ABC_CONST(0x0400000004020101), ABC_CONST(0x0400000000020101) },
    { ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202), ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202) },
    { ABC_CONST(0x0505050505030201), ABC_CONST(0x0505050500030201), ABC_CONST(0x0505050005030201), ABC_CONST(0x0505050000030201), ABC_CONST(0x0505000505030201), ABC_CONST(0x0505000500030201), ABC_CONST(0x0505000005030201), ABC_CONST(0x0505000000030201), ABC_CONST(0x0500050505030201), ABC_CONST(0x0500050500030201), ABC_CONST(0x0500050005030201), ABC_CONST(0x0500050000030201), ABC_CONST(0x0500000505030201), ABC_CONST(0x0500000500030201), ABC_CONST(0x0500000005030201), ABC_CONST(0x0500000000030201), ABC_CONST(0x0505050505030201), ABC_CONST(0x0505050500030201), ABC_CONST(0x0505050005030201), ABC_CONST(0x0505050000030201), ABC_CONST(0x0505000505030201), ABC_CONST(0x0505000500030201), ABC_CONST(0x0505000005030201), ABC_CONST(0x0505000000030201), ABC_CONST(0x0500050505030201), ABC_CONST(0x0500050500030201), ABC_CONST(0x0500050005030201), ABC_CONST(0x0500050000030201), ABC_CONST(0x0500000505030201), ABC_CONST(0x0500000500030201), ABC_CONST(0x0500000005030201), ABC_CONST(0x0500000000030201) },
    { ABC_CONST(0x0606060606040302), ABC_CONST(0x0606060600040302), ABC_CONST(0x0606060006040302), ABC_CONST(0x0606060000040302), ABC_CONST(0x0606000606040302), ABC_CONST(0x0606000600040302), ABC_CONST(0x0606000006040302), ABC_CONST(0x0606000000040302), ABC_CONST(0x0600060606040302), ABC_CONST(0x0600060600040302), ABC_CONST(0x0600060006040302), ABC_CONST(0x0600060000040302), ABC_CONST(0x0600000606040302), ABC_CONST(0x0600000600040302), ABC_CONST(0x0600000006040302), ABC_CONST(0x0600000000040302), ABC_CONST(0x0606060606040302), ABC_CONST(0x0606060600040302), ABC_CONST(0x0606060006040302), ABC_CONST(0x0606060000040302), ABC_CONST(0x0606000606040302), ABC_CONST(0x0606000600040302), ABC_CONST(0x0606000006040302), ABC_CONST(0x0606000000040302), ABC_CONST(0x0600060606040302), ABC_CONST(0x0600060600040302), ABC_CONST(0x0600060006040302), ABC_CONST(0x0600060000040302), ABC_CONST(0x0600000606040302), ABC_CONST(0x0600000600040302), ABC_CONST(0x0600000006040302), ABC_CONST(0x0600000000040302) },
    { ABC_CONST(0x0303030303000201), ABC_CONST(0x0303030300000201), ABC_CONST(0x0303030003000201), ABC_CONST(0x0303030000000201), ABC_CONST(0x0303000303000201), ABC_CONST(0x0303000300000201), ABC_CONST(0x0303000003000201), ABC_CONST(0x0303000000000201), ABC_CONST(0x0300030303000201), ABC_CONST(0x0300030300000201), ABC_CONST(0x0300030003000201), ABC_CONST(0x0300030000000201), ABC_CONST(0x0300000303000201), ABC_CONST(0x0300000300000201), ABC_CONST(0x0300000003000201), ABC_CONST(0x0300000000000201), ABC_CONST(0x0303030303000201), ABC_CONST(0x0303030300000201), ABC_CONST(0x0303030003000201), ABC_CONST(0x0303030000000201), ABC_CONST(0x0303000303000201), ABC_CONST(0x0303000300000201), ABC_CONST(0x0303000003000201), ABC_CONST(0x0303000000000201), ABC_CONST(0x0300030303000201), ABC_CONST(0x0300030300000201), ABC_CONST(0x0300030003000201), ABC_CONST(0x0300030000000201), ABC_CONST(0x0300000303000201), ABC_CONST(0x0300000300000201), ABC_CONST(0x0300000003000201), ABC_CONST(0x0300000000000201) },
    { ABC_CONST(0x0404040404010302), ABC_CONST(0x0404040400010302), ABC_CONST(0x0404040004010302), ABC_CONST(0x0404040000010302), ABC_CONST(0x0404000404010302), ABC_CONST(0x0404000400010302), ABC_CONST(0x0404000004010302), ABC_CONST(0x0404000000010302), ABC_CONST(0x0400040404010302), ABC_CONST(0x0400040400010302), ABC_CONST(0x0400040004010302), ABC_CONST(0x0400040000010302), ABC_CONST(0x0400000404010302), ABC_CONST(0x0400000400010302), ABC_CONST(0x0400000004010302), ABC_CONST(0x0400000000010302), ABC_CONST(0x0404040404010302), ABC_CONST(0x0404040400010302), ABC_CONST(0x0404040004010302), ABC_CONST(0x0404040000010302), ABC_CONST(0x0404000404010302), ABC_CONST(0x0404000400010302), ABC_CONST(0x0404000004010302), ABC_CONST(0x0404000000010302), ABC_CONST(0x0400040404010302), ABC_CONST(0x0400040400010302), ABC_CONST(0x0400040004010302), ABC_CONST(0x0400040000010302), ABC_CONST(0x0400000404010302), ABC_CONST(0x0400000400010302), ABC_CONST(0x0400000004010302), ABC_CONST(0x0400000000010302) },
    { ABC_CONST(0x0404040404010301), ABC_CONST(0x0404040400010301), ABC_CONST(0x0404040004010301), ABC_CONST(0x0404040000010301), ABC_CONST(0x0404000404010301), ABC_CONST(0x0404000400010301), ABC_CONST(0x0404000004010301), ABC_CONST(0x0404000000010301), ABC_CONST(0x0400040404010301), ABC_CONST(0x0400040400010301), ABC_CONST(0x0400040004010301), ABC_CONST(0x0400040000010301), ABC_CONST(0x0400000404010301), ABC_CONST(0x0400000400010301), ABC_CONST(0x0400000004010301), ABC_CONST(0x0400000000010301), ABC_CONST(0x0404040404010301), ABC_CONST(0x0404040400010301), ABC_CONST(0x0404040004010301), ABC_CONST(0x0404040000010301), ABC_CONST(0x0404000404010301), ABC_CONST(0x0404000400010301), ABC_CONST(0x0404000004010301), ABC_CONST(0x0404000000010301), ABC_CONST(0x0400040404010301), ABC_CONST(0x0400040400010301), ABC_CONST(0x0400040004010301), ABC_CONST(0x0400040000010301), ABC_CONST(0x0400000404010301), ABC_CONST(0x0400000400010301), ABC_CONST(0x0400000004010301), ABC_CONST(0x0400000000010301) },
    { ABC_CONST(0x0505050505020402), ABC_CONST(0x0505050500020402), ABC_CONST(0x0505050005020402), ABC_CONST(0x0505050000020402), ABC_CONST(0x0505000505020402), ABC_CONST(0x0505000500020402), ABC_CONST(0x0505000005020402), ABC_CONST(0x0505000000020402), ABC_CONST(0x0500050505020402), ABC_CONST(0x0500050500020402), ABC_CONST(0x0500050005020402), ABC_CONST(0x0500050000020402), ABC_CONST(0x0500000505020402), ABC_CONST(0x0500000500020402), ABC_CONST(0x0500000005020402), ABC_CONST(0x0500000000020402), ABC_CONST(0x0505050505020402), ABC_CONST(0x0505050500020402), ABC_CONST(0x0505050005020402), ABC_CONST(0x0505050000020402), ABC_CONST(0x0505000505020402), ABC_CONST(0x0505000500020402), ABC_CONST(0x0505000005020402), ABC_CONST(0x0505000000020402), ABC_CONST(0x0500050505020402), ABC_CONST(0x0500050500020402), ABC_CONST(0x0500050005020402), ABC_CONST(0x0500050000020402), ABC_CONST(0x0500000505020402), ABC_CONST(0x0500000500020402), ABC_CONST(0x0500000005020402), ABC_CONST(0x0500000000020402) },
    { ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202), ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202) },
    { ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303), ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303) },
    { ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302), ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302) },
    { ABC_CONST(0x0606060606030403), ABC_CONST(0x0606060600030403), ABC_CONST(0x0606060006030403), ABC_CONST(0x0606060000030403), ABC_CONST(0x0606000606030403), ABC_CONST(0x0606000600030403), ABC_CONST(0x0606000006030403), ABC_CONST(0x0606000000030403), ABC_CONST(0x0600060606030403), ABC_CONST(0x0600060600030403), ABC_CONST(0x0600060006030403), ABC_CONST(0x0600060000030403), ABC_CONST(0x0600000606030403), ABC_CONST(0x0600000600030403), ABC_CONST(0x0600000006030403), ABC_CONST(0x0600000000030403), ABC_CONST(0x0606060606030403), ABC_CONST(0x0606060600030403), ABC_CONST(0x0606060006030403), ABC_CONST(0x0606060000030403), ABC_CONST(0x0606000606030403), ABC_CONST(0x0606000600030403), ABC_CONST(0x0606000006030403), ABC_CONST(0x0606000000030403), ABC_CONST(0x0600060606030403), ABC_CONST(0x0600060600030403), ABC_CONST(0x0600060006030403), ABC_CONST(0x0600060000030403), ABC_CONST(0x0600000606030403), ABC_CONST(0x0600000600030403), ABC_CONST(0x0600000006030403), ABC_CONST(0x0600000000030403) },
    { ABC_CONST(0x0404040404010201), ABC_CONST(0x0404040400010201), ABC_CONST(0x0404040004010201), ABC_CONST(0x0404040000010201), ABC_CONST(0x0404000404010201), ABC_CONST(0x0404000400010201), ABC_CONST(0x0404000004010201), ABC_CONST(0x0404000000010201), ABC_CONST(0x0400040404010201), ABC_CONST(0x0400040400010201), ABC_CONST(0x0400040004010201), ABC_CONST(0x0400040000010201), ABC_CONST(0x0400000404010201), ABC_CONST(0x0400000400010201), ABC_CONST(0x0400000004010201), ABC_CONST(0x0400000000010201), ABC_CONST(0x0404040404010201), ABC_CONST(0x0404040400010201), ABC_CONST(0x0404040004010201), ABC_CONST(0x0404040000010201), ABC_CONST(0x0404000404010201), ABC_CONST(0x0404000400010201), ABC_CONST(0x0404000004010201), ABC_CONST(0x0404000000010201), ABC_CONST(0x0400040404010201), ABC_CONST(0x0400040400010201), ABC_CONST(0x0400040004010201), ABC_CONST(0x0400040000010201), ABC_CONST(0x0400000404010201), ABC_CONST(0x0400000400010201), ABC_CONST(0x0400000004010201), ABC_CONST(0x0400000000010201) },
    { ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302), ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302) },
    { ABC_CONST(0x0505050505020301), ABC_CONST(0x0505050500020301), ABC_CONST(0x0505050005020301), ABC_CONST(0x0505050000020301), ABC_CONST(0x0505000505020301), ABC_CONST(0x0505000500020301), ABC_CONST(0x0505000005020301), ABC_CONST(0x0505000000020301), ABC_CONST(0x0500050505020301), ABC_CONST(0x0500050500020301), ABC_CONST(0x0500050005020301), ABC_CONST(0x0500050000020301), ABC_CONST(0x0500000505020301), ABC_CONST(0x0500000500020301), ABC_CONST(0x0500000005020301), ABC_CONST(0x0500000000020301), ABC_CONST(0x0505050505020301), ABC_CONST(0x0505050500020301), ABC_CONST(0x0505050005020301), ABC_CONST(0x0505050000020301), ABC_CONST(0x0505000505020301), ABC_CONST(0x0505000500020301), ABC_CONST(0x0505000005020301), ABC_CONST(0x0505000000020301), ABC_CONST(0x0500050505020301), ABC_CONST(0x0500050500020301), ABC_CONST(0x0500050005020301), ABC_CONST(0x0500050000020301), ABC_CONST(0x0500000505020301), ABC_CONST(0x0500000500020301), ABC_CONST(0x0500000005020301), ABC_CONST(0x0500000000020301) },
    { ABC_CONST(0x0606060606030402), ABC_CONST(0x0606060600030402), ABC_CONST(0x0606060006030402), ABC_CONST(0x0606060000030402), ABC_CONST(0x0606000606030402), ABC_CONST(0x0606000600030402), ABC_CONST(0x0606000006030402), ABC_CONST(0x0606000000030402), ABC_CONST(0x0600060606030402), ABC_CONST(0x0600060600030402), ABC_CONST(0x0600060006030402), ABC_CONST(0x0600060000030402), ABC_CONST(0x0600000606030402), ABC_CONST(0x0600000600030402), ABC_CONST(0x0600000006030402), ABC_CONST(0x0600000000030402), ABC_CONST(0x0606060606030402), ABC_CONST(0x0606060600030402), ABC_CONST(0x0606060006030402), ABC_CONST(0x0606060000030402), ABC_CONST(0x0606000606030402), ABC_CONST(0x0606000600030402), ABC_CONST(0x0606000006030402), ABC_CONST(0x0606000000030402), ABC_CONST(0x0600060606030402), ABC_CONST(0x0600060600030402), ABC_CONST(0x0600060006030402), ABC_CONST(0x0600060000030402), ABC_CONST(0x0600000606030402), ABC_CONST(0x0600000600030402), ABC_CONST(0x0600000006030402), ABC_CONST(0x0600000000030402) },
    { ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202), ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202) },
    { ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303), ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303) },
    { ABC_CONST(0x0606060606030302), ABC_CONST(0x0606060600030302), ABC_CONST(0x0606060006030302), ABC_CONST(0x0606060000030302), ABC_CONST(0x0606000606030302), ABC_CONST(0x0606000600030302), ABC_CONST(0x0606000006030302), ABC_CONST(0x0606000000030302), ABC_CONST(0x0600060606030302), ABC_CONST(0x0600060600030302), ABC_CONST(0x0600060006030302), ABC_CONST(0x0600060000030302), ABC_CONST(0x0600000606030302), ABC_CONST(0x0600000600030302), ABC_CONST(0x0600000006030302), ABC_CONST(0x0600000000030302), ABC_CONST(0x0606060606030302), ABC_CONST(0x0606060600030302), ABC_CONST(0x0606060006030302), ABC_CONST(0x0606060000030302), ABC_CONST(0x0606000606030302), ABC_CONST(0x0606000600030302), ABC_CONST(0x0606000006030302), ABC_CONST(0x0606000000030302), ABC_CONST(0x0600060606030302), ABC_CONST(0x0600060600030302), ABC_CONST(0x0600060006030302), ABC_CONST(0x0600060000030302), ABC_CONST(0x0600000606030302), ABC_CONST(0x0600000600030302), ABC_CONST(0x0600000006030302), ABC_CONST(0x0600000000030302) },
    { ABC_CONST(0x0707070707040403), ABC_CONST(0x0707070700040403), ABC_CONST(0x0707070007040403), ABC_CONST(0x0707070000040403), ABC_CONST(0x0707000707040403), ABC_CONST(0x0707000700040403), ABC_CONST(0x0707000007040403), ABC_CONST(0x0707000000040403), ABC_CONST(0x0700070707040403), ABC_CONST(0x0700070700040403), ABC_CONST(0x0700070007040403), ABC_CONST(0x0700070000040403), ABC_CONST(0x0700000707040403), ABC_CONST(0x0700000700040403), ABC_CONST(0x0700000007040403), ABC_CONST(0x0700000000040403), ABC_CONST(0x0707070707040403), ABC_CONST(0x0707070700040403), ABC_CONST(0x0707070007040403), ABC_CONST(0x0707070000040403), ABC_CONST(0x0707000707040403), ABC_CONST(0x0707000700040403), ABC_CONST(0x0707000007040403), ABC_CONST(0x0707000000040403), ABC_CONST(0x0700070707040403), ABC_CONST(0x0700070700040403), ABC_CONST(0x0700070007040403), ABC_CONST(0x0700070000040403), ABC_CONST(0x0700000707040403), ABC_CONST(0x0700000700040403), ABC_CONST(0x0700000007040403), ABC_CONST(0x0700000000040403) },
    { ABC_CONST(0x0202020202000001), ABC_CONST(0x0202020200000001), ABC_CONST(0x0202020002000001), ABC_CONST(0x0202020000000001), ABC_CONST(0x0202000202000001), ABC_CONST(0x0202000200000001), ABC_CONST(0x0202000002000001), ABC_CONST(0x0202000000000001), ABC_CONST(0x0200020202000001), ABC_CONST(0x0200020200000001), ABC_CONST(0x0200020002000001), ABC_CONST(0x0200020000000001), ABC_CONST(0x0200000202000001), ABC_CONST(0x0200000200000001), ABC_CONST(0x0200000002000001), ABC_CONST(0x0200000000000001), ABC_CONST(0x0202020202000001), ABC_CONST(0x0202020200000001), ABC_CONST(0x0202020002000001), ABC_CONST(0x0202020000000001), ABC_CONST(0x0202000202000001), ABC_CONST(0x0202000200000001), ABC_CONST(0x0202000002000001), ABC_CONST(0x0202000000000001), ABC_CONST(0x0200020202000001), ABC_CONST(0x0200020200000001), ABC_CONST(0x0200020002000001), ABC_CONST(0x0200020000000001), ABC_CONST(0x0200000202000001), ABC_CONST(0x0200000200000001), ABC_CONST(0x0200000002000001), ABC_CONST(0x0200000000000001) },
    { ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102), ABC_CONST(0x0303030303010102), ABC_CONST(0x0303030300010102), ABC_CONST(0x0303030003010102), ABC_CONST(0x0303030000010102), ABC_CONST(0x0303000303010102), ABC_CONST(0x0303000300010102), ABC_CONST(0x0303000003010102), ABC_CONST(0x0303000000010102), ABC_CONST(0x0300030303010102), ABC_CONST(0x0300030300010102), ABC_CONST(0x0300030003010102), ABC_CONST(0x0300030000010102), ABC_CONST(0x0300000303010102), ABC_CONST(0x0300000300010102), ABC_CONST(0x0300000003010102), ABC_CONST(0x0300000000010102) },
    { ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101), ABC_CONST(0x0303030303010101), ABC_CONST(0x0303030300010101), ABC_CONST(0x0303030003010101), ABC_CONST(0x0303030000010101), ABC_CONST(0x0303000303010101), ABC_CONST(0x0303000300010101), ABC_CONST(0x0303000003010101), ABC_CONST(0x0303000000010101), ABC_CONST(0x0300030303010101), ABC_CONST(0x0300030300010101), ABC_CONST(0x0300030003010101), ABC_CONST(0x0300030000010101), ABC_CONST(0x0300000303010101), ABC_CONST(0x0300000300010101), ABC_CONST(0x0300000003010101), ABC_CONST(0x0300000000010101) },
    { ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202), ABC_CONST(0x0404040404020202), ABC_CONST(0x0404040400020202), ABC_CONST(0x0404040004020202), ABC_CONST(0x0404040000020202), ABC_CONST(0x0404000404020202), ABC_CONST(0x0404000400020202), ABC_CONST(0x0404000004020202), ABC_CONST(0x0404000000020202), ABC_CONST(0x0400040404020202), ABC_CONST(0x0400040400020202), ABC_CONST(0x0400040004020202), ABC_CONST(0x0400040000020202), ABC_CONST(0x0400000404020202), ABC_CONST(0x0400000400020202), ABC_CONST(0x0400000004020202), ABC_CONST(0x0400000000020202) },
    { ABC_CONST(0x0303030303010002), ABC_CONST(0x0303030300010002), ABC_CONST(0x0303030003010002), ABC_CONST(0x0303030000010002), ABC_CONST(0x0303000303010002), ABC_CONST(0x0303000300010002), ABC_CONST(0x0303000003010002), ABC_CONST(0x0303000000010002), ABC_CONST(0x0300030303010002), ABC_CONST(0x0300030300010002), ABC_CONST(0x0300030003010002), ABC_CONST(0x0300030000010002), ABC_CONST(0x0300000303010002), ABC_CONST(0x0300000300010002), ABC_CONST(0x0300000003010002), ABC_CONST(0x0300000000010002), ABC_CONST(0x0303030303010002), ABC_CONST(0x0303030300010002), ABC_CONST(0x0303030003010002), ABC_CONST(0x0303030000010002), ABC_CONST(0x0303000303010002), ABC_CONST(0x0303000300010002), ABC_CONST(0x0303000003010002), ABC_CONST(0x0303000000010002), ABC_CONST(0x0300030303010002), ABC_CONST(0x0300030300010002), ABC_CONST(0x0300030003010002), ABC_CONST(0x0300030000010002), ABC_CONST(0x0300000303010002), ABC_CONST(0x0300000300010002), ABC_CONST(0x0300000003010002), ABC_CONST(0x0300000000010002) },
    { ABC_CONST(0x0404040404020103), ABC_CONST(0x0404040400020103), ABC_CONST(0x0404040004020103), ABC_CONST(0x0404040000020103), ABC_CONST(0x0404000404020103), ABC_CONST(0x0404000400020103), ABC_CONST(0x0404000004020103), ABC_CONST(0x0404000000020103), ABC_CONST(0x0400040404020103), ABC_CONST(0x0400040400020103), ABC_CONST(0x0400040004020103), ABC_CONST(0x0400040000020103), ABC_CONST(0x0400000404020103), ABC_CONST(0x0400000400020103), ABC_CONST(0x0400000004020103), ABC_CONST(0x0400000000020103), ABC_CONST(0x0404040404020103), ABC_CONST(0x0404040400020103), ABC_CONST(0x0404040004020103), ABC_CONST(0x0404040000020103), ABC_CONST(0x0404000404020103), ABC_CONST(0x0404000400020103), ABC_CONST(0x0404000004020103), ABC_CONST(0x0404000000020103), ABC_CONST(0x0400040404020103), ABC_CONST(0x0400040400020103), ABC_CONST(0x0400040004020103), ABC_CONST(0x0400040000020103), ABC_CONST(0x0400000404020103), ABC_CONST(0x0400000400020103), ABC_CONST(0x0400000004020103), ABC_CONST(0x0400000000020103) },
    { ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102), ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102) },
    { ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203), ABC_CONST(0x0505050505030203), ABC_CONST(0x0505050500030203), ABC_CONST(0x0505050005030203), ABC_CONST(0x0505050000030203), ABC_CONST(0x0505000505030203), ABC_CONST(0x0505000500030203), ABC_CONST(0x0505000005030203), ABC_CONST(0x0505000000030203), ABC_CONST(0x0500050505030203), ABC_CONST(0x0500050500030203), ABC_CONST(0x0500050005030203), ABC_CONST(0x0500050000030203), ABC_CONST(0x0500000505030203), ABC_CONST(0x0500000500030203), ABC_CONST(0x0500000005030203), ABC_CONST(0x0500000000030203) },
    { ABC_CONST(0x0303030303010001), ABC_CONST(0x0303030300010001), ABC_CONST(0x0303030003010001), ABC_CONST(0x0303030000010001), ABC_CONST(0x0303000303010001), ABC_CONST(0x0303000300010001), ABC_CONST(0x0303000003010001), ABC_CONST(0x0303000000010001), ABC_CONST(0x0300030303010001), ABC_CONST(0x0300030300010001), ABC_CONST(0x0300030003010001), ABC_CONST(0x0300030000010001), ABC_CONST(0x0300000303010001), ABC_CONST(0x0300000300010001), ABC_CONST(0x0300000003010001), ABC_CONST(0x0300000000010001), ABC_CONST(0x0303030303010001), ABC_CONST(0x0303030300010001), ABC_CONST(0x0303030003010001), ABC_CONST(0x0303030000010001), ABC_CONST(0x0303000303010001), ABC_CONST(0x0303000300010001), ABC_CONST(0x0303000003010001), ABC_CONST(0x0303000000010001), ABC_CONST(0x0300030303010001), ABC_CONST(0x0300030300010001), ABC_CONST(0x0300030003010001), ABC_CONST(0x0300030000010001), ABC_CONST(0x0300000303010001), ABC_CONST(0x0300000300010001), ABC_CONST(0x0300000003010001), ABC_CONST(0x0300000000010001) },
    { ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102), ABC_CONST(0x0404040404020102), ABC_CONST(0x0404040400020102), ABC_CONST(0x0404040004020102), ABC_CONST(0x0404040000020102), ABC_CONST(0x0404000404020102), ABC_CONST(0x0404000400020102), ABC_CONST(0x0404000004020102), ABC_CONST(0x0404000000020102), ABC_CONST(0x0400040404020102), ABC_CONST(0x0400040400020102), ABC_CONST(0x0400040004020102), ABC_CONST(0x0400040000020102), ABC_CONST(0x0400000404020102), ABC_CONST(0x0400000400020102), ABC_CONST(0x0400000004020102), ABC_CONST(0x0400000000020102) },
    { ABC_CONST(0x0404040404020101), ABC_CONST(0x0404040400020101), ABC_CONST(0x0404040004020101), ABC_CONST(0x0404040000020101), ABC_CONST(0x0404000404020101), ABC_CONST(0x0404000400020101), ABC_CONST(0x0404000004020101), ABC_CONST(0x0404000000020101), ABC_CONST(0x0400040404020101), ABC_CONST(0x0400040400020101), ABC_CONST(0x0400040004020101), ABC_CONST(0x0400040000020101), ABC_CONST(0x0400000404020101), ABC_CONST(0x0400000400020101), ABC_CONST(0x0400000004020101), ABC_CONST(0x0400000000020101), ABC_CONST(0x0404040404020101), ABC_CONST(0x0404040400020101), ABC_CONST(0x0404040004020101), ABC_CONST(0x0404040000020101), ABC_CONST(0x0404000404020101), ABC_CONST(0x0404000400020101), ABC_CONST(0x0404000004020101), ABC_CONST(0x0404000000020101), ABC_CONST(0x0400040404020101), ABC_CONST(0x0400040400020101), ABC_CONST(0x0400040004020101), ABC_CONST(0x0400040000020101), ABC_CONST(0x0400000404020101), ABC_CONST(0x0400000400020101), ABC_CONST(0x0400000004020101), ABC_CONST(0x0400000000020101) },
    { ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202), ABC_CONST(0x0505050505030202), ABC_CONST(0x0505050500030202), ABC_CONST(0x0505050005030202), ABC_CONST(0x0505050000030202), ABC_CONST(0x0505000505030202), ABC_CONST(0x0505000500030202), ABC_CONST(0x0505000005030202), ABC_CONST(0x0505000000030202), ABC_CONST(0x0500050505030202), ABC_CONST(0x0500050500030202), ABC_CONST(0x0500050005030202), ABC_CONST(0x0500050000030202), ABC_CONST(0x0500000505030202), ABC_CONST(0x0500000500030202), ABC_CONST(0x0500000005030202), ABC_CONST(0x0500000000030202) },
    { ABC_CONST(0x0404040404020002), ABC_CONST(0x0404040400020002), ABC_CONST(0x0404040004020002), ABC_CONST(0x0404040000020002), ABC_CONST(0x0404000404020002), ABC_CONST(0x0404000400020002), ABC_CONST(0x0404000004020002), ABC_CONST(0x0404000000020002), ABC_CONST(0x0400040404020002), ABC_CONST(0x0400040400020002), ABC_CONST(0x0400040004020002), ABC_CONST(0x0400040000020002), ABC_CONST(0x0400000404020002), ABC_CONST(0x0400000400020002), ABC_CONST(0x0400000004020002), ABC_CONST(0x0400000000020002), ABC_CONST(0x0404040404020002), ABC_CONST(0x0404040400020002), ABC_CONST(0x0404040004020002), ABC_CONST(0x0404040000020002), ABC_CONST(0x0404000404020002), ABC_CONST(0x0404000400020002), ABC_CONST(0x0404000004020002), ABC_CONST(0x0404000000020002), ABC_CONST(0x0400040404020002), ABC_CONST(0x0400040400020002), ABC_CONST(0x0400040004020002), ABC_CONST(0x0400040000020002), ABC_CONST(0x0400000404020002), ABC_CONST(0x0400000400020002), ABC_CONST(0x0400000004020002), ABC_CONST(0x0400000000020002) },
    { ABC_CONST(0x0505050505030103), ABC_CONST(0x0505050500030103), ABC_CONST(0x0505050005030103), ABC_CONST(0x0505050000030103), ABC_CONST(0x0505000505030103), ABC_CONST(0x0505000500030103), ABC_CONST(0x0505000005030103), ABC_CONST(0x0505000000030103), ABC_CONST(0x0500050505030103), ABC_CONST(0x0500050500030103), ABC_CONST(0x0500050005030103), ABC_CONST(0x0500050000030103), ABC_CONST(0x0500000505030103), ABC_CONST(0x0500000500030103), ABC_CONST(0x0500000005030103), ABC_CONST(0x0500000000030103), ABC_CONST(0x0505050505030103), ABC_CONST(0x0505050500030103), ABC_CONST(0x0505050005030103), ABC_CONST(0x0505050000030103), ABC_CONST(0x0505000505030103), ABC_CONST(0x0505000500030103), ABC_CONST(0x0505000005030103), ABC_CONST(0x0505000000030103), ABC_CONST(0x0500050505030103), ABC_CONST(0x0500050500030103), ABC_CONST(0x0500050005030103), ABC_CONST(0x0500050000030103), ABC_CONST(0x0500000505030103), ABC_CONST(0x0500000500030103), ABC_CONST(0x0500000005030103), ABC_CONST(0x0500000000030103) },
    { ABC_CONST(0x0505050505030102), ABC_CONST(0x0505050500030102), ABC_CONST(0x0505050005030102), ABC_CONST(0x0505050000030102), ABC_CONST(0x0505000505030102), ABC_CONST(0x0505000500030102), ABC_CONST(0x0505000005030102), ABC_CONST(0x0505000000030102), ABC_CONST(0x0500050505030102), ABC_CONST(0x0500050500030102), ABC_CONST(0x0500050005030102), ABC_CONST(0x0500050000030102), ABC_CONST(0x0500000505030102), ABC_CONST(0x0500000500030102), ABC_CONST(0x0500000005030102), ABC_CONST(0x0500000000030102), ABC_CONST(0x0505050505030102), ABC_CONST(0x0505050500030102), ABC_CONST(0x0505050005030102), ABC_CONST(0x0505050000030102), ABC_CONST(0x0505000505030102), ABC_CONST(0x0505000500030102), ABC_CONST(0x0505000005030102), ABC_CONST(0x0505000000030102), ABC_CONST(0x0500050505030102), ABC_CONST(0x0500050500030102), ABC_CONST(0x0500050005030102), ABC_CONST(0x0500050000030102), ABC_CONST(0x0500000505030102), ABC_CONST(0x0500000500030102), ABC_CONST(0x0500000005030102), ABC_CONST(0x0500000000030102) },
    { ABC_CONST(0x0606060606040203), ABC_CONST(0x0606060600040203), ABC_CONST(0x0606060006040203), ABC_CONST(0x0606060000040203), ABC_CONST(0x0606000606040203), ABC_CONST(0x0606000600040203), ABC_CONST(0x0606000006040203), ABC_CONST(0x0606000000040203), ABC_CONST(0x0600060606040203), ABC_CONST(0x0600060600040203), ABC_CONST(0x0600060006040203), ABC_CONST(0x0600060000040203), ABC_CONST(0x0600000606040203), ABC_CONST(0x0600000600040203), ABC_CONST(0x0600000006040203), ABC_CONST(0x0600000000040203), ABC_CONST(0x0606060606040203), ABC_CONST(0x0606060600040203), ABC_CONST(0x0606060006040203), ABC_CONST(0x0606060000040203), ABC_CONST(0x0606000606040203), ABC_CONST(0x0606000600040203), ABC_CONST(0x0606000006040203), ABC_CONST(0x0606000000040203), ABC_CONST(0x0600060606040203), ABC_CONST(0x0600060600040203), ABC_CONST(0x0600060006040203), ABC_CONST(0x0600060000040203), ABC_CONST(0x0600000606040203), ABC_CONST(0x0600000600040203), ABC_CONST(0x0600000006040203), ABC_CONST(0x0600000000040203) },
    { ABC_CONST(0x0303030303000102), ABC_CONST(0x0303030300000102), ABC_CONST(0x0303030003000102), ABC_CONST(0x0303030000000102), ABC_CONST(0x0303000303000102), ABC_CONST(0x0303000300000102), ABC_CONST(0x0303000003000102), ABC_CONST(0x0303000000000102), ABC_CONST(0x0300030303000102), ABC_CONST(0x0300030300000102), ABC_CONST(0x0300030003000102), ABC_CONST(0x0300030000000102), ABC_CONST(0x0300000303000102), ABC_CONST(0x0300000300000102), ABC_CONST(0x0300000003000102), ABC_CONST(0x0300000000000102), ABC_CONST(0x0303030303000102), ABC_CONST(0x0303030300000102), ABC_CONST(0x0303030003000102), ABC_CONST(0x0303030000000102), ABC_CONST(0x0303000303000102), ABC_CONST(0x0303000300000102), ABC_CONST(0x0303000003000102), ABC_CONST(0x0303000000000102), ABC_CONST(0x0300030303000102), ABC_CONST(0x0300030300000102), ABC_CONST(0x0300030003000102), ABC_CONST(0x0300030000000102), ABC_CONST(0x0300000303000102), ABC_CONST(0x0300000300000102), ABC_CONST(0x0300000003000102), ABC_CONST(0x0300000000000102) },
    { ABC_CONST(0x0404040404010203), ABC_CONST(0x0404040400010203), ABC_CONST(0x0404040004010203), ABC_CONST(0x0404040000010203), ABC_CONST(0x0404000404010203), ABC_CONST(0x0404000400010203), ABC_CONST(0x0404000004010203), ABC_CONST(0x0404000000010203), ABC_CONST(0x0400040404010203), ABC_CONST(0x0400040400010203), ABC_CONST(0x0400040004010203), ABC_CONST(0x0400040000010203), ABC_CONST(0x0400000404010203), ABC_CONST(0x0400000400010203), ABC_CONST(0x0400000004010203), ABC_CONST(0x0400000000010203), ABC_CONST(0x0404040404010203), ABC_CONST(0x0404040400010203), ABC_CONST(0x0404040004010203), ABC_CONST(0x0404040000010203), ABC_CONST(0x0404000404010203), ABC_CONST(0x0404000400010203), ABC_CONST(0x0404000004010203), ABC_CONST(0x0404000000010203), ABC_CONST(0x0400040404010203), ABC_CONST(0x0400040400010203), ABC_CONST(0x0400040004010203), ABC_CONST(0x0400040000010203), ABC_CONST(0x0400000404010203), ABC_CONST(0x0400000400010203), ABC_CONST(0x0400000004010203), ABC_CONST(0x0400000000010203) },
    { ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202), ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202) },
    { ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303), ABC_CONST(0x0505050505020303), ABC_CONST(0x0505050500020303), ABC_CONST(0x0505050005020303), ABC_CONST(0x0505050000020303), ABC_CONST(0x0505000505020303), ABC_CONST(0x0505000500020303), ABC_CONST(0x0505000005020303), ABC_CONST(0x0505000000020303), ABC_CONST(0x0500050505020303), ABC_CONST(0x0500050500020303), ABC_CONST(0x0500050005020303), ABC_CONST(0x0500050000020303), ABC_CONST(0x0500000505020303), ABC_CONST(0x0500000500020303), ABC_CONST(0x0500000005020303), ABC_CONST(0x0500000000020303) },
    { ABC_CONST(0x0404040404010103), ABC_CONST(0x0404040400010103), ABC_CONST(0x0404040004010103), ABC_CONST(0x0404040000010103), ABC_CONST(0x0404000404010103), ABC_CONST(0x0404000400010103), ABC_CONST(0x0404000004010103), ABC_CONST(0x0404000000010103), ABC_CONST(0x0400040404010103), ABC_CONST(0x0400040400010103), ABC_CONST(0x0400040004010103), ABC_CONST(0x0400040000010103), ABC_CONST(0x0400000404010103), ABC_CONST(0x0400000400010103), ABC_CONST(0x0400000004010103), ABC_CONST(0x0400000000010103), ABC_CONST(0x0404040404010103), ABC_CONST(0x0404040400010103), ABC_CONST(0x0404040004010103), ABC_CONST(0x0404040000010103), ABC_CONST(0x0404000404010103), ABC_CONST(0x0404000400010103), ABC_CONST(0x0404000004010103), ABC_CONST(0x0404000000010103), ABC_CONST(0x0400040404010103), ABC_CONST(0x0400040400010103), ABC_CONST(0x0400040004010103), ABC_CONST(0x0400040000010103), ABC_CONST(0x0400000404010103), ABC_CONST(0x0400000400010103), ABC_CONST(0x0400000004010103), ABC_CONST(0x0400000000010103) },
    { ABC_CONST(0x0505050505020204), ABC_CONST(0x0505050500020204), ABC_CONST(0x0505050005020204), ABC_CONST(0x0505050000020204), ABC_CONST(0x0505000505020204), ABC_CONST(0x0505000500020204), ABC_CONST(0x0505000005020204), ABC_CONST(0x0505000000020204), ABC_CONST(0x0500050505020204), ABC_CONST(0x0500050500020204), ABC_CONST(0x0500050005020204), ABC_CONST(0x0500050000020204), ABC_CONST(0x0500000505020204), ABC_CONST(0x0500000500020204), ABC_CONST(0x0500000005020204), ABC_CONST(0x0500000000020204), ABC_CONST(0x0505050505020204), ABC_CONST(0x0505050500020204), ABC_CONST(0x0505050005020204), ABC_CONST(0x0505050000020204), ABC_CONST(0x0505000505020204), ABC_CONST(0x0505000500020204), ABC_CONST(0x0505000005020204), ABC_CONST(0x0505000000020204), ABC_CONST(0x0500050505020204), ABC_CONST(0x0500050500020204), ABC_CONST(0x0500050005020204), ABC_CONST(0x0500050000020204), ABC_CONST(0x0500000505020204), ABC_CONST(0x0500000500020204), ABC_CONST(0x0500000005020204), ABC_CONST(0x0500000000020204) },
    { ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203), ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203) },
    { ABC_CONST(0x0606060606030304), ABC_CONST(0x0606060600030304), ABC_CONST(0x0606060006030304), ABC_CONST(0x0606060000030304), ABC_CONST(0x0606000606030304), ABC_CONST(0x0606000600030304), ABC_CONST(0x0606000006030304), ABC_CONST(0x0606000000030304), ABC_CONST(0x0600060606030304), ABC_CONST(0x0600060600030304), ABC_CONST(0x0600060006030304), ABC_CONST(0x0600060000030304), ABC_CONST(0x0600000606030304), ABC_CONST(0x0600000600030304), ABC_CONST(0x0600000006030304), ABC_CONST(0x0600000000030304), ABC_CONST(0x0606060606030304), ABC_CONST(0x0606060600030304), ABC_CONST(0x0606060006030304), ABC_CONST(0x0606060000030304), ABC_CONST(0x0606000606030304), ABC_CONST(0x0606000600030304), ABC_CONST(0x0606000006030304), ABC_CONST(0x0606000000030304), ABC_CONST(0x0600060606030304), ABC_CONST(0x0600060600030304), ABC_CONST(0x0600060006030304), ABC_CONST(0x0600060000030304), ABC_CONST(0x0600000606030304), ABC_CONST(0x0600000600030304), ABC_CONST(0x0600000006030304), ABC_CONST(0x0600000000030304) },
    { ABC_CONST(0x0404040404010102), ABC_CONST(0x0404040400010102), ABC_CONST(0x0404040004010102), ABC_CONST(0x0404040000010102), ABC_CONST(0x0404000404010102), ABC_CONST(0x0404000400010102), ABC_CONST(0x0404000004010102), ABC_CONST(0x0404000000010102), ABC_CONST(0x0400040404010102), ABC_CONST(0x0400040400010102), ABC_CONST(0x0400040004010102), ABC_CONST(0x0400040000010102), ABC_CONST(0x0400000404010102), ABC_CONST(0x0400000400010102), ABC_CONST(0x0400000004010102), ABC_CONST(0x0400000000010102), ABC_CONST(0x0404040404010102), ABC_CONST(0x0404040400010102), ABC_CONST(0x0404040004010102), ABC_CONST(0x0404040000010102), ABC_CONST(0x0404000404010102), ABC_CONST(0x0404000400010102), ABC_CONST(0x0404000004010102), ABC_CONST(0x0404000000010102), ABC_CONST(0x0400040404010102), ABC_CONST(0x0400040400010102), ABC_CONST(0x0400040004010102), ABC_CONST(0x0400040000010102), ABC_CONST(0x0400000404010102), ABC_CONST(0x0400000400010102), ABC_CONST(0x0400000004010102), ABC_CONST(0x0400000000010102) },
    { ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203), ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203) },
    { ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202), ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202) },
    { ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303), ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303) },
    { ABC_CONST(0x0505050505020103), ABC_CONST(0x0505050500020103), ABC_CONST(0x0505050005020103), ABC_CONST(0x0505050000020103), ABC_CONST(0x0505000505020103), ABC_CONST(0x0505000500020103), ABC_CONST(0x0505000005020103), ABC_CONST(0x0505000000020103), ABC_CONST(0x0500050505020103), ABC_CONST(0x0500050500020103), ABC_CONST(0x0500050005020103), ABC_CONST(0x0500050000020103), ABC_CONST(0x0500000505020103), ABC_CONST(0x0500000500020103), ABC_CONST(0x0500000005020103), ABC_CONST(0x0500000000020103), ABC_CONST(0x0505050505020103), ABC_CONST(0x0505050500020103), ABC_CONST(0x0505050005020103), ABC_CONST(0x0505050000020103), ABC_CONST(0x0505000505020103), ABC_CONST(0x0505000500020103), ABC_CONST(0x0505000005020103), ABC_CONST(0x0505000000020103), ABC_CONST(0x0500050505020103), ABC_CONST(0x0500050500020103), ABC_CONST(0x0500050005020103), ABC_CONST(0x0500050000020103), ABC_CONST(0x0500000505020103), ABC_CONST(0x0500000500020103), ABC_CONST(0x0500000005020103), ABC_CONST(0x0500000000020103) },
    { ABC_CONST(0x0606060606030204), ABC_CONST(0x0606060600030204), ABC_CONST(0x0606060006030204), ABC_CONST(0x0606060000030204), ABC_CONST(0x0606000606030204), ABC_CONST(0x0606000600030204), ABC_CONST(0x0606000006030204), ABC_CONST(0x0606000000030204), ABC_CONST(0x0600060606030204), ABC_CONST(0x0600060600030204), ABC_CONST(0x0600060006030204), ABC_CONST(0x0600060000030204), ABC_CONST(0x0600000606030204), ABC_CONST(0x0600000600030204), ABC_CONST(0x0600000006030204), ABC_CONST(0x0600000000030204), ABC_CONST(0x0606060606030204), ABC_CONST(0x0606060600030204), ABC_CONST(0x0606060006030204), ABC_CONST(0x0606060000030204), ABC_CONST(0x0606000606030204), ABC_CONST(0x0606000600030204), ABC_CONST(0x0606000006030204), ABC_CONST(0x0606000000030204), ABC_CONST(0x0600060606030204), ABC_CONST(0x0600060600030204), ABC_CONST(0x0600060006030204), ABC_CONST(0x0600060000030204), ABC_CONST(0x0600000606030204), ABC_CONST(0x0600000600030204), ABC_CONST(0x0600000006030204), ABC_CONST(0x0600000000030204) },
    { ABC_CONST(0x0606060606030203), ABC_CONST(0x0606060600030203), ABC_CONST(0x0606060006030203), ABC_CONST(0x0606060000030203), ABC_CONST(0x0606000606030203), ABC_CONST(0x0606000600030203), ABC_CONST(0x0606000006030203), ABC_CONST(0x0606000000030203), ABC_CONST(0x0600060606030203), ABC_CONST(0x0600060600030203), ABC_CONST(0x0600060006030203), ABC_CONST(0x0600060000030203), ABC_CONST(0x0600000606030203), ABC_CONST(0x0600000600030203), ABC_CONST(0x0600000006030203), ABC_CONST(0x0600000000030203), ABC_CONST(0x0606060606030203), ABC_CONST(0x0606060600030203), ABC_CONST(0x0606060006030203), ABC_CONST(0x0606060000030203), ABC_CONST(0x0606000606030203), ABC_CONST(0x0606000600030203), ABC_CONST(0x0606000006030203), ABC_CONST(0x0606000000030203), ABC_CONST(0x0600060606030203), ABC_CONST(0x0600060600030203), ABC_CONST(0x0600060006030203), ABC_CONST(0x0600060000030203), ABC_CONST(0x0600000606030203), ABC_CONST(0x0600000600030203), ABC_CONST(0x0600000006030203), ABC_CONST(0x0600000000030203) },
    { ABC_CONST(0x0707070707040304), ABC_CONST(0x0707070700040304), ABC_CONST(0x0707070007040304), ABC_CONST(0x0707070000040304), ABC_CONST(0x0707000707040304), ABC_CONST(0x0707000700040304), ABC_CONST(0x0707000007040304), ABC_CONST(0x0707000000040304), ABC_CONST(0x0700070707040304), ABC_CONST(0x0700070700040304), ABC_CONST(0x0700070007040304), ABC_CONST(0x0700070000040304), ABC_CONST(0x0700000707040304), ABC_CONST(0x0700000700040304), ABC_CONST(0x0700000007040304), ABC_CONST(0x0700000000040304), ABC_CONST(0x0707070707040304), ABC_CONST(0x0707070700040304), ABC_CONST(0x0707070007040304), ABC_CONST(0x0707070000040304), ABC_CONST(0x0707000707040304), ABC_CONST(0x0707000700040304), ABC_CONST(0x0707000007040304), ABC_CONST(0x0707000000040304), ABC_CONST(0x0700070707040304), ABC_CONST(0x0700070700040304), ABC_CONST(0x0700070007040304), ABC_CONST(0x0700070000040304), ABC_CONST(0x0700000707040304), ABC_CONST(0x0700000700040304), ABC_CONST(0x0700000007040304), ABC_CONST(0x0700000000040304) },
    { ABC_CONST(0x0303030303000101), ABC_CONST(0x0303030300000101), ABC_CONST(0x0303030003000101), ABC_CONST(0x0303030000000101), ABC_CONST(0x0303000303000101), ABC_CONST(0x0303000300000101), ABC_CONST(0x0303000003000101), ABC_CONST(0x0303000000000101), ABC_CONST(0x0300030303000101), ABC_CONST(0x0300030300000101), ABC_CONST(0x0300030003000101), ABC_CONST(0x0300030000000101), ABC_CONST(0x0300000303000101), ABC_CONST(0x0300000300000101), ABC_CONST(0x0300000003000101), ABC_CONST(0x0300000000000101), ABC_CONST(0x0303030303000101), ABC_CONST(0x0303030300000101), ABC_CONST(0x0303030003000101), ABC_CONST(0x0303030000000101), ABC_CONST(0x0303000303000101), ABC_CONST(0x0303000300000101), ABC_CONST(0x0303000003000101), ABC_CONST(0x0303000000000101), ABC_CONST(0x0300030303000101), ABC_CONST(0x0300030300000101), ABC_CONST(0x0300030003000101), ABC_CONST(0x0300030000000101), ABC_CONST(0x0300000303000101), ABC_CONST(0x0300000300000101), ABC_CONST(0x0300000003000101), ABC_CONST(0x0300000000000101) },
    { ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202), ABC_CONST(0x0404040404010202), ABC_CONST(0x0404040400010202), ABC_CONST(0x0404040004010202), ABC_CONST(0x0404040000010202), ABC_CONST(0x0404000404010202), ABC_CONST(0x0404000400010202), ABC_CONST(0x0404000004010202), ABC_CONST(0x0404000000010202), ABC_CONST(0x0400040404010202), ABC_CONST(0x0400040400010202), ABC_CONST(0x0400040004010202), ABC_CONST(0x0400040000010202), ABC_CONST(0x0400000404010202), ABC_CONST(0x0400000400010202), ABC_CONST(0x0400000004010202), ABC_CONST(0x0400000000010202) },
    { ABC_CONST(0x0404040404010201), ABC_CONST(0x0404040400010201), ABC_CONST(0x0404040004010201), ABC_CONST(0x0404040000010201), ABC_CONST(0x0404000404010201), ABC_CONST(0x0404000400010201), ABC_CONST(0x0404000004010201), ABC_CONST(0x0404000000010201), ABC_CONST(0x0400040404010201), ABC_CONST(0x0400040400010201), ABC_CONST(0x0400040004010201), ABC_CONST(0x0400040000010201), ABC_CONST(0x0400000404010201), ABC_CONST(0x0400000400010201), ABC_CONST(0x0400000004010201), ABC_CONST(0x0400000000010201), ABC_CONST(0x0404040404010201), ABC_CONST(0x0404040400010201), ABC_CONST(0x0404040004010201), ABC_CONST(0x0404040000010201), ABC_CONST(0x0404000404010201), ABC_CONST(0x0404000400010201), ABC_CONST(0x0404000004010201), ABC_CONST(0x0404000000010201), ABC_CONST(0x0400040404010201), ABC_CONST(0x0400040400010201), ABC_CONST(0x0400040004010201), ABC_CONST(0x0400040000010201), ABC_CONST(0x0400000404010201), ABC_CONST(0x0400000400010201), ABC_CONST(0x0400000004010201), ABC_CONST(0x0400000000010201) },
    { ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302), ABC_CONST(0x0505050505020302), ABC_CONST(0x0505050500020302), ABC_CONST(0x0505050005020302), ABC_CONST(0x0505050000020302), ABC_CONST(0x0505000505020302), ABC_CONST(0x0505000500020302), ABC_CONST(0x0505000005020302), ABC_CONST(0x0505000000020302), ABC_CONST(0x0500050505020302), ABC_CONST(0x0500050500020302), ABC_CONST(0x0500050005020302), ABC_CONST(0x0500050000020302), ABC_CONST(0x0500000505020302), ABC_CONST(0x0500000500020302), ABC_CONST(0x0500000005020302), ABC_CONST(0x0500000000020302) },
    { ABC_CONST(0x0404040404010102), ABC_CONST(0x0404040400010102), ABC_CONST(0x0404040004010102), ABC_CONST(0x0404040000010102), ABC_CONST(0x0404000404010102), ABC_CONST(0x0404000400010102), ABC_CONST(0x0404000004010102), ABC_CONST(0x0404000000010102), ABC_CONST(0x0400040404010102), ABC_CONST(0x0400040400010102), ABC_CONST(0x0400040004010102), ABC_CONST(0x0400040000010102), ABC_CONST(0x0400000404010102), ABC_CONST(0x0400000400010102), ABC_CONST(0x0400000004010102), ABC_CONST(0x0400000000010102), ABC_CONST(0x0404040404010102), ABC_CONST(0x0404040400010102), ABC_CONST(0x0404040004010102), ABC_CONST(0x0404040000010102), ABC_CONST(0x0404000404010102), ABC_CONST(0x0404000400010102), ABC_CONST(0x0404000004010102), ABC_CONST(0x0404000000010102), ABC_CONST(0x0400040404010102), ABC_CONST(0x0400040400010102), ABC_CONST(0x0400040004010102), ABC_CONST(0x0400040000010102), ABC_CONST(0x0400000404010102), ABC_CONST(0x0400000400010102), ABC_CONST(0x0400000004010102), ABC_CONST(0x0400000000010102) },
    { ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203), ABC_CONST(0x0505050505020203), ABC_CONST(0x0505050500020203), ABC_CONST(0x0505050005020203), ABC_CONST(0x0505050000020203), ABC_CONST(0x0505000505020203), ABC_CONST(0x0505000500020203), ABC_CONST(0x0505000005020203), ABC_CONST(0x0505000000020203), ABC_CONST(0x0500050505020203), ABC_CONST(0x0500050500020203), ABC_CONST(0x0500050005020203), ABC_CONST(0x0500050000020203), ABC_CONST(0x0500000505020203), ABC_CONST(0x0500000500020203), ABC_CONST(0x0500000005020203), ABC_CONST(0x0500000000020203) },
    { ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202), ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202) },
    { ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303), ABC_CONST(0x0606060606030303), ABC_CONST(0x0606060600030303), ABC_CONST(0x0606060006030303), ABC_CONST(0x0606060000030303), ABC_CONST(0x0606000606030303), ABC_CONST(0x0606000600030303), ABC_CONST(0x0606000006030303), ABC_CONST(0x0606000000030303), ABC_CONST(0x0600060606030303), ABC_CONST(0x0600060600030303), ABC_CONST(0x0600060006030303), ABC_CONST(0x0600060000030303), ABC_CONST(0x0600000606030303), ABC_CONST(0x0600000600030303), ABC_CONST(0x0600000006030303), ABC_CONST(0x0600000000030303) },
    { ABC_CONST(0x0404040404010101), ABC_CONST(0x0404040400010101), ABC_CONST(0x0404040004010101), ABC_CONST(0x0404040000010101), ABC_CONST(0x0404000404010101), ABC_CONST(0x0404000400010101), ABC_CONST(0x0404000004010101), ABC_CONST(0x0404000000010101), ABC_CONST(0x0400040404010101), ABC_CONST(0x0400040400010101), ABC_CONST(0x0400040004010101), ABC_CONST(0x0400040000010101), ABC_CONST(0x0400000404010101), ABC_CONST(0x0400000400010101), ABC_CONST(0x0400000004010101), ABC_CONST(0x0400000000010101), ABC_CONST(0x0404040404010101), ABC_CONST(0x0404040400010101), ABC_CONST(0x0404040004010101), ABC_CONST(0x0404040000010101), ABC_CONST(0x0404000404010101), ABC_CONST(0x0404000400010101), ABC_CONST(0x0404000004010101), ABC_CONST(0x0404000000010101), ABC_CONST(0x0400040404010101), ABC_CONST(0x0400040400010101), ABC_CONST(0x0400040004010101), ABC_CONST(0x0400040000010101), ABC_CONST(0x0400000404010101), ABC_CONST(0x0400000400010101), ABC_CONST(0x0400000004010101), ABC_CONST(0x0400000000010101) },
    { ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202), ABC_CONST(0x0505050505020202), ABC_CONST(0x0505050500020202), ABC_CONST(0x0505050005020202), ABC_CONST(0x0505050000020202), ABC_CONST(0x0505000505020202), ABC_CONST(0x0505000500020202), ABC_CONST(0x0505000005020202), ABC_CONST(0x0505000000020202), ABC_CONST(0x0500050505020202), ABC_CONST(0x0500050500020202), ABC_CONST(0x0500050005020202), ABC_CONST(0x0500050000020202), ABC_CONST(0x0500000505020202), ABC_CONST(0x0500000500020202), ABC_CONST(0x0500000005020202), ABC_CONST(0x0500000000020202) },
    { ABC_CONST(0x0505050505020201), ABC_CONST(0x0505050500020201), ABC_CONST(0x0505050005020201), ABC_CONST(0x0505050000020201), ABC_CONST(0x0505000505020201), ABC_CONST(0x0505000500020201), ABC_CONST(0x0505000005020201), ABC_CONST(0x0505000000020201), ABC_CONST(0x0500050505020201), ABC_CONST(0x0500050500020201), ABC_CONST(0x0500050005020201), ABC_CONST(0x0500050000020201), ABC_CONST(0x0500000505020201), ABC_CONST(0x0500000500020201), ABC_CONST(0x0500000005020201), ABC_CONST(0x0500000000020201), ABC_CONST(0x0505050505020201), ABC_CONST(0x0505050500020201), ABC_CONST(0x0505050005020201), ABC_CONST(0x0505050000020201), ABC_CONST(0x0505000505020201), ABC_CONST(0x0505000500020201), ABC_CONST(0x0505000005020201), ABC_CONST(0x0505000000020201), ABC_CONST(0x0500050505020201), ABC_CONST(0x0500050500020201), ABC_CONST(0x0500050005020201), ABC_CONST(0x0500050000020201), ABC_CONST(0x0500000505020201), ABC_CONST(0x0500000500020201), ABC_CONST(0x0500000005020201), ABC_CONST(0x0500000000020201) },
    { ABC_CONST(0x0606060606030302), ABC_CONST(0x0606060600030302), ABC_CONST(0x0606060006030302), ABC_CONST(0x0606060000030302), ABC_CONST(0x0606000606030302), ABC_CONST(0x0606000600030302), ABC_CONST(0x0606000006030302), ABC_CONST(0x0606000000030302), ABC_CONST(0x0600060606030302), ABC_CONST(0x0600060600030302), ABC_CONST(0x0600060006030302), ABC_CONST(0x0600060000030302), ABC_CONST(0x0600000606030302), ABC_CONST(0x0600000600030302), ABC_CONST(0x0600000006030302), ABC_CONST(0x0600000000030302), ABC_CONST(0x0606060606030302), ABC_CONST(0x0606060600030302), ABC_CONST(0x0606060006030302), ABC_CONST(0x0606060000030302), ABC_CONST(0x0606000606030302), ABC_CONST(0x0606000600030302), ABC_CONST(0x0606000006030302), ABC_CONST(0x0606000000030302), ABC_CONST(0x0600060606030302), ABC_CONST(0x0600060600030302), ABC_CONST(0x0600060006030302), ABC_CONST(0x0600060000030302), ABC_CONST(0x0600000606030302), ABC_CONST(0x0600000600030302), ABC_CONST(0x0600000006030302), ABC_CONST(0x0600000000030302) },
    { ABC_CONST(0x0505050505020102), ABC_CONST(0x0505050500020102), ABC_CONST(0x0505050005020102), ABC_CONST(0x0505050000020102), ABC_CONST(0x0505000505020102), ABC_CONST(0x0505000500020102), ABC_CONST(0x0505000005020102), ABC_CONST(0x0505000000020102), ABC_CONST(0x0500050505020102), ABC_CONST(0x0500050500020102), ABC_CONST(0x0500050005020102), ABC_CONST(0x0500050000020102), ABC_CONST(0x0500000505020102), ABC_CONST(0x0500000500020102), ABC_CONST(0x0500000005020102), ABC_CONST(0x0500000000020102), ABC_CONST(0x0505050505020102), ABC_CONST(0x0505050500020102), ABC_CONST(0x0505050005020102), ABC_CONST(0x0505050000020102), ABC_CONST(0x0505000505020102), ABC_CONST(0x0505000500020102), ABC_CONST(0x0505000005020102), ABC_CONST(0x0505000000020102), ABC_CONST(0x0500050505020102), ABC_CONST(0x0500050500020102), ABC_CONST(0x0500050005020102), ABC_CONST(0x0500050000020102), ABC_CONST(0x0500000505020102), ABC_CONST(0x0500000500020102), ABC_CONST(0x0500000005020102), ABC_CONST(0x0500000000020102) },
    { ABC_CONST(0x0606060606030203), ABC_CONST(0x0606060600030203), ABC_CONST(0x0606060006030203), ABC_CONST(0x0606060000030203), ABC_CONST(0x0606000606030203), ABC_CONST(0x0606000600030203), ABC_CONST(0x0606000006030203), ABC_CONST(0x0606000000030203), ABC_CONST(0x0600060606030203), ABC_CONST(0x0600060600030203), ABC_CONST(0x0600060006030203), ABC_CONST(0x0600060000030203), ABC_CONST(0x0600000606030203), ABC_CONST(0x0600000600030203), ABC_CONST(0x0600000006030203), ABC_CONST(0x0600000000030203), ABC_CONST(0x0606060606030203), ABC_CONST(0x0606060600030203), ABC_CONST(0x0606060006030203), ABC_CONST(0x0606060000030203), ABC_CONST(0x0606000606030203), ABC_CONST(0x0606000600030203), ABC_CONST(0x0606000006030203), ABC_CONST(0x0606000000030203), ABC_CONST(0x0600060606030203), ABC_CONST(0x0600060600030203), ABC_CONST(0x0600060006030203), ABC_CONST(0x0600060000030203), ABC_CONST(0x0600000606030203), ABC_CONST(0x0600000600030203), ABC_CONST(0x0600000006030203), ABC_CONST(0x0600000000030203) },
    { ABC_CONST(0x0606060606030202), ABC_CONST(0x0606060600030202), ABC_CONST(0x0606060006030202), ABC_CONST(0x0606060000030202), ABC_CONST(0x0606000606030202), ABC_CONST(0x0606000600030202), ABC_CONST(0x0606000006030202), ABC_CONST(0x0606000000030202), ABC_CONST(0x0600060606030202), ABC_CONST(0x0600060600030202), ABC_CONST(0x0600060006030202), ABC_CONST(0x0600060000030202), ABC_CONST(0x0600000606030202), ABC_CONST(0x0600000600030202), ABC_CONST(0x0600000006030202), ABC_CONST(0x0600000000030202), ABC_CONST(0x0606060606030202), ABC_CONST(0x0606060600030202), ABC_CONST(0x0606060006030202), ABC_CONST(0x0606060000030202), ABC_CONST(0x0606000606030202), ABC_CONST(0x0606000600030202), ABC_CONST(0x0606000006030202), ABC_CONST(0x0606000000030202), ABC_CONST(0x0600060606030202), ABC_CONST(0x0600060600030202), ABC_CONST(0x0600060006030202), ABC_CONST(0x0600060000030202), ABC_CONST(0x0600000606030202), ABC_CONST(0x0600000600030202), ABC_CONST(0x0600000006030202), ABC_CONST(0x0600000000030202) },
    { ABC_CONST(0x0707070707040303), ABC_CONST(0x0707070700040303), ABC_CONST(0x0707070007040303), ABC_CONST(0x0707070000040303), ABC_CONST(0x0707000707040303), ABC_CONST(0x0707000700040303), ABC_CONST(0x0707000007040303), ABC_CONST(0x0707000000040303), ABC_CONST(0x0700070707040303), ABC_CONST(0x0700070700040303), ABC_CONST(0x0700070007040303), ABC_CONST(0x0700070000040303), ABC_CONST(0x0700000707040303), ABC_CONST(0x0700000700040303), ABC_CONST(0x0700000007040303), ABC_CONST(0x0700000000040303), ABC_CONST(0x0707070707040303), ABC_CONST(0x0707070700040303), ABC_CONST(0x0707070007040303), ABC_CONST(0x0707070000040303), ABC_CONST(0x0707000707040303), ABC_CONST(0x0707000700040303), ABC_CONST(0x0707000007040303), ABC_CONST(0x0707000000040303), ABC_CONST(0x0700070707040303), ABC_CONST(0x0700070700040303), ABC_CONST(0x0700070007040303), ABC_CONST(0x0700070000040303), ABC_CONST(0x0700000707040303), ABC_CONST(0x0700000700040303), ABC_CONST(0x0700000007040303), ABC_CONST(0x0700000000040303) },
    { ABC_CONST(0x0404040404000202), ABC_CONST(0x0404040400000202), ABC_CONST(0x0404040004000202), ABC_CONST(0x0404040000000202), ABC_CONST(0x0404000404000202), ABC_CONST(0x0404000400000202), ABC_CONST(0x0404000004000202), ABC_CONST(0x0404000000000202), ABC_CONST(0x0400040404000202), ABC_CONST(0x0400040400000202), ABC_CONST(0x0400040004000202), ABC_CONST(0x0400040000000202), ABC_CONST(0x0400000404000202), ABC_CONST(0x0400000400000202), ABC_CONST(0x0400000004000202), ABC_CONST(0x0400000000000202), ABC_CONST(0x0404040404000202), ABC_CONST(0x0404040400000202), ABC_CONST(0x0404040004000202), ABC_CONST(0x0404040000000202), ABC_CONST(0x0404000404000202), ABC_CONST(0x0404000400000202), ABC_CONST(0x0404000004000202), ABC_CONST(0x0404000000000202), ABC_CONST(0x0400040404000202), ABC_CONST(0x0400040400000202), ABC_CONST(0x0400040004000202), ABC_CONST(0x0400040000000202), ABC_CONST(0x0400000404000202), ABC_CONST(0x0400000400000202), ABC_CONST(0x0400000004000202), ABC_CONST(0x0400000000000202) },
    { ABC_CONST(0x0505050505010303), ABC_CONST(0x0505050500010303), ABC_CONST(0x0505050005010303), ABC_CONST(0x0505050000010303), ABC_CONST(0x0505000505010303), ABC_CONST(0x0505000500010303), ABC_CONST(0x0505000005010303), ABC_CONST(0x0505000000010303), ABC_CONST(0x0500050505010303), ABC_CONST(0x0500050500010303), ABC_CONST(0x0500050005010303), ABC_CONST(0x0500050000010303), ABC_CONST(0x0500000505010303), ABC_CONST(0x0500000500010303), ABC_CONST(0x0500000005010303), ABC_CONST(0x0500000000010303), ABC_CONST(0x0505050505010303), ABC_CONST(0x0505050500010303), ABC_CONST(0x0505050005010303), ABC_CONST(0x0505050000010303), ABC_CONST(0x0505000505010303), ABC_CONST(0x0505000500010303), ABC_CONST(0x0505000005010303), ABC_CONST(0x0505000000010303), ABC_CONST(0x0500050505010303), ABC_CONST(0x0500050500010303), ABC_CONST(0x0500050005010303), ABC_CONST(0x0500050000010303), ABC_CONST(0x0500000505010303), ABC_CONST(0x0500000500010303), ABC_CONST(0x0500000005010303), ABC_CONST(0x0500000000010303) },
    { ABC_CONST(0x0505050505010302), ABC_CONST(0x0505050500010302), ABC_CONST(0x0505050005010302), ABC_CONST(0x0505050000010302), ABC_CONST(0x0505000505010302), ABC_CONST(0x0505000500010302), ABC_CONST(0x0505000005010302), ABC_CONST(0x0505000000010302), ABC_CONST(0x0500050505010302), ABC_CONST(0x0500050500010302), ABC_CONST(0x0500050005010302), ABC_CONST(0x0500050000010302), ABC_CONST(0x0500000505010302), ABC_CONST(0x0500000500010302), ABC_CONST(0x0500000005010302), ABC_CONST(0x0500000000010302), ABC_CONST(0x0505050505010302), ABC_CONST(0x0505050500010302), ABC_CONST(0x0505050005010302), ABC_CONST(0x0505050000010302), ABC_CONST(0x0505000505010302), ABC_CONST(0x0505000500010302), ABC_CONST(0x0505000005010302), ABC_CONST(0x0505000000010302), ABC_CONST(0x0500050505010302), ABC_CONST(0x0500050500010302), ABC_CONST(0x0500050005010302), ABC_CONST(0x0500050000010302), ABC_CONST(0x0500000505010302), ABC_CONST(0x0500000500010302), ABC_CONST(0x0500000005010302), ABC_CONST(0x0500000000010302) },
    { ABC_CONST(0x0606060606020403), ABC_CONST(0x0606060600020403), ABC_CONST(0x0606060006020403), ABC_CONST(0x0606060000020403), ABC_CONST(0x0606000606020403), ABC_CONST(0x0606000600020403), ABC_CONST(0x0606000006020403), ABC_CONST(0x0606000000020403), ABC_CONST(0x0600060606020403), ABC_CONST(0x0600060600020403), ABC_CONST(0x0600060006020403), ABC_CONST(0x0600060000020403), ABC_CONST(0x0600000606020403), ABC_CONST(0x0600000600020403), ABC_CONST(0x0600000006020403), ABC_CONST(0x0600000000020403), ABC_CONST(0x0606060606020403), ABC_CONST(0x0606060600020403), ABC_CONST(0x0606060006020403), ABC_CONST(0x0606060000020403), ABC_CONST(0x0606000606020403), ABC_CONST(0x0606000600020403), ABC_CONST(0x0606000006020403), ABC_CONST(0x0606000000020403), ABC_CONST(0x0600060606020403), ABC_CONST(0x0600060600020403), ABC_CONST(0x0600060006020403), ABC_CONST(0x0600060000020403), ABC_CONST(0x0600000606020403), ABC_CONST(0x0600000600020403), ABC_CONST(0x0600000006020403), ABC_CONST(0x0600000000020403) },
    { ABC_CONST(0x0505050505010203), ABC_CONST(0x0505050500010203), ABC_CONST(0x0505050005010203), ABC_CONST(0x0505050000010203), ABC_CONST(0x0505000505010203), ABC_CONST(0x0505000500010203), ABC_CONST(0x0505000005010203), ABC_CONST(0x0505000000010203), ABC_CONST(0x0500050505010203), ABC_CONST(0x0500050500010203), ABC_CONST(0x0500050005010203), ABC_CONST(0x0500050000010203), ABC_CONST(0x0500000505010203), ABC_CONST(0x0500000500010203), ABC_CONST(0x0500000005010203), ABC_CONST(0x0500000000010203), ABC_CONST(0x0505050505010203), ABC_CONST(0x0505050500010203), ABC_CONST(0x0505050005010203), ABC_CONST(0x0505050000010203), ABC_CONST(0x0505000505010203), ABC_CONST(0x0505000500010203), ABC_CONST(0x0505000005010203), ABC_CONST(0x0505000000010203), ABC_CONST(0x0500050505010203), ABC_CONST(0x0500050500010203), ABC_CONST(0x0500050005010203), ABC_CONST(0x0500050000010203), ABC_CONST(0x0500000505010203), ABC_CONST(0x0500000500010203), ABC_CONST(0x0500000005010203), ABC_CONST(0x0500000000010203) },
    { ABC_CONST(0x0606060606020304), ABC_CONST(0x0606060600020304), ABC_CONST(0x0606060006020304), ABC_CONST(0x0606060000020304), ABC_CONST(0x0606000606020304), ABC_CONST(0x0606000600020304), ABC_CONST(0x0606000006020304), ABC_CONST(0x0606000000020304), ABC_CONST(0x0600060606020304), ABC_CONST(0x0600060600020304), ABC_CONST(0x0600060006020304), ABC_CONST(0x0600060000020304), ABC_CONST(0x0600000606020304), ABC_CONST(0x0600000600020304), ABC_CONST(0x0600000006020304), ABC_CONST(0x0600000000020304), ABC_CONST(0x0606060606020304), ABC_CONST(0x0606060600020304), ABC_CONST(0x0606060006020304), ABC_CONST(0x0606060000020304), ABC_CONST(0x0606000606020304), ABC_CONST(0x0606000600020304), ABC_CONST(0x0606000006020304), ABC_CONST(0x0606000000020304), ABC_CONST(0x0600060606020304), ABC_CONST(0x0600060600020304), ABC_CONST(0x0600060006020304), ABC_CONST(0x0600060000020304), ABC_CONST(0x0600000606020304), ABC_CONST(0x0600000600020304), ABC_CONST(0x0600000006020304), ABC_CONST(0x0600000000020304) },
    { ABC_CONST(0x0606060606020303), ABC_CONST(0x0606060600020303), ABC_CONST(0x0606060006020303), ABC_CONST(0x0606060000020303), ABC_CONST(0x0606000606020303), ABC_CONST(0x0606000600020303), ABC_CONST(0x0606000006020303), ABC_CONST(0x0606000000020303), ABC_CONST(0x0600060606020303), ABC_CONST(0x0600060600020303), ABC_CONST(0x0600060006020303), ABC_CONST(0x0600060000020303), ABC_CONST(0x0600000606020303), ABC_CONST(0x0600000600020303), ABC_CONST(0x0600000006020303), ABC_CONST(0x0600000000020303), ABC_CONST(0x0606060606020303), ABC_CONST(0x0606060600020303), ABC_CONST(0x0606060006020303), ABC_CONST(0x0606060000020303), ABC_CONST(0x0606000606020303), ABC_CONST(0x0606000600020303), ABC_CONST(0x0606000006020303), ABC_CONST(0x0606000000020303), ABC_CONST(0x0600060606020303), ABC_CONST(0x0600060600020303), ABC_CONST(0x0600060006020303), ABC_CONST(0x0600060000020303), ABC_CONST(0x0600000606020303), ABC_CONST(0x0600000600020303), ABC_CONST(0x0600000006020303), ABC_CONST(0x0600000000020303) },
    { ABC_CONST(0x0707070707030404), ABC_CONST(0x0707070700030404), ABC_CONST(0x0707070007030404), ABC_CONST(0x0707070000030404), ABC_CONST(0x0707000707030404), ABC_CONST(0x0707000700030404), ABC_CONST(0x0707000007030404), ABC_CONST(0x0707000000030404), ABC_CONST(0x0700070707030404), ABC_CONST(0x0700070700030404), ABC_CONST(0x0700070007030404), ABC_CONST(0x0700070000030404), ABC_CONST(0x0700000707030404), ABC_CONST(0x0700000700030404), ABC_CONST(0x0700000007030404), ABC_CONST(0x0700000000030404), ABC_CONST(0x0707070707030404), ABC_CONST(0x0707070700030404), ABC_CONST(0x0707070007030404), ABC_CONST(0x0707070000030404), ABC_CONST(0x0707000707030404), ABC_CONST(0x0707000700030404), ABC_CONST(0x0707000007030404), ABC_CONST(0x0707000000030404), ABC_CONST(0x0700070707030404), ABC_CONST(0x0700070700030404), ABC_CONST(0x0700070007030404), ABC_CONST(0x0700070000030404), ABC_CONST(0x0700000707030404), ABC_CONST(0x0700000700030404), ABC_CONST(0x0700000007030404), ABC_CONST(0x0700000000030404) },
    { ABC_CONST(0x0505050505010202), ABC_CONST(0x0505050500010202), ABC_CONST(0x0505050005010202), ABC_CONST(0x0505050000010202), ABC_CONST(0x0505000505010202), ABC_CONST(0x0505000500010202), ABC_CONST(0x0505000005010202), ABC_CONST(0x0505000000010202), ABC_CONST(0x0500050505010202), ABC_CONST(0x0500050500010202), ABC_CONST(0x0500050005010202), ABC_CONST(0x0500050000010202), ABC_CONST(0x0500000505010202), ABC_CONST(0x0500000500010202), ABC_CONST(0x0500000005010202), ABC_CONST(0x0500000000010202), ABC_CONST(0x0505050505010202), ABC_CONST(0x0505050500010202), ABC_CONST(0x0505050005010202), ABC_CONST(0x0505050000010202), ABC_CONST(0x0505000505010202), ABC_CONST(0x0505000500010202), ABC_CONST(0x0505000005010202), ABC_CONST(0x0505000000010202), ABC_CONST(0x0500050505010202), ABC_CONST(0x0500050500010202), ABC_CONST(0x0500050005010202), ABC_CONST(0x0500050000010202), ABC_CONST(0x0500000505010202), ABC_CONST(0x0500000500010202), ABC_CONST(0x0500000005010202), ABC_CONST(0x0500000000010202) },
    { ABC_CONST(0x0606060606020303), ABC_CONST(0x0606060600020303), ABC_CONST(0x0606060006020303), ABC_CONST(0x0606060000020303), ABC_CONST(0x0606000606020303), ABC_CONST(0x0606000600020303), ABC_CONST(0x0606000006020303), ABC_CONST(0x0606000000020303), ABC_CONST(0x0600060606020303), ABC_CONST(0x0600060600020303), ABC_CONST(0x0600060006020303), ABC_CONST(0x0600060000020303), ABC_CONST(0x0600000606020303), ABC_CONST(0x0600000600020303), ABC_CONST(0x0600000006020303), ABC_CONST(0x0600000000020303), ABC_CONST(0x0606060606020303), ABC_CONST(0x0606060600020303), ABC_CONST(0x0606060006020303), ABC_CONST(0x0606060000020303), ABC_CONST(0x0606000606020303), ABC_CONST(0x0606000600020303), ABC_CONST(0x0606000006020303), ABC_CONST(0x0606000000020303), ABC_CONST(0x0600060606020303), ABC_CONST(0x0600060600020303), ABC_CONST(0x0600060006020303), ABC_CONST(0x0600060000020303), ABC_CONST(0x0600000606020303), ABC_CONST(0x0600000600020303), ABC_CONST(0x0600000006020303), ABC_CONST(0x0600000000020303) },
    { ABC_CONST(0x0606060606020302), ABC_CONST(0x0606060600020302), ABC_CONST(0x0606060006020302), ABC_CONST(0x0606060000020302), ABC_CONST(0x0606000606020302), ABC_CONST(0x0606000600020302), ABC_CONST(0x0606000006020302), ABC_CONST(0x0606000000020302), ABC_CONST(0x0600060606020302), ABC_CONST(0x0600060600020302), ABC_CONST(0x0600060006020302), ABC_CONST(0x0600060000020302), ABC_CONST(0x0600000606020302), ABC_CONST(0x0600000600020302), ABC_CONST(0x0600000006020302), ABC_CONST(0x0600000000020302), ABC_CONST(0x0606060606020302), ABC_CONST(0x0606060600020302), ABC_CONST(0x0606060006020302), ABC_CONST(0x0606060000020302), ABC_CONST(0x0606000606020302), ABC_CONST(0x0606000600020302), ABC_CONST(0x0606000006020302), ABC_CONST(0x0606000000020302), ABC_CONST(0x0600060606020302), ABC_CONST(0x0600060600020302), ABC_CONST(0x0600060006020302), ABC_CONST(0x0600060000020302), ABC_CONST(0x0600000606020302), ABC_CONST(0x0600000600020302), ABC_CONST(0x0600000006020302), ABC_CONST(0x0600000000020302) },
    { ABC_CONST(0x0707070707030403), ABC_CONST(0x0707070700030403), ABC_CONST(0x0707070007030403), ABC_CONST(0x0707070000030403), ABC_CONST(0x0707000707030403), ABC_CONST(0x0707000700030403), ABC_CONST(0x0707000007030403), ABC_CONST(0x0707000000030403), ABC_CONST(0x0700070707030403), ABC_CONST(0x0700070700030403), ABC_CONST(0x0700070007030403), ABC_CONST(0x0700070000030403), ABC_CONST(0x0700000707030403), ABC_CONST(0x0700000700030403), ABC_CONST(0x0700000007030403), ABC_CONST(0x0700000000030403), ABC_CONST(0x0707070707030403), ABC_CONST(0x0707070700030403), ABC_CONST(0x0707070007030403), ABC_CONST(0x0707070000030403), ABC_CONST(0x0707000707030403), ABC_CONST(0x0707000700030403), ABC_CONST(0x0707000007030403), ABC_CONST(0x0707000000030403), ABC_CONST(0x0700070707030403), ABC_CONST(0x0700070700030403), ABC_CONST(0x0700070007030403), ABC_CONST(0x0700070000030403), ABC_CONST(0x0700000707030403), ABC_CONST(0x0700000700030403), ABC_CONST(0x0700000007030403), ABC_CONST(0x0700000000030403) },
    { ABC_CONST(0x0606060606020203), ABC_CONST(0x0606060600020203), ABC_CONST(0x0606060006020203), ABC_CONST(0x0606060000020203), ABC_CONST(0x0606000606020203), ABC_CONST(0x0606000600020203), ABC_CONST(0x0606000006020203), ABC_CONST(0x0606000000020203), ABC_CONST(0x0600060606020203), ABC_CONST(0x0600060600020203), ABC_CONST(0x0600060006020203), ABC_CONST(0x0600060000020203), ABC_CONST(0x0600000606020203), ABC_CONST(0x0600000600020203), ABC_CONST(0x0600000006020203), ABC_CONST(0x0600000000020203), ABC_CONST(0x0606060606020203), ABC_CONST(0x0606060600020203), ABC_CONST(0x0606060006020203), ABC_CONST(0x0606060000020203), ABC_CONST(0x0606000606020203), ABC_CONST(0x0606000600020203), ABC_CONST(0x0606000006020203), ABC_CONST(0x0606000000020203), ABC_CONST(0x0600060606020203), ABC_CONST(0x0600060600020203), ABC_CONST(0x0600060006020203), ABC_CONST(0x0600060000020203), ABC_CONST(0x0600000606020203), ABC_CONST(0x0600000600020203), ABC_CONST(0x0600000006020203), ABC_CONST(0x0600000000020203) },
    { ABC_CONST(0x0707070707030304), ABC_CONST(0x0707070700030304), ABC_CONST(0x0707070007030304), ABC_CONST(0x0707070000030304), ABC_CONST(0x0707000707030304), ABC_CONST(0x0707000700030304), ABC_CONST(0x0707000007030304), ABC_CONST(0x0707000000030304), ABC_CONST(0x0700070707030304), ABC_CONST(0x0700070700030304), ABC_CONST(0x0700070007030304), ABC_CONST(0x0700070000030304), ABC_CONST(0x0700000707030304), ABC_CONST(0x0700000700030304), ABC_CONST(0x0700000007030304), ABC_CONST(0x0700000000030304), ABC_CONST(0x0707070707030304), ABC_CONST(0x0707070700030304), ABC_CONST(0x0707070007030304), ABC_CONST(0x0707070000030304), ABC_CONST(0x0707000707030304), ABC_CONST(0x0707000700030304), ABC_CONST(0x0707000007030304), ABC_CONST(0x0707000000030304), ABC_CONST(0x0700070707030304), ABC_CONST(0x0700070700030304), ABC_CONST(0x0700070007030304), ABC_CONST(0x0700070000030304), ABC_CONST(0x0700000707030304), ABC_CONST(0x0700000700030304), ABC_CONST(0x0700000007030304), ABC_CONST(0x0700000000030304) },
    { ABC_CONST(0x0707070707030303), ABC_CONST(0x0707070700030303), ABC_CONST(0x0707070007030303), ABC_CONST(0x0707070000030303), ABC_CONST(0x0707000707030303), ABC_CONST(0x0707000700030303), ABC_CONST(0x0707000007030303), ABC_CONST(0x0707000000030303), ABC_CONST(0x0700070707030303), ABC_CONST(0x0700070700030303), ABC_CONST(0x0700070007030303), ABC_CONST(0x0700070000030303), ABC_CONST(0x0700000707030303), ABC_CONST(0x0700000700030303), ABC_CONST(0x0700000007030303), ABC_CONST(0x0700000000030303), ABC_CONST(0x0707070707030303), ABC_CONST(0x0707070700030303), ABC_CONST(0x0707070007030303), ABC_CONST(0x0707070000030303), ABC_CONST(0x0707000707030303), ABC_CONST(0x0707000700030303), ABC_CONST(0x0707000007030303), ABC_CONST(0x0707000000030303), ABC_CONST(0x0700070707030303), ABC_CONST(0x0700070700030303), ABC_CONST(0x0700070007030303), ABC_CONST(0x0700070000030303), ABC_CONST(0x0700000707030303), ABC_CONST(0x0700000700030303), ABC_CONST(0x0700000007030303), ABC_CONST(0x0700000000030303) },
    { ABC_CONST(0x0808080808040404), ABC_CONST(0x0808080800040404), ABC_CONST(0x0808080008040404), ABC_CONST(0x0808080000040404), ABC_CONST(0x0808000808040404), ABC_CONST(0x0808000800040404), ABC_CONST(0x0808000008040404), ABC_CONST(0x0808000000040404), ABC_CONST(0x0800080808040404), ABC_CONST(0x0800080800040404), ABC_CONST(0x0800080008040404), ABC_CONST(0x0800080000040404), ABC_CONST(0x0800000808040404), ABC_CONST(0x0800000800040404), ABC_CONST(0x0800000008040404), ABC_CONST(0x0800000000040404), ABC_CONST(0x0808080808040404), ABC_CONST(0x0808080800040404), ABC_CONST(0x0808080008040404), ABC_CONST(0x0808080000040404), ABC_CONST(0x0808000808040404), ABC_CONST(0x0808000800040404), ABC_CONST(0x0808000008040404), ABC_CONST(0x0808000000040404), ABC_CONST(0x0800080808040404), ABC_CONST(0x0800080800040404), ABC_CONST(0x0800080008040404), ABC_CONST(0x0800080000040404), ABC_CONST(0x0800000808040404), ABC_CONST(0x0800000800040404), ABC_CONST(0x0800000008040404), ABC_CONST(0x0800000000040404) }
};


////////////////////////////////////////////////////////////////////////
///                     FUNCTION DEFINITIONS                         ///
////////////////////////////////////////////////////////////////////////
 
/**Function*************************************************************

  Synopsis    []

  Description []
               
  SideEffects []

  SeeAlso     []

***********************************************************************/
void Abc_TtCountGenerate()
{
    static word s_CMasks6[3] = {
        ABC_CONST(0x5555555555555555),
        ABC_CONST(0x3333333333333333),
        ABC_CONST(0x0F0F0F0F0F0F0F0F)
    };
    static int bit_count[256] = {
      0,1,1,2,1,2,2,3,1,2,2,3,2,3,3,4,1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,
      1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
      1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
      2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
      1,2,2,3,2,3,3,4,2,3,3,4,3,4,4,5,2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,
      2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
      2,3,3,4,3,4,4,5,3,4,4,5,4,5,5,6,3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,
      3,4,4,5,4,5,5,6,4,5,5,6,5,6,6,7,4,5,5,6,5,6,6,7,5,6,6,7,6,7,7,8
    };
    int i, k, c;
    printf("{ ");
    for ( i = 0; i < 256; i++, printf(" },\n{ ") )
    for ( k = 0; k <  32; k++ )
    {
        printf( "ABC_CONST(0x0%d", bit_count[i] );
        for ( c = 3; c >= 0; c-- )
            printf( "0%d", (((k >> c) & 1) == 0) * bit_count[i]  );
        for ( c = 2; c >= 0; c-- )
            printf( "0%d", bit_count[s_CMasks6[c] & i] );
        printf( ")%s", k == 31 ? "":", " );
    }
}

/**Function*************************************************************

  Synopsis    []

  Description []
               
  SideEffects []

  SeeAlso     []

***********************************************************************/
int Abc_TtCountOnesInCofsQuick_rec( word * pTruth, int nVars, int * pStore )
{
    if ( nVars <= 8 )
    {
        word Res = 0;
        unsigned char * pResC = (unsigned char *)&Res;
        unsigned char * pTruthC = (unsigned char *)pTruth;
        int i, nBytes = nVars <= 6 ? 4 : 1 << (nVars-4), nBytes2 = nBytes << 1;
        assert( nVars >= 1 && nVars <= 8 );
        for ( i = 0; i < nBytes; i++ )
            Res += Table[pTruthC[i]][i];
        if ( nVars == 8 )
            pStore[7] += pResC[7];
        for (      ; i < nBytes2; i++ )
            Res += Table[pTruthC[i]][i];
        for ( i = 0; i < nVars-1; i++ )
            pStore[i] += pResC[i];
        if ( nVars < 8 )
            pStore[nVars-1] += pResC[nVars-1];
        return (int)pResC[7];
    }
    else
    {
        int Res1 = Abc_TtCountOnesInCofsQuick_rec( pTruth,                    nVars-1, pStore );
        int Res2 = Abc_TtCountOnesInCofsQuick_rec( pTruth + (1 << (nVars-7)), nVars-1, pStore );
        pStore[nVars-1] = Res1;
        return Res1 + Res2;
    }
}
int Abc_TtCountOnesInCofsQuick( word * pTruth, int nVars, int * pStore )
{
    if ( nVars == 0 )
        return (int)(pTruth[0] & 1);
    memset( pStore, 0, sizeof(int)*nVars );
    return Abc_TtCountOnesInCofsQuick_rec( pTruth, nVars, pStore );
}


/**Function*************************************************************

  Synopsis    []

  Description []
               
  SideEffects []

  SeeAlso     []

***********************************************************************/
void Abc_TtCountOnesInCofsTest2()
{
    word Truth = ABC_CONST(0x5555555555555555) & ABC_CONST(0x3333333333333333);

    int Store1[8] = {0}, Store2[8] = {0};
    int i, Res1, Res2;

    Res1 = Abc_TtCountOnesInCofsSimple( &Truth, 2, Store1 );
    Res2 = Abc_TtCountOnesInCofsQuick( &Truth, 2, Store2 );
    assert( Res1 == Res2 );
    for ( i = 0; i < 8; i++ )
        assert( Store1[i] == Store2[i] );

}
void Abc_TtCountOnesInCofsTest()
{
    word Truth[4] = {0};
    int Store1[8] = {0}, Store2[8] = {0};
    int n, i, k, Res1, Res2;
    srand( time(NULL) );
    for ( n = 0; n < 1000000; n++ )
    {
        for ( i = 0; i < 4; i++ )
        for ( k = 0; k < 8; k++ )
            Truth[i] ^= (word)(rand() & 0xFF) << (k << 3);
        Res1 = Abc_TtCountOnesInCofsSimple( Truth, 8, Store1 );
        Res2 = Abc_TtCountOnesInCofsQuick( Truth, 8, Store2 );
        assert( Res1 == Res2 );
        for ( i = 0; i < 8; i++ )
            assert( Store1[i] == Store2[i] );
    }
}


////////////////////////////////////////////////////////////////////////
///                       END OF FILE                                ///
////////////////////////////////////////////////////////////////////////


ABC_NAMESPACE_IMPL_END

