/*
 * Decompiled with CFR 0.152.
 */
package de.jarnbjo.jsnappy;

import de.jarnbjo.jsnappy.Buffer;
import de.jarnbjo.jsnappy.MapBasedCompressor;
import de.jarnbjo.jsnappy.TableBasedCompressor;

public class SnappyCompressor {
    public static final int DEFAULT_EFFORT = 1;

    private SnappyCompressor() {
    }

    public static Buffer compress(byte[] in) {
        return SnappyCompressor.compress(in, 0, in.length, null);
    }

    public static Buffer compress(byte[] in, Buffer out) {
        return SnappyCompressor.compress(in, 0, in.length, out);
    }

    public static Buffer compress(byte[] in, int offset, int length) {
        return SnappyCompressor.compress(in, offset, length, null);
    }

    public static Buffer compress(Buffer in) {
        return SnappyCompressor.compress(in.getData(), 0, in.getLength(), null);
    }

    public static Buffer compress(Buffer in, Buffer out) {
        return SnappyCompressor.compress(in.getData(), 0, in.getLength(), out);
    }

    public static Buffer compress(byte[] in, int offset, int length, Buffer out) {
        return SnappyCompressor.compress(in, offset, length, out, 1);
    }

    public static Buffer compress(byte[] in, int offset, int length, Buffer out, int effort) {
        if (effort < 1 || effort > 100) {
            throw new IllegalArgumentException("Compression effort must be an integer from 0 (fastest, less compression) to 100 (slowest, highest compression)");
        }
        if (effort < 30) {
            return TableBasedCompressor.compress(in, offset, length, out);
        }
        if (effort < 70) {
            return MapBasedCompressor.compress(in, offset, length, out, true);
        }
        return MapBasedCompressor.compress(in, offset, length, out, false);
    }
}

