#include "Bdef.h"

void cgupk_amx2(MatInf, buff)
MATINFO  *MatInf;
char  *buff;
{
   int m, n, lda, j, k, r, i;
   float *A, *v, diff;

   m = MatInf->M;
   n = MatInf->N;
   lda = 2 * MatInf->lda;
   A = (float *) MatInf->A;
   v = (float *) buff;

   if (m != 1)
   {
      k = 2 * m;
      for (j=n; j; j--)
      {
         i = pvm_upkcplx(v, m, 1);
         Mpvmerror(i, "pvm_upkcplx", __LINE__, __FILE__);
         for (r=0, i=1; r != k; r += 2, i += 2)
         {
            diff = (Rabs(A[r]) + Rabs(A[i])) - (Rabs(v[r]) + Rabs(v[i]));
            if (diff < 0)
            {
               A[r] = v[r];
               A[i] = v[i];
            }
            else if (diff == 0)
            {
               if (A[r] != v[r])
               {
                  if (A[r] < v[r])
                  {
                     A[r] = v[r];
                     A[i] = v[i];
                  }
               }
               else if (A[i] < v[i])
               {
                  A[r] = v[r];
                  A[i] = v[i];
               }
            }
         }
         A += lda;
      }
   }
   else
   {
      i = pvm_upkcplx(v, n, 1);
      Mpvmerror(i, "pvm_upkcplx", __LINE__, __FILE__);
      k = 2 * n;
      for (r=0, i=1; r != k; r += 2, i += 2)
      {
         diff = (Rabs(A[0]) + Rabs(A[1])) - (Rabs(v[r]) + Rabs(v[i]));
         if (diff < 0)
         {
            A[0] = v[r];
            A[1] = v[i];
         }
         else if (diff == 0)
         {
            if (A[0] != v[r])
            {
               if (A[0] < v[r])
               {
                  A[0] = v[r];
                  A[1] = v[i];
               }
            }
            else if (A[1] < v[i])
            {
               A[0] = v[r];
               A[1] = v[i];
            }
         }
         A += lda;
      }
   }
}
