/***************************************************************************
 *   Copyright (C) 2008 by Benjamin Knispel                                *
 *   benjamin.knispel[AT]aei.mpg.de                                        *
 *   Copyright (C) 2009, 2010 by Oliver Bock                               *
 *   oliver.bock[AT]aei.mpg.de                                             *
 *                                                                         *
 *   This file is part of Einstein@Home (Radio Pulsar Edition).            *
 *                                                                         *
 *   Einstein@Home is free software: you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published     *
 *   by the Free Software Foundation, version 2 of the License.            *
 *                                                                         *
 *   Einstein@Home is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with Einstein@Home. If not, see <http://www.gnu.org/licenses/>. *
 *                                                                         *
 ***************************************************************************/

#ifndef STRUCTS_H
#define STRUCTS_H

/*
 TODO:
 - checksum
 */

// useful definitions
#define FN_LENGTH 256       // length of the filenames
#define N_BINS_SS 40        // number of bins in the screensaver powerspectrum
#define MICROSEC 1.0e-6     // conversion factor from seconds to microseconds
#define MEGAHZ 1.0e6        // conversion factor from Hz to MHz

#include <stdint.h>

//header struct from data files
struct data_header
{
  double tsample;		// Sample time in us
  double tobs;		       	// Observation time in s
  double timestamp;	       	// Time stamp (MJD)
  double fcenter;	       	// Center freq in MHz
  double fchan;		       	// Channel band in kHz
  double RA;		        // right ascencsion (J2000)
  double DEC;			// declination (J2000)
  double gal_l;		       	// galactic longitude
  double gal_b;		       	// galactic latitude
  double AZstart;	       	// AZ at start
  double ZAstart;	       	// ZA at start
  double ASTstart;	       	// AST at start
  double LSTstart;	       	// LST at start
  uint32_t filesize;		// filesize in bytes -> refers to the file generated by filterbank, not the file in which this header sits
  uint32_t datasize;		// datasize in bytes -> refers to the file generated by filterbank, not the file in which this header sits
  uint32_t nsamples;		// number of samples
  uint16_t smprec;	       	// Number of samples/record
  uint16_t nchan;     	       	// Number of channels/record
  uint16_t nifs;              	// Nifs = number of IF channels -> for PALFA channel 1 contains sum of two polarizations
  uint16_t lagformat;	       	// lagformat
  uint16_t sum;		       	// sum
  uint16_t level;      	       	// level
  char name[FN_LENGTH];	       	// name of the object
  char originalfile[FN_LENGTH];	// Original WAPP file
  char proj_id[FN_LENGTH];	// project ID
  char observers[FN_LENGTH];	// observers
} __attribute__((__packed__));

typedef struct data_header Data_Header;


//header struct for dedispersed time series
struct dd_header
{
  double tsample;		// Sample time in us
  double tobs;		       	// Observation time in s
  double timestamp;	       	// Time stamp (MJD)
  double fcenter;	       	// Center freq in MHz
  double fchan;		       	// Channel band in kHz
  double RA;		        // right ascencsion (J2000)
  double DEC;			// declination (J2000)
  double gal_l;		       	// galactic longitude
  double gal_b;		       	// galactic latitude
  double AZstart;	       	// AZ at start
  double ZAstart;	       	// ZA at start
  double ASTstart;	       	// AST at start
  double LSTstart;	       	// LST at start
  double DM;                    // trial dispersion measure value pc cm^{-3}
  double scale;                 // scale factor for compressed data. If compressed data value = 1, uncompressed value is 1/scale
  uint32_t filesize;		// filesize in bytes -> refers to the file generated by filterbank, not the file in which this header sits
  uint32_t datasize;		// datasize in bytes -> refers to the file generated by filterbank, not the file in which this header sits
  uint32_t nsamples;		// number of samples
  uint16_t smprec;            	// Number of samples/record
  uint16_t nchan;      	       	// Number of channels/record
  uint16_t nifs;       	       	// Nifs = number of polarizations -> for PALFA channel 1 contains sum of two polarizations
  uint16_t lagformat;	       	// lagformat
  uint16_t sum;		       	// sum
  uint16_t level;     	       	// level
  char name[FN_LENGTH];	       	// name of the object
  char originalfile[FN_LENGTH];	// Original WAPP file
  char proj_id[FN_LENGTH];	// project ID
  char observers[FN_LENGTH];	// observers

} __attribute__((__packed__));

typedef struct dd_header DD_Header;


//header for checkpointing file
struct cp_header
{
  uint32_t n_template;		// #(template) in the bank that was used most recently
  char originalfile[FN_LENGTH];	// name of the dedispersed timeseries file
} __attribute__((__packed__));

typedef struct cp_header CP_Header;


//struct for candidates in checkpointing file
struct cp_cand
{
  double power;                 // demodulated power
  double P_b;                   // binary period
  double tau;                   // projected orbital radius
  double Psi;                   // initial orbital phase
  double fA;                    // corresponding false alarm rate
  uint32_t n_harm;              // number of summed harmonics
  uint32_t f0;                 // intrinsic spin frequency bin in FFT
} __attribute__((__packed__));

typedef struct cp_cand CP_cand;


#ifndef BOINCIFIED
//struct for communication with screensaver over shared memory
struct pulsar_search {
  double skypos_rac;
  double skypos_dec;
  double dispersion_measure;
  double orbital_radius;
  double orbital_period;
  double orbital_phase;
  unsigned char power_spectrum[N_BINS_SS];
} __attribute__((__packed__));
typedef struct pulsar_search t_pulsar_search;
#endif


// struct for passing parameters efficiently to resampling function
typedef struct {
    unsigned int nsamples;
    unsigned int nsamples_unpadded;
    unsigned int fft_size;
    float tau;
    float Omega;
    float Psi0;
    float dt;
    float step_inv;
    float S0;
} RESAMP_PARAMS;

#endif
