//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/Model/Data/ProjectionItems.h
//! @brief     Defines items related to projections over color map.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_MODEL_DATA_PROJECTIONITEMS_H
#define BORNAGAIN_GUI_MODEL_DATA_PROJECTIONITEMS_H

#include "GUI/Model/Data/MaskItems.h"
#include "GUI/Support/Data/ID.h"

//! A container to hold ProjectionItems, intended to store projections of color map on X, Y axes.

class ProjectionContainerItem : public MaskContainerItem {
public:
    ProjectionContainerItem();

    QVector<MaskItem*> projectionsOfType(GUI::ID::ProjectionType projectionType);

private:
    template <typename LineType>
    QVector<MaskItem*> projections()
    {
        QVector<MaskItem*> result;
        for (const auto& proj : m_maskItems)
            if (dynamic_cast<LineType*>(proj.currentItem()))
                result.push_back(proj.currentItem());
        return result;
    }
};


#endif // BORNAGAIN_GUI_MODEL_DATA_PROJECTIONITEMS_H
