//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/PlotUtil/PlotStatusLabel.h
//! @brief     Defines class PlotStatusLabel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_PLOTUTIL_PLOTSTATUSLABEL_H
#define BORNAGAIN_GUI_VIEW_PLOTUTIL_PLOTSTATUSLABEL_H

#include "GUI/View/PlotUtil/StatusLabel.h"
#include <QList>

class ScientificPlot;

//! The PlotStatusLabel class shows status string as reported by DescriptedPlot in a frame.
//! Can work with more than one DescriptedPlot. Provides automatic adjustment of font size,
//! depending on available space in parent layout. Also doesn't trigger layout resize,
//! being happy with place it has.

class PlotStatusLabel : public StatusLabel {
    Q_OBJECT
public:
    PlotStatusLabel(ScientificPlot* plot, QWidget* parent = nullptr);

    void addPlot(ScientificPlot* plot);

    void setLabelEnabled(bool flag);

    void reset();

public slots:
    void onPlotStatusString(const QString& text);

private slots:
    void onPlotDestroyed(QObject* obj);

private:
    void setPlotLabelEnabled(ScientificPlot* plot, bool flag);
    void setConnected(ScientificPlot* plot, bool flag) const;

    QList<ScientificPlot*> m_plots;
};

#endif // BORNAGAIN_GUI_VIEW_PLOTUTIL_PLOTSTATUSLABEL_H
