set(BA_ARCHITECTURE linux)
set(BA_PLATFORM linux)

if(CMAKE_SIZEOF_VOID_P GREATER 4)
    message(STATUS "Found a 64bit system")
    if(${CMAKE_SYSTEM_PROCESSOR} STREQUAL x86_64)
        set(BA_ARCHITECTURE linux_x64)
    endif()
else()
    message(STATUS "Found a 32bit system, not covered by our CI tests - proceed on your own risk")
endif()

set(CMAKE_CXX_FLAGS_RELWITHDEBINFO "-O2 -g")
set(CMAKE_CXX_FLAGS_RELEASE        "-O3")
set(CMAKE_CXX_FLAGS_DEBUG          "-g")
set(CMAKE_C_FLAGS_RELWITHDEBINFO   "-O2 -g")
set(CMAKE_C_FLAGS_RELEASE          "-O3")
set(CMAKE_C_FLAGS_DEBUG            "-g")

string(APPEND CMAKE_CXX_FLAGS " -I${CMAKE_SOURCE_DIR}/Wrap -pipe ${BIT_ENVIRONMENT} -Wall -W -Woverloaded-virtual -Wno-unknown-pragmas -fPIC")
string(APPEND CMAKE_CXX_FLAGS " -Wno-restrict") # under g++ -std=c++20, warnings from <string>
string(APPEND CMAKE_C_FLAGS " -pipe ${BIT_ENVIRONMENT} -Wall -W -fPIC")
set(CMAKE_SHARED_LINKER_FLAGS "-Wl,--no-undefined")
