export DH_ALWAYS_EXCLUDE=CVS
export LC_ALL=C
export LC_COLLATE=C
export DEB_HOST_MULTIARCH ?= $(shell dpkg-architecture -qDEB_HOST_MULTIARCH)
export DEB_BUILD_ARCH ?= $(shell dpkg-architecture -qDEB_BUILD_ARCH)
export TEXMFVAR = $(CURDIR)/.texmf-var

# current package version
DEBIAN_VERSION=$(strip $(shell \
		head -n 1 debian/changelog | cut -f 2 -d ' ' | tr -d '()'))

# current upstream version (remove any epoch and Debian release number)
UPSTREAM_VERSION=$(shell echo $(DEBIAN_VERSION) | \
		 sed -e 's/-[^-]*$$//' -e 's/^[^:]*://')

# current upstream year
UPSTREAM_YEAR=2006

LOCAL_DEFINES = -DCERNLIB_VERBOSE -DCERNLIB_DEBIAN -DDEBIAN_VERSION=\"$(DEBIAN_VERSION)\" -DCERNLIB_QGETCWD

# location of patches
PATCHDIR = debian/patches
# location of non-Debian-specific add-ons
ADDONDIR = debian/add-ons

# output a helpful usage message if this target is invoked
help:
	@[ -e debian/README.source ] && cat debian/README.source || \
		echo "Sorry, no help for debian/rules available."

# Download the current CERNLIB tarball to ".."
../$(UPSTREAM_YEAR)_src.tar.gz:
	set -e ; \
	cd .. ; \
	wget --continue http://cernlib.web.cern.ch/cernlib/download/$(UPSTREAM_YEAR)_source/tar/$(@F)

# Delete non-free files listed in debian/deadpool.txt from an unpacked
# source tree under upstream/
remove-deadpool:
	set -e ; \
	if [ -e $(ADDONDIR)/bin/remove-deadpool ] ; then \
		sh $(ADDONDIR)/bin/remove-deadpool ; \
	elif [ -x /usr/share/cernlib/remove-deadpool ] ; then \
		/usr/share/cernlib/remove-deadpool ; \
	fi ; \
	$(MAKE) -f debian/rules debian/copyright

# Generate the orig.tar.gz file in the .. directory
../$(MY_NAME)_$(UPSTREAM_VERSION).orig.tar.gz: ../$(UPSTREAM_YEAR)_src.tar.gz
	set -e ; \
	( cd upstream && tar xzf ../$< ) ; \
	$(MAKE) -f debian/rules remove-deadpool ; \
	( cd upstream ; \
	  for module in $(MY_MODULES) ; do \
		tar czf src_$${module}.tar.gz $(UPSTREAM_YEAR)/src/$$module ; \
	  done ) ; \
	fakeroot $(MAKE) -f debian/rules clean ; \
	mkdir -p ../$(MY_NAME)-$(UPSTREAM_VERSION).orig/upstream ; \
	cp -a upstream/*.tar.gz \
		../$(MY_NAME)-$(UPSTREAM_VERSION).orig/upstream/ ; \
	cd .. ; tar czf $(@F) $(MY_NAME)-$(UPSTREAM_VERSION).orig ; \
	rm -r $(MY_NAME)-$(UPSTREAM_VERSION).orig

# This target downloads source code from the CERNLIB web site
# and creates an orig.tar.gz file in the directory ".."
# Don't do this if you already have an orig.tar.gz for this source version, 
# as the md5sums will not match!
# Requires "wget" package.
get-orig-source: ../$(MY_NAME)_$(UPSTREAM_VERSION).orig.tar.gz

# Do not depend on build-indep so that buildd's don't needlessly run
# build-indep target.
build: build-arch

Makefile: $(ADDONDIR)/Makefile
	cp -f $(ADDONDIR)/Makefile .

unpack: Makefile
	dh_testdir
	
	# Check that the debian/control that would be autogenerated
	# matches the existing one.  If not, fail out.
	$(MAKE) -f debian/rules debian/control.new
	[ -s debian/control ] || exit 1
	[ -s debian/control.new ] || exit 1
	[ -z "`diff debian/control debian/control.new`" ] || exit 1

	$(MAKE) prefix=/usr mandir=/usr/share/man sysconfdir=/etc \
		LOCAL_DEFINES='$(LOCAL_DEFINES)' stampdir/configure-stamp

patch: stampdir/patch-stamp
stampdir/patch-stamp: unpack
	# A hacky way to use dpatch without actually necessarily
	# having it installed.  Patches whose name ends in .sh.dpatch
	# are really shell scripts.
	@set -e ; \
	if [ -f $@ ]; then exit 0; fi; \
	export LC_COLLATE=C ; \
	for patch in `ls -1 $(PATCHDIR)/*.dpatch 2> /dev/null \
		| grep -v 000-unpack.sh`; do \
		if [ "$$patch" = "$${patch%.sh.dpatch}" ] ; then \
			echo "Applying patch `basename $${patch%.dpatch}`..." ;\
			patch -f -p1 < "$$patch" > /dev/null ; \
		else \
			echo "Running script `basename $${patch%.dpatch}`..." ;\
			chmod a+x "$$patch" ; \
			"$$patch" -patch ; \
		fi ; \
	done
	mkdir -p stampdir
	touch $@

patched: patch
build-arch: patch
	dh_testdir
	# create local LaTeX cache dir
	mkdir -p .texmf-var
	# force use of system cfortran.h since we Build-Depend upon it
	-mv -f src/include/cfortran/cfortran.h \
		src/include/cfortran/cfortran.h.disabled
	$(MAKE) prefix=/usr mandir=/usr/share/man sysconfdir=/etc \
		LOCAL_DEFINES='$(LOCAL_DEFINES)' cernlib-arch
ifeq (,$(findstring nocheck,$(DEB_BUILD_OPTIONS)))
	# run test suite if not disabled by DEB_BUILD_OPTIONS
	if [ -z "$$LD_LIBRARY_PATH" ] ; then \
		export LD_LIBRARY_PATH="$(CURDIR)/shlib" ; \
	else \
		export LD_LIBRARY_PATH="$${LD_LIBRARY_PATH}:$(CURDIR)/shlib" ; \
	fi ; \
	$(MAKE) prefix=/usr mandir=/usr/share/man sysconfdir=/etc \
		LOCAL_DEFINES='$(LOCAL_DEFINES)' cernlib-test
endif

build-indep: patch
	dh_testdir
	# create local LaTeX cache dir
	mkdir -p .texmf-var
	$(MAKE) prefix=/usr mandir=/usr/share/man sysconfdir=/etc \
		LOCAL_DEFINES='$(LOCAL_DEFINES)' cernlib-indep

unpatch-clean:
	# Move this back so reverse patch doesn't fail
	-mv -f src/include/cfortran/cfortran.h.disabled \
		src/include/cfortran/cfortran.h

unpatch: unpatch-clean

clean: Makefile
	dh_testdir
	dh_testroot
	@if ! $(MAKE) -f debian/rules unpatch ; then \
		echo ; \
		echo "The last patch listed above failed to de-apply.  To" ; \
		echo "inspect the situation, hit Ctrl+C within 10 seconds." ; \
		for i in `seq 10 -1 1` ; do \
			echo -n "$$i " ; sleep 1 ; \
		done ; \
		echo ; \
		rm -rf debian/patched debian/patches/00list ; \
	fi
	$(MAKE) prefix=/usr clean
	rm -f Makefile $(ADDONDIR)/bin/kuipc
	rm -f debian/control.new
	rm -rf upstream/200?
	rm -rf debian/tmp/
	-find . -name higz_windows.dat -o -name last.kumac \
		-o -name last.kumacold -o -name paw.metafile | xargs rm -f
	-rm -rf lib*.txt libdeps/ bindeps/ # clean up output of makedeplist
	-rm -rf .texmf-var # clean up TeX font cache
	dh_clean
	# Remove symlinks to debhelper snippets:
	find debian -maxdepth 1 -type l | xargs rm -f
	# Regenerate debian/patches/00list:
	cd $(PATCHDIR) && ls -1 *.dpatch > 00list
	# Make sure scripts are executable (but not READMEs):
	-chmod a+x $(ADDONDIR)/bin/[a-z]*
	-chmod a+x $(ADDONDIR)/scripts/[a-z]*

debian/control.new: $(wildcard debian/control.d/*.control)
	cat $(sort $^) > $@

debian/control: debian/control.new
	cp -f $< $@

debian/copyright: debian/copyright.in debian/deadpool.txt
	# Stick a list of removed files at the end of debian/copyright
	grep -v DEADPOOL_LIST_GOES_HERE debian/copyright.in > $@
	sed -e 's/#.*//g' -e '/^[[:space:]]*$$/d' debian/deadpool.txt | \
		sort | uniq >> $@

install-common:
	# Set up debhelper links.
	cd debian ; for file in dh/* ; do \
		ln -sf $$file ; \
	done
	dh_testdir
	dh_testroot
	dh_clean -k

# target to install arch-dependent files
install-arch: install-common build-arch
	dh_installdirs -s
	mkdir -p debian/tmp/etc/logrotate.d
	$(MAKE) DESTDIR="$(CURDIR)/debian/tmp" prefix=/usr \
		mandir=/usr/share/man sysconfdir=/etc install-arch
	debian/rules install-arch-local

install-arch-local:

# target to install arch-independent files
install-indep: install-common build-indep
	dh_installdirs -i
	$(MAKE) DESTDIR="$(CURDIR)/debian/tmp" prefix=/usr \
		mandir=/usr/share/man sysconfdir=/etc install-indep
	debian/rules install-indep-local

install-indep-local:

install: install-indep install-arch
binary-arch: install-arch
binary-indep: install-indep
binary: binary-indep binary-arch

.PHONY: help get-orig-source remove-deadpool build build-indep build-arch \
	clean debian/control install install-common install-indep install-arch\
	install-indep-local install-arch-local \
	binary binary-indep binary-arch unpack patch unpatch setup \
	unpatch-clean

