/* Copyright (c) 2008-2010, Google Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * ---
 * Author: Kostya Serebryany
 */

/* This file lists ThreadSanitizer/Valgrind client requests.
   See ts_valgrind.cc for details.
   This file may need to be included into source files
   outside of ThreadSanitizer, hence the BSD license.
*/

#ifndef TS_VALGRIND_CLIENT_REQUESTS_H_
#define TS_VALGRIND_CLIENT_REQUESTS_H_

#include "valgrind.h"

/*
 * WARNING: The following enum defines the ThreadSanitizer ABI.
 * Existing elements should never be changed, new elements should be added to
 * the end.
 */
enum {
  TSREQ_NOOP = VG_USERREQ_TOOL_BASE('T', 'S'),
  TSREQ_CLEAN_MEMORY,
  TSREQ_MAIN_IN,
  TSREQ_MAIN_OUT,
  TSREQ_MALLOC,
  TSREQ_FREE,
  TSREQ_MMAP,
  TSREQ_MUNMAP,
  TSREQ_BENIGN_RACE,
  TSREQ_EXPECT_RACE,
  TSREQ_PCQ_CREATE,
  TSREQ_PCQ_DESTROY,
  TSREQ_PCQ_PUT,
  TSREQ_PCQ_GET,
  TSREQ_TRACE_MEM,
  TSREQ_MUTEX_IS_USED_AS_CONDVAR,
  TSREQ_IGNORE_READS_BEGIN,
  TSREQ_IGNORE_READS_END,
  TSREQ_IGNORE_WRITES_BEGIN,
  TSREQ_IGNORE_WRITES_END,
  TSREQ_SET_THREAD_NAME,
  TSREQ_IGNORE_ALL_ACCESSES_BEGIN,
  TSREQ_IGNORE_ALL_ACCESSES_END,
  TSREQ_IGNORE_ALL_SYNC_BEGIN,
  TSREQ_IGNORE_ALL_SYNC_END,
  TSREQ_GLOBAL_IGNORE_ON,
  TSREQ_GLOBAL_IGNORE_OFF,
  TSREQ_PUBLISH_MEMORY_RANGE,
  TSREQ_UNPUBLISH_MEMORY_RANGE,
  TSREQ_PRINT_MEMORY_USAGE,
  TSREQ_PRINT_STATS,
  TSREQ_RESET_STATS,
  TSREQ_SET_MY_PTHREAD_T,
  TSREQ_THR_STACK_TOP,
  TSREQ_SET_STACKTOP_STACKSIZE,
  TSREQ_PTH_API_ERROR,
  TSREQ_PTHREAD_JOIN_POST,
  TSREQ_PTHREAD_RWLOCK_CREATE_POST,
  TSREQ_PTHREAD_RWLOCK_DESTROY_PRE,
  TSREQ_PTHREAD_RWLOCK_LOCK_POST,
  TSREQ_PTHREAD_RWLOCK_UNLOCK_PRE,
  TSREQ_PTHREAD_SPIN_LOCK_INIT_OR_UNLOCK,
  TSREQ_POSIX_SEM_INIT_POST,
  TSREQ_POSIX_SEM_DESTROY_PRE,
  TSREQ_SIGNAL,
  TSREQ_WAIT,
  TSREQ_CYCLIC_BARRIER_INIT,
  TSREQ_CYCLIC_BARRIER_WAIT_BEFORE,
  TSREQ_CYCLIC_BARRIER_WAIT_AFTER,
  TSREQ_GET_MY_SEGMENT,
  TSREQ_GET_THREAD_ID,
  TSREQ_GET_VG_THREAD_ID,
  TSREQ_GET_SEGMENT_ID,
  TSREQ_THREAD_SANITIZER_QUERY,
  TSREQ_FLUSH_STATE,
  TSREQ_MUTEX_IS_NOT_PHB  // The opposite of TSREQ_MUTEX_IS_USED_AS_CONDVAR.
};
#endif  // TS_VALGRIND_CLIENT_REQUESTS_H_
// end. {{{1
// vim:shiftwidth=2:softtabstop=2:expandtab
