;;; -*- Mode: Lisp; Package: CLIM-XCOMMON; -*-

(in-package :clim-xcommon)

;;/***********************************************************
;;Copyright 1987, 1994, 1998  The Open Group
;;
;;All Rights Reserved.
;;
;;The above copyright notice and this permission notice shall be included
;;in all copies or substantial portions of the Software.
;;
;;THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;;OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;;MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;;IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
;;OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
;;ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;;OTHER DEALINGS IN THE SOFTWARE.
;;
;;Except as contained in this notice, the name of The Open Group shall
;;not be used in advertising or otherwise to promote the sale, use or
;;other dealings in this Software without prior written authorization
;;from The Open Group.
;;
;;
;;Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts
;;
;;                        All Rights Reserved
;;
;;Permission to use, copy, modify, and distribute this software and its
;;documentation for any purpose and without fee is hereby granted,
;;provided that the above copyright notice appear in all copies and that
;;both that copyright notice and this permission notice appear in
;;supporting documentation, and that the name of Digital not be
;;used in advertising or publicity pertaining to distribution of the
;;software without specific, written prior permission.
;;
;;DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
;;ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
;;DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
;;WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
;;ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
;;SOFTWARE.
;;
;;******************************************************************/
(define-keysym :VOID-SYMBOL #xffffff)
;;/*
;; * TTY Functions, cleverly chosen to map to ascii, for convenience of
;; * programming, but could have been arbitrary (at the cost of lookup
;; * tables in client code.
;; */
(define-keysym :BACKSPACE #xff08)
(define-keysym :TAB #xff09)
(define-keysym :LINEFEED #xff0a)
(define-keysym :CLEAR #xff0b)
(define-keysym :RETURN #xff0d)
(define-keysym :PAUSE #xff13)
(define-keysym :SCROLL-LOCK #xff14)
(define-keysym :SYS-REQ #xff15)
(define-keysym :ESCAPE #xff1b)
(define-keysym :DELETE #xffff)
(define-keysym :MULTI-KEY #xff20)
(define-keysym :CODEINPUT #xff37)
(define-keysym :SINGLE-CANDIDATE #xff3c)
(define-keysym :MULTIPLE-CANDIDATE #xff3d)
(define-keysym :PREVIOUS-CANDIDATE #xff3e)
(define-keysym :KANJI #xff21)
(define-keysym :MUHENKAN #xff22)
(define-keysym :HENKAN-MODE #xff23)
(define-keysym :HENKAN #xff23)
(define-keysym :ROMAJI #xff24)
(define-keysym :HIRAGANA #xff25)
(define-keysym :KATAKANA #xff26)
(define-keysym :HIRAGANA-KATAKANA #xff27)
(define-keysym :ZENKAKU #xff28)
(define-keysym :HANKAKU #xff29)
(define-keysym :ZENKAKU-HANKAKU #xff2a)
(define-keysym :TOUROKU #xff2b)
(define-keysym :MASSYO #xff2c)
(define-keysym :KANA-LOCK #xff2d)
(define-keysym :KANA-SHIFT #xff2e)
(define-keysym :EISU-SHIFT #xff2f)
(define-keysym :EISU-TOGGLE #xff30)
(define-keysym :KANJI-BANGOU #xff37)
(define-keysym :ZEN-KOHO #xff3d)
(define-keysym :MAE-KOHO #xff3e)
(define-keysym :HOME #xff50)
(define-keysym :LEFT #xff51)
(define-keysym :UP #xff52)
(define-keysym :RIGHT #xff53)
(define-keysym :DOWN #xff54)
(define-keysym :PRIOR #xff55)
(define-keysym :PAGE-UP #xff55)
(define-keysym :NEXT #xff56)
(define-keysym :PAGE-DOWN #xff56)
(define-keysym :END #xff57)
(define-keysym :BEGIN #xff58)
(define-keysym :SELECT #xff60)
(define-keysym :PRINT #xff61)
(define-keysym :EXECUTE #xff62)
(define-keysym :INSERT #xff63)
(define-keysym :UNDO #xff65)
(define-keysym :REDO #xff66)
(define-keysym :MENU #xff67)
(define-keysym :FIND #xff68)
(define-keysym :CANCEL #xff69)
(define-keysym :HELP #xff6a)
(define-keysym :BREAK #xff6b)
(define-keysym :MODE-SWITCH #xff7e)
(define-keysym :SCRIPT-SWITCH #xff7e)
(define-keysym :NUM-LOCK #xff7f)
(define-keysym :KP-SPACE #xff80)
(define-keysym :KP-TAB #xff89)
(define-keysym :KP-ENTER #xff8d)
(define-keysym :KP-F1 #xff91)
(define-keysym :KP-F2 #xff92)
(define-keysym :KP-F3 #xff93)
(define-keysym :KP-F4 #xff94)
(define-keysym :KP-HOME #xff95)
(define-keysym :KP-LEFT #xff96)
(define-keysym :KP-UP #xff97)
(define-keysym :KP-RIGHT #xff98)
(define-keysym :KP-DOWN #xff99)
(define-keysym :KP-PRIOR #xff9a)
(define-keysym :KP-PAGE-UP #xff9a)
(define-keysym :KP-NEXT #xff9b)
(define-keysym :KP-PAGE-DOWN #xff9b)
(define-keysym :KP-END #xff9c)
(define-keysym :KP-BEGIN #xff9d)
(define-keysym :KP-INSERT #xff9e)
(define-keysym :KP-DELETE #xff9f)
(define-keysym :KP-EQUAL #xffbd)
(define-keysym :KP-MULTIPLY #xffaa)
(define-keysym :KP-ADD #xffab)
(define-keysym :KP-SEPARATOR #xffac)
(define-keysym :KP-SUBTRACT #xffad)
(define-keysym :KP-DECIMAL #xffae)
(define-keysym :KP-DIVIDE #xffaf)
(define-keysym :KP-0 #xffb0)
(define-keysym :KP-1 #xffb1)
(define-keysym :KP-2 #xffb2)
(define-keysym :KP-3 #xffb3)
(define-keysym :KP-4 #xffb4)
(define-keysym :KP-5 #xffb5)
(define-keysym :KP-6 #xffb6)
(define-keysym :KP-7 #xffb7)
(define-keysym :KP-8 #xffb8)
(define-keysym :KP-9 #xffb9)
;;/*
;; * Auxilliary Functions; note the duplicate definitions for left and right
;; * function keys;  Sun keyboards and a few other manufactures have such
;; * function key groups on the left and/or right sides of the keyboard.
;; * We've not found a keyboard with more than 35 function keys total.
;; */
(define-keysym :F1 #xffbe)
(define-keysym :F2 #xffbf)
(define-keysym :F3 #xffc0)
(define-keysym :F4 #xffc1)
(define-keysym :F5 #xffc2)
(define-keysym :F6 #xffc3)
(define-keysym :F7 #xffc4)
(define-keysym :F8 #xffc5)
(define-keysym :F9 #xffc6)
(define-keysym :F10 #xffc7)
(define-keysym :F11 #xffc8)
(define-keysym :L1 #xffc8)
(define-keysym :F12 #xffc9)
(define-keysym :L2 #xffc9)
(define-keysym :F13 #xffca)
(define-keysym :L3 #xffca)
(define-keysym :F14 #xffcb)
(define-keysym :L4 #xffcb)
(define-keysym :F15 #xffcc)
(define-keysym :L5 #xffcc)
(define-keysym :F16 #xffcd)
(define-keysym :L6 #xffcd)
(define-keysym :F17 #xffce)
(define-keysym :L7 #xffce)
(define-keysym :F18 #xffcf)
(define-keysym :L8 #xffcf)
(define-keysym :F19 #xffd0)
(define-keysym :L9 #xffd0)
(define-keysym :F20 #xffd1)
(define-keysym :L10 #xffd1)
(define-keysym :F21 #xffd2)
(define-keysym :R1 #xffd2)
(define-keysym :F22 #xffd3)
(define-keysym :R2 #xffd3)
(define-keysym :F23 #xffd4)
(define-keysym :R3 #xffd4)
(define-keysym :F24 #xffd5)
(define-keysym :R4 #xffd5)
(define-keysym :F25 #xffd6)
(define-keysym :R5 #xffd6)
(define-keysym :F26 #xffd7)
(define-keysym :R6 #xffd7)
(define-keysym :F27 #xffd8)
(define-keysym :R7 #xffd8)
(define-keysym :F28 #xffd9)
(define-keysym :R8 #xffd9)
(define-keysym :F29 #xffda)
(define-keysym :R9 #xffda)
(define-keysym :F30 #xffdb)
(define-keysym :R10 #xffdb)
(define-keysym :F31 #xffdc)
(define-keysym :R11 #xffdc)
(define-keysym :F32 #xffdd)
(define-keysym :R12 #xffdd)
(define-keysym :F33 #xffde)
(define-keysym :R13 #xffde)
(define-keysym :F34 #xffdf)
(define-keysym :R14 #xffdf)
(define-keysym :F35 #xffe0)
(define-keysym :R15 #xffe0)

(define-keysym :SHIFT-LEFT #xffe1)
(define-keysym :SHIFT-RIGHT #xffe2)
(define-keysym :CONTROL-LEFT #xffe3)
(define-keysym :CONTROL-RIGHT #xffe4)
(define-keysym :CAPS-LOCK #xffe5)
(define-keysym :SHIFT-LOCK #xffe6)
(define-keysym :META-LEFT #xffe7)
(define-keysym :META-RIGHT #xffe8)
(define-keysym :ALT-LEFT #xffe9)
(define-keysym :ALT-RIGHT #xffea)
(define-keysym :SUPER-LEFT #xffeb)
(define-keysym :SUPER-RIGHT #xffec)
(define-keysym :HYPER-LEFT #xffed)
(define-keysym :HYPER-RIGHT #xffee)

;;/*
;; * ISO 9995 Function and Modifier Keys
;; * Byte 3 = 0xFE
;; */
(define-keysym :ISO-LOCK #xfe01)
(define-keysym :ISO-LEVEL2-LATCH #xfe02)
(define-keysym :ISO-LEVEL3-SHIFT #xfe03)
(define-keysym :ISO-LEVEL3-LATCH #xfe04)
(define-keysym :ISO-LEVEL3-LOCK #xfe05)
(define-keysym :ISO-GROUP-SHIFT #xff7e)
(define-keysym :ISO-GROUP-LATCH #xfe06)
(define-keysym :ISO-GROUP-LOCK #xfe07)
(define-keysym :ISO-NEXT-GROUP #xfe08)
(define-keysym :ISO-NEXT-GROUP-LOCK #xfe09)
(define-keysym :ISO-PREV-GROUP #xfe0a)
(define-keysym :ISO-PREV-GROUP-LOCK #xfe0b)
(define-keysym :ISO-FIRST-GROUP #xfe0c)
(define-keysym :ISO-FIRST-GROUP-LOCK #xfe0d)
(define-keysym :ISO-LAST-GROUP #xfe0e)
(define-keysym :ISO-LAST-GROUP-LOCK #xfe0f)
(define-keysym :ISO-LEFT-TAB #xfe20)
(define-keysym :ISO-MOVE-LINE-UP #xfe21)
(define-keysym :ISO-MOVE-LINE-DOWN #xfe22)
(define-keysym :ISO-PARTIAL-LINE-UP #xfe23)
(define-keysym :ISO-PARTIAL-LINE-DOWN #xfe24)
(define-keysym :ISO-PARTIAL-SPACE-LEFT #xfe25)
(define-keysym :ISO-PARTIAL-SPACE-RIGHT #xfe26)
(define-keysym :ISO-SET-MARGIN-LEFT #xfe27)
(define-keysym :ISO-SET-MARGIN-RIGHT #xfe28)
(define-keysym :ISO-RELEASE-MARGIN-LEFT #xfe29)
(define-keysym :ISO-RELEASE-MARGIN-RIGHT #xfe2a)
(define-keysym :ISO-RELEASE-BOTH-MARGINS #xfe2b)
(define-keysym :ISO-FAST-CURSOR-LEFT #xfe2c)
(define-keysym :ISO-FAST-CURSOR-RIGHT #xfe2d)
(define-keysym :ISO-FAST-CURSOR-UP #xfe2e)
(define-keysym :ISO-FAST-CURSOR-DOWN #xfe2f)
(define-keysym :ISO-CONTINUOUS-UNDERLINE #xfe30)
(define-keysym :ISO-DISCONTINUOUS-UNDERLINE #xfe31)
(define-keysym :ISO-EMPHASIZE #xfe32)
(define-keysym :ISO-CENTER-OBJECT #xfe33)
(define-keysym :ISO-ENTER #xfe34)
(define-keysym :DEAD-GRAVE #xfe50)
(define-keysym :DEAD-ACUTE #xfe51)
(define-keysym :DEAD-CIRCUMFLEX #xfe52)
(define-keysym :DEAD-TILDE #xfe53)
(define-keysym :DEAD-MACRON #xfe54)
(define-keysym :DEAD-BREVE #xfe55)
(define-keysym :DEAD-ABOVEDOT #xfe56)
(define-keysym :DEAD-DIAERESIS #xfe57)
(define-keysym :DEAD-ABOVE-RING #xfe58)
(define-keysym :DEAD-DOUBLEACUTE #xfe59)
(define-keysym :DEAD-CARON #xfe5a)
(define-keysym :DEAD-CEDILLA #xfe5b)
(define-keysym :DEAD-OGONEK #xfe5c)
(define-keysym :DEAD-IOTA #xfe5d)
(define-keysym :DEAD-VOICED-SOUND #xfe5e)
(define-keysym :DEAD-SEMIVOICED-SOUND #xfe5f)
(define-keysym :DEAD-BELOWDOT #xfe60)
(define-keysym :FIRST-VIRTUAL-SCREEN #xfed0)
(define-keysym :PREV-VIRTUAL-SCREEN #xfed1)
(define-keysym :NEXT-VIRTUAL-SCREEN #xfed2)
(define-keysym :LAST-VIRTUAL-SCREEN #xfed4)
(define-keysym :TERMINATE-SERVER #xfed5)
(define-keysym :ACCESS-X-ENABLE #xfe70)
(define-keysym :ACCESS-X-FEEDBACK-ENABLE #xfe71)
(define-keysym :REPEAT-KEYS-ENABLE #xfe72)
(define-keysym :SLOW-KEYS-ENABLE #xfe73)
(define-keysym :BOUNCE-KEYS-ENABLE #xfe74)
(define-keysym :STICKY-KEYS-ENABLE #xfe75)
(define-keysym :MOUSE-KEYS-ENABLE #xfe76)
(define-keysym :MOUSE-KEYS-ACCEL-ENABLE #xfe77)
(define-keysym :OVERLAY1-ENABLE #xfe78)
(define-keysym :OVERLAY2-ENABLE #xfe79)
(define-keysym :AUDIBLE-BELL-ENABLE #xfe7a)
(define-keysym :POINTER-LEFT #xfee0)
(define-keysym :POINTER-RIGHT #xfee1)
(define-keysym :POINTER-UP #xfee2)
(define-keysym :POINTER-DOWN #xfee3)
(define-keysym :POINTER-UP-LEFT #xfee4)
(define-keysym :POINTER-UP-RIGHT #xfee5)
(define-keysym :POINTER-DOWN-LEFT #xfee6)
(define-keysym :POINTER-DOWN-RIGHT #xfee7)
(define-keysym :POINTER-BUTTON-DFLT #xfee8)
(define-keysym :POINTER-BUTTON1 #xfee9)
(define-keysym :POINTER-BUTTON2 #xfeea)
(define-keysym :POINTER-BUTTON3 #xfeeb)
(define-keysym :POINTER-BUTTON4 #xfeec)
(define-keysym :POINTER-BUTTON5 #xfeed)
(define-keysym :POINTER-DBL-CLICK-DFLT #xfeee)
(define-keysym :POINTER-DBL-CLICK1 #xfeef)
(define-keysym :POINTER-DBL-CLICK2 #xfef0)
(define-keysym :POINTER-DBL-CLICK3 #xfef1)
(define-keysym :POINTER-DBL-CLICK4 #xfef2)
(define-keysym :POINTER-DBL-CLICK5 #xfef3)
(define-keysym :POINTER-DRAG-DFLT #xfef4)
(define-keysym :POINTER-DRAG1 #xfef5)
(define-keysym :POINTER-DRAG2 #xfef6)
(define-keysym :POINTER-DRAG3 #xfef7)
(define-keysym :POINTER-DRAG4 #xfef8)
(define-keysym :POINTER-DRAG5 #xfefd)
(define-keysym :POINTER-ENABLE-KEYS #xfef9)
(define-keysym :POINTER-ACCELERATE #xfefa)
(define-keysym :POINTER-DFLT-BTN-NEXT #xfefb)
(define-keysym :POINTER-DFLT-BTN-PREV #xfefc)
;;/*
;; * 3270 Terminal Keys
;; * Byte 3 = 0xFD
;; */
(define-keysym :3270-DUPLICATE #xfd01)
(define-keysym :3270-FIELD-MARK #xfd02)
(define-keysym :3270-RIGHT2 #xfd03)
(define-keysym :3270-LEFT2 #xfd04)
(define-keysym :3270-BACK-TAB #xfd05)
(define-keysym :3270-ERASE-EOF #xfd06)
(define-keysym :3270-ERASE-INPUT #xfd07)
(define-keysym :3270-RESET #xfd08)
(define-keysym :3270-QUIT #xfd09)
(define-keysym :3270-PA1 #xfd0a)
(define-keysym :3270-PA2 #xfd0b)
(define-keysym :3270-PA3 #xfd0c)
(define-keysym :3270-TEST #xfd0d)
(define-keysym :3270-ATTN #xfd0e)
(define-keysym :3270-CURSOR-BLINK #xfd0f)
(define-keysym :3270-ALT-CURSOR #xfd10)
(define-keysym :3270-KEY-CLICK #xfd11)
(define-keysym :3270-JUMP #xfd12)
(define-keysym :3270-IDENT #xfd13)
(define-keysym :3270-RULE #xfd14)
(define-keysym :3270-COPY #xfd15)
(define-keysym :3270-PLAY #xfd16)
(define-keysym :3270-SETUP #xfd17)
(define-keysym :3270-RECORD #xfd18)
(define-keysym :3270-CHANGE-SCREEN #xfd19)
(define-keysym :3270-DELETE-WORD #xfd1a)
(define-keysym :3270-EX-SELECT #xfd1b)
(define-keysym :3270-CURSOR-SELECT #xfd1c)
(define-keysym :3270-PRINT-SCREEN #xfd1d)
(define-keysym :3270-ENTER #xfd1e)
;;/*
;; *  Latin 1
;; *  Byte 3 = 0
;; */
(define-keysym :| | #x20)
(define-keysym :|!| #x21)
(define-keysym :|"| #x22)
(define-keysym :|#| #x23)
(define-keysym :$ #x24)
(define-keysym :% #x25)
(define-keysym :& #x26)
(define-keysym :|'| #x27)
(define-keysym :|(| #x28)
(define-keysym :|)| #x29)
(define-keysym :* #x2a)
(define-keysym :+ #x2b)
(define-keysym :|,| #x2c)
(define-keysym :- #x2d)
(define-keysym :\. #x2e)
(define-keysym :/ #x2f)
(define-keysym :|0| #x30)
(define-keysym :|1| #x31)
(define-keysym :|2| #x32)
(define-keysym :|3| #x33)
(define-keysym :|4| #x34)
(define-keysym :|5| #x35)
(define-keysym :|6| #x36)
(define-keysym :|7| #x37)
(define-keysym :|8| #x38)
(define-keysym :|9| #x39)
(define-keysym :|:| #x3a)
(define-keysym :|;| #x3b)
(define-keysym :< #x3c)
(define-keysym := #x3d)
(define-keysym :> #x3e)
(define-keysym :|?| #x3f)
(define-keysym :@ #x40)
(define-keysym :A #x41)
(define-keysym :B #x42)
(define-keysym :C #x43)
(define-keysym :D #x44)
(define-keysym :E #x45)
(define-keysym :F #x46)
(define-keysym :G #x47)
(define-keysym :H #x48)
(define-keysym :I #x49)
(define-keysym :J #x4a)
(define-keysym :K #x4b)
(define-keysym :L #x4c)
(define-keysym :M #x4d)
(define-keysym :N #x4e)
(define-keysym :O #x4f)
(define-keysym :P #x50)
(define-keysym :Q #x51)
(define-keysym :R #x52)
(define-keysym :S #x53)
(define-keysym :T #x54)
(define-keysym :U #x55)
(define-keysym :V #x56)
(define-keysym :W #x57)
(define-keysym :X #x58)
(define-keysym :Y #x59)
(define-keysym :Z #x5a)
(define-keysym :|[| #x5b)
(define-keysym :\\ #x5c)
(define-keysym :|]| #x5d)
(define-keysym :^ #x5e)
(define-keysym :_ #x5f)
(define-keysym :|`| #x60)
(define-keysym :|a| #x61)
(define-keysym :|b| #x62)
(define-keysym :|c| #x63)
(define-keysym :|d| #x64)
(define-keysym :|e| #x65)
(define-keysym :|f| #x66)
(define-keysym :|g| #x67)
(define-keysym :|h| #x68)
(define-keysym :|i| #x69)
(define-keysym :|j| #x6a)
(define-keysym :|k| #x6b)
(define-keysym :|l| #x6c)
(define-keysym :|m| #x6d)
(define-keysym :|n| #x6e)
(define-keysym :|o| #x6f)
(define-keysym :|p| #x70)
(define-keysym :|q| #x71)
(define-keysym :|r| #x72)
(define-keysym :|s| #x73)
(define-keysym :|t| #x74)
(define-keysym :|u| #x75)
(define-keysym :|v| #x76)
(define-keysym :|w| #x77)
(define-keysym :|x| #x78)
(define-keysym :|y| #x79)
(define-keysym :|z| #x7a)
(define-keysym :|{| #x7b)
(define-keysym :\| #x7c)
(define-keysym :|}| #x7d)
(define-keysym :|~| #x7e)
(define-keysym :NOBREAKSPACE #xa0)
(define-keysym :EXCLAMDOWN #xa1)
(define-keysym :CENT #xa2)
(define-keysym :STERLING #xa3)
(define-keysym :CURRENCY #xa4)
(define-keysym :YEN #xa5)
(define-keysym :BROKENBAR #xa6)
(define-keysym :SECTION #xa7)
(define-keysym :-DIAERESIS #xa8)
(define-keysym :COPYRIGHT #xa9)
(define-keysym :ORDFEMININE #xaa)
(define-keysym :GUILLEMOTLEFT #xab)
(define-keysym :NOTSIGN #xac)
(define-keysym :HYPHEN #xad)
(define-keysym :REGISTERED #xae)
(define-keysym :-MACRON #xaf)
(define-keysym :DEGREE #xb0)
(define-keysym :PLUSMINUS #xb1)
(define-keysym :TWOSUPERIOR #xb2)
(define-keysym :THREESUPERIOR #xb3)
(define-keysym :-ACUTE #xb4)
(define-keysym :MU #xb5)
(define-keysym :PARAGRAPH #xb6)
(define-keysym :PERIODCENTERED #xb7)
(define-keysym :-CEDILLA #xb8)
(define-keysym :ONESUPERIOR #xb9)
(define-keysym :MASCULINE #xba)
(define-keysym :GUILLEMOTRIGHT #xbb)
(define-keysym :ONEQUARTER #xbc)
(define-keysym :ONEHALF #xbd)
(define-keysym :THREEQUARTERS #xbe)
(define-keysym :QUESTIONDOWN #xbf)
(define-keysym :A-GRAVE #xc0)
(define-keysym :A-ACUTE #xc1)
(define-keysym :A-CIRCUMFLEX #xc2)
(define-keysym :A-TILDE #xc3)
(define-keysym :A-DIAERESIS #xc4)
(define-keysym :A-RING #xc5)
(define-keysym :AE #xc6)
(define-keysym :C-CEDILLA #xc7)
(define-keysym :E-GRAVE #xc8)
(define-keysym :E-ACUTE #xc9)
(define-keysym :E-CIRCUMFLEX #xca)
(define-keysym :E-DIAERESIS #xcb)
(define-keysym :I-GRAVE #xcc)
(define-keysym :I-ACUTE #xcd)
(define-keysym :I-CIRCUMFLEX #xce)
(define-keysym :I-DIAERESIS #xcf)
(define-keysym :ETH #xd0)
(define-keysym :N-TILDE #xd1)
(define-keysym :O-GRAVE #xd2)
(define-keysym :O-ACUTE #xd3)
(define-keysym :O-CIRCUMFLEX #xd4)
(define-keysym :O-TILDE #xd5)
(define-keysym :O-DIAERESIS #xd6)
(define-keysym :MULTIPLY #xd7)
(define-keysym :OOBLIQUE #xd8)
(define-keysym :U-GRAVE #xd9)
(define-keysym :U-ACUTE #xda)
(define-keysym :U-CIRCUMFLEX #xdb)
(define-keysym :U-DIAERESIS #xdc)
(define-keysym :Y-ACUTE #xdd)
(define-keysym :THORN #xde)
(define-keysym :SSHARP #xdf)
(define-keysym :|a-GRAVE| #xe0)
(define-keysym :|a-ACUTE| #xe1)
(define-keysym :|a-CIRCUMFLEX| #xe2)
(define-keysym :|a-TILDE| #xe3)
(define-keysym :|a-DIAERESIS| #xe4)
(define-keysym :|a-RING| #xe5)
(define-keysym :|ae| #xe6)
(define-keysym :|c-CEDILLA| #xe7)
(define-keysym :|e-GRAVE| #xe8)
(define-keysym :|e-ACUTE| #xe9)
(define-keysym :|e-CIRCUMFLEX| #xea)
(define-keysym :|e-DIAERESIS| #xeb)
(define-keysym :|i-GRAVE| #xec)
(define-keysym :|i-ACUTE| #xed)
(define-keysym :|i-CIRCUMFLEX| #xee)
(define-keysym :|i-DIAERESIS| #xef)
(define-keysym :|eth| #xf0)
(define-keysym :|n-TILDE| #xf1)
(define-keysym :|o-GRAVE| #xf2)
(define-keysym :|o-ACUTE| #xf3)
(define-keysym :|o-CIRCUMFLEX| #xf4)
(define-keysym :|o-TILDE| #xf5)
(define-keysym :|o-DIAERESIS| #xf6)
(define-keysym :DIVISION #xf7)
(define-keysym :O-SLASH #xf8)
(define-keysym :|u-GRAVE| #xf9)
(define-keysym :|u-ACUTE| #xfa)
(define-keysym :|u-CIRCUMFLEX| #xfb)
(define-keysym :|u-DIAERESIS| #xfc)
(define-keysym :|y-ACUTE| #xfd)
(define-keysym :|thorn| #xfe)
(define-keysym :|y-DIAERESIS| #xff)
;;/*
;; *   Latin 2
;; *   Byte 3 = 1
;; */
(define-keysym :A-OGONEK #x1a1)
(define-keysym :-BREVE #x1a2)
(define-keysym :L-STROKE #x1a3)
(define-keysym :L-CARON #x1a5)
(define-keysym :S-ACUTE #x1a6)
(define-keysym :S-CARON #x1a9)
(define-keysym :S-CEDILLA #x1aa)
(define-keysym :T-CARON #x1ab)
(define-keysym :Z-ACUTE #x1ac)
(define-keysym :Z-CARON #x1ae)
(define-keysym :Z-ABOVEDOT #x1af)
(define-keysym :|a-OGONEK| #x1b1)
(define-keysym :-OGONEK #x1b2)
(define-keysym :|l-STROKE| #x1b3)
(define-keysym :|l-CARON| #x1b5)
(define-keysym :|s-ACUTE| #x1b6)
(define-keysym :-CARON #x1b7)
(define-keysym :|s-CARON| #x1b9)
(define-keysym :|s-CEDILLA| #x1ba)
(define-keysym :|t-CARON| #x1bb)
(define-keysym :|z-ACUTE| #x1bc)
(define-keysym :-DOUBLEACUTE #x1bd)
(define-keysym :|z-CARON| #x1be)
(define-keysym :|z-ABOVEDOT| #x1bf)
(define-keysym :R-ACUTE #x1c0)
(define-keysym :A-BREVE #x1c3)
(define-keysym :L-ACUTE #x1c5)
(define-keysym :C-ACUTE #x1c6)
(define-keysym :C-CARON #x1c8)
(define-keysym :E-OGONEK #x1ca)
(define-keysym :E-CARON #x1cc)
(define-keysym :D-CARON #x1cf)
(define-keysym :D-STROKE #x1d0)
(define-keysym :N-ACUTE #x1d1)
(define-keysym :N-CARON #x1d2)
(define-keysym :O-DOUBLEACUTE #x1d5)
(define-keysym :R-CARON #x1d8)
(define-keysym :U-RING #x1d9)
(define-keysym :U-DOUBLEACUTE #x1db)
(define-keysym :T-CEDILLA #x1de)
(define-keysym :|r-ACUTE| #x1e0)
(define-keysym :|a-BREVE| #x1e3)
(define-keysym :|l-ACUTE| #x1e5)
(define-keysym :|c-ACUTE| #x1e6)
(define-keysym :|c-CARON| #x1e8)
(define-keysym :|e-OGONEK| #x1ea)
(define-keysym :|e-CARON| #x1ec)
(define-keysym :|d-CARON| #x1ef)
(define-keysym :|d-STROKE| #x1f0)
(define-keysym :|n-ACUTE| #x1f1)
(define-keysym :|n-CARON| #x1f2)
(define-keysym :|o-DOUBLEACUTE| #x1f5)
(define-keysym :|u-DOUBLEACUTE| #x1fb)
(define-keysym :|r-CARON| #x1f8)
(define-keysym :|u-RING| #x1f9)
(define-keysym :|t-CEDILLA| #x1fe)
(define-keysym :-ABOVEDOT #x1ff)
;;/*
;; *   Latin 3
;; *   Byte 3 = 2
;; */
(define-keysym :H-STROKE #x2a1)
(define-keysym :H-CIRCUMFLEX #x2a6)
(define-keysym :I-ABOVEDOT #x2a9)
(define-keysym :G-BREVE #x2ab)
(define-keysym :J-CIRCUMFLEX #x2ac)
(define-keysym :|h-STROKE| #x2b1)
(define-keysym :|h-CIRCUMFLEX| #x2b6)
(define-keysym :IDOTLESS #x2b9)
(define-keysym :|g-BREVE| #x2bb)
(define-keysym :|j-CIRCUMFLEX| #x2bc)
(define-keysym :C-ABOVEDOT #x2c5)
(define-keysym :C-CIRCUMFLEX #x2c6)
(define-keysym :G-ABOVEDOT #x2d5)
(define-keysym :G-CIRCUMFLEX #x2d8)
(define-keysym :U-BREVE #x2dd)
(define-keysym :S-CIRCUMFLEX #x2de)
(define-keysym :|c-ABOVEDOT| #x2e5)
(define-keysym :|c-CIRCUMFLEX| #x2e6)
(define-keysym :|g-ABOVEDOT| #x2f5)
(define-keysym :|g-CIRCUMFLEX| #x2f8)
(define-keysym :|u-BREVE| #x2fd)
(define-keysym :|s-CIRCUMFLEX| #x2fe)
;;/*
;; *   Latin 4
;; *   Byte 3 = 3
;; */
(define-keysym :KRA #x3a2)
(define-keysym :R-CEDILLA #x3a3)
(define-keysym :I-TILDE #x3a5)
(define-keysym :L-CEDILLA #x3a6)
(define-keysym :E-MACRON #x3aa)
(define-keysym :G-CEDILLA #x3ab)
(define-keysym :T-SLASH #x3ac)
(define-keysym :|r-CEDILLA| #x3b3)
(define-keysym :|i-TILDE| #x3b5)
(define-keysym :|l-CEDILLA| #x3b6)
(define-keysym :|e-MACRON| #x3ba)
(define-keysym :|g-CEDILLA| #x3bb)
(define-keysym :|t-SLASH| #x3bc)
(define-keysym :ENG #x3bd)
(define-keysym :|eng| #x3bf)
(define-keysym :A-MACRON #x3c0)
(define-keysym :I-OGONEK #x3c7)
(define-keysym :E-ABOVEDOT #x3cc)
(define-keysym :I-MACRON #x3cf)
(define-keysym :N-CEDILLA #x3d1)
(define-keysym :O-MACRON #x3d2)
(define-keysym :K-CEDILLA #x3d3)
(define-keysym :U-OGONEK #x3d9)
(define-keysym :U-TILDE #x3dd)
(define-keysym :U-MACRON #x3de)
(define-keysym :|a-MACRON| #x3e0)
(define-keysym :|i-OGONEK| #x3e7)
(define-keysym :|e-ABOVEDOT| #x3ec)
(define-keysym :|i-MACRON| #x3ef)
(define-keysym :|n-CEDILLA| #x3f1)
(define-keysym :|o-MACRON| #x3f2)
(define-keysym :|k-CEDILLA| #x3f3)
(define-keysym :|u-OGONEK| #x3f9)
(define-keysym :|u-TILDE| #x3fd)
(define-keysym :|u-MACRON| #x3fe)
;;/*
;; * Latin-9 (a.k.a. Latin-0)
;; * Byte 3 = 19
;; */
(define-keysym :OE #x13bc)
(define-keysym :|oe| #x13bd)
(define-keysym :Y-DIAERESIS #x13be)
;;/*
;; * Katakana
;; * Byte 3 = 4
;; */
(define-keysym :OVERLINE #x47e)
(define-keysym :KANA-FULLSTOP #x4a1)
(define-keysym :KANA-OPENINGBRACKET #x4a2)
(define-keysym :KANA-CLOSINGBRACKET #x4a3)
(define-keysym :KANA-COMMA #x4a4)
(define-keysym :KANA-CONJUNCTIVE #x4a5)
(define-keysym :KANA-WO #x4a6)
(define-keysym :|KANA-a| #x4a7)
(define-keysym :|KANA-i| #x4a8)
(define-keysym :|KANA-u| #x4a9)
(define-keysym :|KANA-e| #x4aa)
(define-keysym :|KANA-o| #x4ab)
(define-keysym :|KANA-ya| #x4ac)
(define-keysym :|KANA-yu| #x4ad)
(define-keysym :|KANA-yo| #x4ae)
(define-keysym :|KANA-tsu| #x4af)
(define-keysym :PROLONGEDSOUND #x4b0)
(define-keysym :KANA-A #x4b1)
(define-keysym :KANA-I #x4b2)
(define-keysym :KANA-U #x4b3)
(define-keysym :KANA-E #x4b4)
(define-keysym :KANA-O #x4b5)
(define-keysym :KANA-KA #x4b6)
(define-keysym :KANA-KI #x4b7)
(define-keysym :KANA-KU #x4b8)
(define-keysym :KANA-KE #x4b9)
(define-keysym :KANA-KO #x4ba)
(define-keysym :KANA-SA #x4bb)
(define-keysym :KANA-SHI #x4bc)
(define-keysym :KANA-SU #x4bd)
(define-keysym :KANA-SE #x4be)
(define-keysym :KANA-SO #x4bf)
(define-keysym :KANA-TA #x4c0)
(define-keysym :KANA-CHI #x4c1)
(define-keysym :KANA-TSU #x4c2)
(define-keysym :KANA-TE #x4c3)
(define-keysym :KANA-TO #x4c4)
(define-keysym :KANA-NA #x4c5)
(define-keysym :KANA-NI #x4c6)
(define-keysym :KANA-NU #x4c7)
(define-keysym :KANA-NE #x4c8)
(define-keysym :KANA-NO #x4c9)
(define-keysym :KANA-HA #x4ca)
(define-keysym :KANA-HI #x4cb)
(define-keysym :KANA-FU #x4cc)
(define-keysym :KANA-HE #x4cd)
(define-keysym :KANA-HO #x4ce)
(define-keysym :KANA-MA #x4cf)
(define-keysym :KANA-MI #x4d0)
(define-keysym :KANA-MU #x4d1)
(define-keysym :KANA-ME #x4d2)
(define-keysym :KANA-MO #x4d3)
(define-keysym :KANA-YA #x4d4)
(define-keysym :KANA-YU #x4d5)
(define-keysym :KANA-YO #x4d6)
(define-keysym :KANA-RA #x4d7)
(define-keysym :KANA-RI #x4d8)
(define-keysym :KANA-RU #x4d9)
(define-keysym :KANA-RE #x4da)
(define-keysym :KANA-RO #x4db)
(define-keysym :KANA-WA #x4dc)
(define-keysym :KANA-N #x4dd)
(define-keysym :VOICEDSOUND #x4de)
(define-keysym :SEMIVOICEDSOUND #x4df)
(define-keysym :KANA-SWITCH #xff7e)
;;/*
;; *  Arabic
;; *  Byte 3 = 5
;; */
(define-keysym :ARABIC-COMMA #x5ac)
(define-keysym :ARABIC-SEMICOLON #x5bb)
(define-keysym :ARABIC-QUESTION-MARK #x5bf)
(define-keysym :ARABIC-HAMZA #x5c1)
(define-keysym :ARABIC-MADDAONALEF #x5c2)
(define-keysym :ARABIC-HAMZAONALEF #x5c3)
(define-keysym :ARABIC-HAMZAONWAW #x5c4)
(define-keysym :ARABIC-HAMZAUNDERALEF #x5c5)
(define-keysym :ARABIC-HAMZAONYEH #x5c6)
(define-keysym :ARABIC-ALEF #x5c7)
(define-keysym :ARABIC-BEH #x5c8)
(define-keysym :ARABIC-TEHMARBUTA #x5c9)
(define-keysym :ARABIC-TEH #x5ca)
(define-keysym :ARABIC-THEH #x5cb)
(define-keysym :ARABIC-JEEM #x5cc)
(define-keysym :ARABIC-HAH #x5cd)
(define-keysym :ARABIC-KHAH #x5ce)
(define-keysym :ARABIC-DAL #x5cf)
(define-keysym :ARABIC-THAL #x5d0)
(define-keysym :ARABIC-RA #x5d1)
(define-keysym :ARABIC-ZAIN #x5d2)
(define-keysym :ARABIC-SEEN #x5d3)
(define-keysym :ARABIC-SHEEN #x5d4)
(define-keysym :ARABIC-SAD #x5d5)
(define-keysym :ARABIC-DAD #x5d6)
(define-keysym :ARABIC-TAH #x5d7)
(define-keysym :ARABIC-ZAH #x5d8)
(define-keysym :ARABIC-AIN #x5d9)
(define-keysym :ARABIC-GHAIN #x5da)
(define-keysym :ARABIC-TATWEEL #x5e0)
(define-keysym :ARABIC-FEH #x5e1)
(define-keysym :ARABIC-QAF #x5e2)
(define-keysym :ARABIC-KAF #x5e3)
(define-keysym :ARABIC-LAM #x5e4)
(define-keysym :ARABIC-MEEM #x5e5)
(define-keysym :ARABIC-NOON #x5e6)
(define-keysym :ARABIC-HA #x5e7)
(define-keysym :ARABIC-WAW #x5e8)
(define-keysym :ARABIC-ALEFMAKSURA #x5e9)
(define-keysym :ARABIC-YEH #x5ea)
(define-keysym :ARABIC-FATHATAN #x5eb)
(define-keysym :ARABIC-DAMMATAN #x5ec)
(define-keysym :ARABIC-KASRATAN #x5ed)
(define-keysym :ARABIC-FATHA #x5ee)
(define-keysym :ARABIC-DAMMA #x5ef)
(define-keysym :ARABIC-KASRA #x5f0)
(define-keysym :ARABIC-SHADDA #x5f1)
(define-keysym :ARABIC-SUKUN #x5f2)
(define-keysym :ARABIC-SWITCH #xff7e)
;;/*
;; * Cyrillic
;; * Byte 3 = 6
;; */
(define-keysym :|SERBIAN-dje| #x6a1)
(define-keysym :|MACEDONIA-gje| #x6a2)
(define-keysym :|CYRILLIC-io| #x6a3)
(define-keysym :|UKRAINIAN-ie| #x6a4)
(define-keysym :|MACEDONIA-dse| #x6a5)
(define-keysym :|UKRAINIAN-i| #x6a6)
(define-keysym :|UKRAINIAN-yi| #x6a7)
(define-keysym :|CYRILLIC-je| #x6a8)
(define-keysym :|CYRILLIC-lje| #x6a9)
(define-keysym :|CYRILLIC-nje| #x6aa)
(define-keysym :|SERBIAN-tshe| #x6ab)
(define-keysym :|MACEDONIA-kje| #x6ac)
(define-keysym :|BYELORUSSIAN-shortu| #x6ae)
(define-keysym :|CYRILLIC-dzhe| #x6af)
(define-keysym :NUMEROSIGN #x6b0)
(define-keysym :SERBIAN-DJE #x6b1)
(define-keysym :MACEDONIA-GJE #x6b2)
(define-keysym :CYRILLIC-IO #x6b3)
(define-keysym :UKRAINIAN-IE #x6b4)
(define-keysym :MACEDONIA-DSE #x6b5)
(define-keysym :UKRAINIAN-I #x6b6)
(define-keysym :UKRAINIAN-YI #x6b7)
(define-keysym :CYRILLIC-JE #x6b8)
(define-keysym :CYRILLIC-LJE #x6b9)
(define-keysym :CYRILLIC-NJE #x6ba)
(define-keysym :SERBIAN-TSHE #x6bb)
(define-keysym :MACEDONIA-KJE #x6bc)
(define-keysym :BYELORUSSIAN-SHORTU #x6be)
(define-keysym :CYRILLIC-DZHE #x6bf)
(define-keysym :|CYRILLIC-yu| #x6c0)
(define-keysym :|CYRILLIC-a| #x6c1)
(define-keysym :|CYRILLIC-be| #x6c2)
(define-keysym :|CYRILLIC-tse| #x6c3)
(define-keysym :|CYRILLIC-de| #x6c4)
(define-keysym :|CYRILLIC-ie| #x6c5)
(define-keysym :|CYRILLIC-ef| #x6c6)
(define-keysym :|CYRILLIC-ghe| #x6c7)
(define-keysym :|CYRILLIC-ha| #x6c8)
(define-keysym :|CYRILLIC-i| #x6c9)
(define-keysym :|CYRILLIC-shorti| #x6ca)
(define-keysym :|CYRILLIC-ka| #x6cb)
(define-keysym :|CYRILLIC-el| #x6cc)
(define-keysym :|CYRILLIC-em| #x6cd)
(define-keysym :|CYRILLIC-en| #x6ce)
(define-keysym :|CYRILLIC-o| #x6cf)
(define-keysym :|CYRILLIC-pe| #x6d0)
(define-keysym :|CYRILLIC-ya| #x6d1)
(define-keysym :|CYRILLIC-er| #x6d2)
(define-keysym :|CYRILLIC-es| #x6d3)
(define-keysym :|CYRILLIC-te| #x6d4)
(define-keysym :|CYRILLIC-u| #x6d5)
(define-keysym :|CYRILLIC-zhe| #x6d6)
(define-keysym :|CYRILLIC-ve| #x6d7)
(define-keysym :|CYRILLIC-softsign| #x6d8)
(define-keysym :|CYRILLIC-yeru| #x6d9)
(define-keysym :|CYRILLIC-ze| #x6da)
(define-keysym :|CYRILLIC-sha| #x6db)
(define-keysym :|CYRILLIC-e| #x6dc)
(define-keysym :|CYRILLIC-shcha| #x6dd)
(define-keysym :|CYRILLIC-che| #x6de)
(define-keysym :|CYRILLIC-hardsign| #x6df)
(define-keysym :CYRILLIC-YU #x6e0)
(define-keysym :CYRILLIC-A #x6e1)
(define-keysym :CYRILLIC-BE #x6e2)
(define-keysym :CYRILLIC-TSE #x6e3)
(define-keysym :CYRILLIC-DE #x6e4)
(define-keysym :CYRILLIC-IE #x6e5)
(define-keysym :CYRILLIC-EF #x6e6)
(define-keysym :CYRILLIC-GHE #x6e7)
(define-keysym :CYRILLIC-HA #x6e8)
(define-keysym :CYRILLIC-I #x6e9)
(define-keysym :CYRILLIC-SHORTI #x6ea)
(define-keysym :CYRILLIC-KA #x6eb)
(define-keysym :CYRILLIC-EL #x6ec)
(define-keysym :CYRILLIC-EM #x6ed)
(define-keysym :CYRILLIC-EN #x6ee)
(define-keysym :CYRILLIC-O #x6ef)
(define-keysym :CYRILLIC-PE #x6f0)
(define-keysym :CYRILLIC-YA #x6f1)
(define-keysym :CYRILLIC-ER #x6f2)
(define-keysym :CYRILLIC-ES #x6f3)
(define-keysym :CYRILLIC-TE #x6f4)
(define-keysym :CYRILLIC-U #x6f5)
(define-keysym :CYRILLIC-ZHE #x6f6)
(define-keysym :CYRILLIC-VE #x6f7)
(define-keysym :CYRILLIC-SOFTSIGN #x6f8)
(define-keysym :CYRILLIC-YERU #x6f9)
(define-keysym :CYRILLIC-ZE #x6fa)
(define-keysym :CYRILLIC-SHA #x6fb)
(define-keysym :CYRILLIC-E #x6fc)
(define-keysym :CYRILLIC-SHCHA #x6fd)
(define-keysym :CYRILLIC-CHE #x6fe)
(define-keysym :CYRILLIC-HARDSIGN #x6ff)
;;/*
;; * Greek
;; * Byte 3 = 7
;; */
(define-keysym :GREEK-ALPHA-ACCENT #x7a1)
(define-keysym :GREEK-EPSILON-ACCENT #x7a2)
(define-keysym :GREEK-ETA-ACCENT #x7a3)
(define-keysym :GREEK-IOTA-ACCENT #x7a4)
(define-keysym :GREEK-IOTA-DIAERESIS #x7a5)
(define-keysym :GREEK-OMICRON-ACCENT #x7a7)
(define-keysym :GREEK-UPSILON-ACCENT #x7a8)
(define-keysym :GREEK-UPSILON-DIERESIS #x7a9)
(define-keysym :GREEK-OMEGA-ACCENT #x7ab)
(define-keysym :GREEK-ACCENT-DIERESIS #x7ae)
(define-keysym :GREEK-HORIZBAR #x7af)
(define-keysym :|GREEK-alpha-ACCENT| #x7b1)
(define-keysym :|GREEK-epsilon-ACCENT| #x7b2)
(define-keysym :|GREEK-eta-ACCENT| #x7b3)
(define-keysym :|GREEK-iota-ACCENT| #x7b4)
(define-keysym :GREEK-IOTA-DIERESIS #x7b5)
(define-keysym :GREEK-IOTAACCENT-DIERESIS #x7b6)
(define-keysym :|GREEK-omicron-ACCENT| #x7b7)
(define-keysym :|GREEK-upsilon-ACCENT| #x7b8)
(define-keysym :|GREEK-upsilon-DIERESIS| #x7b9)
(define-keysym :GREEK-UPSILONACCENT-DIERESIS #x7ba)
(define-keysym :|GREEK-omega-ACCENT| #x7bb)
(define-keysym :GREEK-ALPHA #x7c1)
(define-keysym :GREEK-BETA #x7c2)
(define-keysym :GREEK-GAMMA #x7c3)
(define-keysym :GREEK-DELTA #x7c4)
(define-keysym :GREEK-EPSILON #x7c5)
(define-keysym :GREEK-ZETA #x7c6)
(define-keysym :GREEK-ETA #x7c7)
(define-keysym :GREEK-THETA #x7c8)
(define-keysym :GREEK-IOTA #x7c9)
(define-keysym :GREEK-KAPPA #x7ca)
(define-keysym :GREEK-LAMDA #x7cb)
(define-keysym :GREEK-LAMBDA #x7cb)
(define-keysym :GREEK-MU #x7cc)
(define-keysym :GREEK-NU #x7cd)
(define-keysym :GREEK-XI #x7ce)
(define-keysym :GREEK-OMICRON #x7cf)
(define-keysym :GREEK-PI #x7d0)
(define-keysym :GREEK-RHO #x7d1)
(define-keysym :GREEK-SIGMA #x7d2)
(define-keysym :GREEK-TAU #x7d4)
(define-keysym :GREEK-UPSILON #x7d5)
(define-keysym :GREEK-PHI #x7d6)
(define-keysym :GREEK-CHI #x7d7)
(define-keysym :GREEK-PSI #x7d8)
(define-keysym :GREEK-OMEGA #x7d9)
(define-keysym :|GREEK-alpha| #x7e1)
(define-keysym :|GREEK-beta| #x7e2)
(define-keysym :|GREEK-gamma| #x7e3)
(define-keysym :|GREEK-delta| #x7e4)
(define-keysym :|GREEK-epsilon| #x7e5)
(define-keysym :|GREEK-zeta| #x7e6)
(define-keysym :|GREEK-eta| #x7e7)
(define-keysym :|GREEK-theta| #x7e8)
(define-keysym :|GREEK-iota| #x7e9)
(define-keysym :|GREEK-kappa| #x7ea)
(define-keysym :|GREEK-lamda| #x7eb)
(define-keysym :|GREEK-lambda| #x7eb)
(define-keysym :|GREEK-mu| #x7ec)
(define-keysym :|GREEK-nu| #x7ed)
(define-keysym :|GREEK-xi| #x7ee)
(define-keysym :|GREEK-omicron| #x7ef)
(define-keysym :|GREEK-pi| #x7f0)
(define-keysym :|GREEK-rho| #x7f1)
(define-keysym :|GREEK-sigma| #x7f2)
(define-keysym :GREEK-FINALSMALLSIGMA #x7f3)
(define-keysym :|GREEK-tau| #x7f4)
(define-keysym :|GREEK-upsilon| #x7f5)
(define-keysym :|GREEK-phi| #x7f6)
(define-keysym :|GREEK-chi| #x7f7)
(define-keysym :|GREEK-psi| #x7f8)
(define-keysym :|GREEK-omega| #x7f9)
(define-keysym :GREEK-SWITCH #xff7e)
;;/*
;; * Technical
;; * Byte 3 = 8
;; */
(define-keysym :LEFTRADICAL #x8a1)
(define-keysym :TOPLEFTRADICAL #x8a2)
(define-keysym :HORIZCONNECTOR #x8a3)
(define-keysym :TOPINTEGRAL #x8a4)
(define-keysym :BOTINTEGRAL #x8a5)
(define-keysym :VERTCONNECTOR #x8a6)
(define-keysym :TOPLEFTSQBRACKET #x8a7)
(define-keysym :BOTLEFTSQBRACKET #x8a8)
(define-keysym :TOPRIGHTSQBRACKET #x8a9)
(define-keysym :BOTRIGHTSQBRACKET #x8aa)
(define-keysym :TOPLEFTPARENS #x8ab)
(define-keysym :BOTLEFTPARENS #x8ac)
(define-keysym :TOPRIGHTPARENS #x8ad)
(define-keysym :BOTRIGHTPARENS #x8ae)
(define-keysym :LEFTMIDDLECURLYBRACE #x8af)
(define-keysym :RIGHTMIDDLECURLYBRACE #x8b0)
(define-keysym :TOPLEFTSUMMATION #x8b1)
(define-keysym :BOTLEFTSUMMATION #x8b2)
(define-keysym :TOPVERTSUMMATIONCONNECTOR #x8b3)
(define-keysym :BOTVERTSUMMATIONCONNECTOR #x8b4)
(define-keysym :TOPRIGHTSUMMATION #x8b5)
(define-keysym :BOTRIGHTSUMMATION #x8b6)
(define-keysym :RIGHTMIDDLESUMMATION #x8b7)
(define-keysym :LESSTHANEQUAL #x8bc)
(define-keysym :NOTEQUAL #x8bd)
(define-keysym :GREATERTHANEQUAL #x8be)
(define-keysym :INTEGRAL #x8bf)
(define-keysym :THEREFORE #x8c0)
(define-keysym :VARIATION #x8c1)
(define-keysym :INFINITY #x8c2)
(define-keysym :NABLA #x8c5)
(define-keysym :APPROXIMATE #x8c8)
(define-keysym :SIMILAREQUAL #x8c9)
(define-keysym :IFONLYIF #x8cd)
(define-keysym :IMPLIES #x8ce)
(define-keysym :IDENTICAL #x8cf)
(define-keysym :RADICAL #x8d6)
(define-keysym :INCLUDEDIN #x8da)
(define-keysym :INCLUDES #x8db)
(define-keysym :INTERSECTION #x8dc)
(define-keysym :UNION #x8dd)
(define-keysym :LOGICALAND #x8de)
(define-keysym :LOGICALOR #x8df)
(define-keysym :PARTIALDERIVATIVE #x8ef)
(define-keysym :FUNCTION #x8f6)
(define-keysym :LEFTARROW #x8fb)
(define-keysym :UPARROW #x8fc)
(define-keysym :RIGHTARROW #x8fd)
(define-keysym :DOWNARROW #x8fe)
;;/*
;; *  Special
;; *  Byte 3 = 9
;; */
(define-keysym :BLANK #x9df)
(define-keysym :SOLIDDIAMOND #x9e0)
(define-keysym :CHECKERBOARD #x9e1)
(define-keysym :HT #x9e2)
(define-keysym :FF #x9e3)
(define-keysym :CR #x9e4)
(define-keysym :LF #x9e5)
(define-keysym :NL #x9e8)
(define-keysym :VT #x9e9)
(define-keysym :LOWRIGHTCORNER #x9ea)
(define-keysym :UPRIGHTCORNER #x9eb)
(define-keysym :UPLEFTCORNER #x9ec)
(define-keysym :LOWLEFTCORNER #x9ed)
(define-keysym :CROSSINGLINES #x9ee)
(define-keysym :HORIZLINESCAN1 #x9ef)
(define-keysym :HORIZLINESCAN3 #x9f0)
(define-keysym :HORIZLINESCAN5 #x9f1)
(define-keysym :HORIZLINESCAN7 #x9f2)
(define-keysym :HORIZLINESCAN9 #x9f3)
(define-keysym :LEFTT #x9f4)
(define-keysym :RIGHTT #x9f5)
(define-keysym :BOTT #x9f6)
(define-keysym :TOPT #x9f7)
(define-keysym :VERTBAR #x9f8)
;;/*
;; *  Publishing
;; *  Byte 3 = a
;; */
(define-keysym :EMSPACE #xaa1)
(define-keysym :ENSPACE #xaa2)
(define-keysym :EM3SPACE #xaa3)
(define-keysym :EM4SPACE #xaa4)
(define-keysym :DIGITSPACE #xaa5)
(define-keysym :PUNCTSPACE #xaa6)
(define-keysym :THINSPACE #xaa7)
(define-keysym :HAIRSPACE #xaa8)
(define-keysym :EMDASH #xaa9)
(define-keysym :ENDASH #xaaa)
(define-keysym :SIGNIFBLANK #xaac)
(define-keysym :ELLIPSIS #xaae)
(define-keysym :DOUBBASELINEDOT #xaaf)
(define-keysym :ONETHIRD #xab0)
(define-keysym :TWOTHIRDS #xab1)
(define-keysym :ONEFIFTH #xab2)
(define-keysym :TWOFIFTHS #xab3)
(define-keysym :THREEFIFTHS #xab4)
(define-keysym :FOURFIFTHS #xab5)
(define-keysym :ONESIXTH #xab6)
(define-keysym :FIVESIXTHS #xab7)
(define-keysym :CAREOF #xab8)
(define-keysym :FIGDASH #xabb)
(define-keysym :LEFTANGLEBRACKET #xabc)
(define-keysym :DECIMALPOINT #xabd)
(define-keysym :RIGHTANGLEBRACKET #xabe)
(define-keysym :MARKER #xabf)
(define-keysym :ONEEIGHTH #xac3)
(define-keysym :THREEEIGHTHS #xac4)
(define-keysym :FIVEEIGHTHS #xac5)
(define-keysym :SEVENEIGHTHS #xac6)
(define-keysym :TRADEMARK #xac9)
(define-keysym :SIGNATUREMARK #xaca)
(define-keysym :TRADEMARKINCIRCLE #xacb)
(define-keysym :LEFTOPENTRIANGLE #xacc)
(define-keysym :RIGHTOPENTRIANGLE #xacd)
(define-keysym :EMOPENCIRCLE #xace)
(define-keysym :EMOPENRECTANGLE #xacf)
(define-keysym :LEFTSINGLEQUOTEMARK #xad0)
(define-keysym :RIGHTSINGLEQUOTEMARK #xad1)
(define-keysym :LEFTDOUBLEQUOTEMARK #xad2)
(define-keysym :RIGHTDOUBLEQUOTEMARK #xad3)
(define-keysym :PRESCRIPTION #xad4)
(define-keysym :MINUTES #xad6)
(define-keysym :SECONDS #xad7)
(define-keysym :LATINCROSS #xad9)
(define-keysym :HEXAGRAM #xada)
(define-keysym :FILLEDRECTBULLET #xadb)
(define-keysym :FILLEDLEFTTRIBULLET #xadc)
(define-keysym :FILLEDRIGHTTRIBULLET #xadd)
(define-keysym :EMFILLEDCIRCLE #xade)
(define-keysym :EMFILLEDRECT #xadf)
(define-keysym :ENOPENCIRCBULLET #xae0)
(define-keysym :ENOPENSQUAREBULLET #xae1)
(define-keysym :OPENRECTBULLET #xae2)
(define-keysym :OPENTRIBULLETUP #xae3)
(define-keysym :OPENTRIBULLETDOWN #xae4)
(define-keysym :OPENSTAR #xae5)
(define-keysym :ENFILLEDCIRCBULLET #xae6)
(define-keysym :ENFILLEDSQBULLET #xae7)
(define-keysym :FILLEDTRIBULLETUP #xae8)
(define-keysym :FILLEDTRIBULLETDOWN #xae9)
(define-keysym :LEFTPOINTER #xaea)
(define-keysym :RIGHTPOINTER #xaeb)
(define-keysym :CLUB #xaec)
(define-keysym :DIAMOND #xaed)
(define-keysym :HEART #xaee)
(define-keysym :MALTESECROSS #xaf0)
(define-keysym :DAGGER #xaf1)
(define-keysym :DOUBLEDAGGER #xaf2)
(define-keysym :CHECKMARK #xaf3)
(define-keysym :BALLOTCROSS #xaf4)
(define-keysym :MUSICALSHARP #xaf5)
(define-keysym :MUSICALFLAT #xaf6)
(define-keysym :MALESYMBOL #xaf7)
(define-keysym :FEMALESYMBOL #xaf8)
(define-keysym :TELEPHONE #xaf9)
(define-keysym :TELEPHONERECORDER #xafa)
(define-keysym :PHONOGRAPHCOPYRIGHT #xafb)
(define-keysym :CARET #xafc)
(define-keysym :SINGLELOWQUOTEMARK #xafd)
(define-keysym :DOUBLELOWQUOTEMARK #xafe)
(define-keysym :CURSOR #xaff)
;;/*
;; *  APL
;; *  Byte 3 = b
;; */
(define-keysym :LEFTCARET #xba3)
(define-keysym :RIGHTCARET #xba6)
(define-keysym :DOWNCARET #xba8)
(define-keysym :UPCARET #xba9)
(define-keysym :OVERBAR #xbc0)
(define-keysym :DOWNTACK #xbc2)
(define-keysym :UPSHOE #xbc3)
(define-keysym :DOWNSTILE #xbc4)
(define-keysym :UNDERBAR #xbc6)
(define-keysym :JOT #xbca)
(define-keysym :QUAD #xbcc)
(define-keysym :UPTACK #xbce)
(define-keysym :CIRCLE #xbcf)
(define-keysym :UPSTILE #xbd3)
(define-keysym :DOWNSHOE #xbd6)
(define-keysym :RIGHTSHOE #xbd8)
(define-keysym :LEFTSHOE #xbda)
(define-keysym :LEFTTACK #xbdc)
(define-keysym :RIGHTTACK #xbfc)
;;/*
;; * Hebrew
;; * Byte 3 = c
;; */
(define-keysym :HEBREW-DOUBLELOWLINE #xcdf)
(define-keysym :HEBREW-ALEPH #xce0)
(define-keysym :HEBREW-BET #xce1)
(define-keysym :HEBREW-GIMEL #xce2)
(define-keysym :HEBREW-DALET #xce3)
(define-keysym :HEBREW-HE #xce4)
(define-keysym :HEBREW-WAW #xce5)
(define-keysym :HEBREW-ZAIN #xce6)
(define-keysym :HEBREW-CHET #xce7)
(define-keysym :HEBREW-TET #xce8)
(define-keysym :HEBREW-YOD #xce9)
(define-keysym :HEBREW-FINALKAPH #xcea)
(define-keysym :HEBREW-KAPH #xceb)
(define-keysym :HEBREW-LAMED #xcec)
(define-keysym :HEBREW-FINALMEM #xced)
(define-keysym :HEBREW-MEM #xcee)
(define-keysym :HEBREW-FINALNUN #xcef)
(define-keysym :HEBREW-NUN #xcf0)
(define-keysym :HEBREW-SAMECH #xcf1)
(define-keysym :HEBREW-AYIN #xcf2)
(define-keysym :HEBREW-FINALPE #xcf3)
(define-keysym :HEBREW-PE #xcf4)
(define-keysym :HEBREW-FINALZADE #xcf5)
(define-keysym :HEBREW-ZADE #xcf6)
(define-keysym :HEBREW-QOPH #xcf7)
(define-keysym :HEBREW-RESH #xcf8)
(define-keysym :HEBREW-SHIN #xcf9)
(define-keysym :HEBREW-TAW #xcfa)
(define-keysym :HEBREW-SWITCH #xff7e)
;;/*
;; * Thai
;; * Byte 3 = d
;; */
(define-keysym :THAI-KOKAI #xda1)
(define-keysym :THAI-KHOKHAI #xda2)
(define-keysym :THAI-KHOKHUAT #xda3)
(define-keysym :THAI-KHOKHWAI #xda4)
(define-keysym :THAI-KHOKHON #xda5)
(define-keysym :THAI-KHORAKHANG #xda6)
(define-keysym :THAI-NGONGU #xda7)
(define-keysym :THAI-CHOCHAN #xda8)
(define-keysym :THAI-CHOCHING #xda9)
(define-keysym :THAI-CHOCHANG #xdaa)
(define-keysym :THAI-SOSO #xdab)
(define-keysym :THAI-CHOCHOE #xdac)
(define-keysym :THAI-YOYING #xdad)
(define-keysym :THAI-DOCHADA #xdae)
(define-keysym :THAI-TOPATAK #xdaf)
(define-keysym :THAI-THOTHAN #xdb0)
(define-keysym :THAI-THONANGMONTHO #xdb1)
(define-keysym :THAI-THOPHUTHAO #xdb2)
(define-keysym :THAI-NONEN #xdb3)
(define-keysym :THAI-DODEK #xdb4)
(define-keysym :THAI-TOTAO #xdb5)
(define-keysym :THAI-THOTHUNG #xdb6)
(define-keysym :THAI-THOTHAHAN #xdb7)
(define-keysym :THAI-THOTHONG #xdb8)
(define-keysym :THAI-NONU #xdb9)
(define-keysym :THAI-BOBAIMAI #xdba)
(define-keysym :THAI-POPLA #xdbb)
(define-keysym :THAI-PHOPHUNG #xdbc)
(define-keysym :THAI-FOFA #xdbd)
(define-keysym :THAI-PHOPHAN #xdbe)
(define-keysym :THAI-FOFAN #xdbf)
(define-keysym :THAI-PHOSAMPHAO #xdc0)
(define-keysym :THAI-MOMA #xdc1)
(define-keysym :THAI-YOYAK #xdc2)
(define-keysym :THAI-RORUA #xdc3)
(define-keysym :THAI-RU #xdc4)
(define-keysym :THAI-LOLING #xdc5)
(define-keysym :THAI-LU #xdc6)
(define-keysym :THAI-WOWAEN #xdc7)
(define-keysym :THAI-SOSALA #xdc8)
(define-keysym :THAI-SORUSI #xdc9)
(define-keysym :THAI-SOSUA #xdca)
(define-keysym :THAI-HOHIP #xdcb)
(define-keysym :THAI-LOCHULA #xdcc)
(define-keysym :THAI-OANG #xdcd)
(define-keysym :THAI-HONOKHUK #xdce)
(define-keysym :THAI-PAIYANNOI #xdcf)
(define-keysym :THAI-SARAA #xdd0)
(define-keysym :THAI-MAIHANAKAT #xdd1)
(define-keysym :THAI-SARAAA #xdd2)
(define-keysym :THAI-SARAAM #xdd3)
(define-keysym :THAI-SARAI #xdd4)
(define-keysym :THAI-SARAII #xdd5)
(define-keysym :THAI-SARAUE #xdd6)
(define-keysym :THAI-SARAUEE #xdd7)
(define-keysym :THAI-SARAU #xdd8)
(define-keysym :THAI-SARAUU #xdd9)
(define-keysym :THAI-PHINTHU #xdda)
(define-keysym :THAI-MAIHANAKAT-MAITHO #xdde)
(define-keysym :THAI-BAHT #xddf)
(define-keysym :THAI-SARAE #xde0)
(define-keysym :THAI-SARAAE #xde1)
(define-keysym :THAI-SARAO #xde2)
(define-keysym :THAI-SARAAIMAIMUAN #xde3)
(define-keysym :THAI-SARAAIMAIMALAI #xde4)
(define-keysym :THAI-LAKKHANGYAO #xde5)
(define-keysym :THAI-MAIYAMOK #xde6)
(define-keysym :THAI-MAITAIKHU #xde7)
(define-keysym :THAI-MAIEK #xde8)
(define-keysym :THAI-MAITHO #xde9)
(define-keysym :THAI-MAITRI #xdea)
(define-keysym :THAI-MAICHATTAWA #xdeb)
(define-keysym :THAI-THANTHAKHAT #xdec)
(define-keysym :THAI-NIKHAHIT #xded)
(define-keysym :THAI-LEKSUN #xdf0)
(define-keysym :THAI-LEKNUNG #xdf1)
(define-keysym :THAI-LEKSONG #xdf2)
(define-keysym :THAI-LEKSAM #xdf3)
(define-keysym :THAI-LEKSI #xdf4)
(define-keysym :THAI-LEKHA #xdf5)
(define-keysym :THAI-LEKHOK #xdf6)
(define-keysym :THAI-LEKCHET #xdf7)
(define-keysym :THAI-LEKPAET #xdf8)
(define-keysym :THAI-LEKKAO #xdf9)
;;/*
;; *   Korean
;; *   Byte 3 = e
;; */
(define-keysym :HANGUL #xff31)
(define-keysym :HANGUL-START #xff32)
(define-keysym :HANGUL-END #xff33)
(define-keysym :HANGUL-HANJA #xff34)
(define-keysym :HANGUL-JAMO #xff35)
(define-keysym :HANGUL-ROMAJA #xff36)
(define-keysym :HANGUL-CODEINPUT #xff37)
(define-keysym :HANGUL-JEONJA #xff38)
(define-keysym :HANGUL-BANJA #xff39)
(define-keysym :HANGUL-PRE-HANJA #xff3a)
(define-keysym :HANGUL-POST-HANJA #xff3b)
(define-keysym :HANGUL-SINGLE-CANDIDATE #xff3c)
(define-keysym :HANGUL-MULTIPLE-CANDIDATE #xff3d)
(define-keysym :HANGUL-PREVIOUS-CANDIDATE #xff3e)
(define-keysym :HANGUL-SPECIAL #xff3f)
(define-keysym :HANGUL-SWITCH #xff7e)
(define-keysym :HANGUL-KIYEOG #xea1)
(define-keysym :HANGUL-SSANG-KIYEOG #xea2)
(define-keysym :HANGUL-KIYEOG-SIOS #xea3)
(define-keysym :HANGUL-NIEUN #xea4)
(define-keysym :HANGUL-NIEUN-JIEUJ #xea5)
(define-keysym :HANGUL-NIEUN-HIEUH #xea6)
(define-keysym :HANGUL-DIKEUD #xea7)
(define-keysym :HANGUL-SSANG-DIKEUD #xea8)
(define-keysym :HANGUL-RIEUL #xea9)
(define-keysym :HANGUL-RIEUL-KIYEOG #xeaa)
(define-keysym :HANGUL-RIEUL-MIEUM #xeab)
(define-keysym :HANGUL-RIEUL-PIEUB #xeac)
(define-keysym :HANGUL-RIEUL-SIOS #xead)
(define-keysym :HANGUL-RIEUL-TIEUT #xeae)
(define-keysym :HANGUL-RIEUL-PHIEUF #xeaf)
(define-keysym :HANGUL-RIEUL-HIEUH #xeb0)
(define-keysym :HANGUL-MIEUM #xeb1)
(define-keysym :HANGUL-PIEUB #xeb2)
(define-keysym :HANGUL-SSANG-PIEUB #xeb3)
(define-keysym :HANGUL-PIEUB-SIOS #xeb4)
(define-keysym :HANGUL-SIOS #xeb5)
(define-keysym :HANGUL-SSANG-SIOS #xeb6)
(define-keysym :HANGUL-IEUNG #xeb7)
(define-keysym :HANGUL-JIEUJ #xeb8)
(define-keysym :HANGUL-SSANG-JIEUJ #xeb9)
(define-keysym :HANGUL-CIEUC #xeba)
(define-keysym :HANGUL-KHIEUQ #xebb)
(define-keysym :HANGUL-TIEUT #xebc)
(define-keysym :HANGUL-PHIEUF #xebd)
(define-keysym :HANGUL-HIEUH #xebe)
(define-keysym :HANGUL-A #xebf)
(define-keysym :HANGUL-AE #xec0)
(define-keysym :HANGUL-YA #xec1)
(define-keysym :HANGUL-YAE #xec2)
(define-keysym :HANGUL-EO #xec3)
(define-keysym :HANGUL-E #xec4)
(define-keysym :HANGUL-YEO #xec5)
(define-keysym :HANGUL-YE #xec6)
(define-keysym :HANGUL-O #xec7)
(define-keysym :HANGUL-WA #xec8)
(define-keysym :HANGUL-WAE #xec9)
(define-keysym :HANGUL-OE #xeca)
(define-keysym :HANGUL-YO #xecb)
(define-keysym :HANGUL-U #xecc)
(define-keysym :HANGUL-WEO #xecd)
(define-keysym :HANGUL-WE #xece)
(define-keysym :HANGUL-WI #xecf)
(define-keysym :HANGUL-YU #xed0)
(define-keysym :HANGUL-EU #xed1)
(define-keysym :HANGUL-YI #xed2)
(define-keysym :HANGUL-I #xed3)
(define-keysym :HANGUL-J-KIYEOG #xed4)
(define-keysym :HANGUL-J-SSANG-KIYEOG #xed5)
(define-keysym :HANGUL-J-KIYEOG-SIOS #xed6)
(define-keysym :HANGUL-J-NIEUN #xed7)
(define-keysym :HANGUL-J-NIEUN-JIEUJ #xed8)
(define-keysym :HANGUL-J-NIEUN-HIEUH #xed9)
(define-keysym :HANGUL-J-DIKEUD #xeda)
(define-keysym :HANGUL-J-RIEUL #xedb)
(define-keysym :HANGUL-J-RIEUL-KIYEOG #xedc)
(define-keysym :HANGUL-J-RIEUL-MIEUM #xedd)
(define-keysym :HANGUL-J-RIEUL-PIEUB #xede)
(define-keysym :HANGUL-J-RIEUL-SIOS #xedf)
(define-keysym :HANGUL-J-RIEUL-TIEUT #xee0)
(define-keysym :HANGUL-J-RIEUL-PHIEUF #xee1)
(define-keysym :HANGUL-J-RIEUL-HIEUH #xee2)
(define-keysym :HANGUL-J-MIEUM #xee3)
(define-keysym :HANGUL-J-PIEUB #xee4)
(define-keysym :HANGUL-J-PIEUB-SIOS #xee5)
(define-keysym :HANGUL-J-SIOS #xee6)
(define-keysym :HANGUL-J-SSANG-SIOS #xee7)
(define-keysym :HANGUL-J-IEUNG #xee8)
(define-keysym :HANGUL-J-JIEUJ #xee9)
(define-keysym :HANGUL-J-CIEUC #xeea)
(define-keysym :HANGUL-J-KHIEUQ #xeeb)
(define-keysym :HANGUL-J-TIEUT #xeec)
(define-keysym :HANGUL-J-PHIEUF #xeed)
(define-keysym :HANGUL-J-HIEUH #xeee)
(define-keysym :HANGUL-RIEUL-YEORIN-HIEUH #xeef)
(define-keysym :HANGUL-SUNKYEONGEUM-MIEUM #xef0)
(define-keysym :HANGUL-SUNKYEONGEUM-PIEUB #xef1)
(define-keysym :HANGUL-PAN-SIOS #xef2)
(define-keysym :HANGUL-KKOGJI-DALRIN-IEUNG #xef3)
(define-keysym :HANGUL-SUNKYEONGEUM-PHIEUF #xef4)
(define-keysym :HANGUL-YEORIN-HIEUH #xef5)
(define-keysym :HANGUL-ARAE-A #xef6)
(define-keysym :HANGUL-ARAE-AE #xef7)
(define-keysym :HANGUL-J-PAN-SIOS #xef8)
(define-keysym :HANGUL-J-KKOGJI-DALRIN-IEUNG #xef9)
(define-keysym :HANGUL-J-YEORIN-HIEUH #xefa)
(define-keysym :KOREAN-WON #xeff)
(define-keysym :ECU-SIGN #x20a0)
(define-keysym :COLON-SIGN #x20a1)
(define-keysym :CRUZEIRO-SIGN #x20a2)
(define-keysym :FFRANC-SIGN #x20a3)
(define-keysym :LIRA-SIGN #x20a4)
(define-keysym :MILL-SIGN #x20a5)
(define-keysym :NAIRA-SIGN #x20a6)
(define-keysym :PESETA-SIGN #x20a7)
(define-keysym :RUPEE-SIGN #x20a8)
(define-keysym :WON-SIGN #x20a9)
(define-keysym :NEW-SHEQEL-SIGN #x20aa)
(define-keysym :DONG-SIGN #x20ab)
(define-keysym :EURO-SIGN #x20ac)
;;/***********************************************************
;;
;;Copyright (c) 1988  X Consortium
;;
;;Permission is hereby granted, free of charge, to any person obtaining a copy
;;of this software and associated documentation files (the "Software"), to deal
;;in the Software without restriction, including without limitation the rights
;;to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
;;copies of the Software, and to permit persons to whom the Software is
;;furnished to do so, subject to the following conditions:
;;
;;The above copyright notice and this permission notice shall be included in
;;all copies or substantial portions of the Software.
;;
;;THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;;IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;;FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
;;X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
;;AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
;;CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
;;
;;Except as contained in this notice, the name of the X Consortium shall not be
;;used in advertising or otherwise to promote the sale, use or other dealings
;;in this Software without prior written authorization from the X Consortium.
;;
;;
;;Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts.
;;
;;                        All Rights Reserved
;;
;;Permission to use, copy, modify, and distribute this software and its 
;;documentation for any purpose and without fee is hereby granted, 
;;provided that the above copyright notice appear in all copies and that
;;both that copyright notice and this permission notice appear in 
;;supporting documentation, and that the name of Digital not be
;;used in advertising or publicity pertaining to distribution of the
;;software without specific, written prior permission.  
;;
;;DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
;;ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
;;DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
;;WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
;;ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
;;SOFTWARE.
;;
;;******************************************************************/
;;/*
;; * DEC private keysyms
;; * (29th bit set)
;; */
(define-keysym :D-RING-ACCENT #x1000feb0)
(define-keysym :D-CIRCUMFLEX-ACCENT #x1000fe5e)
(define-keysym :D-CEDILLA-ACCENT #x1000fe2c)
(define-keysym :D-ACUTE-ACCENT #x1000fe27)
(define-keysym :D-GRAVE-ACCENT #x1000fe60)
(define-keysym :D-TILDE #x1000fe7e)
(define-keysym :D-DIAERESIS #x1000fe22)
(define-keysym :D-REMOVE #x1000ff00)
;;/*
;;
;;Copyright (c) 1987  X Consortium
;;
;;Permission is hereby granted, free of charge, to any person obtaining
;;a copy of this software and associated documentation files (the
;;"Software"), to deal in the Software without restriction, including
;;without limitation the rights to use, copy, modify, merge, publish,
;;distribute, sublicense, and/or sell copies of the Software, and to
;;permit persons to whom the Software is furnished to do so, subject to
;;the following conditions:
;;
;;The above copyright notice and this permission notice shall be included
;;in all copies or substantial portions of the Software.
;;
;;THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
;;OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
;;MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
;;IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
;;OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
;;ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
;;OTHER DEALINGS IN THE SOFTWARE.
;;
;;Except as contained in this notice, the name of the X Consortium shall
;;not be used in advertising or otherwise to promote the sale, use or
;;other dealings in this Software without prior written authorization
;;from the X Consortium.
;;
;;Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
;;
;;                        All Rights Reserved
;;
;;Permission to use, copy, modify, and distribute this software and its
;;documentation for any purpose and without fee is hereby granted,
;;provided that the above copyright notice appear in all copies and that
;;both that copyright notice and this permission notice appear in
;;supporting documentation, and that the names of Hewlett Packard
;;or Digital not be
;;used in advertising or publicity pertaining to distribution of the
;;software without specific, written prior permission.
;;
;;DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
;;ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
;;DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
;;WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
;;ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
;;SOFTWARE.
;;
;;HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD
;;TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
;;PURPOSE.  Hewlett-Packard shall not be liable for errors
;;contained herein or direct, indirect, special, incidental or
;;consequential damages in connection with the furnishing,
;;performance, or use of this material.
;;
;;*/
(define-keysym :HP-CLEAR-LINE #x1000ff6f)
(define-keysym :HP-INSERT-LINE #x1000ff70)
(define-keysym :HP-DELETE-LINE #x1000ff71)
(define-keysym :HP-INSERT-CHAR #x1000ff72)
(define-keysym :HP-DELETE-CHAR #x1000ff73)
(define-keysym :HP-BACK-TAB #x1000ff74)
(define-keysym :HP-KP-BACK-TAB #x1000ff75)
(define-keysym :HP-MODELOCK1 #x1000ff48)
(define-keysym :HP-MODELOCK2 #x1000ff49)
(define-keysym :HP-RESET #x1000ff6c)
(define-keysym :HP-SYSTEM #x1000ff6d)
(define-keysym :HP-USER #x1000ff6e)
(define-keysym :HP-MUTE-ACUTE #x100000a8)
(define-keysym :HP-MUTE-GRAVE #x100000a9)
(define-keysym :HP-MUTE-ASCIICIRCUM #x100000aa)
(define-keysym :HP-MUTE-DIAERESIS #x100000ab)
(define-keysym :HP-MUTE-ASCII-TILDE #x100000ac)
(define-keysym :HP-LIRA #x100000af)
(define-keysym :HP-GUILDER #x100000be)
(define-keysym :HP-Y-DIAERESIS #x100000ee)
(define-keysym :HP-IO #x100000ee)
(define-keysym :HP-LONGMINUS #x100000f6)
(define-keysym :HP-BLOCK #x100000fc)
(define-keysym :OSF-COPY #x1004ff02)
(define-keysym :OSF-CUT #x1004ff03)
(define-keysym :OSF-PASTE #x1004ff04)
(define-keysym :OSF-BACK-TAB #x1004ff07)
(define-keysym :OSF-BACK-SPACE #x1004ff08)
(define-keysym :OSF-CLEAR #x1004ff0b)
(define-keysym :OSF-ESCAPE #x1004ff1b)
(define-keysym :OSF-ADD-MODE #x1004ff31)
(define-keysym :OSF-PRIMARY-PASTE #x1004ff32)
(define-keysym :OSF-QUICK-PASTE #x1004ff33)
(define-keysym :OSF-PAGE-LEFT #x1004ff40)
(define-keysym :OSF-PAGE-UP #x1004ff41)
(define-keysym :OSF-PAGE-DOWN #x1004ff42)
(define-keysym :OSF-PAGE-RIGHT #x1004ff43)
(define-keysym :OSF-ACTIVATE #x1004ff44)
(define-keysym :OSF-MENU-BAR #x1004ff45)
(define-keysym :OSF-LEFT #x1004ff51)
(define-keysym :OSF-UP #x1004ff52)
(define-keysym :OSF-RIGHT #x1004ff53)
(define-keysym :OSF-DOWN #x1004ff54)
(define-keysym :OSF-END-LINE #x1004ff57)
(define-keysym :OSF-BEGIN-LINE #x1004ff58)
(define-keysym :OSF-END-DATA #x1004ff59)
(define-keysym :OSF-BEGIN-DATA #x1004ff5a)
(define-keysym :OSF-PREV-MENU #x1004ff5b)
(define-keysym :OSF-NEXT-MENU #x1004ff5c)
(define-keysym :OSF-PREV-FIELD #x1004ff5d)
(define-keysym :OSF-NEXT-FIELD #x1004ff5e)
(define-keysym :OSF-SELECT #x1004ff60)
(define-keysym :OSF-INSERT #x1004ff63)
(define-keysym :OSF-UNDO #x1004ff65)
(define-keysym :OSF-MENU #x1004ff67)
(define-keysym :OSF-CANCEL #x1004ff69)
(define-keysym :OSF-HELP #x1004ff6a)
(define-keysym :OSF-SELECT-ALL #x1004ff71)
(define-keysym :OSF-DESELECT-ALL #x1004ff72)
(define-keysym :OSF-RESELECT #x1004ff73)
(define-keysym :OSF-EXTEND #x1004ff74)
(define-keysym :OSF-RESTORE #x1004ff78)
(define-keysym :OSF-DELETE #x1004ffff)
;;/**************************************************************
;; * The use of the following macros is deprecated.
;; * They are listed below only for backwards compatibility.
;; */
(define-keysym :RESET #x1000ff6c)
(define-keysym :SYSTEM #x1000ff6d)
(define-keysym :USER #x1000ff6e)
(define-keysym :CLEAR-LINE #x1000ff6f)
(define-keysym :INSERT-LINE #x1000ff70)
(define-keysym :DELETE-LINE #x1000ff71)
(define-keysym :INSERT-CHAR #x1000ff72)
(define-keysym :DELETE-CHAR #x1000ff73)
(define-keysym :BACK-TAB #x1000ff74)
(define-keysym :KP-BACK-TAB #x1000ff75)
(define-keysym :EXT16BIT-L #x1000ff76)
(define-keysym :EXT16BIT-R #x1000ff77)
(define-keysym :MUTE-ACUTE #x100000a8)
(define-keysym :MUTE-GRAVE #x100000a9)
(define-keysym :MUTE-ASCIICIRCUM #x100000aa)
(define-keysym :MUTE-DIAERESIS #x100000ab)
(define-keysym :MUTE-ASCII-TILDE #x100000ac)
(define-keysym :LIRA #x100000af)
(define-keysym :GUILDER #x100000be)
(define-keysym :Y-DIAERESIS #x100000ee)
(define-keysym :IO #x100000ee)
(define-keysym :LONGMINUS #x100000f6)
(define-keysym :BLOCK #x100000fc)
;;/************************************************************
;;
;;Copyright (c) 1991  X Consortium
;;
;;Permission is hereby granted, free of charge, to any person obtaining a copy
;;of this software and associated documentation files (the "Software"), to deal
;;in the Software without restriction, including without limitation the rights
;;to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
;;copies of the Software, and to permit persons to whom the Software is
;;furnished to do so, subject to the following conditions:
;;
;;The above copyright notice and this permission notice shall be included in
;;all copies or substantial portions of the Software.
;;
;;THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
;;IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
;;FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
;;X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
;;AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
;;CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
;;
;;Except as contained in this notice, the name of the X Consortium shall not be
;;used in advertising or otherwise to promote the sale, use or other dealings
;;in this Software without prior written authorization from the X Consortium.
;;
;;
;;Copyright 1991 by Sun Microsystems, Inc. Mountain View, CA.
;;
;;                    All Rights Reserved
;;
;;Permission  to  use,  copy,  modify,  and  distribute   this
;;software  and  its documentation for any purpose and without
;;fee is hereby granted, provided that the above copyright no-
;;tice  appear  in all copies and that both that copyright no-
;;tice and this permission notice appear in  supporting  docu-
;;mentation,  and  that the name of Sun not be used in
;;advertising or publicity pertaining to distribution  of  the
;;software  without specific prior written permission. Sun 
;;makes  no  representations about the suitability  of this
;;software for any purpose. It is provided "as is" without any
;;express or implied warranty.
;;
;;SUN DISCLAIMS ALL WARRANTIES WITH REGARD TO  THIS  SOFTWARE,
;;INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
;;NESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL SUN BE  LI-
;;ABLE  FOR  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
;;ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,  DATA  OR
;;PROFITS,  WHETHER  IN  AN  ACTION OF CONTRACT, NEGLIGENCE OR
;;OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION  WITH
;;THE USE OR PERFORMANCE OF THIS SOFTWARE.
;;
;;***********************************************************/
;;/*
;; * Floating Accent
;; */
(define-keysym :SUN-FA-GRAVE #x1005ff00)
(define-keysym :SUN-FA-CIRCUM #x1005ff01)
(define-keysym :SUN-FA-TILDE #x1005ff02)
(define-keysym :SUN-FA-ACUTE #x1005ff03)
(define-keysym :SUN-FA-DIAERESIS #x1005ff04)
(define-keysym :SUN-FA-CEDILLA #x1005ff05)
;;/*
;; * Miscellaneous Functions
;; */
(define-keysym :SUN-F36 #x1005ff10)
(define-keysym :SUN-F37 #x1005ff11)
(define-keysym :SUN-SYS-REQ #x1005ff60)
(define-keysym :SUN-PRINT-SCREEN #xff61)
;;/*
;; * International & Multi-Key Character Composition
;; */
(define-keysym :SUN-COMPOSE #xff20)
(define-keysym :SUN-ALT-GRAPH #xff7e)
;;/*
;; * Cursor Control
;; */
(define-keysym :SUN-PAGE-UP #xff55)
(define-keysym :SUN-PAGE-DOWN #xff56)
;;/*
;; * Open Look Functions
;; */
(define-keysym :SUN-UNDO #xff65)
(define-keysym :SUN-AGAIN #xff66)
(define-keysym :SUN-FIND #xff68)
(define-keysym :SUN-STOP #xff69)
(define-keysym :SUN-PROPS #x1005ff70)
(define-keysym :SUN-FRONT #x1005ff71)
(define-keysym :SUN-COPY #x1005ff72)
(define-keysym :SUN-OPEN #x1005ff73)
(define-keysym :SUN-PASTE #x1005ff74)
(define-keysym :SUN-CUT #x1005ff75)
(define-keysym :SUN-POWER-SWITCH #x1005ff76)
(define-keysym :SUN-AUDIO-LOWER-VOLUME #x1005ff77)
(define-keysym :SUN-AUDIO-MUTE #x1005ff78)
(define-keysym :SUN-AUDIO-RAISE-VOLUME #x1005ff79)
(define-keysym :SUN-VIDEO-DEGAUSS #x1005ff7a)
(define-keysym :SUN-VIDEO-LOWER-BRIGHTNESS #x1005ff7b)
(define-keysym :SUN-VIDEO-RAISE-BRIGHTNESS #x1005ff7c)
(define-keysym :SUN-POWER-SWITCH-SHIFT #x1005ff7d)
;;/******************************************************************
;;Copyright 1987 by Apollo Computer Inc., Chelmsford, Massachusetts.
;;Copyright 1989 by Hewlett-Packard Company.
;;
;;                        All Rights Reserved
;;
;;Permission to use, duplicate, change, and distribute this software and
;;its documentation for any purpose and without fee is granted, provided
;;that the above copyright notice appear in such copy and that this
;;copyright notice appear in all supporting documentation, and that the
;;names of Apollo Computer Inc., the Hewlett-Packard Company, or the X
;;Consortium not be used in advertising or publicity pertaining to
;;distribution of the software without written prior permission.
;;
;;HEWLETT-PACKARD MAKES NO WARRANTY OF ANY KIND WITH REGARD
;;TO THIS SOFWARE, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
;;WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
;;PURPOSE.  Hewlett-Packard shall not be liable for errors 
;;contained herein or direct, indirect, special, incidental or 
;;consequential damages in connection with the furnishing, 
;;performance, or use of this material.
;;
;;This software is not subject to any license of the American
;;Telephone and Telegraph Company or of the Regents of the
;;University of California.
;;******************************************************************/
(define-keysym :AP-LINE-DEL #x1000ff00)
(define-keysym :AP-CHAR-DEL #x1000ff01)
(define-keysym :AP-COPY #x1000ff02)
(define-keysym :AP-CUT #x1000ff03)
(define-keysym :AP-PASTE #x1000ff04)
(define-keysym :AP-MOVE #x1000ff05)
(define-keysym :AP-GROW #x1000ff06)
(define-keysym :AP-CMD #x1000ff07)
(define-keysym :AP-SHELL #x1000ff08)
(define-keysym :AP-LEFT-BAR #x1000ff09)
(define-keysym :AP-RIGHT-BAR #x1000ff0a)
(define-keysym :AP-LEFT-BOX #x1000ff0b)
(define-keysym :AP-RIGHT-BOX #x1000ff0c)
(define-keysym :AP-UP-BOX #x1000ff0d)
(define-keysym :AP-DOWN-BOX #x1000ff0e)
(define-keysym :AP-POP #x1000ff0f)
(define-keysym :AP-READ #x1000ff10)
(define-keysym :AP-EDIT #x1000ff11)
(define-keysym :AP-SAVE #x1000ff12)
(define-keysym :AP-EXIT #x1000ff13)
(define-keysym :AP-REPEAT #x1000ff14)
(define-keysym :AP-KP-PARENLEFT #x1000ffa8)
(define-keysym :AP-KP-PARENRIGHT #x1000ffa9)
