/****************************************************************************
 *    lib/b/Program.cpp - This file is part of coala						*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "Program.h"
#include "Parser.h"

using namespace B;

B::Program::Program(Coala::CompilerOptions* options) : C::Program(options) {

}

B::Program::~Program() {

}

void B::Program::addFluentDef(Formula* fluent_list, bool defined, Types* types) {
	FluentAction* f;

	for(vector<Formula*>::iterator fluent = fluent_list->begin(); fluent != fluent_list->end(); fluent++) {
		if((*fluent)->getType() == 'n') {
			cerr << "Warning: fluent '" << f->getName() << "' can not be defined negatively at line " << *line_ << ".\n";
			f = (*fluent)->getFluentAction();
			*fluent = f;
		}
		else f = (FluentAction*) *fluent;

		f->setClass("Fluent");
		if(!addFluent(f))
			cerr << "Warning: fluent '" << f->getName() << "' defined multiple times at line " << *line_ << ".\n";
	}
	fluent_definitions_.push_back(new B::FluentDefinition(*line_, fluent_list, defined, types));
}

void B::Program::addStaticRule(C::Formula* F, C::Formula* G, C::Types* types) {
	transformFormula(F, "Fluent");
	transformFormula(G, "Fluent");

	static_rules_.push_back(new B::StaticRule(*line_, F, G, types));
}

void B::Program::addDynamicRule(Formula* A, Formula* F, Formula* G, Types* types) {
	transformFormula(A, "Action");
	transformFormula(F, "Fluent");
	transformFormula(G, "Fluent");

	dynamic_rules_.push_back(new B::DynamicRule(*line_, F, G, A, types));
}

void B::Program::addNonexecutableRule(Formula* A, Formula* G, Types* types) {
	Formula* F = addFormula('c', new Formula('n', new FluentAction(new string("0"))));

	addDynamicRule(A, F, G, types);
}

void B::Program::addExecutableRule(Formula* A, Formula* F, Types* types) {
	executable_rules_.push_back(new ExecutableRule(*line_, A, F, types));
}

void B::Program::addInitiallyRule(Formula* F, Types* types) {
	addQQuery("holds", F, "0", types);
}

void B::Program::addQQuery(string type, Formula* A, string time, Types* types) {
	transformFormula(A, "Action");

	qqueries_.push_back(new B::QQuery(*line_, type, A, &time, types));
}

void B::Program::print(Printer* p) {
	//p->add("\n%\n% Fluents\n%\n");
	for(vector<B::FluentDefinition*>::iterator n = fluent_definitions_.begin(); n != fluent_definitions_.end(); ++n) {
		(*n)->print(p, ltlquery_);
		delete *n;
	}
	
	p->setSection('c');
	p->add("\n%\n% Actions\n%\n");
	for(vector<ActionDefinition*>::iterator n = action_definitions_.begin(); n != action_definitions_.end(); ++n) {
		(*n)->print(p);
	}

	p->setSection('c');
	p->add("\n%\n% Static Rules\n%\n");
	for(vector<B::StaticRule*>::iterator n = static_rules_.begin(); n != static_rules_.end(); ++n) {
		(*n)->print(p);
	}

	p->add("\n%\n% Dynamic Rules\n%\n");
	for(vector<B::DynamicRule*>::iterator n = dynamic_rules_.begin(); n != dynamic_rules_.end(); ++n) {
		(*n)->print(p);
	}
	
	p->add("\n%\n% Executable Rules\n%\n");
	for(vector<ExecutableRule*>::iterator n = executable_rules_.begin(); n != executable_rules_.end(); ++n) {
		(*n)->print(p);
	}

	p->setSection('v');
	p->add("\n%\n% Initially Rules\n%\n");
	for(vector<B::QQuery*>::iterator n = qqueries_.begin(); n != qqueries_.end(); ++n) {
		(*n)->print(p);
	}

	p->add("\n%\n% LTL Queries\n%\n");
	if(ltlquery_) {
		ltlquery_->print(p, &fluents_);
		p->add("\n");
	}
	
	p->print();

}
