/****************************************************************************
 *    lib/b/QQuery.cpp - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

#include "QQuery.h"

using namespace B;

B::QQuery::QQuery(int line, string type, Formula* I, string* time, Types* types) : Statement(line, types), C::QQuery(line, type, I, time, types) {

}

B::QQuery::~QQuery ( ) { }

void B::QQuery::print(Printer* p) {
	if(time_ == "0") p->setSection('b');
	else p->setSection('v');

	FluentAction* i;
	string neg;

	if(time_ != "0") {
		p->add(":- not goal(t).\n");
		p->add("goal(t) :- ");
	}

	// :- not f1, ..., not f_n
	for(vector<Formula*>::iterator n = I_->begin(); n != I_->end(); ++n) {
		if((*n)->getType() == 'n') {
			i = (FluentAction*) (*n)->getFirstFormula();
			neg = p->neg;
		}
		else {
			i = (FluentAction*) *n;
			neg = "";
		}
		
		p->add(type_ + "(" + neg + i->print(p, time_) + ", " + time_ + ")");

		if(time_ != "0" && n != I_->end()-1) p->add(", ");

		set<Variable*>* vars = i->getVariables();

		if(!vars->empty()) {
			p->add(" :- ");
			types_.print(p, vars, line_);
		}
		if(time_ == "0")	p->add(".\n");
		delete vars;
	}
	if(time_ != "0") p->add(".\n");
}
