#!/bin/sh
#
# gencxxtypedumper - Generating cxxDebugTypeDecode function
#
# Copyright (C) 2014 Masatake YAMATO
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

INPUT=./parsers/cxx/cxx_token.h
CTAGS=./ctags
OUTPUT=./parsers/cxx/cxx_debug_type.c

exec > ${OUTPUT}
echo '/* Automatically generated by misc/gencxxtypedumper.sh */'
echo
echo '#include "cxx_token.h"'
echo '#include "cxx_debug.h"'
echo
echo '#ifdef CXX_DO_DEBUGGING'
echo "static bool append(vString *buf, const char *str, bool appended)"
echo "{"
echo "	if (appended) vStringPut(buf, ' ');"
echo "	vStringCatS (buf, str);"
echo "	return true;"
echo "}"
echo
echo 'const char * cxxDebugTypeDecode (enum CXXTokenType eType)'
echo '{'
echo '	bool a = false;'
echo '	static vString *buf;'
echo '	buf = vStringNewOrClearWithAutoRelease (buf);'
echo
${CTAGS} -o - --sort=no --language-force=C --kinds-C=e -x --_xformat="%N" "${INPUT}" \
	| grep ^CXXTokenType \
	| while read N; do
		echo "	if (eType & $N) a = append (buf, \"${N#CXXTokenType}\", a);"
done
echo '	if (vStringLength(buf) == 0) vStringCatS(buf, "REALLY-UNKNOWN");'
echo '	return vStringValue (buf);'
echo '}'
echo '#endif'
