#!/bin/sh
#
# Copyright (c) 2008, 2011  Peter Pentchev
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.

[ -z "$CONFGET" ] && CONFGET='./confget'
[ -z "$TESTDIR" ] && TESTDIR='t'

T1="$TESTDIR/t1.ini"

echo '1..4'

if [ ! -f "$T1" ]; then
	echo "Bail out!  No test file $T1"
	exit 255
fi

l=`$CONFGET -f "$T1" -s a -L '*' | wc -l | tr -d ' '`
if [ "$l" = '4' ]; then echo 'ok 1'; else echo "not ok 1 '$l'"; fi
l=`$CONFGET -f "$T1" -N -s 'b sect' -L '*' | fgrep -e '=' | wc -l | tr -d ' '`
if [ "$l" = '2' ]; then echo 'ok 2'; else echo "not ok 2 '$l'"; fi
l=`$CONFGET -f "$T1" -n -s a -L '*ey2' | fgrep -ve '=' | wc -l | tr -d ' '`
if [ "$l" = '1' ]; then echo 'ok 3'; else echo "not ok 3 '$l'"; fi
l=`$CONFGET -f "$T1" -s d -L '*ey2' | wc -l | tr -d ' '`
if [ "$l" = '0' ]; then echo 'ok 4'; else echo "not ok 4 '$l'"; fi
