/*
 *  Copyright 2012  Integrated Computer Solutions - http://www.ics.com
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

#include "accelerometer.h"

Accelerometer::Accelerometer(Cordova *cordova): CPlugin(cordova) {
    m_accelerometerSource = QSharedPointer<QAccelerometer>(new QAccelerometer());
    m_sensorAvaliable = m_accelerometerSource->start();
    connect(m_accelerometerSource.data(),SIGNAL(readingChanged()), SLOT(updateSensor()));
}

void Accelerometer::getCurrentAcceleration(int scId, int ecId, QVariantMap p_options) {
    Q_UNUSED(ecId);
    Q_UNUSED(p_options);

    if (!m_sensorAvaliable) {
        this->cb(ecId);
        return;
    }

    m_successCallbacks << scId;
}

void Accelerometer::updateSensor() {
    QAccelerometerReading *accelerometer = m_accelerometerSource->reading();

    QVariantMap obj;
    obj.insert("x", accelerometer->x());
    obj.insert("y", accelerometer->y());
    obj.insert("z", accelerometer->z());
    obj.insert("timestamp", QDateTime::currentDateTime().toMSecsSinceEpoch());
    // accelerometer->timestamp() is not sutiable.
    // Timestamps values are microseconds since _a_ fixed point(depend on backend).
    QString callbackArguments = QString("Acceleration.cast(%1)").arg(CordovaInternal::format(obj));

    for (int scId: m_successCallbacks) {
        this->callback(scId, callbackArguments);
    }
    m_successCallbacks.clear();
}
