#ifndef QMLPLUGIN_H_SDASDAS
#define QMLPLUGIN_H_SDASDAS

#include <QtCore>
#include <QtQuick>
#include <cassert>

#include "cordova.h"

class CordovaWrapper: public QQuickItem {
    Q_OBJECT
    Q_PROPERTY(QString wwwDir READ wwwDir WRITE setWwwDir SCRIPTABLE true FINAL)
    Q_PROPERTY(QString mainUrl READ mainUrl CONSTANT)
public:
    CordovaWrapper() = default;

    QString wwwDir() {
        if (!m_cordova.data()) {
            return "";
        }
        return m_wwwDir;
    }

    void setWwwDir(const QString &www) {
        if (www.trimmed().isEmpty()) {
            return;
        }
        assert(!m_cordova.data());
        m_cordova = QSharedPointer<Cordova>(new Cordova(QDir(www), this));
        m_wwwDir = www;

        connect(m_cordova.data(), &Cordova::javaScriptExecNeeded, [&] (const QString &js) {
            emit javaScriptExecNeeded(js);
        });
        connect(m_cordova.data(), &Cordova::pluginWantsToBeAdded, [&] (const QString &pluginName, QObject *pluginObject, const QString &pluginShortName) {
            emit pluginWantsToBeAdded(pluginName, pluginObject, pluginShortName);
        });
        connect(m_cordova.data(), &Cordova::confirm, [&] (const QString &message, const QString &title, const QString &button1Name, const QString &button2Name, const QString &button3Name) {
            emit confirm(message, title, button1Name, button2Name, button3Name);
        });
        connect(m_cordova.data(), &Cordova::prompt, [&] (const QString &message, const QString &title, const QString &button1Name, const QString &button2Name, const QString &button3Name, const QString &defaultText) {
            emit prompt(message, title, button1Name, button2Name, button3Name, defaultText);
        });
    }

    Q_INVOKABLE static QString getSplashscreenPath(QQuickItem *parent, const QString &www) {
        return QSharedPointer<Cordova>(new Cordova(QDir(www), parent))->getSplashscreenPath();
    }

    QString mainUrl() {
        if (!m_cordova.data()) {
            return "";
        }
        return m_cordova->mainUrl();
    }

signals:
    void confirm(const QString &message, const QString &title, const QString &button1Name, const QString &button2Name, const QString &button3Name);
    void prompt(const QString &message, const QString &title, const QString &button1Name, const QString &button2Name, const QString &button3Name, const QString &defaultText);
    void javaScriptExecNeeded(const QString &js);
    void pluginWantsToBeAdded(const QString &pluginName, QObject *pluginObject, const QString &pluginShortName);
public slots:
    void notificationDialogButtonPressed(int id, const QString &text) {
        if (!m_cordova.data() || !m_cordova->rootObject()) {
            return;
        }
        m_cordova->notificationDialogButtonPressed(id, text);
    }
    void setTitle(const QString &title) {
        if (!m_cordova.data() || !m_cordova->rootObject()) {
            return;
        }
        return m_cordova->setTitle(title);
    }

    void loadFinished(bool b) {
        if (!m_cordova.data()) {
            return;
        }
        return m_cordova->loadFinished(b);
    }

private:
    QSharedPointer<Cordova> m_cordova;
    QString m_wwwDir;
};

class CordovaUbuntuPlugin: public QQmlExtensionPlugin {
    Q_OBJECT
    Q_PLUGIN_METADATA(IID "org.qt-project.Qt.QQmlExtensionInterface")

public:
    void registerTypes(const char *uri);
};

#endif
