/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <arch/header.ld>

/* SYSTEM_IMEM : 0x14680000 - 0x146AB000 */
#define SSRAM_START(addr) REGION_START(ssram, addr)
#define SSRAM_END(addr) REGION_END(ssram, addr)

/* BOOT_IMEM   : 0x14800000 - 0x14980000 */
#define BSRAM_START(addr) REGION_START(bsram, addr)
#define BSRAM_END(addr) REGION_END(bsram, addr)

/* AOP : 0x0B000000 - 0x0B100000 */
#define AOPSRAM_START(addr) REGION_START(aopsram, addr)
#define AOPSRAM_END(addr) REGION_END(aopsram, addr)

SECTIONS
{
	REGION(shrm, 0x09060000, 64K , 4K)

	AOPSRAM_START(0x0B000000)
	REGION(aop_code_ram, 0x0B000000, 0x80000, 4096)
	REGION(aop_data_ram, 0x0B0E0000, 0x20000, 4096)
	AOPSRAM_END(0x0B100000)

	SSRAM_START(0x14680000)
	OVERLAP_DECOMPRESSOR_VERSTAGE_ROMSTAGE(0x14680000, 112K)
	REGION(qcsdi, 0x1469C000, 39K + 256, 4K)
	REGION(modem_id, 0x146A5D00, 4, 4)
	SSRAM_END(0x146AB000)

	BSRAM_START(0x14800000)
	REGION(pbl_timestamps, 0x14800000, 84K, 4K)
	WATCHDOG_TOMBSTONE(0x14818FFC, 4)
	BOOTBLOCK(0x14819000, 44K)
	PRERAM_CBFS_CACHE(0x14824000, 103K)
	TIMESTAMP(0x1483DC00, 1K)
	TTB(0x1483E000, 56K)
	STACK(0x1484C000, 16K)
	VBOOT2_WORK(0x14850000, 12K)
	DMA_COHERENT(0x14853000, 8K)
	REGION(qclib_serial_log, 0x14857000, 4K, 4K)
	CBFS_MCACHE(0x14858000,16K)
	REGION(ddr_information, 0x1485C000, 1K, 1K)
	FMAP_CACHE(0x1485C400, 2K)
	REGION(dcb, 0x1485E000, 32K, 4K)
	REGION(pmic, 0x14866000, 96K, 4K)
	REGION(ddr_training, 0x1487E000, 32K, 4K)
	REGION(qclib, 0x14886000, 800K, 4K)
	PRERAM_CBMEM_CONSOLE(0x14950000, 32K)
	BSRAM_END(0x14958000)

	DRAM_START(0x80000000)
	/* Various hardware/software subsystems make use of this area */
	REGION(dram_aop,  0x80800000, 0x080000, 0x1000)
	REGION(dram_soc,  0x80900000, 0x200000, 0x1000)
	REGION(dram_cpucp,0x80B00000, 0x100000, 0x1000)
	REGION(dram_wlan, 0x80C00000, 0xC00000, 0x1000)
	REGION(dram_modem, 0x8B800000, 0xF600000, 0x1000)
	REGION(dram_wpss, 0x9AE00000, 0x1900000, 0x1000)
	POSTRAM_CBFS_CACHE(0x9F800000, 16M)
	RAMSTAGE(0xA0800000, 16M)
	BL31(0xC0000000, 1M)
}
