struct cpuinfo_mock_file filesystem[] = {
	{
		.path = "/proc/cpuinfo",
		.size = 1170,
		.content =
			"Processor\t: ARMv7 Processor rev 4 (v7l)\n"
			"processor\t: 0\n"
			"model name\t: ARMv7 Processor rev 4 (v7l)\n"
			"BogoMIPS\t: 32.39\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 4\n"
			"\n"
			"processor\t: 1\n"
			"model name\t: ARMv7 Processor rev 4 (v7l)\n"
			"BogoMIPS\t: 32.39\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 4\n"
			"\n"
			"processor\t: 2\n"
			"model name\t: ARMv7 Processor rev 4 (v7l)\n"
			"BogoMIPS\t: 32.39\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 4\n"
			"\n"
			"processor\t: 3\n"
			"model name\t: ARMv7 Processor rev 4 (v7l)\n"
			"BogoMIPS\t: 26.00\n"
			"Features\t: half thumb fastmult vfp edsp neon vfpv3 tls vfpv4 idiva idivt vfpd32 lpae evtstrm sha2 \n"
			"CPU implementer\t: 0x41\n"
			"CPU architecture: 7\n"
			"CPU variant\t: 0x0\n"
			"CPU part\t: 0xd03\n"
			"CPU revision\t: 4\n"
			"\n"
			"Hardware\t: MT6735P\n"
			"Revision\t: 0000\n"
			"Serial\t\t: 0000000000000000\n",
	},
	{
		.path = "/system/build.prop",
		.size = 7809,
		.content =
			"\n"
			"# begin build properties\n"
			"# autogenerated by buildinfo.sh\n"
			"ro.product.sw.external.version=A6600a40_S032_161104_ROW\n"
			"ro.product.sw.internal.version=A6600a40_USR_S032_1611042152_M0MP1_ROW\n"
			"ro.custom.internal.version=LLD3I80.1.0.2.4T32L1104_M320\n"
			"ro.custom.external.version=LLD3I80.2.4_M320\n"
			"ro.custom.hardware.version=H301\n"
			"ro.lenovo.hardware.version=H301\n"
			"ro.lenovo.build.date=201611042152\n"
			"ro.lenovo.version.no=01\n"
			"ro.lenovo.branch.name=ALPS.MP.M0.MP1.V2.39.1\n"
			"ro.com.google.clientidbase=android-lenovo\n"
			"ro.com.google.clientidbase.ms=android-lenovo\n"
			"ro.com.google.clientidbase.yt=android-lenovo\n"
			"ro.com.google.clientidbase.ms=android-lenovo\n"
			"ro.com.google.clientidbase.am=android-lenovo\n"
			"ro.com.google.clientidbase.gmm=android-lenovo\n"
			"ro.build.id=MRA58K\n"
			"ro.build.display.id=A6600a40_S032_161104_ROW\n"
			"ro.build.version.incremental=A6600a40_S032_161104_ROW\n"
			"ro.build.version.sdk=23\n"
			"ro.build.version.preview_sdk=0\n"
			"ro.build.version.codename=REL\n"
			"ro.build.version.all_codenames=REL\n"
			"ro.build.version.release=6.0\n"
			"ro.build.version.security_patch=2016-10-05\n"
			"ro.build.version.base_os=\n"
			"ro.build.date=Fri Nov  4 21:52:25 CST 2016\n"
			"ro.build.date.utc=1478267545\n"
			"ro.build.type=user\n"
			"ro.build.user=jenkins\n"
			"ro.build.host=glsrv4\n"
			"ro.build.tags=release-keys\n"
			"ro.build.flavor=full_lcsh6735m_35u_m-user\n"
			"ro.product.model=Lenovo A6600a40\n"
			"ro.product.brand=Lenovo\n"
			"ro.product.name=A6600a40\n"
			"ro.product.device=A6600a40\n"
			"ro.product.board=\n"
			"# ro.product.cpu.abi and ro.product.cpu.abi2 are obsolete,\n"
			"# use ro.product.cpu.abilist instead.\n"
			"ro.product.cpu.abi=armeabi-v7a\n"
			"ro.product.cpu.abi2=armeabi\n"
			"ro.product.cpu.abilist=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist32=armeabi-v7a,armeabi\n"
			"ro.product.cpu.abilist64=\n"
			"ro.product.manufacturer=LENOVO\n"
			"ro.product.locale=en-US\n"
			"ro.wifi.channels=\n"
			"ro.board.platform=mt6735m\n"
			"# ro.build.product is obsolete; use ro.product.device\n"
			"ro.build.product=A6600a40\n"
			"# Do not try to parse description, fingerprint, or thumbprint\n"
			"ro.build.description=full_lcsh6735m_35u_m-user 6.0 MRA58K 1478267301 release-keys\n"
			"ro.build.fingerprint=Lenovo/A6600a40/A6600a40:6.0/MRA58K/A6600a40_S032_161104_ROW:user/release-keys\n"
			"ro.build.characteristics=default\n"
			"persist.sys.pwron.snd.state=1\n"
			"persist.sys.pwron.snd.state1=1\n"
			"persist.sys.pwron.snd.state2=1\n"
			"# end build properties\n"
			"persist.gsensor.encali=1\n"
			"ro.lenovo.region=row\n"
			"ro.lenovo.device=phone\n"
			"ro.lenovo.operator=open\n"
			"ro.lenovo.platform=mtk\n"
			"ro.lenovo.bqb=no\n"
			"ro.lenovo.wificert=no\n"
			"ro.lenovo.series=Lenovo A6600\n"
			"ro.lenovo.lcdsize=5.0\n"
			"ro.lenovo.vibeuistyle=true\n"
			"ro.lenovo.audioparaver=PVT-2016-04-13\n"
			"persist.backgrounddata.enable=false\n"
			"persist.lenovo.ltetype=NONE\n"
			"ro.product.ota.model=LenovoA6600a40\n"
			"ro.lenovo.ota.extsd=sdcard\n"
			"ro.build.device.ninur=64687\n"
			"ro.lxf_lenovo_standard_usb=1\n"
			"#\n"
			"# from device/lcsh/lcsh6735m_35u_m/system.prop\n"
			"#\n"
			"#\n"
			"# system.prop for generic sdk\n"
			"#\n"
			"\n"
			"rild.libpath=mtk-ril.so\n"
			"rild.libargs=-d /dev/ttyC0\n"
			"\n"
			"\n"
			"# MTK, Infinity, 20090720 {\n"
			"wifi.interface=wlan0\n"
			"# MTK, Infinity, 20090720 }\n"
			"\n"
			"# MTK, mtk03034, 20101210 {\n"
			"ro.mediatek.wlan.wsc=1\n"
			"# MTK, mtk03034 20101210}\n"
			"# MTK, mtk03034, 20110318 {\n"
			"ro.mediatek.wlan.p2p=1\n"
			"# MTK, mtk03034 20110318}\n"
			"\n"
			"# MTK, mtk03034, 20101213 {\n"
			"mediatek.wlan.ctia=0\n"
			"# MTK, mtk03034 20101213}\n"
			"\n"
			"\n"
			"#\n"
			"wifi.tethering.interface=ap0\n"
			"#\n"
			"\n"
			"ro.opengles.version=196608\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"\n"
			"wifi.direct.interface=p2p0\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"\n"
			"# USB MTP WHQL\n"
			"ro.sys.usb.mtp.whql.enable=0\n"
			"\n"
			"# Power off opt in IPO\n"
			"sys.ipo.pwrdncap=2\n"
			"\n"
			"ro.sys.usb.storage.type=mtp,mass_storage\n"
			"\n"
			"# USB BICR function\n"
			"ro.sys.usb.bicr=yes\n"
			"\n"
			"# USB Charge only function\n"
			"ro.sys.usb.charging.only=yes\n"
			"\n"
			"# audio\n"
			"ro.camera.sound.forced=0\n"
			"ro.audio.silent=0\n"
			"\n"
			"ro.zygote.preload.enable=0\n"
			"\n"
			"# temporary enables NAV bar (soft keys)\n"
			"# lct close nav bar\n"
			"qemu.hw.mainkeys=1\n"
			"\n"
			"ro.kernel.zio=38,108,105,16\n"
			"#ro.kernel.qemu=1\n"
			"#ro.kernel.qemu.gles=0\n"
			"#ro.boot.selinux=disable\n"
			"#lct modify\n"
			"ro.sf.lcd_density=320\n"
			"\n"
			"# performance\n"
			"ro.mtk_perf_simple_start_win=1\n"
			"ro.mtk_perf_fast_start_win=1\n"
			"ro.mtk_perf_response_time=1\n"
			"\n"
			"#\n"
			"# ADDITIONAL_BUILD_PROPERTIES\n"
			"#\n"
			"ro.com.android.dateformat=MM-dd-yyyy\n"
			"ro.config.ringtone=Fantastic_Clang.ogg\n"
			"ro.config.notification_sound=Notice.ogg\n"
			"ro.config.msg_notification=Curiosity.ogg\n"
			"ro.config.alarm_alert=New_Morning.ogg\n"
			"ro.carrier=unknown\n"
			"dalvik.vm.heapgrowthlimit=128m\n"
			"dalvik.vm.heapsize=256m\n"
			"ro.mediatek.chip_ver=S01\n"
			"ro.mediatek.version.release=alps-mp-m0.mp1-V2.39.1_lcsh6735m.35u.m_P62\n"
			"ro.mediatek.platform=MT6735\n"
			"ro.telephony.sim.count=2\n"
			"persist.radio.default.sim=0\n"
			"persist.radio.multisim.config=dsds\n"
			"persist.gemini.sim_num=2\n"
			"ro.gemini.smart_sim_switch=false\n"
			"ril.specific.sm_cause=0\n"
			"bgw.current3gband=0\n"
			"ril.external.md=0\n"
			"ro.sf.hwrotation=0\n"
			"curlockscreen=1\n"
			"ro.mediatek.gemini_support=true\n"
			"persist.radio.fd.counter=15\n"
			"persist.radio.fd.off.counter=5\n"
			"persist.radio.fd.r8.counter=15\n"
			"persist.radio.fd.off.r8.counter=5\n"
			"drm.service.enabled=true\n"
			"fmradio.driver.enable=1\n"
			"ril.first.md=1\n"
			"ril.flightmode.poweroffMD=1\n"
			"ril.telephony.mode=0\n"
			"dalvik.vm.mtk-stack-trace-file=/data/anr/mtk_traces.txt\n"
			"mediatek.wlan.chip=CONSYS_MT6735\n"
			"mediatek.wlan.module.postfix=_consys_mt6735\n"
			"ril.read.imsi=1\n"
			"ril.radiooff.poweroffMD=0\n"
			"ro.frp.pst=/dev/block/platform/mtk-msdc.0/11230000.msdc0/by-name/frp\n"
			"ro.sys.usb.storage.type=mtp,mass_storage\n"
			"ro.mediatek.version.branch=alps-mp-m0.mp1\n"
			"ro.mediatek.version.sdk=4\n"
			"ro.setupwizard.mode=OPTIONAL\n"
			"ro.com.google.gmsversion=6.0_r6\n"
			"ro.com.google.clientidbase=alps-full_lcsh6735m_35u_m-{country}\n"
			"ro.com.google.clientidbase.ms=alps-full_lcsh6735m_35u_m-{country}\n"
			"ro.com.google.clientidbase.yt=alps-full_lcsh6735m_35u_m-{country}\n"
			"ro.com.google.clientidbase.am=alps-full_lcsh6735m_35u_m-{country}\n"
			"ro.com.google.clientidbase.gmm=alps-full_lcsh6735m_35u_m-{country}\n"
			"ro.mtk_gemini_support=1\n"
			"persist.radio.gemini_support=1\n"
			"ril.current.share_modem=2\n"
			"ro.mtk_audio_profiles=1\n"
			"ro.mtk_audenh_support=1\n"
			"ro.mtk_besloudness_support=1\n"
			"ro.mtk_bessurround_support=1\n"
			"ro.mtk_bt_support=1\n"
			"ro.mtk_wappush_support=1\n"
			"ro.mtk_agps_app=1\n"
			"ro.mtk_audio_tuning_tool_ver=V1\n"
			"ro.mtk_wlan_support=1\n"
			"ro.mtk_ipo_support=1\n"
			"ro.mtk_gps_support=1\n"
			"ro.mtk_omacp_support=1\n"
			"ro.mtk_search_db_support=1\n"
			"ro.mtk_dialer_search_support=1\n"
			"ro.mtk_dhcpv6c_wifi=1\n"
			"ro.have_aacencode_feature=1\n"
			"ro.mtk_fd_support=1\n"
			"ro.mtk_oma_drm_support=1\n"
			"ro.mtk_widevine_drm_l3_support=1\n"
			"ro.mtk_eap_sim_aka=1\n"
			"ro.mtk_fm_recording_support=1\n"
			"ro.mtk_audio_ape_support=1\n"
			"ro.mtk_flv_playback_support=1\n"
			"ro.mtk_send_rr_support=1\n"
			"ro.mtk_emmc_support=1\n"
			"ro.mtk_tetheringipv6_support=1\n"
			"ro.mtk_shared_sdcard=1\n"
			"ro.mtk_enable_md1=1\n"
			"ro.mtk_flight_mode_power_off_md=1\n"
			"ro.mtk_pq_support=2\n"
			"ro.mtk_miravision_image_dc=1\n"
			"ro.mtk_wifi_mcc_support=1\n"
			"ro.mtk_sim_hot_swap=1\n"
			"ro.mtk_thumbnail_play_support=1\n"
			"ro.mtk_bip_scws=1\n"
			"ro.mtk_multisim_ringtone=1\n"
			"ro.mtk_world_phone_policy=0\n"
			"ro.mtk_perfservice_support=1\n"
			"ro.mtk_mobile_management=1\n"
			"ro.mtk_antibricking_level=2\n"
			"ro.mtk_cam_mfb_support=0\n"
			"ro.mtk_lte_support=1\n"
			"ro.mtk_safemedia_support=1\n"
			"ro.mtk_rild_read_imsi=1\n"
			"ro.sim_refresh_reset_by_modem=1\n"
			"ro.mtk_passpoint_r1_support=1\n"
			"ro.mtk_bg_power_saving_support=1\n"
			"ro.mtk_bg_power_saving_ui=1\n"
			"ro.have_aee_feature=1\n"
			"ro.sim_me_lock_mode=0\n"
			"ro.mtk_dual_mic_support=0\n"
			"ro.mtk_is_tablet=0\n"
			"ro.mtk_ims_support=1\n"
			"ro.mtk_volte_support=1\n"
			"persist.mtk.volte.enable=1\n"
			"persist.radio.mtk_dsbp_support=1\n"
			"persist.mtk_dynamic_ims_switch=0\n"
			"wfd.dummy.enable=1\n"
			"ro.mediatek.project.path=device/lcsh/lcsh6735m_35u_m\n"
			"persist.mtk.wcn.combo.chipid=-1\n"
			"service.wcn.driver.ready=no\n"
			"service.wcn.coredump.mode=2\n"
			"ro.com.android.mobiledata=false\n"
			"persist.radio.mobile.data=0,0\n"
			"persist.meta.dumpdata=0\n"
			"ro.mtk_md_sbp_custom_value=0\n"
			"mtk.vdec.waitkeyframeforplay=1\n"
			"ro.lct_country_info_ctrl=1\n"
			"ro.delete_all_recent_apps=1\n"
			"ro.lct.cetest=1\n"
			"persist.sys.dalvik.vm.lib.2=libart\n"
			"dalvik.vm.isa.arm.variant=cortex-a53\n"
			"dalvik.vm.isa.arm.features=default\n"
			"net.bt.name=Android\n"
			"dalvik.vm.stack-trace-file=/data/anr/traces.txt\n"
			"ro.expect.recovery_id=0xf5bbd9207572df534d50ff297bc4f3220ff69a79000000000000000000000000\n",
	},
	{
		.path = "/sys/devices/system/cpu/kernel_max",
		.size = 2,
		.content = "7\n",
	},
	{
		.path = "/sys/devices/system/cpu/possible",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/present",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/online",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/offline",
		.size = 1,
		.content = "\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/all_time_in_state",
		.size = 215,
		.content =
			"freq\t\tcpu0\t\tcpu1\t\tcpu2\t\tcpu3\t\t\n"
			"221000\t\t31\t\t31\t\t31\t\t31\t\t\n"
			"364000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"494000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"637000\t\t4\t\t4\t\t4\t\t4\t\t\n"
			"793000\t\t13\t\t13\t\t13\t\t13\t\t\n"
			"858000\t\t0\t\t0\t\t0\t\t0\t\t\n"
			"923000\t\t8\t\t8\t\t8\t\t8\t\t\n"
			"988000\t\t605\t\t605\t\t605\t\t605\t\t\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpufreq/current_in_state",
		.size = 312,
		.content =
			"CPU0:988000=0 923000=0 858000=0 793000=0 637000=0 494000=0 364000=0 221000=0 \n"
			"CPU1:988000=0 923000=0 858000=0 793000=0 637000=0 494000=0 364000=0 221000=0 \n"
			"CPU2:988000=0 923000=0 858000=0 793000=0 637000=0 494000=0 364000=0 221000=0 \n"
			"CPU3:988000=0 923000=0 858000=0 793000=0 637000=0 494000=0 364000=0 221000=0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_driver",
		.size = 15,
		.content = "mt6735_cpuidle\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpuidle/current_governor_ro",
		.size = 13,
		.content = "mtk_governor\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/cpus_per_cluster",
		.size = 12,
		.content = "cluster0: f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/glbinfo",
		.size = 58,
		.content =
			"big/little arch: no\n"
			"nr_cups: 4\n"
			"nr_clusters: 1\n"
			"cluster0: f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_big_little",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/is_multi_cluster",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cputopo/nr_clusters",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq",
		.size = 7,
		.content = "988000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "221000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_frequencies",
		.size = 57,
		.content = "988000 923000 858000 793000 637000 494000 364000 221000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "988000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "221000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/time_in_state",
		.size = 76,
		.content =
			"988000 732\n"
			"923000 8\n"
			"858000 0\n"
			"793000 13\n"
			"637000 4\n"
			"494000 0\n"
			"364000 0\n"
			"221000 31\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/total_trans",
		.size = 3,
		.content = "16\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :    988000    923000    858000    793000    637000    494000    364000    221000 \n"
			"   988000:         0         2         0         2         2         0         0         1 \n"
			"   923000:         2         0         0         0         0         0         0         0 \n"
			"   858000:         0         0         0         0         0         0         0         0 \n"
			"   793000:         4         0         0         0         0         0         0         0 \n"
			"   637000:         1         0         0         1         0         0         0         0 \n"
			"   494000:         0         0         0         0         0         0         0         0 \n"
			"   364000:         0         0         0         0         0         0         0         0 \n"
			"   221000:         1         0         0         0         0         0         0         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/core_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings_list",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu0/topology/thread_siblings",
		.size = 3,
		.content = "01\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_max_freq",
		.size = 7,
		.content = "988000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "221000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_frequencies",
		.size = 57,
		.content = "988000 923000 858000 793000 637000 494000 364000 221000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "988000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "221000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/time_in_state",
		.size = 77,
		.content =
			"988000 1000\n"
			"923000 8\n"
			"858000 0\n"
			"793000 13\n"
			"637000 4\n"
			"494000 0\n"
			"364000 0\n"
			"221000 31\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/total_trans",
		.size = 3,
		.content = "16\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :    988000    923000    858000    793000    637000    494000    364000    221000 \n"
			"   988000:         0         2         0         2         2         0         0         1 \n"
			"   923000:         2         0         0         0         0         0         0         0 \n"
			"   858000:         0         0         0         0         0         0         0         0 \n"
			"   793000:         4         0         0         0         0         0         0         0 \n"
			"   637000:         1         0         0         1         0         0         0         0 \n"
			"   494000:         0         0         0         0         0         0         0         0 \n"
			"   364000:         0         0         0         0         0         0         0         0 \n"
			"   221000:         1         0         0         0         0         0         0         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/core_id",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings_list",
		.size = 2,
		.content = "1\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu1/topology/thread_siblings",
		.size = 3,
		.content = "02\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/affected_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_max_freq",
		.size = 7,
		.content = "988000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_min_freq",
		.size = 7,
		.content = "221000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/cpuinfo_transition_latency",
		.size = 5,
		.content = "1000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/related_cpus",
		.size = 8,
		.content = "0 1 2 3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_frequencies",
		.size = 57,
		.content = "988000 923000 858000 793000 637000 494000 364000 221000 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_available_governors",
		.size = 54,
		.content = "ondemand userspace powersave interactive performance \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_cur_freq",
		.size = 7,
		.content = "988000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_driver",
		.size = 11,
		.content = "mt-cpufreq\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_governor",
		.size = 12,
		.content = "interactive\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/scaling_min_freq",
		.size = 7,
		.content = "221000\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/time_in_state",
		.size = 77,
		.content =
			"988000 1248\n"
			"923000 8\n"
			"858000 0\n"
			"793000 13\n"
			"637000 4\n"
			"494000 0\n"
			"364000 0\n"
			"221000 31\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/total_trans",
		.size = 3,
		.content = "16\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/cpufreq/stats/trans_table",
		.size = 845,
		.content =
			"   From  :    To\n"
			"         :    988000    923000    858000    793000    637000    494000    364000    221000 \n"
			"   988000:         0         2         0         2         2         0         0         1 \n"
			"   923000:         2         0         0         0         0         0         0         0 \n"
			"   858000:         0         0         0         0         0         0         0         0 \n"
			"   793000:         4         0         0         0         0         0         0         0 \n"
			"   637000:         1         0         0         1         0         0         0         0 \n"
			"   494000:         0         0         0         0         0         0         0         0 \n"
			"   364000:         0         0         0         0         0         0         0         0 \n"
			"   221000:         1         0         0         0         0         0         0         0 \n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/physical_package_id",
		.size = 2,
		.content = "0\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings_list",
		.size = 4,
		.content = "0-3\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_siblings",
		.size = 3,
		.content = "0f\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/core_id",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings_list",
		.size = 2,
		.content = "2\n",
	},
	{
		.path = "/sys/devices/system/cpu/cpu2/topology/thread_siblings",
		.size = 3,
		.content = "04\n",
	},
	{ NULL },
};

#ifdef __ANDROID__
struct cpuinfo_mock_property properties[] = {
	{
		.key = "bgw.current3gband",
		.value = "0",
	},
	{
		.key = "camera.disable_zsl_mode",
		.value = "1",
	},
	{
		.key = "curlockscreen",
		.value = "1",
	},
	{
		.key = "dalvik.vm.dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.dex2oat-Xmx",
		.value = "512m",
	},
	{
		.key = "dalvik.vm.heapgrowthlimit",
		.value = "128m",
	},
	{
		.key = "dalvik.vm.heapsize",
		.value = "256m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xms",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.image-dex2oat-Xmx",
		.value = "64m",
	},
	{
		.key = "dalvik.vm.isa.arm.features",
		.value = "default",
	},
	{
		.key = "dalvik.vm.isa.arm.variant",
		.value = "cortex-a53",
	},
	{
		.key = "dalvik.vm.mtk-stack-trace-file",
		.value = "/data/anr/mtk_traces.txt",
	},
	{
		.key = "dalvik.vm.stack-trace-file",
		.value = "/data/anr/traces.txt",
	},
	{
		.key = "debug.MB.running",
		.value = "0",
	},
	{
		.key = "debug.atrace.tags.enableflags",
		.value = "0",
	},
	{
		.key = "debug.hwc.bq_count",
		.value = "4",
	},
	{
		.key = "debug.hwc.compose_level",
		.value = "0",
	},
	{
		.key = "debug.mtklog.netlog.Running",
		.value = "0",
	},
	{
		.key = "drm.service.enabled",
		.value = "true",
	},
	{
		.key = "fmradio.driver.enable",
		.value = "1",
	},
	{
		.key = "init.svc.DMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.MtkCodecService",
		.value = "running",
	},
	{
		.key = "init.svc.NvRAMAgent",
		.value = "running",
	},
	{
		.key = "init.svc.PPLAgent",
		.value = "running",
	},
	{
		.key = "init.svc.adbd",
		.value = "running",
	},
	{
		.key = "init.svc.agpsd",
		.value = "running",
	},
	{
		.key = "init.svc.batterywarning",
		.value = "running",
	},
	{
		.key = "init.svc.boot-check",
		.value = "stopped",
	},
	{
		.key = "init.svc.bootanim",
		.value = "running",
	},
	{
		.key = "init.svc.bootlogoupdater",
		.value = "stopped",
	},
	{
		.key = "init.svc.ccci_fsd",
		.value = "running",
	},
	{
		.key = "init.svc.ccci_mdinit",
		.value = "running",
	},
	{
		.key = "init.svc.conn_launcher",
		.value = "running",
	},
	{
		.key = "init.svc.debuggerd",
		.value = "running",
	},
	{
		.key = "init.svc.defaultcrypto",
		.value = "stopped",
	},
	{
		.key = "init.svc.drm",
		.value = "running",
	},
	{
		.key = "init.svc.emsvr_user",
		.value = "running",
	},
	{
		.key = "init.svc.enableswap",
		.value = "stopped",
	},
	{
		.key = "init.svc.flash_recovery",
		.value = "running",
	},
	{
		.key = "init.svc.fuelgauged",
		.value = "running",
	},
	{
		.key = "init.svc.gatekeeperd",
		.value = "running",
	},
	{
		.key = "init.svc.guiext-server",
		.value = "running",
	},
	{
		.key = "init.svc.healthd",
		.value = "running",
	},
	{
		.key = "init.svc.installd",
		.value = "running",
	},
	{
		.key = "init.svc.keystore",
		.value = "running",
	},
	{
		.key = "init.svc.lmkd",
		.value = "running",
	},
	{
		.key = "init.svc.logd",
		.value = "running",
	},
	{
		.key = "init.svc.logd-reinit",
		.value = "stopped",
	},
	{
		.key = "init.svc.mal-daemon",
		.value = "running",
	},
	{
		.key = "init.svc.media",
		.value = "running",
	},
	{
		.key = "init.svc.mnld",
		.value = "running",
	},
	{
		.key = "init.svc.mobile_log_d",
		.value = "running",
	},
	{
		.key = "init.svc.msensord",
		.value = "stopped",
	},
	{
		.key = "init.svc.netd",
		.value = "running",
	},
	{
		.key = "init.svc.netdiag",
		.value = "running",
	},
	{
		.key = "init.svc.nvram_daemon",
		.value = "running",
	},
	{
		.key = "init.svc.pq",
		.value = "running",
	},
	{
		.key = "init.svc.program_binary",
		.value = "running",
	},
	{
		.key = "init.svc.servicemanager",
		.value = "running",
	},
	{
		.key = "init.svc.slpd",
		.value = "running",
	},
	{
		.key = "init.svc.sn",
		.value = "running",
	},
	{
		.key = "init.svc.start_modem",
		.value = "stopped",
	},
	{
		.key = "init.svc.surfaceflinger",
		.value = "running",
	},
	{
		.key = "init.svc.terservice",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermal",
		.value = "running",
	},
	{
		.key = "init.svc.thermal_manager",
		.value = "stopped",
	},
	{
		.key = "init.svc.thermald",
		.value = "running",
	},
	{
		.key = "init.svc.ueventd",
		.value = "running",
	},
	{
		.key = "init.svc.vold",
		.value = "running",
	},
	{
		.key = "init.svc.vtservice",
		.value = "running",
	},
	{
		.key = "init.svc.wifi2agps",
		.value = "running",
	},
	{
		.key = "init.svc.wmtLoader",
		.value = "stopped",
	},
	{
		.key = "init.svc.xlogboot",
		.value = "stopped",
	},
	{
		.key = "init.svc.xlogdebugchanged",
		.value = "stopped",
	},
	{
		.key = "init.svc.zygote",
		.value = "running",
	},
	{
		.key = "mediatek.wlan.chip",
		.value = "CONSYS_MT6735",
	},
	{
		.key = "mediatek.wlan.ctia",
		.value = "0",
	},
	{
		.key = "mediatek.wlan.module.postfix",
		.value = "_consys_mt6735",
	},
	{
		.key = "mtk.md1.status",
		.value = "init_done",
	},
	{
		.key = "mtk.vdec.waitkeyframeforplay",
		.value = "1",
	},
	{
		.key = "net.bt.name",
		.value = "Android",
	},
	{
		.key = "net.change",
		.value = "net.tcp.default_init_rwnd",
	},
	{
		.key = "net.tcp.default_init_rwnd",
		.value = "60",
	},
	{
		.key = "persist.backgrounddata.enable",
		.value = "false",
	},
	{
		.key = "persist.dm.lock",
		.value = "false",
	},
	{
		.key = "persist.gemini.sim_num",
		.value = "2",
	},
	{
		.key = "persist.gsensor.encali",
		.value = "1",
	},
	{
		.key = "persist.lenovo.ltetype",
		.value = "NONE",
	},
	{
		.key = "persist.meta.dumpdata",
		.value = "0",
	},
	{
		.key = "persist.mtk.volte.enable",
		.value = "1",
	},
	{
		.key = "persist.mtk.wcn.combo.chipid",
		.value = "0x0335",
	},
	{
		.key = "persist.mtk_dynamic_ims_switch",
		.value = "0",
	},
	{
		.key = "persist.radio.data.iccid",
		.value = "",
	},
	{
		.key = "persist.radio.default.sim",
		.value = "0",
	},
	{
		.key = "persist.radio.fd.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.fd.off.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.off.r8.counter",
		.value = "5",
	},
	{
		.key = "persist.radio.fd.r8.counter",
		.value = "15",
	},
	{
		.key = "persist.radio.gemini_support",
		.value = "1",
	},
	{
		.key = "persist.radio.ia",
		.value = "",
	},
	{
		.key = "persist.radio.ia-apn",
		.value = "",
	},
	{
		.key = "persist.radio.mobile.data",
		.value = "0,0",
	},
	{
		.key = "persist.radio.mtk_dsbp_support",
		.value = "1",
	},
	{
		.key = "persist.radio.multisim.config",
		.value = "dsds",
	},
	{
		.key = "persist.radio.reset_on_switch",
		.value = "true",
	},
	{
		.key = "persist.radio.simswitch",
		.value = "1",
	},
	{
		.key = "persist.service.acm.enable",
		.value = "0",
	},
	{
		.key = "persist.service.bdroid.bdaddr",
		.value = "22:22:e7:79:30:10",
	},
	{
		.key = "persist.service.stk.shutdown",
		.value = "1",
	},
	{
		.key = "persist.sys.dalvik.vm.lib.2",
		.value = "libart.so",
	},
	{
		.key = "persist.sys.first_boot",
		.value = "complete",
	},
	{
		.key = "persist.sys.first_time_boot",
		.value = "false",
	},
	{
		.key = "persist.sys.lang_country",
		.value = "MY",
	},
	{
		.key = "persist.sys.lang_updated",
		.value = "1",
	},
	{
		.key = "persist.sys.locale",
		.value = "en-US",
	},
	{
		.key = "persist.sys.longcheer.reboot",
		.value = "0",
	},
	{
		.key = "persist.sys.mute.state",
		.value = "2",
	},
	{
		.key = "persist.sys.opmcc",
		.value = "310",
	},
	{
		.key = "persist.sys.pq.adl.idx",
		.value = "0",
	},
	{
		.key = "persist.sys.pq.shp.idx",
		.value = "2",
	},
	{
		.key = "persist.sys.profiler_ms",
		.value = "0",
	},
	{
		.key = "persist.sys.pwron.snd.state",
		.value = "1",
	},
	{
		.key = "persist.sys.pwron.snd.state1",
		.value = "1",
	},
	{
		.key = "persist.sys.pwron.snd.state2",
		.value = "1",
	},
	{
		.key = "persist.sys.sd.defaultpath",
		.value = "/storage/emulated/0",
	},
	{
		.key = "persist.sys.timezone",
		.value = "Asia/Kuala_Lumpur",
	},
	{
		.key = "persist.sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "qemu.hw.mainkeys",
		.value = "1",
	},
	{
		.key = "ril.current.share_modem",
		.value = "2",
	},
	{
		.key = "ril.external.md",
		.value = "0",
	},
	{
		.key = "ril.first.md",
		.value = "1",
	},
	{
		.key = "ril.flightmode.poweroffMD",
		.value = "1",
	},
	{
		.key = "ril.radiooff.poweroffMD",
		.value = "0",
	},
	{
		.key = "ril.read.imsi",
		.value = "1",
	},
	{
		.key = "ril.specific.sm_cause",
		.value = "0",
	},
	{
		.key = "ril.telephony.mode",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface0",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface1",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface10",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface11",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface12",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface13",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface14",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface15",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface2",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface3",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface4",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface5",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface6",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface7",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface8",
		.value = "0",
	},
	{
		.key = "ril.volte.hoe.interface9",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface0",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface1",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface10",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface11",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface12",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface13",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface14",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface15",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface2",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface3",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface4",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface5",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface6",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface7",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface8",
		.value = "0",
	},
	{
		.key = "ril.volte.hos.interface9",
		.value = "0",
	},
	{
		.key = "ril.volte.mal.latency",
		.value = "65535",
	},
	{
		.key = "ril.volte.mal.opkey",
		.value = "0x0001",
	},
	{
		.key = "ril.volte.mal.pkterrth",
		.value = "99",
	},
	{
		.key = "ril.volte.mal.pktlosth",
		.value = "99",
	},
	{
		.key = "ril.volte.mal.rb_hoddc_t",
		.value = "3",
	},
	{
		.key = "ril.volte.mal.rb_hol2w_t",
		.value = "10",
	},
	{
		.key = "ril.volte.mal.rb_how2l_t",
		.value = "150",
	},
	{
		.key = "ril.volte.mal.retranth",
		.value = "99",
	},
	{
		.key = "ril.volte.mal.throupt",
		.value = "65535",
	},
	{
		.key = "ril.volte.mal.vijit",
		.value = "3",
	},
	{
		.key = "ril.volte.mal.vojit",
		.value = "26",
	},
	{
		.key = "rild.libargs",
		.value = "-d /dev/ttyC0",
	},
	{
		.key = "rild.libpath",
		.value = "mtk-ril.so",
	},
	{
		.key = "rild.mark_switchuser",
		.value = "0",
	},
	{
		.key = "ro.adb.secure",
		.value = "1",
	},
	{
		.key = "ro.allow.mock.location",
		.value = "0",
	},
	{
		.key = "ro.audio.silent",
		.value = "0",
	},
	{
		.key = "ro.baseband",
		.value = "unknown",
	},
	{
		.key = "ro.board.platform",
		.value = "mt6735m",
	},
	{
		.key = "ro.boot.bootreason",
		.value = "wdt_by_pass_pwk",
	},
	{
		.key = "ro.boot.countrycode",
		.value = "MY",
	},
	{
		.key = "ro.boot.hardware",
		.value = "mt6735",
	},
	{
		.key = "ro.boot.mode",
		.value = "normal",
	},
	{
		.key = "ro.boot.name",
		.value = "android",
	},
	{
		.key = "ro.boot.serialno",
		.value = "62213210HY1171207Z9",
	},
	{
		.key = "ro.boot.sncode",
		.value = "HKE7FCXU",
	},
	{
		.key = "ro.bootimage.build.date",
		.value = "Fri Nov 4 21:54:39 CST 2016",
	},
	{
		.key = "ro.bootimage.build.date.utc",
		.value = "1478267679",
	},
	{
		.key = "ro.bootimage.build.fingerprint",
		.value = "full_lcsh6735m_35u_m/lcsh6735m_35u_m:6.0/MRA58K/1478267301:user/release-keys",
	},
	{
		.key = "ro.bootloader",
		.value = "unknown",
	},
	{
		.key = "ro.bootmode",
		.value = "normal",
	},
	{
		.key = "ro.build.characteristics",
		.value = "default",
	},
	{
		.key = "ro.build.date",
		.value = "Fri Nov  4 21:52:25 CST 2016",
	},
	{
		.key = "ro.build.date.utc",
		.value = "1478267545",
	},
	{
		.key = "ro.build.description",
		.value = "full_lcsh6735m_35u_m-user 6.0 MRA58K 1478267301 release-keys",
	},
	{
		.key = "ro.build.device.ninur",
		.value = "64687",
	},
	{
		.key = "ro.build.display.id",
		.value = "A6600a40_S032_161104_ROW",
	},
	{
		.key = "ro.build.fingerprint",
		.value = "Lenovo/A6600a40/A6600a40:6.0/MRA58K/A6600a40_S032_161104_ROW:user/release-keys",
	},
	{
		.key = "ro.build.flavor",
		.value = "full_lcsh6735m_35u_m-user",
	},
	{
		.key = "ro.build.host",
		.value = "glsrv4",
	},
	{
		.key = "ro.build.id",
		.value = "MRA58K",
	},
	{
		.key = "ro.build.product",
		.value = "A6600a40",
	},
	{
		.key = "ro.build.tags",
		.value = "release-keys",
	},
	{
		.key = "ro.build.type",
		.value = "user",
	},
	{
		.key = "ro.build.user",
		.value = "jenkins",
	},
	{
		.key = "ro.build.version.all_codenames",
		.value = "REL",
	},
	{
		.key = "ro.build.version.base_os",
		.value = "",
	},
	{
		.key = "ro.build.version.codename",
		.value = "REL",
	},
	{
		.key = "ro.build.version.incremental",
		.value = "A6600a40_S032_161104_ROW",
	},
	{
		.key = "ro.build.version.preview_sdk",
		.value = "0",
	},
	{
		.key = "ro.build.version.release",
		.value = "6.0",
	},
	{
		.key = "ro.build.version.sdk",
		.value = "23",
	},
	{
		.key = "ro.build.version.security_patch",
		.value = "2016-10-05",
	},
	{
		.key = "ro.camera.sound.forced",
		.value = "0",
	},
	{
		.key = "ro.carrier",
		.value = "unknown",
	},
	{
		.key = "ro.com.android.dateformat",
		.value = "MM-dd-yyyy",
	},
	{
		.key = "ro.com.android.mobiledata",
		.value = "false",
	},
	{
		.key = "ro.com.google.clientidbase",
		.value = "android-lenovo",
	},
	{
		.key = "ro.com.google.clientidbase.am",
		.value = "android-lenovo",
	},
	{
		.key = "ro.com.google.clientidbase.gmm",
		.value = "android-lenovo",
	},
	{
		.key = "ro.com.google.clientidbase.ms",
		.value = "android-lenovo",
	},
	{
		.key = "ro.com.google.clientidbase.yt",
		.value = "android-lenovo",
	},
	{
		.key = "ro.com.google.gmsversion",
		.value = "6.0_r6",
	},
	{
		.key = "ro.config.alarm_alert",
		.value = "New_Morning.ogg",
	},
	{
		.key = "ro.config.msg_notification",
		.value = "Curiosity.ogg",
	},
	{
		.key = "ro.config.notification_sound",
		.value = "Notice.ogg",
	},
	{
		.key = "ro.config.ringtone",
		.value = "Fantastic_Clang.ogg",
	},
	{
		.key = "ro.crypto.fs_crypto_blkdev",
		.value = "/dev/block/dm-1",
	},
	{
		.key = "ro.crypto.state",
		.value = "encrypted",
	},
	{
		.key = "ro.crypto.type",
		.value = "block",
	},
	{
		.key = "ro.custom.external.version",
		.value = "LLD3I80.2.4_M320",
	},
	{
		.key = "ro.custom.hardware.version",
		.value = "H301",
	},
	{
		.key = "ro.custom.internal.version",
		.value = "LLD3I80.1.0.2.4T32L1104_M320",
	},
	{
		.key = "ro.dalvik.vm.native.bridge",
		.value = "0",
	},
	{
		.key = "ro.debuggable",
		.value = "0",
	},
	{
		.key = "ro.delete_all_recent_apps",
		.value = "1",
	},
	{
		.key = "ro.expect.recovery_id",
		.value = "0xf5bbd9207572df534d50ff297bc4f3220ff69a79000000000000000000000000",
	},
	{
		.key = "ro.frp.pst",
		.value = "/dev/block/platform/mtk-msdc.0/11230000.msdc0/by-name/frp",
	},
	{
		.key = "ro.gemini.smart_sim_switch",
		.value = "false",
	},
	{
		.key = "ro.hardware",
		.value = "mt6735",
	},
	{
		.key = "ro.have_aacencode_feature",
		.value = "1",
	},
	{
		.key = "ro.have_aee_feature",
		.value = "1",
	},
	{
		.key = "ro.kernel.zio",
		.value = "38,108,105,16",
	},
	{
		.key = "ro.lct.cetest",
		.value = "1",
	},
	{
		.key = "ro.lct_country_info_ctrl",
		.value = "1",
	},
	{
		.key = "ro.lenovo.audioparaver",
		.value = "PVT-2016-04-13",
	},
	{
		.key = "ro.lenovo.bqb",
		.value = "no",
	},
	{
		.key = "ro.lenovo.branch.name",
		.value = "ALPS.MP.M0.MP1.V2.39.1",
	},
	{
		.key = "ro.lenovo.build.date",
		.value = "201611042152",
	},
	{
		.key = "ro.lenovo.device",
		.value = "phone",
	},
	{
		.key = "ro.lenovo.easyimage.code",
		.value = "my",
	},
	{
		.key = "ro.lenovo.hardware.version",
		.value = "H301",
	},
	{
		.key = "ro.lenovo.lcdsize",
		.value = "5.0",
	},
	{
		.key = "ro.lenovo.operator",
		.value = "open",
	},
	{
		.key = "ro.lenovo.ota.extsd",
		.value = "sdcard",
	},
	{
		.key = "ro.lenovo.platform",
		.value = "mtk",
	},
	{
		.key = "ro.lenovo.region",
		.value = "row",
	},
	{
		.key = "ro.lenovo.series",
		.value = "Lenovo A6600 PLUS",
	},
	{
		.key = "ro.lenovo.version.no",
		.value = "01",
	},
	{
		.key = "ro.lenovo.vibeuistyle",
		.value = "true",
	},
	{
		.key = "ro.lenovo.wificert",
		.value = "no",
	},
	{
		.key = "ro.lenovosn2",
		.value = "HKE7FCXU",
	},
	{
		.key = "ro.lxf_lenovo_standard_usb",
		.value = "1",
	},
	{
		.key = "ro.mediatek.chip_ver",
		.value = "S01",
	},
	{
		.key = "ro.mediatek.gemini_support",
		.value = "true",
	},
	{
		.key = "ro.mediatek.platform",
		.value = "MT6735",
	},
	{
		.key = "ro.mediatek.project.path",
		.value = "device/lcsh/lcsh6735m_35u_m",
	},
	{
		.key = "ro.mediatek.version.branch",
		.value = "alps-mp-m0.mp1",
	},
	{
		.key = "ro.mediatek.version.release",
		.value = "alps-mp-m0.mp1-V2.39.1_lcsh6735m.35u.m_P62",
	},
	{
		.key = "ro.mediatek.version.sdk",
		.value = "4",
	},
	{
		.key = "ro.mediatek.wlan.p2p",
		.value = "1",
	},
	{
		.key = "ro.mediatek.wlan.wsc",
		.value = "1",
	},
	{
		.key = "ro.mount.fs",
		.value = "EXT4",
	},
	{
		.key = "ro.mtk_agps_app",
		.value = "1",
	},
	{
		.key = "ro.mtk_antibricking_level",
		.value = "2",
	},
	{
		.key = "ro.mtk_audenh_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_ape_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_profiles",
		.value = "1",
	},
	{
		.key = "ro.mtk_audio_tuning_tool_ver",
		.value = "V1",
	},
	{
		.key = "ro.mtk_besloudness_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bessurround_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_bg_power_saving_ui",
		.value = "1",
	},
	{
		.key = "ro.mtk_bip_scws",
		.value = "1",
	},
	{
		.key = "ro.mtk_bt_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_cam_mfb_support",
		.value = "0",
	},
	{
		.key = "ro.mtk_dhcpv6c_wifi",
		.value = "1",
	},
	{
		.key = "ro.mtk_dialer_search_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_dual_mic_support",
		.value = "0",
	},
	{
		.key = "ro.mtk_eap_sim_aka",
		.value = "1",
	},
	{
		.key = "ro.mtk_emmc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_enable_md1",
		.value = "1",
	},
	{
		.key = "ro.mtk_fd_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_flight_mode_power_off_md",
		.value = "1",
	},
	{
		.key = "ro.mtk_flv_playback_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_fm_recording_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_gemini_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_gps_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_ims_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_ipo_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_is_tablet",
		.value = "0",
	},
	{
		.key = "ro.mtk_lte_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_md_sbp_custom_value",
		.value = "0",
	},
	{
		.key = "ro.mtk_miravision_image_dc",
		.value = "1",
	},
	{
		.key = "ro.mtk_mobile_management",
		.value = "1",
	},
	{
		.key = "ro.mtk_multisim_ringtone",
		.value = "1",
	},
	{
		.key = "ro.mtk_oma_drm_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_omacp_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_passpoint_r1_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_fast_start_win",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_response_time",
		.value = "1",
	},
	{
		.key = "ro.mtk_perf_simple_start_win",
		.value = "1",
	},
	{
		.key = "ro.mtk_perfservice_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_pq_support",
		.value = "2",
	},
	{
		.key = "ro.mtk_rild_read_imsi",
		.value = "1",
	},
	{
		.key = "ro.mtk_safemedia_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_search_db_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_send_rr_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_shared_sdcard",
		.value = "1",
	},
	{
		.key = "ro.mtk_sim_hot_swap",
		.value = "1",
	},
	{
		.key = "ro.mtk_tetheringipv6_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_thumbnail_play_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_volte_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wappush_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_widevine_drm_l3_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wifi_mcc_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_wlan_support",
		.value = "1",
	},
	{
		.key = "ro.mtk_world_phone_policy",
		.value = "0",
	},
	{
		.key = "ro.opengles.version",
		.value = "196608",
	},
	{
		.key = "ro.phone.date_format",
		.value = "dd-MM-yyyy",
	},
	{
		.key = "ro.phone.fm_band",
		.value = "Default",
	},
	{
		.key = "ro.phone.min_match",
		.value = "7",
	},
	{
		.key = "ro.phone.wifi_channel",
		.value = "1-13",
	},
	{
		.key = "ro.product.board",
		.value = "",
	},
	{
		.key = "ro.product.brand",
		.value = "Lenovo",
	},
	{
		.key = "ro.product.countrycode",
		.value = "MY",
	},
	{
		.key = "ro.product.cpu.abi",
		.value = "armeabi-v7a",
	},
	{
		.key = "ro.product.cpu.abi2",
		.value = "armeabi",
	},
	{
		.key = "ro.product.cpu.abilist",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist32",
		.value = "armeabi-v7a,armeabi",
	},
	{
		.key = "ro.product.cpu.abilist64",
		.value = "",
	},
	{
		.key = "ro.product.device",
		.value = "A6600a40",
	},
	{
		.key = "ro.product.locale",
		.value = "en-US",
	},
	{
		.key = "ro.product.locale.language",
		.value = "en",
	},
	{
		.key = "ro.product.locale.region",
		.value = "US",
	},
	{
		.key = "ro.product.manufacturer",
		.value = "LENOVO",
	},
	{
		.key = "ro.product.model",
		.value = "Lenovo A6600a40",
	},
	{
		.key = "ro.product.name",
		.value = "A6600a40",
	},
	{
		.key = "ro.product.ota.model",
		.value = "LenovoA6600a40",
	},
	{
		.key = "ro.product.sw.external.version",
		.value = "A6600a40_S032_161104_ROW",
	},
	{
		.key = "ro.product.sw.internal.version",
		.value = "A6600a40_USR_S032_1611042152_M0MP1_ROW",
	},
	{
		.key = "ro.recovery_id",
		.value = "0xf5bbd9207572df534d50ff297bc4f3220ff69a79000000000000000000000000",
	},
	{
		.key = "ro.revision",
		.value = "0",
	},
	{
		.key = "ro.secure",
		.value = "1",
	},
	{
		.key = "ro.serialno",
		.value = "62213210HY1171207Z9",
	},
	{
		.key = "ro.setupwizard.mode",
		.value = "OPTIONAL",
	},
	{
		.key = "ro.sf.hwrotation",
		.value = "0",
	},
	{
		.key = "ro.sf.lcd_density",
		.value = "320",
	},
	{
		.key = "ro.sim_me_lock_mode",
		.value = "0",
	},
	{
		.key = "ro.sim_refresh_reset_by_modem",
		.value = "1",
	},
	{
		.key = "ro.sys.usb.bicr",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.charging.only",
		.value = "yes",
	},
	{
		.key = "ro.sys.usb.mtp.whql.enable",
		.value = "0",
	},
	{
		.key = "ro.sys.usb.storage.type",
		.value = "mtp,mass_storage",
	},
	{
		.key = "ro.telephony.sim.count",
		.value = "2",
	},
	{
		.key = "ro.wifi.channels",
		.value = "",
	},
	{
		.key = "ro.wlan.mtk.wifi.5g",
		.value = "0",
	},
	{
		.key = "ro.zygote",
		.value = "zygote32",
	},
	{
		.key = "ro.zygote.preload.enable",
		.value = "0",
	},
	{
		.key = "security.perf_harden",
		.value = "1",
	},
	{
		.key = "selinux.reload_policy",
		.value = "1",
	},
	{
		.key = "service.bootanim.exit",
		.value = "0",
	},
	{
		.key = "service.nvram_init",
		.value = "Ready",
	},
	{
		.key = "service.wcn.coredump.mode",
		.value = "0",
	},
	{
		.key = "service.wcn.driver.ready",
		.value = "yes",
	},
	{
		.key = "sys.boot.reason",
		.value = "0",
	},
	{
		.key = "sys.ipo.pwrdncap",
		.value = "2",
	},
	{
		.key = "sys.usb.config",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.ffs.ready",
		.value = "1",
	},
	{
		.key = "sys.usb.state",
		.value = "mtp,adb",
	},
	{
		.key = "sys.usb.vid",
		.value = "0E8D",
	},
	{
		.key = "vold.decrypt",
		.value = "trigger_restart_framework",
	},
	{
		.key = "vold.encryption.type",
		.value = "default",
	},
	{
		.key = "vold.has_adoptable",
		.value = "1",
	},
	{
		.key = "vold.post_fs_data_done",
		.value = "1",
	},
	{
		.key = "vold.support_external_sd",
		.value = "1",
	},
	{
		.key = "wfd.dummy.enable",
		.value = "1",
	},
	{
		.key = "wifi.direct.interface",
		.value = "p2p0",
	},
	{
		.key = "wifi.interface",
		.value = "wlan0",
	},
	{
		.key = "wifi.tethering.interface",
		.value = "ap0",
	},
	{ NULL },
};
#endif /* __ANDROID__ */
