DACS.INSTALL(7)         DACS Miscellaneous Information         DACS.INSTALL(7)



[1mNAME[0m
       dacs.install - [1mDACS [22minstallation guide

[1mDESCRIPTION[0m
       This document describes how to build and install this release of [1mDACS[22m.
       Please read it carefully.

           [1mImportant[0m
           +o   Installation requires the GNU [1mmake [22mcommand ([34m[1mgmake[0m[1m[22m[1]) and
               [34m[1mGCC[0m[1m[22m[2]. On macOS, [34m[1mLLVM/Clang[0m[1m[22m[3] is used.

           +o   Our philosophy is that [1mDACS [22mshould be used with the most recent
               stable versions of third-party packages (such as [1mOpenSSL[22m)
               available at the time [1mDACS [22mis released. This helps to ensure
               that a [1mDACS [22mdeployment has the latest security features and bug
               fixes. A [1mDACS [22mrelease will most likely not have been tested
               with older (or newer) third-party packages, and the [1mDACS[0m
               instructions for configuring or building an older release may
               be incorrect. You may save yourself time and headaches if you
               just use the recommended releases.

               That said, third-party software used by [1mDACS [22mis often already
               installed or readily obtained using [1myum[22m, [1mrpm[22m, [1mpkg[22m, or a similar
               package manager. These are often not the latest versions, but
               sometimes convenience outweighs other factors. Provided the
               [1mDACS [22mdocumentation does not forbid a particular version and
               [1mDACS [22mseems to build and test correctly with it, you may elect
               to use it.

               For a very few third-party packages, it is important that you
               use the [4mexact[24m [4mversion[24m that is mentioned. Do not use anything
               newer or older.

               For some third-party packages, a particular release is
               [4mrecommended[24m. It is less critical that you use the recommended
               release.

               Sometimes the recommended version of a third-party package will
               be fine on some platforms but is buggy or will not build on
               another platform. Whenever possible, the [1mDACS [22minstallation
               instructions suggest an alternative version, and you may
               proceed with that version, or a recent version of your choice -
               but keep the preceding comments regarding older releases in
               mind and ensure that a "[1mgmake test[22m" of [1mDACS [22mcompletes
               successfully.

           +o   Should a critical bug in a third-party package be found, the
               [34m[1mPost-Release Notes[0m[1m[22m[4] section will provide instructions.

           +o   You should build third-party packages in the order in which
               they are discussed below because packages that are discussed
               earlier may require some that appear later.

           +o   The examples here and in other [1mDACS [22mdocumentation assume that
               [1mDACS [22mis installed in its default location, /usr/local/dacs. If
               you specify a different location at build time, please keep
               this in mind as you read the documentation. This also applies
               to third-party packages, which you may install where
               convenient, provided you are careful not to confuse or combine
               different versions of the same package; in this document's
               examples we install them under /usr/local and unpack their
               source code under /local/src.

           +o   In some examples, long lines have been split to improve
               readability. Copy-and-paste with care.

           +o   Whenever you upgrade to a more recent version of [1mDACS[22m, do not
               forget to install the [1mmod_auth_dacs [22mmodule that comes with your
               new version of [1mDACS[22m.  [1mDACS [22mweb-based access control
               ([34m[1mdacs_acs(8)[0m[1m[22m[5]) will deny all access if it detects an
               incompatible version of [1mmod_auth_dacs[22m.

           +o   On macOS you will probably need to install the [34m[1mXcode[0m[1m[22m[6]
               development environment.

           +o   On some platforms, the PAM development environment is required
               if you need [1mDACS [22mto authenticate against Unix accounts. If
               security/pam_appl.h is in a standard include directory, as is
               often the case, it has probably been installed and no action is
               necessary. On platforms where this development environment is
               optional (CentOS), it may be necessary to install it; for
               example,

                   # yum install pam-devel.x86_64

               For details, refer to [34m[1mUsing Pluggable Authentication Modules[0m
               [1m[34m(PAM)[0m[1m[22m[7].

           +o   On some systems it will be necessary to use [34m[1mldconfig(8)[0m[1m[22m[8] (or
               equivalent) so that your system finds the correct shared
               libraries for programs that are executed by the web server,
               including the [1mDACS [22mweb services. Command such as [34m[1mldd(1)[0m[1m[22m[9] and
               [1motool [22mmay be helpful.

           +o   Solaris and OpenSolaris are no longer supported. Notes
               regarding these unsupported platforms and deprecated releases
               of supported platforms may appear in the [1mDACS [22mdocumentation and
               source code.

           +o   [1mDACS [22mis not supported on Microsoft Windows platforms.
               [34m[1mCygwin[0m[1m[22m[10], which provides a GNU/Linux-like environment for
               Windows, is not an officially-supported platform, but earlier
               [1mDACS [22mreleases would usually build on it. At that time, running
               [1mDACS [22mutilities and commands on Windows (such as [1mdacscheck[22m)
               required installing the binaries along with the Cygwin run-time
               libraries, such as /bin/cygwin1.dll and /bin/cygcrypt-0.dll.


   [1mTrying DACS[0m
       If at this time you only want to try [1mDACS [22mrather than doing a full
       install, review the information below regarding third-party packages
       and then proceed to follow the instructions you will find in
       [34m[1mdacs.quick(7)[0m[1m[22m[11], which is a step-by-step tutorial for installing and
       configuring [1mDACS[22m.

   [1mUpgrading DACS[0m
       If [1mDACS [22m1.4 is already installed on your system and you are not
       changing any third-party packages or installation options, for a "quick
       and dirty" upgrade you can often install a new release on top of a
       previous release. While this will leave your existing [1mDACS[0m
       configuration files alone, it will also leave files that are no longer
       needed by the new [1mDACS[22m. Be sure to check the new distribution's release
       notes, HISTORY file, and the rest of this manual page for any notable
       changes and incompatibilities - you may need to make some adjustments
       to your pre-existing installation.

       It is possible for minor, incompatible changes introduced by a new
       release to cause temporary, user-visible problems. For example, changes
       to the format of credentials might invalidate sessions (i.e., [1mDACS [22mHTTP
       cookies) issued by the earlier release, requiring users to
       reauthenticate.

        1. Make a backup copy of the previous install, just in case.  [4mIt[24m [4mis[0m
           [4mespecially[24m [4mimportant[24m [4mto[24m [4mmake[24m [4mcopies[24m [4mof[24m [4mall[24m [4mdata[24m [4mfiles[24m [4m(such[24m [4mas[24m [1mDACS[0m
           [4mpassword[24m [4mfiles,[24m [4mother[24m [4mkinds[24m [4mof[24m [4maccount[24m [4mfiles,[24m [4mencryption[24m [4mkeys)[24m [4mand[0m
           [4many[24m [4mcustom[24m [4mconfiguration[24m [4m(such[24m [4mas[24m [4maccess[24m [4mcontrol[24m [4mrules)[24m.

        2. Obtain and unpack the new distribution and [1mchdir [22mto it;

        3. Review [34m[1mdacs.readme(7)[0m[1m[22m[12] and the instructions in this document;

        4. Copy src/config.nice from your installed version to the new src
           directory, make any updates and corrections that are necessary, and
           configure [1mDACS[22m:

               % cd src; sh ./config.nice


        5. Build [1mDACS[22m:

               % gmake


        6. We recommend that you remove some of the files from the previous
           release in case they are no longer required or have been renamed.
           Unless you have put non-standard files in them or made non-standard
           customizations, it is safe to simply delete these directories and
           their contents:

               % rm -f -r /usr/local/dacs/{acls,bin,include,lib,man,www}


        7. Stop [1mhttpd[22m:

               % apachectl stop


        8. Install [1mDACS[22m:

               % gmake install


        9. Make and install the latest [34m[1mmod_auth_dacs module[0m[1m[22m[13]:

               % cd ../apache; gmake tag install


       10. Restart [1mhttpd[22m:

               % apachectl start

           or

               % apachectl startssl


       11. Check that [1mDACS [22mappears to be working correctly. You may find it
           handy to construct a set of links or bookmarks that you can use
           after installing or configuring [1mDACS [22mto invoke various [1mDACS [22mweb
           services with appropriate arguments; for instance, try
           [34m[1mdacs_authenticate(8)[0m[1m[22m[14] [34m[1mdacs_current_credentials(8)[0m[1m[22m[15],
           [34m[1mdacs_prenv(8)[0m[1m[22m[16], [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[17],
           [34m[1mdacs_conf(8)[0m[1m[22m[18], [34m[1mdacs_signout(8)[0m[1m[22m[19], and [34m[1mdacs_version(8)[0m[1m[22m[20].
           Review the [1mDACS [22mlog file for any error messages or warnings.

   [1mInstallation Layout Overview[0m
       By default, [1mDACS [22mis installed under /usr/local/dacs. It is sometimes
       installed as /usr/local/dacs-[4mversion[24m (e.g., /usr/local/dacs-1.4.30)
       with the current version symbolically linked to, and referenced as,
       /usr/local/dacs. In the documentation and [1mDACS [22mconfiguration files, the
       root directory used is referred to as [34m[1mDACS_HOME[0m[1m[22m[21] or the
       [34m[1mconfiguration variable[0m[1m[22m[22] [4m${Conf::DACS_HOME}[24m. The locations of other
       components are usually specified relative to the actual root directory,
       as in site.conf (and its template, conf/site.conf-std) and dacs.conf.
       While the default layout of directories and files is adequate, system
       administrators often customize it, which is not difficult to do.
       Customization might be desirable for security, availability, aesthetic,
       or performance reasons.

       Briefly, the default directory layout is as follows. The organization
       of files and directories within these directories can be customized by
       system administrators through changes to site.conf and dacs.conf and
       largely depends on how many federations and jurisdictions will be
       configured and how much configuration is shared by different
       federations and jurisdictions. Also see [34m[1mConfiguration Variables[0m[1m[22m[22].

       /usr/local/dacs
           The installation root directory.

       /usr/local/dacs/acls
           Default access control list files for [1mDACS [22mweb services and
           resources, copied from the distribution's acls directory.

       /usr/local/dacs/bin
           This contains [1mDACS [22mcommands and utilities (and excludes the
           [34m[1mmod_auth_dacs module[0m[1m[22m[13], which is installed in [1mApache[22m's modules
           directory).

       /usr/local/dacs/etc
           Currently unused.

       /usr/local/dacs/federations
           This directory will contain one directory per federation, and each
           of those subdirectories will contain one directory per
           jurisdiction. The following example shows a default configuration
           for a site that belongs to two federations, having domains
           fed1.example.com and fed2.example.com. The site has two
           jurisdictions (JUR1 and JUR2) at this site that belong to the
           former federation and one jurisdiction (JUR8) in the latter
           federation.

                 /usr/local/dacs/federations/fed1.example.com
                 /usr/local/dacs/federations/fed1.example.com/federation_keyfile
                 /usr/local/dacs/federations/fed1.example.com/JUR1
                 /usr/local/dacs/federations/fed1.example.com/JUR1/jurisdiction_keyfile
                 /usr/local/dacs/federations/fed1.example.com/JUR1/acls
                 /usr/local/dacs/federations/fed1.example.com/JUR1/acls/revocations
                 /usr/local/dacs/federations/fed1.example.com/JUR1/auth_tokens
                 /usr/local/dacs/federations/fed1.example.com/JUR1/auth_token_keys
                 /usr/local/dacs/federations/fed1.example.com/JUR1/auth_token_keys.prev
                 /usr/local/dacs/federations/fed1.example.com/JUR1/groups
                 /usr/local/dacs/federations/fed1.example.com/JUR1/passwd
                 /usr/local/dacs/federations/fed1.example.com/JUR1/roles

                 /usr/local/dacs/federations/fed1.example.com/JUR2
                 /usr/local/dacs/federations/fed1.example.com/JUR2/jurisdiction_keyfile
                 /usr/local/dacs/federations/fed1.example.com/JUR2/acls
                 /usr/local/dacs/federations/fed1.example.com/JUR2/acls/revocations
                 /usr/local/dacs/federations/fed1.example.com/JUR2/auth_tokens
                 /usr/local/dacs/federations/fed1.example.com/JUR2/auth_token_keys
                 /usr/local/dacs/federations/fed1.example.com/JUR2/auth_token_keys.prev
                 /usr/local/dacs/federations/fed1.example.com/JUR2/groups
                 /usr/local/dacs/federations/fed1.example.com/JUR2/passwd
                 /usr/local/dacs/federations/fed1.example.com/JUR2/roles


                 /usr/local/dacs/federations/fed2.example.com
                 /usr/local/dacs/federations/fed2.example.com/federation_keyfile
                 /usr/local/dacs/federations/fed2.example.com/JUR8
                 /usr/local/dacs/federations/fed2.example.com/JUR8/jurisdiction_keyfile
                 /usr/local/dacs/federations/fed2.example.com/JUR8/acls
                 /usr/local/dacs/federations/fed2.example.com/JUR8/acls/revocations
                 /usr/local/dacs/federations/fed2.example.com/JUR8/auth_tokens
                 /usr/local/dacs/federations/fed2.example.com/JUR8/auth_token_keys
                 /usr/local/dacs/federations/fed2.example.com/JUR8/auth_token_keys.prev
                 /usr/local/dacs/federations/fed2.example.com/JUR8/groups
                 /usr/local/dacs/federations/fed2.example.com/JUR8/passwd
                 /usr/local/dacs/federations/fed2.example.com/JUR8/roles




           If additional data or configuration files are needed, an
           administrator is free to place them wherever convenient within this
           hierarchy by referencing them using appropriate configuration
           directives in dacs.conf.

       /usr/local/dacs/include
           This directory contains header files for use with custom [1mDACS [22mcode.

       /usr/local/dacs/lib
           Run-time libraries are installed here.

       /usr/local/dacs/logs
           Run-time log files are written here by [34m[1mdacs_acs(8)[0m[1m[22m[5] and [1mDACS[0m
           commands.

       /usr/local/dacs/sbin
           Analogous to /usr/sbin, system administrative commands are
           installed here.

       /usr/local/dacs/share/man
           [1mDACS [22mmanual pages for use by [34m[1mman(1)[0m[1m[22m[23] are installed here.

       /usr/local/dacs/tmp
           Various temporary run-time files, such as lock files, are kept in
           this directory.

       /usr/local/dacs/www
           [1mDACS [22mHTML documentation is installed here.

   [1mInstalling DACS[0m
       The following describes how to install [1mDACS[22m.

           [1mImportant[0m
           +o   If another release of [1mDACS [22mis present, rename your previous
               release, install the new release, and then copy any
               site-specific configuration files from the previous release to
               the new release.

           +o   Be careful not to mix [1mDACS [22mbinaries and support files from
               different releases. This can lead to strange behaviour that is
               often hard to resolve.

           +o   If you are installing or upgrading a third-party package, make
               sure that you are building it against the correct include files
               and libraries (e.g., ensure that the [1mDACS [22mbuild is not finding
               an old version, or using include files from one version and
               library files from a different version, or that [1mhttpd [22mis trying
               to use the wrong version of an [1mOpenSSL [22mlibrary). This is
               frequently the cause of build and run-time problems.

        1. Unpack the [1mDACS [22mdistribution and move to its root directory.

        2. Familiarize yourself with the system by:

           +o   reading this document;

           +o   running:

                   % src/configure --help


           +o   browsing through the documentation (best done by loading
               [34m[1mman/index.html[0m[1m[22m[24] into your browser);

           +o   deciding where you want the various components to be installed;
               and

           +o   considering which optional features you may want (you can
               easily make changes at any time, so do not be too concerned
               about this).

            3. A few third-party packages are [4mrequired[24m by [1mDACS [22mand must be
               built before [1mDACS [22mcan be configured and built. Please note
               carefully if any special exceptions apply to your particular
               platform and third-party package needs. Although you may have
               better luck, sometimes we experienced problems building the
               recommended packages (or combinations of packages) on certain
               platforms; whenever possible, we try to provide a workable
               alternative. Late-breaking updates are sometimes available in
               the release's [34m[1mPost-Release Notes[0m[1m[22m[4].

                   [1mImportant[0m
                   It is not necessary to actually [4minstall[24m these packages, you
                   only have to [4mbuild[24m them so that the [1mDACS [22mbuild can use
                   their libraries, include files, and so on, directly from
                   where you build the packages. You may chose to do this if
                   you do not want to upgrade an existing version of the
                   package, or if you are unable to do so.

                   Shared libraries belonging to these packages must be
                   accessible at run-time, so [4mplease[24m [4mmake[24m [4msure[24m [4mthat[24m [4mtheir[24m [4mpath[0m
                   [4mpermissions[24m [4menable[24m [4mthem[24m [4mto[24m [4mbe[24m [4mread[24m [4mby[24m [4ma[24m [4mprogram[24m [4mexecuting[0m
                   [4mwith[24m [1mApache[4m[22m's[24m [4mCGI[24m [4mpermissions[24m.

                   Build these packages [4min[24m [4mthe[24m [4morder[24m [4min[24m [4mwhich[24m [4mthey[24m [4mare[24m [4mlisted[0m
                   [4mbelow[24m.

                   If you install a package, you may need to be root or use
                   [34m[1msudo(8)[0m[1m[22m[25] (e.g., "[1msudo make install[22m").

                   These packages are not distributed with [1mDACS [22mand have
                   licensing terms completely separate from those of [1mDACS [22mthat
                   are your responsibility.

               [1mThird-Party Package Index:[0m

               +o   [1mExpat[22m: XML parser

               +o   [1mOpenSSL[22m: Crytographic toolkit

               +o   [1mApache[22m: Web server

               +o   Berkeley DB, gdbm, ndbm: dbm-type database libraries

               +o   [1mSQLite[22m: SQL database engine

               +o   [1mlibdsm/Samba[22m: NTLM authentication protocol client

               +o   libxml2, xmlsec1: XML toolkit and security libraries

               +o   [1mOpenLDAP[22m: Lightweight Directory Access Protocol software

               +o   Readline: Command line history and editing

                1. Install the Expat XML parser

                   This release of [1mDACS [22mhas been tested with [34m[1mExpat[0m[1m[22m[26] 2.2.5
                   and we recommend that you use that release.

                   For use with [1mDACS[22m, [1mExpat [22mcan either be built with
                   [1m-prefix=/usr/local [22mor something like
                   [1m-prefix=/usr/local/expat-2.2.5[22m, whichever you prefer. In
                   the former case, you can omit the [1m--with-expat [22mwhen
                   configuring [1mDACS [22mor use [1m--with-expat=/usr/local[22m, and in the
                   latter case you must use
                   [1m--with-expat=/usr/local/expat-2.2.5[22m. Here is how we usually
                   build [1mExpat [22mafter unpacking it:

                       % cd expat-2.2.5
                       % ./configure --prefix=/usr/local/expat-2.2.5
                       % make
                       (All should go well.)
                       % make install
                       (All should go well here, too.)


                       [1mNote[0m
                       On Win2K/Cygwin, only a static library is needed. From
                       the root of the [1mexpat [22mdistribution directory:

                           % cd lib; ar rv libexpat.a *.o; ranlib libexpat.a

                       If the build fails, reconfigure using
                       [1m--enable-shared=no [22mand [1m--enable-static=yes [22mand try to
                       build it again.

                2. Install [1mOpenSSL[0m

                   [1mDACS [22muses cryptographic functionality provided by
                   [34m[1mOpenSSL[0m[1m[22m[27]. This release of [1mDACS [22mhas been tested with
                   openssl-1.0.2n and we recommend that you use that release
                   with [1mDACS[22m.  [1mApache [22mshould be built using the version of
                   [1mOpenSSL [22mrecommended by the particular [1mApache [22mrelease -
                   using a more recent version of [1mOpenSSL [22mmay introduce build
                   problems or run-time bugs in [1mApache[22m.  [4mIt[24m [4mis[24m [4mnot[24m [4mnecessary[0m
                   [4mfor[24m [1mApache [4m[22mand[24m [1mDACS [4m[22mto[24m [4muse[24m [4mthe[24m [4msame[24m [4mrelease[24m [4mof[24m [1mOpenSSL[22m.

                       [1mNotes[0m
                       +o   [1mDACS [22mwill likely work with recent openssl-1.0.1x
                           releases, although those versions are no longer
                           officially supported and may have important
                           security issues.

                       +o   If you are enabling [1mDACS [22msupport for Java, add the
                           [1m-fPIC [22mflag to [1mconfig [22mwhen you are building [1mOpenSSL[22m.

                       +o   In some configurations you may want or require
                           shared [1mOpenSSL [22mlibraries; if so, add the [1mshared[0m
                           command line flag to [1mconfig [22mwhen building [1mOpenSSL[22m.

                       +o   Here is how we built [1mOpenSSL[22m:

                               % ./config --prefix=/usr/local/openssl-1.0.2n --openssldir=/usr/local/openssl-1.0.2n \
                                   -fPIC shared


                       +o   On macOS, however, it was necessary to explicitly
                           request a 64-bit build of [1mOpenSSL[22m:

                               % ./Configure darwin64-x86_64-cc --prefix=/usr/local/openssl-1.0.2n \
                                   --openssldir=/usr/local/openssl-1.0.2n -fPIC shared


                    3. Install Apache 2.4.29 or 2.2.34

                       You will need an SSL/TLS-capable [34m[1mApache[0m[1m[22m[28] server
                       (build [1mApache [22mwith [1m--enable-ssl[22m) that uses a recent
                       version of [1mOpenSSL [22m(build [1mApache [22musing [1m--with-ssl=[4m[22mpath[24m,
                       see [34m[1mabove[0m[1m[22m[29]).

                           [1mImportant[0m
                           [1mDACS [22m1.4.40 is the final version to officially
                           support the Apache 2.2 series. Future releases of
                           [1mDACS [22mwill not be maintained, tested, or documented
                           with Apache 2.2 series servers.

                           [1mTip[0m
                           You can install a subset of [1mDACS [22mthat does not
                           require [1mApache [22mand does not require [4many[24m [1mDACS[0m
                           configuration. These stand-alone, general-purpose
                           utility commands, such as [1mdacshttp [22mand [1msslclient[22m,
                           might be of interest to you even if you are not
                           interested in any other parts of [1mDACS[22m. Look for
                           BASIC_PROGS in Makefile.in to see which commands
                           will be installed.

                           To build this subset, use [1m--with-apache=omit [22mwhen
                           running [1mconfigure[22m. Please continue to review the
                           information about third-party packages in this
                           document, but you can ignore anything that follows
                           that is related to [1mApache [22mand [1mmod_auth_dacs[22m.
                       If you want to use [34m[1mmod_auth_dacs[0m[1m[22m[13] as a dynamic
                       module, which is the recommended configuration, make
                       sure that [1mmod_so [22mis built-in to your [1mhttpd [22m("httpd -l"
                       displays a list).

                           [1mImportant[0m
                           +o   This release of [1mDACS [22mhas been tested with both
                               [1mApache [22m2.2.34 and [1mApache [22m2.4.29. We now
                               strongly recommend that you use 2.4.29.

                           +o   If suitable APR, APR-UTIL, and other support
                               libraries have already been installed on your
                               system, you may be able to perform a basic
                               build and install of [1mApache [22m2.4 with a command
                               like:

                                   % cd httpd-2.4.29
                                   % ./configure --prefix=/usr/local/apache2-2.4.29 --enable-ssl \
                                         --with-ssl=/usr/local/openssl-1.0.2n
                                   % make install


                           +o   Detailed instructions for building [1mApache[0m
                               2.4.29 can be found in Apache's INSTALL file.
                               For the testing platforms, we get the APR and
                               APR-UTIL libraries from [34m[1mapr.apache.org[0m[1m[22m[30] and
                               unpack them in the Apache distribution's srclib
                               directory, then rename them srclib/apr and
                               srclib/apr-util, respectively, as it says in
                               INSTALL. We currently use apr-1.6.3 and
                               apr-util-1.6.1. If you are building [1mhttpd [22mthis
                               way, include the [1m--with-included-apr [22mflag with
                               [1mconfigure[22m.

                           +o   On CentOS 5.9 and later, the [1mApache [22mbuild
                               initially failed with a complaint about not
                               finding [1mpcre-config[22m. To solve this, we did:

                                   # yum install pcre-devel.x86_64


                           +o   We sometimes run into minor problems
                               configuring or building [1mApache [22m2.4 on macOS,
                               especially after a recent [34m[1mXcode[0m[1m[22m[6] upgrade.
                               Ensure your [1mPATH [22mis correct. It is sometimes
                               necessary to make a symbolic link from an
                               [34m[1mXcode[0m[1m[22m[6] directory
                               /Applications/Xcode.app/Contents/Developer/Toolchains/XcodeDefault.xctoolchain/...
                               to a more conventional path so that it is
                               found. If necessary, obtain Perl Compatible
                               Regular Expressions (PCRE) from [34m[1mhttp://pcre.org[0m
                               and install it, then make sure that [1mpcre-config[0m
                               is on your [1mPATH[22m.

                           +o   When building [1mApache [22m2.2, running [1mconfigure [22mas
                               shown above will work in some cases
                               (distributions of the 2.2 branch include the
                               APR and APR-UTIL libraries, currently apr-1.6.3
                               and apr-util-1.6.1). If you decide not to use
                               the APR and APR-UTIL libraries that ship with
                               [1mApache[22m, remove or rename the existing
                               directories and install the fresh copies, which
                               is the procedure we usually follow.

                               After unpacking fresh copies of APR (as
                               srclib/apr) and APR-UTIL (as srclib/apr-util),
                               configure, build, and install them. We then
                               build [1mhttpd [22musing the [1m--with-apr [22mand
                               [1m--with-apr-util [22mflags. When you build [1mDACS [22min
                               an upcoming step, you will probably need to use
                               the [1m--with-apache [22mand [1m--with-apache-apr [22mflags
                               (see [34m[1mThird-party support options[0m[1m[22m[31]). If you
                               are going to use the [1m--with-berkeley-db [22mflag
                               when building APR-UTIL (e.g.,
                               [1m--with-berkeley-db=/usr/local/BerkeleyDB.5.3[22m),
                               you may want to temporarily skip ahead to [34m[1mbuild[0m
                               [1m[34mBerkeley DB[0m[1m[22m[32] before returning here to
                               continue your [1mApache [22mbuild. (Note: apr-util
                               will sometimes not work with the latest
                               versions of Berkeley DB; refer to documentation
                               for its [1m--with-dbm [22mflag).

                           +o   Here is how we built [1mApache [22m2.2 after unpacking
                               it and the correct versions of the APR and
                               APR-UTIL libraries:

                                   % cd httpd-2.2.34
                                   % cd srclib/apr
                                   % ./configure --prefix=/usr/local/apache2-2.2.34/apr-httpd --disable-lfs CFLAGS=-fPIC
                                   % make install
                                   % cd ../apr-util
                                   # See notes below for adding LDFLAGS
                                   % ./configure --prefix=/usr/local/apache2-2.2.34/apr-util-httpd
                                          --with-apr=/usr/local/apache2-2.2.34/apr-httpd
                                          --with-expat=/usr/local/expat-2.2.5
                                          --with-dbm=db53
                                   % make install
                                   % cd ../..
                                   # See notes below for adding LDFLAGS
                                   % ./configure --prefix=/usr/local/apache2-2.2.34 --enable-ssl
                                          --with-ssl=/usr/local/openssl-1.0.2n
                                          --with-apr=/usr/local/apache2-2.2.34/apr-httpd
                                          --with-apr-util=/usr/local/apache2-2.2.34/apr-util-httpd
                                          LDFLAGS="-rpath /usr/local/db-5.3.28/lib -rpath /usr/local/openssl-1.0.2n/lib"
                                   % make install

                               This builds a very basic server; you can enable
                               other options if you want.

                               Because we deal with multiple versions of
                               third-party packages, each release is installed
                               separately, hence the version numbers in the
                               pathnames.

                               If you encounter problems building [1mdacsversion[22m,
                               it may be necessary for you to go back and
                               build APR with the [1m--disable-lfs [22mflag to
                               disable large file support on your platform.

                               On FreeBSD, when doing the top level [1mApache[0m
                               configuration above it was necessary to add
                               "-rpath /usr/local/db-5.3.28/lib -rpath
                               /usr/local/openssl-1.0.2n/lib" to [4mLDFLAGS[24m so
                               that Apache commands could find shared
                               libraries at run time.

                               On CentOS, when building apr-util, and at the
                               top level, it was necessary to use (instead of
                               the -rpath flags) "-Wl,-rpath
                               /usr/local/db-5.3.28/lib -Wl,-rpath
                               /usr/local/openssl-1.0.2n/lib" to [4mLDFLAGS[24m.

                               Alternatively, on either platform the [1mldconfig[0m
                               command or [1mLD_LIBRARY_PATH [22mmight be used. It
                               appears that the [4mLDFLAGS[24m above should be
                               omitted on macOS.

                           +o   In some configurations an "undefined
                               ssl_hook_Fixup symbol" error or "Cannot load
                               modules/mod_ssl.so into server" error is
                               produced by [1mhttpd [22mwhen it starts up. This was
                               also seen in earlier releases of [1mApache[22m. These
                               errors can be due to an apparent bug in the
                               [1mApache [22mbuild procedure that results in the
                               [1mmod_ssl [22mmodule not knowing where libssl.so and
                               libcrypto.so are, even though the correct path
                               was specified at Apache build time through the
                               [1m--with-ssl [22mflag to [1mconfigure[22m.

                               One solution is to make [1mmod_ssl [22ma built-in
                               module instead of a dynamically loaded module.
                               Build [1mApache [22musing something similar to this
                               (using the [1m--enable-ssl=static [22mflag is the
                               important change):

                                   % ./configure --prefix=/usr/local/apache2-2.4.29 \
                                       --with-ssl=/usr/local/openssl-1.0.2n --enable-ssl=static

                               Then do a "[1mmake install[22m". Note that you will
                               need to comment out the httpd.conf directive
                               that loads [1mmod_ssl[22m:

                                   # LoadModule ssl_module modules/mod_ssl.so

                               Now, from the [1mApache [22minstallation directory,
                               try:

                                   % bin/httpd -l
                                   % bin/httpd -M

                               If [1mhttpd [22mcannot find your [1mOpenSSL [22mlibraries,
                               you will see an error message like this:

                                   error while loading shared libraries: libssl.so.1.0.0: cannot open
                                     shared object file: No such file or directory

                               Tell the linker where the [1mOpenSSL [22mlibraries are
                               by setting the [1mLD_LIBRARY_PATH [22menvironment
                               variable for [1mhttpd[22m; for example:

                                   %  sh -c "export LD_LIBRARY_PATH=/usr/local/openssl-1.0.2n/lib; bin/httpd -M"

                               You may also be able to resolve the problem
                               using the [1mldconfig [22mcommand, but we don't know
                               if that could possibly break other programs
                               that expect a different version of the [1mOpenSSL[0m
                               library. You will need to always set
                               [1mLD_LIBRARY_PATH [22mbefore running [1mhttpd[22m, maybe
                               using an alias or script. If you use [1mapachectl[0m
                               to manage [1mApache[22m, you could simply have it set
                               [1mLD_LIBRARY_PATH [22m(also see the [1mApache envvars[0m
                               script, which is sourced by [1mapachectl[22m).

                               Another thing to try if [1mApache [22mis unable to
                               load a shared library is to re-run [1mconfigure[0m
                               without the [1m--with-dbm [22mflag.

                           +o   Sometimes the [1mApache [22mbuild procedure [4minsists[24m on
                               using the system's version of apr or apr-util
                               rather than the version you explicitly asked
                               [1mconfigure [22mto use with [1m--with-apr [22mor
                               [1m--with-apr-util [22m(check using: [1mldd bin/httpd [22mor
                               [1motool bin/httpd[22m). If the linker complains about
                               an undefined symbol when you attempt to start
                               [1mApache[22m, this may be the reason. The easiest
                               solution is to temporarily hide the system
                               libraries that you don't want [1mconfigure [22mto use
                               and then re-make [1mApache[22m, checking that
                               [1mbin/httpd [22mis now referencing the expected
                               libraries and restoring the system libraries.

                           +o   If you find that your [1mApache [22mserver on CentOS
                               does not accept requests coming from the
                               network (non-localhost requests) it may be
                               because the operating system's security policy
                               is disallowing them. As root, do:

                                   # system-config-firewall

                               (This command is sometimes named
                               [1msystem-config-securitylevel[22m, or
                               [1msystem-config-firewall-tui [22min various releases
                               of CentOS). In the "Other ports" section of the
                               "Firewall Options", add the HTTP/HTTPS port(s)
                               you want to use for protocol TCP. Once the
                               change is applied it is persistent. Another
                               option, if it is safe to do so, is to totally
                               disable the firewall. On CentOS:

                                   # service iptables stop

                               (Alternative: [1msystemctl disable firewalld[22m) Note
                               that this change is not persistent, however.
                               Another alternative, for CentOS and other
                               systems, is to use the appropriate command
                               (e.g., [1miptables[22m, [1mipfw[22m, or [1mpfctl[22m) to add a
                               firewall rule to allow TCP access to your
                               HTTP/HTTPS port(s).

                           +o   One difference to be aware of between the
                               [1mApache [22m2.0 branch and subsequent branches is
                               that the default [1mApache [22mconfiguration of the
                               newer branches may deny all access by default;
                               some [1mDACS [22mfiles should be publicly accessible,
                               however, so you may need to explicitly allow
                               this. For example, in httpd.conf:

                                   <Directory /usr/local/dacs/www>
                                     Satisfy Any
                                     Allow from all
                                     Options Indexes FollowSymLinks
                                   </Directory>


                           +o   [1mApache [22m1.3 is [4mnot[24m supported; please consult the
                               [34m[1mFAQ[0m[1m[22m[33].  [1mDACS [22mhas not been tested with [1mApache[0m
                               2.3 or 2.4.

                           +o   We do not support using [1mmod_auth_dacs [22mwith a
                               non-source install of [1mApache[22m; we have received
                               feedback that it can be done manually without
                               much effort, however. In this case, we believe
                               that the install may go more smoothly if you
                               use the configure flag [1m--disable-shared[22m.

                           [1mTip[0m
                           Check that [1mApache [22mis working properly and that it
                           is actually using the version of [1mOpenSSL [22mthat you
                           are expecting. It is important to confirm that your
                           server is working correctly with your web resources
                           [4mbefore[24m [1mDACS [22mgets involved. Doing so can save you
                           time and frustration.

                           You can see your [1mhttpd's [22mServer response-header by
                           connecting to your server (e.g., using [1mtelnet[22m) and
                           engaging in an interaction with it similar to the
                           following (note the last line of output):

                               % telnet localhost 80
                               Trying 127.0.0.1...
                               Connected to localhost.
                               Escape character is '^]'.
                               GET / HTTP/1.0

                               HTTP/1.1 200 OK
                               Date: Tue, 20 Jan 2018 18:08:11 GMT
                               Server: Apache/2.4.29 (Unix) OpenSSL/1.0.2n mod_auth_dacs/1.4.40(Release date 31-Jan-2018 09:49:34) PHP/5.6.14

                4. A few third-party packages are [4moptional[24m and whether you
                   need them depends on which optional features of [1mDACS [22myou
                   require. These packages must be built before [1mDACS [22mcan be
                   configured and built. If you decide you want to add or
                   remove optional capabilities after building [1mDACS[22m, it is
                   easy to do so later.

                       [1mTip[0m
                       If you are new to [1mDACS[22m, it may be a good idea to first
                       build it without any optional packages. After you have
                       gotten the basic system working to your satisfaction,
                       rebuild [1mDACS [22mwith the optional components you need. Or,
                       if you are not sure at this time which optional
                       packages you need, return to this step later.

                    1. Berkeley DB, gdbm, ndbm DB (dbm-type databases)

                       If you want to be able to store [1mDACS [22mconfiguration
                       information in a database or need to access files
                       managed by [1mApache's mod_auth_dbm[22m, you may use [34m[1mBerkeley[0m
                       [1m[34mDB[0m[1m[22m[34] from [34m[1mOracle Corporation[0m[1m[22m[35] (Sleepy Cat Software
                       was acquired by Oracle in February, 2006). A suitable
                       version may already be installed on your system.
                       Typically, [1mApache [22mwill only build with a version of
                       Berkeley DB that is somewhat older than the latest.
                       Neither [1mDACS [22mnor [1mApache [22mrequire Berkeley DB, and they
                       do not need to use the same version of Berkeley DB.
                       Version db-5.3.28 is being used for testing, but
                       somewhat older versions should be fine. See the [1mDACS[0m
                       configure arguments: [34m[1m--enable-bdb[0m[1m[22m[36],
                       [34m[1m--disable-bdb[0m[1m[22m[37], and [34m[1m--with-bdb[0m[1m[22m[38].

                           [1mNotes[0m
                           Note that starting with db-6.x, licensing for
                           Berkeley DB [34m[1mchanged[0m[1m[22m[39] from the [34m[1mSleepycat[0m
                           [1m[34mLicense[0m[1m[22m[40] to the [34m[1mGNU AGPL v3[0m[1m[22m[41]. Installations
                           should consider whether they should use db-5.3.28
                           or switch to another supported dbm-type database.

                           [1mTip[0m
                           You may find that you must sign on to the Oracle
                           site before you are allowed to download Berkeley
                           DB. You may be able to avoid this by using a URL
                           such as:

                               [34m[1mhttp://download.oracle.com/berkeley-db/db-5.3.28.tar.gz[0m

                           You may also be able to obtain Berkeley DB
                           elsewhere, such as at linux.softpedia.com,
                           pkgs.fedoraproject.org, or fossies.org. Consider
                           validating the downloaded file using a checksum
                           published on a different site, however.
                       The default is to use Berkeley DB if it is available.
                       If you do not want to use Berkeley DB you must disable
                       it ([34m[1m--disable-bdb[0m[1m[22m[37]). Similar functionality is
                       provided by the NDBM library and from GNU GDBM
                       (versions 1.8.3 through 1.14, the latter being the
                       version tested against).  GNU GDBM must be built with
                       its NDBM compatibility mode. These libraries may
                       already be installed on your system. Get GDBM from
                       [34m[1mftp://ftp.gnu.org/gnu/gdbm[0m[1m[22m[42]. See the
                       [34m[1m--enable-ndbm[0m[1m[22m[43], [34m[1m--with-gdbm-lib[0m[1m[22m[44], and
                       [34m[1m--with-gdbm-includes[0m[1m[22m[44] configure flags.

                           [1mNotes[0m
                           +o   It may be necessary to create (or update) links
                               to the Berkeley DB installation directory to
                               avoid problems when building other packages.
                               For example, if you install it in
                               /usr/local/db-5.3.28:

                                   % ln -sf /usr/local/db-5.3.28 /usr/local/BerkeleyDB.5.3
                                   % ln -sf /usr/local/db-5.3.28 /usr/local/db53


                           +o   Here is how we built Berkeley DB for [1mDACS [22mafter
                               unpacking it:

                                   % cd build_unix
                                   % ../dist/configure --prefix=/usr/local/db-5.3.28
                                   % make
                                   (All should go well.)
                                   % make install
                                   (All should go well here, too.)


                           +o   On some platforms, applications (including
                               [1mDACS[22m) that use Berkeley DB may need to be
                               linked with the [1m-lpthread [22mflag.

                           +o   You cannot enable the NDBM library and GNU
                               GDBM. You can use either one with Berkeley DB.

                           +o   GNU GDBM 1.9.1 and newer may not interoperate
                               correctly with databases created by older
                               versions of GNU GDBM; consult its source code
                               and documentation for details.

                           +o   A deficiency in configuration processing is
                               that the location of the NDBM library cannot be
                               specified; the standard configuration search
                               path is used. A future version should provide a
                               [1m--with-ndbm [22mflag.

                           +o   The NDBM-workalike, [34m[1msdbm[0m[1m[22m[45], is not currently
                               supported. It may be added to a future release
                               if it is requested.

                    2. SQLite

                       The [34m[1mSQLite[0m[1m[22m[46] database, which can be used together
                       with the [34m[1mdbm-type databases[0m[1m[22m[32], is another option for
                       storing [1mDACS [22mconfiguration information. Version 3.22.0
                       is being used for testing (we use the "sqlite-autoconf"
                       amalgamation tarball). See the [1mDACS [22mconfigure
                       arguments: [34m[1m--enable-sqlite[0m[1m[22m[47], [34m[1m--disable-sqlite[0m[1m[22m[48],
                       and [34m[1m--with-sqlite[0m[1m[22m[49].

                           [1mNotes[0m
                           +o   On FreeBSD at least, an apparent bug in the
                               SQlite build procedure can cause a compilation
                               error. To avoid the error, edit the definition
                               of the DEFS symbol in the Makefile to remove
                               the embedded space by changing:

                                     -DPACKAGE_STRING=\"sqlite 3.22.0\"

                               to:


                                     -DPACKAGE_STRING=\"sqlite-3.22.0\"


                           +o   Here is how we built SQlite:

                                   % ./configure --prefix=/usr/local/sqlite-3.22.0
                                   % make
                                   % make install


                        3. [1mlibdsm/Samba[0m

                           If you want to be able to authenticate using
                           Microsoft's [34m[1mSMB[0m[1m[22m[50]/[34m[1mNTLM[0m[1m[22m[51] protocol (see
                           [34m[1mlocal_ntlm_authenticate[0m[1m[22m[52]), you must either
                           configure [1mDACS [22mto use the custom implementation of
                           the libdsm library that ships with [1mDACS [22mor obtain
                           [34m[1mSamba[0m[1m[22m[53], a Microsoft Windows interoperability
                           suite.

                           [1mDACS [22mNTLM authentication is currently tested
                           against services provided by Windows Server 2012
                           but [1mDACS [22mshould also interoperate with other MS
                           Windows platforms.

                               [1mImportant[0m
                               For a very long time, [1mSamba 3.x [22mprovided NTLM
                               client authentication for [1mDACS [22mand was the only
                               option. But because [1mSamba [22m3.x has not been
                               supported by the [1mSamba [22mteam for quite some
                               time, and [1mSamba [22m4.x has proved to be difficult
                               to build on [1mDACS [22mplatforms and is not a drop-in
                               replacement for [1mSamba [22m3.x in any case, the
                               smaller and simpler libdsm will replace [1mSamba[22m.
                               [1mSamba [22m3.x can still be used by this version of
                               [1mDACS [22mbut support for [1mSamba [4m[22mwill[24m [4mbe[24m [4mremoved[24m.

                               [1mlibdsm Notes[0m
                               Although the library is currently functional
                               and tested, configuration of libdsm is not
                               quite fully integrated or documented within the
                               main [1mDACS [22mbuild. To use libdsm:

                                1. Unpack the [1mDACS [22mtarfile

                                2. [1mchdir [22mto dacs-1.4.40/src/libdsm and refer
                                   to the README in that directory for
                                   detailed instructions.

                                   We continue here with a brief outline of
                                   the procedure to build the library. If you
                                   are going to enable NTLM authentication, or
                                   think you might do so later, build the
                                   library before running [1mconfigure [22mfor [1mDACS[22m.
                                   If you do not need NTLM authentication, you
                                   need not build the library.

                                3. Obtain the GNU libraries [34m[1mlibtasn1[0m[1m[22m[54] and
                                   [34m[1mlibiconv[0m[1m[22m[55]. No changes to those libraries
                                   are required. Build both libraries in
                                   place.

                                4. Configure and make the modified libdsm. The
                                   library is installed in its root directory
                                   and no system files or directories are
                                   modified. A program called [1mntlmauth [22mwill be
                                   built. You should use it to test
                                   authentication against your Windows server.

                                5. If all goes well, build [1mDACS [22mas you
                                   normally would, except instead of
                                   configuring it using

                                       [1m--with-samba[0m

                                   use

                                       [1m--with-libdsm=./libdsm[0m

                                   Test authentication again, this time using
                                   [1mdacsauth [22m(refer to [34m[1mdacsauth(1)[0m[1m[22m[56] and
                                   [34m[1mlocal_ntlm_authenticate[0m[1m[22m[57] for examples).

                                6. If you are satisfied with the results of
                                   your testing, complete your installation of
                                   [1mDACS [22mand verify that [34m[1mdacs_authenticate[0m[1m[22m[58]
                                   also works correctly. The only change you
                                   may need to make to dacs.conf is to specify

                                       OPTION 'SAMBA_PORT="0"'

                                   in the appropriate Auth clause. If you are
                                   using the standard ports, you may delete
                                   that option entirely since the library
                                   knows which port(s) to try.

                                7. Please report any problems so that they can
                                   be addressed in the next release.

                                   [1mSamba Notes[0m
                                   +o   This release of [1mDACS [22mhas been tested
                                       with samba-3.6.25 and that is the only
                                       version officially supported. If you
                                       use Samba, we strongly recommend that
                                       you use that version. It is not known
                                       whether this release of [1mDACS [22mwill work
                                       with any other version of [1mSamba[22m.

                                   +o   [1mDACS [22mrequires the [1mSamba [22msource
                                       distribution to be [4mbuilt[24m but it does
                                       not matter if [1mSamba [22mis [4minstalled[24m. The
                                       [1mDACS [22mbuild procedure looks for include
                                       files and libraries relative to the
                                       [1mSamba [22mdistribution's root directory.

                                   +o   On systems where libexecinfo has been
                                       installed (FreeBSD), when building [1mDACS[0m
                                       it may be necessary to add [1m-lexecinfo[0m
                                       to [4mLDFLAGS[24m if [1mbacktrace [22mor
                                       [1mbacktrace_symbols [22mare referenced by
                                       [1mSamba[22m.

                                   +o   The [1mSamba [22m4.X releases use a different
                                       build system than earlier releases,
                                       unfortunately.  [1mDACS [22mdoes not currently
                                       work with the 4.X releases, mainly
                                       because we have had no success getting
                                       a clean build of any 4.X release on
                                       either FreeBSD or macOS.

                                   +o   To build [1mSamba [22mfor [1mDACS[22m, from your
                                       [1mSamba [22mdistribution's ./source3
                                       directory do:

                                           % ./configure --enable-static=yes --with-ads=no --with-ldap=no --disable-swat --disable-cups --disable-pie \
                                                 --enable-external-libtalloc=no --enable-external-libtdb=no
                                           % make


                                   +o   Then, when configuring [1mDACS[22m, specify
                                       the directory where [1mSamba [22mwas unpacked,
                                       for example:

                                           --with-samba=/local/src/samba-3.6.25

                                   See the [1mDACS [22mconfigure arguments:
                                   [34m[1m--enable-ntlm-auth[0m[1m[22m[59], [34m[1m--with-samba[0m[1m[22m[60],
                                   and [34m[1m--with-libdsm[0m[1m[22m[61].

                                4. libxml2 and xmlsec1

                                   InfoCard support [4mis[24m [4mnow[24m [4mdeprecated[24m [4mand[0m
                                   [4mtherefore[24m [4mthese[24m [4mlibraries[24m [4mare[24m [4mno[24m [4mlonger[0m
                                   [4mneeded[24m. This section may be removed in a
                                   future release.

                                   See [34m[1mlocal_infocard_authenticate[0m[1m[22m[62].

                                   InfoCard support requires [34m[1mlibxml2[0m[1m[22m[63] and
                                   [34m[1mxmlsec1[0m[1m[22m[64] are required. Build libxml2 and
                                   [1mOpenSSL [22mfirst, because [34m[1mxmlsec1[0m[1m[22m[64] depends
                                   on both of them. This release of [1mDACS [22mhas
                                   been tested with libxml2-2.8.0 or
                                   libxml2-2.9.1, and xmlsec1-1.2.20, and we
                                   strongly recommend that you use those
                                   versions. It is not known whether this
                                   release of [1mDACS [22mwill work with any other
                                   versions - we do not officially support
                                   them.

                                       [1mNotes[0m
                                       +o   Here is how we built libxml2:

                                               % ./configure --prefix=/usr/local/libxml2-2.9.1

                                           Due to an apparent bug in the code
                                           (in threads.c) that results in a
                                           syntax error, it was necessary to
                                           add [1m--with-threads=no [22mon some
                                           platforms, such as macOS.

                                       +o   Here is how we built xmlsec1:

                                               % ./configure --prefix=/usr/local/xmlsec1-1.2.20
                                                   --with-libxml=/usr/local/libxml2-2.9.1
                                                   --with-openssl=/usr/local/openssl-1.0.2n --with-gnu-ld
                                                   --enable-static-linking  --disable-crypto-dl --disable-apps-crypto-dl

                                           Except on macOS:

                                               % ./configure --prefix=/usr/local/xmlsec1-1.2.20 \
                                                     --with-libxml=/usr/local/libxml2-2.9.1 --with-gnu-ld --enable-static=yes \
                                                     --enable-shared=yes --with-nss=/Applications/Firefox.app/Contents/MacOS \
                                                     --with-nspr=/Applications/Firefox.app/Contents/MacOS \
                                                     --with-openssl=/usr/local/openssl-1.0.2n \
                                                     --disable-crypto-dl


                                       +o   Due to an apparent error in its
                                           build procedure, we sometimes
                                           encountered the following error
                                           message:

                                               *** Warning: Linking the shared library libxmlsec1-openssl.la against the
                                               *** static library /local/openssl-1.0.2n/lib/libcrypto.a is not portable!

                                           After ensuring that libcrypto.so
                                           (or libcrypto.dylib) had been
                                           installed when building [1mOpenSSL[22m, to
                                           correct the xmlsec1 build problem
                                           we did "[1mmake clean[22m", re-ran
                                           [1mconfigure [22mas above, and edited
                                           src/openssl/Makefile under the root
                                           of the xmlsec1 distribution
                                           directory to change all occurrences
                                           of "libcrypto.a" to "libcrypto.so".
                                           It was sometimes also necessary to
                                           delete the -ldl flag on those same
                                           lines, and in other Makefile files
                                           in the distribution (and making
                                           sure the flag was not specified by
                                           xmlsec1-config). After those
                                           changes, we ran [1mmake [22magain.
                                           Additionally, it was sometimes
                                           necessary to specify
                                           CFLAGS="-I/usr/local/include
                                           -L/usr/local/lib".

                                       +o   Another problem related to this
                                           library on a CentOS platform
                                           resulted in an error message
                                           similar to this:

                                               Cannot restore segment prot after reloc: Permission denied

                                           The solution was to issue the
                                           command (adjust the path as
                                           necessary):

                                               % chcon -t texrel_shlib_t /usr/local/xmlsec1-1.2.20/lib/libxmlsec1-openssl.so


                                       +o   When including InfoCard support on
                                           macOS, it was necessary to tell the
                                           dynamic linker where to find the
                                           xmlsec1 library (despite using the
                                           [1m-rpath [22mflag during the build). To
                                           work around this, do something like
                                           the following (or equivalent):

                                               % setenv DYLD_LIBRARY_PATH /usr/local/xmlsec1-1.2.20/lib

                                           Ensure that "[1mgmake test[22m" does not
                                           fail.

                                       +o   Due to an apparent bug in
                                           configure.in, on FreeBSD [1mconfigure[0m
                                           may incorrectly use the [1m-ldl [22mflag
                                           in generated Makefiles. Either edit
                                           all Makefiles to remove all
                                           occurrences of the [1m-ldl [22mflag, or
                                           edit configure.in, add a
                                           "*-*-freebsd*" case like the others
                                           in the "OpenSSL" section, run
                                           [1mautoconf [22mto regenerate [1mconfigure[22m,
                                           and then "[1mmake clean[22m" and re-run
                                           [1mconfigure[22m.

                                       +o   Your experience may differ, but we
                                           found xmlsec1 to not cooperate when
                                           we wanted to work with multiple
                                           installations of libxml2 -
                                           apparently if a libxml2 directory
                                           or link has been installed, its
                                           build procedure seems to use that
                                           version, regardless of what is
                                           specified on the command line,
                                           requiring manual editing of its
                                           Makefiles. Check that the correct
                                           instance of [1mxml2-config [22mis being
                                           used. Unfortunately, it may be
                                           necessary to remove (or temporarily
                                           rename) older installed versions,
                                           or fall back to using an older
                                           version already installed on your
                                           system.

                                       +o   We also found it sometimes
                                           necessary to also upgrade the
                                           version of the libxslt library
                                           (also available [34m[1mhere[0m[1m[22m[65]) to build
                                           against the same libxml2 as xmlsec1
                                           library, otherwise multiple
                                           versions of libxml2 may be
                                           referenced, leading to undefined
                                           symbols during the [1mDACS [22mbuild
                                           procedure. We have had success
                                           using libxslt-1.1.28 (and then
                                           adding
                                           --with-libxslt=/usr/local/libxslt-1.1.28
                                           when configuring libxslt).
                                       The [1mDACS [22mbuild procedure uses
                                       [1mxmlsec1-config[22m, a program that comes
                                       with xmlsec1. If InfoCard support is
                                       enabled, the build procedure will look
                                       in some standard places for this
                                       command. You can specify its location
                                       with the [34m[1m--with-xmlsec1-config[0m[1m[22m[66]
                                       flag.

                                       See the [1mDACS [22mconfigure arguments:
                                       [34m[1m--enable-infocard-auth[0m[1m[22m[67] and
                                       [34m[1m--with-xmlsec1-config[0m[1m[22m[66]

                                    5. [1mOpenLDAP[0m

                                       Authentication through LDAP or
                                       Microsoft Active Directory (see
                                       [34m[1mlocal_ldap_authenticate[0m[1m[22m[68]) is
                                       implemented using [34m[1mOpenLDAP[0m[1m[22m[69]. This
                                       release of [1mDACS [22mhas been tested only
                                       with openldap-2.4.45 and we strongly
                                       recommend that you use that version.

                                       It is not known whether this release of
                                       [1mDACS [22mwill work with any other version
                                       of [1mOpenLDAP [22m- we do not support them.
                                       [1mDACS [22mmay work properly with [1mOpenLDAP[0m
                                       versions at least as old as 2.2.24, if
                                       you really must use one of them.

                                       [1mDACS [22mLDAP authentication and role
                                       retrieval is currently tested against
                                       directory services provided by Windows
                                       Server 2012 but [1mDACS [22mshould also
                                       interoperate with other LDAP
                                       implementations.

                                       If the [1m--with-ldap [22mflag is [4mnot[24m given
                                       (in which case LDAP authentication must
                                       be enabled; e.g., via
                                       [1m--enable-ldap-auth[22m), [1mconfigure [22mwill
                                       search for [1mOpenLDAP [22mheaders and
                                       libraries; if found, it will assume
                                       they are a suitable version and use
                                       them.

                                       If [1m--with-ldap [22mis given (either because
                                       [1mOpenLDAP [22mis not installed or an
                                       unsuitable version is installed),
                                       headers and libraries relative to the
                                       root of the specified directory will be
                                       used rather than any installed [1mOpenLDAP[0m
                                       files; it is not necessary to [4minstall[0m
                                       [1mOpenLDAP[22m, you only need to [4mbuild[24m it -
                                       so you do not need to be concerned
                                       about hassles associated with upgrading
                                       or any other versions that might
                                       already be installed on your system.

                                       To build [1mOpenLDAP [22mfor [1mDACS[22m, from the
                                       root of your [1mOpenLDAP [22mdistribution do:

                                           % ./configure --with-tls=openssl --disable-slapd --enable-static \
                                               CFLAGS=-I/usr/local/openssl-1.0.2n/include \
                                               LDFLAGS=-L/usr/local/openssl-1.0.2n/lib
                                           % make

                                       If so instructed, do a "[1mmake depend[22m"
                                       before the [1mmake[22m.

                                       See the [1mDACS [22mconfigure arguments:
                                       [34m[1m--enable-ldap-auth[0m[1m[22m[70] and
                                       [34m[1m--with-ldap[0m[1m[22m[71]

                                    6. Readline

                                       The history and editing functionality
                                       provided by the [34m[1mGNU Readline[0m
                                       [1m[34mLibrary[0m[1m[22m[72] is entirely optional but
                                       can be nice to have when using
                                       [34m[1mdacsexpr(1)[0m[1m[22m[73] interactively. This
                                       release of [1mDACS [22mhas been tested with
                                       version 7.0, although we have used
                                       readline-6.X with recent releases of
                                       [1mDACS[22m. Note that you may need to compile
                                       Readline with the [1m-fPIC [22mflag ("[1mmake[0m
                                       [1mCFLAGS=-fPIC[22m").

                                       It is not necessary for you to [4minstall[0m
                                       readline, you only need to [4mbuild[24m it -
                                       so you do not need to be concerned
                                       about hassles associated with upgrading
                                       or any other versions that might
                                       already be installed on your system. If
                                       readline/readline.h is in a standard
                                       include directory, it has probably been
                                       installed and no action is necessary.
                                       On platforms where it is missing, it
                                       may be simple to install using a
                                       command such as:

                                           # yum install readline-devel.x86_64

                                       or

                                           # pkg install readline


                                           [1mNotes[0m
                                           +o   When building on macOS, it was
                                               sometimes necessary to fix a
                                               bug by editing shlib/Makefile
                                               and making this change:

                                                   #SHOBJ_LDFLAGS = -dynamic
                                                   SHOBJ_LDFLAGS = -dynamiclib

                                           See the [1mDACS [22mconfigure arguments:
                                           [34m[1m--with-readline[0m[1m[22m[74]

                                    5. Configure and build [1mDACS [22mlibraries,
                                       services, commands, and utilities

                                       See [34m[1mBuild Options[0m[1m[22m[75] for build
                                       alternatives and options to [1mconfigure[22m.

                                           % cd src
                                           % ./configure
                                           % gmake

                                       To confirm that [1mDACS [22mhas been built
                                       with the third-party packages that you
                                       intended, from the run:

                                           % ./version -v

                                       You should ensure that the [1msslclient[0m
                                       utility is working correctly. From the
                                       src directory, you can test it using
                                       the following command:

                                           % printf "GET https://dacs.dss.ca:8443 HTTP/1.0\r\n\r\n" | ./sslclient dacs.dss.ca:443

                                       which should print the contents of
                                       [34m[1mhttps://dacs.dss.ca [0m[1m[22mto the standard
                                       output. You should repeat this test
                                       substituting the name of your server
                                       and port.

                                           [1mTip[0m
                                           After building [1mDACS[22m, it is strongly
                                           recommended that you run the
                                           self-tests (expression evaluation,
                                           crypto code, string handling, and
                                           so on) from the src directory:

                                               % gmake test

                                           If any error occurs during testing,
                                           testing will stop immediately and a
                                           message will be displayed. In this
                                           event, first check that you are
                                           using the recommended software
                                           packages and that your build flags
                                           are correct. Most often, problems
                                           are the result of mixing header
                                           files or library files from
                                           different versions of a third-party
                                           package (e.g., [1mOpenSSL[22m) or
                                           incorrect file permissions. If you
                                           cannot find anything wrong with
                                           your configuration, please submit a
                                           bug report that includes the self
                                           test output and describes your
                                           platform (you can include the
                                           output of "./version -v").

                                    6. If all looks good, install [1mDACS[0m

                                           % gmake install


                                           [1mNotes[0m
                                           +o   If [1mgmake [22mcomplains about not
                                               being able to find [1mxsltproc[22m,
                                               docbook.xsl, or something that
                                               might be related to installing
                                               the documentation, try:

                                                   % (cd ../man; gmake touch)
                                                   % gmake install


                                           +o   This will install the rules for
                                               the standard [1mDACS [22mweb services
                                               and run [34m[1mdacsacl(1)[0m[1m[22m[76] to
                                               create and install an index for
                                               them.

                                           +o   You can specify [34m[1mDESTDIR[0m[1m[22m[77] to
                                               [1mgmake [22mwhen installing or
                                               uninstalling:

                                                   % gmake DESTDIR=/tmp/mydacs install

                                           The installation process may prompt
                                           you for the owner name and group
                                           name to use for files and
                                           directories; it will guess at
                                           reasonable defaults for your
                                           platform. The appropriate responses
                                           will depend on local conventions,
                                           but to start with you might set the
                                           owner to your login name or root,
                                           and the group name to the same name
                                           that is used by [1mApache [22m(specified
                                           by the [34m[1mGroup[0m[1m[22m[78] directive in
                                           httpd.conf). For the group, it may
                                           help to look at /etc/group. If you
                                           need to change your owner or group
                                           selection, remove src/.ownername or
                                           src/.groupname and try again.

                                               [1mTip[0m
                                               While running "[1mgmake install[22m",
                                               important instructions
                                               regarding manual installation
                                               steps may be displayed. A copy
                                               is written to .build_notes,
                                               truncating any previous
                                               contents.

                                        7. As part of the installation
                                           procedure, the [1mDACS [22mmanual pages
                                           are copied into the [1mDACS [22mman
                                           directory (default:
                                           /usr/local/dacs/man). If you adjust
                                           your [1mMANPATH [22menvironment variable
                                           to include that directory, try:

                                               % man dacs

                                           While it is occasionally handy to
                                           view the manual pages using the [1mman[0m
                                           command, the HTML documentation is
                                           far superior.

                                        8. Build a [1mDACS[22m-enabled [1mhttpd[0m

                                           Please consult apache/README in the
                                           [1mDACS [22mdistribution for details and,
                                           from the apache directory, do:

                                               % gmake help


                                               [1mSecurity[0m
                                               You can build the [34m[1mmod_auth_dacs[0m
                                               [1m[34mmodule[0m[1m[22m[13] with a module
                                               identification string (a
                                               "version tag") with varying
                                               amounts of detail, or without a
                                               tag. For a full-length tag, use
                                               "[1mgmake tag[22m", for a simple tag
                                               use "[1mgmake smalltag[22m", or to
                                               disable the tag use "[1mgmake[0m
                                               [1mnotag[22m" or "[1mgmake module[22m". We
                                               suggest that you compile
                                               [1mmod_auth_dacs [22mwith a tag so
                                               that [1mApache's SERVER_SIGNATURE[0m
                                               and Server response header
                                               field can include [1mDACS [22mversion
                                               identification; this makes it
                                               easy to tell which version of
                                               [1mDACS [22mthe server is running and
                                               helps to detect mismatches. If
                                               [1mmod_auth_dacs [22mis compiled with
                                               debugging enabled or if the
                                               [34m[1mSetDACSAuthDebug[0m[1m[22m[79] directive
                                               enables debugging, additional
                                               version information is added to
                                               the tag. For production use,
                                               identifying the modules in your
                                               [1mApache [22mserver is considered by
                                               some to be a potential security
                                               weakness - you may reasonably
                                               choose not to include the
                                               version tag. For some versions
                                               of [1mApache[22m, module
                                               identification can be
                                               suppressed at runtime through
                                               its [34m[1mServerTokens[0m[1m[22m[80] directive.
                                           If you want [34m[1mmod_auth_dacs[0m[1m[22m[13] to be
                                           a dynamic module, which is
                                           recommended, do:

                                               % cd apache
                                               % gmake tag
                                               % gmake install

                                           Check that your httpd.conf has the
                                           appropriate LoadModule directive.

                                               [1mNotes[0m
                                               When installing [1mmod_auth_dacs[0m
                                               on some platforms (such as
                                               FreeBSD 10.0), messages similar
                                               to the following may be seen:

                                                   Warning!  dlname not found in /usr/local/apache2.2/modules/mod_auth_dacs.la.
                                                   Assuming installing a .so rather than a libtool archive.
                                                   chmod 755 /usr/local/apache2.2/modules/mod_auth_dacs.so
                                                   chmod: /usr/local/apache2.2/modules/mod_auth_dacs.so: No such file or directory
                                                   apxs:Error: Command failed with rc=65536

                                               In this situation you should
                                               notice that a shared library (a
                                               .so file) has not been created
                                               in the [1mApache [22mmodules
                                               directory. This problem is
                                               apparently caused by a buggy
                                               version of [1mlibtool [22mthat ships
                                               with [1mApache [22m(e.g.,
                                               /usr/local/apache2.2/apr-httpd/build-1/libtool)
                                               and is invoked by [1mapxs [22mby [1mgmake[0m
                                               [1minstall[22m. To work around this
                                               issue, edit the [1mapxs [22mcommand
                                               that is run from the Makefile
                                               in the [1mDACS [22mapache directory
                                               (e.g.,
                                               [1m/usr/local/apache2.2/bin/apxs[22m).
                                               Modify the [1mapxs [22mscript to
                                               execute the system's [1mlibtool[0m
                                               instead of [1mApache's[22m. This
                                               change will suffice, for
                                               example:

                                                   #my $libtool = `$apr_config --apr-libtool`;
                                                   my $libtool = "/usr/local/bin/libtool";

                                               After the change, repeat the
                                               [1mgmake install[22m. If this fails
                                               with the error message:

                                                   libtool: compile: unable to infer tagged configuration

                                               try:

                                                   my $libtool = "/usr/local/bin/libtool --tag=CC";
                                           If you want [34m[1mmod_auth_dacs[0m
                                           [1m[34mmodule[0m[1m[22m[13] to be a static module:

                                            1. Copy apache/mod_auth_dacs.c to
                                               [1mApache's [22mmodules/aaa directory

                                            2. Re-run [1mApache[22m's configure,
                                               adding [1mmod_auth_dacs[0m
                                               ([1m--with-module=aaa:auth_dacs[22m)

                                            3. Reinstall [1mApache[22m:

                                                   % make install


                                            4. Verify that [1mmod_auth_dacs[0m
                                               appears in the list of [1mApache[0m
                                               modules:

                                                   % httpd -l


                                                   [1mTip[0m
                                                   Because [34m[1mmod_auth_dacs[0m[1m[22m[13]
                                                   references symbols in
                                                   [1mmod_ssl[22m, apparently those
                                                   symbols must be loaded
                                                   [4mbefore[24m [1mmod_auth_dacs [22mis
                                                   loaded. This can be ensured
                                                   by statically compiling
                                                   [1mmod_ssl [22minto [1mhttpd[0m
                                                   (configure [1mhttpd [22mwith
                                                   [1m--enable-ssl [22mand verify
                                                   with "[1mhttpd -l[22m") and using
                                                   the following directive in
                                                   httpd.conf to dynamically
                                                   load the [1mmod_auth_dacs[0m
                                                   module:

                                                       LoadModule auth_dacs_module modules/mod_auth_dacs.so

                                                   Alternatively, it may be
                                                   sufficient to dynamically
                                                   load [1mmod_ssl [4m[22mbefore[0m
                                                   [1mmod_auth_dacs[22m.

                                                   If [1mmod_ssl [22msymbols are
                                                   unavailable when they are
                                                   needed, you'll probably see
                                                   a message like the
                                                   following when you try to
                                                   start [1mhttpd[22m:

                                                       mod_auth_dacs.so: undefined symbol: ssl_hook_Fixup
                                               After you've installed
                                               [1mmod_auth_dacs[22m, restart [1mhttpd[22m.

                                               If you built the module with a
                                               tag, verify that the [1mDACS[0m
                                               version identifier appears in
                                               [1mSERVER_SIGNATURE[22m. You can do
                                               this by hitting [1mApache's[0m
                                               [1mprintenv [22mCGI program from your
                                               browser or using a command
                                               like:

                                                   % dacshttp "http://[4mmyserver[24m:[4mmyserverport[24m/cgi-bin/printenv"

                                               (first making sure that
                                               [1mApache's printenv [22mCGI is
                                               executable) and examining the
                                               [1mSERVER_SIGNATURE [22menvironment
                                               variable, or by running:

                                                   % telnet [4mmyserver[24m [4mmyserverport[0m

                                               and typing:

                                                   OPTIONS * HTTP/1.0

                                               followed by a blank line and
                                               examining the Server response
                                               header.

                                                   [1mNote[0m
                                                   +o   The URLs that follow
                                                       will use http and omit
                                                       [4mmyserverport[24m.
                                                       Substitute https and/or
                                                       include [4mmyserverport[24m as
                                                       necessary for your
                                                       configuration.

                                                   +o   If you install a new
                                                       version of [1mDACS[22m, please
                                                       make sure that you use
                                                       the [1mmod_auth_dacs[0m
                                                       module that comes with
                                                       it. Follow the
                                                       instructions above.

                                            9. An assortment of [1mDACS [22mfiles,
                                               including HTML documentation
                                               and CSS files, are copied into
                                               the [1mDACS [22mwww directory
                                               (default: /usr/local/dacs/www).

                                               While you can view the
                                               documentation simply by
                                               pointing your web browser at
                                               the [1mDACS [22mwww directory, it is
                                               recommended that you make it
                                               available through [1mApache [22musing
                                               its [34m[1mAlias[0m[1m[22m[81] directive because
                                               the default site configuration
                                               (site.conf-std) expects
                                               handlers and DTDs to be
                                               available using certain URLs.

                                               Add lines like the following to
                                               your httpd.conf:

                                                   Alias /dacs      "/usr/local/dacs/www/"
                                                   Alias /css       "/usr/local/dacs/www/css/"
                                                   Alias /dtd-xsd   "/usr/local/dacs/www/dtd-xsd/"
                                                   Alias /examples  "/usr/local/dacs/www/examples/"
                                                   Alias /handlers  "/usr/local/dacs/www/handlers/"
                                                   Alias /infocards "/usr/local/dacs/www/infocards/"
                                                   Alias /man       "/usr/local/dacs/www/man/"
                                                   Alias /misc      "/usr/local/dacs/www/misc/"
                                                   Alias /mod       "/usr/local/dacs/www/mod/"

                                               To see the [1mDACS [22mDTD files from
                                               your browser, you can also add:

                                                   AddType text/plain      .dtd

                                               These .dtd files are only used
                                               to document XML structures and
                                               messages used by [1mDACS [22mand are
                                               cited in the documentation.

                                               You should also uncomment these
                                               two directives in your
                                               site.conf file:

                                                   XSD_BASE_URL "/dacs/dtd-xsd"
                                                   DTD_BASE_URL "/dacs/dtd-xsd"


                                                   [1mTip[0m
                                                   After restarting [1mhttpd[22m, you
                                                   can view the documentation
                                                   using a URL that looks like
                                                   http://[4mmyserver[24m/dacs/man or
                                                   simply http://[4mmyserver[24m/man.

                                           10. Access to all [1mDACS [22mweb services
                                               (everything installed in the
                                               .../cgi-bin/dacs directory)
                                               [4mmust[24m be controlled by [1mDACS[22m;
                                               that is, they must be
                                               "[1mDACS[22m-wrapped". Assuming you
                                               are following the defaults for
                                               installing [1mDACS[22m, these are the
                                               only files that are required to
                                               be [1mDACS[22m-wrapped.

                                               [1mDACS[22m-wrapping a resource or set
                                               of related resources involves:

                                               +o   Configuring [1mApache [22mso that
                                                   it uses [1mDACS [22mto manage
                                                   access to the contents of a
                                                   directory or portion of URL
                                                   space and

                                               +o   Configuring one or more
                                                   [1mDACS [22maccess control rules
                                                   for the jurisdiction
                                                   responsible for the
                                                   resources (this is done for
                                                   the [1mDACS [22mweb services by
                                                   the default ACLs).
                                                   Configuring [1mApache[0m
                                                   involves, at minimum,
                                                   adding directives like the
                                                   following to the
                                                   appropriate VirtualHost
                                                   section of httpd.conf:

                                                       AddDACSAuth dacs-acs /usr/local/dacs/bin/dacs_acs "-t -v"
                                                       SetDACSAuthMethod dacs-acs external
                                                       SetDACSAuthConf dacs-acs "/usr/local/dacs/dacs.conf"
                                                       <Location /cgi-bin/dacs>
                                                          AuthType DACS
                                                          AuthDACS dacs-acs
                                                          Require valid-user
                                                       # Note: For Apache 2.4, instead use:
                                                       # Require dacs-authz
                                                          Options ExecCGI
                                                       </Location>


                                                       [1mTip[0m
                                                       Remember to restart
                                                       [1mApache [22mafter making
                                                       changes to httpd.conf.
                                                   Some administrators may
                                                   choose to make [4mall[24m content
                                                   or [4mall[24m CGIs [1mDACS[22m-wrapped.
                                                   That is probably a more
                                                   secure approach, although
                                                   of course it can be
                                                   somewhat less efficient
                                                   than segmenting the
                                                   server's URL space into
                                                   "secure" and "insecure"
                                                   areas. Content that is not
                                                   [1mDACS[22m-wrapped is totally
                                                   oblivious to [1mDACS [22mand
                                                   incurs no overhead due to
                                                   [1mDACS[22m. Also, this approach
                                                   may necessitate making
                                                   "holes" in the URL space
                                                   for non-access controlled
                                                   resources, which must be
                                                   done with care.

                                                       [1mTip[0m
                                                       If you decide to
                                                       [1mDACS[22m-wrap everything,
                                                       you will likely want to
                                                       add rules to grant
                                                       access to various
                                                       public resources, such
                                                       as CSS files,
                                                       robots.txt,
                                                       favicon.ico, and
                                                       various public [1mDACS[0m
                                                       resources, such as its
                                                       man, dtd-xsd, etc.
                                                       directories (see the
                                                       instructions for the
                                                       Alias directive above).
                                                       The default ACL
                                                       acl-stddocs.0 does this
                                                       for some resources, but
                                                       you may need to extend
                                                       the list to grant
                                                       access to additional
                                                       public resources.

   [1mInitial Configuration[0m
           [1mTip[0m
           At this point, reviewing [34m[1mdacs.quick(7)[0m[1m[22m[11] is strongly recommended.
           It provides a detailed example of what needs to be done to make
           your [1mDACS [22moperational and how to do some basic testing. If you
           encounter problems installing or running [1mApache [22mor [1mDACS[22m, please
           refer to [34m[1mdacs.quick(7)[0m[1m[22m[11].

           [1mTip[0m
           The interactive [1mdacsinit [22mutility can perform the steps described
           below quickly. You will find [1mdacsinit [22min the installation bin
           directory. It can be run anytime after [1mDACS [22mhas been built and
           installed. It produces a directory structure for the federation,
           copies the distribution's site configuration file, creates a
           minimal dacs.conf for the federation and one jurisdiction, makes
           federation and jurisdiction encryption keys, and generates metadata
           for the jurisdiction. The resulting configuration can be used
           immediately by [1mDACS [22mcommands and by [1mDACS [22mweb services after [1mApache[0m
           has been configured for [1mDACS[22m.

           Passing the [1m-d [22mflag to [1mdacsinit [22mcauses it to append a string to
           certain paths and filenames so that, for debugging or test
           purposes, it is unlikely to overwrite any "real" configuration
           files. Passing it the [1m-n [22mflag causes it to display what it would do
           without performing any of the actions.

       Having installed [1mDACS[22m, the next major step is to do some initial
       configuration of your federation and jurisdiction(s). At each
       jurisdiction in your federation you will need to do the following:

        1. Install the default site configuration file. The distribution comes
           with a default site configuration file found in the distribution's
           conf/site.conf-std file. The installation procedure copies this
           file into the [1mDACS [22mfederations directory. After making a backup
           copy of any federations/site.conf file that is already there, copy
           federations/site.conf-std to federations/site.conf, applying any
           customizations you require (customizations are usually done in
           dacs.conf though, so that you can simply copy on top of the
           previous site.conf). Note that conf/site.conf-std may well change
           in a new release and you should use the latest version.

        2. As part of the installation procedure, a default set of access
           control rules is copied into the [1mDACS [22macls directory (default:
           /usr/local/dacs/acls). The default site.conf file (site.conf-std)
           configures [1mDACS [22mto look in that directory for the default rules.
           These rules control access to [1mDACS [22mweb services and are sufficient
           for proper operation.

               [1mTip[0m
               If your installed [1mDACS [22mweb services have a filename suffix
               (e.g., .cgi, you should probably build [1mDACS [22mwith an appropriate
               [1m--with-cgi-suffix [22mflag or customize the rules manually. If it
               is necessary to change the default rules, consider overriding
               them at the jurisdiction level instead of editing a default ACL
               file - this will make it easier for you to upgrade because you
               will not have to carry these changes forward to future releases
               of [1mDACS[22m.

               [1mSecurity[0m
               Access to some administrative and experimental [1mDACS [22mweb
               services is completely disabled or restricted by default;
               [4mchange[24m [4mthese[24m [4mwith[24m [4mcare[24m [4mand[24m [4mat[24m [4myour[24m [4mown[24m [4mrisk,[24m [4mparticularly[24m [4mif[0m
               [4myour[24m [4mweb[24m [4mserver[24m [4mis[24m [4mreachable[24m [4mfrom[24m [4mthe[24m [4mInternet[24m.

        3. Configure your dacs.conf file at each jurisdiction. At the very
           least, you must provide [34m[1mFEDERATION_DOMAIN[0m[1m[22m[82], [34m[1mFEDERATION_NAME[0m[1m[22m[83],
           and [34m[1mJURISDICTION_NAME[0m[1m[22m[84] directives; all other required directives
           will come from the site.conf file installed in an earlier step if
           you do not specify them.

        4. Use [34m[1mdacskey(1)[0m[1m[22m[85] to make encryption keys for the federation (if
           you are creating a new federation) or obtain a copy of the
           federation's encryption keys for each new jurisdiction (if you are
           joining an existing federation). Each jurisdiction in a federation
           must have a copy of the same federation keys.

        5. Use [34m[1mdacskey(1)[0m[1m[22m[85] to make encryption keys for each new
           jurisdiction (each jurisdiction will have different keys).

        6. Create a group definition that describes your jurisdictions - see
           [34m[1mdacs.groups(5)[0m[1m[22m[86] - and install an identical copy at each
           jurisdiction.

        7. Check ownership and permissions on [1mDACS [22mexecutables and data files.

               [1mSecurity[0m
               All access to [1mDACS [22mconfiguration files (dacs.conf, site.conf)
               and keys must be limited to the [1mDACS [22madministrator and the [1mDACS[0m
               CGI programs called by [1mApache[22m. The installation process tries
               to set this reasonably, but you should re-check now and after
               making changes because it is vital to maintain a secure system
               (e.g., ls -lR /usr/local/dacs).


   [1mInitial Testing[0m
       Having configured [1mApache [22mand [1mDACS[22m, you should try some basic [1mDACS [22mweb
       services to make sure that they are working properly before you go on
       to make customizations.

       For example, invoke [34m[1mdacs_version(8)[0m[1m[22m[20] from your browser to check that
       it is properly [1mDACS[22m-wrapped (adjust the URL for your environment):

           % dacshttp "http://[4mmyserver[24m/cgi-bin/dacs/dacs_version"

       Review the [1mDACS [22mlog files (default: /usr/local/dacs/logs/*) to see what
       happened. The [1mApache [22mlog files can also be helpful, as messages from
       [1mmod_auth_dacs [22mcan be found there if they have been enabled.

       You can also try [34m[1mdacsversion(1)[0m[1m[22m[87] from the command line.

       You should verify that [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[17] works properly.

           [1mSecurity[0m
           If your browser successfully retrieves a [1mDACS[22m-wrapped resource it
           may retain a copy in its cache. A later attempt to retrieve the
           same resource may appear to succeeed, because the cached copy is
           returned, even if the [1mDACS [22mconfiguration or other context has
           changed so that access to the resource should be denied. To ensure
           that [1mDACS [22mis handling every request when testing, always clear or
           disable your browser's cache before beginning. If a request is
           granted when you expect it to be denied, try the request again,
           making sure that your browser sends the request to the web server.

       The next step is to configure an authentication method - see
       [34m[1mdacs_authenticate(8)[0m[1m[22m[14] and try to authenticate. Once that appears to
       be working, you can try [34m[1mdacs_current_credentials(8)[0m[1m[22m[15],
       [34m[1mdacs_prenv(8)[0m[1m[22m[16], [34m[1mdacs_conf(8)[0m[1m[22m[18], and [34m[1mdacs_signout(8)[0m[1m[22m[19].

           [1mSecurity[0m
           Before deploying your [1mDACS[22m-enabled system, after an upgrade, or
           following configuration changes, always carefully test to ensure
           that resources are being protected as you require. It is best to
           configure and test [1mDACS [22mon a development platform that looks as
           much as possible like the intended production platform. When you
           are satisfied, a clone of the development platform can become the
           new production platform, which should also be tested.

   [1mBuild Options[0m
       Running [1mconfigure [22mgenerates config.nice (over-writing any previous
       contents), which can be executed at some later time if you want to
       re-run [1mconfigure [22mwith the same arguments.

           [1mTip[0m
           After you are happy with your configuration, consider squirrelling
           away a copy of config.nice in case you want to reconfigure [1mDACS [22mor
           for use with later releases of [1mDACS[22m.

       It is possible to "bundle" several of the [1mDACS [22mutility programs
       together into a single binary called [1mdacs[22m. This is similar to what
       [1mOpenSSL [22mdoes with its [1mopenssl [22mcommand. Instead of running:

           % dacsacl ...

       you would run:

           % dacs dacsacl ...

       Running [1mdacs [22mwithout arguments displays the list of built-in utilities.
       Some utilities have multiple names that are equivalent; these appear in
       a comma-separated list. To build this combined command, add the flag
       bundle=yes to command lines when building and installing:

           % gmake bundle=yes
           % gmake bundle=yes install

       The commands that are bundled into the [1mdacs [22mcommand won't be built as
       separate programs. To build and install both bundled and unbundled
       commands:

           % gmake bundle=both
           % gmake bundle=both install

       Command: gmake or "[1mgmake build[22m"
           This will build libraries, services, and utilities in the source
           directory. By default, the build process will create shared
           libraries and binaries if they are supported on your platform.

               [1mTip[0m
               If you encounter problems while building [1mDACS [22mwith shared
               libraries, use [1m--disabled-shared [22mand [1m--enable-static [22mwith
               [1mconfigure [22mand try building it again.

       Command: "[1mgmake install[22m"
           This will install all [1mDACS [22mcomponents. We recommend that everything
           other than CGI binaries be put under /usr/local/dacs, which is the
           default. The CGI binaries are by default installed in
           .../[4myour-apache-dir[24m/cgi-bin/dacs. By default, [1mDACS [22mutilities will
           be installed in /usr/local/dacs/bin, which you may want to put on
           your [1mPATH [22mfor convenience.

       Command: "[1mgmake clean[22m"
           Removes binaries, object files, and other junk in the build
           directory

       Command: "[1mgmake distclean[22m"
           Does a "[1mgmake clean[22m" and cleans up so that [1mconfigure [22mcan be
           re-done.

       Command: "[1mgmake extraclean[22m"
           Does a "[1mgmake distclean[22m" and removes configure. After this, do:

               % autoconf -I../include

           and then run [1mconfigure[22m.

       Command: "[1mgmake uninstall[22m"
           Removes installed binaries, include files, and libraries

       Other useful build commands (these should be self-explanatory):

           % gmake build-services
           % gmake build-progs
           % gmake build-static
           % gmake build-shared
           % gmake build-static-services
           % gmake build-shared-services
           % gmake build-static-progs
           % gmake build-shared-progs
           % gmake build-shared-lib
           % gmake install-libs
           % gmake install-shared-lib
           % gmake install-static-lib
           % gmake install-progs
           % gmake install-services

       [1mConfigure Options[0m
           To verify that this documentation is up-to-date, please run:

               % configure --help

           This will also tell you which features are enabled (or disabled) by
           default.  Standard build and install options.PP

           [1m--prefix=[4m[22mPREFIX[0m
               The root for the installation hierarchy [/usr/local/dacs],
               which is referred to as the symbol and variable [34m[1mDACS_HOME[0m[1m[22m[21].

           [1m--exec-prefix=[4m[22mEPREFIX[0m
               The root for the architecture-dependent hierarchy [[4mPREFIX[24m].

           [1m--bindir=[4m[22mDIR[0m
               Where [1mDACS [22mutilities are installed [[4mEPREFIX[24m/bin].

           [1m--libdir=[4m[22mDIR[0m
               Where [1mDACS [22mlibraries are installed [[4mEPREFIX[24m/lib].

           [1m--includedir=[4m[22mDIR[0m
               Where [1mDACS [22minclude files are installed [[4mEPREFIX[24m/include].

           [1m--mandir=[4m[22mDIR[0m
               Where [1mDACS [22mmanual pages are installed [[4mEPREFIX[24m/man].

           [1m--enable-shared[0m
               Generate shared libraries.

           [1m--enable-static[0m
               Generate static libraries.

           [1m--disable-prefix-check[0m
               Disable prefix path check; the prefix path check does some
               sanity tests on [4mPREFIX[24m.
           Feature selection options.PP

           [1m--enable-access-tokens[0m
               Compile with the authorization caching feature.

           [1m--enable-addons[0m
               Compile with optional [34m[1madd-on features[0m[1m[22m[88]; add-on source code
               files for the version of [1mDACS [22mbeing built must be present in
               the src directory.

           [1m--enable-all-auth[0m
               Enable all authentication methods; you can use this flag and
               then individually disable methods (e.g., [1m--enable-all-auth[0m
               [1m--disable-apache-auth [22mwould enable all methods except [1mApache[0m
               password authentication.

           [1m--enable-apache-auth[0m
               Enable [1mApache [22mpassword authentication directly through [1mDACS[22m.

           [1m--enable-bdb[0m
               Enable Berkeley DB support (default is yes); if you don't want
               it, use the [1m--disable-bdb [22mflag.

           [1m--enable-cas-auth[0m
               Enable CAS authentication.

           [1m--enable-cert-auth[0m
               Enable X.509 client certificate authentication.

           [1m--enable-dacs-conf[0m
               Specify default [1mDACS [22mconfig file.

           [1m--enable-dacs-log[0m
               Specify initial [1mDACS [22mlog file.

           [1m--enable-debug[0m
               Compile with debugging.

           [1m--enable-developer[0m
               Compile with development flags.

           [1m--enable-fts[0m
               Use the included [34m[1mfts(3)[0m[1m[22m[89] library.

           [1m--enable-grid-auth[0m
               Enable one-time password grid authentication.

           [1m--enable-hush-startup-logging[0m
               Enable suppression of informational log messages at startup.

           [1m--enable-infocard-auth[0m
               Enable InfoCard authentication and support. Deprecated.

           [1m--enable-java[0m
               Enable Java support.

           [1m--enable-ldap-auth[0m
               Enable LDAP authentication and roles.

           [1m--enable-local-roles[0m
               Enable private [1mDACS [22mroles module. (enabled by default)

           [1m--enable-native-auth[0m
               Enable authentication via [1mApache [22mmodules.

           [1m--enable-ndbm[0m
               Enable native Unix ndbm API support (this is often supplied by
               the Berkeley DB compatibility API).

           [1m--enable-ntlm-auth[0m
               Enable NTLM authentication.

           [1m--enable-pam-auth[0m
               Enable PAM authentication.

                   [1mImportant[0m
                   The PAM module should be considered experimental. Test it
                   carefully before production use.

           [1m--enable-passwd-auth[0m
               Enable DACS password-protected account authentication.

           [1m--enable-radius-auth[0m
               Enable RADIUS authentication.

           [1m--enable-rule-patterns[0m
               Enable extended URL patterns when matching a request against
               ACLs (this is an [34m[1madd-on feature[0m[1m[22m[88]).

           [1m--enable-simple-auth[0m
               Enable simple DACS account authentication.

           [1m--enable-sqlite[0m
               Enable SQLite support (default is no). If you don't want it,
               use the [1m--disable-sqlite [22mflag.

           [1m--enable-system-libradius[0m
               Link to the system libradius library (which must provide a
               BSD-style RADIUS client API). If RADIUS authentication is
               enabled and this flag is not given, the portable implementation
               of the library that is included with [1mDACS [22mis configured, built,
               and used as a [1mDACS [22mcomponent. Only BSD systems are likely to
               use this flag.

           [1m--enable-token-auth[0m
               Enable one-time password token authentication.

           [1m--enable-unix-roles[0m
               Enable Unix groups roles module (enabled by default on Unix
               platforms).

           [1m--enable-user-info[0m
               Compile with the user information reporting feature.
           Third-party support options.PP

           [1m--with-apache=[4m[22mDIR[0m
               Root [1mApache [22minstall directory; if [4mDIR[24m is "omit", however, a
               basic subset of [1mDACS [22mwill be installed ([34m[1malso see above[0m[1m[22m[90])
               (example: if [1mApache [22mfiles have been installed in
               /usr/local/apache2.2/include, /usr/local/apache2.2/conf, etc.,
               use [1m--with-apache[22m=/usr/local/apache2.2).

           [1m--with-apache-apr=[4m[22mDIR[0m
               Root [1mApache [22mAPR install directory; required only when [1mApache[0m
               2.2 or 2.4 are used (example:
               [1m--with-apache-apr[22m=/usr/local/apache2.2/apr-httpd).

           [1m--with-apache-apr-config=[4m[22mPATH[0m
               [1mApache [22mAPR configuration program; required only when [1mApache [22m2.2
               or 2.4 are used and the correct program is not on the search
               path; this flag may be required if the build system has more
               than one instance of [1mApache [22minstalled or if you have installed
               [1mApache [22min a non-standard location (example:
               [1m--with-apache-apr-config[22m=/usr/local/apache2.2/apr-httpd/bin/apr-1-config).

           [1m--with-apache-apr-cpp-defs=[4m[22mFLAGS[0m
               Preprocessor flags required when compiling files that include
               [1mApache [22mAPR code; may be required with some "non-standard" cases
               when [1mApache [22m2.2 or 2.4 are used and "[1mapr-1-config --cppflags[22m"
               is unavailable or does not report the correct flags (example:
               [1m--with-apache-apr-cpp-defs[22m=-D_LARGEFILE64_SOURCE).

                   [1mNote[0m
                   It has been reported that on some GNU/Linux platforms, such
                   as Ubuntu, it is necessary to define these symbols when
                   building [1mDACS [22mcode that includes APR header files (such as
                   [1mdacsversion[22m):

                       #define LINUX 2
                       #define _REENTRANT
                       #define _GNU_SOURCE
                       #define _LARGEFILE64_SOURCE

           [1m--with-apache-apr-includes=[4m[22mDIR[0m
               [1mApache [22mAPR include files directory; required with some
               "non-standard" cases when [1mApache [22m2.2 or 2.4 are used and
               [1mapr-1-config [22mis unavailable or does not report the correct
               directory (example:
               [1m--with-apache-apr-includes[22m=/usr/bin/include/apr-1.0).

           [1m--with-apache-apu-config=[4m[22mPATH[0m
               [1mApache [22mAPU configuration program; required only when [1mApache [22m2.2
               or 2.4 are used and the correct program is not on the search
               path; this flag may be required if the build system has more
               than one instance of [1mApache [22minstalled or if you have installed
               [1mApache [22min a non-standard location (example:
               [1m--with-apache-apu-config[22m=/usr/local/apache2.2/apr-util-httpd/bin/apu-1-config).

           [1m--with-apache-apu-includes=[4m[22mDIR[0m
               [1mApache [22mAPU include files directory; required with some
               "non-standard" cases when [1mApache [22m2.2 or 2.4 are used and
               [1mapu-1-config [22mis unavailable or does not report the correct
               directory (example:
               [1m--with-apache-apu-includes[22m=/usr/bin/include/apr-util-1.0).

           [1m--with-apxs=[4m[22mPATH[0m
               By default, the build procedure expects the [1mApache apxs [22mutility
               to be bin/apxs, relative to [1mApache's [22minstallation directory. On
               systems where this is incorrect, you must specifically
               configure the path for [1mapxs[22m. (example:
               [1m--with-apxs[22m=/usr/sbin/apxs2).

           [1m--with-bdb=[4m[22mDIR[0m
               Location of the root of the installed Berkeley DB libraries,
               include files, etc.; for example
               [1m--with-bdb[22m=/usr/local/db-5.3.28. This implies [1m--enable-bdb[22m.

           [1m--with-cgi-bin=[4m[22mDIR[0m
               Location of [1mApache [22mCGI files for [1mDACS [22mweb services. This will
               resolve to [4mDIR[24m/cgi-bin/dacs if it exists, or [4mDIR[24m/dacs if that
               exists, or [4mDIR[24m if its last component is "dacs".

           [1m--with-cgi-suffix=[4m[22mSUFFIX[0m
               When installing CGI executables, add [4mSUFFIX[24m as the file
               extension. A typical value for [4mSUFFIX[24m is ".cgi". The default
               access control rules for [1mDACS [22mweb services (via the VFS item
               type dacs_acls) respect this suffix. On Windows platforms,
               where ".exe" is the standard extension for programs, [4mSUFFIX[24m is
               set to that by default. Using a [4mSUFFIX[24m of "no" sets the
               extension to the null string.

           [1m--with-dacs-conf=[4m[22mPATH[0m
               Specify default [1mDACS [22mconfig file (default:
               [4mPREFIX[24m/federations/dacs.conf).

           [1m--with-dacs-log=[4m[22mPATH[0m
               Specify initial [1mDACS [22mlog file (default: [4mPREFIX[24m/logs/error_log).

           [1m--with-default-cipher-list=[4m[22mCIPHERSTRING[0m
               Specify a default [1mOpenSSL [22mcipher string specification (the
               argument to [34m[1mSSL_CTX_set_cipher_list()[0m[1m[22m[91]) to be used with
               [34m[1msslclient(1)[0m[1m[22m[92] and therefore by SSL/TLS connections internal
               to [1mDACS[22m. By default, these connections may use SSLv3 or TLS. By
               setting [4mCIPHERSTRING[24m appropriately, connections can be
               restricted to TLS, for instance. This is separate from any
               [1mApache [22mSSL/TLS configuration.

           [1m--with-expat=[4m[22mDIR[0m
               Root directory of installed [1mExpat [22mlibraries and include files.
               If Expat files have been installed in /usr/local/expat/include,
               /usr/local/expat/lib, etc., use [1m--with-expat[22m=/usr/local/expat.

           [1m--with-federations-root=[4m[22mDIR[0m
               Location of [1mDACS [22mfederations root directory (default:
               [4mPREFIX[24m/federations).

           [1m--with-gdbm-includes[22m=[4mDIR[0m
               Enable ndbm support using gdbm's compatibility API
               ([34m[1mgdbm(3)[0m[1m[22m[93]), specifying the include flags to use. (Example:
               [1m--with-gdbm-includes=-I/local/src/gdbm-1.13/include[22m). (CentOS
               Example: [1m--with-gdbm-includes=-I/usr/include/gdbm[22m).

           [1m--with-gdbm-lib[22m=[4mLIB[0m
               Enable ndbm support using gdbm's compatibility API
               ([34m[1mgdbm(3)[0m[1m[22m[93]), specifying the link flags to use, the pathname
               for the library, and any other necessary flags. (FreeBSD
               Example: [1m--with-gdbm-lib="-Wl,-rpath,/local/src/gdbm-1.13/lib[0m
               [1m-L/local/src/gdbm-1.13/lib -lgdbm"[22m). (CentOS Example:
               [1m--with-gdbm-lib="-L/usr/lib64 -lgdbm"[22m).

           [1m--with-htdocs=[4m[22mDIR[0m
               Location of [1mApache DACS [22mfiles if not the htdocs subdirectory of
               the [1mApache [22minstall directory.

           [1m--with-iconv=[4m[22mDIR[0m
               Path to parent of iconv installation. This flag may be required
               if you are enabling [1mSamba [22msupport.

           [1m--with-jdk-bin[0m
               If Java support is enabled, this identifies the directory
               containing the [1mjava[22m, [1mjavac[22m, [1mjavah[22m, and [1mjar [22mcommands. If this
               flag is absent, [1mconfigure [22mwill look for those programs using
               the current [1mPATH [22mvariable. (Example:
               [1m--with-jdk-bin=/usr/local/java/bin[22m).

           [1m--with-jdk-includes[0m
               If Java support is enabled, this is a list of one or more [1mGCC[0m
               include flags for JDK include directories (Example:
               [1m--with-jdk-includes="-I/usr/local/jdk/include[0m
               [1m-I/usr/local/jdk/include/freebsd"[22m).

           [1m--with-ldap=[4m[22mDIR[0m
               Location of [1mOpenLDAP [4m[22msource[24m files. This is the root directory
               for the OpenLDAP source distribution (Example:
               /local/src/openldap-2.4.45). This implies [1m--enable-ldap-auth[22m.

           [1m--with-libdsm=[4m[22mDIR[0m
               Location of the libdsm library (which will be used instead of
               Samba). This is the root directory of the library's source
               distribution. This option implies [1m--enable-ntlm-auth[22m, which may
               also appear explicitly, but is incompatible with [1m--with-samba[22m.

           [1m--with-mailer-prog=[4m[22mPATH[0m
               Location of a mailer program to use instead of [1msendmail[22m. This
               is only needed if email support is required. If
               [1m--with-mailer-args [22mis also specified, it will be used as the
               command line arguments. See [34m[1mdacsemail(1)[0m[1m[22m[94] for a description
               of how the mailer is expected to behave.

           [1m--with-mailer-args=[4m[22mSTRING[0m
               Command line arguments to use with the selected mailer program.
               This is only required if email support is required. See
               [34m[1mdacsemail(1)[0m[1m[22m[94] for a description of how the mailer is
               expected to behave.

           [1m--with-readline=[4m[22mLIB[0m
               Use [34m[1mGNU Readline[0m[1m[22m[72] when available. If [4mLIB[24m is given, it is the
               link flag to use or the pathname for the library (other flags
               may also be specified). (Example:
               [1m--with-readline="-Wl,-rpath,/local/src/readline-7.0/lib[0m
               [1m-L/local/src/readline-7.0/lib[0m
               [1m-I/local/src/readline-7.0/include"[22m).

           [1m--with-samba=[4m[22mDIR[0m
               Location of Samba [4msource[24m files. This is the root directory for
               the Samba source distribution (Example:
               /local/src/samba-3.6.25). This implies [1m--enable-ntlm-auth[22m.

           [1m--with-sendmail=[4m[22mPATH[0m
               Location of [34m[1msendmail(8)[0m[1m[22m[95]. This is only needed if email
               support is required and the location of the [1msendmail [22mcommand
               found at configuration time must be overridden. If
               [1m--with-mailer-args [22mis also specified, it will be used instead
               of the default [1msendmail [22mcommand line arguments. See
               [34m[1mdacsemail(1)[0m[1m[22m[94] for additional details.

           [1m--with-sqlite=[4m[22mDIR[0m
               Location of the root of the installed SQLite libraries, include
               files, etc.; for example
               [1m--with-sqlite[22m=/usr/local/sqlite-3.14.2. This implies
               [1m--enable-sqlite[22m.

           [1m--with-ssl=[4m[22mDIR[0m
               Location of the root of the installed [1mOpenSSL [22mlibraries and
               include files. If [1mOpenSSL [22mfiles have been installed in
               /usr/local/openssl/include, /usr/local/openssl/lib, etc., use
               [1m--with-expat[22m=/usr/local/openssl.

           [1m--with-xmlsec1-config=[4m[22mPATH[0m
               If the build procedure cannot find [1mxmlsec1-config[22m, or if it
               finds the wrong one, you can specify its location as [4mPATH[24m. This
               may only be required if InfoCard authentication has been
               enabled.

           To specify additional flags for compiling or linking [1mDACS[22m, set
           [4mCFLAGS[24m or [4mLDFLAGS[24m, respectively.

           To specify additional flags for compiling or linking the
           [34m[1mmod_auth_dacs module[0m[1m[22m[13], set [4mAPACHE_CFLAGS[24m or [4mAPACHE_LDFLAGS[24m,
           respectively. For example, this command will cause [1mmod_auth_dacs [22mto
           be built with the [1m-m64 [22mflag and [1mDACS [22mto be built with both the [1m-m64[0m
           flag and the [1m-O3 [22mflag:

               % ./configure "APACHE_CFLAGS=-m64" "CFLAGS=-O3 -m64" ...


[1mSEE ALSO[0m
       [34m[1mdacs(1)[0m[1m[22m[96], [34m[1mdacs.readme(7)[0m[1m[22m[12], [34m[1mdacs.quick(7)[0m[1m[22m[11]

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[97])

[1mCOPYING[0m
       Copyright (C) 2003-2018 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[98] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. gmake
           http://directory.fsf.org/project/make

        2. GCC
           http://gcc.gnu.org

        3. LLVM/Clang
           http://llvm.org

        4. Post-Release Notes
           http://dacs.dss.ca/download.html

        5. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        6. Xcode
           https://developer.apple.com/xcode

        7. Using Pluggable Authentication Modules (PAM)
           https://access.redhat.com/documentation/en-US/Red_Hat_Enterprise_Linux/6/html/Managing_Smart_Cards/Pluggable_Authentication_Modules.html

        8. ldconfig(8)
           https://www.freebsd.org/cgi/man.cgi?query=ldconfig&apropos=0&sektion=8&manpath=FreeBSD+10.3-RELEASE&format=html

        9. ldd(1)
           https://www.freebsd.org/cgi/man.cgi?query=ldd&apropos=0&sektion=1&manpath=FreeBSD+10.3-RELEASE&format=html

       10. Cygwin
           http://cygwin.com

       11. dacs.quick(7)
           http://dacs.dss.ca/man/dacs.quick.7.html

       12. dacs.readme(7)
           http://dacs.dss.ca/man/dacs.readme.7.html

       13. mod_auth_dacs module
           http://dacs.dss.ca/man/mod_auth_dacs.html

       14. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       15. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

       16. dacs_prenv(8)
           http://dacs.dss.ca/man/dacs_prenv.8.html

       17. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       18. dacs_conf(8)
           http://dacs.dss.ca/man/dacs_conf.8.html

       19. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

       20. dacs_version(8)
           http://dacs.dss.ca/man/dacs_version.8.html

       21. DACS_HOME
           http://dacs.dss.ca/man/dacs.conf.5.html#var_dacs_home

       22. configuration variable
           http://dacs.dss.ca/man/dacs.conf.5.html#config-vars

       23. man(1)
           https://www.freebsd.org/cgi/man.cgi?query=man&apropos=0&sektion=1&manpath=FreeBSD+10.3-RELEASE&format=html

       24. man/index.html
           http://dacs.dss.ca/man/index.html

       25. sudo(8)
           https://www.freebsd.org/cgi/man.cgi?query=sudo&apropos=0&sektion=8&manpath=FreeBSD+10.3-RELEASE&format=html

       26. Expat
           https://libexpat.github.io/

       27. OpenSSL
           http://www.openssl.org

       28. Apache
           http://httpd.apache.org

       29. above
           http://dacs.dss.ca/man/#install-openssl

       30. apr.apache.org
           http://apr.apache.org

       31. Third-party support options
           http://dacs.dss.ca/man/#third-party-support-options

       32. build Berkeley DB
           http://dacs.dss.ca/man/#dbm-databases

       33. FAQ
           http://dacs.dss.ca/man//faq.html

       34. Berkeley DB
           http://www.oracle.com/us/products/database/berkeley-db/overview/index.html

       35. Oracle Corporation
           http://www.oracle.com

       36. --enable-bdb
           http://dacs.dss.ca/man/#build_flag_--enable-bdb

       37. --disable-bdb
           http://dacs.dss.ca/man/#build_flag_--disable-bdb

       38. --with-bdb
           http://dacs.dss.ca/man/#build_flag_--with-bdb

       39. changed
           http://www.infoworld.com/article/2611450/open-source-software/oracle-switches-berkeley-db-license.html

       40. Sleepycat License
           http://opensource.org/licenses/Sleepycat

       41. GNU AGPL v3
           http://www.oracle.com/technetwork/products/berkeleydb/downloads/oslicense-093458.html

       42. ftp://ftp.gnu.org/gnu/gdbm
           ftp://ftp.gnu.org/gnu/gdbm/

       43. --enable-ndbm
           http://dacs.dss.ca/man/#build_flag_--enable-ndbm

       44. --with-gdbm-lib
           http://dacs.dss.ca/man/#build_flag_--with-gdbm-lib

       45. sdbm
           http://search.cpan.org/src/NWCLARK/perl-5.8.8/ext/SDBM_File/sdbm/README

       46. SQLite
           http://www.sqlite.org

       47. --enable-sqlite
           http://dacs.dss.ca/man/#build_flag_--enable-sqlite

       48. --disable-sqlite
           http://dacs.dss.ca/man/#build_flag_--disable-sqlite

       49. --with-sqlite
           http://dacs.dss.ca/man/#build_flag_--with-sqlite

       50. SMB
           https://en.wikipedia.org/wiki/Server_Message_Block

       51. NTLM
           https://en.wikipedia.org/wiki/NT_LAN_Manager

       52. local_ntlm_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ntlm_authenticate

       53. Samba
           http://www.samba.org

       54. libtasn1
           https://www.gnu.org/software/libtasn1

       55. libiconv
           https://www.gnu.org/software/libiconv

       56. dacsauth(1)
           https://dacs.dss.ca/man/dacsauth.1.html

       57. local_ntlm_authenticate
           https://dacs.dss.ca/man/dacs_authenticate.8.html#local_ntlm_authenticate

       58. dacs_authenticate
           https://dacs.dss.ca/man/dacs_authenticate.8.html

       59. --enable-ntlm-auth
           http://dacs.dss.ca/man/#build_flag_--enable-ntlm-auth

       60. --with-samba
           http://dacs.dss.ca/man/#build_flag_--with-samba

       61. --with-libdsm
           http://dacs.dss.ca/man/#build_flag_--with-libdsm

       62. local_infocard_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_infocard_authenticate

       63. libxml2
           http://xmlsoft.org

       64. xmlsec1
           http://www.aleksey.com/xmlsec

       65. here
           ftp://xmlsoft.org/libxslt/

       66. --with-xmlsec1-config
           http://dacs.dss.ca/man/#build_flag_--with-xmlsec1-config

       67. --enable-infocard-auth
           http://dacs.dss.ca/man/#build_flag_--enable-infocard-auth

       68. local_ldap_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_ldap_authenticate

       69. OpenLDAP
           http://www.openldap.org

       70. --enable-ldap-auth
           http://dacs.dss.ca/man/#build_flag_--enable-ldap-auth

       71. --with-ldap
           http://dacs.dss.ca/man/#build_flag_--with-ldap

       72. GNU Readline Library
           https://tiswww.case.edu/php/chet/readline/rltop.html

       73. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

       74. --with-readline
           http://dacs.dss.ca/man/#build_flag_--with-readline

       75. Build Options
           http://dacs.dss.ca/man/#build_options

       76. dacsacl(1)
           http://dacs.dss.ca/man/dacsacl.1.html

       77. DESTDIR
           http://www.gnu.org/prep/standards/standards.html#DESTDIR

       78. Group
           http://httpd.apache.org/docs/2.4/mod/mod_unixd.html#group

       79. SetDACSAuthDebug
           http://dacs.dss.ca/man/mod_auth_dacs.html#SetDACSAuthDebug

       80. ServerTokens
           http://httpd.apache.org/docs/current/mod/core.html#servertokens

       81. Alias
           http://httpd.apache.org/docs/2.4/mod/mod_alias.html#alias

       82. FEDERATION_DOMAIN
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_DOMAIN

       83. FEDERATION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_NAME

       84. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       85. dacskey(1)
           http://dacs.dss.ca/man/dacskey.1.html

       86. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html#dacs_metadata

       87. dacsversion(1)
           http://dacs.dss.ca/man/dacsversion.1.html

       88. add-on features
           http://dacs.dss.ca/man/dacs.readme.7.html#addons

       89. fts(3)
           https://www.freebsd.org/cgi/man.cgi?query=fts&apropos=0&sektion=3&manpath=FreeBSD+10.3-RELEASE&format=html

       90. also see above
           http://dacs.dss.ca/man/#building_subset

       91. [1mSSL_CTX_set_cipher_list()[0m
           http://www.openssl.org/docs/ssl/SSL_CTX_set_cipher_list.html

       92. sslclient(1)
           http://dacs.dss.ca/man/sslclient.1.html

       93. gdbm(3)
           http://directory.fsf.org/gdbm.html

       94. dacsemail(1)
           http://dacs.dss.ca/man/dacsemail.1.html

       95. sendmail(8)
           https://www.freebsd.org/cgi/man.cgi?query=sendmail&apropos=0&sektion=8&manpath=FreeBSD+10.3-RELEASE&format=html

       96. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

       97. www.dss.ca
           http://www.dss.ca

       98. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.40                       02/01/2018                   DACS.INSTALL(7)
