with Ada.Text_IO;

with D_Bus.Arguments.Basic;
with D_Bus.Arguments.Containers;
with D_Bus.Connection;

pragma Unreferenced (D_Bus.Arguments.Basic);
pragma Unreferenced (D_Bus.Arguments.Containers);

procedure List_Names
is
   use D_Bus;
   use D_Bus.Arguments.Basic;

   --  Connect to the D-Bus session bus

   Conn   : constant Connection.Connection_Type := Connection.Connect;
   Result : Arguments.Argument_List_Type;

   procedure Print (Argument : Arguments.Argument_Type'Class);
   --  Print out an argument.

   procedure Print (Argument : Arguments.Argument_Type'Class)
   is
   begin
      Ada.Text_IO.Set_Col (To => 1);
      Ada.Text_IO.Put ("(" & Argument.Get_Code'Img & " )");
      Ada.Text_IO.Set_Col (To => 10);
      Ada.Text_IO.Put_Line (Argument.To_String);
   end Print;

begin

   --  Request a name on the bus

   Connection.Request_Name
     (Connection => Conn,
      Name       => "dbus.ada.caller");

   --  Call a method on a remote object

   Result := Connection.Call_Blocking
     (Connection  => Conn,
      Destination => "org.freedesktop.DBus",
      Path        => "/",
      Iface       => "org.freedesktop.DBus",
      Method      => "ListNames");
   Ada.Text_IO.Put_Line ("Method called successfully:");

   Arguments.Iterate (List    => Result,
                      Process => Print'Access);
end List_Names;
