" Vim syntax file
" Language: DDTP files - server version
" Maintainer: Lorenzo Cappelletti <lorenzo.cappelletti@email.it>
" Last Change: Tue,  5 Aug 2003 19:46:14 +0200
"

" For copyright statement and stuff, see included file ddtpCom.vim



" Common definitions
runtime syntax/ddtpCom.vim


" Atomic description
syntax region ddtpSrvAtom	fold keepend transparent
	\ start=/^# \(Package(s)\|packages\|changed translation\|This package\)/
	\ end=/^# \(Package(s)\|packages\|changed translation\|This package\)/me=s-1
	\ contains=ddtpSrvHeader,ddtpSrvOr,@ddtpSrvXx

" Pseudo-header
syntax region ddtpSrvHeader	fold keepend transparent contained
	\ start=/^/
	\ end=/^Description: \|^# orignal description:/me=s-1
	\ contains=ddtpSrvHeaderKey,ddtpSrvCommServSect,ddtpSrvCommServOldDesc

syntax match  ddtpSrvHeaderKey	contained
	\ /^\(From\|BTSCLOSE\)[^:]*/
	\ nextgroup=ddtpComHeaderArg
syntax match  ddtpSrvHeaderKey	contained
	\ /^# \([Pp]ackage\|[Tt]ranslator\|Reviewer\|Bug\)[^:]*/hs=s+2
	\ nextgroup=ddtpComHeaderArg

" Original description
syntax region ddtpSrvOr		fold keepend transparent contained
	\ start=/^Description: \|^# origi\?nal description:/
	\ end=/^Description-\l\l\|^# new translation:\|^$/me=s-1
	\ contains=ddtpSrvOrSynp,ddtpSrvOrDesc,ddtpSrvCommServ

syntax match  ddtpSrvOrSynp	transparent contained
	\ /^Description: .*/
	\ contains=ddtpComSynpKey,ddtpComTodo,@ddtpComErrSynp	" Synopsis

syntax region ddtpSrvOrDesc 	fold keepend transparent contained
	\ start=/^[ #]\( origi\?nal description:\)\@!/
	\ end=/^$/
	\ contains=ddtpSrvOrPara,ddtpComDot			" Description

syntax region ddtpSrvOrPara	fold transparent contained
	\ start=/^[ #][^\.]/
	\ skip=/^#/
	\ end=/ \.$/me=e-2
	\ contains=@ddtpSrvComm,@ddtpComErrPara			" Paragraphs

" Generic translation
syntax region ddtpSrvXx		fold keepend transparent contained
	\ start=/^Description-\l\l\|^# new translation:/
	\ end=/^# \(Package(s)\|packages\|changed translation\|This package\)/me=s-1
	\ contains=ddtpSrvXxSynp,ddtpSrvXxDesc,ddtpSrvCommServ

syntax match  ddtpSrvXxSynp	transparent contained
	\ /^Description-\l\l\(_\u\u\)\?: .*/
	\ contains=ddtpComSynpKey,ddtpComTodo,@ddtpComErrSynp	" Synopsis

syntax region ddtpSrvXxDesc	fold keepend transparent contained
	\ start=/^[ #]\( new translation:\)\@!/
	\ end=/^$/
	\ contains=ddtpSrvXxPara,ddtpComDot			" Description

syntax region ddtpSrvXxPara	fold transparent contained
	\ start=/^[ #][^\.]/
	\ skip=/^#/
	\ end=/ \.$/me=e-2
	\ contains=@ddtpSrvComm,ddtpComTodo,@ddtpComErrPara	" Paragraph


" Comments
syntax cluster ddtpSrvComm contains=ddtpSrvCommPerm,ddtpSrvCommServ

syntax match  ddtpSrvCommPerm	contained
	\ /^##.*$/						" Permanent
syntax match  ddtpSrvCommServ	contained
	\ /^#[^#].*$\|^#$/
	\ contains=ddtpSrvCommServSect,ddtpSrvDiff		" Server

syntax match  ddtpSrvCommServSect	/^# changed translation from .*/hs=s+2
	\ contains=ddtpComEmail
	\ contained						" changed translation
syntax match  ddtpSrvCommServSect	/^# \(origi\?nal\|new\|old\|old translated\) description/hs=s+2
	\ contained						" Description
syntax match  ddtpSrvCommServSect	/^# \(new\|old\) translation/hs=s+2
	\ contained						" Translation
syntax match  ddtpSrvCommServSect	/^# ppart translation, please check it! It needs your help/hs=s+2
	\ contained						" PPart
syntax match  ddtpSrvCommServSect	/^# This package description has passed the review process/hs=s+2
	\ contained						" Passed review

" Old description
syntax region  ddtpSrvCommServOldDesc	fold keepend transparent contained
	\ start=/^# old description/hs=s+2
	\ end=/^ new description/me=s-1
	\ contains=ddtpSrvCommServSect,ddtpSrvDiff

" Diff
syntax region ddtpSrvDiff		fold keepend transparent contained
	\ start=/^# diff old-new \(translation\|description\):/
	\ end=/^# \(new description\|old translation\):/me=s-1
	\ contains=ddtpSrvDiffPrefix,ddtpSrvDiffHeader,ddtpSrvDiffText,ddtpSrvCommServSect,
		  \ddtpSrvDiffAdded,ddtpSrvDiffRemoved,ddtpSrvDiffLine,ddtpSrvDiffFile,
		  \ddtpSrvDiffNewFile
syntax match  ddtpSrvDiffPrefix		/^#/
	\ contained
syntax match  ddtpSrvDiffHeader		/^# diff old-new \(translation\|description\)/hs=s+2
	\ contained
syntax match  ddtpSrvDiffText		/.*/ms=s+2
	\ contained
syntax match  ddtpSrvDiffAdded		/ +.*/
	\ contained
syntax match  ddtpSrvDiffRemoved	/ -.*/
	\ contained
syntax match  ddtpSrvDiffLine		/ @.*/
	\ contained
syntax match  ddtpSrvDiffFile		/ +++ .*/
	\ contained
syntax match  ddtpSrvDiffNewFile	/ --- .*/
	\ contained


" Localized versions
runtime syntax/ddtpSrv??.vim
runtime syntax/ddtpSrv????.vim
syntax cluster ddtpSrvXx contains=ddtpSrv..


" Highlighting
highlight ddtpSrvCommServSect	ctermfg=Magenta
				\ guifg=Magenta

highlight def link ddtpSrvHeaderKey		ddtpComHeaderKey
highlight def link ddtpSrvCommServ		ddtpComCommServ
highlight def link ddtpSrvCommPerm		ddtpComCommPerm
highlight def link ddtpSrvDiffHeader		ddtpSrvCommServSect
highlight def link ddtpSrvDiffAdded		diffAdded
highlight def link ddtpSrvDiffRemoved		diffRemoved
highlight def link ddtpSrvDiffLine		diffLine
highlight def link ddtpSrvDiffFile		diffFile
highlight def link ddtpSrvDiffPrefix		ddtpSrvDiffFile
highlight def link ddtpSrvDiffNewFile		diffNewFile


" Folding
if !exists("ddtpSrv_nofolding")
  set foldmethod=syntax
  1,$foldopen!
endif

let b:current_syntax = "ddtpSrv"
