from mpl_toolkits.mplot3d import Axes3D
from matplotlib import cm
from matplotlib.colors import LogNorm
import matplotlib.pyplot as plt
import sys

try:
    import numpy as np
except:
    exit()


sys.path.append("../..")
from deap import benchmarks

#NUMMAX = 5
#A = 10 * np.random.rand(NUMMAX, 2)
#C = np.random.rand(NUMMAX)

A = [[0.5, 0.5], [0.25, 0.25], [0.25, 0.75], [0.75, 0.25], [0.75, 0.75]]
C = [0.002, 0.005, 0.005, 0.005, 0.005]

print A
print C

def shekel_arg0(sol):
    return benchmarks.shekel(sol, A, C)[0]

fig = plt.figure()
# ax = Axes3D(fig, azim = -29, elev = 50)
ax = Axes3D(fig)
X = np.arange(0, 1, 0.01)
Y = np.arange(0, 1, 0.01)
X, Y = np.meshgrid(X, Y)
Z = np.zeros(X.shape)

for i in xrange(X.shape[0]):
    for j in xrange(X.shape[1]):
        Z[i,j] = shekel_arg0((X[i,j],Y[i,j]))

ax.plot_surface(X, Y, Z, rstride = 1, cstride = 1,  norm = LogNorm(), cmap = cm.jet, linewidth=0.2, )
 
plt.xlabel("x")
plt.ylabel("y")

plt.show()