/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>
#include <gconf/gconf-client.h>
#include <libintl.h>
#include <glib.h>

#define _(message) dgettext(GETTEXT_PACKAGE_MODULE_GNOME, message)

void module_init()
{
	bindtextdomain(GETTEXT_PACKAGE_MODULE_GNOME, LOCALEDIR);
}

const gchar * module_get_gw_version()
{
	return VERSION;
}

const gchar * module_get_version()
{
	return VERSION_MODULE_GNOME;
}

const gchar * module_get_name()
{
	return _("Gnome");
}

const gchar * module_get_description()
{
	return _("This module enables Gnome-support.");
}

const gchar * module_get_author()
{
	return "Stefan Haller <haliner@googlemail.com>";
}

const gchar * module_get_homepage()
{
	return "http://launchpad.net/desktopnova";
}

void module_change_wallpaper(const gchar * filename)
{
	GConfClient * gconf_client = gconf_client_get_default();
	if (gconf_client != NULL)
	{
		gconf_client_set_string(gconf_client,
		                        "/desktop/gnome/background/picture_filename",
		                        filename, NULL);
		g_object_unref(gconf_client);
	}
}

#undef _
