#!/usr/bin/python3
"""
Module file handling for Fortran: tests

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

import dhfortran.module as mod
from click.testing import CliRunner
from pathlib import Path
import pytest

def test_detection_flang_21():
    if not Path("/usr/bin/flang-21").exists():
        return
    (cmplr, version) = mod.which_compiler_flavor_and_mod_version("modfiles/flang-21/points.mod")
    assert (cmplr,version) == ("flang","1")
    
def test_dh_fortran_mod_cmdline1():
    runner = CliRunner()
    result = runner.invoke(mod.dh_fortran_mod, ['debian/tmp/lib/points.mod'])
    assert result.exit_code == 0

def test_dh_fortran_mod():
    """ Install mod files. Normal case"""
    runner = CliRunner()
    result = runner.invoke(mod.dh_fortran_mod, [])
    assert result.exit_code == 0

    

@pytest.mark.skip
def test_which_compiler_gf14():
    if not Path("/usr/bin/gfortran-14").exists():
        return
    assert "gfortran-mod-15" == mod.which_compiler("modfiles/gfortran-14/points.mod")


@pytest.mark.skip
def test_which_compiler_gf15():
    if not Path("/usr/bin/gfortran-15").exists():
        return
    assert "gfortran-mod-16" == mod.which_compiler("modfiles/gfortran-15/points.mod")


@pytest.mark.skip
def test_which_compiler_fn18():
    if not Path("/usr/bin/flang-new-18").exists():
        return
    assert "flang-mod-1" == mod.which_compiler("modfiles/flang-new-18/points.mod")


@pytest.mark.skip
def test_which_compiler_fe18():
    if not Path("/usr/bin/flang-to-external-fc").exists():
        return
    # actual mod depends on gfortran external
    assert mod.which_compiler("modfiles/flang-ext-18/points.mod").startswith(
        "flangext-mod-"
    )


@pytest.mark.skip
def test_which_compiler_fn19():
    if not Path("/usr/bin/flang-new-19").exists():
        return
    assert "flang-mod-1" == mod.which_compiler("modfiles/flang-new-19/points.mod")


@pytest.mark.skip
def test_which_compiler_fn20():
    if not Path("/usr/bin/flang-new-20").exists():
        return
    assert "flang-mod-1" == mod.which_compiler("modfiles/flang-new-20/points.mod")


@pytest.mark.skip
def test_which_compiler_fn21():
    if not Path("/usr/bin/flang-new-21").exists():
        return
    assert "flang-mod-1" == mod.which_compiler("modfiles/flang-new-21/points.mod")


@pytest.mark.skip
def test_which_compiler_lfortran():
    if not Path("/usr/bin/lfortran").exists():
        return
    assert "lfortran-mod-0" == mod.which_compiler("modfiles/lfortran/points.mod")


if __name__ == "__main__":
    import pytest

    pytest.main()
