/*****************************************************************
|
|   Platinum - main
|
| Copyright (c) 2004-2010, Plutinosoft, LLC.
| All rights reserved.
| http://www.plutinosoft.com
|
| This program is free software; you can redistribute it and/or
| modify it under the terms of the GNU General Public License
| as published by the Free Software Foundation; either version 2
| of the License, or (at your option) any later version.
|
| OEMs, ISVs, VARs and other distributors that combine and
| distribute commercially licensed software with Platinum software
| and do not wish to distribute the source code for the commercially
| licensed software under version 2, or (at your option) any later
| version, of the GNU General Public License (the "GPL") must enter
| into a commercial license agreement with Plutinosoft, LLC.
| licensing@plutinosoft.com
|
| This program is distributed in the hope that it will be useful,
| but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
| GNU General Public License for more details.
|
| You should have received a copy of the GNU General Public License
| along with this program; see the file LICENSE.txt. If not, write to
| the Free Software Foundation, Inc.,
| 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
| http://www.gnu.org/licenses/gpl-2.0.html
|
****************************************************************/

/*----------------------------------------------------------------------
|   includes
+---------------------------------------------------------------------*/
#include "MediaCrawler.h"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

/*----------------------------------------------------------------------
|   main
+---------------------------------------------------------------------*/
int main(void)
{
    // setup Neptune logging
    NPT_LogManager::GetDefault().Configure("plist:.level=INFO;.handlers=ConsoleHandler;.ConsoleHandler.colors=off;.ConsoleHandler.filter=58");

    PLT_UPnP upnp;
    PLT_CtrlPointReference ctrlPoint(new PLT_CtrlPoint());
    upnp.AddCtrlPoint(ctrlPoint);

    CMediaCrawler* crawler =
        new CMediaCrawler(ctrlPoint,
                          "Sylvain: Platinum: Crawler");
    CPassThroughStreamHandler* handler =
        new CPassThroughStreamHandler(crawler);
    crawler->AddStreamHandler(handler);
    PLT_DeviceHostReference device(crawler);
    upnp.AddDevice(device);

    // make sure we ignore ourselves
    ctrlPoint->IgnoreUUID(device->GetUUID());

    upnp.Start();

    // extra broadcast discover
    ctrlPoint->Discover(NPT_HttpUrl("255.255.255.255", 1900, "*"), "upnp:rootdevice", 1);

    char buf[256];
    while (true) {
        fgets(buf, 256, stdin);
        if (*buf == 'q')
            break;
    }

    upnp.Stop();

    delete handler;
    return 0;
}
