/*
 * Copyright (c) 2018-2025 OARC, Inc.
 * All rights reserved.
 *
 * This file is part of dnsjit.
 *
 * dnsjit is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * dnsjit is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with dnsjit.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <dnsjit/core/log.h>
#include <dnsjit/core/object.h>

#ifndef __dnsjit_core_object_dns_h
#define __dnsjit_core_object_dns_h

#include <netinet/in.h>
#include <sys/types.h>

#include <dnsjit/core/object/dns.hh>

#define CORE_OBJECT_DNS_INIT(prev)                          \
    {                                                       \
        CORE_OBJECT_INIT(CORE_OBJECT_DNS, prev)             \
        ,                                                   \
            0, 0, 0, 0, 0,                                  \
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, \
    }

/*
 * 2016-12-09 https://www.iana.org/assignments/dns-parameters/dns-parameters.xhtml
 */

#define CORE_OBJECT_DNS_CLASS_IN 1
#define CORE_OBJECT_DNS_CLASS_CH 3
#define CORE_OBJECT_DNS_CLASS_HS 4
#define CORE_OBJECT_DNS_CLASS_NONE 254
#define CORE_OBJECT_DNS_CLASS_ANY 255

#define CORE_OBJECT_DNS_TYPE_A 1
#define CORE_OBJECT_DNS_TYPE_NS 2
#define CORE_OBJECT_DNS_TYPE_MD 3
#define CORE_OBJECT_DNS_TYPE_MF 4
#define CORE_OBJECT_DNS_TYPE_CNAME 5
#define CORE_OBJECT_DNS_TYPE_SOA 6
#define CORE_OBJECT_DNS_TYPE_MB 7
#define CORE_OBJECT_DNS_TYPE_MG 8
#define CORE_OBJECT_DNS_TYPE_MR 9
#define CORE_OBJECT_DNS_TYPE_NULL 10
#define CORE_OBJECT_DNS_TYPE_WKS 11
#define CORE_OBJECT_DNS_TYPE_PTR 12
#define CORE_OBJECT_DNS_TYPE_HINFO 13
#define CORE_OBJECT_DNS_TYPE_MINFO 14
#define CORE_OBJECT_DNS_TYPE_MX 15
#define CORE_OBJECT_DNS_TYPE_TXT 16
#define CORE_OBJECT_DNS_TYPE_RP 17
#define CORE_OBJECT_DNS_TYPE_AFSDB 18
#define CORE_OBJECT_DNS_TYPE_X25 19
#define CORE_OBJECT_DNS_TYPE_ISDN 20
#define CORE_OBJECT_DNS_TYPE_RT 21
#define CORE_OBJECT_DNS_TYPE_NSAP 22
#define CORE_OBJECT_DNS_TYPE_NSAP_PTR 23
#define CORE_OBJECT_DNS_TYPE_SIG 24
#define CORE_OBJECT_DNS_TYPE_KEY 25
#define CORE_OBJECT_DNS_TYPE_PX 26
#define CORE_OBJECT_DNS_TYPE_GPOS 27
#define CORE_OBJECT_DNS_TYPE_AAAA 28
#define CORE_OBJECT_DNS_TYPE_LOC 29
#define CORE_OBJECT_DNS_TYPE_NXT 30
#define CORE_OBJECT_DNS_TYPE_EID 31
#define CORE_OBJECT_DNS_TYPE_NIMLOC 32
#define CORE_OBJECT_DNS_TYPE_SRV 33
#define CORE_OBJECT_DNS_TYPE_ATMA 34
#define CORE_OBJECT_DNS_TYPE_NAPTR 35
#define CORE_OBJECT_DNS_TYPE_KX 36
#define CORE_OBJECT_DNS_TYPE_CERT 37
#define CORE_OBJECT_DNS_TYPE_A6 38
#define CORE_OBJECT_DNS_TYPE_DNAME 39
#define CORE_OBJECT_DNS_TYPE_SINK 40
#define CORE_OBJECT_DNS_TYPE_OPT 41
#define CORE_OBJECT_DNS_TYPE_APL 42
#define CORE_OBJECT_DNS_TYPE_DS 43
#define CORE_OBJECT_DNS_TYPE_SSHFP 44
#define CORE_OBJECT_DNS_TYPE_IPSECKEY 45
#define CORE_OBJECT_DNS_TYPE_RRSIG 46
#define CORE_OBJECT_DNS_TYPE_NSEC 47
#define CORE_OBJECT_DNS_TYPE_DNSKEY 48
#define CORE_OBJECT_DNS_TYPE_DHCID 49
#define CORE_OBJECT_DNS_TYPE_NSEC3 50
#define CORE_OBJECT_DNS_TYPE_NSEC3PARAM 51
#define CORE_OBJECT_DNS_TYPE_TLSA 52
#define CORE_OBJECT_DNS_TYPE_SMIMEA 53
#define CORE_OBJECT_DNS_TYPE_HIP 55
#define CORE_OBJECT_DNS_TYPE_NINFO 56
#define CORE_OBJECT_DNS_TYPE_RKEY 57
#define CORE_OBJECT_DNS_TYPE_TALINK 58
#define CORE_OBJECT_DNS_TYPE_CDS 59
#define CORE_OBJECT_DNS_TYPE_CDNSKEY 60
#define CORE_OBJECT_DNS_TYPE_OPENPGPKEY 61
#define CORE_OBJECT_DNS_TYPE_CSYNC 62
#define CORE_OBJECT_DNS_TYPE_SPF 99
#define CORE_OBJECT_DNS_TYPE_UINFO 100
#define CORE_OBJECT_DNS_TYPE_UID 101
#define CORE_OBJECT_DNS_TYPE_GID 102
#define CORE_OBJECT_DNS_TYPE_UNSPEC 103
#define CORE_OBJECT_DNS_TYPE_NID 104
#define CORE_OBJECT_DNS_TYPE_L32 105
#define CORE_OBJECT_DNS_TYPE_L64 106
#define CORE_OBJECT_DNS_TYPE_LP 107
#define CORE_OBJECT_DNS_TYPE_EUI48 108
#define CORE_OBJECT_DNS_TYPE_EUI64 109
#define CORE_OBJECT_DNS_TYPE_TKEY 249
#define CORE_OBJECT_DNS_TYPE_TSIG 250
#define CORE_OBJECT_DNS_TYPE_IXFR 251
#define CORE_OBJECT_DNS_TYPE_AXFR 252
#define CORE_OBJECT_DNS_TYPE_MAILB 253
#define CORE_OBJECT_DNS_TYPE_MAILA 254
#define CORE_OBJECT_DNS_TYPE_ANY 255
#define CORE_OBJECT_DNS_TYPE_URI 256
#define CORE_OBJECT_DNS_TYPE_CAA 257
#define CORE_OBJECT_DNS_TYPE_AVC 258
#define CORE_OBJECT_DNS_TYPE_TA 32768
#define CORE_OBJECT_DNS_TYPE_DLV 32769

#define CORE_OBJECT_DNS_OPCODE_QUERY 0
#define CORE_OBJECT_DNS_OPCODE_IQUERY 1
#define CORE_OBJECT_DNS_OPCODE_STATUS 2
#define CORE_OBJECT_DNS_OPCODE_NOTIFY 4
#define CORE_OBJECT_DNS_OPCODE_UPDATE 5

#define CORE_OBJECT_DNS_RCODE_NOERROR 0
#define CORE_OBJECT_DNS_RCODE_FORMERR 1
#define CORE_OBJECT_DNS_RCODE_SERVFAIL 2
#define CORE_OBJECT_DNS_RCODE_NXDOMAIN 3
#define CORE_OBJECT_DNS_RCODE_NOTIMP 4
#define CORE_OBJECT_DNS_RCODE_REFUSED 5
#define CORE_OBJECT_DNS_RCODE_YXDOMAIN 6
#define CORE_OBJECT_DNS_RCODE_YXRRSET 7
#define CORE_OBJECT_DNS_RCODE_NXRRSET 8
#define CORE_OBJECT_DNS_RCODE_NOTAUTH 9
#define CORE_OBJECT_DNS_RCODE_NOTZONE 10
#define CORE_OBJECT_DNS_RCODE_BADVERS 16
#define CORE_OBJECT_DNS_RCODE_BADSIG 16
#define CORE_OBJECT_DNS_RCODE_BADKEY 17
#define CORE_OBJECT_DNS_RCODE_BADTIME 18
#define CORE_OBJECT_DNS_RCODE_BADMODE 19
#define CORE_OBJECT_DNS_RCODE_BADNAME 20
#define CORE_OBJECT_DNS_RCODE_BADALG 21
#define CORE_OBJECT_DNS_RCODE_BADTRUNC 22
#define CORE_OBJECT_DNS_RCODE_BADCOOKIE 23

#define CORE_OBJECT_DNS_AFSDB_SUBTYPE_AFS3LOCSRV 1
#define CORE_OBJECT_DNS_AFSDB_SUBTYPE_DCENCA_ROOT 2

#define CORE_OBJECT_DNS_DHCID_TYPE_1OCTET 0
#define CORE_OBJECT_DNS_DHCID_TYPE_DATAOCTET 1
#define CORE_OBJECT_DNS_DHCID_TYPE_CLIENT_DUID 2

#define CORE_OBJECT_DNS_EDNS0_OPT_LLQ 1
#define CORE_OBJECT_DNS_EDNS0_OPT_UL 2
#define CORE_OBJECT_DNS_EDNS0_OPT_NSID 3
#define CORE_OBJECT_DNS_EDNS0_OPT_DAU 5
#define CORE_OBJECT_DNS_EDNS0_OPT_DHU 6
#define CORE_OBJECT_DNS_EDNS0_OPT_N3U 7
#define CORE_OBJECT_DNS_EDNS0_OPT_CLIENT_SUBNET 8
#define CORE_OBJECT_DNS_EDNS0_OPT_EXPIRE 9
#define CORE_OBJECT_DNS_EDNS0_OPT_COOKIE 10
#define CORE_OBJECT_DNS_EDNS0_OPT_TCP_KEEPALIVE 11
#define CORE_OBJECT_DNS_EDNS0_OPT_PADDING 12
#define CORE_OBJECT_DNS_EDNS0_OPT_CHAIN 13
#define CORE_OBJECT_DNS_EDNS0_OPT_DEVICEID 26946

#endif
